#include "edge-impulse-sdk/dsp/config.hpp"
#if EIDSP_LOAD_CMSIS_DSP_SOURCES
/* ----------------------------------------------------------------------
 * Project:      CMSIS DSP Library
 * Title:        arm_mve_tables_f16.c
 * Description:  common tables like fft twiddle factors, Bitreverse, reciprocal etc
 *               used for MVE implementation only
 *
 * @version  V1.10.0
 * @date     04 October 2021
 *
 * Target Processor: Cortex-M and Cortex-A cores
 * -------------------------------------------------------------------- */
/*
 * Copyright (C) 2010-2021 ARM Limited or its affiliates. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

 #include "edge-impulse-sdk/CMSIS/DSP/Include/arm_math_types_f16.h"

 
#if defined(ARM_FLOAT16_SUPPORTED)


#if defined(ARM_MATH_MVE_FLOAT16) && !defined(ARM_MATH_AUTOVECTORIZE)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES)

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_16) || defined(ARM_TABLE_TWIDDLECOEF_F16_32)

uint32_t rearranged_twiddle_tab_stride1_arr_16_f16[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_16_f16[2]={
0,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_16_f16[2]={
0,0,};

float16_t rearranged_twiddle_stride1_16_f16[8]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,};

float16_t rearranged_twiddle_stride2_16_f16[8]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,};

float16_t rearranged_twiddle_stride3_16_f16[8]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_64) || defined(ARM_TABLE_TWIDDLECOEF_F16_128)

uint32_t rearranged_twiddle_tab_stride1_arr_64_f16[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_64_f16[3]={
0,32,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_64_f16[3]={
0,32,0,};

float16_t rearranged_twiddle_stride1_64_f16[40]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,};

float16_t rearranged_twiddle_stride2_64_f16[40]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)-0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,};

float16_t rearranged_twiddle_stride3_64_f16[40]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9951171875000f,(float16_t)-0.0980224609375f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,
(float16_t)-0.7729492187500f,(float16_t)-0.6342773437500f,
(float16_t)-0.5556640625000f,(float16_t)-0.8315429687500f,
(float16_t)-0.2902832031250f,(float16_t)-0.9570312500000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_256) || defined(ARM_TABLE_TWIDDLECOEF_F16_512)

uint32_t rearranged_twiddle_tab_stride1_arr_256_f16[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_256_f16[4]={
0,128,160,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_256_f16[4]={
0,128,160,0,};

float16_t rearranged_twiddle_stride1_256_f16[168]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9995117187500f,(float16_t)0.0245361328125f,
(float16_t)0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9853515625000f,(float16_t)0.1710205078125f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9497070312500f,(float16_t)0.3137207031250f,
(float16_t)0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.8930664062500f,(float16_t)0.4497070312500f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8173828125000f,(float16_t)0.5756835937500f,
(float16_t)0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7241210937500f,(float16_t)0.6894531250000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.6152343750000f,(float16_t)0.7885742187500f,
(float16_t)0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.4929199218750f,(float16_t)0.8701171875000f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3598632812500f,(float16_t)0.9331054687500f,
(float16_t)0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.2191162109375f,(float16_t)0.9755859375000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0735473632812f,(float16_t)0.9970703125000f,
(float16_t)0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,};

float16_t rearranged_twiddle_stride2_256_f16[168]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)-0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)-0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)-0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)-0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)-0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)-0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)-0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)-0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)-0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)-0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)-0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)-0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)-0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)-0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)-0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)-0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)-0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)-0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)-0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)-0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,};

float16_t rearranged_twiddle_stride3_256_f16[168]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)-0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)-0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)-0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)-0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)-0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)-0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)-0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)-0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)-0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)-0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)-0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)-0.9995117187500f,(float16_t)-0.0245361328125f,
(float16_t)-0.9951171875000f,(float16_t)-0.0980224609375f,
(float16_t)-0.9853515625000f,(float16_t)-0.1710205078125f,
(float16_t)-0.9702148437500f,(float16_t)-0.2429199218750f,
(float16_t)-0.9497070312500f,(float16_t)-0.3137207031250f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,
(float16_t)-0.8930664062500f,(float16_t)-0.4497070312500f,
(float16_t)-0.8579101562500f,(float16_t)-0.5141601562500f,
(float16_t)-0.8173828125000f,(float16_t)-0.5756835937500f,
(float16_t)-0.7729492187500f,(float16_t)-0.6342773437500f,
(float16_t)-0.7241210937500f,(float16_t)-0.6894531250000f,
(float16_t)-0.6713867187500f,(float16_t)-0.7407226562500f,
(float16_t)-0.6152343750000f,(float16_t)-0.7885742187500f,
(float16_t)-0.5556640625000f,(float16_t)-0.8315429687500f,
(float16_t)-0.4929199218750f,(float16_t)-0.8701171875000f,
(float16_t)-0.4274902343750f,(float16_t)-0.9038085937500f,
(float16_t)-0.3598632812500f,(float16_t)-0.9331054687500f,
(float16_t)-0.2902832031250f,(float16_t)-0.9570312500000f,
(float16_t)-0.2191162109375f,(float16_t)-0.9755859375000f,
(float16_t)-0.1467285156250f,(float16_t)-0.9892578125000f,
(float16_t)-0.0735473632812f,(float16_t)-0.9970703125000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9951171875000f,(float16_t)-0.0980224609375f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,
(float16_t)-0.7729492187500f,(float16_t)-0.6342773437500f,
(float16_t)-0.5556640625000f,(float16_t)-0.8315429687500f,
(float16_t)-0.2902832031250f,(float16_t)-0.9570312500000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_1024) || defined(ARM_TABLE_TWIDDLECOEF_F16_2048)

uint32_t rearranged_twiddle_tab_stride1_arr_1024_f16[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_1024_f16[5]={
0,512,640,672,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_1024_f16[5]={
0,512,640,672,0,};

float16_t rearranged_twiddle_stride1_1024_f16[680]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0061340332031f,
(float16_t)1.0000000000000f,(float16_t)0.0122680664062f,
(float16_t)1.0000000000000f,(float16_t)0.0184020996094f,
(float16_t)0.9995117187500f,(float16_t)0.0245361328125f,
(float16_t)0.9995117187500f,(float16_t)0.0306701660156f,
(float16_t)0.9995117187500f,(float16_t)0.0368041992188f,
(float16_t)0.9990234375000f,(float16_t)0.0429382324219f,
(float16_t)0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)0.9985351562500f,(float16_t)0.0552062988281f,
(float16_t)0.9980468750000f,(float16_t)0.0613098144531f,
(float16_t)0.9975585937500f,(float16_t)0.0674438476562f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9965820312500f,(float16_t)0.0797119140625f,
(float16_t)0.9960937500000f,(float16_t)0.0858154296875f,
(float16_t)0.9956054687500f,(float16_t)0.0919189453125f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9946289062500f,(float16_t)0.1041259765625f,
(float16_t)0.9941406250000f,(float16_t)0.1102294921875f,
(float16_t)0.9931640625000f,(float16_t)0.1163330078125f,
(float16_t)0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)0.9916992187500f,(float16_t)0.1285400390625f,
(float16_t)0.9907226562500f,(float16_t)0.1345214843750f,
(float16_t)0.9902343750000f,(float16_t)0.1406250000000f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9882812500000f,(float16_t)0.1528320312500f,
(float16_t)0.9873046875000f,(float16_t)0.1588134765625f,
(float16_t)0.9863281250000f,(float16_t)0.1649169921875f,
(float16_t)0.9853515625000f,(float16_t)0.1710205078125f,
(float16_t)0.9843750000000f,(float16_t)0.1770019531250f,
(float16_t)0.9829101562500f,(float16_t)0.1829833984375f,
(float16_t)0.9819335937500f,(float16_t)0.1890869140625f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9794921875000f,(float16_t)0.2010498046875f,
(float16_t)0.9785156250000f,(float16_t)0.2071533203125f,
(float16_t)0.9770507812500f,(float16_t)0.2131347656250f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9741210937500f,(float16_t)0.2250976562500f,
(float16_t)0.9731445312500f,(float16_t)0.2310791015625f,
(float16_t)0.9716796875000f,(float16_t)0.2370605468750f,
(float16_t)0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)0.9687500000000f,(float16_t)0.2489013671875f,
(float16_t)0.9667968750000f,(float16_t)0.2548828125000f,
(float16_t)0.9653320312500f,(float16_t)0.2607421875000f,
(float16_t)0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)0.9619140625000f,(float16_t)0.2727050781250f,
(float16_t)0.9604492187500f,(float16_t)0.2785644531250f,
(float16_t)0.9584960937500f,(float16_t)0.2844238281250f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9550781250000f,(float16_t)0.2961425781250f,
(float16_t)0.9531250000000f,(float16_t)0.3020019531250f,
(float16_t)0.9516601562500f,(float16_t)0.3078613281250f,
(float16_t)0.9497070312500f,(float16_t)0.3137207031250f,
(float16_t)0.9477539062500f,(float16_t)0.3195800781250f,
(float16_t)0.9458007812500f,(float16_t)0.3251953125000f,
(float16_t)0.9433593750000f,(float16_t)0.3310546875000f,
(float16_t)0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)0.9394531250000f,(float16_t)0.3427734375000f,
(float16_t)0.9375000000000f,(float16_t)0.3483886718750f,
(float16_t)0.9350585937500f,(float16_t)0.3542480468750f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9306640625000f,(float16_t)0.3657226562500f,
(float16_t)0.9287109375000f,(float16_t)0.3713378906250f,
(float16_t)0.9262695312500f,(float16_t)0.3769531250000f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.9213867187500f,(float16_t)0.3884277343750f,
(float16_t)0.9189453125000f,(float16_t)0.3940429687500f,
(float16_t)0.9165039062500f,(float16_t)0.3996582031250f,
(float16_t)0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)0.9116210937500f,(float16_t)0.4108886718750f,
(float16_t)0.9091796875000f,(float16_t)0.4165039062500f,
(float16_t)0.9067382812500f,(float16_t)0.4221191406250f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.9013671875000f,(float16_t)0.4331054687500f,
(float16_t)0.8984375000000f,(float16_t)0.4387207031250f,
(float16_t)0.8959960937500f,(float16_t)0.4440917968750f,
(float16_t)0.8930664062500f,(float16_t)0.4497070312500f,
(float16_t)0.8906250000000f,(float16_t)0.4550781250000f,
(float16_t)0.8876953125000f,(float16_t)0.4604492187500f,
(float16_t)0.8847656250000f,(float16_t)0.4660644531250f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8789062500000f,(float16_t)0.4768066406250f,
(float16_t)0.8759765625000f,(float16_t)0.4821777343750f,
(float16_t)0.8730468750000f,(float16_t)0.4875488281250f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8671875000000f,(float16_t)0.4982910156250f,
(float16_t)0.8637695312500f,(float16_t)0.5034179687500f,
(float16_t)0.8608398437500f,(float16_t)0.5087890625000f,
(float16_t)0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)0.8544921875000f,(float16_t)0.5195312500000f,
(float16_t)0.8515625000000f,(float16_t)0.5244140625000f,
(float16_t)0.8481445312500f,(float16_t)0.5297851562500f,
(float16_t)0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)0.8417968750000f,(float16_t)0.5400390625000f,
(float16_t)0.8383789062500f,(float16_t)0.5454101562500f,
(float16_t)0.8349609375000f,(float16_t)0.5502929687500f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8281250000000f,(float16_t)0.5605468750000f,
(float16_t)0.8247070312500f,(float16_t)0.5659179687500f,
(float16_t)0.8212890625000f,(float16_t)0.5708007812500f,
(float16_t)0.8173828125000f,(float16_t)0.5756835937500f,
(float16_t)0.8139648437500f,(float16_t)0.5810546875000f,
(float16_t)0.8105468750000f,(float16_t)0.5859375000000f,
(float16_t)0.8066406250000f,(float16_t)0.5908203125000f,
(float16_t)0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)0.7993164062500f,(float16_t)0.6005859375000f,
(float16_t)0.7958984375000f,(float16_t)0.6054687500000f,
(float16_t)0.7919921875000f,(float16_t)0.6103515625000f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7846679687500f,(float16_t)0.6201171875000f,
(float16_t)0.7807617187500f,(float16_t)0.6250000000000f,
(float16_t)0.7768554687500f,(float16_t)0.6293945312500f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7690429687500f,(float16_t)0.6391601562500f,
(float16_t)0.7651367187500f,(float16_t)0.6440429687500f,
(float16_t)0.7612304687500f,(float16_t)0.6484375000000f,
(float16_t)0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)0.7534179687500f,(float16_t)0.6577148437500f,
(float16_t)0.7490234375000f,(float16_t)0.6625976562500f,
(float16_t)0.7451171875000f,(float16_t)0.6669921875000f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7368164062500f,(float16_t)0.6762695312500f,
(float16_t)0.7324218750000f,(float16_t)0.6806640625000f,
(float16_t)0.7285156250000f,(float16_t)0.6850585937500f,
(float16_t)0.7241210937500f,(float16_t)0.6894531250000f,
(float16_t)0.7202148437500f,(float16_t)0.6938476562500f,
(float16_t)0.7158203125000f,(float16_t)0.6982421875000f,
(float16_t)0.7114257812500f,(float16_t)0.7026367187500f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.7026367187500f,(float16_t)0.7114257812500f,
(float16_t)0.6982421875000f,(float16_t)0.7158203125000f,
(float16_t)0.6938476562500f,(float16_t)0.7202148437500f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6850585937500f,(float16_t)0.7285156250000f,
(float16_t)0.6806640625000f,(float16_t)0.7324218750000f,
(float16_t)0.6762695312500f,(float16_t)0.7368164062500f,
(float16_t)0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)0.6669921875000f,(float16_t)0.7451171875000f,
(float16_t)0.6625976562500f,(float16_t)0.7490234375000f,
(float16_t)0.6577148437500f,(float16_t)0.7534179687500f,
(float16_t)0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)0.6484375000000f,(float16_t)0.7612304687500f,
(float16_t)0.6440429687500f,(float16_t)0.7651367187500f,
(float16_t)0.6391601562500f,(float16_t)0.7690429687500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.6293945312500f,(float16_t)0.7768554687500f,
(float16_t)0.6250000000000f,(float16_t)0.7807617187500f,
(float16_t)0.6201171875000f,(float16_t)0.7846679687500f,
(float16_t)0.6152343750000f,(float16_t)0.7885742187500f,
(float16_t)0.6103515625000f,(float16_t)0.7919921875000f,
(float16_t)0.6054687500000f,(float16_t)0.7958984375000f,
(float16_t)0.6005859375000f,(float16_t)0.7993164062500f,
(float16_t)0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)0.5908203125000f,(float16_t)0.8066406250000f,
(float16_t)0.5859375000000f,(float16_t)0.8105468750000f,
(float16_t)0.5810546875000f,(float16_t)0.8139648437500f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5708007812500f,(float16_t)0.8212890625000f,
(float16_t)0.5659179687500f,(float16_t)0.8247070312500f,
(float16_t)0.5605468750000f,(float16_t)0.8281250000000f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.5502929687500f,(float16_t)0.8349609375000f,
(float16_t)0.5454101562500f,(float16_t)0.8383789062500f,
(float16_t)0.5400390625000f,(float16_t)0.8417968750000f,
(float16_t)0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)0.5297851562500f,(float16_t)0.8481445312500f,
(float16_t)0.5244140625000f,(float16_t)0.8515625000000f,
(float16_t)0.5195312500000f,(float16_t)0.8544921875000f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.5087890625000f,(float16_t)0.8608398437500f,
(float16_t)0.5034179687500f,(float16_t)0.8637695312500f,
(float16_t)0.4982910156250f,(float16_t)0.8671875000000f,
(float16_t)0.4929199218750f,(float16_t)0.8701171875000f,
(float16_t)0.4875488281250f,(float16_t)0.8730468750000f,
(float16_t)0.4821777343750f,(float16_t)0.8759765625000f,
(float16_t)0.4768066406250f,(float16_t)0.8789062500000f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.4660644531250f,(float16_t)0.8847656250000f,
(float16_t)0.4604492187500f,(float16_t)0.8876953125000f,
(float16_t)0.4550781250000f,(float16_t)0.8906250000000f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.4440917968750f,(float16_t)0.8959960937500f,
(float16_t)0.4387207031250f,(float16_t)0.8984375000000f,
(float16_t)0.4331054687500f,(float16_t)0.9013671875000f,
(float16_t)0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)0.4221191406250f,(float16_t)0.9067382812500f,
(float16_t)0.4165039062500f,(float16_t)0.9091796875000f,
(float16_t)0.4108886718750f,(float16_t)0.9116210937500f,
(float16_t)0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)0.3996582031250f,(float16_t)0.9165039062500f,
(float16_t)0.3940429687500f,(float16_t)0.9189453125000f,
(float16_t)0.3884277343750f,(float16_t)0.9213867187500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3769531250000f,(float16_t)0.9262695312500f,
(float16_t)0.3713378906250f,(float16_t)0.9287109375000f,
(float16_t)0.3657226562500f,(float16_t)0.9306640625000f,
(float16_t)0.3598632812500f,(float16_t)0.9331054687500f,
(float16_t)0.3542480468750f,(float16_t)0.9350585937500f,
(float16_t)0.3483886718750f,(float16_t)0.9375000000000f,
(float16_t)0.3427734375000f,(float16_t)0.9394531250000f,
(float16_t)0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)0.3310546875000f,(float16_t)0.9433593750000f,
(float16_t)0.3251953125000f,(float16_t)0.9458007812500f,
(float16_t)0.3195800781250f,(float16_t)0.9477539062500f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.3078613281250f,(float16_t)0.9516601562500f,
(float16_t)0.3020019531250f,(float16_t)0.9531250000000f,
(float16_t)0.2961425781250f,(float16_t)0.9550781250000f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.2844238281250f,(float16_t)0.9584960937500f,
(float16_t)0.2785644531250f,(float16_t)0.9604492187500f,
(float16_t)0.2727050781250f,(float16_t)0.9619140625000f,
(float16_t)0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)0.2607421875000f,(float16_t)0.9653320312500f,
(float16_t)0.2548828125000f,(float16_t)0.9667968750000f,
(float16_t)0.2489013671875f,(float16_t)0.9687500000000f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.2370605468750f,(float16_t)0.9716796875000f,
(float16_t)0.2310791015625f,(float16_t)0.9731445312500f,
(float16_t)0.2250976562500f,(float16_t)0.9741210937500f,
(float16_t)0.2191162109375f,(float16_t)0.9755859375000f,
(float16_t)0.2131347656250f,(float16_t)0.9770507812500f,
(float16_t)0.2071533203125f,(float16_t)0.9785156250000f,
(float16_t)0.2010498046875f,(float16_t)0.9794921875000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.1890869140625f,(float16_t)0.9819335937500f,
(float16_t)0.1829833984375f,(float16_t)0.9829101562500f,
(float16_t)0.1770019531250f,(float16_t)0.9843750000000f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.1649169921875f,(float16_t)0.9863281250000f,
(float16_t)0.1588134765625f,(float16_t)0.9873046875000f,
(float16_t)0.1528320312500f,(float16_t)0.9882812500000f,
(float16_t)0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)0.1406250000000f,(float16_t)0.9902343750000f,
(float16_t)0.1345214843750f,(float16_t)0.9907226562500f,
(float16_t)0.1285400390625f,(float16_t)0.9916992187500f,
(float16_t)0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)0.1163330078125f,(float16_t)0.9931640625000f,
(float16_t)0.1102294921875f,(float16_t)0.9941406250000f,
(float16_t)0.1041259765625f,(float16_t)0.9946289062500f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0919189453125f,(float16_t)0.9956054687500f,
(float16_t)0.0858154296875f,(float16_t)0.9960937500000f,
(float16_t)0.0797119140625f,(float16_t)0.9965820312500f,
(float16_t)0.0735473632812f,(float16_t)0.9970703125000f,
(float16_t)0.0674438476562f,(float16_t)0.9975585937500f,
(float16_t)0.0613098144531f,(float16_t)0.9980468750000f,
(float16_t)0.0552062988281f,(float16_t)0.9985351562500f,
(float16_t)0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)0.0429382324219f,(float16_t)0.9990234375000f,
(float16_t)0.0368041992188f,(float16_t)0.9995117187500f,
(float16_t)0.0306701660156f,(float16_t)0.9995117187500f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)0.0184020996094f,(float16_t)1.0000000000000f,
(float16_t)0.0122680664062f,(float16_t)1.0000000000000f,
(float16_t)0.0061340332031f,(float16_t)1.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9995117187500f,(float16_t)0.0245361328125f,
(float16_t)0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9853515625000f,(float16_t)0.1710205078125f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9497070312500f,(float16_t)0.3137207031250f,
(float16_t)0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.8930664062500f,(float16_t)0.4497070312500f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8173828125000f,(float16_t)0.5756835937500f,
(float16_t)0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7241210937500f,(float16_t)0.6894531250000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.6152343750000f,(float16_t)0.7885742187500f,
(float16_t)0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.4929199218750f,(float16_t)0.8701171875000f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3598632812500f,(float16_t)0.9331054687500f,
(float16_t)0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.2191162109375f,(float16_t)0.9755859375000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0735473632812f,(float16_t)0.9970703125000f,
(float16_t)0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,};

float16_t rearranged_twiddle_stride2_1024_f16[680]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0122680664062f,
(float16_t)0.9995117187500f,(float16_t)0.0245361328125f,
(float16_t)0.9995117187500f,(float16_t)0.0368041992188f,
(float16_t)0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)0.9980468750000f,(float16_t)0.0613098144531f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9960937500000f,(float16_t)0.0858154296875f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9941406250000f,(float16_t)0.1102294921875f,
(float16_t)0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)0.9907226562500f,(float16_t)0.1345214843750f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9873046875000f,(float16_t)0.1588134765625f,
(float16_t)0.9853515625000f,(float16_t)0.1710205078125f,
(float16_t)0.9829101562500f,(float16_t)0.1829833984375f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9785156250000f,(float16_t)0.2071533203125f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9731445312500f,(float16_t)0.2310791015625f,
(float16_t)0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)0.9667968750000f,(float16_t)0.2548828125000f,
(float16_t)0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)0.9604492187500f,(float16_t)0.2785644531250f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9531250000000f,(float16_t)0.3020019531250f,
(float16_t)0.9497070312500f,(float16_t)0.3137207031250f,
(float16_t)0.9458007812500f,(float16_t)0.3251953125000f,
(float16_t)0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)0.9375000000000f,(float16_t)0.3483886718750f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9287109375000f,(float16_t)0.3713378906250f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.9189453125000f,(float16_t)0.3940429687500f,
(float16_t)0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)0.9091796875000f,(float16_t)0.4165039062500f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.8984375000000f,(float16_t)0.4387207031250f,
(float16_t)0.8930664062500f,(float16_t)0.4497070312500f,
(float16_t)0.8876953125000f,(float16_t)0.4604492187500f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8759765625000f,(float16_t)0.4821777343750f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8637695312500f,(float16_t)0.5034179687500f,
(float16_t)0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)0.8515625000000f,(float16_t)0.5244140625000f,
(float16_t)0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)0.8383789062500f,(float16_t)0.5454101562500f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8247070312500f,(float16_t)0.5659179687500f,
(float16_t)0.8173828125000f,(float16_t)0.5756835937500f,
(float16_t)0.8105468750000f,(float16_t)0.5859375000000f,
(float16_t)0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)0.7958984375000f,(float16_t)0.6054687500000f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7807617187500f,(float16_t)0.6250000000000f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7651367187500f,(float16_t)0.6440429687500f,
(float16_t)0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)0.7490234375000f,(float16_t)0.6625976562500f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7324218750000f,(float16_t)0.6806640625000f,
(float16_t)0.7241210937500f,(float16_t)0.6894531250000f,
(float16_t)0.7158203125000f,(float16_t)0.6982421875000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.6982421875000f,(float16_t)0.7158203125000f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6806640625000f,(float16_t)0.7324218750000f,
(float16_t)0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)0.6625976562500f,(float16_t)0.7490234375000f,
(float16_t)0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)0.6440429687500f,(float16_t)0.7651367187500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.6250000000000f,(float16_t)0.7807617187500f,
(float16_t)0.6152343750000f,(float16_t)0.7885742187500f,
(float16_t)0.6054687500000f,(float16_t)0.7958984375000f,
(float16_t)0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)0.5859375000000f,(float16_t)0.8105468750000f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5659179687500f,(float16_t)0.8247070312500f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.5454101562500f,(float16_t)0.8383789062500f,
(float16_t)0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)0.5244140625000f,(float16_t)0.8515625000000f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.5034179687500f,(float16_t)0.8637695312500f,
(float16_t)0.4929199218750f,(float16_t)0.8701171875000f,
(float16_t)0.4821777343750f,(float16_t)0.8759765625000f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.4604492187500f,(float16_t)0.8876953125000f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.4387207031250f,(float16_t)0.8984375000000f,
(float16_t)0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)0.4165039062500f,(float16_t)0.9091796875000f,
(float16_t)0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)0.3940429687500f,(float16_t)0.9189453125000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3713378906250f,(float16_t)0.9287109375000f,
(float16_t)0.3598632812500f,(float16_t)0.9331054687500f,
(float16_t)0.3483886718750f,(float16_t)0.9375000000000f,
(float16_t)0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)0.3251953125000f,(float16_t)0.9458007812500f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.3020019531250f,(float16_t)0.9531250000000f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.2785644531250f,(float16_t)0.9604492187500f,
(float16_t)0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)0.2548828125000f,(float16_t)0.9667968750000f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.2310791015625f,(float16_t)0.9731445312500f,
(float16_t)0.2191162109375f,(float16_t)0.9755859375000f,
(float16_t)0.2071533203125f,(float16_t)0.9785156250000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.1829833984375f,(float16_t)0.9829101562500f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.1588134765625f,(float16_t)0.9873046875000f,
(float16_t)0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)0.1345214843750f,(float16_t)0.9907226562500f,
(float16_t)0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)0.1102294921875f,(float16_t)0.9941406250000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0858154296875f,(float16_t)0.9960937500000f,
(float16_t)0.0735473632812f,(float16_t)0.9970703125000f,
(float16_t)0.0613098144531f,(float16_t)0.9980468750000f,
(float16_t)0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)0.0368041992188f,(float16_t)0.9995117187500f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)0.0122680664062f,(float16_t)1.0000000000000f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.0122680664062f,(float16_t)1.0000000000000f,
(float16_t)-0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)-0.0368041992188f,(float16_t)0.9995117187500f,
(float16_t)-0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)-0.0613098144531f,(float16_t)0.9980468750000f,
(float16_t)-0.0735473632812f,(float16_t)0.9970703125000f,
(float16_t)-0.0858154296875f,(float16_t)0.9960937500000f,
(float16_t)-0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)-0.1102294921875f,(float16_t)0.9941406250000f,
(float16_t)-0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)-0.1345214843750f,(float16_t)0.9907226562500f,
(float16_t)-0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)-0.1588134765625f,(float16_t)0.9873046875000f,
(float16_t)-0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)-0.1829833984375f,(float16_t)0.9829101562500f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.2071533203125f,(float16_t)0.9785156250000f,
(float16_t)-0.2191162109375f,(float16_t)0.9755859375000f,
(float16_t)-0.2310791015625f,(float16_t)0.9731445312500f,
(float16_t)-0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)-0.2548828125000f,(float16_t)0.9667968750000f,
(float16_t)-0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)-0.2785644531250f,(float16_t)0.9604492187500f,
(float16_t)-0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)-0.3020019531250f,(float16_t)0.9531250000000f,
(float16_t)-0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)-0.3251953125000f,(float16_t)0.9458007812500f,
(float16_t)-0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)-0.3483886718750f,(float16_t)0.9375000000000f,
(float16_t)-0.3598632812500f,(float16_t)0.9331054687500f,
(float16_t)-0.3713378906250f,(float16_t)0.9287109375000f,
(float16_t)-0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.3940429687500f,(float16_t)0.9189453125000f,
(float16_t)-0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)-0.4165039062500f,(float16_t)0.9091796875000f,
(float16_t)-0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)-0.4387207031250f,(float16_t)0.8984375000000f,
(float16_t)-0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)-0.4604492187500f,(float16_t)0.8876953125000f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.4821777343750f,(float16_t)0.8759765625000f,
(float16_t)-0.4929199218750f,(float16_t)0.8701171875000f,
(float16_t)-0.5034179687500f,(float16_t)0.8637695312500f,
(float16_t)-0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)-0.5244140625000f,(float16_t)0.8515625000000f,
(float16_t)-0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)-0.5454101562500f,(float16_t)0.8383789062500f,
(float16_t)-0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)-0.5659179687500f,(float16_t)0.8247070312500f,
(float16_t)-0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)-0.5859375000000f,(float16_t)0.8105468750000f,
(float16_t)-0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)-0.6054687500000f,(float16_t)0.7958984375000f,
(float16_t)-0.6152343750000f,(float16_t)0.7885742187500f,
(float16_t)-0.6250000000000f,(float16_t)0.7807617187500f,
(float16_t)-0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)-0.6440429687500f,(float16_t)0.7651367187500f,
(float16_t)-0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)-0.6625976562500f,(float16_t)0.7490234375000f,
(float16_t)-0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)-0.6806640625000f,(float16_t)0.7324218750000f,
(float16_t)-0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)-0.6982421875000f,(float16_t)0.7158203125000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.7158203125000f,(float16_t)0.6982421875000f,
(float16_t)-0.7241210937500f,(float16_t)0.6894531250000f,
(float16_t)-0.7324218750000f,(float16_t)0.6806640625000f,
(float16_t)-0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)-0.7490234375000f,(float16_t)0.6625976562500f,
(float16_t)-0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)-0.7651367187500f,(float16_t)0.6440429687500f,
(float16_t)-0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)-0.7807617187500f,(float16_t)0.6250000000000f,
(float16_t)-0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)-0.7958984375000f,(float16_t)0.6054687500000f,
(float16_t)-0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)-0.8105468750000f,(float16_t)0.5859375000000f,
(float16_t)-0.8173828125000f,(float16_t)0.5756835937500f,
(float16_t)-0.8247070312500f,(float16_t)0.5659179687500f,
(float16_t)-0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)-0.8383789062500f,(float16_t)0.5454101562500f,
(float16_t)-0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)-0.8515625000000f,(float16_t)0.5244140625000f,
(float16_t)-0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)-0.8637695312500f,(float16_t)0.5034179687500f,
(float16_t)-0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)-0.8759765625000f,(float16_t)0.4821777343750f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.8876953125000f,(float16_t)0.4604492187500f,
(float16_t)-0.8930664062500f,(float16_t)0.4497070312500f,
(float16_t)-0.8984375000000f,(float16_t)0.4387207031250f,
(float16_t)-0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)-0.9091796875000f,(float16_t)0.4165039062500f,
(float16_t)-0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)-0.9189453125000f,(float16_t)0.3940429687500f,
(float16_t)-0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)-0.9287109375000f,(float16_t)0.3713378906250f,
(float16_t)-0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)-0.9375000000000f,(float16_t)0.3483886718750f,
(float16_t)-0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)-0.9458007812500f,(float16_t)0.3251953125000f,
(float16_t)-0.9497070312500f,(float16_t)0.3137207031250f,
(float16_t)-0.9531250000000f,(float16_t)0.3020019531250f,
(float16_t)-0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)-0.9604492187500f,(float16_t)0.2785644531250f,
(float16_t)-0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)-0.9667968750000f,(float16_t)0.2548828125000f,
(float16_t)-0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)-0.9731445312500f,(float16_t)0.2310791015625f,
(float16_t)-0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)-0.9785156250000f,(float16_t)0.2071533203125f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9829101562500f,(float16_t)0.1829833984375f,
(float16_t)-0.9853515625000f,(float16_t)0.1710205078125f,
(float16_t)-0.9873046875000f,(float16_t)0.1588134765625f,
(float16_t)-0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)-0.9907226562500f,(float16_t)0.1345214843750f,
(float16_t)-0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)-0.9941406250000f,(float16_t)0.1102294921875f,
(float16_t)-0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)-0.9960937500000f,(float16_t)0.0858154296875f,
(float16_t)-0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)-0.9980468750000f,(float16_t)0.0613098144531f,
(float16_t)-0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)-0.9995117187500f,(float16_t)0.0368041992188f,
(float16_t)-0.9995117187500f,(float16_t)0.0245361328125f,
(float16_t)-1.0000000000000f,(float16_t)0.0122680664062f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)-0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)-0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)-0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)-0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)-0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)-0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)-0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)-0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)-0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)-0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)-0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)-0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)-0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)-0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)-0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)-0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)-0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)-0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)-0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)-0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,};

float16_t rearranged_twiddle_stride3_1024_f16[680]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0184020996094f,
(float16_t)0.9995117187500f,(float16_t)0.0368041992188f,
(float16_t)0.9985351562500f,(float16_t)0.0552062988281f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9956054687500f,(float16_t)0.0919189453125f,
(float16_t)0.9941406250000f,(float16_t)0.1102294921875f,
(float16_t)0.9916992187500f,(float16_t)0.1285400390625f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9863281250000f,(float16_t)0.1649169921875f,
(float16_t)0.9829101562500f,(float16_t)0.1829833984375f,
(float16_t)0.9794921875000f,(float16_t)0.2010498046875f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9716796875000f,(float16_t)0.2370605468750f,
(float16_t)0.9667968750000f,(float16_t)0.2548828125000f,
(float16_t)0.9619140625000f,(float16_t)0.2727050781250f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9516601562500f,(float16_t)0.3078613281250f,
(float16_t)0.9458007812500f,(float16_t)0.3251953125000f,
(float16_t)0.9394531250000f,(float16_t)0.3427734375000f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9262695312500f,(float16_t)0.3769531250000f,
(float16_t)0.9189453125000f,(float16_t)0.3940429687500f,
(float16_t)0.9116210937500f,(float16_t)0.4108886718750f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.8959960937500f,(float16_t)0.4440917968750f,
(float16_t)0.8876953125000f,(float16_t)0.4604492187500f,
(float16_t)0.8789062500000f,(float16_t)0.4768066406250f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8608398437500f,(float16_t)0.5087890625000f,
(float16_t)0.8515625000000f,(float16_t)0.5244140625000f,
(float16_t)0.8417968750000f,(float16_t)0.5400390625000f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8212890625000f,(float16_t)0.5708007812500f,
(float16_t)0.8105468750000f,(float16_t)0.5859375000000f,
(float16_t)0.7993164062500f,(float16_t)0.6005859375000f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7768554687500f,(float16_t)0.6293945312500f,
(float16_t)0.7651367187500f,(float16_t)0.6440429687500f,
(float16_t)0.7534179687500f,(float16_t)0.6577148437500f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7285156250000f,(float16_t)0.6850585937500f,
(float16_t)0.7158203125000f,(float16_t)0.6982421875000f,
(float16_t)0.7026367187500f,(float16_t)0.7114257812500f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6762695312500f,(float16_t)0.7368164062500f,
(float16_t)0.6625976562500f,(float16_t)0.7490234375000f,
(float16_t)0.6484375000000f,(float16_t)0.7612304687500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.6201171875000f,(float16_t)0.7846679687500f,
(float16_t)0.6054687500000f,(float16_t)0.7958984375000f,
(float16_t)0.5908203125000f,(float16_t)0.8066406250000f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5605468750000f,(float16_t)0.8281250000000f,
(float16_t)0.5454101562500f,(float16_t)0.8383789062500f,
(float16_t)0.5297851562500f,(float16_t)0.8481445312500f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.4982910156250f,(float16_t)0.8671875000000f,
(float16_t)0.4821777343750f,(float16_t)0.8759765625000f,
(float16_t)0.4660644531250f,(float16_t)0.8847656250000f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.4331054687500f,(float16_t)0.9013671875000f,
(float16_t)0.4165039062500f,(float16_t)0.9091796875000f,
(float16_t)0.3996582031250f,(float16_t)0.9165039062500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3657226562500f,(float16_t)0.9306640625000f,
(float16_t)0.3483886718750f,(float16_t)0.9375000000000f,
(float16_t)0.3310546875000f,(float16_t)0.9433593750000f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.2961425781250f,(float16_t)0.9550781250000f,
(float16_t)0.2785644531250f,(float16_t)0.9604492187500f,
(float16_t)0.2607421875000f,(float16_t)0.9653320312500f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.2250976562500f,(float16_t)0.9741210937500f,
(float16_t)0.2071533203125f,(float16_t)0.9785156250000f,
(float16_t)0.1890869140625f,(float16_t)0.9819335937500f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.1528320312500f,(float16_t)0.9882812500000f,
(float16_t)0.1345214843750f,(float16_t)0.9907226562500f,
(float16_t)0.1163330078125f,(float16_t)0.9931640625000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0797119140625f,(float16_t)0.9965820312500f,
(float16_t)0.0613098144531f,(float16_t)0.9980468750000f,
(float16_t)0.0429382324219f,(float16_t)0.9990234375000f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)0.0061340332031f,(float16_t)1.0000000000000f,
(float16_t)-0.0122680664062f,(float16_t)1.0000000000000f,
(float16_t)-0.0306701660156f,(float16_t)0.9995117187500f,
(float16_t)-0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)-0.0674438476562f,(float16_t)0.9975585937500f,
(float16_t)-0.0858154296875f,(float16_t)0.9960937500000f,
(float16_t)-0.1041259765625f,(float16_t)0.9946289062500f,
(float16_t)-0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)-0.1406250000000f,(float16_t)0.9902343750000f,
(float16_t)-0.1588134765625f,(float16_t)0.9873046875000f,
(float16_t)-0.1770019531250f,(float16_t)0.9843750000000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.2131347656250f,(float16_t)0.9770507812500f,
(float16_t)-0.2310791015625f,(float16_t)0.9731445312500f,
(float16_t)-0.2489013671875f,(float16_t)0.9687500000000f,
(float16_t)-0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)-0.2844238281250f,(float16_t)0.9584960937500f,
(float16_t)-0.3020019531250f,(float16_t)0.9531250000000f,
(float16_t)-0.3195800781250f,(float16_t)0.9477539062500f,
(float16_t)-0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)-0.3542480468750f,(float16_t)0.9350585937500f,
(float16_t)-0.3713378906250f,(float16_t)0.9287109375000f,
(float16_t)-0.3884277343750f,(float16_t)0.9213867187500f,
(float16_t)-0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)-0.4221191406250f,(float16_t)0.9067382812500f,
(float16_t)-0.4387207031250f,(float16_t)0.8984375000000f,
(float16_t)-0.4550781250000f,(float16_t)0.8906250000000f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.4875488281250f,(float16_t)0.8730468750000f,
(float16_t)-0.5034179687500f,(float16_t)0.8637695312500f,
(float16_t)-0.5195312500000f,(float16_t)0.8544921875000f,
(float16_t)-0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)-0.5502929687500f,(float16_t)0.8349609375000f,
(float16_t)-0.5659179687500f,(float16_t)0.8247070312500f,
(float16_t)-0.5810546875000f,(float16_t)0.8139648437500f,
(float16_t)-0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)-0.6103515625000f,(float16_t)0.7919921875000f,
(float16_t)-0.6250000000000f,(float16_t)0.7807617187500f,
(float16_t)-0.6391601562500f,(float16_t)0.7690429687500f,
(float16_t)-0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)-0.6669921875000f,(float16_t)0.7451171875000f,
(float16_t)-0.6806640625000f,(float16_t)0.7324218750000f,
(float16_t)-0.6938476562500f,(float16_t)0.7202148437500f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.7202148437500f,(float16_t)0.6938476562500f,
(float16_t)-0.7324218750000f,(float16_t)0.6806640625000f,
(float16_t)-0.7451171875000f,(float16_t)0.6669921875000f,
(float16_t)-0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)-0.7690429687500f,(float16_t)0.6391601562500f,
(float16_t)-0.7807617187500f,(float16_t)0.6250000000000f,
(float16_t)-0.7919921875000f,(float16_t)0.6103515625000f,
(float16_t)-0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)-0.8139648437500f,(float16_t)0.5810546875000f,
(float16_t)-0.8247070312500f,(float16_t)0.5659179687500f,
(float16_t)-0.8349609375000f,(float16_t)0.5502929687500f,
(float16_t)-0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)-0.8544921875000f,(float16_t)0.5195312500000f,
(float16_t)-0.8637695312500f,(float16_t)0.5034179687500f,
(float16_t)-0.8730468750000f,(float16_t)0.4875488281250f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.8906250000000f,(float16_t)0.4550781250000f,
(float16_t)-0.8984375000000f,(float16_t)0.4387207031250f,
(float16_t)-0.9067382812500f,(float16_t)0.4221191406250f,
(float16_t)-0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)-0.9213867187500f,(float16_t)0.3884277343750f,
(float16_t)-0.9287109375000f,(float16_t)0.3713378906250f,
(float16_t)-0.9350585937500f,(float16_t)0.3542480468750f,
(float16_t)-0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)-0.9477539062500f,(float16_t)0.3195800781250f,
(float16_t)-0.9531250000000f,(float16_t)0.3020019531250f,
(float16_t)-0.9584960937500f,(float16_t)0.2844238281250f,
(float16_t)-0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)-0.9687500000000f,(float16_t)0.2489013671875f,
(float16_t)-0.9731445312500f,(float16_t)0.2310791015625f,
(float16_t)-0.9770507812500f,(float16_t)0.2131347656250f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9843750000000f,(float16_t)0.1770019531250f,
(float16_t)-0.9873046875000f,(float16_t)0.1588134765625f,
(float16_t)-0.9902343750000f,(float16_t)0.1406250000000f,
(float16_t)-0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)-0.9946289062500f,(float16_t)0.1041259765625f,
(float16_t)-0.9960937500000f,(float16_t)0.0858154296875f,
(float16_t)-0.9975585937500f,(float16_t)0.0674438476562f,
(float16_t)-0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)-0.9995117187500f,(float16_t)0.0306701660156f,
(float16_t)-1.0000000000000f,(float16_t)0.0122680664062f,
(float16_t)-1.0000000000000f,(float16_t)-0.0061340332031f,
(float16_t)-0.9995117187500f,(float16_t)-0.0245361328125f,
(float16_t)-0.9990234375000f,(float16_t)-0.0429382324219f,
(float16_t)-0.9980468750000f,(float16_t)-0.0613098144531f,
(float16_t)-0.9965820312500f,(float16_t)-0.0797119140625f,
(float16_t)-0.9951171875000f,(float16_t)-0.0980224609375f,
(float16_t)-0.9931640625000f,(float16_t)-0.1163330078125f,
(float16_t)-0.9907226562500f,(float16_t)-0.1345214843750f,
(float16_t)-0.9882812500000f,(float16_t)-0.1528320312500f,
(float16_t)-0.9853515625000f,(float16_t)-0.1710205078125f,
(float16_t)-0.9819335937500f,(float16_t)-0.1890869140625f,
(float16_t)-0.9785156250000f,(float16_t)-0.2071533203125f,
(float16_t)-0.9741210937500f,(float16_t)-0.2250976562500f,
(float16_t)-0.9702148437500f,(float16_t)-0.2429199218750f,
(float16_t)-0.9653320312500f,(float16_t)-0.2607421875000f,
(float16_t)-0.9604492187500f,(float16_t)-0.2785644531250f,
(float16_t)-0.9550781250000f,(float16_t)-0.2961425781250f,
(float16_t)-0.9497070312500f,(float16_t)-0.3137207031250f,
(float16_t)-0.9433593750000f,(float16_t)-0.3310546875000f,
(float16_t)-0.9375000000000f,(float16_t)-0.3483886718750f,
(float16_t)-0.9306640625000f,(float16_t)-0.3657226562500f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,
(float16_t)-0.9165039062500f,(float16_t)-0.3996582031250f,
(float16_t)-0.9091796875000f,(float16_t)-0.4165039062500f,
(float16_t)-0.9013671875000f,(float16_t)-0.4331054687500f,
(float16_t)-0.8930664062500f,(float16_t)-0.4497070312500f,
(float16_t)-0.8847656250000f,(float16_t)-0.4660644531250f,
(float16_t)-0.8759765625000f,(float16_t)-0.4821777343750f,
(float16_t)-0.8671875000000f,(float16_t)-0.4982910156250f,
(float16_t)-0.8579101562500f,(float16_t)-0.5141601562500f,
(float16_t)-0.8481445312500f,(float16_t)-0.5297851562500f,
(float16_t)-0.8383789062500f,(float16_t)-0.5454101562500f,
(float16_t)-0.8281250000000f,(float16_t)-0.5605468750000f,
(float16_t)-0.8173828125000f,(float16_t)-0.5756835937500f,
(float16_t)-0.8066406250000f,(float16_t)-0.5908203125000f,
(float16_t)-0.7958984375000f,(float16_t)-0.6054687500000f,
(float16_t)-0.7846679687500f,(float16_t)-0.6201171875000f,
(float16_t)-0.7729492187500f,(float16_t)-0.6342773437500f,
(float16_t)-0.7612304687500f,(float16_t)-0.6484375000000f,
(float16_t)-0.7490234375000f,(float16_t)-0.6625976562500f,
(float16_t)-0.7368164062500f,(float16_t)-0.6762695312500f,
(float16_t)-0.7241210937500f,(float16_t)-0.6894531250000f,
(float16_t)-0.7114257812500f,(float16_t)-0.7026367187500f,
(float16_t)-0.6982421875000f,(float16_t)-0.7158203125000f,
(float16_t)-0.6850585937500f,(float16_t)-0.7285156250000f,
(float16_t)-0.6713867187500f,(float16_t)-0.7407226562500f,
(float16_t)-0.6577148437500f,(float16_t)-0.7534179687500f,
(float16_t)-0.6440429687500f,(float16_t)-0.7651367187500f,
(float16_t)-0.6293945312500f,(float16_t)-0.7768554687500f,
(float16_t)-0.6152343750000f,(float16_t)-0.7885742187500f,
(float16_t)-0.6005859375000f,(float16_t)-0.7993164062500f,
(float16_t)-0.5859375000000f,(float16_t)-0.8105468750000f,
(float16_t)-0.5708007812500f,(float16_t)-0.8212890625000f,
(float16_t)-0.5556640625000f,(float16_t)-0.8315429687500f,
(float16_t)-0.5400390625000f,(float16_t)-0.8417968750000f,
(float16_t)-0.5244140625000f,(float16_t)-0.8515625000000f,
(float16_t)-0.5087890625000f,(float16_t)-0.8608398437500f,
(float16_t)-0.4929199218750f,(float16_t)-0.8701171875000f,
(float16_t)-0.4768066406250f,(float16_t)-0.8789062500000f,
(float16_t)-0.4604492187500f,(float16_t)-0.8876953125000f,
(float16_t)-0.4440917968750f,(float16_t)-0.8959960937500f,
(float16_t)-0.4274902343750f,(float16_t)-0.9038085937500f,
(float16_t)-0.4108886718750f,(float16_t)-0.9116210937500f,
(float16_t)-0.3940429687500f,(float16_t)-0.9189453125000f,
(float16_t)-0.3769531250000f,(float16_t)-0.9262695312500f,
(float16_t)-0.3598632812500f,(float16_t)-0.9331054687500f,
(float16_t)-0.3427734375000f,(float16_t)-0.9394531250000f,
(float16_t)-0.3251953125000f,(float16_t)-0.9458007812500f,
(float16_t)-0.3078613281250f,(float16_t)-0.9516601562500f,
(float16_t)-0.2902832031250f,(float16_t)-0.9570312500000f,
(float16_t)-0.2727050781250f,(float16_t)-0.9619140625000f,
(float16_t)-0.2548828125000f,(float16_t)-0.9667968750000f,
(float16_t)-0.2370605468750f,(float16_t)-0.9716796875000f,
(float16_t)-0.2191162109375f,(float16_t)-0.9755859375000f,
(float16_t)-0.2010498046875f,(float16_t)-0.9794921875000f,
(float16_t)-0.1829833984375f,(float16_t)-0.9829101562500f,
(float16_t)-0.1649169921875f,(float16_t)-0.9863281250000f,
(float16_t)-0.1467285156250f,(float16_t)-0.9892578125000f,
(float16_t)-0.1285400390625f,(float16_t)-0.9916992187500f,
(float16_t)-0.1102294921875f,(float16_t)-0.9941406250000f,
(float16_t)-0.0919189453125f,(float16_t)-0.9956054687500f,
(float16_t)-0.0735473632812f,(float16_t)-0.9970703125000f,
(float16_t)-0.0552062988281f,(float16_t)-0.9985351562500f,
(float16_t)-0.0368041992188f,(float16_t)-0.9995117187500f,
(float16_t)-0.0184020996094f,(float16_t)-1.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)-0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)-0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)-0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)-0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)-0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)-0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)-0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)-0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)-0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)-0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)-0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)-0.9995117187500f,(float16_t)-0.0245361328125f,
(float16_t)-0.9951171875000f,(float16_t)-0.0980224609375f,
(float16_t)-0.9853515625000f,(float16_t)-0.1710205078125f,
(float16_t)-0.9702148437500f,(float16_t)-0.2429199218750f,
(float16_t)-0.9497070312500f,(float16_t)-0.3137207031250f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,
(float16_t)-0.8930664062500f,(float16_t)-0.4497070312500f,
(float16_t)-0.8579101562500f,(float16_t)-0.5141601562500f,
(float16_t)-0.8173828125000f,(float16_t)-0.5756835937500f,
(float16_t)-0.7729492187500f,(float16_t)-0.6342773437500f,
(float16_t)-0.7241210937500f,(float16_t)-0.6894531250000f,
(float16_t)-0.6713867187500f,(float16_t)-0.7407226562500f,
(float16_t)-0.6152343750000f,(float16_t)-0.7885742187500f,
(float16_t)-0.5556640625000f,(float16_t)-0.8315429687500f,
(float16_t)-0.4929199218750f,(float16_t)-0.8701171875000f,
(float16_t)-0.4274902343750f,(float16_t)-0.9038085937500f,
(float16_t)-0.3598632812500f,(float16_t)-0.9331054687500f,
(float16_t)-0.2902832031250f,(float16_t)-0.9570312500000f,
(float16_t)-0.2191162109375f,(float16_t)-0.9755859375000f,
(float16_t)-0.1467285156250f,(float16_t)-0.9892578125000f,
(float16_t)-0.0735473632812f,(float16_t)-0.9970703125000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9951171875000f,(float16_t)-0.0980224609375f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,
(float16_t)-0.7729492187500f,(float16_t)-0.6342773437500f,
(float16_t)-0.5556640625000f,(float16_t)-0.8315429687500f,
(float16_t)-0.2902832031250f,(float16_t)-0.9570312500000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,};

#endif

#if !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_ALL_FFT_TABLES) || defined(ARM_TABLE_TWIDDLECOEF_F16_4096) || defined(ARM_TABLE_TWIDDLECOEF_F16_8192)

uint32_t rearranged_twiddle_tab_stride1_arr_4096_f16[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride2_arr_4096_f16[6]={
0,2048,2560,2688,2720,0,};

uint32_t rearranged_twiddle_tab_stride3_arr_4096_f16[6]={
0,2048,2560,2688,2720,0,};

float16_t rearranged_twiddle_stride1_4096_f16[2728]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0015335083008f,
(float16_t)1.0000000000000f,(float16_t)0.0030670166016f,
(float16_t)1.0000000000000f,(float16_t)0.0046005249023f,
(float16_t)1.0000000000000f,(float16_t)0.0061340332031f,
(float16_t)1.0000000000000f,(float16_t)0.0076713562012f,
(float16_t)1.0000000000000f,(float16_t)0.0092010498047f,
(float16_t)1.0000000000000f,(float16_t)0.0107345581055f,
(float16_t)1.0000000000000f,(float16_t)0.0122680664062f,
(float16_t)1.0000000000000f,(float16_t)0.0138015747070f,
(float16_t)1.0000000000000f,(float16_t)0.0153427124023f,
(float16_t)1.0000000000000f,(float16_t)0.0168762207031f,
(float16_t)1.0000000000000f,(float16_t)0.0184020996094f,
(float16_t)1.0000000000000f,(float16_t)0.0199432373047f,
(float16_t)1.0000000000000f,(float16_t)0.0214691162109f,
(float16_t)0.9995117187500f,(float16_t)0.0230102539062f,
(float16_t)0.9995117187500f,(float16_t)0.0245361328125f,
(float16_t)0.9995117187500f,(float16_t)0.0260772705078f,
(float16_t)0.9995117187500f,(float16_t)0.0276031494141f,
(float16_t)0.9995117187500f,(float16_t)0.0291442871094f,
(float16_t)0.9995117187500f,(float16_t)0.0306701660156f,
(float16_t)0.9995117187500f,(float16_t)0.0321960449219f,
(float16_t)0.9995117187500f,(float16_t)0.0337524414062f,
(float16_t)0.9995117187500f,(float16_t)0.0352783203125f,
(float16_t)0.9995117187500f,(float16_t)0.0368041992188f,
(float16_t)0.9990234375000f,(float16_t)0.0383300781250f,
(float16_t)0.9990234375000f,(float16_t)0.0398864746094f,
(float16_t)0.9990234375000f,(float16_t)0.0414123535156f,
(float16_t)0.9990234375000f,(float16_t)0.0429382324219f,
(float16_t)0.9990234375000f,(float16_t)0.0444641113281f,
(float16_t)0.9990234375000f,(float16_t)0.0459899902344f,
(float16_t)0.9990234375000f,(float16_t)0.0475463867188f,
(float16_t)0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)0.9985351562500f,(float16_t)0.0505981445312f,
(float16_t)0.9985351562500f,(float16_t)0.0521240234375f,
(float16_t)0.9985351562500f,(float16_t)0.0536499023438f,
(float16_t)0.9985351562500f,(float16_t)0.0552062988281f,
(float16_t)0.9985351562500f,(float16_t)0.0567321777344f,
(float16_t)0.9985351562500f,(float16_t)0.0582580566406f,
(float16_t)0.9980468750000f,(float16_t)0.0597839355469f,
(float16_t)0.9980468750000f,(float16_t)0.0613098144531f,
(float16_t)0.9980468750000f,(float16_t)0.0628662109375f,
(float16_t)0.9980468750000f,(float16_t)0.0643920898438f,
(float16_t)0.9980468750000f,(float16_t)0.0659179687500f,
(float16_t)0.9975585937500f,(float16_t)0.0674438476562f,
(float16_t)0.9975585937500f,(float16_t)0.0689697265625f,
(float16_t)0.9975585937500f,(float16_t)0.0704956054688f,
(float16_t)0.9975585937500f,(float16_t)0.0720214843750f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9970703125000f,(float16_t)0.0750732421875f,
(float16_t)0.9970703125000f,(float16_t)0.0765991210938f,
(float16_t)0.9970703125000f,(float16_t)0.0781250000000f,
(float16_t)0.9965820312500f,(float16_t)0.0797119140625f,
(float16_t)0.9965820312500f,(float16_t)0.0812377929688f,
(float16_t)0.9965820312500f,(float16_t)0.0827636718750f,
(float16_t)0.9965820312500f,(float16_t)0.0842895507812f,
(float16_t)0.9960937500000f,(float16_t)0.0858154296875f,
(float16_t)0.9960937500000f,(float16_t)0.0873413085938f,
(float16_t)0.9960937500000f,(float16_t)0.0888671875000f,
(float16_t)0.9960937500000f,(float16_t)0.0903930664062f,
(float16_t)0.9956054687500f,(float16_t)0.0919189453125f,
(float16_t)0.9956054687500f,(float16_t)0.0934448242188f,
(float16_t)0.9956054687500f,(float16_t)0.0949707031250f,
(float16_t)0.9951171875000f,(float16_t)0.0964965820312f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9951171875000f,(float16_t)0.0995483398438f,
(float16_t)0.9951171875000f,(float16_t)0.1010742187500f,
(float16_t)0.9946289062500f,(float16_t)0.1026000976562f,
(float16_t)0.9946289062500f,(float16_t)0.1041259765625f,
(float16_t)0.9946289062500f,(float16_t)0.1056518554688f,
(float16_t)0.9941406250000f,(float16_t)0.1071777343750f,
(float16_t)0.9941406250000f,(float16_t)0.1087036132812f,
(float16_t)0.9941406250000f,(float16_t)0.1102294921875f,
(float16_t)0.9936523437500f,(float16_t)0.1117553710938f,
(float16_t)0.9936523437500f,(float16_t)0.1132812500000f,
(float16_t)0.9931640625000f,(float16_t)0.1148071289062f,
(float16_t)0.9931640625000f,(float16_t)0.1163330078125f,
(float16_t)0.9931640625000f,(float16_t)0.1178588867188f,
(float16_t)0.9926757812500f,(float16_t)0.1193847656250f,
(float16_t)0.9926757812500f,(float16_t)0.1209106445312f,
(float16_t)0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)0.9921875000000f,(float16_t)0.1239624023438f,
(float16_t)0.9921875000000f,(float16_t)0.1254882812500f,
(float16_t)0.9916992187500f,(float16_t)0.1269531250000f,
(float16_t)0.9916992187500f,(float16_t)0.1285400390625f,
(float16_t)0.9916992187500f,(float16_t)0.1300048828125f,
(float16_t)0.9912109375000f,(float16_t)0.1315917968750f,
(float16_t)0.9912109375000f,(float16_t)0.1330566406250f,
(float16_t)0.9907226562500f,(float16_t)0.1345214843750f,
(float16_t)0.9907226562500f,(float16_t)0.1361083984375f,
(float16_t)0.9907226562500f,(float16_t)0.1375732421875f,
(float16_t)0.9902343750000f,(float16_t)0.1391601562500f,
(float16_t)0.9902343750000f,(float16_t)0.1406250000000f,
(float16_t)0.9897460937500f,(float16_t)0.1422119140625f,
(float16_t)0.9897460937500f,(float16_t)0.1436767578125f,
(float16_t)0.9892578125000f,(float16_t)0.1452636718750f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9887695312500f,(float16_t)0.1481933593750f,
(float16_t)0.9887695312500f,(float16_t)0.1497802734375f,
(float16_t)0.9882812500000f,(float16_t)0.1512451171875f,
(float16_t)0.9882812500000f,(float16_t)0.1528320312500f,
(float16_t)0.9877929687500f,(float16_t)0.1542968750000f,
(float16_t)0.9877929687500f,(float16_t)0.1558837890625f,
(float16_t)0.9873046875000f,(float16_t)0.1573486328125f,
(float16_t)0.9873046875000f,(float16_t)0.1588134765625f,
(float16_t)0.9868164062500f,(float16_t)0.1604003906250f,
(float16_t)0.9868164062500f,(float16_t)0.1618652343750f,
(float16_t)0.9863281250000f,(float16_t)0.1634521484375f,
(float16_t)0.9863281250000f,(float16_t)0.1649169921875f,
(float16_t)0.9858398437500f,(float16_t)0.1663818359375f,
(float16_t)0.9858398437500f,(float16_t)0.1679687500000f,
(float16_t)0.9853515625000f,(float16_t)0.1694335937500f,
(float16_t)0.9853515625000f,(float16_t)0.1710205078125f,
(float16_t)0.9848632812500f,(float16_t)0.1724853515625f,
(float16_t)0.9848632812500f,(float16_t)0.1739501953125f,
(float16_t)0.9843750000000f,(float16_t)0.1755371093750f,
(float16_t)0.9843750000000f,(float16_t)0.1770019531250f,
(float16_t)0.9838867187500f,(float16_t)0.1784667968750f,
(float16_t)0.9838867187500f,(float16_t)0.1800537109375f,
(float16_t)0.9833984375000f,(float16_t)0.1815185546875f,
(float16_t)0.9829101562500f,(float16_t)0.1829833984375f,
(float16_t)0.9829101562500f,(float16_t)0.1845703125000f,
(float16_t)0.9824218750000f,(float16_t)0.1860351562500f,
(float16_t)0.9824218750000f,(float16_t)0.1876220703125f,
(float16_t)0.9819335937500f,(float16_t)0.1890869140625f,
(float16_t)0.9814453125000f,(float16_t)0.1905517578125f,
(float16_t)0.9814453125000f,(float16_t)0.1921386718750f,
(float16_t)0.9809570312500f,(float16_t)0.1936035156250f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9804687500000f,(float16_t)0.1966552734375f,
(float16_t)0.9799804687500f,(float16_t)0.1981201171875f,
(float16_t)0.9799804687500f,(float16_t)0.1995849609375f,
(float16_t)0.9794921875000f,(float16_t)0.2010498046875f,
(float16_t)0.9794921875000f,(float16_t)0.2026367187500f,
(float16_t)0.9790039062500f,(float16_t)0.2041015625000f,
(float16_t)0.9785156250000f,(float16_t)0.2055664062500f,
(float16_t)0.9785156250000f,(float16_t)0.2071533203125f,
(float16_t)0.9780273437500f,(float16_t)0.2086181640625f,
(float16_t)0.9775390625000f,(float16_t)0.2100830078125f,
(float16_t)0.9775390625000f,(float16_t)0.2116699218750f,
(float16_t)0.9770507812500f,(float16_t)0.2131347656250f,
(float16_t)0.9765625000000f,(float16_t)0.2145996093750f,
(float16_t)0.9765625000000f,(float16_t)0.2160644531250f,
(float16_t)0.9760742187500f,(float16_t)0.2176513671875f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9755859375000f,(float16_t)0.2205810546875f,
(float16_t)0.9750976562500f,(float16_t)0.2220458984375f,
(float16_t)0.9746093750000f,(float16_t)0.2236328125000f,
(float16_t)0.9741210937500f,(float16_t)0.2250976562500f,
(float16_t)0.9741210937500f,(float16_t)0.2265625000000f,
(float16_t)0.9736328125000f,(float16_t)0.2280273437500f,
(float16_t)0.9731445312500f,(float16_t)0.2296142578125f,
(float16_t)0.9731445312500f,(float16_t)0.2310791015625f,
(float16_t)0.9726562500000f,(float16_t)0.2325439453125f,
(float16_t)0.9721679687500f,(float16_t)0.2340087890625f,
(float16_t)0.9716796875000f,(float16_t)0.2354736328125f,
(float16_t)0.9716796875000f,(float16_t)0.2370605468750f,
(float16_t)0.9711914062500f,(float16_t)0.2385253906250f,
(float16_t)0.9707031250000f,(float16_t)0.2399902343750f,
(float16_t)0.9702148437500f,(float16_t)0.2414550781250f,
(float16_t)0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)0.9697265625000f,(float16_t)0.2445068359375f,
(float16_t)0.9692382812500f,(float16_t)0.2459716796875f,
(float16_t)0.9687500000000f,(float16_t)0.2474365234375f,
(float16_t)0.9687500000000f,(float16_t)0.2489013671875f,
(float16_t)0.9682617187500f,(float16_t)0.2504882812500f,
(float16_t)0.9677734375000f,(float16_t)0.2519531250000f,
(float16_t)0.9672851562500f,(float16_t)0.2534179687500f,
(float16_t)0.9667968750000f,(float16_t)0.2548828125000f,
(float16_t)0.9667968750000f,(float16_t)0.2563476562500f,
(float16_t)0.9663085937500f,(float16_t)0.2578125000000f,
(float16_t)0.9658203125000f,(float16_t)0.2592773437500f,
(float16_t)0.9653320312500f,(float16_t)0.2607421875000f,
(float16_t)0.9648437500000f,(float16_t)0.2622070312500f,
(float16_t)0.9643554687500f,(float16_t)0.2636718750000f,
(float16_t)0.9643554687500f,(float16_t)0.2651367187500f,
(float16_t)0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)0.9633789062500f,(float16_t)0.2683105468750f,
(float16_t)0.9628906250000f,(float16_t)0.2697753906250f,
(float16_t)0.9624023437500f,(float16_t)0.2712402343750f,
(float16_t)0.9619140625000f,(float16_t)0.2727050781250f,
(float16_t)0.9619140625000f,(float16_t)0.2741699218750f,
(float16_t)0.9614257812500f,(float16_t)0.2756347656250f,
(float16_t)0.9609375000000f,(float16_t)0.2770996093750f,
(float16_t)0.9604492187500f,(float16_t)0.2785644531250f,
(float16_t)0.9599609375000f,(float16_t)0.2800292968750f,
(float16_t)0.9594726562500f,(float16_t)0.2814941406250f,
(float16_t)0.9589843750000f,(float16_t)0.2829589843750f,
(float16_t)0.9584960937500f,(float16_t)0.2844238281250f,
(float16_t)0.9584960937500f,(float16_t)0.2858886718750f,
(float16_t)0.9580078125000f,(float16_t)0.2873535156250f,
(float16_t)0.9575195312500f,(float16_t)0.2888183593750f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9565429687500f,(float16_t)0.2917480468750f,
(float16_t)0.9560546875000f,(float16_t)0.2932128906250f,
(float16_t)0.9555664062500f,(float16_t)0.2946777343750f,
(float16_t)0.9550781250000f,(float16_t)0.2961425781250f,
(float16_t)0.9545898437500f,(float16_t)0.2976074218750f,
(float16_t)0.9541015625000f,(float16_t)0.2990722656250f,
(float16_t)0.9536132812500f,(float16_t)0.3005371093750f,
(float16_t)0.9531250000000f,(float16_t)0.3020019531250f,
(float16_t)0.9526367187500f,(float16_t)0.3034667968750f,
(float16_t)0.9521484375000f,(float16_t)0.3049316406250f,
(float16_t)0.9521484375000f,(float16_t)0.3063964843750f,
(float16_t)0.9516601562500f,(float16_t)0.3078613281250f,
(float16_t)0.9511718750000f,(float16_t)0.3093261718750f,
(float16_t)0.9506835937500f,(float16_t)0.3107910156250f,
(float16_t)0.9501953125000f,(float16_t)0.3122558593750f,
(float16_t)0.9497070312500f,(float16_t)0.3137207031250f,
(float16_t)0.9492187500000f,(float16_t)0.3151855468750f,
(float16_t)0.9487304687500f,(float16_t)0.3166503906250f,
(float16_t)0.9482421875000f,(float16_t)0.3181152343750f,
(float16_t)0.9477539062500f,(float16_t)0.3195800781250f,
(float16_t)0.9472656250000f,(float16_t)0.3210449218750f,
(float16_t)0.9467773437500f,(float16_t)0.3225097656250f,
(float16_t)0.9462890625000f,(float16_t)0.3239746093750f,
(float16_t)0.9458007812500f,(float16_t)0.3251953125000f,
(float16_t)0.9453125000000f,(float16_t)0.3266601562500f,
(float16_t)0.9448242187500f,(float16_t)0.3281250000000f,
(float16_t)0.9443359375000f,(float16_t)0.3295898437500f,
(float16_t)0.9433593750000f,(float16_t)0.3310546875000f,
(float16_t)0.9428710937500f,(float16_t)0.3325195312500f,
(float16_t)0.9423828125000f,(float16_t)0.3339843750000f,
(float16_t)0.9418945312500f,(float16_t)0.3354492187500f,
(float16_t)0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)0.9409179687500f,(float16_t)0.3383789062500f,
(float16_t)0.9404296875000f,(float16_t)0.3398437500000f,
(float16_t)0.9399414062500f,(float16_t)0.3413085937500f,
(float16_t)0.9394531250000f,(float16_t)0.3427734375000f,
(float16_t)0.9389648437500f,(float16_t)0.3439941406250f,
(float16_t)0.9384765625000f,(float16_t)0.3454589843750f,
(float16_t)0.9379882812500f,(float16_t)0.3469238281250f,
(float16_t)0.9375000000000f,(float16_t)0.3483886718750f,
(float16_t)0.9370117187500f,(float16_t)0.3498535156250f,
(float16_t)0.9360351562500f,(float16_t)0.3513183593750f,
(float16_t)0.9355468750000f,(float16_t)0.3527832031250f,
(float16_t)0.9350585937500f,(float16_t)0.3542480468750f,
(float16_t)0.9345703125000f,(float16_t)0.3557128906250f,
(float16_t)0.9340820312500f,(float16_t)0.3569335937500f,
(float16_t)0.9335937500000f,(float16_t)0.3583984375000f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9326171875000f,(float16_t)0.3613281250000f,
(float16_t)0.9316406250000f,(float16_t)0.3627929687500f,
(float16_t)0.9311523437500f,(float16_t)0.3642578125000f,
(float16_t)0.9306640625000f,(float16_t)0.3657226562500f,
(float16_t)0.9301757812500f,(float16_t)0.3669433593750f,
(float16_t)0.9296875000000f,(float16_t)0.3684082031250f,
(float16_t)0.9291992187500f,(float16_t)0.3698730468750f,
(float16_t)0.9287109375000f,(float16_t)0.3713378906250f,
(float16_t)0.9277343750000f,(float16_t)0.3728027343750f,
(float16_t)0.9272460937500f,(float16_t)0.3742675781250f,
(float16_t)0.9267578125000f,(float16_t)0.3754882812500f,
(float16_t)0.9262695312500f,(float16_t)0.3769531250000f,
(float16_t)0.9257812500000f,(float16_t)0.3784179687500f,
(float16_t)0.9252929687500f,(float16_t)0.3798828125000f,
(float16_t)0.9243164062500f,(float16_t)0.3813476562500f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.9233398437500f,(float16_t)0.3840332031250f,
(float16_t)0.9228515625000f,(float16_t)0.3854980468750f,
(float16_t)0.9218750000000f,(float16_t)0.3869628906250f,
(float16_t)0.9213867187500f,(float16_t)0.3884277343750f,
(float16_t)0.9208984375000f,(float16_t)0.3896484375000f,
(float16_t)0.9204101562500f,(float16_t)0.3911132812500f,
(float16_t)0.9199218750000f,(float16_t)0.3925781250000f,
(float16_t)0.9189453125000f,(float16_t)0.3940429687500f,
(float16_t)0.9184570312500f,(float16_t)0.3955078125000f,
(float16_t)0.9179687500000f,(float16_t)0.3967285156250f,
(float16_t)0.9174804687500f,(float16_t)0.3981933593750f,
(float16_t)0.9165039062500f,(float16_t)0.3996582031250f,
(float16_t)0.9160156250000f,(float16_t)0.4011230468750f,
(float16_t)0.9155273437500f,(float16_t)0.4023437500000f,
(float16_t)0.9150390625000f,(float16_t)0.4038085937500f,
(float16_t)0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)0.9135742187500f,(float16_t)0.4067382812500f,
(float16_t)0.9130859375000f,(float16_t)0.4079589843750f,
(float16_t)0.9121093750000f,(float16_t)0.4094238281250f,
(float16_t)0.9116210937500f,(float16_t)0.4108886718750f,
(float16_t)0.9111328125000f,(float16_t)0.4123535156250f,
(float16_t)0.9106445312500f,(float16_t)0.4135742187500f,
(float16_t)0.9096679687500f,(float16_t)0.4150390625000f,
(float16_t)0.9091796875000f,(float16_t)0.4165039062500f,
(float16_t)0.9086914062500f,(float16_t)0.4177246093750f,
(float16_t)0.9077148437500f,(float16_t)0.4191894531250f,
(float16_t)0.9072265625000f,(float16_t)0.4206542968750f,
(float16_t)0.9067382812500f,(float16_t)0.4221191406250f,
(float16_t)0.9057617187500f,(float16_t)0.4233398437500f,
(float16_t)0.9052734375000f,(float16_t)0.4248046875000f,
(float16_t)0.9047851562500f,(float16_t)0.4262695312500f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.9033203125000f,(float16_t)0.4289550781250f,
(float16_t)0.9028320312500f,(float16_t)0.4304199218750f,
(float16_t)0.9018554687500f,(float16_t)0.4316406250000f,
(float16_t)0.9013671875000f,(float16_t)0.4331054687500f,
(float16_t)0.9008789062500f,(float16_t)0.4345703125000f,
(float16_t)0.8999023437500f,(float16_t)0.4357910156250f,
(float16_t)0.8994140625000f,(float16_t)0.4372558593750f,
(float16_t)0.8984375000000f,(float16_t)0.4387207031250f,
(float16_t)0.8979492187500f,(float16_t)0.4399414062500f,
(float16_t)0.8974609375000f,(float16_t)0.4414062500000f,
(float16_t)0.8964843750000f,(float16_t)0.4426269531250f,
(float16_t)0.8959960937500f,(float16_t)0.4440917968750f,
(float16_t)0.8955078125000f,(float16_t)0.4455566406250f,
(float16_t)0.8945312500000f,(float16_t)0.4467773437500f,
(float16_t)0.8940429687500f,(float16_t)0.4482421875000f,
(float16_t)0.8930664062500f,(float16_t)0.4497070312500f,
(float16_t)0.8925781250000f,(float16_t)0.4509277343750f,
(float16_t)0.8916015625000f,(float16_t)0.4523925781250f,
(float16_t)0.8911132812500f,(float16_t)0.4536132812500f,
(float16_t)0.8906250000000f,(float16_t)0.4550781250000f,
(float16_t)0.8896484375000f,(float16_t)0.4565429687500f,
(float16_t)0.8891601562500f,(float16_t)0.4577636718750f,
(float16_t)0.8881835937500f,(float16_t)0.4592285156250f,
(float16_t)0.8876953125000f,(float16_t)0.4604492187500f,
(float16_t)0.8867187500000f,(float16_t)0.4619140625000f,
(float16_t)0.8862304687500f,(float16_t)0.4633789062500f,
(float16_t)0.8857421875000f,(float16_t)0.4645996093750f,
(float16_t)0.8847656250000f,(float16_t)0.4660644531250f,
(float16_t)0.8842773437500f,(float16_t)0.4672851562500f,
(float16_t)0.8833007812500f,(float16_t)0.4687500000000f,
(float16_t)0.8828125000000f,(float16_t)0.4699707031250f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8813476562500f,(float16_t)0.4726562500000f,
(float16_t)0.8803710937500f,(float16_t)0.4741210937500f,
(float16_t)0.8798828125000f,(float16_t)0.4753417968750f,
(float16_t)0.8789062500000f,(float16_t)0.4768066406250f,
(float16_t)0.8784179687500f,(float16_t)0.4780273437500f,
(float16_t)0.8774414062500f,(float16_t)0.4794921875000f,
(float16_t)0.8769531250000f,(float16_t)0.4809570312500f,
(float16_t)0.8759765625000f,(float16_t)0.4821777343750f,
(float16_t)0.8754882812500f,(float16_t)0.4836425781250f,
(float16_t)0.8745117187500f,(float16_t)0.4848632812500f,
(float16_t)0.8740234375000f,(float16_t)0.4863281250000f,
(float16_t)0.8730468750000f,(float16_t)0.4875488281250f,
(float16_t)0.8725585937500f,(float16_t)0.4887695312500f,
(float16_t)0.8715820312500f,(float16_t)0.4902343750000f,
(float16_t)0.8706054687500f,(float16_t)0.4914550781250f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8691406250000f,(float16_t)0.4941406250000f,
(float16_t)0.8686523437500f,(float16_t)0.4956054687500f,
(float16_t)0.8676757812500f,(float16_t)0.4968261718750f,
(float16_t)0.8671875000000f,(float16_t)0.4982910156250f,
(float16_t)0.8662109375000f,(float16_t)0.4995117187500f,
(float16_t)0.8657226562500f,(float16_t)0.5009765625000f,
(float16_t)0.8647460937500f,(float16_t)0.5024414062500f,
(float16_t)0.8637695312500f,(float16_t)0.5034179687500f,
(float16_t)0.8632812500000f,(float16_t)0.5048828125000f,
(float16_t)0.8623046875000f,(float16_t)0.5063476562500f,
(float16_t)0.8618164062500f,(float16_t)0.5073242187500f,
(float16_t)0.8608398437500f,(float16_t)0.5087890625000f,
(float16_t)0.8598632812500f,(float16_t)0.5102539062500f,
(float16_t)0.8593750000000f,(float16_t)0.5112304687500f,
(float16_t)0.8583984375000f,(float16_t)0.5126953125000f,
(float16_t)0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)0.8569335937500f,(float16_t)0.5156250000000f,
(float16_t)0.8559570312500f,(float16_t)0.5166015625000f,
(float16_t)0.8554687500000f,(float16_t)0.5180664062500f,
(float16_t)0.8544921875000f,(float16_t)0.5195312500000f,
(float16_t)0.8540039062500f,(float16_t)0.5205078125000f,
(float16_t)0.8530273437500f,(float16_t)0.5219726562500f,
(float16_t)0.8520507812500f,(float16_t)0.5234375000000f,
(float16_t)0.8515625000000f,(float16_t)0.5244140625000f,
(float16_t)0.8505859375000f,(float16_t)0.5258789062500f,
(float16_t)0.8496093750000f,(float16_t)0.5273437500000f,
(float16_t)0.8491210937500f,(float16_t)0.5283203125000f,
(float16_t)0.8481445312500f,(float16_t)0.5297851562500f,
(float16_t)0.8471679687500f,(float16_t)0.5312500000000f,
(float16_t)0.8466796875000f,(float16_t)0.5322265625000f,
(float16_t)0.8457031250000f,(float16_t)0.5336914062500f,
(float16_t)0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)0.8442382812500f,(float16_t)0.5361328125000f,
(float16_t)0.8432617187500f,(float16_t)0.5375976562500f,
(float16_t)0.8422851562500f,(float16_t)0.5390625000000f,
(float16_t)0.8417968750000f,(float16_t)0.5400390625000f,
(float16_t)0.8408203125000f,(float16_t)0.5415039062500f,
(float16_t)0.8398437500000f,(float16_t)0.5429687500000f,
(float16_t)0.8388671875000f,(float16_t)0.5439453125000f,
(float16_t)0.8383789062500f,(float16_t)0.5454101562500f,
(float16_t)0.8374023437500f,(float16_t)0.5463867187500f,
(float16_t)0.8364257812500f,(float16_t)0.5478515625000f,
(float16_t)0.8359375000000f,(float16_t)0.5493164062500f,
(float16_t)0.8349609375000f,(float16_t)0.5502929687500f,
(float16_t)0.8339843750000f,(float16_t)0.5517578125000f,
(float16_t)0.8330078125000f,(float16_t)0.5532226562500f,
(float16_t)0.8325195312500f,(float16_t)0.5541992187500f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8305664062500f,(float16_t)0.5566406250000f,
(float16_t)0.8295898437500f,(float16_t)0.5581054687500f,
(float16_t)0.8291015625000f,(float16_t)0.5595703125000f,
(float16_t)0.8281250000000f,(float16_t)0.5605468750000f,
(float16_t)0.8271484375000f,(float16_t)0.5620117187500f,
(float16_t)0.8261718750000f,(float16_t)0.5629882812500f,
(float16_t)0.8256835937500f,(float16_t)0.5644531250000f,
(float16_t)0.8247070312500f,(float16_t)0.5659179687500f,
(float16_t)0.8237304687500f,(float16_t)0.5668945312500f,
(float16_t)0.8227539062500f,(float16_t)0.5683593750000f,
(float16_t)0.8217773437500f,(float16_t)0.5693359375000f,
(float16_t)0.8212890625000f,(float16_t)0.5708007812500f,
(float16_t)0.8203125000000f,(float16_t)0.5722656250000f,
(float16_t)0.8193359375000f,(float16_t)0.5732421875000f,
(float16_t)0.8183593750000f,(float16_t)0.5747070312500f,
(float16_t)0.8173828125000f,(float16_t)0.5756835937500f,
(float16_t)0.8168945312500f,(float16_t)0.5771484375000f,
(float16_t)0.8159179687500f,(float16_t)0.5781250000000f,
(float16_t)0.8149414062500f,(float16_t)0.5795898437500f,
(float16_t)0.8139648437500f,(float16_t)0.5810546875000f,
(float16_t)0.8129882812500f,(float16_t)0.5820312500000f,
(float16_t)0.8120117187500f,(float16_t)0.5834960937500f,
(float16_t)0.8115234375000f,(float16_t)0.5844726562500f,
(float16_t)0.8105468750000f,(float16_t)0.5859375000000f,
(float16_t)0.8095703125000f,(float16_t)0.5869140625000f,
(float16_t)0.8085937500000f,(float16_t)0.5883789062500f,
(float16_t)0.8076171875000f,(float16_t)0.5893554687500f,
(float16_t)0.8066406250000f,(float16_t)0.5908203125000f,
(float16_t)0.8061523437500f,(float16_t)0.5917968750000f,
(float16_t)0.8051757812500f,(float16_t)0.5932617187500f,
(float16_t)0.8041992187500f,(float16_t)0.5942382812500f,
(float16_t)0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)0.8022460937500f,(float16_t)0.5971679687500f,
(float16_t)0.8012695312500f,(float16_t)0.5981445312500f,
(float16_t)0.8002929687500f,(float16_t)0.5996093750000f,
(float16_t)0.7993164062500f,(float16_t)0.6005859375000f,
(float16_t)0.7988281250000f,(float16_t)0.6020507812500f,
(float16_t)0.7978515625000f,(float16_t)0.6030273437500f,
(float16_t)0.7968750000000f,(float16_t)0.6044921875000f,
(float16_t)0.7958984375000f,(float16_t)0.6054687500000f,
(float16_t)0.7949218750000f,(float16_t)0.6069335937500f,
(float16_t)0.7939453125000f,(float16_t)0.6079101562500f,
(float16_t)0.7929687500000f,(float16_t)0.6093750000000f,
(float16_t)0.7919921875000f,(float16_t)0.6103515625000f,
(float16_t)0.7910156250000f,(float16_t)0.6118164062500f,
(float16_t)0.7900390625000f,(float16_t)0.6127929687500f,
(float16_t)0.7890625000000f,(float16_t)0.6142578125000f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7875976562500f,(float16_t)0.6162109375000f,
(float16_t)0.7866210937500f,(float16_t)0.6176757812500f,
(float16_t)0.7856445312500f,(float16_t)0.6186523437500f,
(float16_t)0.7846679687500f,(float16_t)0.6201171875000f,
(float16_t)0.7836914062500f,(float16_t)0.6210937500000f,
(float16_t)0.7827148437500f,(float16_t)0.6225585937500f,
(float16_t)0.7817382812500f,(float16_t)0.6235351562500f,
(float16_t)0.7807617187500f,(float16_t)0.6250000000000f,
(float16_t)0.7797851562500f,(float16_t)0.6259765625000f,
(float16_t)0.7788085937500f,(float16_t)0.6274414062500f,
(float16_t)0.7778320312500f,(float16_t)0.6284179687500f,
(float16_t)0.7768554687500f,(float16_t)0.6293945312500f,
(float16_t)0.7758789062500f,(float16_t)0.6308593750000f,
(float16_t)0.7749023437500f,(float16_t)0.6318359375000f,
(float16_t)0.7739257812500f,(float16_t)0.6333007812500f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7719726562500f,(float16_t)0.6357421875000f,
(float16_t)0.7709960937500f,(float16_t)0.6367187500000f,
(float16_t)0.7700195312500f,(float16_t)0.6381835937500f,
(float16_t)0.7690429687500f,(float16_t)0.6391601562500f,
(float16_t)0.7680664062500f,(float16_t)0.6401367187500f,
(float16_t)0.7670898437500f,(float16_t)0.6416015625000f,
(float16_t)0.7661132812500f,(float16_t)0.6425781250000f,
(float16_t)0.7651367187500f,(float16_t)0.6440429687500f,
(float16_t)0.7641601562500f,(float16_t)0.6450195312500f,
(float16_t)0.7631835937500f,(float16_t)0.6459960937500f,
(float16_t)0.7622070312500f,(float16_t)0.6474609375000f,
(float16_t)0.7612304687500f,(float16_t)0.6484375000000f,
(float16_t)0.7602539062500f,(float16_t)0.6499023437500f,
(float16_t)0.7592773437500f,(float16_t)0.6508789062500f,
(float16_t)0.7583007812500f,(float16_t)0.6518554687500f,
(float16_t)0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)0.7563476562500f,(float16_t)0.6542968750000f,
(float16_t)0.7553710937500f,(float16_t)0.6552734375000f,
(float16_t)0.7543945312500f,(float16_t)0.6567382812500f,
(float16_t)0.7534179687500f,(float16_t)0.6577148437500f,
(float16_t)0.7519531250000f,(float16_t)0.6591796875000f,
(float16_t)0.7509765625000f,(float16_t)0.6601562500000f,
(float16_t)0.7500000000000f,(float16_t)0.6611328125000f,
(float16_t)0.7490234375000f,(float16_t)0.6625976562500f,
(float16_t)0.7480468750000f,(float16_t)0.6635742187500f,
(float16_t)0.7470703125000f,(float16_t)0.6645507812500f,
(float16_t)0.7460937500000f,(float16_t)0.6660156250000f,
(float16_t)0.7451171875000f,(float16_t)0.6669921875000f,
(float16_t)0.7441406250000f,(float16_t)0.6679687500000f,
(float16_t)0.7431640625000f,(float16_t)0.6694335937500f,
(float16_t)0.7421875000000f,(float16_t)0.6704101562500f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7397460937500f,(float16_t)0.6728515625000f,
(float16_t)0.7387695312500f,(float16_t)0.6738281250000f,
(float16_t)0.7377929687500f,(float16_t)0.6748046875000f,
(float16_t)0.7368164062500f,(float16_t)0.6762695312500f,
(float16_t)0.7358398437500f,(float16_t)0.6772460937500f,
(float16_t)0.7348632812500f,(float16_t)0.6782226562500f,
(float16_t)0.7338867187500f,(float16_t)0.6796875000000f,
(float16_t)0.7324218750000f,(float16_t)0.6806640625000f,
(float16_t)0.7314453125000f,(float16_t)0.6816406250000f,
(float16_t)0.7304687500000f,(float16_t)0.6826171875000f,
(float16_t)0.7294921875000f,(float16_t)0.6840820312500f,
(float16_t)0.7285156250000f,(float16_t)0.6850585937500f,
(float16_t)0.7275390625000f,(float16_t)0.6860351562500f,
(float16_t)0.7265625000000f,(float16_t)0.6875000000000f,
(float16_t)0.7250976562500f,(float16_t)0.6884765625000f,
(float16_t)0.7241210937500f,(float16_t)0.6894531250000f,
(float16_t)0.7231445312500f,(float16_t)0.6904296875000f,
(float16_t)0.7221679687500f,(float16_t)0.6918945312500f,
(float16_t)0.7211914062500f,(float16_t)0.6928710937500f,
(float16_t)0.7202148437500f,(float16_t)0.6938476562500f,
(float16_t)0.7187500000000f,(float16_t)0.6953125000000f,
(float16_t)0.7177734375000f,(float16_t)0.6962890625000f,
(float16_t)0.7167968750000f,(float16_t)0.6972656250000f,
(float16_t)0.7158203125000f,(float16_t)0.6982421875000f,
(float16_t)0.7148437500000f,(float16_t)0.6997070312500f,
(float16_t)0.7133789062500f,(float16_t)0.7006835937500f,
(float16_t)0.7124023437500f,(float16_t)0.7016601562500f,
(float16_t)0.7114257812500f,(float16_t)0.7026367187500f,
(float16_t)0.7104492187500f,(float16_t)0.7036132812500f,
(float16_t)0.7094726562500f,(float16_t)0.7050781250000f,
(float16_t)0.7080078125000f,(float16_t)0.7060546875000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.7060546875000f,(float16_t)0.7080078125000f,
(float16_t)0.7050781250000f,(float16_t)0.7094726562500f,
(float16_t)0.7036132812500f,(float16_t)0.7104492187500f,
(float16_t)0.7026367187500f,(float16_t)0.7114257812500f,
(float16_t)0.7016601562500f,(float16_t)0.7124023437500f,
(float16_t)0.7006835937500f,(float16_t)0.7133789062500f,
(float16_t)0.6997070312500f,(float16_t)0.7148437500000f,
(float16_t)0.6982421875000f,(float16_t)0.7158203125000f,
(float16_t)0.6972656250000f,(float16_t)0.7167968750000f,
(float16_t)0.6962890625000f,(float16_t)0.7177734375000f,
(float16_t)0.6953125000000f,(float16_t)0.7187500000000f,
(float16_t)0.6938476562500f,(float16_t)0.7202148437500f,
(float16_t)0.6928710937500f,(float16_t)0.7211914062500f,
(float16_t)0.6918945312500f,(float16_t)0.7221679687500f,
(float16_t)0.6904296875000f,(float16_t)0.7231445312500f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6884765625000f,(float16_t)0.7250976562500f,
(float16_t)0.6875000000000f,(float16_t)0.7265625000000f,
(float16_t)0.6860351562500f,(float16_t)0.7275390625000f,
(float16_t)0.6850585937500f,(float16_t)0.7285156250000f,
(float16_t)0.6840820312500f,(float16_t)0.7294921875000f,
(float16_t)0.6826171875000f,(float16_t)0.7304687500000f,
(float16_t)0.6816406250000f,(float16_t)0.7314453125000f,
(float16_t)0.6806640625000f,(float16_t)0.7324218750000f,
(float16_t)0.6796875000000f,(float16_t)0.7338867187500f,
(float16_t)0.6782226562500f,(float16_t)0.7348632812500f,
(float16_t)0.6772460937500f,(float16_t)0.7358398437500f,
(float16_t)0.6762695312500f,(float16_t)0.7368164062500f,
(float16_t)0.6748046875000f,(float16_t)0.7377929687500f,
(float16_t)0.6738281250000f,(float16_t)0.7387695312500f,
(float16_t)0.6728515625000f,(float16_t)0.7397460937500f,
(float16_t)0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)0.6704101562500f,(float16_t)0.7421875000000f,
(float16_t)0.6694335937500f,(float16_t)0.7431640625000f,
(float16_t)0.6679687500000f,(float16_t)0.7441406250000f,
(float16_t)0.6669921875000f,(float16_t)0.7451171875000f,
(float16_t)0.6660156250000f,(float16_t)0.7460937500000f,
(float16_t)0.6645507812500f,(float16_t)0.7470703125000f,
(float16_t)0.6635742187500f,(float16_t)0.7480468750000f,
(float16_t)0.6625976562500f,(float16_t)0.7490234375000f,
(float16_t)0.6611328125000f,(float16_t)0.7500000000000f,
(float16_t)0.6601562500000f,(float16_t)0.7509765625000f,
(float16_t)0.6591796875000f,(float16_t)0.7519531250000f,
(float16_t)0.6577148437500f,(float16_t)0.7534179687500f,
(float16_t)0.6567382812500f,(float16_t)0.7543945312500f,
(float16_t)0.6552734375000f,(float16_t)0.7553710937500f,
(float16_t)0.6542968750000f,(float16_t)0.7563476562500f,
(float16_t)0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)0.6518554687500f,(float16_t)0.7583007812500f,
(float16_t)0.6508789062500f,(float16_t)0.7592773437500f,
(float16_t)0.6499023437500f,(float16_t)0.7602539062500f,
(float16_t)0.6484375000000f,(float16_t)0.7612304687500f,
(float16_t)0.6474609375000f,(float16_t)0.7622070312500f,
(float16_t)0.6459960937500f,(float16_t)0.7631835937500f,
(float16_t)0.6450195312500f,(float16_t)0.7641601562500f,
(float16_t)0.6440429687500f,(float16_t)0.7651367187500f,
(float16_t)0.6425781250000f,(float16_t)0.7661132812500f,
(float16_t)0.6416015625000f,(float16_t)0.7670898437500f,
(float16_t)0.6401367187500f,(float16_t)0.7680664062500f,
(float16_t)0.6391601562500f,(float16_t)0.7690429687500f,
(float16_t)0.6381835937500f,(float16_t)0.7700195312500f,
(float16_t)0.6367187500000f,(float16_t)0.7709960937500f,
(float16_t)0.6357421875000f,(float16_t)0.7719726562500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.6333007812500f,(float16_t)0.7739257812500f,
(float16_t)0.6318359375000f,(float16_t)0.7749023437500f,
(float16_t)0.6308593750000f,(float16_t)0.7758789062500f,
(float16_t)0.6293945312500f,(float16_t)0.7768554687500f,
(float16_t)0.6284179687500f,(float16_t)0.7778320312500f,
(float16_t)0.6274414062500f,(float16_t)0.7788085937500f,
(float16_t)0.6259765625000f,(float16_t)0.7797851562500f,
(float16_t)0.6250000000000f,(float16_t)0.7807617187500f,
(float16_t)0.6235351562500f,(float16_t)0.7817382812500f,
(float16_t)0.6225585937500f,(float16_t)0.7827148437500f,
(float16_t)0.6210937500000f,(float16_t)0.7836914062500f,
(float16_t)0.6201171875000f,(float16_t)0.7846679687500f,
(float16_t)0.6186523437500f,(float16_t)0.7856445312500f,
(float16_t)0.6176757812500f,(float16_t)0.7866210937500f,
(float16_t)0.6162109375000f,(float16_t)0.7875976562500f,
(float16_t)0.6152343750000f,(float16_t)0.7885742187500f,
(float16_t)0.6142578125000f,(float16_t)0.7890625000000f,
(float16_t)0.6127929687500f,(float16_t)0.7900390625000f,
(float16_t)0.6118164062500f,(float16_t)0.7910156250000f,
(float16_t)0.6103515625000f,(float16_t)0.7919921875000f,
(float16_t)0.6093750000000f,(float16_t)0.7929687500000f,
(float16_t)0.6079101562500f,(float16_t)0.7939453125000f,
(float16_t)0.6069335937500f,(float16_t)0.7949218750000f,
(float16_t)0.6054687500000f,(float16_t)0.7958984375000f,
(float16_t)0.6044921875000f,(float16_t)0.7968750000000f,
(float16_t)0.6030273437500f,(float16_t)0.7978515625000f,
(float16_t)0.6020507812500f,(float16_t)0.7988281250000f,
(float16_t)0.6005859375000f,(float16_t)0.7993164062500f,
(float16_t)0.5996093750000f,(float16_t)0.8002929687500f,
(float16_t)0.5981445312500f,(float16_t)0.8012695312500f,
(float16_t)0.5971679687500f,(float16_t)0.8022460937500f,
(float16_t)0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)0.5942382812500f,(float16_t)0.8041992187500f,
(float16_t)0.5932617187500f,(float16_t)0.8051757812500f,
(float16_t)0.5917968750000f,(float16_t)0.8061523437500f,
(float16_t)0.5908203125000f,(float16_t)0.8066406250000f,
(float16_t)0.5893554687500f,(float16_t)0.8076171875000f,
(float16_t)0.5883789062500f,(float16_t)0.8085937500000f,
(float16_t)0.5869140625000f,(float16_t)0.8095703125000f,
(float16_t)0.5859375000000f,(float16_t)0.8105468750000f,
(float16_t)0.5844726562500f,(float16_t)0.8115234375000f,
(float16_t)0.5834960937500f,(float16_t)0.8120117187500f,
(float16_t)0.5820312500000f,(float16_t)0.8129882812500f,
(float16_t)0.5810546875000f,(float16_t)0.8139648437500f,
(float16_t)0.5795898437500f,(float16_t)0.8149414062500f,
(float16_t)0.5781250000000f,(float16_t)0.8159179687500f,
(float16_t)0.5771484375000f,(float16_t)0.8168945312500f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5747070312500f,(float16_t)0.8183593750000f,
(float16_t)0.5732421875000f,(float16_t)0.8193359375000f,
(float16_t)0.5722656250000f,(float16_t)0.8203125000000f,
(float16_t)0.5708007812500f,(float16_t)0.8212890625000f,
(float16_t)0.5693359375000f,(float16_t)0.8217773437500f,
(float16_t)0.5683593750000f,(float16_t)0.8227539062500f,
(float16_t)0.5668945312500f,(float16_t)0.8237304687500f,
(float16_t)0.5659179687500f,(float16_t)0.8247070312500f,
(float16_t)0.5644531250000f,(float16_t)0.8256835937500f,
(float16_t)0.5629882812500f,(float16_t)0.8261718750000f,
(float16_t)0.5620117187500f,(float16_t)0.8271484375000f,
(float16_t)0.5605468750000f,(float16_t)0.8281250000000f,
(float16_t)0.5595703125000f,(float16_t)0.8291015625000f,
(float16_t)0.5581054687500f,(float16_t)0.8295898437500f,
(float16_t)0.5566406250000f,(float16_t)0.8305664062500f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.5541992187500f,(float16_t)0.8325195312500f,
(float16_t)0.5532226562500f,(float16_t)0.8330078125000f,
(float16_t)0.5517578125000f,(float16_t)0.8339843750000f,
(float16_t)0.5502929687500f,(float16_t)0.8349609375000f,
(float16_t)0.5493164062500f,(float16_t)0.8359375000000f,
(float16_t)0.5478515625000f,(float16_t)0.8364257812500f,
(float16_t)0.5463867187500f,(float16_t)0.8374023437500f,
(float16_t)0.5454101562500f,(float16_t)0.8383789062500f,
(float16_t)0.5439453125000f,(float16_t)0.8388671875000f,
(float16_t)0.5429687500000f,(float16_t)0.8398437500000f,
(float16_t)0.5415039062500f,(float16_t)0.8408203125000f,
(float16_t)0.5400390625000f,(float16_t)0.8417968750000f,
(float16_t)0.5390625000000f,(float16_t)0.8422851562500f,
(float16_t)0.5375976562500f,(float16_t)0.8432617187500f,
(float16_t)0.5361328125000f,(float16_t)0.8442382812500f,
(float16_t)0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)0.5336914062500f,(float16_t)0.8457031250000f,
(float16_t)0.5322265625000f,(float16_t)0.8466796875000f,
(float16_t)0.5312500000000f,(float16_t)0.8471679687500f,
(float16_t)0.5297851562500f,(float16_t)0.8481445312500f,
(float16_t)0.5283203125000f,(float16_t)0.8491210937500f,
(float16_t)0.5273437500000f,(float16_t)0.8496093750000f,
(float16_t)0.5258789062500f,(float16_t)0.8505859375000f,
(float16_t)0.5244140625000f,(float16_t)0.8515625000000f,
(float16_t)0.5234375000000f,(float16_t)0.8520507812500f,
(float16_t)0.5219726562500f,(float16_t)0.8530273437500f,
(float16_t)0.5205078125000f,(float16_t)0.8540039062500f,
(float16_t)0.5195312500000f,(float16_t)0.8544921875000f,
(float16_t)0.5180664062500f,(float16_t)0.8554687500000f,
(float16_t)0.5166015625000f,(float16_t)0.8559570312500f,
(float16_t)0.5156250000000f,(float16_t)0.8569335937500f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.5126953125000f,(float16_t)0.8583984375000f,
(float16_t)0.5112304687500f,(float16_t)0.8593750000000f,
(float16_t)0.5102539062500f,(float16_t)0.8598632812500f,
(float16_t)0.5087890625000f,(float16_t)0.8608398437500f,
(float16_t)0.5073242187500f,(float16_t)0.8618164062500f,
(float16_t)0.5063476562500f,(float16_t)0.8623046875000f,
(float16_t)0.5048828125000f,(float16_t)0.8632812500000f,
(float16_t)0.5034179687500f,(float16_t)0.8637695312500f,
(float16_t)0.5024414062500f,(float16_t)0.8647460937500f,
(float16_t)0.5009765625000f,(float16_t)0.8657226562500f,
(float16_t)0.4995117187500f,(float16_t)0.8662109375000f,
(float16_t)0.4982910156250f,(float16_t)0.8671875000000f,
(float16_t)0.4968261718750f,(float16_t)0.8676757812500f,
(float16_t)0.4956054687500f,(float16_t)0.8686523437500f,
(float16_t)0.4941406250000f,(float16_t)0.8691406250000f,
(float16_t)0.4929199218750f,(float16_t)0.8701171875000f,
(float16_t)0.4914550781250f,(float16_t)0.8706054687500f,
(float16_t)0.4902343750000f,(float16_t)0.8715820312500f,
(float16_t)0.4887695312500f,(float16_t)0.8725585937500f,
(float16_t)0.4875488281250f,(float16_t)0.8730468750000f,
(float16_t)0.4863281250000f,(float16_t)0.8740234375000f,
(float16_t)0.4848632812500f,(float16_t)0.8745117187500f,
(float16_t)0.4836425781250f,(float16_t)0.8754882812500f,
(float16_t)0.4821777343750f,(float16_t)0.8759765625000f,
(float16_t)0.4809570312500f,(float16_t)0.8769531250000f,
(float16_t)0.4794921875000f,(float16_t)0.8774414062500f,
(float16_t)0.4780273437500f,(float16_t)0.8784179687500f,
(float16_t)0.4768066406250f,(float16_t)0.8789062500000f,
(float16_t)0.4753417968750f,(float16_t)0.8798828125000f,
(float16_t)0.4741210937500f,(float16_t)0.8803710937500f,
(float16_t)0.4726562500000f,(float16_t)0.8813476562500f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.4699707031250f,(float16_t)0.8828125000000f,
(float16_t)0.4687500000000f,(float16_t)0.8833007812500f,
(float16_t)0.4672851562500f,(float16_t)0.8842773437500f,
(float16_t)0.4660644531250f,(float16_t)0.8847656250000f,
(float16_t)0.4645996093750f,(float16_t)0.8857421875000f,
(float16_t)0.4633789062500f,(float16_t)0.8862304687500f,
(float16_t)0.4619140625000f,(float16_t)0.8867187500000f,
(float16_t)0.4604492187500f,(float16_t)0.8876953125000f,
(float16_t)0.4592285156250f,(float16_t)0.8881835937500f,
(float16_t)0.4577636718750f,(float16_t)0.8891601562500f,
(float16_t)0.4565429687500f,(float16_t)0.8896484375000f,
(float16_t)0.4550781250000f,(float16_t)0.8906250000000f,
(float16_t)0.4536132812500f,(float16_t)0.8911132812500f,
(float16_t)0.4523925781250f,(float16_t)0.8916015625000f,
(float16_t)0.4509277343750f,(float16_t)0.8925781250000f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.4482421875000f,(float16_t)0.8940429687500f,
(float16_t)0.4467773437500f,(float16_t)0.8945312500000f,
(float16_t)0.4455566406250f,(float16_t)0.8955078125000f,
(float16_t)0.4440917968750f,(float16_t)0.8959960937500f,
(float16_t)0.4426269531250f,(float16_t)0.8964843750000f,
(float16_t)0.4414062500000f,(float16_t)0.8974609375000f,
(float16_t)0.4399414062500f,(float16_t)0.8979492187500f,
(float16_t)0.4387207031250f,(float16_t)0.8984375000000f,
(float16_t)0.4372558593750f,(float16_t)0.8994140625000f,
(float16_t)0.4357910156250f,(float16_t)0.8999023437500f,
(float16_t)0.4345703125000f,(float16_t)0.9008789062500f,
(float16_t)0.4331054687500f,(float16_t)0.9013671875000f,
(float16_t)0.4316406250000f,(float16_t)0.9018554687500f,
(float16_t)0.4304199218750f,(float16_t)0.9028320312500f,
(float16_t)0.4289550781250f,(float16_t)0.9033203125000f,
(float16_t)0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)0.4262695312500f,(float16_t)0.9047851562500f,
(float16_t)0.4248046875000f,(float16_t)0.9052734375000f,
(float16_t)0.4233398437500f,(float16_t)0.9057617187500f,
(float16_t)0.4221191406250f,(float16_t)0.9067382812500f,
(float16_t)0.4206542968750f,(float16_t)0.9072265625000f,
(float16_t)0.4191894531250f,(float16_t)0.9077148437500f,
(float16_t)0.4177246093750f,(float16_t)0.9086914062500f,
(float16_t)0.4165039062500f,(float16_t)0.9091796875000f,
(float16_t)0.4150390625000f,(float16_t)0.9096679687500f,
(float16_t)0.4135742187500f,(float16_t)0.9106445312500f,
(float16_t)0.4123535156250f,(float16_t)0.9111328125000f,
(float16_t)0.4108886718750f,(float16_t)0.9116210937500f,
(float16_t)0.4094238281250f,(float16_t)0.9121093750000f,
(float16_t)0.4079589843750f,(float16_t)0.9130859375000f,
(float16_t)0.4067382812500f,(float16_t)0.9135742187500f,
(float16_t)0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)0.4038085937500f,(float16_t)0.9150390625000f,
(float16_t)0.4023437500000f,(float16_t)0.9155273437500f,
(float16_t)0.4011230468750f,(float16_t)0.9160156250000f,
(float16_t)0.3996582031250f,(float16_t)0.9165039062500f,
(float16_t)0.3981933593750f,(float16_t)0.9174804687500f,
(float16_t)0.3967285156250f,(float16_t)0.9179687500000f,
(float16_t)0.3955078125000f,(float16_t)0.9184570312500f,
(float16_t)0.3940429687500f,(float16_t)0.9189453125000f,
(float16_t)0.3925781250000f,(float16_t)0.9199218750000f,
(float16_t)0.3911132812500f,(float16_t)0.9204101562500f,
(float16_t)0.3896484375000f,(float16_t)0.9208984375000f,
(float16_t)0.3884277343750f,(float16_t)0.9213867187500f,
(float16_t)0.3869628906250f,(float16_t)0.9218750000000f,
(float16_t)0.3854980468750f,(float16_t)0.9228515625000f,
(float16_t)0.3840332031250f,(float16_t)0.9233398437500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3813476562500f,(float16_t)0.9243164062500f,
(float16_t)0.3798828125000f,(float16_t)0.9252929687500f,
(float16_t)0.3784179687500f,(float16_t)0.9257812500000f,
(float16_t)0.3769531250000f,(float16_t)0.9262695312500f,
(float16_t)0.3754882812500f,(float16_t)0.9267578125000f,
(float16_t)0.3742675781250f,(float16_t)0.9272460937500f,
(float16_t)0.3728027343750f,(float16_t)0.9277343750000f,
(float16_t)0.3713378906250f,(float16_t)0.9287109375000f,
(float16_t)0.3698730468750f,(float16_t)0.9291992187500f,
(float16_t)0.3684082031250f,(float16_t)0.9296875000000f,
(float16_t)0.3669433593750f,(float16_t)0.9301757812500f,
(float16_t)0.3657226562500f,(float16_t)0.9306640625000f,
(float16_t)0.3642578125000f,(float16_t)0.9311523437500f,
(float16_t)0.3627929687500f,(float16_t)0.9316406250000f,
(float16_t)0.3613281250000f,(float16_t)0.9326171875000f,
(float16_t)0.3598632812500f,(float16_t)0.9331054687500f,
(float16_t)0.3583984375000f,(float16_t)0.9335937500000f,
(float16_t)0.3569335937500f,(float16_t)0.9340820312500f,
(float16_t)0.3557128906250f,(float16_t)0.9345703125000f,
(float16_t)0.3542480468750f,(float16_t)0.9350585937500f,
(float16_t)0.3527832031250f,(float16_t)0.9355468750000f,
(float16_t)0.3513183593750f,(float16_t)0.9360351562500f,
(float16_t)0.3498535156250f,(float16_t)0.9370117187500f,
(float16_t)0.3483886718750f,(float16_t)0.9375000000000f,
(float16_t)0.3469238281250f,(float16_t)0.9379882812500f,
(float16_t)0.3454589843750f,(float16_t)0.9384765625000f,
(float16_t)0.3439941406250f,(float16_t)0.9389648437500f,
(float16_t)0.3427734375000f,(float16_t)0.9394531250000f,
(float16_t)0.3413085937500f,(float16_t)0.9399414062500f,
(float16_t)0.3398437500000f,(float16_t)0.9404296875000f,
(float16_t)0.3383789062500f,(float16_t)0.9409179687500f,
(float16_t)0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)0.3354492187500f,(float16_t)0.9418945312500f,
(float16_t)0.3339843750000f,(float16_t)0.9423828125000f,
(float16_t)0.3325195312500f,(float16_t)0.9428710937500f,
(float16_t)0.3310546875000f,(float16_t)0.9433593750000f,
(float16_t)0.3295898437500f,(float16_t)0.9443359375000f,
(float16_t)0.3281250000000f,(float16_t)0.9448242187500f,
(float16_t)0.3266601562500f,(float16_t)0.9453125000000f,
(float16_t)0.3251953125000f,(float16_t)0.9458007812500f,
(float16_t)0.3239746093750f,(float16_t)0.9462890625000f,
(float16_t)0.3225097656250f,(float16_t)0.9467773437500f,
(float16_t)0.3210449218750f,(float16_t)0.9472656250000f,
(float16_t)0.3195800781250f,(float16_t)0.9477539062500f,
(float16_t)0.3181152343750f,(float16_t)0.9482421875000f,
(float16_t)0.3166503906250f,(float16_t)0.9487304687500f,
(float16_t)0.3151855468750f,(float16_t)0.9492187500000f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.3122558593750f,(float16_t)0.9501953125000f,
(float16_t)0.3107910156250f,(float16_t)0.9506835937500f,
(float16_t)0.3093261718750f,(float16_t)0.9511718750000f,
(float16_t)0.3078613281250f,(float16_t)0.9516601562500f,
(float16_t)0.3063964843750f,(float16_t)0.9521484375000f,
(float16_t)0.3049316406250f,(float16_t)0.9521484375000f,
(float16_t)0.3034667968750f,(float16_t)0.9526367187500f,
(float16_t)0.3020019531250f,(float16_t)0.9531250000000f,
(float16_t)0.3005371093750f,(float16_t)0.9536132812500f,
(float16_t)0.2990722656250f,(float16_t)0.9541015625000f,
(float16_t)0.2976074218750f,(float16_t)0.9545898437500f,
(float16_t)0.2961425781250f,(float16_t)0.9550781250000f,
(float16_t)0.2946777343750f,(float16_t)0.9555664062500f,
(float16_t)0.2932128906250f,(float16_t)0.9560546875000f,
(float16_t)0.2917480468750f,(float16_t)0.9565429687500f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.2888183593750f,(float16_t)0.9575195312500f,
(float16_t)0.2873535156250f,(float16_t)0.9580078125000f,
(float16_t)0.2858886718750f,(float16_t)0.9584960937500f,
(float16_t)0.2844238281250f,(float16_t)0.9584960937500f,
(float16_t)0.2829589843750f,(float16_t)0.9589843750000f,
(float16_t)0.2814941406250f,(float16_t)0.9594726562500f,
(float16_t)0.2800292968750f,(float16_t)0.9599609375000f,
(float16_t)0.2785644531250f,(float16_t)0.9604492187500f,
(float16_t)0.2770996093750f,(float16_t)0.9609375000000f,
(float16_t)0.2756347656250f,(float16_t)0.9614257812500f,
(float16_t)0.2741699218750f,(float16_t)0.9619140625000f,
(float16_t)0.2727050781250f,(float16_t)0.9619140625000f,
(float16_t)0.2712402343750f,(float16_t)0.9624023437500f,
(float16_t)0.2697753906250f,(float16_t)0.9628906250000f,
(float16_t)0.2683105468750f,(float16_t)0.9633789062500f,
(float16_t)0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)0.2651367187500f,(float16_t)0.9643554687500f,
(float16_t)0.2636718750000f,(float16_t)0.9643554687500f,
(float16_t)0.2622070312500f,(float16_t)0.9648437500000f,
(float16_t)0.2607421875000f,(float16_t)0.9653320312500f,
(float16_t)0.2592773437500f,(float16_t)0.9658203125000f,
(float16_t)0.2578125000000f,(float16_t)0.9663085937500f,
(float16_t)0.2563476562500f,(float16_t)0.9667968750000f,
(float16_t)0.2548828125000f,(float16_t)0.9667968750000f,
(float16_t)0.2534179687500f,(float16_t)0.9672851562500f,
(float16_t)0.2519531250000f,(float16_t)0.9677734375000f,
(float16_t)0.2504882812500f,(float16_t)0.9682617187500f,
(float16_t)0.2489013671875f,(float16_t)0.9687500000000f,
(float16_t)0.2474365234375f,(float16_t)0.9687500000000f,
(float16_t)0.2459716796875f,(float16_t)0.9692382812500f,
(float16_t)0.2445068359375f,(float16_t)0.9697265625000f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.2414550781250f,(float16_t)0.9702148437500f,
(float16_t)0.2399902343750f,(float16_t)0.9707031250000f,
(float16_t)0.2385253906250f,(float16_t)0.9711914062500f,
(float16_t)0.2370605468750f,(float16_t)0.9716796875000f,
(float16_t)0.2354736328125f,(float16_t)0.9716796875000f,
(float16_t)0.2340087890625f,(float16_t)0.9721679687500f,
(float16_t)0.2325439453125f,(float16_t)0.9726562500000f,
(float16_t)0.2310791015625f,(float16_t)0.9731445312500f,
(float16_t)0.2296142578125f,(float16_t)0.9731445312500f,
(float16_t)0.2280273437500f,(float16_t)0.9736328125000f,
(float16_t)0.2265625000000f,(float16_t)0.9741210937500f,
(float16_t)0.2250976562500f,(float16_t)0.9741210937500f,
(float16_t)0.2236328125000f,(float16_t)0.9746093750000f,
(float16_t)0.2220458984375f,(float16_t)0.9750976562500f,
(float16_t)0.2205810546875f,(float16_t)0.9755859375000f,
(float16_t)0.2191162109375f,(float16_t)0.9755859375000f,
(float16_t)0.2176513671875f,(float16_t)0.9760742187500f,
(float16_t)0.2160644531250f,(float16_t)0.9765625000000f,
(float16_t)0.2145996093750f,(float16_t)0.9765625000000f,
(float16_t)0.2131347656250f,(float16_t)0.9770507812500f,
(float16_t)0.2116699218750f,(float16_t)0.9775390625000f,
(float16_t)0.2100830078125f,(float16_t)0.9775390625000f,
(float16_t)0.2086181640625f,(float16_t)0.9780273437500f,
(float16_t)0.2071533203125f,(float16_t)0.9785156250000f,
(float16_t)0.2055664062500f,(float16_t)0.9785156250000f,
(float16_t)0.2041015625000f,(float16_t)0.9790039062500f,
(float16_t)0.2026367187500f,(float16_t)0.9794921875000f,
(float16_t)0.2010498046875f,(float16_t)0.9794921875000f,
(float16_t)0.1995849609375f,(float16_t)0.9799804687500f,
(float16_t)0.1981201171875f,(float16_t)0.9799804687500f,
(float16_t)0.1966552734375f,(float16_t)0.9804687500000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.1936035156250f,(float16_t)0.9809570312500f,
(float16_t)0.1921386718750f,(float16_t)0.9814453125000f,
(float16_t)0.1905517578125f,(float16_t)0.9814453125000f,
(float16_t)0.1890869140625f,(float16_t)0.9819335937500f,
(float16_t)0.1876220703125f,(float16_t)0.9824218750000f,
(float16_t)0.1860351562500f,(float16_t)0.9824218750000f,
(float16_t)0.1845703125000f,(float16_t)0.9829101562500f,
(float16_t)0.1829833984375f,(float16_t)0.9829101562500f,
(float16_t)0.1815185546875f,(float16_t)0.9833984375000f,
(float16_t)0.1800537109375f,(float16_t)0.9838867187500f,
(float16_t)0.1784667968750f,(float16_t)0.9838867187500f,
(float16_t)0.1770019531250f,(float16_t)0.9843750000000f,
(float16_t)0.1755371093750f,(float16_t)0.9843750000000f,
(float16_t)0.1739501953125f,(float16_t)0.9848632812500f,
(float16_t)0.1724853515625f,(float16_t)0.9848632812500f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.1694335937500f,(float16_t)0.9853515625000f,
(float16_t)0.1679687500000f,(float16_t)0.9858398437500f,
(float16_t)0.1663818359375f,(float16_t)0.9858398437500f,
(float16_t)0.1649169921875f,(float16_t)0.9863281250000f,
(float16_t)0.1634521484375f,(float16_t)0.9863281250000f,
(float16_t)0.1618652343750f,(float16_t)0.9868164062500f,
(float16_t)0.1604003906250f,(float16_t)0.9868164062500f,
(float16_t)0.1588134765625f,(float16_t)0.9873046875000f,
(float16_t)0.1573486328125f,(float16_t)0.9873046875000f,
(float16_t)0.1558837890625f,(float16_t)0.9877929687500f,
(float16_t)0.1542968750000f,(float16_t)0.9877929687500f,
(float16_t)0.1528320312500f,(float16_t)0.9882812500000f,
(float16_t)0.1512451171875f,(float16_t)0.9882812500000f,
(float16_t)0.1497802734375f,(float16_t)0.9887695312500f,
(float16_t)0.1481933593750f,(float16_t)0.9887695312500f,
(float16_t)0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)0.1452636718750f,(float16_t)0.9892578125000f,
(float16_t)0.1436767578125f,(float16_t)0.9897460937500f,
(float16_t)0.1422119140625f,(float16_t)0.9897460937500f,
(float16_t)0.1406250000000f,(float16_t)0.9902343750000f,
(float16_t)0.1391601562500f,(float16_t)0.9902343750000f,
(float16_t)0.1375732421875f,(float16_t)0.9907226562500f,
(float16_t)0.1361083984375f,(float16_t)0.9907226562500f,
(float16_t)0.1345214843750f,(float16_t)0.9907226562500f,
(float16_t)0.1330566406250f,(float16_t)0.9912109375000f,
(float16_t)0.1315917968750f,(float16_t)0.9912109375000f,
(float16_t)0.1300048828125f,(float16_t)0.9916992187500f,
(float16_t)0.1285400390625f,(float16_t)0.9916992187500f,
(float16_t)0.1269531250000f,(float16_t)0.9916992187500f,
(float16_t)0.1254882812500f,(float16_t)0.9921875000000f,
(float16_t)0.1239624023438f,(float16_t)0.9921875000000f,
(float16_t)0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)0.1209106445312f,(float16_t)0.9926757812500f,
(float16_t)0.1193847656250f,(float16_t)0.9926757812500f,
(float16_t)0.1178588867188f,(float16_t)0.9931640625000f,
(float16_t)0.1163330078125f,(float16_t)0.9931640625000f,
(float16_t)0.1148071289062f,(float16_t)0.9931640625000f,
(float16_t)0.1132812500000f,(float16_t)0.9936523437500f,
(float16_t)0.1117553710938f,(float16_t)0.9936523437500f,
(float16_t)0.1102294921875f,(float16_t)0.9941406250000f,
(float16_t)0.1087036132812f,(float16_t)0.9941406250000f,
(float16_t)0.1071777343750f,(float16_t)0.9941406250000f,
(float16_t)0.1056518554688f,(float16_t)0.9946289062500f,
(float16_t)0.1041259765625f,(float16_t)0.9946289062500f,
(float16_t)0.1026000976562f,(float16_t)0.9946289062500f,
(float16_t)0.1010742187500f,(float16_t)0.9951171875000f,
(float16_t)0.0995483398438f,(float16_t)0.9951171875000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0964965820312f,(float16_t)0.9951171875000f,
(float16_t)0.0949707031250f,(float16_t)0.9956054687500f,
(float16_t)0.0934448242188f,(float16_t)0.9956054687500f,
(float16_t)0.0919189453125f,(float16_t)0.9956054687500f,
(float16_t)0.0903930664062f,(float16_t)0.9960937500000f,
(float16_t)0.0888671875000f,(float16_t)0.9960937500000f,
(float16_t)0.0873413085938f,(float16_t)0.9960937500000f,
(float16_t)0.0858154296875f,(float16_t)0.9960937500000f,
(float16_t)0.0842895507812f,(float16_t)0.9965820312500f,
(float16_t)0.0827636718750f,(float16_t)0.9965820312500f,
(float16_t)0.0812377929688f,(float16_t)0.9965820312500f,
(float16_t)0.0797119140625f,(float16_t)0.9965820312500f,
(float16_t)0.0781250000000f,(float16_t)0.9970703125000f,
(float16_t)0.0765991210938f,(float16_t)0.9970703125000f,
(float16_t)0.0750732421875f,(float16_t)0.9970703125000f,
(float16_t)0.0735473632812f,(float16_t)0.9970703125000f,
(float16_t)0.0720214843750f,(float16_t)0.9975585937500f,
(float16_t)0.0704956054688f,(float16_t)0.9975585937500f,
(float16_t)0.0689697265625f,(float16_t)0.9975585937500f,
(float16_t)0.0674438476562f,(float16_t)0.9975585937500f,
(float16_t)0.0659179687500f,(float16_t)0.9980468750000f,
(float16_t)0.0643920898438f,(float16_t)0.9980468750000f,
(float16_t)0.0628662109375f,(float16_t)0.9980468750000f,
(float16_t)0.0613098144531f,(float16_t)0.9980468750000f,
(float16_t)0.0597839355469f,(float16_t)0.9980468750000f,
(float16_t)0.0582580566406f,(float16_t)0.9985351562500f,
(float16_t)0.0567321777344f,(float16_t)0.9985351562500f,
(float16_t)0.0552062988281f,(float16_t)0.9985351562500f,
(float16_t)0.0536499023438f,(float16_t)0.9985351562500f,
(float16_t)0.0521240234375f,(float16_t)0.9985351562500f,
(float16_t)0.0505981445312f,(float16_t)0.9985351562500f,
(float16_t)0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)0.0475463867188f,(float16_t)0.9990234375000f,
(float16_t)0.0459899902344f,(float16_t)0.9990234375000f,
(float16_t)0.0444641113281f,(float16_t)0.9990234375000f,
(float16_t)0.0429382324219f,(float16_t)0.9990234375000f,
(float16_t)0.0414123535156f,(float16_t)0.9990234375000f,
(float16_t)0.0398864746094f,(float16_t)0.9990234375000f,
(float16_t)0.0383300781250f,(float16_t)0.9990234375000f,
(float16_t)0.0368041992188f,(float16_t)0.9995117187500f,
(float16_t)0.0352783203125f,(float16_t)0.9995117187500f,
(float16_t)0.0337524414062f,(float16_t)0.9995117187500f,
(float16_t)0.0321960449219f,(float16_t)0.9995117187500f,
(float16_t)0.0306701660156f,(float16_t)0.9995117187500f,
(float16_t)0.0291442871094f,(float16_t)0.9995117187500f,
(float16_t)0.0276031494141f,(float16_t)0.9995117187500f,
(float16_t)0.0260772705078f,(float16_t)0.9995117187500f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)0.0230102539062f,(float16_t)0.9995117187500f,
(float16_t)0.0214691162109f,(float16_t)1.0000000000000f,
(float16_t)0.0199432373047f,(float16_t)1.0000000000000f,
(float16_t)0.0184020996094f,(float16_t)1.0000000000000f,
(float16_t)0.0168762207031f,(float16_t)1.0000000000000f,
(float16_t)0.0153427124023f,(float16_t)1.0000000000000f,
(float16_t)0.0138015747070f,(float16_t)1.0000000000000f,
(float16_t)0.0122680664062f,(float16_t)1.0000000000000f,
(float16_t)0.0107345581055f,(float16_t)1.0000000000000f,
(float16_t)0.0092010498047f,(float16_t)1.0000000000000f,
(float16_t)0.0076713562012f,(float16_t)1.0000000000000f,
(float16_t)0.0061340332031f,(float16_t)1.0000000000000f,
(float16_t)0.0046005249023f,(float16_t)1.0000000000000f,
(float16_t)0.0030670166016f,(float16_t)1.0000000000000f,
(float16_t)0.0015335083008f,(float16_t)1.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0061340332031f,
(float16_t)1.0000000000000f,(float16_t)0.0122680664062f,
(float16_t)1.0000000000000f,(float16_t)0.0184020996094f,
(float16_t)0.9995117187500f,(float16_t)0.0245361328125f,
(float16_t)0.9995117187500f,(float16_t)0.0306701660156f,
(float16_t)0.9995117187500f,(float16_t)0.0368041992188f,
(float16_t)0.9990234375000f,(float16_t)0.0429382324219f,
(float16_t)0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)0.9985351562500f,(float16_t)0.0552062988281f,
(float16_t)0.9980468750000f,(float16_t)0.0613098144531f,
(float16_t)0.9975585937500f,(float16_t)0.0674438476562f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9965820312500f,(float16_t)0.0797119140625f,
(float16_t)0.9960937500000f,(float16_t)0.0858154296875f,
(float16_t)0.9956054687500f,(float16_t)0.0919189453125f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9946289062500f,(float16_t)0.1041259765625f,
(float16_t)0.9941406250000f,(float16_t)0.1102294921875f,
(float16_t)0.9931640625000f,(float16_t)0.1163330078125f,
(float16_t)0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)0.9916992187500f,(float16_t)0.1285400390625f,
(float16_t)0.9907226562500f,(float16_t)0.1345214843750f,
(float16_t)0.9902343750000f,(float16_t)0.1406250000000f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9882812500000f,(float16_t)0.1528320312500f,
(float16_t)0.9873046875000f,(float16_t)0.1588134765625f,
(float16_t)0.9863281250000f,(float16_t)0.1649169921875f,
(float16_t)0.9853515625000f,(float16_t)0.1710205078125f,
(float16_t)0.9843750000000f,(float16_t)0.1770019531250f,
(float16_t)0.9829101562500f,(float16_t)0.1829833984375f,
(float16_t)0.9819335937500f,(float16_t)0.1890869140625f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9794921875000f,(float16_t)0.2010498046875f,
(float16_t)0.9785156250000f,(float16_t)0.2071533203125f,
(float16_t)0.9770507812500f,(float16_t)0.2131347656250f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9741210937500f,(float16_t)0.2250976562500f,
(float16_t)0.9731445312500f,(float16_t)0.2310791015625f,
(float16_t)0.9716796875000f,(float16_t)0.2370605468750f,
(float16_t)0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)0.9687500000000f,(float16_t)0.2489013671875f,
(float16_t)0.9667968750000f,(float16_t)0.2548828125000f,
(float16_t)0.9653320312500f,(float16_t)0.2607421875000f,
(float16_t)0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)0.9619140625000f,(float16_t)0.2727050781250f,
(float16_t)0.9604492187500f,(float16_t)0.2785644531250f,
(float16_t)0.9584960937500f,(float16_t)0.2844238281250f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9550781250000f,(float16_t)0.2961425781250f,
(float16_t)0.9531250000000f,(float16_t)0.3020019531250f,
(float16_t)0.9516601562500f,(float16_t)0.3078613281250f,
(float16_t)0.9497070312500f,(float16_t)0.3137207031250f,
(float16_t)0.9477539062500f,(float16_t)0.3195800781250f,
(float16_t)0.9458007812500f,(float16_t)0.3251953125000f,
(float16_t)0.9433593750000f,(float16_t)0.3310546875000f,
(float16_t)0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)0.9394531250000f,(float16_t)0.3427734375000f,
(float16_t)0.9375000000000f,(float16_t)0.3483886718750f,
(float16_t)0.9350585937500f,(float16_t)0.3542480468750f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9306640625000f,(float16_t)0.3657226562500f,
(float16_t)0.9287109375000f,(float16_t)0.3713378906250f,
(float16_t)0.9262695312500f,(float16_t)0.3769531250000f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.9213867187500f,(float16_t)0.3884277343750f,
(float16_t)0.9189453125000f,(float16_t)0.3940429687500f,
(float16_t)0.9165039062500f,(float16_t)0.3996582031250f,
(float16_t)0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)0.9116210937500f,(float16_t)0.4108886718750f,
(float16_t)0.9091796875000f,(float16_t)0.4165039062500f,
(float16_t)0.9067382812500f,(float16_t)0.4221191406250f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.9013671875000f,(float16_t)0.4331054687500f,
(float16_t)0.8984375000000f,(float16_t)0.4387207031250f,
(float16_t)0.8959960937500f,(float16_t)0.4440917968750f,
(float16_t)0.8930664062500f,(float16_t)0.4497070312500f,
(float16_t)0.8906250000000f,(float16_t)0.4550781250000f,
(float16_t)0.8876953125000f,(float16_t)0.4604492187500f,
(float16_t)0.8847656250000f,(float16_t)0.4660644531250f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8789062500000f,(float16_t)0.4768066406250f,
(float16_t)0.8759765625000f,(float16_t)0.4821777343750f,
(float16_t)0.8730468750000f,(float16_t)0.4875488281250f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8671875000000f,(float16_t)0.4982910156250f,
(float16_t)0.8637695312500f,(float16_t)0.5034179687500f,
(float16_t)0.8608398437500f,(float16_t)0.5087890625000f,
(float16_t)0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)0.8544921875000f,(float16_t)0.5195312500000f,
(float16_t)0.8515625000000f,(float16_t)0.5244140625000f,
(float16_t)0.8481445312500f,(float16_t)0.5297851562500f,
(float16_t)0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)0.8417968750000f,(float16_t)0.5400390625000f,
(float16_t)0.8383789062500f,(float16_t)0.5454101562500f,
(float16_t)0.8349609375000f,(float16_t)0.5502929687500f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8281250000000f,(float16_t)0.5605468750000f,
(float16_t)0.8247070312500f,(float16_t)0.5659179687500f,
(float16_t)0.8212890625000f,(float16_t)0.5708007812500f,
(float16_t)0.8173828125000f,(float16_t)0.5756835937500f,
(float16_t)0.8139648437500f,(float16_t)0.5810546875000f,
(float16_t)0.8105468750000f,(float16_t)0.5859375000000f,
(float16_t)0.8066406250000f,(float16_t)0.5908203125000f,
(float16_t)0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)0.7993164062500f,(float16_t)0.6005859375000f,
(float16_t)0.7958984375000f,(float16_t)0.6054687500000f,
(float16_t)0.7919921875000f,(float16_t)0.6103515625000f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7846679687500f,(float16_t)0.6201171875000f,
(float16_t)0.7807617187500f,(float16_t)0.6250000000000f,
(float16_t)0.7768554687500f,(float16_t)0.6293945312500f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7690429687500f,(float16_t)0.6391601562500f,
(float16_t)0.7651367187500f,(float16_t)0.6440429687500f,
(float16_t)0.7612304687500f,(float16_t)0.6484375000000f,
(float16_t)0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)0.7534179687500f,(float16_t)0.6577148437500f,
(float16_t)0.7490234375000f,(float16_t)0.6625976562500f,
(float16_t)0.7451171875000f,(float16_t)0.6669921875000f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7368164062500f,(float16_t)0.6762695312500f,
(float16_t)0.7324218750000f,(float16_t)0.6806640625000f,
(float16_t)0.7285156250000f,(float16_t)0.6850585937500f,
(float16_t)0.7241210937500f,(float16_t)0.6894531250000f,
(float16_t)0.7202148437500f,(float16_t)0.6938476562500f,
(float16_t)0.7158203125000f,(float16_t)0.6982421875000f,
(float16_t)0.7114257812500f,(float16_t)0.7026367187500f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.7026367187500f,(float16_t)0.7114257812500f,
(float16_t)0.6982421875000f,(float16_t)0.7158203125000f,
(float16_t)0.6938476562500f,(float16_t)0.7202148437500f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6850585937500f,(float16_t)0.7285156250000f,
(float16_t)0.6806640625000f,(float16_t)0.7324218750000f,
(float16_t)0.6762695312500f,(float16_t)0.7368164062500f,
(float16_t)0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)0.6669921875000f,(float16_t)0.7451171875000f,
(float16_t)0.6625976562500f,(float16_t)0.7490234375000f,
(float16_t)0.6577148437500f,(float16_t)0.7534179687500f,
(float16_t)0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)0.6484375000000f,(float16_t)0.7612304687500f,
(float16_t)0.6440429687500f,(float16_t)0.7651367187500f,
(float16_t)0.6391601562500f,(float16_t)0.7690429687500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.6293945312500f,(float16_t)0.7768554687500f,
(float16_t)0.6250000000000f,(float16_t)0.7807617187500f,
(float16_t)0.6201171875000f,(float16_t)0.7846679687500f,
(float16_t)0.6152343750000f,(float16_t)0.7885742187500f,
(float16_t)0.6103515625000f,(float16_t)0.7919921875000f,
(float16_t)0.6054687500000f,(float16_t)0.7958984375000f,
(float16_t)0.6005859375000f,(float16_t)0.7993164062500f,
(float16_t)0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)0.5908203125000f,(float16_t)0.8066406250000f,
(float16_t)0.5859375000000f,(float16_t)0.8105468750000f,
(float16_t)0.5810546875000f,(float16_t)0.8139648437500f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5708007812500f,(float16_t)0.8212890625000f,
(float16_t)0.5659179687500f,(float16_t)0.8247070312500f,
(float16_t)0.5605468750000f,(float16_t)0.8281250000000f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.5502929687500f,(float16_t)0.8349609375000f,
(float16_t)0.5454101562500f,(float16_t)0.8383789062500f,
(float16_t)0.5400390625000f,(float16_t)0.8417968750000f,
(float16_t)0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)0.5297851562500f,(float16_t)0.8481445312500f,
(float16_t)0.5244140625000f,(float16_t)0.8515625000000f,
(float16_t)0.5195312500000f,(float16_t)0.8544921875000f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.5087890625000f,(float16_t)0.8608398437500f,
(float16_t)0.5034179687500f,(float16_t)0.8637695312500f,
(float16_t)0.4982910156250f,(float16_t)0.8671875000000f,
(float16_t)0.4929199218750f,(float16_t)0.8701171875000f,
(float16_t)0.4875488281250f,(float16_t)0.8730468750000f,
(float16_t)0.4821777343750f,(float16_t)0.8759765625000f,
(float16_t)0.4768066406250f,(float16_t)0.8789062500000f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.4660644531250f,(float16_t)0.8847656250000f,
(float16_t)0.4604492187500f,(float16_t)0.8876953125000f,
(float16_t)0.4550781250000f,(float16_t)0.8906250000000f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.4440917968750f,(float16_t)0.8959960937500f,
(float16_t)0.4387207031250f,(float16_t)0.8984375000000f,
(float16_t)0.4331054687500f,(float16_t)0.9013671875000f,
(float16_t)0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)0.4221191406250f,(float16_t)0.9067382812500f,
(float16_t)0.4165039062500f,(float16_t)0.9091796875000f,
(float16_t)0.4108886718750f,(float16_t)0.9116210937500f,
(float16_t)0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)0.3996582031250f,(float16_t)0.9165039062500f,
(float16_t)0.3940429687500f,(float16_t)0.9189453125000f,
(float16_t)0.3884277343750f,(float16_t)0.9213867187500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3769531250000f,(float16_t)0.9262695312500f,
(float16_t)0.3713378906250f,(float16_t)0.9287109375000f,
(float16_t)0.3657226562500f,(float16_t)0.9306640625000f,
(float16_t)0.3598632812500f,(float16_t)0.9331054687500f,
(float16_t)0.3542480468750f,(float16_t)0.9350585937500f,
(float16_t)0.3483886718750f,(float16_t)0.9375000000000f,
(float16_t)0.3427734375000f,(float16_t)0.9394531250000f,
(float16_t)0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)0.3310546875000f,(float16_t)0.9433593750000f,
(float16_t)0.3251953125000f,(float16_t)0.9458007812500f,
(float16_t)0.3195800781250f,(float16_t)0.9477539062500f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.3078613281250f,(float16_t)0.9516601562500f,
(float16_t)0.3020019531250f,(float16_t)0.9531250000000f,
(float16_t)0.2961425781250f,(float16_t)0.9550781250000f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.2844238281250f,(float16_t)0.9584960937500f,
(float16_t)0.2785644531250f,(float16_t)0.9604492187500f,
(float16_t)0.2727050781250f,(float16_t)0.9619140625000f,
(float16_t)0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)0.2607421875000f,(float16_t)0.9653320312500f,
(float16_t)0.2548828125000f,(float16_t)0.9667968750000f,
(float16_t)0.2489013671875f,(float16_t)0.9687500000000f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.2370605468750f,(float16_t)0.9716796875000f,
(float16_t)0.2310791015625f,(float16_t)0.9731445312500f,
(float16_t)0.2250976562500f,(float16_t)0.9741210937500f,
(float16_t)0.2191162109375f,(float16_t)0.9755859375000f,
(float16_t)0.2131347656250f,(float16_t)0.9770507812500f,
(float16_t)0.2071533203125f,(float16_t)0.9785156250000f,
(float16_t)0.2010498046875f,(float16_t)0.9794921875000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.1890869140625f,(float16_t)0.9819335937500f,
(float16_t)0.1829833984375f,(float16_t)0.9829101562500f,
(float16_t)0.1770019531250f,(float16_t)0.9843750000000f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.1649169921875f,(float16_t)0.9863281250000f,
(float16_t)0.1588134765625f,(float16_t)0.9873046875000f,
(float16_t)0.1528320312500f,(float16_t)0.9882812500000f,
(float16_t)0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)0.1406250000000f,(float16_t)0.9902343750000f,
(float16_t)0.1345214843750f,(float16_t)0.9907226562500f,
(float16_t)0.1285400390625f,(float16_t)0.9916992187500f,
(float16_t)0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)0.1163330078125f,(float16_t)0.9931640625000f,
(float16_t)0.1102294921875f,(float16_t)0.9941406250000f,
(float16_t)0.1041259765625f,(float16_t)0.9946289062500f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0919189453125f,(float16_t)0.9956054687500f,
(float16_t)0.0858154296875f,(float16_t)0.9960937500000f,
(float16_t)0.0797119140625f,(float16_t)0.9965820312500f,
(float16_t)0.0735473632812f,(float16_t)0.9970703125000f,
(float16_t)0.0674438476562f,(float16_t)0.9975585937500f,
(float16_t)0.0613098144531f,(float16_t)0.9980468750000f,
(float16_t)0.0552062988281f,(float16_t)0.9985351562500f,
(float16_t)0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)0.0429382324219f,(float16_t)0.9990234375000f,
(float16_t)0.0368041992188f,(float16_t)0.9995117187500f,
(float16_t)0.0306701660156f,(float16_t)0.9995117187500f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)0.0184020996094f,(float16_t)1.0000000000000f,
(float16_t)0.0122680664062f,(float16_t)1.0000000000000f,
(float16_t)0.0061340332031f,(float16_t)1.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9995117187500f,(float16_t)0.0245361328125f,
(float16_t)0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9853515625000f,(float16_t)0.1710205078125f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9497070312500f,(float16_t)0.3137207031250f,
(float16_t)0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.8930664062500f,(float16_t)0.4497070312500f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8173828125000f,(float16_t)0.5756835937500f,
(float16_t)0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7241210937500f,(float16_t)0.6894531250000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.6152343750000f,(float16_t)0.7885742187500f,
(float16_t)0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.4929199218750f,(float16_t)0.8701171875000f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3598632812500f,(float16_t)0.9331054687500f,
(float16_t)0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.2191162109375f,(float16_t)0.9755859375000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0735473632812f,(float16_t)0.9970703125000f,
(float16_t)0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,};

float16_t rearranged_twiddle_stride2_4096_f16[2728]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0030670166016f,
(float16_t)1.0000000000000f,(float16_t)0.0061340332031f,
(float16_t)1.0000000000000f,(float16_t)0.0092010498047f,
(float16_t)1.0000000000000f,(float16_t)0.0122680664062f,
(float16_t)1.0000000000000f,(float16_t)0.0153427124023f,
(float16_t)1.0000000000000f,(float16_t)0.0184020996094f,
(float16_t)1.0000000000000f,(float16_t)0.0214691162109f,
(float16_t)0.9995117187500f,(float16_t)0.0245361328125f,
(float16_t)0.9995117187500f,(float16_t)0.0276031494141f,
(float16_t)0.9995117187500f,(float16_t)0.0306701660156f,
(float16_t)0.9995117187500f,(float16_t)0.0337524414062f,
(float16_t)0.9995117187500f,(float16_t)0.0368041992188f,
(float16_t)0.9990234375000f,(float16_t)0.0398864746094f,
(float16_t)0.9990234375000f,(float16_t)0.0429382324219f,
(float16_t)0.9990234375000f,(float16_t)0.0459899902344f,
(float16_t)0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)0.9985351562500f,(float16_t)0.0521240234375f,
(float16_t)0.9985351562500f,(float16_t)0.0552062988281f,
(float16_t)0.9985351562500f,(float16_t)0.0582580566406f,
(float16_t)0.9980468750000f,(float16_t)0.0613098144531f,
(float16_t)0.9980468750000f,(float16_t)0.0643920898438f,
(float16_t)0.9975585937500f,(float16_t)0.0674438476562f,
(float16_t)0.9975585937500f,(float16_t)0.0704956054688f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9970703125000f,(float16_t)0.0765991210938f,
(float16_t)0.9965820312500f,(float16_t)0.0797119140625f,
(float16_t)0.9965820312500f,(float16_t)0.0827636718750f,
(float16_t)0.9960937500000f,(float16_t)0.0858154296875f,
(float16_t)0.9960937500000f,(float16_t)0.0888671875000f,
(float16_t)0.9956054687500f,(float16_t)0.0919189453125f,
(float16_t)0.9956054687500f,(float16_t)0.0949707031250f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9951171875000f,(float16_t)0.1010742187500f,
(float16_t)0.9946289062500f,(float16_t)0.1041259765625f,
(float16_t)0.9941406250000f,(float16_t)0.1071777343750f,
(float16_t)0.9941406250000f,(float16_t)0.1102294921875f,
(float16_t)0.9936523437500f,(float16_t)0.1132812500000f,
(float16_t)0.9931640625000f,(float16_t)0.1163330078125f,
(float16_t)0.9926757812500f,(float16_t)0.1193847656250f,
(float16_t)0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)0.9921875000000f,(float16_t)0.1254882812500f,
(float16_t)0.9916992187500f,(float16_t)0.1285400390625f,
(float16_t)0.9912109375000f,(float16_t)0.1315917968750f,
(float16_t)0.9907226562500f,(float16_t)0.1345214843750f,
(float16_t)0.9907226562500f,(float16_t)0.1375732421875f,
(float16_t)0.9902343750000f,(float16_t)0.1406250000000f,
(float16_t)0.9897460937500f,(float16_t)0.1436767578125f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9887695312500f,(float16_t)0.1497802734375f,
(float16_t)0.9882812500000f,(float16_t)0.1528320312500f,
(float16_t)0.9877929687500f,(float16_t)0.1558837890625f,
(float16_t)0.9873046875000f,(float16_t)0.1588134765625f,
(float16_t)0.9868164062500f,(float16_t)0.1618652343750f,
(float16_t)0.9863281250000f,(float16_t)0.1649169921875f,
(float16_t)0.9858398437500f,(float16_t)0.1679687500000f,
(float16_t)0.9853515625000f,(float16_t)0.1710205078125f,
(float16_t)0.9848632812500f,(float16_t)0.1739501953125f,
(float16_t)0.9843750000000f,(float16_t)0.1770019531250f,
(float16_t)0.9838867187500f,(float16_t)0.1800537109375f,
(float16_t)0.9829101562500f,(float16_t)0.1829833984375f,
(float16_t)0.9824218750000f,(float16_t)0.1860351562500f,
(float16_t)0.9819335937500f,(float16_t)0.1890869140625f,
(float16_t)0.9814453125000f,(float16_t)0.1921386718750f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9799804687500f,(float16_t)0.1981201171875f,
(float16_t)0.9794921875000f,(float16_t)0.2010498046875f,
(float16_t)0.9790039062500f,(float16_t)0.2041015625000f,
(float16_t)0.9785156250000f,(float16_t)0.2071533203125f,
(float16_t)0.9775390625000f,(float16_t)0.2100830078125f,
(float16_t)0.9770507812500f,(float16_t)0.2131347656250f,
(float16_t)0.9765625000000f,(float16_t)0.2160644531250f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9750976562500f,(float16_t)0.2220458984375f,
(float16_t)0.9741210937500f,(float16_t)0.2250976562500f,
(float16_t)0.9736328125000f,(float16_t)0.2280273437500f,
(float16_t)0.9731445312500f,(float16_t)0.2310791015625f,
(float16_t)0.9721679687500f,(float16_t)0.2340087890625f,
(float16_t)0.9716796875000f,(float16_t)0.2370605468750f,
(float16_t)0.9707031250000f,(float16_t)0.2399902343750f,
(float16_t)0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)0.9692382812500f,(float16_t)0.2459716796875f,
(float16_t)0.9687500000000f,(float16_t)0.2489013671875f,
(float16_t)0.9677734375000f,(float16_t)0.2519531250000f,
(float16_t)0.9667968750000f,(float16_t)0.2548828125000f,
(float16_t)0.9663085937500f,(float16_t)0.2578125000000f,
(float16_t)0.9653320312500f,(float16_t)0.2607421875000f,
(float16_t)0.9643554687500f,(float16_t)0.2636718750000f,
(float16_t)0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)0.9628906250000f,(float16_t)0.2697753906250f,
(float16_t)0.9619140625000f,(float16_t)0.2727050781250f,
(float16_t)0.9614257812500f,(float16_t)0.2756347656250f,
(float16_t)0.9604492187500f,(float16_t)0.2785644531250f,
(float16_t)0.9594726562500f,(float16_t)0.2814941406250f,
(float16_t)0.9584960937500f,(float16_t)0.2844238281250f,
(float16_t)0.9580078125000f,(float16_t)0.2873535156250f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9560546875000f,(float16_t)0.2932128906250f,
(float16_t)0.9550781250000f,(float16_t)0.2961425781250f,
(float16_t)0.9541015625000f,(float16_t)0.2990722656250f,
(float16_t)0.9531250000000f,(float16_t)0.3020019531250f,
(float16_t)0.9521484375000f,(float16_t)0.3049316406250f,
(float16_t)0.9516601562500f,(float16_t)0.3078613281250f,
(float16_t)0.9506835937500f,(float16_t)0.3107910156250f,
(float16_t)0.9497070312500f,(float16_t)0.3137207031250f,
(float16_t)0.9487304687500f,(float16_t)0.3166503906250f,
(float16_t)0.9477539062500f,(float16_t)0.3195800781250f,
(float16_t)0.9467773437500f,(float16_t)0.3225097656250f,
(float16_t)0.9458007812500f,(float16_t)0.3251953125000f,
(float16_t)0.9448242187500f,(float16_t)0.3281250000000f,
(float16_t)0.9433593750000f,(float16_t)0.3310546875000f,
(float16_t)0.9423828125000f,(float16_t)0.3339843750000f,
(float16_t)0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)0.9404296875000f,(float16_t)0.3398437500000f,
(float16_t)0.9394531250000f,(float16_t)0.3427734375000f,
(float16_t)0.9384765625000f,(float16_t)0.3454589843750f,
(float16_t)0.9375000000000f,(float16_t)0.3483886718750f,
(float16_t)0.9360351562500f,(float16_t)0.3513183593750f,
(float16_t)0.9350585937500f,(float16_t)0.3542480468750f,
(float16_t)0.9340820312500f,(float16_t)0.3569335937500f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9316406250000f,(float16_t)0.3627929687500f,
(float16_t)0.9306640625000f,(float16_t)0.3657226562500f,
(float16_t)0.9296875000000f,(float16_t)0.3684082031250f,
(float16_t)0.9287109375000f,(float16_t)0.3713378906250f,
(float16_t)0.9272460937500f,(float16_t)0.3742675781250f,
(float16_t)0.9262695312500f,(float16_t)0.3769531250000f,
(float16_t)0.9252929687500f,(float16_t)0.3798828125000f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.9228515625000f,(float16_t)0.3854980468750f,
(float16_t)0.9213867187500f,(float16_t)0.3884277343750f,
(float16_t)0.9204101562500f,(float16_t)0.3911132812500f,
(float16_t)0.9189453125000f,(float16_t)0.3940429687500f,
(float16_t)0.9179687500000f,(float16_t)0.3967285156250f,
(float16_t)0.9165039062500f,(float16_t)0.3996582031250f,
(float16_t)0.9155273437500f,(float16_t)0.4023437500000f,
(float16_t)0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)0.9130859375000f,(float16_t)0.4079589843750f,
(float16_t)0.9116210937500f,(float16_t)0.4108886718750f,
(float16_t)0.9106445312500f,(float16_t)0.4135742187500f,
(float16_t)0.9091796875000f,(float16_t)0.4165039062500f,
(float16_t)0.9077148437500f,(float16_t)0.4191894531250f,
(float16_t)0.9067382812500f,(float16_t)0.4221191406250f,
(float16_t)0.9052734375000f,(float16_t)0.4248046875000f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.9028320312500f,(float16_t)0.4304199218750f,
(float16_t)0.9013671875000f,(float16_t)0.4331054687500f,
(float16_t)0.8999023437500f,(float16_t)0.4357910156250f,
(float16_t)0.8984375000000f,(float16_t)0.4387207031250f,
(float16_t)0.8974609375000f,(float16_t)0.4414062500000f,
(float16_t)0.8959960937500f,(float16_t)0.4440917968750f,
(float16_t)0.8945312500000f,(float16_t)0.4467773437500f,
(float16_t)0.8930664062500f,(float16_t)0.4497070312500f,
(float16_t)0.8916015625000f,(float16_t)0.4523925781250f,
(float16_t)0.8906250000000f,(float16_t)0.4550781250000f,
(float16_t)0.8891601562500f,(float16_t)0.4577636718750f,
(float16_t)0.8876953125000f,(float16_t)0.4604492187500f,
(float16_t)0.8862304687500f,(float16_t)0.4633789062500f,
(float16_t)0.8847656250000f,(float16_t)0.4660644531250f,
(float16_t)0.8833007812500f,(float16_t)0.4687500000000f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8803710937500f,(float16_t)0.4741210937500f,
(float16_t)0.8789062500000f,(float16_t)0.4768066406250f,
(float16_t)0.8774414062500f,(float16_t)0.4794921875000f,
(float16_t)0.8759765625000f,(float16_t)0.4821777343750f,
(float16_t)0.8745117187500f,(float16_t)0.4848632812500f,
(float16_t)0.8730468750000f,(float16_t)0.4875488281250f,
(float16_t)0.8715820312500f,(float16_t)0.4902343750000f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8686523437500f,(float16_t)0.4956054687500f,
(float16_t)0.8671875000000f,(float16_t)0.4982910156250f,
(float16_t)0.8657226562500f,(float16_t)0.5009765625000f,
(float16_t)0.8637695312500f,(float16_t)0.5034179687500f,
(float16_t)0.8623046875000f,(float16_t)0.5063476562500f,
(float16_t)0.8608398437500f,(float16_t)0.5087890625000f,
(float16_t)0.8593750000000f,(float16_t)0.5112304687500f,
(float16_t)0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)0.8559570312500f,(float16_t)0.5166015625000f,
(float16_t)0.8544921875000f,(float16_t)0.5195312500000f,
(float16_t)0.8530273437500f,(float16_t)0.5219726562500f,
(float16_t)0.8515625000000f,(float16_t)0.5244140625000f,
(float16_t)0.8496093750000f,(float16_t)0.5273437500000f,
(float16_t)0.8481445312500f,(float16_t)0.5297851562500f,
(float16_t)0.8466796875000f,(float16_t)0.5322265625000f,
(float16_t)0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)0.8432617187500f,(float16_t)0.5375976562500f,
(float16_t)0.8417968750000f,(float16_t)0.5400390625000f,
(float16_t)0.8398437500000f,(float16_t)0.5429687500000f,
(float16_t)0.8383789062500f,(float16_t)0.5454101562500f,
(float16_t)0.8364257812500f,(float16_t)0.5478515625000f,
(float16_t)0.8349609375000f,(float16_t)0.5502929687500f,
(float16_t)0.8330078125000f,(float16_t)0.5532226562500f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8295898437500f,(float16_t)0.5581054687500f,
(float16_t)0.8281250000000f,(float16_t)0.5605468750000f,
(float16_t)0.8261718750000f,(float16_t)0.5629882812500f,
(float16_t)0.8247070312500f,(float16_t)0.5659179687500f,
(float16_t)0.8227539062500f,(float16_t)0.5683593750000f,
(float16_t)0.8212890625000f,(float16_t)0.5708007812500f,
(float16_t)0.8193359375000f,(float16_t)0.5732421875000f,
(float16_t)0.8173828125000f,(float16_t)0.5756835937500f,
(float16_t)0.8159179687500f,(float16_t)0.5781250000000f,
(float16_t)0.8139648437500f,(float16_t)0.5810546875000f,
(float16_t)0.8120117187500f,(float16_t)0.5834960937500f,
(float16_t)0.8105468750000f,(float16_t)0.5859375000000f,
(float16_t)0.8085937500000f,(float16_t)0.5883789062500f,
(float16_t)0.8066406250000f,(float16_t)0.5908203125000f,
(float16_t)0.8051757812500f,(float16_t)0.5932617187500f,
(float16_t)0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)0.8012695312500f,(float16_t)0.5981445312500f,
(float16_t)0.7993164062500f,(float16_t)0.6005859375000f,
(float16_t)0.7978515625000f,(float16_t)0.6030273437500f,
(float16_t)0.7958984375000f,(float16_t)0.6054687500000f,
(float16_t)0.7939453125000f,(float16_t)0.6079101562500f,
(float16_t)0.7919921875000f,(float16_t)0.6103515625000f,
(float16_t)0.7900390625000f,(float16_t)0.6127929687500f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7866210937500f,(float16_t)0.6176757812500f,
(float16_t)0.7846679687500f,(float16_t)0.6201171875000f,
(float16_t)0.7827148437500f,(float16_t)0.6225585937500f,
(float16_t)0.7807617187500f,(float16_t)0.6250000000000f,
(float16_t)0.7788085937500f,(float16_t)0.6274414062500f,
(float16_t)0.7768554687500f,(float16_t)0.6293945312500f,
(float16_t)0.7749023437500f,(float16_t)0.6318359375000f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7709960937500f,(float16_t)0.6367187500000f,
(float16_t)0.7690429687500f,(float16_t)0.6391601562500f,
(float16_t)0.7670898437500f,(float16_t)0.6416015625000f,
(float16_t)0.7651367187500f,(float16_t)0.6440429687500f,
(float16_t)0.7631835937500f,(float16_t)0.6459960937500f,
(float16_t)0.7612304687500f,(float16_t)0.6484375000000f,
(float16_t)0.7592773437500f,(float16_t)0.6508789062500f,
(float16_t)0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)0.7553710937500f,(float16_t)0.6552734375000f,
(float16_t)0.7534179687500f,(float16_t)0.6577148437500f,
(float16_t)0.7509765625000f,(float16_t)0.6601562500000f,
(float16_t)0.7490234375000f,(float16_t)0.6625976562500f,
(float16_t)0.7470703125000f,(float16_t)0.6645507812500f,
(float16_t)0.7451171875000f,(float16_t)0.6669921875000f,
(float16_t)0.7431640625000f,(float16_t)0.6694335937500f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7387695312500f,(float16_t)0.6738281250000f,
(float16_t)0.7368164062500f,(float16_t)0.6762695312500f,
(float16_t)0.7348632812500f,(float16_t)0.6782226562500f,
(float16_t)0.7324218750000f,(float16_t)0.6806640625000f,
(float16_t)0.7304687500000f,(float16_t)0.6826171875000f,
(float16_t)0.7285156250000f,(float16_t)0.6850585937500f,
(float16_t)0.7265625000000f,(float16_t)0.6875000000000f,
(float16_t)0.7241210937500f,(float16_t)0.6894531250000f,
(float16_t)0.7221679687500f,(float16_t)0.6918945312500f,
(float16_t)0.7202148437500f,(float16_t)0.6938476562500f,
(float16_t)0.7177734375000f,(float16_t)0.6962890625000f,
(float16_t)0.7158203125000f,(float16_t)0.6982421875000f,
(float16_t)0.7133789062500f,(float16_t)0.7006835937500f,
(float16_t)0.7114257812500f,(float16_t)0.7026367187500f,
(float16_t)0.7094726562500f,(float16_t)0.7050781250000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.7050781250000f,(float16_t)0.7094726562500f,
(float16_t)0.7026367187500f,(float16_t)0.7114257812500f,
(float16_t)0.7006835937500f,(float16_t)0.7133789062500f,
(float16_t)0.6982421875000f,(float16_t)0.7158203125000f,
(float16_t)0.6962890625000f,(float16_t)0.7177734375000f,
(float16_t)0.6938476562500f,(float16_t)0.7202148437500f,
(float16_t)0.6918945312500f,(float16_t)0.7221679687500f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6875000000000f,(float16_t)0.7265625000000f,
(float16_t)0.6850585937500f,(float16_t)0.7285156250000f,
(float16_t)0.6826171875000f,(float16_t)0.7304687500000f,
(float16_t)0.6806640625000f,(float16_t)0.7324218750000f,
(float16_t)0.6782226562500f,(float16_t)0.7348632812500f,
(float16_t)0.6762695312500f,(float16_t)0.7368164062500f,
(float16_t)0.6738281250000f,(float16_t)0.7387695312500f,
(float16_t)0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)0.6694335937500f,(float16_t)0.7431640625000f,
(float16_t)0.6669921875000f,(float16_t)0.7451171875000f,
(float16_t)0.6645507812500f,(float16_t)0.7470703125000f,
(float16_t)0.6625976562500f,(float16_t)0.7490234375000f,
(float16_t)0.6601562500000f,(float16_t)0.7509765625000f,
(float16_t)0.6577148437500f,(float16_t)0.7534179687500f,
(float16_t)0.6552734375000f,(float16_t)0.7553710937500f,
(float16_t)0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)0.6508789062500f,(float16_t)0.7592773437500f,
(float16_t)0.6484375000000f,(float16_t)0.7612304687500f,
(float16_t)0.6459960937500f,(float16_t)0.7631835937500f,
(float16_t)0.6440429687500f,(float16_t)0.7651367187500f,
(float16_t)0.6416015625000f,(float16_t)0.7670898437500f,
(float16_t)0.6391601562500f,(float16_t)0.7690429687500f,
(float16_t)0.6367187500000f,(float16_t)0.7709960937500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.6318359375000f,(float16_t)0.7749023437500f,
(float16_t)0.6293945312500f,(float16_t)0.7768554687500f,
(float16_t)0.6274414062500f,(float16_t)0.7788085937500f,
(float16_t)0.6250000000000f,(float16_t)0.7807617187500f,
(float16_t)0.6225585937500f,(float16_t)0.7827148437500f,
(float16_t)0.6201171875000f,(float16_t)0.7846679687500f,
(float16_t)0.6176757812500f,(float16_t)0.7866210937500f,
(float16_t)0.6152343750000f,(float16_t)0.7885742187500f,
(float16_t)0.6127929687500f,(float16_t)0.7900390625000f,
(float16_t)0.6103515625000f,(float16_t)0.7919921875000f,
(float16_t)0.6079101562500f,(float16_t)0.7939453125000f,
(float16_t)0.6054687500000f,(float16_t)0.7958984375000f,
(float16_t)0.6030273437500f,(float16_t)0.7978515625000f,
(float16_t)0.6005859375000f,(float16_t)0.7993164062500f,
(float16_t)0.5981445312500f,(float16_t)0.8012695312500f,
(float16_t)0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)0.5932617187500f,(float16_t)0.8051757812500f,
(float16_t)0.5908203125000f,(float16_t)0.8066406250000f,
(float16_t)0.5883789062500f,(float16_t)0.8085937500000f,
(float16_t)0.5859375000000f,(float16_t)0.8105468750000f,
(float16_t)0.5834960937500f,(float16_t)0.8120117187500f,
(float16_t)0.5810546875000f,(float16_t)0.8139648437500f,
(float16_t)0.5781250000000f,(float16_t)0.8159179687500f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5732421875000f,(float16_t)0.8193359375000f,
(float16_t)0.5708007812500f,(float16_t)0.8212890625000f,
(float16_t)0.5683593750000f,(float16_t)0.8227539062500f,
(float16_t)0.5659179687500f,(float16_t)0.8247070312500f,
(float16_t)0.5629882812500f,(float16_t)0.8261718750000f,
(float16_t)0.5605468750000f,(float16_t)0.8281250000000f,
(float16_t)0.5581054687500f,(float16_t)0.8295898437500f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.5532226562500f,(float16_t)0.8330078125000f,
(float16_t)0.5502929687500f,(float16_t)0.8349609375000f,
(float16_t)0.5478515625000f,(float16_t)0.8364257812500f,
(float16_t)0.5454101562500f,(float16_t)0.8383789062500f,
(float16_t)0.5429687500000f,(float16_t)0.8398437500000f,
(float16_t)0.5400390625000f,(float16_t)0.8417968750000f,
(float16_t)0.5375976562500f,(float16_t)0.8432617187500f,
(float16_t)0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)0.5322265625000f,(float16_t)0.8466796875000f,
(float16_t)0.5297851562500f,(float16_t)0.8481445312500f,
(float16_t)0.5273437500000f,(float16_t)0.8496093750000f,
(float16_t)0.5244140625000f,(float16_t)0.8515625000000f,
(float16_t)0.5219726562500f,(float16_t)0.8530273437500f,
(float16_t)0.5195312500000f,(float16_t)0.8544921875000f,
(float16_t)0.5166015625000f,(float16_t)0.8559570312500f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.5112304687500f,(float16_t)0.8593750000000f,
(float16_t)0.5087890625000f,(float16_t)0.8608398437500f,
(float16_t)0.5063476562500f,(float16_t)0.8623046875000f,
(float16_t)0.5034179687500f,(float16_t)0.8637695312500f,
(float16_t)0.5009765625000f,(float16_t)0.8657226562500f,
(float16_t)0.4982910156250f,(float16_t)0.8671875000000f,
(float16_t)0.4956054687500f,(float16_t)0.8686523437500f,
(float16_t)0.4929199218750f,(float16_t)0.8701171875000f,
(float16_t)0.4902343750000f,(float16_t)0.8715820312500f,
(float16_t)0.4875488281250f,(float16_t)0.8730468750000f,
(float16_t)0.4848632812500f,(float16_t)0.8745117187500f,
(float16_t)0.4821777343750f,(float16_t)0.8759765625000f,
(float16_t)0.4794921875000f,(float16_t)0.8774414062500f,
(float16_t)0.4768066406250f,(float16_t)0.8789062500000f,
(float16_t)0.4741210937500f,(float16_t)0.8803710937500f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.4687500000000f,(float16_t)0.8833007812500f,
(float16_t)0.4660644531250f,(float16_t)0.8847656250000f,
(float16_t)0.4633789062500f,(float16_t)0.8862304687500f,
(float16_t)0.4604492187500f,(float16_t)0.8876953125000f,
(float16_t)0.4577636718750f,(float16_t)0.8891601562500f,
(float16_t)0.4550781250000f,(float16_t)0.8906250000000f,
(float16_t)0.4523925781250f,(float16_t)0.8916015625000f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.4467773437500f,(float16_t)0.8945312500000f,
(float16_t)0.4440917968750f,(float16_t)0.8959960937500f,
(float16_t)0.4414062500000f,(float16_t)0.8974609375000f,
(float16_t)0.4387207031250f,(float16_t)0.8984375000000f,
(float16_t)0.4357910156250f,(float16_t)0.8999023437500f,
(float16_t)0.4331054687500f,(float16_t)0.9013671875000f,
(float16_t)0.4304199218750f,(float16_t)0.9028320312500f,
(float16_t)0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)0.4248046875000f,(float16_t)0.9052734375000f,
(float16_t)0.4221191406250f,(float16_t)0.9067382812500f,
(float16_t)0.4191894531250f,(float16_t)0.9077148437500f,
(float16_t)0.4165039062500f,(float16_t)0.9091796875000f,
(float16_t)0.4135742187500f,(float16_t)0.9106445312500f,
(float16_t)0.4108886718750f,(float16_t)0.9116210937500f,
(float16_t)0.4079589843750f,(float16_t)0.9130859375000f,
(float16_t)0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)0.4023437500000f,(float16_t)0.9155273437500f,
(float16_t)0.3996582031250f,(float16_t)0.9165039062500f,
(float16_t)0.3967285156250f,(float16_t)0.9179687500000f,
(float16_t)0.3940429687500f,(float16_t)0.9189453125000f,
(float16_t)0.3911132812500f,(float16_t)0.9204101562500f,
(float16_t)0.3884277343750f,(float16_t)0.9213867187500f,
(float16_t)0.3854980468750f,(float16_t)0.9228515625000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3798828125000f,(float16_t)0.9252929687500f,
(float16_t)0.3769531250000f,(float16_t)0.9262695312500f,
(float16_t)0.3742675781250f,(float16_t)0.9272460937500f,
(float16_t)0.3713378906250f,(float16_t)0.9287109375000f,
(float16_t)0.3684082031250f,(float16_t)0.9296875000000f,
(float16_t)0.3657226562500f,(float16_t)0.9306640625000f,
(float16_t)0.3627929687500f,(float16_t)0.9316406250000f,
(float16_t)0.3598632812500f,(float16_t)0.9331054687500f,
(float16_t)0.3569335937500f,(float16_t)0.9340820312500f,
(float16_t)0.3542480468750f,(float16_t)0.9350585937500f,
(float16_t)0.3513183593750f,(float16_t)0.9360351562500f,
(float16_t)0.3483886718750f,(float16_t)0.9375000000000f,
(float16_t)0.3454589843750f,(float16_t)0.9384765625000f,
(float16_t)0.3427734375000f,(float16_t)0.9394531250000f,
(float16_t)0.3398437500000f,(float16_t)0.9404296875000f,
(float16_t)0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)0.3339843750000f,(float16_t)0.9423828125000f,
(float16_t)0.3310546875000f,(float16_t)0.9433593750000f,
(float16_t)0.3281250000000f,(float16_t)0.9448242187500f,
(float16_t)0.3251953125000f,(float16_t)0.9458007812500f,
(float16_t)0.3225097656250f,(float16_t)0.9467773437500f,
(float16_t)0.3195800781250f,(float16_t)0.9477539062500f,
(float16_t)0.3166503906250f,(float16_t)0.9487304687500f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.3107910156250f,(float16_t)0.9506835937500f,
(float16_t)0.3078613281250f,(float16_t)0.9516601562500f,
(float16_t)0.3049316406250f,(float16_t)0.9521484375000f,
(float16_t)0.3020019531250f,(float16_t)0.9531250000000f,
(float16_t)0.2990722656250f,(float16_t)0.9541015625000f,
(float16_t)0.2961425781250f,(float16_t)0.9550781250000f,
(float16_t)0.2932128906250f,(float16_t)0.9560546875000f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.2873535156250f,(float16_t)0.9580078125000f,
(float16_t)0.2844238281250f,(float16_t)0.9584960937500f,
(float16_t)0.2814941406250f,(float16_t)0.9594726562500f,
(float16_t)0.2785644531250f,(float16_t)0.9604492187500f,
(float16_t)0.2756347656250f,(float16_t)0.9614257812500f,
(float16_t)0.2727050781250f,(float16_t)0.9619140625000f,
(float16_t)0.2697753906250f,(float16_t)0.9628906250000f,
(float16_t)0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)0.2636718750000f,(float16_t)0.9643554687500f,
(float16_t)0.2607421875000f,(float16_t)0.9653320312500f,
(float16_t)0.2578125000000f,(float16_t)0.9663085937500f,
(float16_t)0.2548828125000f,(float16_t)0.9667968750000f,
(float16_t)0.2519531250000f,(float16_t)0.9677734375000f,
(float16_t)0.2489013671875f,(float16_t)0.9687500000000f,
(float16_t)0.2459716796875f,(float16_t)0.9692382812500f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.2399902343750f,(float16_t)0.9707031250000f,
(float16_t)0.2370605468750f,(float16_t)0.9716796875000f,
(float16_t)0.2340087890625f,(float16_t)0.9721679687500f,
(float16_t)0.2310791015625f,(float16_t)0.9731445312500f,
(float16_t)0.2280273437500f,(float16_t)0.9736328125000f,
(float16_t)0.2250976562500f,(float16_t)0.9741210937500f,
(float16_t)0.2220458984375f,(float16_t)0.9750976562500f,
(float16_t)0.2191162109375f,(float16_t)0.9755859375000f,
(float16_t)0.2160644531250f,(float16_t)0.9765625000000f,
(float16_t)0.2131347656250f,(float16_t)0.9770507812500f,
(float16_t)0.2100830078125f,(float16_t)0.9775390625000f,
(float16_t)0.2071533203125f,(float16_t)0.9785156250000f,
(float16_t)0.2041015625000f,(float16_t)0.9790039062500f,
(float16_t)0.2010498046875f,(float16_t)0.9794921875000f,
(float16_t)0.1981201171875f,(float16_t)0.9799804687500f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.1921386718750f,(float16_t)0.9814453125000f,
(float16_t)0.1890869140625f,(float16_t)0.9819335937500f,
(float16_t)0.1860351562500f,(float16_t)0.9824218750000f,
(float16_t)0.1829833984375f,(float16_t)0.9829101562500f,
(float16_t)0.1800537109375f,(float16_t)0.9838867187500f,
(float16_t)0.1770019531250f,(float16_t)0.9843750000000f,
(float16_t)0.1739501953125f,(float16_t)0.9848632812500f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.1679687500000f,(float16_t)0.9858398437500f,
(float16_t)0.1649169921875f,(float16_t)0.9863281250000f,
(float16_t)0.1618652343750f,(float16_t)0.9868164062500f,
(float16_t)0.1588134765625f,(float16_t)0.9873046875000f,
(float16_t)0.1558837890625f,(float16_t)0.9877929687500f,
(float16_t)0.1528320312500f,(float16_t)0.9882812500000f,
(float16_t)0.1497802734375f,(float16_t)0.9887695312500f,
(float16_t)0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)0.1436767578125f,(float16_t)0.9897460937500f,
(float16_t)0.1406250000000f,(float16_t)0.9902343750000f,
(float16_t)0.1375732421875f,(float16_t)0.9907226562500f,
(float16_t)0.1345214843750f,(float16_t)0.9907226562500f,
(float16_t)0.1315917968750f,(float16_t)0.9912109375000f,
(float16_t)0.1285400390625f,(float16_t)0.9916992187500f,
(float16_t)0.1254882812500f,(float16_t)0.9921875000000f,
(float16_t)0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)0.1193847656250f,(float16_t)0.9926757812500f,
(float16_t)0.1163330078125f,(float16_t)0.9931640625000f,
(float16_t)0.1132812500000f,(float16_t)0.9936523437500f,
(float16_t)0.1102294921875f,(float16_t)0.9941406250000f,
(float16_t)0.1071777343750f,(float16_t)0.9941406250000f,
(float16_t)0.1041259765625f,(float16_t)0.9946289062500f,
(float16_t)0.1010742187500f,(float16_t)0.9951171875000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0949707031250f,(float16_t)0.9956054687500f,
(float16_t)0.0919189453125f,(float16_t)0.9956054687500f,
(float16_t)0.0888671875000f,(float16_t)0.9960937500000f,
(float16_t)0.0858154296875f,(float16_t)0.9960937500000f,
(float16_t)0.0827636718750f,(float16_t)0.9965820312500f,
(float16_t)0.0797119140625f,(float16_t)0.9965820312500f,
(float16_t)0.0765991210938f,(float16_t)0.9970703125000f,
(float16_t)0.0735473632812f,(float16_t)0.9970703125000f,
(float16_t)0.0704956054688f,(float16_t)0.9975585937500f,
(float16_t)0.0674438476562f,(float16_t)0.9975585937500f,
(float16_t)0.0643920898438f,(float16_t)0.9980468750000f,
(float16_t)0.0613098144531f,(float16_t)0.9980468750000f,
(float16_t)0.0582580566406f,(float16_t)0.9985351562500f,
(float16_t)0.0552062988281f,(float16_t)0.9985351562500f,
(float16_t)0.0521240234375f,(float16_t)0.9985351562500f,
(float16_t)0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)0.0459899902344f,(float16_t)0.9990234375000f,
(float16_t)0.0429382324219f,(float16_t)0.9990234375000f,
(float16_t)0.0398864746094f,(float16_t)0.9990234375000f,
(float16_t)0.0368041992188f,(float16_t)0.9995117187500f,
(float16_t)0.0337524414062f,(float16_t)0.9995117187500f,
(float16_t)0.0306701660156f,(float16_t)0.9995117187500f,
(float16_t)0.0276031494141f,(float16_t)0.9995117187500f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)0.0214691162109f,(float16_t)1.0000000000000f,
(float16_t)0.0184020996094f,(float16_t)1.0000000000000f,
(float16_t)0.0153427124023f,(float16_t)1.0000000000000f,
(float16_t)0.0122680664062f,(float16_t)1.0000000000000f,
(float16_t)0.0092010498047f,(float16_t)1.0000000000000f,
(float16_t)0.0061340332031f,(float16_t)1.0000000000000f,
(float16_t)0.0030670166016f,(float16_t)1.0000000000000f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.0030670166016f,(float16_t)1.0000000000000f,
(float16_t)-0.0061340332031f,(float16_t)1.0000000000000f,
(float16_t)-0.0092010498047f,(float16_t)1.0000000000000f,
(float16_t)-0.0122680664062f,(float16_t)1.0000000000000f,
(float16_t)-0.0153427124023f,(float16_t)1.0000000000000f,
(float16_t)-0.0184020996094f,(float16_t)1.0000000000000f,
(float16_t)-0.0214691162109f,(float16_t)1.0000000000000f,
(float16_t)-0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)-0.0276031494141f,(float16_t)0.9995117187500f,
(float16_t)-0.0306701660156f,(float16_t)0.9995117187500f,
(float16_t)-0.0337524414062f,(float16_t)0.9995117187500f,
(float16_t)-0.0368041992188f,(float16_t)0.9995117187500f,
(float16_t)-0.0398864746094f,(float16_t)0.9990234375000f,
(float16_t)-0.0429382324219f,(float16_t)0.9990234375000f,
(float16_t)-0.0459899902344f,(float16_t)0.9990234375000f,
(float16_t)-0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)-0.0521240234375f,(float16_t)0.9985351562500f,
(float16_t)-0.0552062988281f,(float16_t)0.9985351562500f,
(float16_t)-0.0582580566406f,(float16_t)0.9985351562500f,
(float16_t)-0.0613098144531f,(float16_t)0.9980468750000f,
(float16_t)-0.0643920898438f,(float16_t)0.9980468750000f,
(float16_t)-0.0674438476562f,(float16_t)0.9975585937500f,
(float16_t)-0.0704956054688f,(float16_t)0.9975585937500f,
(float16_t)-0.0735473632812f,(float16_t)0.9970703125000f,
(float16_t)-0.0765991210938f,(float16_t)0.9970703125000f,
(float16_t)-0.0797119140625f,(float16_t)0.9965820312500f,
(float16_t)-0.0827636718750f,(float16_t)0.9965820312500f,
(float16_t)-0.0858154296875f,(float16_t)0.9960937500000f,
(float16_t)-0.0888671875000f,(float16_t)0.9960937500000f,
(float16_t)-0.0919189453125f,(float16_t)0.9956054687500f,
(float16_t)-0.0949707031250f,(float16_t)0.9956054687500f,
(float16_t)-0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)-0.1010742187500f,(float16_t)0.9951171875000f,
(float16_t)-0.1041259765625f,(float16_t)0.9946289062500f,
(float16_t)-0.1071777343750f,(float16_t)0.9941406250000f,
(float16_t)-0.1102294921875f,(float16_t)0.9941406250000f,
(float16_t)-0.1132812500000f,(float16_t)0.9936523437500f,
(float16_t)-0.1163330078125f,(float16_t)0.9931640625000f,
(float16_t)-0.1193847656250f,(float16_t)0.9926757812500f,
(float16_t)-0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)-0.1254882812500f,(float16_t)0.9921875000000f,
(float16_t)-0.1285400390625f,(float16_t)0.9916992187500f,
(float16_t)-0.1315917968750f,(float16_t)0.9912109375000f,
(float16_t)-0.1345214843750f,(float16_t)0.9907226562500f,
(float16_t)-0.1375732421875f,(float16_t)0.9907226562500f,
(float16_t)-0.1406250000000f,(float16_t)0.9902343750000f,
(float16_t)-0.1436767578125f,(float16_t)0.9897460937500f,
(float16_t)-0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)-0.1497802734375f,(float16_t)0.9887695312500f,
(float16_t)-0.1528320312500f,(float16_t)0.9882812500000f,
(float16_t)-0.1558837890625f,(float16_t)0.9877929687500f,
(float16_t)-0.1588134765625f,(float16_t)0.9873046875000f,
(float16_t)-0.1618652343750f,(float16_t)0.9868164062500f,
(float16_t)-0.1649169921875f,(float16_t)0.9863281250000f,
(float16_t)-0.1679687500000f,(float16_t)0.9858398437500f,
(float16_t)-0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)-0.1739501953125f,(float16_t)0.9848632812500f,
(float16_t)-0.1770019531250f,(float16_t)0.9843750000000f,
(float16_t)-0.1800537109375f,(float16_t)0.9838867187500f,
(float16_t)-0.1829833984375f,(float16_t)0.9829101562500f,
(float16_t)-0.1860351562500f,(float16_t)0.9824218750000f,
(float16_t)-0.1890869140625f,(float16_t)0.9819335937500f,
(float16_t)-0.1921386718750f,(float16_t)0.9814453125000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.1981201171875f,(float16_t)0.9799804687500f,
(float16_t)-0.2010498046875f,(float16_t)0.9794921875000f,
(float16_t)-0.2041015625000f,(float16_t)0.9790039062500f,
(float16_t)-0.2071533203125f,(float16_t)0.9785156250000f,
(float16_t)-0.2100830078125f,(float16_t)0.9775390625000f,
(float16_t)-0.2131347656250f,(float16_t)0.9770507812500f,
(float16_t)-0.2160644531250f,(float16_t)0.9765625000000f,
(float16_t)-0.2191162109375f,(float16_t)0.9755859375000f,
(float16_t)-0.2220458984375f,(float16_t)0.9750976562500f,
(float16_t)-0.2250976562500f,(float16_t)0.9741210937500f,
(float16_t)-0.2280273437500f,(float16_t)0.9736328125000f,
(float16_t)-0.2310791015625f,(float16_t)0.9731445312500f,
(float16_t)-0.2340087890625f,(float16_t)0.9721679687500f,
(float16_t)-0.2370605468750f,(float16_t)0.9716796875000f,
(float16_t)-0.2399902343750f,(float16_t)0.9707031250000f,
(float16_t)-0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)-0.2459716796875f,(float16_t)0.9692382812500f,
(float16_t)-0.2489013671875f,(float16_t)0.9687500000000f,
(float16_t)-0.2519531250000f,(float16_t)0.9677734375000f,
(float16_t)-0.2548828125000f,(float16_t)0.9667968750000f,
(float16_t)-0.2578125000000f,(float16_t)0.9663085937500f,
(float16_t)-0.2607421875000f,(float16_t)0.9653320312500f,
(float16_t)-0.2636718750000f,(float16_t)0.9643554687500f,
(float16_t)-0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)-0.2697753906250f,(float16_t)0.9628906250000f,
(float16_t)-0.2727050781250f,(float16_t)0.9619140625000f,
(float16_t)-0.2756347656250f,(float16_t)0.9614257812500f,
(float16_t)-0.2785644531250f,(float16_t)0.9604492187500f,
(float16_t)-0.2814941406250f,(float16_t)0.9594726562500f,
(float16_t)-0.2844238281250f,(float16_t)0.9584960937500f,
(float16_t)-0.2873535156250f,(float16_t)0.9580078125000f,
(float16_t)-0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)-0.2932128906250f,(float16_t)0.9560546875000f,
(float16_t)-0.2961425781250f,(float16_t)0.9550781250000f,
(float16_t)-0.2990722656250f,(float16_t)0.9541015625000f,
(float16_t)-0.3020019531250f,(float16_t)0.9531250000000f,
(float16_t)-0.3049316406250f,(float16_t)0.9521484375000f,
(float16_t)-0.3078613281250f,(float16_t)0.9516601562500f,
(float16_t)-0.3107910156250f,(float16_t)0.9506835937500f,
(float16_t)-0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)-0.3166503906250f,(float16_t)0.9487304687500f,
(float16_t)-0.3195800781250f,(float16_t)0.9477539062500f,
(float16_t)-0.3225097656250f,(float16_t)0.9467773437500f,
(float16_t)-0.3251953125000f,(float16_t)0.9458007812500f,
(float16_t)-0.3281250000000f,(float16_t)0.9448242187500f,
(float16_t)-0.3310546875000f,(float16_t)0.9433593750000f,
(float16_t)-0.3339843750000f,(float16_t)0.9423828125000f,
(float16_t)-0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)-0.3398437500000f,(float16_t)0.9404296875000f,
(float16_t)-0.3427734375000f,(float16_t)0.9394531250000f,
(float16_t)-0.3454589843750f,(float16_t)0.9384765625000f,
(float16_t)-0.3483886718750f,(float16_t)0.9375000000000f,
(float16_t)-0.3513183593750f,(float16_t)0.9360351562500f,
(float16_t)-0.3542480468750f,(float16_t)0.9350585937500f,
(float16_t)-0.3569335937500f,(float16_t)0.9340820312500f,
(float16_t)-0.3598632812500f,(float16_t)0.9331054687500f,
(float16_t)-0.3627929687500f,(float16_t)0.9316406250000f,
(float16_t)-0.3657226562500f,(float16_t)0.9306640625000f,
(float16_t)-0.3684082031250f,(float16_t)0.9296875000000f,
(float16_t)-0.3713378906250f,(float16_t)0.9287109375000f,
(float16_t)-0.3742675781250f,(float16_t)0.9272460937500f,
(float16_t)-0.3769531250000f,(float16_t)0.9262695312500f,
(float16_t)-0.3798828125000f,(float16_t)0.9252929687500f,
(float16_t)-0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.3854980468750f,(float16_t)0.9228515625000f,
(float16_t)-0.3884277343750f,(float16_t)0.9213867187500f,
(float16_t)-0.3911132812500f,(float16_t)0.9204101562500f,
(float16_t)-0.3940429687500f,(float16_t)0.9189453125000f,
(float16_t)-0.3967285156250f,(float16_t)0.9179687500000f,
(float16_t)-0.3996582031250f,(float16_t)0.9165039062500f,
(float16_t)-0.4023437500000f,(float16_t)0.9155273437500f,
(float16_t)-0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)-0.4079589843750f,(float16_t)0.9130859375000f,
(float16_t)-0.4108886718750f,(float16_t)0.9116210937500f,
(float16_t)-0.4135742187500f,(float16_t)0.9106445312500f,
(float16_t)-0.4165039062500f,(float16_t)0.9091796875000f,
(float16_t)-0.4191894531250f,(float16_t)0.9077148437500f,
(float16_t)-0.4221191406250f,(float16_t)0.9067382812500f,
(float16_t)-0.4248046875000f,(float16_t)0.9052734375000f,
(float16_t)-0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)-0.4304199218750f,(float16_t)0.9028320312500f,
(float16_t)-0.4331054687500f,(float16_t)0.9013671875000f,
(float16_t)-0.4357910156250f,(float16_t)0.8999023437500f,
(float16_t)-0.4387207031250f,(float16_t)0.8984375000000f,
(float16_t)-0.4414062500000f,(float16_t)0.8974609375000f,
(float16_t)-0.4440917968750f,(float16_t)0.8959960937500f,
(float16_t)-0.4467773437500f,(float16_t)0.8945312500000f,
(float16_t)-0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)-0.4523925781250f,(float16_t)0.8916015625000f,
(float16_t)-0.4550781250000f,(float16_t)0.8906250000000f,
(float16_t)-0.4577636718750f,(float16_t)0.8891601562500f,
(float16_t)-0.4604492187500f,(float16_t)0.8876953125000f,
(float16_t)-0.4633789062500f,(float16_t)0.8862304687500f,
(float16_t)-0.4660644531250f,(float16_t)0.8847656250000f,
(float16_t)-0.4687500000000f,(float16_t)0.8833007812500f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.4741210937500f,(float16_t)0.8803710937500f,
(float16_t)-0.4768066406250f,(float16_t)0.8789062500000f,
(float16_t)-0.4794921875000f,(float16_t)0.8774414062500f,
(float16_t)-0.4821777343750f,(float16_t)0.8759765625000f,
(float16_t)-0.4848632812500f,(float16_t)0.8745117187500f,
(float16_t)-0.4875488281250f,(float16_t)0.8730468750000f,
(float16_t)-0.4902343750000f,(float16_t)0.8715820312500f,
(float16_t)-0.4929199218750f,(float16_t)0.8701171875000f,
(float16_t)-0.4956054687500f,(float16_t)0.8686523437500f,
(float16_t)-0.4982910156250f,(float16_t)0.8671875000000f,
(float16_t)-0.5009765625000f,(float16_t)0.8657226562500f,
(float16_t)-0.5034179687500f,(float16_t)0.8637695312500f,
(float16_t)-0.5063476562500f,(float16_t)0.8623046875000f,
(float16_t)-0.5087890625000f,(float16_t)0.8608398437500f,
(float16_t)-0.5112304687500f,(float16_t)0.8593750000000f,
(float16_t)-0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)-0.5166015625000f,(float16_t)0.8559570312500f,
(float16_t)-0.5195312500000f,(float16_t)0.8544921875000f,
(float16_t)-0.5219726562500f,(float16_t)0.8530273437500f,
(float16_t)-0.5244140625000f,(float16_t)0.8515625000000f,
(float16_t)-0.5273437500000f,(float16_t)0.8496093750000f,
(float16_t)-0.5297851562500f,(float16_t)0.8481445312500f,
(float16_t)-0.5322265625000f,(float16_t)0.8466796875000f,
(float16_t)-0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)-0.5375976562500f,(float16_t)0.8432617187500f,
(float16_t)-0.5400390625000f,(float16_t)0.8417968750000f,
(float16_t)-0.5429687500000f,(float16_t)0.8398437500000f,
(float16_t)-0.5454101562500f,(float16_t)0.8383789062500f,
(float16_t)-0.5478515625000f,(float16_t)0.8364257812500f,
(float16_t)-0.5502929687500f,(float16_t)0.8349609375000f,
(float16_t)-0.5532226562500f,(float16_t)0.8330078125000f,
(float16_t)-0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)-0.5581054687500f,(float16_t)0.8295898437500f,
(float16_t)-0.5605468750000f,(float16_t)0.8281250000000f,
(float16_t)-0.5629882812500f,(float16_t)0.8261718750000f,
(float16_t)-0.5659179687500f,(float16_t)0.8247070312500f,
(float16_t)-0.5683593750000f,(float16_t)0.8227539062500f,
(float16_t)-0.5708007812500f,(float16_t)0.8212890625000f,
(float16_t)-0.5732421875000f,(float16_t)0.8193359375000f,
(float16_t)-0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)-0.5781250000000f,(float16_t)0.8159179687500f,
(float16_t)-0.5810546875000f,(float16_t)0.8139648437500f,
(float16_t)-0.5834960937500f,(float16_t)0.8120117187500f,
(float16_t)-0.5859375000000f,(float16_t)0.8105468750000f,
(float16_t)-0.5883789062500f,(float16_t)0.8085937500000f,
(float16_t)-0.5908203125000f,(float16_t)0.8066406250000f,
(float16_t)-0.5932617187500f,(float16_t)0.8051757812500f,
(float16_t)-0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)-0.5981445312500f,(float16_t)0.8012695312500f,
(float16_t)-0.6005859375000f,(float16_t)0.7993164062500f,
(float16_t)-0.6030273437500f,(float16_t)0.7978515625000f,
(float16_t)-0.6054687500000f,(float16_t)0.7958984375000f,
(float16_t)-0.6079101562500f,(float16_t)0.7939453125000f,
(float16_t)-0.6103515625000f,(float16_t)0.7919921875000f,
(float16_t)-0.6127929687500f,(float16_t)0.7900390625000f,
(float16_t)-0.6152343750000f,(float16_t)0.7885742187500f,
(float16_t)-0.6176757812500f,(float16_t)0.7866210937500f,
(float16_t)-0.6201171875000f,(float16_t)0.7846679687500f,
(float16_t)-0.6225585937500f,(float16_t)0.7827148437500f,
(float16_t)-0.6250000000000f,(float16_t)0.7807617187500f,
(float16_t)-0.6274414062500f,(float16_t)0.7788085937500f,
(float16_t)-0.6293945312500f,(float16_t)0.7768554687500f,
(float16_t)-0.6318359375000f,(float16_t)0.7749023437500f,
(float16_t)-0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)-0.6367187500000f,(float16_t)0.7709960937500f,
(float16_t)-0.6391601562500f,(float16_t)0.7690429687500f,
(float16_t)-0.6416015625000f,(float16_t)0.7670898437500f,
(float16_t)-0.6440429687500f,(float16_t)0.7651367187500f,
(float16_t)-0.6459960937500f,(float16_t)0.7631835937500f,
(float16_t)-0.6484375000000f,(float16_t)0.7612304687500f,
(float16_t)-0.6508789062500f,(float16_t)0.7592773437500f,
(float16_t)-0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)-0.6552734375000f,(float16_t)0.7553710937500f,
(float16_t)-0.6577148437500f,(float16_t)0.7534179687500f,
(float16_t)-0.6601562500000f,(float16_t)0.7509765625000f,
(float16_t)-0.6625976562500f,(float16_t)0.7490234375000f,
(float16_t)-0.6645507812500f,(float16_t)0.7470703125000f,
(float16_t)-0.6669921875000f,(float16_t)0.7451171875000f,
(float16_t)-0.6694335937500f,(float16_t)0.7431640625000f,
(float16_t)-0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)-0.6738281250000f,(float16_t)0.7387695312500f,
(float16_t)-0.6762695312500f,(float16_t)0.7368164062500f,
(float16_t)-0.6782226562500f,(float16_t)0.7348632812500f,
(float16_t)-0.6806640625000f,(float16_t)0.7324218750000f,
(float16_t)-0.6826171875000f,(float16_t)0.7304687500000f,
(float16_t)-0.6850585937500f,(float16_t)0.7285156250000f,
(float16_t)-0.6875000000000f,(float16_t)0.7265625000000f,
(float16_t)-0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)-0.6918945312500f,(float16_t)0.7221679687500f,
(float16_t)-0.6938476562500f,(float16_t)0.7202148437500f,
(float16_t)-0.6962890625000f,(float16_t)0.7177734375000f,
(float16_t)-0.6982421875000f,(float16_t)0.7158203125000f,
(float16_t)-0.7006835937500f,(float16_t)0.7133789062500f,
(float16_t)-0.7026367187500f,(float16_t)0.7114257812500f,
(float16_t)-0.7050781250000f,(float16_t)0.7094726562500f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.7094726562500f,(float16_t)0.7050781250000f,
(float16_t)-0.7114257812500f,(float16_t)0.7026367187500f,
(float16_t)-0.7133789062500f,(float16_t)0.7006835937500f,
(float16_t)-0.7158203125000f,(float16_t)0.6982421875000f,
(float16_t)-0.7177734375000f,(float16_t)0.6962890625000f,
(float16_t)-0.7202148437500f,(float16_t)0.6938476562500f,
(float16_t)-0.7221679687500f,(float16_t)0.6918945312500f,
(float16_t)-0.7241210937500f,(float16_t)0.6894531250000f,
(float16_t)-0.7265625000000f,(float16_t)0.6875000000000f,
(float16_t)-0.7285156250000f,(float16_t)0.6850585937500f,
(float16_t)-0.7304687500000f,(float16_t)0.6826171875000f,
(float16_t)-0.7324218750000f,(float16_t)0.6806640625000f,
(float16_t)-0.7348632812500f,(float16_t)0.6782226562500f,
(float16_t)-0.7368164062500f,(float16_t)0.6762695312500f,
(float16_t)-0.7387695312500f,(float16_t)0.6738281250000f,
(float16_t)-0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)-0.7431640625000f,(float16_t)0.6694335937500f,
(float16_t)-0.7451171875000f,(float16_t)0.6669921875000f,
(float16_t)-0.7470703125000f,(float16_t)0.6645507812500f,
(float16_t)-0.7490234375000f,(float16_t)0.6625976562500f,
(float16_t)-0.7509765625000f,(float16_t)0.6601562500000f,
(float16_t)-0.7534179687500f,(float16_t)0.6577148437500f,
(float16_t)-0.7553710937500f,(float16_t)0.6552734375000f,
(float16_t)-0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)-0.7592773437500f,(float16_t)0.6508789062500f,
(float16_t)-0.7612304687500f,(float16_t)0.6484375000000f,
(float16_t)-0.7631835937500f,(float16_t)0.6459960937500f,
(float16_t)-0.7651367187500f,(float16_t)0.6440429687500f,
(float16_t)-0.7670898437500f,(float16_t)0.6416015625000f,
(float16_t)-0.7690429687500f,(float16_t)0.6391601562500f,
(float16_t)-0.7709960937500f,(float16_t)0.6367187500000f,
(float16_t)-0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)-0.7749023437500f,(float16_t)0.6318359375000f,
(float16_t)-0.7768554687500f,(float16_t)0.6293945312500f,
(float16_t)-0.7788085937500f,(float16_t)0.6274414062500f,
(float16_t)-0.7807617187500f,(float16_t)0.6250000000000f,
(float16_t)-0.7827148437500f,(float16_t)0.6225585937500f,
(float16_t)-0.7846679687500f,(float16_t)0.6201171875000f,
(float16_t)-0.7866210937500f,(float16_t)0.6176757812500f,
(float16_t)-0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)-0.7900390625000f,(float16_t)0.6127929687500f,
(float16_t)-0.7919921875000f,(float16_t)0.6103515625000f,
(float16_t)-0.7939453125000f,(float16_t)0.6079101562500f,
(float16_t)-0.7958984375000f,(float16_t)0.6054687500000f,
(float16_t)-0.7978515625000f,(float16_t)0.6030273437500f,
(float16_t)-0.7993164062500f,(float16_t)0.6005859375000f,
(float16_t)-0.8012695312500f,(float16_t)0.5981445312500f,
(float16_t)-0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)-0.8051757812500f,(float16_t)0.5932617187500f,
(float16_t)-0.8066406250000f,(float16_t)0.5908203125000f,
(float16_t)-0.8085937500000f,(float16_t)0.5883789062500f,
(float16_t)-0.8105468750000f,(float16_t)0.5859375000000f,
(float16_t)-0.8120117187500f,(float16_t)0.5834960937500f,
(float16_t)-0.8139648437500f,(float16_t)0.5810546875000f,
(float16_t)-0.8159179687500f,(float16_t)0.5781250000000f,
(float16_t)-0.8173828125000f,(float16_t)0.5756835937500f,
(float16_t)-0.8193359375000f,(float16_t)0.5732421875000f,
(float16_t)-0.8212890625000f,(float16_t)0.5708007812500f,
(float16_t)-0.8227539062500f,(float16_t)0.5683593750000f,
(float16_t)-0.8247070312500f,(float16_t)0.5659179687500f,
(float16_t)-0.8261718750000f,(float16_t)0.5629882812500f,
(float16_t)-0.8281250000000f,(float16_t)0.5605468750000f,
(float16_t)-0.8295898437500f,(float16_t)0.5581054687500f,
(float16_t)-0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)-0.8330078125000f,(float16_t)0.5532226562500f,
(float16_t)-0.8349609375000f,(float16_t)0.5502929687500f,
(float16_t)-0.8364257812500f,(float16_t)0.5478515625000f,
(float16_t)-0.8383789062500f,(float16_t)0.5454101562500f,
(float16_t)-0.8398437500000f,(float16_t)0.5429687500000f,
(float16_t)-0.8417968750000f,(float16_t)0.5400390625000f,
(float16_t)-0.8432617187500f,(float16_t)0.5375976562500f,
(float16_t)-0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)-0.8466796875000f,(float16_t)0.5322265625000f,
(float16_t)-0.8481445312500f,(float16_t)0.5297851562500f,
(float16_t)-0.8496093750000f,(float16_t)0.5273437500000f,
(float16_t)-0.8515625000000f,(float16_t)0.5244140625000f,
(float16_t)-0.8530273437500f,(float16_t)0.5219726562500f,
(float16_t)-0.8544921875000f,(float16_t)0.5195312500000f,
(float16_t)-0.8559570312500f,(float16_t)0.5166015625000f,
(float16_t)-0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)-0.8593750000000f,(float16_t)0.5112304687500f,
(float16_t)-0.8608398437500f,(float16_t)0.5087890625000f,
(float16_t)-0.8623046875000f,(float16_t)0.5063476562500f,
(float16_t)-0.8637695312500f,(float16_t)0.5034179687500f,
(float16_t)-0.8657226562500f,(float16_t)0.5009765625000f,
(float16_t)-0.8671875000000f,(float16_t)0.4982910156250f,
(float16_t)-0.8686523437500f,(float16_t)0.4956054687500f,
(float16_t)-0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)-0.8715820312500f,(float16_t)0.4902343750000f,
(float16_t)-0.8730468750000f,(float16_t)0.4875488281250f,
(float16_t)-0.8745117187500f,(float16_t)0.4848632812500f,
(float16_t)-0.8759765625000f,(float16_t)0.4821777343750f,
(float16_t)-0.8774414062500f,(float16_t)0.4794921875000f,
(float16_t)-0.8789062500000f,(float16_t)0.4768066406250f,
(float16_t)-0.8803710937500f,(float16_t)0.4741210937500f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.8833007812500f,(float16_t)0.4687500000000f,
(float16_t)-0.8847656250000f,(float16_t)0.4660644531250f,
(float16_t)-0.8862304687500f,(float16_t)0.4633789062500f,
(float16_t)-0.8876953125000f,(float16_t)0.4604492187500f,
(float16_t)-0.8891601562500f,(float16_t)0.4577636718750f,
(float16_t)-0.8906250000000f,(float16_t)0.4550781250000f,
(float16_t)-0.8916015625000f,(float16_t)0.4523925781250f,
(float16_t)-0.8930664062500f,(float16_t)0.4497070312500f,
(float16_t)-0.8945312500000f,(float16_t)0.4467773437500f,
(float16_t)-0.8959960937500f,(float16_t)0.4440917968750f,
(float16_t)-0.8974609375000f,(float16_t)0.4414062500000f,
(float16_t)-0.8984375000000f,(float16_t)0.4387207031250f,
(float16_t)-0.8999023437500f,(float16_t)0.4357910156250f,
(float16_t)-0.9013671875000f,(float16_t)0.4331054687500f,
(float16_t)-0.9028320312500f,(float16_t)0.4304199218750f,
(float16_t)-0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)-0.9052734375000f,(float16_t)0.4248046875000f,
(float16_t)-0.9067382812500f,(float16_t)0.4221191406250f,
(float16_t)-0.9077148437500f,(float16_t)0.4191894531250f,
(float16_t)-0.9091796875000f,(float16_t)0.4165039062500f,
(float16_t)-0.9106445312500f,(float16_t)0.4135742187500f,
(float16_t)-0.9116210937500f,(float16_t)0.4108886718750f,
(float16_t)-0.9130859375000f,(float16_t)0.4079589843750f,
(float16_t)-0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)-0.9155273437500f,(float16_t)0.4023437500000f,
(float16_t)-0.9165039062500f,(float16_t)0.3996582031250f,
(float16_t)-0.9179687500000f,(float16_t)0.3967285156250f,
(float16_t)-0.9189453125000f,(float16_t)0.3940429687500f,
(float16_t)-0.9204101562500f,(float16_t)0.3911132812500f,
(float16_t)-0.9213867187500f,(float16_t)0.3884277343750f,
(float16_t)-0.9228515625000f,(float16_t)0.3854980468750f,
(float16_t)-0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)-0.9252929687500f,(float16_t)0.3798828125000f,
(float16_t)-0.9262695312500f,(float16_t)0.3769531250000f,
(float16_t)-0.9272460937500f,(float16_t)0.3742675781250f,
(float16_t)-0.9287109375000f,(float16_t)0.3713378906250f,
(float16_t)-0.9296875000000f,(float16_t)0.3684082031250f,
(float16_t)-0.9306640625000f,(float16_t)0.3657226562500f,
(float16_t)-0.9316406250000f,(float16_t)0.3627929687500f,
(float16_t)-0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)-0.9340820312500f,(float16_t)0.3569335937500f,
(float16_t)-0.9350585937500f,(float16_t)0.3542480468750f,
(float16_t)-0.9360351562500f,(float16_t)0.3513183593750f,
(float16_t)-0.9375000000000f,(float16_t)0.3483886718750f,
(float16_t)-0.9384765625000f,(float16_t)0.3454589843750f,
(float16_t)-0.9394531250000f,(float16_t)0.3427734375000f,
(float16_t)-0.9404296875000f,(float16_t)0.3398437500000f,
(float16_t)-0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)-0.9423828125000f,(float16_t)0.3339843750000f,
(float16_t)-0.9433593750000f,(float16_t)0.3310546875000f,
(float16_t)-0.9448242187500f,(float16_t)0.3281250000000f,
(float16_t)-0.9458007812500f,(float16_t)0.3251953125000f,
(float16_t)-0.9467773437500f,(float16_t)0.3225097656250f,
(float16_t)-0.9477539062500f,(float16_t)0.3195800781250f,
(float16_t)-0.9487304687500f,(float16_t)0.3166503906250f,
(float16_t)-0.9497070312500f,(float16_t)0.3137207031250f,
(float16_t)-0.9506835937500f,(float16_t)0.3107910156250f,
(float16_t)-0.9516601562500f,(float16_t)0.3078613281250f,
(float16_t)-0.9521484375000f,(float16_t)0.3049316406250f,
(float16_t)-0.9531250000000f,(float16_t)0.3020019531250f,
(float16_t)-0.9541015625000f,(float16_t)0.2990722656250f,
(float16_t)-0.9550781250000f,(float16_t)0.2961425781250f,
(float16_t)-0.9560546875000f,(float16_t)0.2932128906250f,
(float16_t)-0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)-0.9580078125000f,(float16_t)0.2873535156250f,
(float16_t)-0.9584960937500f,(float16_t)0.2844238281250f,
(float16_t)-0.9594726562500f,(float16_t)0.2814941406250f,
(float16_t)-0.9604492187500f,(float16_t)0.2785644531250f,
(float16_t)-0.9614257812500f,(float16_t)0.2756347656250f,
(float16_t)-0.9619140625000f,(float16_t)0.2727050781250f,
(float16_t)-0.9628906250000f,(float16_t)0.2697753906250f,
(float16_t)-0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)-0.9643554687500f,(float16_t)0.2636718750000f,
(float16_t)-0.9653320312500f,(float16_t)0.2607421875000f,
(float16_t)-0.9663085937500f,(float16_t)0.2578125000000f,
(float16_t)-0.9667968750000f,(float16_t)0.2548828125000f,
(float16_t)-0.9677734375000f,(float16_t)0.2519531250000f,
(float16_t)-0.9687500000000f,(float16_t)0.2489013671875f,
(float16_t)-0.9692382812500f,(float16_t)0.2459716796875f,
(float16_t)-0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)-0.9707031250000f,(float16_t)0.2399902343750f,
(float16_t)-0.9716796875000f,(float16_t)0.2370605468750f,
(float16_t)-0.9721679687500f,(float16_t)0.2340087890625f,
(float16_t)-0.9731445312500f,(float16_t)0.2310791015625f,
(float16_t)-0.9736328125000f,(float16_t)0.2280273437500f,
(float16_t)-0.9741210937500f,(float16_t)0.2250976562500f,
(float16_t)-0.9750976562500f,(float16_t)0.2220458984375f,
(float16_t)-0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)-0.9765625000000f,(float16_t)0.2160644531250f,
(float16_t)-0.9770507812500f,(float16_t)0.2131347656250f,
(float16_t)-0.9775390625000f,(float16_t)0.2100830078125f,
(float16_t)-0.9785156250000f,(float16_t)0.2071533203125f,
(float16_t)-0.9790039062500f,(float16_t)0.2041015625000f,
(float16_t)-0.9794921875000f,(float16_t)0.2010498046875f,
(float16_t)-0.9799804687500f,(float16_t)0.1981201171875f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9814453125000f,(float16_t)0.1921386718750f,
(float16_t)-0.9819335937500f,(float16_t)0.1890869140625f,
(float16_t)-0.9824218750000f,(float16_t)0.1860351562500f,
(float16_t)-0.9829101562500f,(float16_t)0.1829833984375f,
(float16_t)-0.9838867187500f,(float16_t)0.1800537109375f,
(float16_t)-0.9843750000000f,(float16_t)0.1770019531250f,
(float16_t)-0.9848632812500f,(float16_t)0.1739501953125f,
(float16_t)-0.9853515625000f,(float16_t)0.1710205078125f,
(float16_t)-0.9858398437500f,(float16_t)0.1679687500000f,
(float16_t)-0.9863281250000f,(float16_t)0.1649169921875f,
(float16_t)-0.9868164062500f,(float16_t)0.1618652343750f,
(float16_t)-0.9873046875000f,(float16_t)0.1588134765625f,
(float16_t)-0.9877929687500f,(float16_t)0.1558837890625f,
(float16_t)-0.9882812500000f,(float16_t)0.1528320312500f,
(float16_t)-0.9887695312500f,(float16_t)0.1497802734375f,
(float16_t)-0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)-0.9897460937500f,(float16_t)0.1436767578125f,
(float16_t)-0.9902343750000f,(float16_t)0.1406250000000f,
(float16_t)-0.9907226562500f,(float16_t)0.1375732421875f,
(float16_t)-0.9907226562500f,(float16_t)0.1345214843750f,
(float16_t)-0.9912109375000f,(float16_t)0.1315917968750f,
(float16_t)-0.9916992187500f,(float16_t)0.1285400390625f,
(float16_t)-0.9921875000000f,(float16_t)0.1254882812500f,
(float16_t)-0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)-0.9926757812500f,(float16_t)0.1193847656250f,
(float16_t)-0.9931640625000f,(float16_t)0.1163330078125f,
(float16_t)-0.9936523437500f,(float16_t)0.1132812500000f,
(float16_t)-0.9941406250000f,(float16_t)0.1102294921875f,
(float16_t)-0.9941406250000f,(float16_t)0.1071777343750f,
(float16_t)-0.9946289062500f,(float16_t)0.1041259765625f,
(float16_t)-0.9951171875000f,(float16_t)0.1010742187500f,
(float16_t)-0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)-0.9956054687500f,(float16_t)0.0949707031250f,
(float16_t)-0.9956054687500f,(float16_t)0.0919189453125f,
(float16_t)-0.9960937500000f,(float16_t)0.0888671875000f,
(float16_t)-0.9960937500000f,(float16_t)0.0858154296875f,
(float16_t)-0.9965820312500f,(float16_t)0.0827636718750f,
(float16_t)-0.9965820312500f,(float16_t)0.0797119140625f,
(float16_t)-0.9970703125000f,(float16_t)0.0765991210938f,
(float16_t)-0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)-0.9975585937500f,(float16_t)0.0704956054688f,
(float16_t)-0.9975585937500f,(float16_t)0.0674438476562f,
(float16_t)-0.9980468750000f,(float16_t)0.0643920898438f,
(float16_t)-0.9980468750000f,(float16_t)0.0613098144531f,
(float16_t)-0.9985351562500f,(float16_t)0.0582580566406f,
(float16_t)-0.9985351562500f,(float16_t)0.0552062988281f,
(float16_t)-0.9985351562500f,(float16_t)0.0521240234375f,
(float16_t)-0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)-0.9990234375000f,(float16_t)0.0459899902344f,
(float16_t)-0.9990234375000f,(float16_t)0.0429382324219f,
(float16_t)-0.9990234375000f,(float16_t)0.0398864746094f,
(float16_t)-0.9995117187500f,(float16_t)0.0368041992188f,
(float16_t)-0.9995117187500f,(float16_t)0.0337524414062f,
(float16_t)-0.9995117187500f,(float16_t)0.0306701660156f,
(float16_t)-0.9995117187500f,(float16_t)0.0276031494141f,
(float16_t)-0.9995117187500f,(float16_t)0.0245361328125f,
(float16_t)-1.0000000000000f,(float16_t)0.0214691162109f,
(float16_t)-1.0000000000000f,(float16_t)0.0184020996094f,
(float16_t)-1.0000000000000f,(float16_t)0.0153427124023f,
(float16_t)-1.0000000000000f,(float16_t)0.0122680664062f,
(float16_t)-1.0000000000000f,(float16_t)0.0092010498047f,
(float16_t)-1.0000000000000f,(float16_t)0.0061340332031f,
(float16_t)-1.0000000000000f,(float16_t)0.0030670166016f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0122680664062f,
(float16_t)0.9995117187500f,(float16_t)0.0245361328125f,
(float16_t)0.9995117187500f,(float16_t)0.0368041992188f,
(float16_t)0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)0.9980468750000f,(float16_t)0.0613098144531f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9960937500000f,(float16_t)0.0858154296875f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9941406250000f,(float16_t)0.1102294921875f,
(float16_t)0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)0.9907226562500f,(float16_t)0.1345214843750f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9873046875000f,(float16_t)0.1588134765625f,
(float16_t)0.9853515625000f,(float16_t)0.1710205078125f,
(float16_t)0.9829101562500f,(float16_t)0.1829833984375f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9785156250000f,(float16_t)0.2071533203125f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9731445312500f,(float16_t)0.2310791015625f,
(float16_t)0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)0.9667968750000f,(float16_t)0.2548828125000f,
(float16_t)0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)0.9604492187500f,(float16_t)0.2785644531250f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9531250000000f,(float16_t)0.3020019531250f,
(float16_t)0.9497070312500f,(float16_t)0.3137207031250f,
(float16_t)0.9458007812500f,(float16_t)0.3251953125000f,
(float16_t)0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)0.9375000000000f,(float16_t)0.3483886718750f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9287109375000f,(float16_t)0.3713378906250f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.9189453125000f,(float16_t)0.3940429687500f,
(float16_t)0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)0.9091796875000f,(float16_t)0.4165039062500f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.8984375000000f,(float16_t)0.4387207031250f,
(float16_t)0.8930664062500f,(float16_t)0.4497070312500f,
(float16_t)0.8876953125000f,(float16_t)0.4604492187500f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8759765625000f,(float16_t)0.4821777343750f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8637695312500f,(float16_t)0.5034179687500f,
(float16_t)0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)0.8515625000000f,(float16_t)0.5244140625000f,
(float16_t)0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)0.8383789062500f,(float16_t)0.5454101562500f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8247070312500f,(float16_t)0.5659179687500f,
(float16_t)0.8173828125000f,(float16_t)0.5756835937500f,
(float16_t)0.8105468750000f,(float16_t)0.5859375000000f,
(float16_t)0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)0.7958984375000f,(float16_t)0.6054687500000f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7807617187500f,(float16_t)0.6250000000000f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7651367187500f,(float16_t)0.6440429687500f,
(float16_t)0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)0.7490234375000f,(float16_t)0.6625976562500f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7324218750000f,(float16_t)0.6806640625000f,
(float16_t)0.7241210937500f,(float16_t)0.6894531250000f,
(float16_t)0.7158203125000f,(float16_t)0.6982421875000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.6982421875000f,(float16_t)0.7158203125000f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6806640625000f,(float16_t)0.7324218750000f,
(float16_t)0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)0.6625976562500f,(float16_t)0.7490234375000f,
(float16_t)0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)0.6440429687500f,(float16_t)0.7651367187500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.6250000000000f,(float16_t)0.7807617187500f,
(float16_t)0.6152343750000f,(float16_t)0.7885742187500f,
(float16_t)0.6054687500000f,(float16_t)0.7958984375000f,
(float16_t)0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)0.5859375000000f,(float16_t)0.8105468750000f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5659179687500f,(float16_t)0.8247070312500f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.5454101562500f,(float16_t)0.8383789062500f,
(float16_t)0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)0.5244140625000f,(float16_t)0.8515625000000f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.5034179687500f,(float16_t)0.8637695312500f,
(float16_t)0.4929199218750f,(float16_t)0.8701171875000f,
(float16_t)0.4821777343750f,(float16_t)0.8759765625000f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.4604492187500f,(float16_t)0.8876953125000f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.4387207031250f,(float16_t)0.8984375000000f,
(float16_t)0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)0.4165039062500f,(float16_t)0.9091796875000f,
(float16_t)0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)0.3940429687500f,(float16_t)0.9189453125000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3713378906250f,(float16_t)0.9287109375000f,
(float16_t)0.3598632812500f,(float16_t)0.9331054687500f,
(float16_t)0.3483886718750f,(float16_t)0.9375000000000f,
(float16_t)0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)0.3251953125000f,(float16_t)0.9458007812500f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.3020019531250f,(float16_t)0.9531250000000f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.2785644531250f,(float16_t)0.9604492187500f,
(float16_t)0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)0.2548828125000f,(float16_t)0.9667968750000f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.2310791015625f,(float16_t)0.9731445312500f,
(float16_t)0.2191162109375f,(float16_t)0.9755859375000f,
(float16_t)0.2071533203125f,(float16_t)0.9785156250000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.1829833984375f,(float16_t)0.9829101562500f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.1588134765625f,(float16_t)0.9873046875000f,
(float16_t)0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)0.1345214843750f,(float16_t)0.9907226562500f,
(float16_t)0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)0.1102294921875f,(float16_t)0.9941406250000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0858154296875f,(float16_t)0.9960937500000f,
(float16_t)0.0735473632812f,(float16_t)0.9970703125000f,
(float16_t)0.0613098144531f,(float16_t)0.9980468750000f,
(float16_t)0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)0.0368041992188f,(float16_t)0.9995117187500f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)0.0122680664062f,(float16_t)1.0000000000000f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.0122680664062f,(float16_t)1.0000000000000f,
(float16_t)-0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)-0.0368041992188f,(float16_t)0.9995117187500f,
(float16_t)-0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)-0.0613098144531f,(float16_t)0.9980468750000f,
(float16_t)-0.0735473632812f,(float16_t)0.9970703125000f,
(float16_t)-0.0858154296875f,(float16_t)0.9960937500000f,
(float16_t)-0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)-0.1102294921875f,(float16_t)0.9941406250000f,
(float16_t)-0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)-0.1345214843750f,(float16_t)0.9907226562500f,
(float16_t)-0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)-0.1588134765625f,(float16_t)0.9873046875000f,
(float16_t)-0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)-0.1829833984375f,(float16_t)0.9829101562500f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.2071533203125f,(float16_t)0.9785156250000f,
(float16_t)-0.2191162109375f,(float16_t)0.9755859375000f,
(float16_t)-0.2310791015625f,(float16_t)0.9731445312500f,
(float16_t)-0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)-0.2548828125000f,(float16_t)0.9667968750000f,
(float16_t)-0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)-0.2785644531250f,(float16_t)0.9604492187500f,
(float16_t)-0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)-0.3020019531250f,(float16_t)0.9531250000000f,
(float16_t)-0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)-0.3251953125000f,(float16_t)0.9458007812500f,
(float16_t)-0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)-0.3483886718750f,(float16_t)0.9375000000000f,
(float16_t)-0.3598632812500f,(float16_t)0.9331054687500f,
(float16_t)-0.3713378906250f,(float16_t)0.9287109375000f,
(float16_t)-0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.3940429687500f,(float16_t)0.9189453125000f,
(float16_t)-0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)-0.4165039062500f,(float16_t)0.9091796875000f,
(float16_t)-0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)-0.4387207031250f,(float16_t)0.8984375000000f,
(float16_t)-0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)-0.4604492187500f,(float16_t)0.8876953125000f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.4821777343750f,(float16_t)0.8759765625000f,
(float16_t)-0.4929199218750f,(float16_t)0.8701171875000f,
(float16_t)-0.5034179687500f,(float16_t)0.8637695312500f,
(float16_t)-0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)-0.5244140625000f,(float16_t)0.8515625000000f,
(float16_t)-0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)-0.5454101562500f,(float16_t)0.8383789062500f,
(float16_t)-0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)-0.5659179687500f,(float16_t)0.8247070312500f,
(float16_t)-0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)-0.5859375000000f,(float16_t)0.8105468750000f,
(float16_t)-0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)-0.6054687500000f,(float16_t)0.7958984375000f,
(float16_t)-0.6152343750000f,(float16_t)0.7885742187500f,
(float16_t)-0.6250000000000f,(float16_t)0.7807617187500f,
(float16_t)-0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)-0.6440429687500f,(float16_t)0.7651367187500f,
(float16_t)-0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)-0.6625976562500f,(float16_t)0.7490234375000f,
(float16_t)-0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)-0.6806640625000f,(float16_t)0.7324218750000f,
(float16_t)-0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)-0.6982421875000f,(float16_t)0.7158203125000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.7158203125000f,(float16_t)0.6982421875000f,
(float16_t)-0.7241210937500f,(float16_t)0.6894531250000f,
(float16_t)-0.7324218750000f,(float16_t)0.6806640625000f,
(float16_t)-0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)-0.7490234375000f,(float16_t)0.6625976562500f,
(float16_t)-0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)-0.7651367187500f,(float16_t)0.6440429687500f,
(float16_t)-0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)-0.7807617187500f,(float16_t)0.6250000000000f,
(float16_t)-0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)-0.7958984375000f,(float16_t)0.6054687500000f,
(float16_t)-0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)-0.8105468750000f,(float16_t)0.5859375000000f,
(float16_t)-0.8173828125000f,(float16_t)0.5756835937500f,
(float16_t)-0.8247070312500f,(float16_t)0.5659179687500f,
(float16_t)-0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)-0.8383789062500f,(float16_t)0.5454101562500f,
(float16_t)-0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)-0.8515625000000f,(float16_t)0.5244140625000f,
(float16_t)-0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)-0.8637695312500f,(float16_t)0.5034179687500f,
(float16_t)-0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)-0.8759765625000f,(float16_t)0.4821777343750f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.8876953125000f,(float16_t)0.4604492187500f,
(float16_t)-0.8930664062500f,(float16_t)0.4497070312500f,
(float16_t)-0.8984375000000f,(float16_t)0.4387207031250f,
(float16_t)-0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)-0.9091796875000f,(float16_t)0.4165039062500f,
(float16_t)-0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)-0.9189453125000f,(float16_t)0.3940429687500f,
(float16_t)-0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)-0.9287109375000f,(float16_t)0.3713378906250f,
(float16_t)-0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)-0.9375000000000f,(float16_t)0.3483886718750f,
(float16_t)-0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)-0.9458007812500f,(float16_t)0.3251953125000f,
(float16_t)-0.9497070312500f,(float16_t)0.3137207031250f,
(float16_t)-0.9531250000000f,(float16_t)0.3020019531250f,
(float16_t)-0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)-0.9604492187500f,(float16_t)0.2785644531250f,
(float16_t)-0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)-0.9667968750000f,(float16_t)0.2548828125000f,
(float16_t)-0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)-0.9731445312500f,(float16_t)0.2310791015625f,
(float16_t)-0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)-0.9785156250000f,(float16_t)0.2071533203125f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9829101562500f,(float16_t)0.1829833984375f,
(float16_t)-0.9853515625000f,(float16_t)0.1710205078125f,
(float16_t)-0.9873046875000f,(float16_t)0.1588134765625f,
(float16_t)-0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)-0.9907226562500f,(float16_t)0.1345214843750f,
(float16_t)-0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)-0.9941406250000f,(float16_t)0.1102294921875f,
(float16_t)-0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)-0.9960937500000f,(float16_t)0.0858154296875f,
(float16_t)-0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)-0.9980468750000f,(float16_t)0.0613098144531f,
(float16_t)-0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)-0.9995117187500f,(float16_t)0.0368041992188f,
(float16_t)-0.9995117187500f,(float16_t)0.0245361328125f,
(float16_t)-1.0000000000000f,(float16_t)0.0122680664062f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)-0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)-0.1467285156250f,(float16_t)0.9892578125000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)-0.2902832031250f,(float16_t)0.9570312500000f,
(float16_t)-0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)-0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.4274902343750f,(float16_t)0.9038085937500f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)-0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)-0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)-0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)-0.6713867187500f,(float16_t)0.7407226562500f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)-0.7729492187500f,(float16_t)0.6342773437500f,
(float16_t)-0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)-0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)-0.8579101562500f,(float16_t)0.5141601562500f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)-0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)-0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)-0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)-0.9702148437500f,(float16_t)0.2429199218750f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)-0.9951171875000f,(float16_t)0.0980224609375f,
(float16_t)-0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.5556640625000f,(float16_t)0.8315429687500f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)-0.9238281250000f,(float16_t)0.3825683593750f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)0.0000000000000f,(float16_t)1.0000000000000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,};

float16_t rearranged_twiddle_stride3_4096_f16[2728]={
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0046005249023f,
(float16_t)1.0000000000000f,(float16_t)0.0092010498047f,
(float16_t)1.0000000000000f,(float16_t)0.0138015747070f,
(float16_t)1.0000000000000f,(float16_t)0.0184020996094f,
(float16_t)0.9995117187500f,(float16_t)0.0230102539062f,
(float16_t)0.9995117187500f,(float16_t)0.0276031494141f,
(float16_t)0.9995117187500f,(float16_t)0.0321960449219f,
(float16_t)0.9995117187500f,(float16_t)0.0368041992188f,
(float16_t)0.9990234375000f,(float16_t)0.0414123535156f,
(float16_t)0.9990234375000f,(float16_t)0.0459899902344f,
(float16_t)0.9985351562500f,(float16_t)0.0505981445312f,
(float16_t)0.9985351562500f,(float16_t)0.0552062988281f,
(float16_t)0.9980468750000f,(float16_t)0.0597839355469f,
(float16_t)0.9980468750000f,(float16_t)0.0643920898438f,
(float16_t)0.9975585937500f,(float16_t)0.0689697265625f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9970703125000f,(float16_t)0.0781250000000f,
(float16_t)0.9965820312500f,(float16_t)0.0827636718750f,
(float16_t)0.9960937500000f,(float16_t)0.0873413085938f,
(float16_t)0.9956054687500f,(float16_t)0.0919189453125f,
(float16_t)0.9951171875000f,(float16_t)0.0964965820312f,
(float16_t)0.9951171875000f,(float16_t)0.1010742187500f,
(float16_t)0.9946289062500f,(float16_t)0.1056518554688f,
(float16_t)0.9941406250000f,(float16_t)0.1102294921875f,
(float16_t)0.9931640625000f,(float16_t)0.1148071289062f,
(float16_t)0.9926757812500f,(float16_t)0.1193847656250f,
(float16_t)0.9921875000000f,(float16_t)0.1239624023438f,
(float16_t)0.9916992187500f,(float16_t)0.1285400390625f,
(float16_t)0.9912109375000f,(float16_t)0.1330566406250f,
(float16_t)0.9907226562500f,(float16_t)0.1375732421875f,
(float16_t)0.9897460937500f,(float16_t)0.1422119140625f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9882812500000f,(float16_t)0.1512451171875f,
(float16_t)0.9877929687500f,(float16_t)0.1558837890625f,
(float16_t)0.9868164062500f,(float16_t)0.1604003906250f,
(float16_t)0.9863281250000f,(float16_t)0.1649169921875f,
(float16_t)0.9853515625000f,(float16_t)0.1694335937500f,
(float16_t)0.9848632812500f,(float16_t)0.1739501953125f,
(float16_t)0.9838867187500f,(float16_t)0.1784667968750f,
(float16_t)0.9829101562500f,(float16_t)0.1829833984375f,
(float16_t)0.9824218750000f,(float16_t)0.1876220703125f,
(float16_t)0.9814453125000f,(float16_t)0.1921386718750f,
(float16_t)0.9804687500000f,(float16_t)0.1966552734375f,
(float16_t)0.9794921875000f,(float16_t)0.2010498046875f,
(float16_t)0.9785156250000f,(float16_t)0.2055664062500f,
(float16_t)0.9775390625000f,(float16_t)0.2100830078125f,
(float16_t)0.9765625000000f,(float16_t)0.2145996093750f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9746093750000f,(float16_t)0.2236328125000f,
(float16_t)0.9736328125000f,(float16_t)0.2280273437500f,
(float16_t)0.9726562500000f,(float16_t)0.2325439453125f,
(float16_t)0.9716796875000f,(float16_t)0.2370605468750f,
(float16_t)0.9702148437500f,(float16_t)0.2414550781250f,
(float16_t)0.9692382812500f,(float16_t)0.2459716796875f,
(float16_t)0.9682617187500f,(float16_t)0.2504882812500f,
(float16_t)0.9667968750000f,(float16_t)0.2548828125000f,
(float16_t)0.9658203125000f,(float16_t)0.2592773437500f,
(float16_t)0.9643554687500f,(float16_t)0.2636718750000f,
(float16_t)0.9633789062500f,(float16_t)0.2683105468750f,
(float16_t)0.9619140625000f,(float16_t)0.2727050781250f,
(float16_t)0.9609375000000f,(float16_t)0.2770996093750f,
(float16_t)0.9594726562500f,(float16_t)0.2814941406250f,
(float16_t)0.9584960937500f,(float16_t)0.2858886718750f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9555664062500f,(float16_t)0.2946777343750f,
(float16_t)0.9541015625000f,(float16_t)0.2990722656250f,
(float16_t)0.9526367187500f,(float16_t)0.3034667968750f,
(float16_t)0.9516601562500f,(float16_t)0.3078613281250f,
(float16_t)0.9501953125000f,(float16_t)0.3122558593750f,
(float16_t)0.9487304687500f,(float16_t)0.3166503906250f,
(float16_t)0.9472656250000f,(float16_t)0.3210449218750f,
(float16_t)0.9458007812500f,(float16_t)0.3251953125000f,
(float16_t)0.9443359375000f,(float16_t)0.3295898437500f,
(float16_t)0.9423828125000f,(float16_t)0.3339843750000f,
(float16_t)0.9409179687500f,(float16_t)0.3383789062500f,
(float16_t)0.9394531250000f,(float16_t)0.3427734375000f,
(float16_t)0.9379882812500f,(float16_t)0.3469238281250f,
(float16_t)0.9360351562500f,(float16_t)0.3513183593750f,
(float16_t)0.9345703125000f,(float16_t)0.3557128906250f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9311523437500f,(float16_t)0.3642578125000f,
(float16_t)0.9296875000000f,(float16_t)0.3684082031250f,
(float16_t)0.9277343750000f,(float16_t)0.3728027343750f,
(float16_t)0.9262695312500f,(float16_t)0.3769531250000f,
(float16_t)0.9243164062500f,(float16_t)0.3813476562500f,
(float16_t)0.9228515625000f,(float16_t)0.3854980468750f,
(float16_t)0.9208984375000f,(float16_t)0.3896484375000f,
(float16_t)0.9189453125000f,(float16_t)0.3940429687500f,
(float16_t)0.9174804687500f,(float16_t)0.3981933593750f,
(float16_t)0.9155273437500f,(float16_t)0.4023437500000f,
(float16_t)0.9135742187500f,(float16_t)0.4067382812500f,
(float16_t)0.9116210937500f,(float16_t)0.4108886718750f,
(float16_t)0.9096679687500f,(float16_t)0.4150390625000f,
(float16_t)0.9077148437500f,(float16_t)0.4191894531250f,
(float16_t)0.9057617187500f,(float16_t)0.4233398437500f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.9018554687500f,(float16_t)0.4316406250000f,
(float16_t)0.8999023437500f,(float16_t)0.4357910156250f,
(float16_t)0.8979492187500f,(float16_t)0.4399414062500f,
(float16_t)0.8959960937500f,(float16_t)0.4440917968750f,
(float16_t)0.8940429687500f,(float16_t)0.4482421875000f,
(float16_t)0.8916015625000f,(float16_t)0.4523925781250f,
(float16_t)0.8896484375000f,(float16_t)0.4565429687500f,
(float16_t)0.8876953125000f,(float16_t)0.4604492187500f,
(float16_t)0.8857421875000f,(float16_t)0.4645996093750f,
(float16_t)0.8833007812500f,(float16_t)0.4687500000000f,
(float16_t)0.8813476562500f,(float16_t)0.4726562500000f,
(float16_t)0.8789062500000f,(float16_t)0.4768066406250f,
(float16_t)0.8769531250000f,(float16_t)0.4809570312500f,
(float16_t)0.8745117187500f,(float16_t)0.4848632812500f,
(float16_t)0.8725585937500f,(float16_t)0.4887695312500f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8676757812500f,(float16_t)0.4968261718750f,
(float16_t)0.8657226562500f,(float16_t)0.5009765625000f,
(float16_t)0.8632812500000f,(float16_t)0.5048828125000f,
(float16_t)0.8608398437500f,(float16_t)0.5087890625000f,
(float16_t)0.8583984375000f,(float16_t)0.5126953125000f,
(float16_t)0.8559570312500f,(float16_t)0.5166015625000f,
(float16_t)0.8540039062500f,(float16_t)0.5205078125000f,
(float16_t)0.8515625000000f,(float16_t)0.5244140625000f,
(float16_t)0.8491210937500f,(float16_t)0.5283203125000f,
(float16_t)0.8466796875000f,(float16_t)0.5322265625000f,
(float16_t)0.8442382812500f,(float16_t)0.5361328125000f,
(float16_t)0.8417968750000f,(float16_t)0.5400390625000f,
(float16_t)0.8388671875000f,(float16_t)0.5439453125000f,
(float16_t)0.8364257812500f,(float16_t)0.5478515625000f,
(float16_t)0.8339843750000f,(float16_t)0.5517578125000f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8291015625000f,(float16_t)0.5595703125000f,
(float16_t)0.8261718750000f,(float16_t)0.5629882812500f,
(float16_t)0.8237304687500f,(float16_t)0.5668945312500f,
(float16_t)0.8212890625000f,(float16_t)0.5708007812500f,
(float16_t)0.8183593750000f,(float16_t)0.5747070312500f,
(float16_t)0.8159179687500f,(float16_t)0.5781250000000f,
(float16_t)0.8129882812500f,(float16_t)0.5820312500000f,
(float16_t)0.8105468750000f,(float16_t)0.5859375000000f,
(float16_t)0.8076171875000f,(float16_t)0.5893554687500f,
(float16_t)0.8051757812500f,(float16_t)0.5932617187500f,
(float16_t)0.8022460937500f,(float16_t)0.5971679687500f,
(float16_t)0.7993164062500f,(float16_t)0.6005859375000f,
(float16_t)0.7968750000000f,(float16_t)0.6044921875000f,
(float16_t)0.7939453125000f,(float16_t)0.6079101562500f,
(float16_t)0.7910156250000f,(float16_t)0.6118164062500f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7856445312500f,(float16_t)0.6186523437500f,
(float16_t)0.7827148437500f,(float16_t)0.6225585937500f,
(float16_t)0.7797851562500f,(float16_t)0.6259765625000f,
(float16_t)0.7768554687500f,(float16_t)0.6293945312500f,
(float16_t)0.7739257812500f,(float16_t)0.6333007812500f,
(float16_t)0.7709960937500f,(float16_t)0.6367187500000f,
(float16_t)0.7680664062500f,(float16_t)0.6401367187500f,
(float16_t)0.7651367187500f,(float16_t)0.6440429687500f,
(float16_t)0.7622070312500f,(float16_t)0.6474609375000f,
(float16_t)0.7592773437500f,(float16_t)0.6508789062500f,
(float16_t)0.7563476562500f,(float16_t)0.6542968750000f,
(float16_t)0.7534179687500f,(float16_t)0.6577148437500f,
(float16_t)0.7500000000000f,(float16_t)0.6611328125000f,
(float16_t)0.7470703125000f,(float16_t)0.6645507812500f,
(float16_t)0.7441406250000f,(float16_t)0.6679687500000f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7377929687500f,(float16_t)0.6748046875000f,
(float16_t)0.7348632812500f,(float16_t)0.6782226562500f,
(float16_t)0.7314453125000f,(float16_t)0.6816406250000f,
(float16_t)0.7285156250000f,(float16_t)0.6850585937500f,
(float16_t)0.7250976562500f,(float16_t)0.6884765625000f,
(float16_t)0.7221679687500f,(float16_t)0.6918945312500f,
(float16_t)0.7187500000000f,(float16_t)0.6953125000000f,
(float16_t)0.7158203125000f,(float16_t)0.6982421875000f,
(float16_t)0.7124023437500f,(float16_t)0.7016601562500f,
(float16_t)0.7094726562500f,(float16_t)0.7050781250000f,
(float16_t)0.7060546875000f,(float16_t)0.7080078125000f,
(float16_t)0.7026367187500f,(float16_t)0.7114257812500f,
(float16_t)0.6997070312500f,(float16_t)0.7148437500000f,
(float16_t)0.6962890625000f,(float16_t)0.7177734375000f,
(float16_t)0.6928710937500f,(float16_t)0.7211914062500f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6860351562500f,(float16_t)0.7275390625000f,
(float16_t)0.6826171875000f,(float16_t)0.7304687500000f,
(float16_t)0.6796875000000f,(float16_t)0.7338867187500f,
(float16_t)0.6762695312500f,(float16_t)0.7368164062500f,
(float16_t)0.6728515625000f,(float16_t)0.7397460937500f,
(float16_t)0.6694335937500f,(float16_t)0.7431640625000f,
(float16_t)0.6660156250000f,(float16_t)0.7460937500000f,
(float16_t)0.6625976562500f,(float16_t)0.7490234375000f,
(float16_t)0.6591796875000f,(float16_t)0.7519531250000f,
(float16_t)0.6552734375000f,(float16_t)0.7553710937500f,
(float16_t)0.6518554687500f,(float16_t)0.7583007812500f,
(float16_t)0.6484375000000f,(float16_t)0.7612304687500f,
(float16_t)0.6450195312500f,(float16_t)0.7641601562500f,
(float16_t)0.6416015625000f,(float16_t)0.7670898437500f,
(float16_t)0.6381835937500f,(float16_t)0.7700195312500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.6308593750000f,(float16_t)0.7758789062500f,
(float16_t)0.6274414062500f,(float16_t)0.7788085937500f,
(float16_t)0.6235351562500f,(float16_t)0.7817382812500f,
(float16_t)0.6201171875000f,(float16_t)0.7846679687500f,
(float16_t)0.6162109375000f,(float16_t)0.7875976562500f,
(float16_t)0.6127929687500f,(float16_t)0.7900390625000f,
(float16_t)0.6093750000000f,(float16_t)0.7929687500000f,
(float16_t)0.6054687500000f,(float16_t)0.7958984375000f,
(float16_t)0.6020507812500f,(float16_t)0.7988281250000f,
(float16_t)0.5981445312500f,(float16_t)0.8012695312500f,
(float16_t)0.5942382812500f,(float16_t)0.8041992187500f,
(float16_t)0.5908203125000f,(float16_t)0.8066406250000f,
(float16_t)0.5869140625000f,(float16_t)0.8095703125000f,
(float16_t)0.5834960937500f,(float16_t)0.8120117187500f,
(float16_t)0.5795898437500f,(float16_t)0.8149414062500f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5722656250000f,(float16_t)0.8203125000000f,
(float16_t)0.5683593750000f,(float16_t)0.8227539062500f,
(float16_t)0.5644531250000f,(float16_t)0.8256835937500f,
(float16_t)0.5605468750000f,(float16_t)0.8281250000000f,
(float16_t)0.5566406250000f,(float16_t)0.8305664062500f,
(float16_t)0.5532226562500f,(float16_t)0.8330078125000f,
(float16_t)0.5493164062500f,(float16_t)0.8359375000000f,
(float16_t)0.5454101562500f,(float16_t)0.8383789062500f,
(float16_t)0.5415039062500f,(float16_t)0.8408203125000f,
(float16_t)0.5375976562500f,(float16_t)0.8432617187500f,
(float16_t)0.5336914062500f,(float16_t)0.8457031250000f,
(float16_t)0.5297851562500f,(float16_t)0.8481445312500f,
(float16_t)0.5258789062500f,(float16_t)0.8505859375000f,
(float16_t)0.5219726562500f,(float16_t)0.8530273437500f,
(float16_t)0.5180664062500f,(float16_t)0.8554687500000f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.5102539062500f,(float16_t)0.8598632812500f,
(float16_t)0.5063476562500f,(float16_t)0.8623046875000f,
(float16_t)0.5024414062500f,(float16_t)0.8647460937500f,
(float16_t)0.4982910156250f,(float16_t)0.8671875000000f,
(float16_t)0.4941406250000f,(float16_t)0.8691406250000f,
(float16_t)0.4902343750000f,(float16_t)0.8715820312500f,
(float16_t)0.4863281250000f,(float16_t)0.8740234375000f,
(float16_t)0.4821777343750f,(float16_t)0.8759765625000f,
(float16_t)0.4780273437500f,(float16_t)0.8784179687500f,
(float16_t)0.4741210937500f,(float16_t)0.8803710937500f,
(float16_t)0.4699707031250f,(float16_t)0.8828125000000f,
(float16_t)0.4660644531250f,(float16_t)0.8847656250000f,
(float16_t)0.4619140625000f,(float16_t)0.8867187500000f,
(float16_t)0.4577636718750f,(float16_t)0.8891601562500f,
(float16_t)0.4536132812500f,(float16_t)0.8911132812500f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.4455566406250f,(float16_t)0.8955078125000f,
(float16_t)0.4414062500000f,(float16_t)0.8974609375000f,
(float16_t)0.4372558593750f,(float16_t)0.8994140625000f,
(float16_t)0.4331054687500f,(float16_t)0.9013671875000f,
(float16_t)0.4289550781250f,(float16_t)0.9033203125000f,
(float16_t)0.4248046875000f,(float16_t)0.9052734375000f,
(float16_t)0.4206542968750f,(float16_t)0.9072265625000f,
(float16_t)0.4165039062500f,(float16_t)0.9091796875000f,
(float16_t)0.4123535156250f,(float16_t)0.9111328125000f,
(float16_t)0.4079589843750f,(float16_t)0.9130859375000f,
(float16_t)0.4038085937500f,(float16_t)0.9150390625000f,
(float16_t)0.3996582031250f,(float16_t)0.9165039062500f,
(float16_t)0.3955078125000f,(float16_t)0.9184570312500f,
(float16_t)0.3911132812500f,(float16_t)0.9204101562500f,
(float16_t)0.3869628906250f,(float16_t)0.9218750000000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3784179687500f,(float16_t)0.9257812500000f,
(float16_t)0.3742675781250f,(float16_t)0.9272460937500f,
(float16_t)0.3698730468750f,(float16_t)0.9291992187500f,
(float16_t)0.3657226562500f,(float16_t)0.9306640625000f,
(float16_t)0.3613281250000f,(float16_t)0.9326171875000f,
(float16_t)0.3569335937500f,(float16_t)0.9340820312500f,
(float16_t)0.3527832031250f,(float16_t)0.9355468750000f,
(float16_t)0.3483886718750f,(float16_t)0.9375000000000f,
(float16_t)0.3439941406250f,(float16_t)0.9389648437500f,
(float16_t)0.3398437500000f,(float16_t)0.9404296875000f,
(float16_t)0.3354492187500f,(float16_t)0.9418945312500f,
(float16_t)0.3310546875000f,(float16_t)0.9433593750000f,
(float16_t)0.3266601562500f,(float16_t)0.9453125000000f,
(float16_t)0.3225097656250f,(float16_t)0.9467773437500f,
(float16_t)0.3181152343750f,(float16_t)0.9482421875000f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.3093261718750f,(float16_t)0.9511718750000f,
(float16_t)0.3049316406250f,(float16_t)0.9521484375000f,
(float16_t)0.3005371093750f,(float16_t)0.9536132812500f,
(float16_t)0.2961425781250f,(float16_t)0.9550781250000f,
(float16_t)0.2917480468750f,(float16_t)0.9565429687500f,
(float16_t)0.2873535156250f,(float16_t)0.9580078125000f,
(float16_t)0.2829589843750f,(float16_t)0.9589843750000f,
(float16_t)0.2785644531250f,(float16_t)0.9604492187500f,
(float16_t)0.2741699218750f,(float16_t)0.9619140625000f,
(float16_t)0.2697753906250f,(float16_t)0.9628906250000f,
(float16_t)0.2651367187500f,(float16_t)0.9643554687500f,
(float16_t)0.2607421875000f,(float16_t)0.9653320312500f,
(float16_t)0.2563476562500f,(float16_t)0.9667968750000f,
(float16_t)0.2519531250000f,(float16_t)0.9677734375000f,
(float16_t)0.2474365234375f,(float16_t)0.9687500000000f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.2385253906250f,(float16_t)0.9711914062500f,
(float16_t)0.2340087890625f,(float16_t)0.9721679687500f,
(float16_t)0.2296142578125f,(float16_t)0.9731445312500f,
(float16_t)0.2250976562500f,(float16_t)0.9741210937500f,
(float16_t)0.2205810546875f,(float16_t)0.9755859375000f,
(float16_t)0.2160644531250f,(float16_t)0.9765625000000f,
(float16_t)0.2116699218750f,(float16_t)0.9775390625000f,
(float16_t)0.2071533203125f,(float16_t)0.9785156250000f,
(float16_t)0.2026367187500f,(float16_t)0.9794921875000f,
(float16_t)0.1981201171875f,(float16_t)0.9799804687500f,
(float16_t)0.1936035156250f,(float16_t)0.9809570312500f,
(float16_t)0.1890869140625f,(float16_t)0.9819335937500f,
(float16_t)0.1845703125000f,(float16_t)0.9829101562500f,
(float16_t)0.1800537109375f,(float16_t)0.9838867187500f,
(float16_t)0.1755371093750f,(float16_t)0.9843750000000f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.1663818359375f,(float16_t)0.9858398437500f,
(float16_t)0.1618652343750f,(float16_t)0.9868164062500f,
(float16_t)0.1573486328125f,(float16_t)0.9873046875000f,
(float16_t)0.1528320312500f,(float16_t)0.9882812500000f,
(float16_t)0.1481933593750f,(float16_t)0.9887695312500f,
(float16_t)0.1436767578125f,(float16_t)0.9897460937500f,
(float16_t)0.1391601562500f,(float16_t)0.9902343750000f,
(float16_t)0.1345214843750f,(float16_t)0.9907226562500f,
(float16_t)0.1300048828125f,(float16_t)0.9916992187500f,
(float16_t)0.1254882812500f,(float16_t)0.9921875000000f,
(float16_t)0.1209106445312f,(float16_t)0.9926757812500f,
(float16_t)0.1163330078125f,(float16_t)0.9931640625000f,
(float16_t)0.1117553710938f,(float16_t)0.9936523437500f,
(float16_t)0.1071777343750f,(float16_t)0.9941406250000f,
(float16_t)0.1026000976562f,(float16_t)0.9946289062500f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0934448242188f,(float16_t)0.9956054687500f,
(float16_t)0.0888671875000f,(float16_t)0.9960937500000f,
(float16_t)0.0842895507812f,(float16_t)0.9965820312500f,
(float16_t)0.0797119140625f,(float16_t)0.9965820312500f,
(float16_t)0.0750732421875f,(float16_t)0.9970703125000f,
(float16_t)0.0704956054688f,(float16_t)0.9975585937500f,
(float16_t)0.0659179687500f,(float16_t)0.9980468750000f,
(float16_t)0.0613098144531f,(float16_t)0.9980468750000f,
(float16_t)0.0567321777344f,(float16_t)0.9985351562500f,
(float16_t)0.0521240234375f,(float16_t)0.9985351562500f,
(float16_t)0.0475463867188f,(float16_t)0.9990234375000f,
(float16_t)0.0429382324219f,(float16_t)0.9990234375000f,
(float16_t)0.0383300781250f,(float16_t)0.9990234375000f,
(float16_t)0.0337524414062f,(float16_t)0.9995117187500f,
(float16_t)0.0291442871094f,(float16_t)0.9995117187500f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)0.0199432373047f,(float16_t)1.0000000000000f,
(float16_t)0.0153427124023f,(float16_t)1.0000000000000f,
(float16_t)0.0107345581055f,(float16_t)1.0000000000000f,
(float16_t)0.0061340332031f,(float16_t)1.0000000000000f,
(float16_t)0.0015335083008f,(float16_t)1.0000000000000f,
(float16_t)-0.0030670166016f,(float16_t)1.0000000000000f,
(float16_t)-0.0076713562012f,(float16_t)1.0000000000000f,
(float16_t)-0.0122680664062f,(float16_t)1.0000000000000f,
(float16_t)-0.0168762207031f,(float16_t)1.0000000000000f,
(float16_t)-0.0214691162109f,(float16_t)1.0000000000000f,
(float16_t)-0.0260772705078f,(float16_t)0.9995117187500f,
(float16_t)-0.0306701660156f,(float16_t)0.9995117187500f,
(float16_t)-0.0352783203125f,(float16_t)0.9995117187500f,
(float16_t)-0.0398864746094f,(float16_t)0.9990234375000f,
(float16_t)-0.0444641113281f,(float16_t)0.9990234375000f,
(float16_t)-0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)-0.0536499023438f,(float16_t)0.9985351562500f,
(float16_t)-0.0582580566406f,(float16_t)0.9985351562500f,
(float16_t)-0.0628662109375f,(float16_t)0.9980468750000f,
(float16_t)-0.0674438476562f,(float16_t)0.9975585937500f,
(float16_t)-0.0720214843750f,(float16_t)0.9975585937500f,
(float16_t)-0.0765991210938f,(float16_t)0.9970703125000f,
(float16_t)-0.0812377929688f,(float16_t)0.9965820312500f,
(float16_t)-0.0858154296875f,(float16_t)0.9960937500000f,
(float16_t)-0.0903930664062f,(float16_t)0.9960937500000f,
(float16_t)-0.0949707031250f,(float16_t)0.9956054687500f,
(float16_t)-0.0995483398438f,(float16_t)0.9951171875000f,
(float16_t)-0.1041259765625f,(float16_t)0.9946289062500f,
(float16_t)-0.1087036132812f,(float16_t)0.9941406250000f,
(float16_t)-0.1132812500000f,(float16_t)0.9936523437500f,
(float16_t)-0.1178588867188f,(float16_t)0.9931640625000f,
(float16_t)-0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)-0.1269531250000f,(float16_t)0.9916992187500f,
(float16_t)-0.1315917968750f,(float16_t)0.9912109375000f,
(float16_t)-0.1361083984375f,(float16_t)0.9907226562500f,
(float16_t)-0.1406250000000f,(float16_t)0.9902343750000f,
(float16_t)-0.1452636718750f,(float16_t)0.9892578125000f,
(float16_t)-0.1497802734375f,(float16_t)0.9887695312500f,
(float16_t)-0.1542968750000f,(float16_t)0.9877929687500f,
(float16_t)-0.1588134765625f,(float16_t)0.9873046875000f,
(float16_t)-0.1634521484375f,(float16_t)0.9863281250000f,
(float16_t)-0.1679687500000f,(float16_t)0.9858398437500f,
(float16_t)-0.1724853515625f,(float16_t)0.9848632812500f,
(float16_t)-0.1770019531250f,(float16_t)0.9843750000000f,
(float16_t)-0.1815185546875f,(float16_t)0.9833984375000f,
(float16_t)-0.1860351562500f,(float16_t)0.9824218750000f,
(float16_t)-0.1905517578125f,(float16_t)0.9814453125000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.1995849609375f,(float16_t)0.9799804687500f,
(float16_t)-0.2041015625000f,(float16_t)0.9790039062500f,
(float16_t)-0.2086181640625f,(float16_t)0.9780273437500f,
(float16_t)-0.2131347656250f,(float16_t)0.9770507812500f,
(float16_t)-0.2176513671875f,(float16_t)0.9760742187500f,
(float16_t)-0.2220458984375f,(float16_t)0.9750976562500f,
(float16_t)-0.2265625000000f,(float16_t)0.9741210937500f,
(float16_t)-0.2310791015625f,(float16_t)0.9731445312500f,
(float16_t)-0.2354736328125f,(float16_t)0.9716796875000f,
(float16_t)-0.2399902343750f,(float16_t)0.9707031250000f,
(float16_t)-0.2445068359375f,(float16_t)0.9697265625000f,
(float16_t)-0.2489013671875f,(float16_t)0.9687500000000f,
(float16_t)-0.2534179687500f,(float16_t)0.9672851562500f,
(float16_t)-0.2578125000000f,(float16_t)0.9663085937500f,
(float16_t)-0.2622070312500f,(float16_t)0.9648437500000f,
(float16_t)-0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)-0.2712402343750f,(float16_t)0.9624023437500f,
(float16_t)-0.2756347656250f,(float16_t)0.9614257812500f,
(float16_t)-0.2800292968750f,(float16_t)0.9599609375000f,
(float16_t)-0.2844238281250f,(float16_t)0.9584960937500f,
(float16_t)-0.2888183593750f,(float16_t)0.9575195312500f,
(float16_t)-0.2932128906250f,(float16_t)0.9560546875000f,
(float16_t)-0.2976074218750f,(float16_t)0.9545898437500f,
(float16_t)-0.3020019531250f,(float16_t)0.9531250000000f,
(float16_t)-0.3063964843750f,(float16_t)0.9521484375000f,
(float16_t)-0.3107910156250f,(float16_t)0.9506835937500f,
(float16_t)-0.3151855468750f,(float16_t)0.9492187500000f,
(float16_t)-0.3195800781250f,(float16_t)0.9477539062500f,
(float16_t)-0.3239746093750f,(float16_t)0.9462890625000f,
(float16_t)-0.3281250000000f,(float16_t)0.9448242187500f,
(float16_t)-0.3325195312500f,(float16_t)0.9428710937500f,
(float16_t)-0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)-0.3413085937500f,(float16_t)0.9399414062500f,
(float16_t)-0.3454589843750f,(float16_t)0.9384765625000f,
(float16_t)-0.3498535156250f,(float16_t)0.9370117187500f,
(float16_t)-0.3542480468750f,(float16_t)0.9350585937500f,
(float16_t)-0.3583984375000f,(float16_t)0.9335937500000f,
(float16_t)-0.3627929687500f,(float16_t)0.9316406250000f,
(float16_t)-0.3669433593750f,(float16_t)0.9301757812500f,
(float16_t)-0.3713378906250f,(float16_t)0.9287109375000f,
(float16_t)-0.3754882812500f,(float16_t)0.9267578125000f,
(float16_t)-0.3798828125000f,(float16_t)0.9252929687500f,
(float16_t)-0.3840332031250f,(float16_t)0.9233398437500f,
(float16_t)-0.3884277343750f,(float16_t)0.9213867187500f,
(float16_t)-0.3925781250000f,(float16_t)0.9199218750000f,
(float16_t)-0.3967285156250f,(float16_t)0.9179687500000f,
(float16_t)-0.4011230468750f,(float16_t)0.9160156250000f,
(float16_t)-0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)-0.4094238281250f,(float16_t)0.9121093750000f,
(float16_t)-0.4135742187500f,(float16_t)0.9106445312500f,
(float16_t)-0.4177246093750f,(float16_t)0.9086914062500f,
(float16_t)-0.4221191406250f,(float16_t)0.9067382812500f,
(float16_t)-0.4262695312500f,(float16_t)0.9047851562500f,
(float16_t)-0.4304199218750f,(float16_t)0.9028320312500f,
(float16_t)-0.4345703125000f,(float16_t)0.9008789062500f,
(float16_t)-0.4387207031250f,(float16_t)0.8984375000000f,
(float16_t)-0.4426269531250f,(float16_t)0.8964843750000f,
(float16_t)-0.4467773437500f,(float16_t)0.8945312500000f,
(float16_t)-0.4509277343750f,(float16_t)0.8925781250000f,
(float16_t)-0.4550781250000f,(float16_t)0.8906250000000f,
(float16_t)-0.4592285156250f,(float16_t)0.8881835937500f,
(float16_t)-0.4633789062500f,(float16_t)0.8862304687500f,
(float16_t)-0.4672851562500f,(float16_t)0.8842773437500f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.4753417968750f,(float16_t)0.8798828125000f,
(float16_t)-0.4794921875000f,(float16_t)0.8774414062500f,
(float16_t)-0.4836425781250f,(float16_t)0.8754882812500f,
(float16_t)-0.4875488281250f,(float16_t)0.8730468750000f,
(float16_t)-0.4914550781250f,(float16_t)0.8706054687500f,
(float16_t)-0.4956054687500f,(float16_t)0.8686523437500f,
(float16_t)-0.4995117187500f,(float16_t)0.8662109375000f,
(float16_t)-0.5034179687500f,(float16_t)0.8637695312500f,
(float16_t)-0.5073242187500f,(float16_t)0.8618164062500f,
(float16_t)-0.5112304687500f,(float16_t)0.8593750000000f,
(float16_t)-0.5156250000000f,(float16_t)0.8569335937500f,
(float16_t)-0.5195312500000f,(float16_t)0.8544921875000f,
(float16_t)-0.5234375000000f,(float16_t)0.8520507812500f,
(float16_t)-0.5273437500000f,(float16_t)0.8496093750000f,
(float16_t)-0.5312500000000f,(float16_t)0.8471679687500f,
(float16_t)-0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)-0.5390625000000f,(float16_t)0.8422851562500f,
(float16_t)-0.5429687500000f,(float16_t)0.8398437500000f,
(float16_t)-0.5463867187500f,(float16_t)0.8374023437500f,
(float16_t)-0.5502929687500f,(float16_t)0.8349609375000f,
(float16_t)-0.5541992187500f,(float16_t)0.8325195312500f,
(float16_t)-0.5581054687500f,(float16_t)0.8295898437500f,
(float16_t)-0.5620117187500f,(float16_t)0.8271484375000f,
(float16_t)-0.5659179687500f,(float16_t)0.8247070312500f,
(float16_t)-0.5693359375000f,(float16_t)0.8217773437500f,
(float16_t)-0.5732421875000f,(float16_t)0.8193359375000f,
(float16_t)-0.5771484375000f,(float16_t)0.8168945312500f,
(float16_t)-0.5810546875000f,(float16_t)0.8139648437500f,
(float16_t)-0.5844726562500f,(float16_t)0.8115234375000f,
(float16_t)-0.5883789062500f,(float16_t)0.8085937500000f,
(float16_t)-0.5917968750000f,(float16_t)0.8061523437500f,
(float16_t)-0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)-0.5996093750000f,(float16_t)0.8002929687500f,
(float16_t)-0.6030273437500f,(float16_t)0.7978515625000f,
(float16_t)-0.6069335937500f,(float16_t)0.7949218750000f,
(float16_t)-0.6103515625000f,(float16_t)0.7919921875000f,
(float16_t)-0.6142578125000f,(float16_t)0.7890625000000f,
(float16_t)-0.6176757812500f,(float16_t)0.7866210937500f,
(float16_t)-0.6210937500000f,(float16_t)0.7836914062500f,
(float16_t)-0.6250000000000f,(float16_t)0.7807617187500f,
(float16_t)-0.6284179687500f,(float16_t)0.7778320312500f,
(float16_t)-0.6318359375000f,(float16_t)0.7749023437500f,
(float16_t)-0.6357421875000f,(float16_t)0.7719726562500f,
(float16_t)-0.6391601562500f,(float16_t)0.7690429687500f,
(float16_t)-0.6425781250000f,(float16_t)0.7661132812500f,
(float16_t)-0.6459960937500f,(float16_t)0.7631835937500f,
(float16_t)-0.6499023437500f,(float16_t)0.7602539062500f,
(float16_t)-0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)-0.6567382812500f,(float16_t)0.7543945312500f,
(float16_t)-0.6601562500000f,(float16_t)0.7509765625000f,
(float16_t)-0.6635742187500f,(float16_t)0.7480468750000f,
(float16_t)-0.6669921875000f,(float16_t)0.7451171875000f,
(float16_t)-0.6704101562500f,(float16_t)0.7421875000000f,
(float16_t)-0.6738281250000f,(float16_t)0.7387695312500f,
(float16_t)-0.6772460937500f,(float16_t)0.7358398437500f,
(float16_t)-0.6806640625000f,(float16_t)0.7324218750000f,
(float16_t)-0.6840820312500f,(float16_t)0.7294921875000f,
(float16_t)-0.6875000000000f,(float16_t)0.7265625000000f,
(float16_t)-0.6904296875000f,(float16_t)0.7231445312500f,
(float16_t)-0.6938476562500f,(float16_t)0.7202148437500f,
(float16_t)-0.6972656250000f,(float16_t)0.7167968750000f,
(float16_t)-0.7006835937500f,(float16_t)0.7133789062500f,
(float16_t)-0.7036132812500f,(float16_t)0.7104492187500f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.7104492187500f,(float16_t)0.7036132812500f,
(float16_t)-0.7133789062500f,(float16_t)0.7006835937500f,
(float16_t)-0.7167968750000f,(float16_t)0.6972656250000f,
(float16_t)-0.7202148437500f,(float16_t)0.6938476562500f,
(float16_t)-0.7231445312500f,(float16_t)0.6904296875000f,
(float16_t)-0.7265625000000f,(float16_t)0.6875000000000f,
(float16_t)-0.7294921875000f,(float16_t)0.6840820312500f,
(float16_t)-0.7324218750000f,(float16_t)0.6806640625000f,
(float16_t)-0.7358398437500f,(float16_t)0.6772460937500f,
(float16_t)-0.7387695312500f,(float16_t)0.6738281250000f,
(float16_t)-0.7421875000000f,(float16_t)0.6704101562500f,
(float16_t)-0.7451171875000f,(float16_t)0.6669921875000f,
(float16_t)-0.7480468750000f,(float16_t)0.6635742187500f,
(float16_t)-0.7509765625000f,(float16_t)0.6601562500000f,
(float16_t)-0.7543945312500f,(float16_t)0.6567382812500f,
(float16_t)-0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)-0.7602539062500f,(float16_t)0.6499023437500f,
(float16_t)-0.7631835937500f,(float16_t)0.6459960937500f,
(float16_t)-0.7661132812500f,(float16_t)0.6425781250000f,
(float16_t)-0.7690429687500f,(float16_t)0.6391601562500f,
(float16_t)-0.7719726562500f,(float16_t)0.6357421875000f,
(float16_t)-0.7749023437500f,(float16_t)0.6318359375000f,
(float16_t)-0.7778320312500f,(float16_t)0.6284179687500f,
(float16_t)-0.7807617187500f,(float16_t)0.6250000000000f,
(float16_t)-0.7836914062500f,(float16_t)0.6210937500000f,
(float16_t)-0.7866210937500f,(float16_t)0.6176757812500f,
(float16_t)-0.7890625000000f,(float16_t)0.6142578125000f,
(float16_t)-0.7919921875000f,(float16_t)0.6103515625000f,
(float16_t)-0.7949218750000f,(float16_t)0.6069335937500f,
(float16_t)-0.7978515625000f,(float16_t)0.6030273437500f,
(float16_t)-0.8002929687500f,(float16_t)0.5996093750000f,
(float16_t)-0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)-0.8061523437500f,(float16_t)0.5917968750000f,
(float16_t)-0.8085937500000f,(float16_t)0.5883789062500f,
(float16_t)-0.8115234375000f,(float16_t)0.5844726562500f,
(float16_t)-0.8139648437500f,(float16_t)0.5810546875000f,
(float16_t)-0.8168945312500f,(float16_t)0.5771484375000f,
(float16_t)-0.8193359375000f,(float16_t)0.5732421875000f,
(float16_t)-0.8217773437500f,(float16_t)0.5693359375000f,
(float16_t)-0.8247070312500f,(float16_t)0.5659179687500f,
(float16_t)-0.8271484375000f,(float16_t)0.5620117187500f,
(float16_t)-0.8295898437500f,(float16_t)0.5581054687500f,
(float16_t)-0.8325195312500f,(float16_t)0.5541992187500f,
(float16_t)-0.8349609375000f,(float16_t)0.5502929687500f,
(float16_t)-0.8374023437500f,(float16_t)0.5463867187500f,
(float16_t)-0.8398437500000f,(float16_t)0.5429687500000f,
(float16_t)-0.8422851562500f,(float16_t)0.5390625000000f,
(float16_t)-0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)-0.8471679687500f,(float16_t)0.5312500000000f,
(float16_t)-0.8496093750000f,(float16_t)0.5273437500000f,
(float16_t)-0.8520507812500f,(float16_t)0.5234375000000f,
(float16_t)-0.8544921875000f,(float16_t)0.5195312500000f,
(float16_t)-0.8569335937500f,(float16_t)0.5156250000000f,
(float16_t)-0.8593750000000f,(float16_t)0.5112304687500f,
(float16_t)-0.8618164062500f,(float16_t)0.5073242187500f,
(float16_t)-0.8637695312500f,(float16_t)0.5034179687500f,
(float16_t)-0.8662109375000f,(float16_t)0.4995117187500f,
(float16_t)-0.8686523437500f,(float16_t)0.4956054687500f,
(float16_t)-0.8706054687500f,(float16_t)0.4914550781250f,
(float16_t)-0.8730468750000f,(float16_t)0.4875488281250f,
(float16_t)-0.8754882812500f,(float16_t)0.4836425781250f,
(float16_t)-0.8774414062500f,(float16_t)0.4794921875000f,
(float16_t)-0.8798828125000f,(float16_t)0.4753417968750f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.8842773437500f,(float16_t)0.4672851562500f,
(float16_t)-0.8862304687500f,(float16_t)0.4633789062500f,
(float16_t)-0.8881835937500f,(float16_t)0.4592285156250f,
(float16_t)-0.8906250000000f,(float16_t)0.4550781250000f,
(float16_t)-0.8925781250000f,(float16_t)0.4509277343750f,
(float16_t)-0.8945312500000f,(float16_t)0.4467773437500f,
(float16_t)-0.8964843750000f,(float16_t)0.4426269531250f,
(float16_t)-0.8984375000000f,(float16_t)0.4387207031250f,
(float16_t)-0.9008789062500f,(float16_t)0.4345703125000f,
(float16_t)-0.9028320312500f,(float16_t)0.4304199218750f,
(float16_t)-0.9047851562500f,(float16_t)0.4262695312500f,
(float16_t)-0.9067382812500f,(float16_t)0.4221191406250f,
(float16_t)-0.9086914062500f,(float16_t)0.4177246093750f,
(float16_t)-0.9106445312500f,(float16_t)0.4135742187500f,
(float16_t)-0.9121093750000f,(float16_t)0.4094238281250f,
(float16_t)-0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)-0.9160156250000f,(float16_t)0.4011230468750f,
(float16_t)-0.9179687500000f,(float16_t)0.3967285156250f,
(float16_t)-0.9199218750000f,(float16_t)0.3925781250000f,
(float16_t)-0.9213867187500f,(float16_t)0.3884277343750f,
(float16_t)-0.9233398437500f,(float16_t)0.3840332031250f,
(float16_t)-0.9252929687500f,(float16_t)0.3798828125000f,
(float16_t)-0.9267578125000f,(float16_t)0.3754882812500f,
(float16_t)-0.9287109375000f,(float16_t)0.3713378906250f,
(float16_t)-0.9301757812500f,(float16_t)0.3669433593750f,
(float16_t)-0.9316406250000f,(float16_t)0.3627929687500f,
(float16_t)-0.9335937500000f,(float16_t)0.3583984375000f,
(float16_t)-0.9350585937500f,(float16_t)0.3542480468750f,
(float16_t)-0.9370117187500f,(float16_t)0.3498535156250f,
(float16_t)-0.9384765625000f,(float16_t)0.3454589843750f,
(float16_t)-0.9399414062500f,(float16_t)0.3413085937500f,
(float16_t)-0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)-0.9428710937500f,(float16_t)0.3325195312500f,
(float16_t)-0.9448242187500f,(float16_t)0.3281250000000f,
(float16_t)-0.9462890625000f,(float16_t)0.3239746093750f,
(float16_t)-0.9477539062500f,(float16_t)0.3195800781250f,
(float16_t)-0.9492187500000f,(float16_t)0.3151855468750f,
(float16_t)-0.9506835937500f,(float16_t)0.3107910156250f,
(float16_t)-0.9521484375000f,(float16_t)0.3063964843750f,
(float16_t)-0.9531250000000f,(float16_t)0.3020019531250f,
(float16_t)-0.9545898437500f,(float16_t)0.2976074218750f,
(float16_t)-0.9560546875000f,(float16_t)0.2932128906250f,
(float16_t)-0.9575195312500f,(float16_t)0.2888183593750f,
(float16_t)-0.9584960937500f,(float16_t)0.2844238281250f,
(float16_t)-0.9599609375000f,(float16_t)0.2800292968750f,
(float16_t)-0.9614257812500f,(float16_t)0.2756347656250f,
(float16_t)-0.9624023437500f,(float16_t)0.2712402343750f,
(float16_t)-0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)-0.9648437500000f,(float16_t)0.2622070312500f,
(float16_t)-0.9663085937500f,(float16_t)0.2578125000000f,
(float16_t)-0.9672851562500f,(float16_t)0.2534179687500f,
(float16_t)-0.9687500000000f,(float16_t)0.2489013671875f,
(float16_t)-0.9697265625000f,(float16_t)0.2445068359375f,
(float16_t)-0.9707031250000f,(float16_t)0.2399902343750f,
(float16_t)-0.9716796875000f,(float16_t)0.2354736328125f,
(float16_t)-0.9731445312500f,(float16_t)0.2310791015625f,
(float16_t)-0.9741210937500f,(float16_t)0.2265625000000f,
(float16_t)-0.9750976562500f,(float16_t)0.2220458984375f,
(float16_t)-0.9760742187500f,(float16_t)0.2176513671875f,
(float16_t)-0.9770507812500f,(float16_t)0.2131347656250f,
(float16_t)-0.9780273437500f,(float16_t)0.2086181640625f,
(float16_t)-0.9790039062500f,(float16_t)0.2041015625000f,
(float16_t)-0.9799804687500f,(float16_t)0.1995849609375f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9814453125000f,(float16_t)0.1905517578125f,
(float16_t)-0.9824218750000f,(float16_t)0.1860351562500f,
(float16_t)-0.9833984375000f,(float16_t)0.1815185546875f,
(float16_t)-0.9843750000000f,(float16_t)0.1770019531250f,
(float16_t)-0.9848632812500f,(float16_t)0.1724853515625f,
(float16_t)-0.9858398437500f,(float16_t)0.1679687500000f,
(float16_t)-0.9863281250000f,(float16_t)0.1634521484375f,
(float16_t)-0.9873046875000f,(float16_t)0.1588134765625f,
(float16_t)-0.9877929687500f,(float16_t)0.1542968750000f,
(float16_t)-0.9887695312500f,(float16_t)0.1497802734375f,
(float16_t)-0.9892578125000f,(float16_t)0.1452636718750f,
(float16_t)-0.9902343750000f,(float16_t)0.1406250000000f,
(float16_t)-0.9907226562500f,(float16_t)0.1361083984375f,
(float16_t)-0.9912109375000f,(float16_t)0.1315917968750f,
(float16_t)-0.9916992187500f,(float16_t)0.1269531250000f,
(float16_t)-0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)-0.9931640625000f,(float16_t)0.1178588867188f,
(float16_t)-0.9936523437500f,(float16_t)0.1132812500000f,
(float16_t)-0.9941406250000f,(float16_t)0.1087036132812f,
(float16_t)-0.9946289062500f,(float16_t)0.1041259765625f,
(float16_t)-0.9951171875000f,(float16_t)0.0995483398438f,
(float16_t)-0.9956054687500f,(float16_t)0.0949707031250f,
(float16_t)-0.9960937500000f,(float16_t)0.0903930664062f,
(float16_t)-0.9960937500000f,(float16_t)0.0858154296875f,
(float16_t)-0.9965820312500f,(float16_t)0.0812377929688f,
(float16_t)-0.9970703125000f,(float16_t)0.0765991210938f,
(float16_t)-0.9975585937500f,(float16_t)0.0720214843750f,
(float16_t)-0.9975585937500f,(float16_t)0.0674438476562f,
(float16_t)-0.9980468750000f,(float16_t)0.0628662109375f,
(float16_t)-0.9985351562500f,(float16_t)0.0582580566406f,
(float16_t)-0.9985351562500f,(float16_t)0.0536499023438f,
(float16_t)-0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)-0.9990234375000f,(float16_t)0.0444641113281f,
(float16_t)-0.9990234375000f,(float16_t)0.0398864746094f,
(float16_t)-0.9995117187500f,(float16_t)0.0352783203125f,
(float16_t)-0.9995117187500f,(float16_t)0.0306701660156f,
(float16_t)-0.9995117187500f,(float16_t)0.0260772705078f,
(float16_t)-1.0000000000000f,(float16_t)0.0214691162109f,
(float16_t)-1.0000000000000f,(float16_t)0.0168762207031f,
(float16_t)-1.0000000000000f,(float16_t)0.0122680664062f,
(float16_t)-1.0000000000000f,(float16_t)0.0076713562012f,
(float16_t)-1.0000000000000f,(float16_t)0.0030670166016f,
(float16_t)-1.0000000000000f,(float16_t)-0.0015335083008f,
(float16_t)-1.0000000000000f,(float16_t)-0.0061340332031f,
(float16_t)-1.0000000000000f,(float16_t)-0.0107345581055f,
(float16_t)-1.0000000000000f,(float16_t)-0.0153427124023f,
(float16_t)-1.0000000000000f,(float16_t)-0.0199432373047f,
(float16_t)-0.9995117187500f,(float16_t)-0.0245361328125f,
(float16_t)-0.9995117187500f,(float16_t)-0.0291442871094f,
(float16_t)-0.9995117187500f,(float16_t)-0.0337524414062f,
(float16_t)-0.9990234375000f,(float16_t)-0.0383300781250f,
(float16_t)-0.9990234375000f,(float16_t)-0.0429382324219f,
(float16_t)-0.9990234375000f,(float16_t)-0.0475463867188f,
(float16_t)-0.9985351562500f,(float16_t)-0.0521240234375f,
(float16_t)-0.9985351562500f,(float16_t)-0.0567321777344f,
(float16_t)-0.9980468750000f,(float16_t)-0.0613098144531f,
(float16_t)-0.9980468750000f,(float16_t)-0.0659179687500f,
(float16_t)-0.9975585937500f,(float16_t)-0.0704956054688f,
(float16_t)-0.9970703125000f,(float16_t)-0.0750732421875f,
(float16_t)-0.9965820312500f,(float16_t)-0.0797119140625f,
(float16_t)-0.9965820312500f,(float16_t)-0.0842895507812f,
(float16_t)-0.9960937500000f,(float16_t)-0.0888671875000f,
(float16_t)-0.9956054687500f,(float16_t)-0.0934448242188f,
(float16_t)-0.9951171875000f,(float16_t)-0.0980224609375f,
(float16_t)-0.9946289062500f,(float16_t)-0.1026000976562f,
(float16_t)-0.9941406250000f,(float16_t)-0.1071777343750f,
(float16_t)-0.9936523437500f,(float16_t)-0.1117553710938f,
(float16_t)-0.9931640625000f,(float16_t)-0.1163330078125f,
(float16_t)-0.9926757812500f,(float16_t)-0.1209106445312f,
(float16_t)-0.9921875000000f,(float16_t)-0.1254882812500f,
(float16_t)-0.9916992187500f,(float16_t)-0.1300048828125f,
(float16_t)-0.9907226562500f,(float16_t)-0.1345214843750f,
(float16_t)-0.9902343750000f,(float16_t)-0.1391601562500f,
(float16_t)-0.9897460937500f,(float16_t)-0.1436767578125f,
(float16_t)-0.9887695312500f,(float16_t)-0.1481933593750f,
(float16_t)-0.9882812500000f,(float16_t)-0.1528320312500f,
(float16_t)-0.9873046875000f,(float16_t)-0.1573486328125f,
(float16_t)-0.9868164062500f,(float16_t)-0.1618652343750f,
(float16_t)-0.9858398437500f,(float16_t)-0.1663818359375f,
(float16_t)-0.9853515625000f,(float16_t)-0.1710205078125f,
(float16_t)-0.9843750000000f,(float16_t)-0.1755371093750f,
(float16_t)-0.9838867187500f,(float16_t)-0.1800537109375f,
(float16_t)-0.9829101562500f,(float16_t)-0.1845703125000f,
(float16_t)-0.9819335937500f,(float16_t)-0.1890869140625f,
(float16_t)-0.9809570312500f,(float16_t)-0.1936035156250f,
(float16_t)-0.9799804687500f,(float16_t)-0.1981201171875f,
(float16_t)-0.9794921875000f,(float16_t)-0.2026367187500f,
(float16_t)-0.9785156250000f,(float16_t)-0.2071533203125f,
(float16_t)-0.9775390625000f,(float16_t)-0.2116699218750f,
(float16_t)-0.9765625000000f,(float16_t)-0.2160644531250f,
(float16_t)-0.9755859375000f,(float16_t)-0.2205810546875f,
(float16_t)-0.9741210937500f,(float16_t)-0.2250976562500f,
(float16_t)-0.9731445312500f,(float16_t)-0.2296142578125f,
(float16_t)-0.9721679687500f,(float16_t)-0.2340087890625f,
(float16_t)-0.9711914062500f,(float16_t)-0.2385253906250f,
(float16_t)-0.9702148437500f,(float16_t)-0.2429199218750f,
(float16_t)-0.9687500000000f,(float16_t)-0.2474365234375f,
(float16_t)-0.9677734375000f,(float16_t)-0.2519531250000f,
(float16_t)-0.9667968750000f,(float16_t)-0.2563476562500f,
(float16_t)-0.9653320312500f,(float16_t)-0.2607421875000f,
(float16_t)-0.9643554687500f,(float16_t)-0.2651367187500f,
(float16_t)-0.9628906250000f,(float16_t)-0.2697753906250f,
(float16_t)-0.9619140625000f,(float16_t)-0.2741699218750f,
(float16_t)-0.9604492187500f,(float16_t)-0.2785644531250f,
(float16_t)-0.9589843750000f,(float16_t)-0.2829589843750f,
(float16_t)-0.9580078125000f,(float16_t)-0.2873535156250f,
(float16_t)-0.9565429687500f,(float16_t)-0.2917480468750f,
(float16_t)-0.9550781250000f,(float16_t)-0.2961425781250f,
(float16_t)-0.9536132812500f,(float16_t)-0.3005371093750f,
(float16_t)-0.9521484375000f,(float16_t)-0.3049316406250f,
(float16_t)-0.9511718750000f,(float16_t)-0.3093261718750f,
(float16_t)-0.9497070312500f,(float16_t)-0.3137207031250f,
(float16_t)-0.9482421875000f,(float16_t)-0.3181152343750f,
(float16_t)-0.9467773437500f,(float16_t)-0.3225097656250f,
(float16_t)-0.9453125000000f,(float16_t)-0.3266601562500f,
(float16_t)-0.9433593750000f,(float16_t)-0.3310546875000f,
(float16_t)-0.9418945312500f,(float16_t)-0.3354492187500f,
(float16_t)-0.9404296875000f,(float16_t)-0.3398437500000f,
(float16_t)-0.9389648437500f,(float16_t)-0.3439941406250f,
(float16_t)-0.9375000000000f,(float16_t)-0.3483886718750f,
(float16_t)-0.9355468750000f,(float16_t)-0.3527832031250f,
(float16_t)-0.9340820312500f,(float16_t)-0.3569335937500f,
(float16_t)-0.9326171875000f,(float16_t)-0.3613281250000f,
(float16_t)-0.9306640625000f,(float16_t)-0.3657226562500f,
(float16_t)-0.9291992187500f,(float16_t)-0.3698730468750f,
(float16_t)-0.9272460937500f,(float16_t)-0.3742675781250f,
(float16_t)-0.9257812500000f,(float16_t)-0.3784179687500f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,
(float16_t)-0.9218750000000f,(float16_t)-0.3869628906250f,
(float16_t)-0.9204101562500f,(float16_t)-0.3911132812500f,
(float16_t)-0.9184570312500f,(float16_t)-0.3955078125000f,
(float16_t)-0.9165039062500f,(float16_t)-0.3996582031250f,
(float16_t)-0.9150390625000f,(float16_t)-0.4038085937500f,
(float16_t)-0.9130859375000f,(float16_t)-0.4079589843750f,
(float16_t)-0.9111328125000f,(float16_t)-0.4123535156250f,
(float16_t)-0.9091796875000f,(float16_t)-0.4165039062500f,
(float16_t)-0.9072265625000f,(float16_t)-0.4206542968750f,
(float16_t)-0.9052734375000f,(float16_t)-0.4248046875000f,
(float16_t)-0.9033203125000f,(float16_t)-0.4289550781250f,
(float16_t)-0.9013671875000f,(float16_t)-0.4331054687500f,
(float16_t)-0.8994140625000f,(float16_t)-0.4372558593750f,
(float16_t)-0.8974609375000f,(float16_t)-0.4414062500000f,
(float16_t)-0.8955078125000f,(float16_t)-0.4455566406250f,
(float16_t)-0.8930664062500f,(float16_t)-0.4497070312500f,
(float16_t)-0.8911132812500f,(float16_t)-0.4536132812500f,
(float16_t)-0.8891601562500f,(float16_t)-0.4577636718750f,
(float16_t)-0.8867187500000f,(float16_t)-0.4619140625000f,
(float16_t)-0.8847656250000f,(float16_t)-0.4660644531250f,
(float16_t)-0.8828125000000f,(float16_t)-0.4699707031250f,
(float16_t)-0.8803710937500f,(float16_t)-0.4741210937500f,
(float16_t)-0.8784179687500f,(float16_t)-0.4780273437500f,
(float16_t)-0.8759765625000f,(float16_t)-0.4821777343750f,
(float16_t)-0.8740234375000f,(float16_t)-0.4863281250000f,
(float16_t)-0.8715820312500f,(float16_t)-0.4902343750000f,
(float16_t)-0.8691406250000f,(float16_t)-0.4941406250000f,
(float16_t)-0.8671875000000f,(float16_t)-0.4982910156250f,
(float16_t)-0.8647460937500f,(float16_t)-0.5024414062500f,
(float16_t)-0.8623046875000f,(float16_t)-0.5063476562500f,
(float16_t)-0.8598632812500f,(float16_t)-0.5102539062500f,
(float16_t)-0.8579101562500f,(float16_t)-0.5141601562500f,
(float16_t)-0.8554687500000f,(float16_t)-0.5180664062500f,
(float16_t)-0.8530273437500f,(float16_t)-0.5219726562500f,
(float16_t)-0.8505859375000f,(float16_t)-0.5258789062500f,
(float16_t)-0.8481445312500f,(float16_t)-0.5297851562500f,
(float16_t)-0.8457031250000f,(float16_t)-0.5336914062500f,
(float16_t)-0.8432617187500f,(float16_t)-0.5375976562500f,
(float16_t)-0.8408203125000f,(float16_t)-0.5415039062500f,
(float16_t)-0.8383789062500f,(float16_t)-0.5454101562500f,
(float16_t)-0.8359375000000f,(float16_t)-0.5493164062500f,
(float16_t)-0.8330078125000f,(float16_t)-0.5532226562500f,
(float16_t)-0.8305664062500f,(float16_t)-0.5566406250000f,
(float16_t)-0.8281250000000f,(float16_t)-0.5605468750000f,
(float16_t)-0.8256835937500f,(float16_t)-0.5644531250000f,
(float16_t)-0.8227539062500f,(float16_t)-0.5683593750000f,
(float16_t)-0.8203125000000f,(float16_t)-0.5722656250000f,
(float16_t)-0.8173828125000f,(float16_t)-0.5756835937500f,
(float16_t)-0.8149414062500f,(float16_t)-0.5795898437500f,
(float16_t)-0.8120117187500f,(float16_t)-0.5834960937500f,
(float16_t)-0.8095703125000f,(float16_t)-0.5869140625000f,
(float16_t)-0.8066406250000f,(float16_t)-0.5908203125000f,
(float16_t)-0.8041992187500f,(float16_t)-0.5942382812500f,
(float16_t)-0.8012695312500f,(float16_t)-0.5981445312500f,
(float16_t)-0.7988281250000f,(float16_t)-0.6020507812500f,
(float16_t)-0.7958984375000f,(float16_t)-0.6054687500000f,
(float16_t)-0.7929687500000f,(float16_t)-0.6093750000000f,
(float16_t)-0.7900390625000f,(float16_t)-0.6127929687500f,
(float16_t)-0.7875976562500f,(float16_t)-0.6162109375000f,
(float16_t)-0.7846679687500f,(float16_t)-0.6201171875000f,
(float16_t)-0.7817382812500f,(float16_t)-0.6235351562500f,
(float16_t)-0.7788085937500f,(float16_t)-0.6274414062500f,
(float16_t)-0.7758789062500f,(float16_t)-0.6308593750000f,
(float16_t)-0.7729492187500f,(float16_t)-0.6342773437500f,
(float16_t)-0.7700195312500f,(float16_t)-0.6381835937500f,
(float16_t)-0.7670898437500f,(float16_t)-0.6416015625000f,
(float16_t)-0.7641601562500f,(float16_t)-0.6450195312500f,
(float16_t)-0.7612304687500f,(float16_t)-0.6484375000000f,
(float16_t)-0.7583007812500f,(float16_t)-0.6518554687500f,
(float16_t)-0.7553710937500f,(float16_t)-0.6552734375000f,
(float16_t)-0.7519531250000f,(float16_t)-0.6591796875000f,
(float16_t)-0.7490234375000f,(float16_t)-0.6625976562500f,
(float16_t)-0.7460937500000f,(float16_t)-0.6660156250000f,
(float16_t)-0.7431640625000f,(float16_t)-0.6694335937500f,
(float16_t)-0.7397460937500f,(float16_t)-0.6728515625000f,
(float16_t)-0.7368164062500f,(float16_t)-0.6762695312500f,
(float16_t)-0.7338867187500f,(float16_t)-0.6796875000000f,
(float16_t)-0.7304687500000f,(float16_t)-0.6826171875000f,
(float16_t)-0.7275390625000f,(float16_t)-0.6860351562500f,
(float16_t)-0.7241210937500f,(float16_t)-0.6894531250000f,
(float16_t)-0.7211914062500f,(float16_t)-0.6928710937500f,
(float16_t)-0.7177734375000f,(float16_t)-0.6962890625000f,
(float16_t)-0.7148437500000f,(float16_t)-0.6997070312500f,
(float16_t)-0.7114257812500f,(float16_t)-0.7026367187500f,
(float16_t)-0.7080078125000f,(float16_t)-0.7060546875000f,
(float16_t)-0.7050781250000f,(float16_t)-0.7094726562500f,
(float16_t)-0.7016601562500f,(float16_t)-0.7124023437500f,
(float16_t)-0.6982421875000f,(float16_t)-0.7158203125000f,
(float16_t)-0.6953125000000f,(float16_t)-0.7187500000000f,
(float16_t)-0.6918945312500f,(float16_t)-0.7221679687500f,
(float16_t)-0.6884765625000f,(float16_t)-0.7250976562500f,
(float16_t)-0.6850585937500f,(float16_t)-0.7285156250000f,
(float16_t)-0.6816406250000f,(float16_t)-0.7314453125000f,
(float16_t)-0.6782226562500f,(float16_t)-0.7348632812500f,
(float16_t)-0.6748046875000f,(float16_t)-0.7377929687500f,
(float16_t)-0.6713867187500f,(float16_t)-0.7407226562500f,
(float16_t)-0.6679687500000f,(float16_t)-0.7441406250000f,
(float16_t)-0.6645507812500f,(float16_t)-0.7470703125000f,
(float16_t)-0.6611328125000f,(float16_t)-0.7500000000000f,
(float16_t)-0.6577148437500f,(float16_t)-0.7534179687500f,
(float16_t)-0.6542968750000f,(float16_t)-0.7563476562500f,
(float16_t)-0.6508789062500f,(float16_t)-0.7592773437500f,
(float16_t)-0.6474609375000f,(float16_t)-0.7622070312500f,
(float16_t)-0.6440429687500f,(float16_t)-0.7651367187500f,
(float16_t)-0.6401367187500f,(float16_t)-0.7680664062500f,
(float16_t)-0.6367187500000f,(float16_t)-0.7709960937500f,
(float16_t)-0.6333007812500f,(float16_t)-0.7739257812500f,
(float16_t)-0.6293945312500f,(float16_t)-0.7768554687500f,
(float16_t)-0.6259765625000f,(float16_t)-0.7797851562500f,
(float16_t)-0.6225585937500f,(float16_t)-0.7827148437500f,
(float16_t)-0.6186523437500f,(float16_t)-0.7856445312500f,
(float16_t)-0.6152343750000f,(float16_t)-0.7885742187500f,
(float16_t)-0.6118164062500f,(float16_t)-0.7910156250000f,
(float16_t)-0.6079101562500f,(float16_t)-0.7939453125000f,
(float16_t)-0.6044921875000f,(float16_t)-0.7968750000000f,
(float16_t)-0.6005859375000f,(float16_t)-0.7993164062500f,
(float16_t)-0.5971679687500f,(float16_t)-0.8022460937500f,
(float16_t)-0.5932617187500f,(float16_t)-0.8051757812500f,
(float16_t)-0.5893554687500f,(float16_t)-0.8076171875000f,
(float16_t)-0.5859375000000f,(float16_t)-0.8105468750000f,
(float16_t)-0.5820312500000f,(float16_t)-0.8129882812500f,
(float16_t)-0.5781250000000f,(float16_t)-0.8159179687500f,
(float16_t)-0.5747070312500f,(float16_t)-0.8183593750000f,
(float16_t)-0.5708007812500f,(float16_t)-0.8212890625000f,
(float16_t)-0.5668945312500f,(float16_t)-0.8237304687500f,
(float16_t)-0.5629882812500f,(float16_t)-0.8261718750000f,
(float16_t)-0.5595703125000f,(float16_t)-0.8291015625000f,
(float16_t)-0.5556640625000f,(float16_t)-0.8315429687500f,
(float16_t)-0.5517578125000f,(float16_t)-0.8339843750000f,
(float16_t)-0.5478515625000f,(float16_t)-0.8364257812500f,
(float16_t)-0.5439453125000f,(float16_t)-0.8388671875000f,
(float16_t)-0.5400390625000f,(float16_t)-0.8417968750000f,
(float16_t)-0.5361328125000f,(float16_t)-0.8442382812500f,
(float16_t)-0.5322265625000f,(float16_t)-0.8466796875000f,
(float16_t)-0.5283203125000f,(float16_t)-0.8491210937500f,
(float16_t)-0.5244140625000f,(float16_t)-0.8515625000000f,
(float16_t)-0.5205078125000f,(float16_t)-0.8540039062500f,
(float16_t)-0.5166015625000f,(float16_t)-0.8559570312500f,
(float16_t)-0.5126953125000f,(float16_t)-0.8583984375000f,
(float16_t)-0.5087890625000f,(float16_t)-0.8608398437500f,
(float16_t)-0.5048828125000f,(float16_t)-0.8632812500000f,
(float16_t)-0.5009765625000f,(float16_t)-0.8657226562500f,
(float16_t)-0.4968261718750f,(float16_t)-0.8676757812500f,
(float16_t)-0.4929199218750f,(float16_t)-0.8701171875000f,
(float16_t)-0.4887695312500f,(float16_t)-0.8725585937500f,
(float16_t)-0.4848632812500f,(float16_t)-0.8745117187500f,
(float16_t)-0.4809570312500f,(float16_t)-0.8769531250000f,
(float16_t)-0.4768066406250f,(float16_t)-0.8789062500000f,
(float16_t)-0.4726562500000f,(float16_t)-0.8813476562500f,
(float16_t)-0.4687500000000f,(float16_t)-0.8833007812500f,
(float16_t)-0.4645996093750f,(float16_t)-0.8857421875000f,
(float16_t)-0.4604492187500f,(float16_t)-0.8876953125000f,
(float16_t)-0.4565429687500f,(float16_t)-0.8896484375000f,
(float16_t)-0.4523925781250f,(float16_t)-0.8916015625000f,
(float16_t)-0.4482421875000f,(float16_t)-0.8940429687500f,
(float16_t)-0.4440917968750f,(float16_t)-0.8959960937500f,
(float16_t)-0.4399414062500f,(float16_t)-0.8979492187500f,
(float16_t)-0.4357910156250f,(float16_t)-0.8999023437500f,
(float16_t)-0.4316406250000f,(float16_t)-0.9018554687500f,
(float16_t)-0.4274902343750f,(float16_t)-0.9038085937500f,
(float16_t)-0.4233398437500f,(float16_t)-0.9057617187500f,
(float16_t)-0.4191894531250f,(float16_t)-0.9077148437500f,
(float16_t)-0.4150390625000f,(float16_t)-0.9096679687500f,
(float16_t)-0.4108886718750f,(float16_t)-0.9116210937500f,
(float16_t)-0.4067382812500f,(float16_t)-0.9135742187500f,
(float16_t)-0.4023437500000f,(float16_t)-0.9155273437500f,
(float16_t)-0.3981933593750f,(float16_t)-0.9174804687500f,
(float16_t)-0.3940429687500f,(float16_t)-0.9189453125000f,
(float16_t)-0.3896484375000f,(float16_t)-0.9208984375000f,
(float16_t)-0.3854980468750f,(float16_t)-0.9228515625000f,
(float16_t)-0.3813476562500f,(float16_t)-0.9243164062500f,
(float16_t)-0.3769531250000f,(float16_t)-0.9262695312500f,
(float16_t)-0.3728027343750f,(float16_t)-0.9277343750000f,
(float16_t)-0.3684082031250f,(float16_t)-0.9296875000000f,
(float16_t)-0.3642578125000f,(float16_t)-0.9311523437500f,
(float16_t)-0.3598632812500f,(float16_t)-0.9331054687500f,
(float16_t)-0.3557128906250f,(float16_t)-0.9345703125000f,
(float16_t)-0.3513183593750f,(float16_t)-0.9360351562500f,
(float16_t)-0.3469238281250f,(float16_t)-0.9379882812500f,
(float16_t)-0.3427734375000f,(float16_t)-0.9394531250000f,
(float16_t)-0.3383789062500f,(float16_t)-0.9409179687500f,
(float16_t)-0.3339843750000f,(float16_t)-0.9423828125000f,
(float16_t)-0.3295898437500f,(float16_t)-0.9443359375000f,
(float16_t)-0.3251953125000f,(float16_t)-0.9458007812500f,
(float16_t)-0.3210449218750f,(float16_t)-0.9472656250000f,
(float16_t)-0.3166503906250f,(float16_t)-0.9487304687500f,
(float16_t)-0.3122558593750f,(float16_t)-0.9501953125000f,
(float16_t)-0.3078613281250f,(float16_t)-0.9516601562500f,
(float16_t)-0.3034667968750f,(float16_t)-0.9526367187500f,
(float16_t)-0.2990722656250f,(float16_t)-0.9541015625000f,
(float16_t)-0.2946777343750f,(float16_t)-0.9555664062500f,
(float16_t)-0.2902832031250f,(float16_t)-0.9570312500000f,
(float16_t)-0.2858886718750f,(float16_t)-0.9584960937500f,
(float16_t)-0.2814941406250f,(float16_t)-0.9594726562500f,
(float16_t)-0.2770996093750f,(float16_t)-0.9609375000000f,
(float16_t)-0.2727050781250f,(float16_t)-0.9619140625000f,
(float16_t)-0.2683105468750f,(float16_t)-0.9633789062500f,
(float16_t)-0.2636718750000f,(float16_t)-0.9643554687500f,
(float16_t)-0.2592773437500f,(float16_t)-0.9658203125000f,
(float16_t)-0.2548828125000f,(float16_t)-0.9667968750000f,
(float16_t)-0.2504882812500f,(float16_t)-0.9682617187500f,
(float16_t)-0.2459716796875f,(float16_t)-0.9692382812500f,
(float16_t)-0.2414550781250f,(float16_t)-0.9702148437500f,
(float16_t)-0.2370605468750f,(float16_t)-0.9716796875000f,
(float16_t)-0.2325439453125f,(float16_t)-0.9726562500000f,
(float16_t)-0.2280273437500f,(float16_t)-0.9736328125000f,
(float16_t)-0.2236328125000f,(float16_t)-0.9746093750000f,
(float16_t)-0.2191162109375f,(float16_t)-0.9755859375000f,
(float16_t)-0.2145996093750f,(float16_t)-0.9765625000000f,
(float16_t)-0.2100830078125f,(float16_t)-0.9775390625000f,
(float16_t)-0.2055664062500f,(float16_t)-0.9785156250000f,
(float16_t)-0.2010498046875f,(float16_t)-0.9794921875000f,
(float16_t)-0.1966552734375f,(float16_t)-0.9804687500000f,
(float16_t)-0.1921386718750f,(float16_t)-0.9814453125000f,
(float16_t)-0.1876220703125f,(float16_t)-0.9824218750000f,
(float16_t)-0.1829833984375f,(float16_t)-0.9829101562500f,
(float16_t)-0.1784667968750f,(float16_t)-0.9838867187500f,
(float16_t)-0.1739501953125f,(float16_t)-0.9848632812500f,
(float16_t)-0.1694335937500f,(float16_t)-0.9853515625000f,
(float16_t)-0.1649169921875f,(float16_t)-0.9863281250000f,
(float16_t)-0.1604003906250f,(float16_t)-0.9868164062500f,
(float16_t)-0.1558837890625f,(float16_t)-0.9877929687500f,
(float16_t)-0.1512451171875f,(float16_t)-0.9882812500000f,
(float16_t)-0.1467285156250f,(float16_t)-0.9892578125000f,
(float16_t)-0.1422119140625f,(float16_t)-0.9897460937500f,
(float16_t)-0.1375732421875f,(float16_t)-0.9907226562500f,
(float16_t)-0.1330566406250f,(float16_t)-0.9912109375000f,
(float16_t)-0.1285400390625f,(float16_t)-0.9916992187500f,
(float16_t)-0.1239624023438f,(float16_t)-0.9921875000000f,
(float16_t)-0.1193847656250f,(float16_t)-0.9926757812500f,
(float16_t)-0.1148071289062f,(float16_t)-0.9931640625000f,
(float16_t)-0.1102294921875f,(float16_t)-0.9941406250000f,
(float16_t)-0.1056518554688f,(float16_t)-0.9946289062500f,
(float16_t)-0.1010742187500f,(float16_t)-0.9951171875000f,
(float16_t)-0.0964965820312f,(float16_t)-0.9951171875000f,
(float16_t)-0.0919189453125f,(float16_t)-0.9956054687500f,
(float16_t)-0.0873413085938f,(float16_t)-0.9960937500000f,
(float16_t)-0.0827636718750f,(float16_t)-0.9965820312500f,
(float16_t)-0.0781250000000f,(float16_t)-0.9970703125000f,
(float16_t)-0.0735473632812f,(float16_t)-0.9970703125000f,
(float16_t)-0.0689697265625f,(float16_t)-0.9975585937500f,
(float16_t)-0.0643920898438f,(float16_t)-0.9980468750000f,
(float16_t)-0.0597839355469f,(float16_t)-0.9980468750000f,
(float16_t)-0.0552062988281f,(float16_t)-0.9985351562500f,
(float16_t)-0.0505981445312f,(float16_t)-0.9985351562500f,
(float16_t)-0.0459899902344f,(float16_t)-0.9990234375000f,
(float16_t)-0.0414123535156f,(float16_t)-0.9990234375000f,
(float16_t)-0.0368041992188f,(float16_t)-0.9995117187500f,
(float16_t)-0.0321960449219f,(float16_t)-0.9995117187500f,
(float16_t)-0.0276031494141f,(float16_t)-0.9995117187500f,
(float16_t)-0.0230102539062f,(float16_t)-0.9995117187500f,
(float16_t)-0.0184020996094f,(float16_t)-1.0000000000000f,
(float16_t)-0.0138015747070f,(float16_t)-1.0000000000000f,
(float16_t)-0.0092010498047f,(float16_t)-1.0000000000000f,
(float16_t)-0.0046005249023f,(float16_t)-1.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0184020996094f,
(float16_t)0.9995117187500f,(float16_t)0.0368041992188f,
(float16_t)0.9985351562500f,(float16_t)0.0552062988281f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9956054687500f,(float16_t)0.0919189453125f,
(float16_t)0.9941406250000f,(float16_t)0.1102294921875f,
(float16_t)0.9916992187500f,(float16_t)0.1285400390625f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9863281250000f,(float16_t)0.1649169921875f,
(float16_t)0.9829101562500f,(float16_t)0.1829833984375f,
(float16_t)0.9794921875000f,(float16_t)0.2010498046875f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9716796875000f,(float16_t)0.2370605468750f,
(float16_t)0.9667968750000f,(float16_t)0.2548828125000f,
(float16_t)0.9619140625000f,(float16_t)0.2727050781250f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9516601562500f,(float16_t)0.3078613281250f,
(float16_t)0.9458007812500f,(float16_t)0.3251953125000f,
(float16_t)0.9394531250000f,(float16_t)0.3427734375000f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9262695312500f,(float16_t)0.3769531250000f,
(float16_t)0.9189453125000f,(float16_t)0.3940429687500f,
(float16_t)0.9116210937500f,(float16_t)0.4108886718750f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.8959960937500f,(float16_t)0.4440917968750f,
(float16_t)0.8876953125000f,(float16_t)0.4604492187500f,
(float16_t)0.8789062500000f,(float16_t)0.4768066406250f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8608398437500f,(float16_t)0.5087890625000f,
(float16_t)0.8515625000000f,(float16_t)0.5244140625000f,
(float16_t)0.8417968750000f,(float16_t)0.5400390625000f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.8212890625000f,(float16_t)0.5708007812500f,
(float16_t)0.8105468750000f,(float16_t)0.5859375000000f,
(float16_t)0.7993164062500f,(float16_t)0.6005859375000f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7768554687500f,(float16_t)0.6293945312500f,
(float16_t)0.7651367187500f,(float16_t)0.6440429687500f,
(float16_t)0.7534179687500f,(float16_t)0.6577148437500f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.7285156250000f,(float16_t)0.6850585937500f,
(float16_t)0.7158203125000f,(float16_t)0.6982421875000f,
(float16_t)0.7026367187500f,(float16_t)0.7114257812500f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6762695312500f,(float16_t)0.7368164062500f,
(float16_t)0.6625976562500f,(float16_t)0.7490234375000f,
(float16_t)0.6484375000000f,(float16_t)0.7612304687500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.6201171875000f,(float16_t)0.7846679687500f,
(float16_t)0.6054687500000f,(float16_t)0.7958984375000f,
(float16_t)0.5908203125000f,(float16_t)0.8066406250000f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5605468750000f,(float16_t)0.8281250000000f,
(float16_t)0.5454101562500f,(float16_t)0.8383789062500f,
(float16_t)0.5297851562500f,(float16_t)0.8481445312500f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.4982910156250f,(float16_t)0.8671875000000f,
(float16_t)0.4821777343750f,(float16_t)0.8759765625000f,
(float16_t)0.4660644531250f,(float16_t)0.8847656250000f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.4331054687500f,(float16_t)0.9013671875000f,
(float16_t)0.4165039062500f,(float16_t)0.9091796875000f,
(float16_t)0.3996582031250f,(float16_t)0.9165039062500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3657226562500f,(float16_t)0.9306640625000f,
(float16_t)0.3483886718750f,(float16_t)0.9375000000000f,
(float16_t)0.3310546875000f,(float16_t)0.9433593750000f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.2961425781250f,(float16_t)0.9550781250000f,
(float16_t)0.2785644531250f,(float16_t)0.9604492187500f,
(float16_t)0.2607421875000f,(float16_t)0.9653320312500f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.2250976562500f,(float16_t)0.9741210937500f,
(float16_t)0.2071533203125f,(float16_t)0.9785156250000f,
(float16_t)0.1890869140625f,(float16_t)0.9819335937500f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.1528320312500f,(float16_t)0.9882812500000f,
(float16_t)0.1345214843750f,(float16_t)0.9907226562500f,
(float16_t)0.1163330078125f,(float16_t)0.9931640625000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0797119140625f,(float16_t)0.9965820312500f,
(float16_t)0.0613098144531f,(float16_t)0.9980468750000f,
(float16_t)0.0429382324219f,(float16_t)0.9990234375000f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)0.0061340332031f,(float16_t)1.0000000000000f,
(float16_t)-0.0122680664062f,(float16_t)1.0000000000000f,
(float16_t)-0.0306701660156f,(float16_t)0.9995117187500f,
(float16_t)-0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)-0.0674438476562f,(float16_t)0.9975585937500f,
(float16_t)-0.0858154296875f,(float16_t)0.9960937500000f,
(float16_t)-0.1041259765625f,(float16_t)0.9946289062500f,
(float16_t)-0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)-0.1406250000000f,(float16_t)0.9902343750000f,
(float16_t)-0.1588134765625f,(float16_t)0.9873046875000f,
(float16_t)-0.1770019531250f,(float16_t)0.9843750000000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.2131347656250f,(float16_t)0.9770507812500f,
(float16_t)-0.2310791015625f,(float16_t)0.9731445312500f,
(float16_t)-0.2489013671875f,(float16_t)0.9687500000000f,
(float16_t)-0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)-0.2844238281250f,(float16_t)0.9584960937500f,
(float16_t)-0.3020019531250f,(float16_t)0.9531250000000f,
(float16_t)-0.3195800781250f,(float16_t)0.9477539062500f,
(float16_t)-0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)-0.3542480468750f,(float16_t)0.9350585937500f,
(float16_t)-0.3713378906250f,(float16_t)0.9287109375000f,
(float16_t)-0.3884277343750f,(float16_t)0.9213867187500f,
(float16_t)-0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)-0.4221191406250f,(float16_t)0.9067382812500f,
(float16_t)-0.4387207031250f,(float16_t)0.8984375000000f,
(float16_t)-0.4550781250000f,(float16_t)0.8906250000000f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.4875488281250f,(float16_t)0.8730468750000f,
(float16_t)-0.5034179687500f,(float16_t)0.8637695312500f,
(float16_t)-0.5195312500000f,(float16_t)0.8544921875000f,
(float16_t)-0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)-0.5502929687500f,(float16_t)0.8349609375000f,
(float16_t)-0.5659179687500f,(float16_t)0.8247070312500f,
(float16_t)-0.5810546875000f,(float16_t)0.8139648437500f,
(float16_t)-0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)-0.6103515625000f,(float16_t)0.7919921875000f,
(float16_t)-0.6250000000000f,(float16_t)0.7807617187500f,
(float16_t)-0.6391601562500f,(float16_t)0.7690429687500f,
(float16_t)-0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)-0.6669921875000f,(float16_t)0.7451171875000f,
(float16_t)-0.6806640625000f,(float16_t)0.7324218750000f,
(float16_t)-0.6938476562500f,(float16_t)0.7202148437500f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.7202148437500f,(float16_t)0.6938476562500f,
(float16_t)-0.7324218750000f,(float16_t)0.6806640625000f,
(float16_t)-0.7451171875000f,(float16_t)0.6669921875000f,
(float16_t)-0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)-0.7690429687500f,(float16_t)0.6391601562500f,
(float16_t)-0.7807617187500f,(float16_t)0.6250000000000f,
(float16_t)-0.7919921875000f,(float16_t)0.6103515625000f,
(float16_t)-0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)-0.8139648437500f,(float16_t)0.5810546875000f,
(float16_t)-0.8247070312500f,(float16_t)0.5659179687500f,
(float16_t)-0.8349609375000f,(float16_t)0.5502929687500f,
(float16_t)-0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)-0.8544921875000f,(float16_t)0.5195312500000f,
(float16_t)-0.8637695312500f,(float16_t)0.5034179687500f,
(float16_t)-0.8730468750000f,(float16_t)0.4875488281250f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.8906250000000f,(float16_t)0.4550781250000f,
(float16_t)-0.8984375000000f,(float16_t)0.4387207031250f,
(float16_t)-0.9067382812500f,(float16_t)0.4221191406250f,
(float16_t)-0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)-0.9213867187500f,(float16_t)0.3884277343750f,
(float16_t)-0.9287109375000f,(float16_t)0.3713378906250f,
(float16_t)-0.9350585937500f,(float16_t)0.3542480468750f,
(float16_t)-0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)-0.9477539062500f,(float16_t)0.3195800781250f,
(float16_t)-0.9531250000000f,(float16_t)0.3020019531250f,
(float16_t)-0.9584960937500f,(float16_t)0.2844238281250f,
(float16_t)-0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)-0.9687500000000f,(float16_t)0.2489013671875f,
(float16_t)-0.9731445312500f,(float16_t)0.2310791015625f,
(float16_t)-0.9770507812500f,(float16_t)0.2131347656250f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9843750000000f,(float16_t)0.1770019531250f,
(float16_t)-0.9873046875000f,(float16_t)0.1588134765625f,
(float16_t)-0.9902343750000f,(float16_t)0.1406250000000f,
(float16_t)-0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)-0.9946289062500f,(float16_t)0.1041259765625f,
(float16_t)-0.9960937500000f,(float16_t)0.0858154296875f,
(float16_t)-0.9975585937500f,(float16_t)0.0674438476562f,
(float16_t)-0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)-0.9995117187500f,(float16_t)0.0306701660156f,
(float16_t)-1.0000000000000f,(float16_t)0.0122680664062f,
(float16_t)-1.0000000000000f,(float16_t)-0.0061340332031f,
(float16_t)-0.9995117187500f,(float16_t)-0.0245361328125f,
(float16_t)-0.9990234375000f,(float16_t)-0.0429382324219f,
(float16_t)-0.9980468750000f,(float16_t)-0.0613098144531f,
(float16_t)-0.9965820312500f,(float16_t)-0.0797119140625f,
(float16_t)-0.9951171875000f,(float16_t)-0.0980224609375f,
(float16_t)-0.9931640625000f,(float16_t)-0.1163330078125f,
(float16_t)-0.9907226562500f,(float16_t)-0.1345214843750f,
(float16_t)-0.9882812500000f,(float16_t)-0.1528320312500f,
(float16_t)-0.9853515625000f,(float16_t)-0.1710205078125f,
(float16_t)-0.9819335937500f,(float16_t)-0.1890869140625f,
(float16_t)-0.9785156250000f,(float16_t)-0.2071533203125f,
(float16_t)-0.9741210937500f,(float16_t)-0.2250976562500f,
(float16_t)-0.9702148437500f,(float16_t)-0.2429199218750f,
(float16_t)-0.9653320312500f,(float16_t)-0.2607421875000f,
(float16_t)-0.9604492187500f,(float16_t)-0.2785644531250f,
(float16_t)-0.9550781250000f,(float16_t)-0.2961425781250f,
(float16_t)-0.9497070312500f,(float16_t)-0.3137207031250f,
(float16_t)-0.9433593750000f,(float16_t)-0.3310546875000f,
(float16_t)-0.9375000000000f,(float16_t)-0.3483886718750f,
(float16_t)-0.9306640625000f,(float16_t)-0.3657226562500f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,
(float16_t)-0.9165039062500f,(float16_t)-0.3996582031250f,
(float16_t)-0.9091796875000f,(float16_t)-0.4165039062500f,
(float16_t)-0.9013671875000f,(float16_t)-0.4331054687500f,
(float16_t)-0.8930664062500f,(float16_t)-0.4497070312500f,
(float16_t)-0.8847656250000f,(float16_t)-0.4660644531250f,
(float16_t)-0.8759765625000f,(float16_t)-0.4821777343750f,
(float16_t)-0.8671875000000f,(float16_t)-0.4982910156250f,
(float16_t)-0.8579101562500f,(float16_t)-0.5141601562500f,
(float16_t)-0.8481445312500f,(float16_t)-0.5297851562500f,
(float16_t)-0.8383789062500f,(float16_t)-0.5454101562500f,
(float16_t)-0.8281250000000f,(float16_t)-0.5605468750000f,
(float16_t)-0.8173828125000f,(float16_t)-0.5756835937500f,
(float16_t)-0.8066406250000f,(float16_t)-0.5908203125000f,
(float16_t)-0.7958984375000f,(float16_t)-0.6054687500000f,
(float16_t)-0.7846679687500f,(float16_t)-0.6201171875000f,
(float16_t)-0.7729492187500f,(float16_t)-0.6342773437500f,
(float16_t)-0.7612304687500f,(float16_t)-0.6484375000000f,
(float16_t)-0.7490234375000f,(float16_t)-0.6625976562500f,
(float16_t)-0.7368164062500f,(float16_t)-0.6762695312500f,
(float16_t)-0.7241210937500f,(float16_t)-0.6894531250000f,
(float16_t)-0.7114257812500f,(float16_t)-0.7026367187500f,
(float16_t)-0.6982421875000f,(float16_t)-0.7158203125000f,
(float16_t)-0.6850585937500f,(float16_t)-0.7285156250000f,
(float16_t)-0.6713867187500f,(float16_t)-0.7407226562500f,
(float16_t)-0.6577148437500f,(float16_t)-0.7534179687500f,
(float16_t)-0.6440429687500f,(float16_t)-0.7651367187500f,
(float16_t)-0.6293945312500f,(float16_t)-0.7768554687500f,
(float16_t)-0.6152343750000f,(float16_t)-0.7885742187500f,
(float16_t)-0.6005859375000f,(float16_t)-0.7993164062500f,
(float16_t)-0.5859375000000f,(float16_t)-0.8105468750000f,
(float16_t)-0.5708007812500f,(float16_t)-0.8212890625000f,
(float16_t)-0.5556640625000f,(float16_t)-0.8315429687500f,
(float16_t)-0.5400390625000f,(float16_t)-0.8417968750000f,
(float16_t)-0.5244140625000f,(float16_t)-0.8515625000000f,
(float16_t)-0.5087890625000f,(float16_t)-0.8608398437500f,
(float16_t)-0.4929199218750f,(float16_t)-0.8701171875000f,
(float16_t)-0.4768066406250f,(float16_t)-0.8789062500000f,
(float16_t)-0.4604492187500f,(float16_t)-0.8876953125000f,
(float16_t)-0.4440917968750f,(float16_t)-0.8959960937500f,
(float16_t)-0.4274902343750f,(float16_t)-0.9038085937500f,
(float16_t)-0.4108886718750f,(float16_t)-0.9116210937500f,
(float16_t)-0.3940429687500f,(float16_t)-0.9189453125000f,
(float16_t)-0.3769531250000f,(float16_t)-0.9262695312500f,
(float16_t)-0.3598632812500f,(float16_t)-0.9331054687500f,
(float16_t)-0.3427734375000f,(float16_t)-0.9394531250000f,
(float16_t)-0.3251953125000f,(float16_t)-0.9458007812500f,
(float16_t)-0.3078613281250f,(float16_t)-0.9516601562500f,
(float16_t)-0.2902832031250f,(float16_t)-0.9570312500000f,
(float16_t)-0.2727050781250f,(float16_t)-0.9619140625000f,
(float16_t)-0.2548828125000f,(float16_t)-0.9667968750000f,
(float16_t)-0.2370605468750f,(float16_t)-0.9716796875000f,
(float16_t)-0.2191162109375f,(float16_t)-0.9755859375000f,
(float16_t)-0.2010498046875f,(float16_t)-0.9794921875000f,
(float16_t)-0.1829833984375f,(float16_t)-0.9829101562500f,
(float16_t)-0.1649169921875f,(float16_t)-0.9863281250000f,
(float16_t)-0.1467285156250f,(float16_t)-0.9892578125000f,
(float16_t)-0.1285400390625f,(float16_t)-0.9916992187500f,
(float16_t)-0.1102294921875f,(float16_t)-0.9941406250000f,
(float16_t)-0.0919189453125f,(float16_t)-0.9956054687500f,
(float16_t)-0.0735473632812f,(float16_t)-0.9970703125000f,
(float16_t)-0.0552062988281f,(float16_t)-0.9985351562500f,
(float16_t)-0.0368041992188f,(float16_t)-0.9995117187500f,
(float16_t)-0.0184020996094f,(float16_t)-1.0000000000000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9970703125000f,(float16_t)0.0735473632812f,
(float16_t)0.9892578125000f,(float16_t)0.1467285156250f,
(float16_t)0.9755859375000f,(float16_t)0.2191162109375f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.9331054687500f,(float16_t)0.3598632812500f,
(float16_t)0.9038085937500f,(float16_t)0.4274902343750f,
(float16_t)0.8701171875000f,(float16_t)0.4929199218750f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.7885742187500f,(float16_t)0.6152343750000f,
(float16_t)0.7407226562500f,(float16_t)0.6713867187500f,
(float16_t)0.6894531250000f,(float16_t)0.7241210937500f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.5756835937500f,(float16_t)0.8173828125000f,
(float16_t)0.5141601562500f,(float16_t)0.8579101562500f,
(float16_t)0.4497070312500f,(float16_t)0.8930664062500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.3137207031250f,(float16_t)0.9497070312500f,
(float16_t)0.2429199218750f,(float16_t)0.9702148437500f,
(float16_t)0.1710205078125f,(float16_t)0.9853515625000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)0.0245361328125f,(float16_t)0.9995117187500f,
(float16_t)-0.0490722656250f,(float16_t)0.9990234375000f,
(float16_t)-0.1224365234375f,(float16_t)0.9926757812500f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.2666015625000f,(float16_t)0.9638671875000f,
(float16_t)-0.3369140625000f,(float16_t)0.9414062500000f,
(float16_t)-0.4052734375000f,(float16_t)0.9140625000000f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.5351562500000f,(float16_t)0.8447265625000f,
(float16_t)-0.5957031250000f,(float16_t)0.8032226562500f,
(float16_t)-0.6533203125000f,(float16_t)0.7573242187500f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.7573242187500f,(float16_t)0.6533203125000f,
(float16_t)-0.8032226562500f,(float16_t)0.5957031250000f,
(float16_t)-0.8447265625000f,(float16_t)0.5351562500000f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.9140625000000f,(float16_t)0.4052734375000f,
(float16_t)-0.9414062500000f,(float16_t)0.3369140625000f,
(float16_t)-0.9638671875000f,(float16_t)0.2666015625000f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9926757812500f,(float16_t)0.1224365234375f,
(float16_t)-0.9990234375000f,(float16_t)0.0490722656250f,
(float16_t)-0.9995117187500f,(float16_t)-0.0245361328125f,
(float16_t)-0.9951171875000f,(float16_t)-0.0980224609375f,
(float16_t)-0.9853515625000f,(float16_t)-0.1710205078125f,
(float16_t)-0.9702148437500f,(float16_t)-0.2429199218750f,
(float16_t)-0.9497070312500f,(float16_t)-0.3137207031250f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,
(float16_t)-0.8930664062500f,(float16_t)-0.4497070312500f,
(float16_t)-0.8579101562500f,(float16_t)-0.5141601562500f,
(float16_t)-0.8173828125000f,(float16_t)-0.5756835937500f,
(float16_t)-0.7729492187500f,(float16_t)-0.6342773437500f,
(float16_t)-0.7241210937500f,(float16_t)-0.6894531250000f,
(float16_t)-0.6713867187500f,(float16_t)-0.7407226562500f,
(float16_t)-0.6152343750000f,(float16_t)-0.7885742187500f,
(float16_t)-0.5556640625000f,(float16_t)-0.8315429687500f,
(float16_t)-0.4929199218750f,(float16_t)-0.8701171875000f,
(float16_t)-0.4274902343750f,(float16_t)-0.9038085937500f,
(float16_t)-0.3598632812500f,(float16_t)-0.9331054687500f,
(float16_t)-0.2902832031250f,(float16_t)-0.9570312500000f,
(float16_t)-0.2191162109375f,(float16_t)-0.9755859375000f,
(float16_t)-0.1467285156250f,(float16_t)-0.9892578125000f,
(float16_t)-0.0735473632812f,(float16_t)-0.9970703125000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.9570312500000f,(float16_t)0.2902832031250f,
(float16_t)0.8315429687500f,(float16_t)0.5556640625000f,
(float16_t)0.6342773437500f,(float16_t)0.7729492187500f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)0.0980224609375f,(float16_t)0.9951171875000f,
(float16_t)-0.1950683593750f,(float16_t)0.9809570312500f,
(float16_t)-0.4714355468750f,(float16_t)0.8818359375000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.8818359375000f,(float16_t)0.4714355468750f,
(float16_t)-0.9809570312500f,(float16_t)0.1950683593750f,
(float16_t)-0.9951171875000f,(float16_t)-0.0980224609375f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,
(float16_t)-0.7729492187500f,(float16_t)-0.6342773437500f,
(float16_t)-0.5556640625000f,(float16_t)-0.8315429687500f,
(float16_t)-0.2902832031250f,(float16_t)-0.9570312500000f,
(float16_t)1.0000000000000f,(float16_t)0.0000000000000f,
(float16_t)0.3825683593750f,(float16_t)0.9238281250000f,
(float16_t)-0.7070312500000f,(float16_t)0.7070312500000f,
(float16_t)-0.9238281250000f,(float16_t)-0.3825683593750f,};

#endif



#endif /* !defined(ARM_DSP_CONFIG_TABLES) || defined(ARM_FFT_ALLOW_TABLES) */
#endif /* defined(ARM_MATH_MVE_FLOAT16) && !defined(ARM_MATH_AUTOVECTORIZE) */

#endif /* if defined(ARM_FLOAT16_SUPPORTED) */

#endif // EIDSP_LOAD_CMSIS_DSP_SOURCES
