/* Generated by Edge Impulse
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef _EI_CLASSIFIER_MODEL_METADATA_H_
#define _EI_CLASSIFIER_MODEL_METADATA_H_

#include <stdint.h>
#include <stdbool.h>

#define EI_CLASSIFIER_NONE                       255
#define EI_CLASSIFIER_UTENSOR                    1
#define EI_CLASSIFIER_TFLITE                     2
#define EI_CLASSIFIER_CUBEAI                     3
#define EI_CLASSIFIER_TFLITE_FULL                4
#define EI_CLASSIFIER_TENSAIFLOW                 5
#define EI_CLASSIFIER_TENSORRT                   6
#define EI_CLASSIFIER_DRPAI                      7
#define EI_CLASSIFIER_TFLITE_TIDL                8
#define EI_CLASSIFIER_AKIDA                      9
#define EI_CLASSIFIER_SYNTIANT                   10
#define EI_CLASSIFIER_ONNX_TIDL                  11
#define EI_CLASSIFIER_MEMRYX                     12

#define EI_CLASSIFIER_SENSOR_UNKNOWN             -1
#define EI_CLASSIFIER_SENSOR_MICROPHONE          1
#define EI_CLASSIFIER_SENSOR_ACCELEROMETER       2
#define EI_CLASSIFIER_SENSOR_CAMERA              3
#define EI_CLASSIFIER_SENSOR_9DOF                4
#define EI_CLASSIFIER_SENSOR_ENVIRONMENTAL       5
#define EI_CLASSIFIER_SENSOR_FUSION              6

#define EI_ANOMALY_TYPE_UNKNOWN                   0
#define EI_ANOMALY_TYPE_KMEANS                    1
#define EI_ANOMALY_TYPE_GMM                       2
#define EI_ANOMALY_TYPE_VISUAL_GMM                3

// These must match the enum values in TensorFlow Lite's "TfLiteType"
#define EI_CLASSIFIER_DATATYPE_FLOAT32           1
#define EI_CLASSIFIER_DATATYPE_UINT8             3
#define EI_CLASSIFIER_DATATYPE_INT8              9

#define EI_CLASSIFIER_PROJECT_ID                 366673
#define EI_CLASSIFIER_PROJECT_OWNER              "Edge Impulse Experts"
#define EI_CLASSIFIER_PROJECT_NAME               "Aquatic Air Bubble Detection"
#define EI_CLASSIFIER_PROJECT_DEPLOY_VERSION     4
#define EI_CLASSIFIER_NN_INPUT_FRAME_SIZE        400
#define EI_CLASSIFIER_RAW_SAMPLE_COUNT           1
#define EI_CLASSIFIER_RAW_SAMPLES_PER_FRAME      400
#define EI_CLASSIFIER_DSP_INPUT_FRAME_SIZE       (EI_CLASSIFIER_RAW_SAMPLE_COUNT * EI_CLASSIFIER_RAW_SAMPLES_PER_FRAME)
#define EI_CLASSIFIER_INPUT_WIDTH                0
#define EI_CLASSIFIER_INPUT_HEIGHT               0
#define EI_CLASSIFIER_INPUT_FRAMES               0
#define EI_CLASSIFIER_NN_OUTPUT_COUNT            2
#define EI_CLASSIFIER_INTERVAL_MS                1000
#define EI_CLASSIFIER_LABEL_COUNT                2
#define EI_CLASSIFIER_HAS_ANOMALY                EI_ANOMALY_TYPE_UNKNOWN
#define EI_CLASSIFIER_HAS_VISUAL_ANOMALY         0
#define EI_CLASSIFIER_SINGLE_FEATURE_INPUT       1
#define EI_CLASSIFIER_FREQUENCY                  1
#define EI_CLASSIFIER_HAS_MODEL_VARIABLES        1

#define EI_CLASSIFIER_OBJECT_DETECTION             0
#define EI_CLASSIFIER_TFLITE_OUTPUT_DATA_TENSOR    0
#define EI_CLASSIFIER_OBJECT_DETECTION_LAST_LAYER  EI_CLASSIFIER_LAST_LAYER_UNKNOWN

#define EI_CLASSIFIER_TFLITE_INPUT_DATATYPE         EI_CLASSIFIER_DATATYPE_FLOAT32
#define EI_CLASSIFIER_TFLITE_OUTPUT_DATATYPE        EI_CLASSIFIER_DATATYPE_FLOAT32


#define EI_CLASSIFIER_INFERENCING_ENGINE            EI_CLASSIFIER_TFLITE

#define EI_CLASSIFIER_QUANTIZATION_ENABLED          0

#define EI_CLASSIFIER_COMPILED                      1
#define EI_CLASSIFIER_HAS_TFLITE_OPS_RESOLVER       1

#define EI_CLASSIFIER_LOAD_IMAGE_SCALING         0


#define EI_CLASSIFIER_HAS_FFT_INFO               1
#define EI_CLASSIFIER_LOAD_FFT_32                0
#define EI_CLASSIFIER_LOAD_FFT_64                0
#define EI_CLASSIFIER_LOAD_FFT_128               0
#define EI_CLASSIFIER_LOAD_FFT_256               0
#define EI_CLASSIFIER_LOAD_FFT_512               0
#define EI_CLASSIFIER_LOAD_FFT_1024              0
#define EI_CLASSIFIER_LOAD_FFT_2048              0
#define EI_CLASSIFIER_LOAD_FFT_4096              0

#define EI_DSP_PARAMS_GENERATED 1


#define EI_CLASSIFIER_SENSOR                     EI_CLASSIFIER_SENSOR_FUSION
#define EI_CLASSIFIER_FUSION_AXES_STRING         "p_0 + p_1 + p_2 + p_3 + p_4 + p_5 + p_6 + p_7 + p_8 + p_9 + p_10 + p_11 + p_12 + p_13 + p_14 + p_15 + p_16 + p_17 + p_18 + p_19 + p_20 + p_21 + p_22 + p_23 + p_24 + p_25 + p_26 + p_27 + p_28 + p_29 + p_30 + p_31 + p_32 + p_33 + p_34 + p_35 + p_36 + p_37 + p_38 + p_39 + p_40 + p_41 + p_42 + p_43 + p_44 + p_45 + p_46 + p_47 + p_48 + p_49 + p_50 + p_51 + p_52 + p_53 + p_54 + p_55 + p_56 + p_57 + p_58 + p_59 + p_60 + p_61 + p_62 + p_63 + p_64 + p_65 + p_66 + p_67 + p_68 + p_69 + p_70 + p_71 + p_72 + p_73 + p_74 + p_75 + p_76 + p_77 + p_78 + p_79 + p_80 + p_81 + p_82 + p_83 + p_84 + p_85 + p_86 + p_87 + p_88 + p_89 + p_90 + p_91 + p_92 + p_93 + p_94 + p_95 + p_96 + p_97 + p_98 + p_99 + p_100 + p_101 + p_102 + p_103 + p_104 + p_105 + p_106 + p_107 + p_108 + p_109 + p_110 + p_111 + p_112 + p_113 + p_114 + p_115 + p_116 + p_117 + p_118 + p_119 + p_120 + p_121 + p_122 + p_123 + p_124 + p_125 + p_126 + p_127 + p_128 + p_129 + p_130 + p_131 + p_132 + p_133 + p_134 + p_135 + p_136 + p_137 + p_138 + p_139 + p_140 + p_141 + p_142 + p_143 + p_144 + p_145 + p_146 + p_147 + p_148 + p_149 + p_150 + p_151 + p_152 + p_153 + p_154 + p_155 + p_156 + p_157 + p_158 + p_159 + p_160 + p_161 + p_162 + p_163 + p_164 + p_165 + p_166 + p_167 + p_168 + p_169 + p_170 + p_171 + p_172 + p_173 + p_174 + p_175 + p_176 + p_177 + p_178 + p_179 + p_180 + p_181 + p_182 + p_183 + p_184 + p_185 + p_186 + p_187 + p_188 + p_189 + p_190 + p_191 + p_192 + p_193 + p_194 + p_195 + p_196 + p_197 + p_198 + p_199 + p_200 + p_201 + p_202 + p_203 + p_204 + p_205 + p_206 + p_207 + p_208 + p_209 + p_210 + p_211 + p_212 + p_213 + p_214 + p_215 + p_216 + p_217 + p_218 + p_219 + p_220 + p_221 + p_222 + p_223 + p_224 + p_225 + p_226 + p_227 + p_228 + p_229 + p_230 + p_231 + p_232 + p_233 + p_234 + p_235 + p_236 + p_237 + p_238 + p_239 + p_240 + p_241 + p_242 + p_243 + p_244 + p_245 + p_246 + p_247 + p_248 + p_249 + p_250 + p_251 + p_252 + p_253 + p_254 + p_255 + p_256 + p_257 + p_258 + p_259 + p_260 + p_261 + p_262 + p_263 + p_264 + p_265 + p_266 + p_267 + p_268 + p_269 + p_270 + p_271 + p_272 + p_273 + p_274 + p_275 + p_276 + p_277 + p_278 + p_279 + p_280 + p_281 + p_282 + p_283 + p_284 + p_285 + p_286 + p_287 + p_288 + p_289 + p_290 + p_291 + p_292 + p_293 + p_294 + p_295 + p_296 + p_297 + p_298 + p_299 + p_300 + p_301 + p_302 + p_303 + p_304 + p_305 + p_306 + p_307 + p_308 + p_309 + p_310 + p_311 + p_312 + p_313 + p_314 + p_315 + p_316 + p_317 + p_318 + p_319 + p_320 + p_321 + p_322 + p_323 + p_324 + p_325 + p_326 + p_327 + p_328 + p_329 + p_330 + p_331 + p_332 + p_333 + p_334 + p_335 + p_336 + p_337 + p_338 + p_339 + p_340 + p_341 + p_342 + p_343 + p_344 + p_345 + p_346 + p_347 + p_348 + p_349 + p_350 + p_351 + p_352 + p_353 + p_354 + p_355 + p_356 + p_357 + p_358 + p_359 + p_360 + p_361 + p_362 + p_363 + p_364 + p_365 + p_366 + p_367 + p_368 + p_369 + p_370 + p_371 + p_372 + p_373 + p_374 + p_375 + p_376 + p_377 + p_378 + p_379 + p_380 + p_381 + p_382 + p_383 + p_384 + p_385 + p_386 + p_387 + p_388 + p_389 + p_390 + p_391 + p_392 + p_393 + p_394 + p_395 + p_396 + p_397 + p_398 + p_399"
#define EI_CLASSIFIER_CALIBRATION_ENABLED        0

#ifndef EI_CLASSIFIER_SLICES_PER_MODEL_WINDOW
#define EI_CLASSIFIER_SLICES_PER_MODEL_WINDOW    4
#endif // EI_CLASSIFIER_SLICES_PER_MODEL_WINDOW
#define EI_CLASSIFIER_SLICE_SIZE                 (EI_CLASSIFIER_RAW_SAMPLE_COUNT / EI_CLASSIFIER_SLICES_PER_MODEL_WINDOW)

#define EI_STUDIO_VERSION_MAJOR             1
#define EI_STUDIO_VERSION_MINOR             48
#define EI_STUDIO_VERSION_PATCH             2

#if ((EI_CLASSIFIER_INFERENCING_ENGINE == EI_CLASSIFIER_TFLITE) ||      (EI_CLASSIFIER_INFERENCING_ENGINE == EI_CLASSIFIER_DRPAI)) &&      EI_CLASSIFIER_USE_FULL_TFLITE == 1

#if EI_CLASSIFIER_INFERENCING_ENGINE == EI_CLASSIFIER_TFLITE
#undef EI_CLASSIFIER_INFERENCING_ENGINE
#define EI_CLASSIFIER_INFERENCING_ENGINE          EI_CLASSIFIER_TFLITE_FULL
#endif

#undef EI_CLASSIFIER_HAS_TFLITE_OPS_RESOLVER
#define EI_CLASSIFIER_HAS_TFLITE_OPS_RESOLVER     0

#if EI_CLASSIFIER_COMPILED == 1
#error "Cannot use full TensorFlow Lite with EON"
#endif
#endif // ((EI_CLASSIFIER_INFERENCING_ENGINE == EI_CLASSIFIER_TFLITE) || (EI_CLASSIFIER_INFERENCING_ENGINE == EI_CLASSIFIER_DRPAI)) && EI_CLASSIFIER_USE_FULL_TFLITE == 1

typedef struct {
    uint32_t block_id;
    uint16_t implementation_version;
    int axes;
    float scale_axes;
    bool average;
    bool minimum;
    bool maximum;
    bool rms;
    bool stdev;
    bool skewness;
    bool kurtosis;
    int moving_avg_num_windows;
} ei_dsp_config_flatten_t;

typedef struct {
    uint32_t block_id;
    uint16_t implementation_version;
    int axes;
    const char * channels;
} ei_dsp_config_image_t;

typedef struct {
    uint32_t block_id;
    uint16_t implementation_version;
    int axes;
    int num_cepstral;
    float frame_length;
    float frame_stride;
    int num_filters;
    int fft_length;
    int win_size;
    int low_frequency;
    int high_frequency;
    float pre_cof;
    int pre_shift;
} ei_dsp_config_mfcc_t;

typedef struct {
    uint32_t block_id;
    uint16_t implementation_version;
    int axes;
    float frame_length;
    float frame_stride;
    int num_filters;
    int fft_length;
    int low_frequency;
    int high_frequency;
    int win_size;
    int noise_floor_db;
} ei_dsp_config_mfe_t;

typedef struct {
    uint32_t block_id;
    uint16_t implementation_version;
    int axes;
    float scale_axes;
} ei_dsp_config_raw_t;

typedef struct {
    uint32_t block_id;
    uint16_t implementation_version;
    int axes;
    float scale_axes;
    int input_decimation_ratio;
    const char * filter_type;
    float filter_cutoff;
    int filter_order;
    const char * analysis_type;
    int fft_length;
    int spectral_peaks_count;
    float spectral_peaks_threshold;
    const char * spectral_power_edges;
    bool do_log;
    bool do_fft_overlap;
    int wavelet_level;
    const char * wavelet;
    bool extra_low_freq;
} ei_dsp_config_spectral_analysis_t;

typedef struct {
    uint32_t block_id;
    uint16_t implementation_version;
    int axes;
    float frame_length;
    float frame_stride;
    int fft_length;
    int noise_floor_db;
    bool show_axes;
} ei_dsp_config_spectrogram_t;

typedef struct {
    uint32_t block_id;
    uint16_t implementation_version;
    int axes;
    float frame_length;
    float frame_stride;
    int num_filters;
    int fft_length;
    int low_frequency;
    int high_frequency;
    float pre_cof;
    const char * extractor;
} ei_dsp_config_audio_syntiant_t;

typedef struct {
    uint32_t block_id;
    uint16_t implementation_version;
    int axes;
    bool scaling;
    bool scaling_raw;
    bool padding;
} ei_dsp_config_imu_syntiant_t;

#endif // _EI_CLASSIFIER_MODEL_METADATA_H_
