/* Generated by Edge Impulse
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef _EI_CLASSIFIER_MODEL_VARIABLES_H_
#define _EI_CLASSIFIER_MODEL_VARIABLES_H_

#include <stdint.h>
#include "model_metadata.h"

#include "tflite-model/tflite_learn_5_compiled.h"
#include "edge-impulse-sdk/classifier/ei_model_types.h"
#include "edge-impulse-sdk/classifier/inferencing_engines/engines.h"

const char* ei_classifier_inferencing_categories[] = { "bubble", "normal" };

uint8_t ei_dsp_config_6_axes[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399 };
const uint32_t ei_dsp_config_6_axes_size = 400;
ei_dsp_config_raw_t ei_dsp_config_6 = {
    6, // uint32_t blockId
    1, // int implementationVersion
    400, // int length of axes
    1.0f // float scale-axes
};

const size_t ei_dsp_blocks_size = 1;
ei_model_dsp_t ei_dsp_blocks[ei_dsp_blocks_size] = {
    { // DSP block 6
        6,
        400, // output size
        &extract_raw_features, // DSP function pointer
        (void*)&ei_dsp_config_6, // pointer to config struct
        ei_dsp_config_6_axes, // array of offsets into the input stream, one for each axis
        ei_dsp_config_6_axes_size, // number of axes
        1, // version
        nullptr, // factory function
    }
};
const ei_config_tflite_eon_graph_t ei_config_tflite_graph_5 = {
    .implementation_version = 1,
    .model_init = &tflite_learn_5_init,
    .model_invoke = &tflite_learn_5_invoke,
    .model_reset = &tflite_learn_5_reset,
    .model_input = &tflite_learn_5_input,
    .model_output = &tflite_learn_5_output,
};

const ei_learning_block_config_tflite_graph_t ei_learning_block_config_5 = {
    .implementation_version = 1,
    .classification_mode = EI_CLASSIFIER_CLASSIFICATION_MODE_CLASSIFICATION,
    .block_id = 5,
    .object_detection = 0,
    .object_detection_last_layer = EI_CLASSIFIER_LAST_LAYER_UNKNOWN,
    .output_data_tensor = 0,
    .output_labels_tensor = 1,
    .output_score_tensor = 2,
    .threshold = 0,
    .quantized = 0,
    .compiled = 1,
    .graph_config = (void*)&ei_config_tflite_graph_5
};

const size_t ei_learning_blocks_size = 1;
const uint32_t ei_learning_block_5_inputs[1] = { 6 };
const uint32_t ei_learning_block_5_inputs_size = 1;
const ei_learning_block_t ei_learning_blocks[ei_learning_blocks_size] = {
    {
        5,
        false,
        &run_nn_inference,
        (void*)&ei_learning_block_config_5,
        EI_CLASSIFIER_IMAGE_SCALING_NONE,
        ei_learning_block_5_inputs,
        ei_learning_block_5_inputs_size,
        2
    },
};

const ei_model_performance_calibration_t ei_calibration = {
    1, /* integer version number */
    false, /* has configured performance calibration */
    (int32_t)(EI_CLASSIFIER_RAW_SAMPLE_COUNT / ((EI_CLASSIFIER_FREQUENCY > 0) ? EI_CLASSIFIER_FREQUENCY : 1)) * 1000, /* Model window */
    0.8f, /* Default threshold */
    (int32_t)(EI_CLASSIFIER_RAW_SAMPLE_COUNT / ((EI_CLASSIFIER_FREQUENCY > 0) ? EI_CLASSIFIER_FREQUENCY : 1)) * 500, /* Half of model window */
    0   /* Don't use flags */
};
const ei_object_detection_nms_config_t ei_object_detection_nms = {
    0.0f, /* NMS confidence threshold */
    0.2f  /* NMS IOU threshold */
};

const ei_impulse_t impulse_366673_0 = {
    .project_id = 366673,
    .project_owner = "Edge Impulse Experts",
    .project_name = "Aquatic Air Bubble Detection",
    .deploy_version = 4,

    .nn_input_frame_size = 400,
    .raw_sample_count = 1,
    .raw_samples_per_frame = 400,
    .dsp_input_frame_size = 1 * 400,
    .input_width = 0,
    .input_height = 0,
    .input_frames = 0,
    .interval_ms = 1000,
    .frequency = 1,
    .dsp_blocks_size = ei_dsp_blocks_size,
    .dsp_blocks = ei_dsp_blocks,
    
    .object_detection_count = 0,
    .fomo_output_size = 0,
    
    .tflite_output_features_count = 2,
    .learning_blocks_size = ei_learning_blocks_size,
    .learning_blocks = ei_learning_blocks,

    .inferencing_engine = EI_CLASSIFIER_TFLITE,

    .sensor = EI_CLASSIFIER_SENSOR_FUSION,
    .fusion_string = "p_0 + p_1 + p_2 + p_3 + p_4 + p_5 + p_6 + p_7 + p_8 + p_9 + p_10 + p_11 + p_12 + p_13 + p_14 + p_15 + p_16 + p_17 + p_18 + p_19 + p_20 + p_21 + p_22 + p_23 + p_24 + p_25 + p_26 + p_27 + p_28 + p_29 + p_30 + p_31 + p_32 + p_33 + p_34 + p_35 + p_36 + p_37 + p_38 + p_39 + p_40 + p_41 + p_42 + p_43 + p_44 + p_45 + p_46 + p_47 + p_48 + p_49 + p_50 + p_51 + p_52 + p_53 + p_54 + p_55 + p_56 + p_57 + p_58 + p_59 + p_60 + p_61 + p_62 + p_63 + p_64 + p_65 + p_66 + p_67 + p_68 + p_69 + p_70 + p_71 + p_72 + p_73 + p_74 + p_75 + p_76 + p_77 + p_78 + p_79 + p_80 + p_81 + p_82 + p_83 + p_84 + p_85 + p_86 + p_87 + p_88 + p_89 + p_90 + p_91 + p_92 + p_93 + p_94 + p_95 + p_96 + p_97 + p_98 + p_99 + p_100 + p_101 + p_102 + p_103 + p_104 + p_105 + p_106 + p_107 + p_108 + p_109 + p_110 + p_111 + p_112 + p_113 + p_114 + p_115 + p_116 + p_117 + p_118 + p_119 + p_120 + p_121 + p_122 + p_123 + p_124 + p_125 + p_126 + p_127 + p_128 + p_129 + p_130 + p_131 + p_132 + p_133 + p_134 + p_135 + p_136 + p_137 + p_138 + p_139 + p_140 + p_141 + p_142 + p_143 + p_144 + p_145 + p_146 + p_147 + p_148 + p_149 + p_150 + p_151 + p_152 + p_153 + p_154 + p_155 + p_156 + p_157 + p_158 + p_159 + p_160 + p_161 + p_162 + p_163 + p_164 + p_165 + p_166 + p_167 + p_168 + p_169 + p_170 + p_171 + p_172 + p_173 + p_174 + p_175 + p_176 + p_177 + p_178 + p_179 + p_180 + p_181 + p_182 + p_183 + p_184 + p_185 + p_186 + p_187 + p_188 + p_189 + p_190 + p_191 + p_192 + p_193 + p_194 + p_195 + p_196 + p_197 + p_198 + p_199 + p_200 + p_201 + p_202 + p_203 + p_204 + p_205 + p_206 + p_207 + p_208 + p_209 + p_210 + p_211 + p_212 + p_213 + p_214 + p_215 + p_216 + p_217 + p_218 + p_219 + p_220 + p_221 + p_222 + p_223 + p_224 + p_225 + p_226 + p_227 + p_228 + p_229 + p_230 + p_231 + p_232 + p_233 + p_234 + p_235 + p_236 + p_237 + p_238 + p_239 + p_240 + p_241 + p_242 + p_243 + p_244 + p_245 + p_246 + p_247 + p_248 + p_249 + p_250 + p_251 + p_252 + p_253 + p_254 + p_255 + p_256 + p_257 + p_258 + p_259 + p_260 + p_261 + p_262 + p_263 + p_264 + p_265 + p_266 + p_267 + p_268 + p_269 + p_270 + p_271 + p_272 + p_273 + p_274 + p_275 + p_276 + p_277 + p_278 + p_279 + p_280 + p_281 + p_282 + p_283 + p_284 + p_285 + p_286 + p_287 + p_288 + p_289 + p_290 + p_291 + p_292 + p_293 + p_294 + p_295 + p_296 + p_297 + p_298 + p_299 + p_300 + p_301 + p_302 + p_303 + p_304 + p_305 + p_306 + p_307 + p_308 + p_309 + p_310 + p_311 + p_312 + p_313 + p_314 + p_315 + p_316 + p_317 + p_318 + p_319 + p_320 + p_321 + p_322 + p_323 + p_324 + p_325 + p_326 + p_327 + p_328 + p_329 + p_330 + p_331 + p_332 + p_333 + p_334 + p_335 + p_336 + p_337 + p_338 + p_339 + p_340 + p_341 + p_342 + p_343 + p_344 + p_345 + p_346 + p_347 + p_348 + p_349 + p_350 + p_351 + p_352 + p_353 + p_354 + p_355 + p_356 + p_357 + p_358 + p_359 + p_360 + p_361 + p_362 + p_363 + p_364 + p_365 + p_366 + p_367 + p_368 + p_369 + p_370 + p_371 + p_372 + p_373 + p_374 + p_375 + p_376 + p_377 + p_378 + p_379 + p_380 + p_381 + p_382 + p_383 + p_384 + p_385 + p_386 + p_387 + p_388 + p_389 + p_390 + p_391 + p_392 + p_393 + p_394 + p_395 + p_396 + p_397 + p_398 + p_399",
    .slice_size = (1/4),
    .slices_per_model_window = 4,

    .has_anomaly = EI_ANOMALY_TYPE_UNKNOWN,
    .label_count = 2,
    .calibration = ei_calibration,
    .categories = ei_classifier_inferencing_categories,
    .object_detection_nms = ei_object_detection_nms
};

ei_impulse_handle_t impulse_handle_366673_0 = ei_impulse_handle_t( &impulse_366673_0 );
ei_impulse_handle_t& ei_default_impulse = impulse_handle_366673_0;

#endif // _EI_CLASSIFIER_MODEL_METADATA_H_
