/* Generated by Edge Impulse
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
// Generated on: 19.03.2024 15:08:52

#include <stdio.h>
#include <stdlib.h>
#include "edge-impulse-sdk/tensorflow/lite/c/builtin_op_data.h"
#include "edge-impulse-sdk/tensorflow/lite/c/common.h"
#include "edge-impulse-sdk/tensorflow/lite/micro/micro_mutable_op_resolver.h"
#include "edge-impulse-sdk/porting/ei_classifier_porting.h"

#if EI_CLASSIFIER_PRINT_STATE
#if defined(__cplusplus) && EI_C_LINKAGE == 1
extern "C" {
    extern void ei_printf(const char *format, ...);
}
#else
extern void ei_printf(const char *format, ...);
#endif
#endif

#if defined __GNUC__
#define ALIGN(X) __attribute__((aligned(X)))
#elif defined _MSC_VER
#define ALIGN(X) __declspec(align(X))
#elif defined __TASKING__
#define ALIGN(X) __align(X)
#elif defined __ICCARM__
#define ALIGN(x) __attribute__((aligned(x)))
#endif

#ifndef EI_MAX_SCRATCH_BUFFER_COUNT
#ifndef CONFIG_IDF_TARGET_ESP32S3
#define EI_MAX_SCRATCH_BUFFER_COUNT 4
#else
#define EI_MAX_SCRATCH_BUFFER_COUNT 4
#endif // CONFIG_IDF_TARGET_ESP32S3
#endif // EI_MAX_SCRATCH_BUFFER_COUNT

#ifndef EI_MAX_OVERFLOW_BUFFER_COUNT
#define EI_MAX_OVERFLOW_BUFFER_COUNT 10
#endif // EI_MAX_OVERFLOW_BUFFER_COUNT

using namespace tflite;
using namespace tflite::ops;
using namespace tflite::ops::micro;

namespace {

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX) || defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
constexpr int kTensorArenaSize = 2864;
#else
constexpr int kTensorArenaSize = 1840;
#endif

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX)
#pragma Bss(".tensor_arena")
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#pragma Bss()
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16) __attribute__((section(".tensor_arena")));
#else
#define EI_CLASSIFIER_ALLOCATION_HEAP 1
uint8_t* tensor_arena = NULL;
#endif

static uint8_t* tensor_boundary;
static uint8_t* current_location;

template <int SZ, class T> struct TfArray {
  int sz; T elem[SZ];
};

enum used_operators_e {
  OP_FULLY_CONNECTED, OP_ADD, OP_SOFTMAX,  OP_LAST
};

struct TensorInfo_t { // subset of TfLiteTensor used for initialization from constant memory
  TfLiteAllocationType allocation_type;
  void* data;
  TfLiteIntArray* dims;
  size_t bytes;
};

typedef struct {
  TfLiteTensor tensor;
  int16_t index;
} TfLiteTensorWithIndex;

typedef struct {
  TfLiteEvalTensor tensor;
  int16_t index;
} TfLiteEvalTensorWithIndex;

TfLiteContext ctx{};
static const int MAX_TFL_TENSOR_COUNT = 3;
static TfLiteTensorWithIndex tflTensors[MAX_TFL_TENSOR_COUNT];
static const int MAX_TFL_EVAL_COUNT = 3;
static TfLiteEvalTensorWithIndex tflEvalTensors[MAX_TFL_EVAL_COUNT];
TfLiteRegistration registrations[OP_LAST];

namespace g0 {
const TfArray<2, int> tensor_dimension0 = { 2, { 1,400 } };
const ALIGN(8) float tensor_data1[1*2] = { 
  -3.4742105007171631, 3.4742105007171631, 
};
const TfArray<2, int> tensor_dimension1 = { 2, { 1,2 } };
const ALIGN(16) float tensor_data2[2*400] = { 
  -0.00055164913646876812, -0.0023643365129828453, -0.0045099565759301186, 0.0015047522028908134, -0.00067123770713806152, 0.0079238023608922958, -0.0069526201114058495, -0.0095098922029137611, 0.0063733607530593872, -0.00021512743842322379, -0.0081376172602176666, -0.00050541729433462024, -0.021929943934082985, -0.010801545344293118, -0.0036542476154863834, -0.0049687759019434452, -0.0055319215171039104, 0.0035317277070134878, 0.0016568958526477218, -0.0078375702723860741, 0.015099496580660343, 0.0047444957308471203, -0.0085811484605073929, 0.0051929350011050701, 0.0047740344889461994, -0.010787601582705975, -7.830251706764102e-05, -0.011547203175723553, 0.0014539246913045645, 0.0070635317824780941, 0.0069357044994831085, 0.0046750470064580441, 0.0083795525133609772, -0.0027592461556196213, 0.0094115175306797028, -0.0032207451295107603, 0.0075455070473253727, 0.0028732821810990572, -0.0001154825440607965, 0.0028799129649996758, 0.0018190293340012431, -0.0038312459364533424, -0.0066984095610678196, 0.0066271428950130939, -0.0018321715760976076, 0.0029130498878657818, 0.011330709792673588, -0.0017214928520843387, -0.0036421632394194603, -0.0030747645068913698, -0.004688863642513752, -0.0042814980261027813, 0.014588221907615662, -0.0023460129741579294, -0.0083834258839488029, -1.1893893315573223e-05, -0.0021690409630537033, 0.0035472651943564415, -0.00089681980898603797, -0.0057595837861299515, -0.0050042755901813507, 0.019448183476924896, -0.0058037657290697098, 0.064750812947750092, 0.077384009957313538, 0.068080268800258636, 0.069730490446090698, 0.068922862410545349, 0.063337638974189758, 0.071506589651107788, 0.073634900152683258, 0.06989818811416626, 0.078809536993503571, 0.074992522597312927, 0.075360208749771118, 0.065806470811367035, 0.069157630205154419, 0.074248246848583221, 0.074073813855648041, 0.065724603831768036, 0.076277285814285278, 0.074010439217090607, 0.072578392922878265, 0.066492900252342224, 0.069202862679958344, 0.075964249670505524, 0.07126288115978241, 0.072164759039878845, 0.064750030636787415, 0.068624608218669891, 0.065095320343971252, 0.07880072295665741, 0.075212098658084869, 0.064341716468334198, 0.059273641556501389, 0.064111761748790741, 0.064637050032615662, 0.075814731419086456, 0.070402361452579498, 0.071451418101787567, 0.076421588659286499, 0.075257480144500732, 0.07167825847864151, 0.06579647958278656, 0.071179233491420746, 0.073358528316020966, 0.080264560878276825, 0.069933071732521057, 0.067197844386100769, 0.070133447647094727, 0.0558820441365242, 0.068865858018398285, 0.066301189363002777, 0.076099090278148651, 0.06022416427731514, 0.066704034805297852, 0.073898628354072571, 0.070355303585529327, 0.084377750754356384, 0.072247445583343506, 0.069152995944023132, 0.072608411312103271, 0.071387827396392822, 0.15042848885059357, 0.1548188328742981, 0.14466223120689392, 0.16123661398887634, 0.14846397936344147, 0.15411941707134247, 0.15727867186069489, 0.1494753509759903, 0.1531374603509903, 0.16555598378181458, 0.16020622849464417, 0.15217605233192444, 0.15410950779914856, 0.14842653274536133, 0.13951531052589417, 0.16561765968799591, 0.14154791831970215, 0.1401941329240799, 0.14582103490829468, 0.1467246413230896, 0.1479635089635849, 0.15227863192558289, 0.14493176341056824, 0.14735476672649384, 0.084834061563014984, 0.069657780230045319, 0.067313894629478455, 0.071015439927577972, 0.07015739381313324, 0.069940805435180664, 0.066760800778865814, 0.082346662878990173, 0.074337713420391083, 0.074785798788070679, 0.086630761623382568, 0.076417580246925354, 0.074843384325504303, 0.063697271049022675, 0.083625525236129761, 0.083924829959869385, 0.08073011040687561, 0.06500466912984848, 0.074783138930797577, 0.078775011003017426, 0.064957492053508759, 0.068257525563240051, 0.072060972452163696, 0.05863126739859581, 0.078288465738296509, 0.083822198212146759, 0.066412098705768585, 0.068185359239578247, 0.067297130823135376, 0.064761780202388763, 0.075764261186122894, 0.06764645129442215, 0.07677055150270462, 0.066956020891666412, 0.086663194000720978, 0.080445669591426849, 0.06518593430519104, 0.077234625816345215, 0.065744869410991669, 0.075994983315467834, 0.076802544295787811, 0.075600698590278625, 0.070644527673721313, 0.078734956681728363, 0.078697383403778076, 0.081007681787014008, 0.077012397348880768, 0.076108947396278381, 0.060288198292255402, 0.072950944304466248, 0.079621061682701111, 0.069455929100513458, 0.063485138118267059, 0.06885228306055069, 0.068044789135456085, 0.081701919436454773, 0.076083064079284668, 0.06975342333316803, 0.07163093239068985, 0.081744514405727386, 0.067444682121276855, 0.081110052764415741, 0.077851526439189911, 0.075376972556114197, 0.067253760993480682, 0.072948172688484192, 0.069482818245887756, 0.059203732758760452, 0.060651008039712906, 0.066962532699108124, 0.074112467467784882, 0.0606679767370224, -0.008230358362197876, -0.00049027119530364871, 0.0011208780342712998, -0.0045611863024532795, -0.0047424742951989174, 0.0044509680010378361, 0.0078982990235090256, 0.0018076383275911212, -0.0021754247136414051, 0.001263834536075592, 4.0618851926410571e-05, -0.01098210271447897, 0.005370019469410181, 0.011275207623839378, -0.0056092296727001667, -0.0041020344942808151, -0.0023971516638994217, 0.0081680165603756905, -0.0018136363942176104, 0.0028403499163687229, -0.0051213582046329975, -0.001568819279782474, 0.0076338094659149647, 0.0039334269240498543, 0.003097994951531291, -0.0077929534018039703, -0.0057855439372360706, 0.0023958890233188868, -0.0094702178612351418, -0.0090623479336500168, 0.0049511557444930077, 0.0032243444584310055, 0.013319458812475204, 0.013869967311620712, 0.011971469968557358, 0.00015811139019206166, 0.012689652852714062, 0.0050510414876043797, 0.00062055635498836637, 0.010741126723587513, 0.0043160035274922848, 0.00080838397843763232, -0.0028857414145022631, -7.8799639595672488e-05, -0.00098725210409611464, -0.0020291756372898817, -0.0041597266681492329, -0.0063675842247903347, 0.0061593297868967056, -0.0082632899284362793, -0.0062019191682338715, 0.0038632003124803305, 0.0001871520362328738, 0.0018280111253261566, 0.0010727598564699292, -0.0030876153614372015, -9.0265952167101204e-05, 0.0027670580893754959, -0.0034856812562793493, 0.0028983382508158684, -0.004237207118421793, -0.00039008993189781904, 0.005616853479295969, 0.0049646785482764244, -0.0072995005175471306, 0.00022761436412110925, -0.01513979397714138, -0.0061159371398389339, -0.005856076255440712, -0.00080762262223288417, 0.00087567709852010012, 0.0097135929390788078, 0.016822122037410736, 0.0013259364059194922, 0.0049564214423298836, -0.012305476702749729, -0.0040029040537774563, 0.002810873556882143, -0.0013612920884042978, -0.0091193290427327156, 0.015053435228765011, -0.0028958744369447231, -0.0042275944724678993, -0.016367411240935326, -0.0039787045679986477, -0.0052574984729290009, -0.012722709216177464, -0.0062029152177274227, -0.010012351907789707, -0.014472151175141335, -0.0097791953012347221, -0.013775870203971863, 0.0048844744451344013, 0.0021026001777499914, -0.007688762154430151, 0.0053956075571477413, 0.0058968802914023399, 0.015001952648162842, 0.00066329666879028082, -0.00075398199260234833, 0.00015165236254688352, 0.0012329586315900087, -0.0016874822322279215, 8.8501810751040466e-06, 0.0051435697823762894, 0.0017319396138191223, -0.0034899101592600346, -0.0081346742808818817, -0.0044921152293682098, 0.00045767799019813538, -0.0017770532285794616, 0.0095214769244194031, 0.0025985799729824066, -0.0048697399906814098, 0.0046695144847035408, 0.0094532538205385208, -0.013806795701384544, 0.0026278714649379253, -0.0066455323249101639, 0.0089212870225310326, -0.00051877886289730668, 0.0055492348037660122, -0.0024535679258406162, -0.0045970827341079712, 0.0080968467518687248, 0.002277028514072299, -0.0072519052773714066, 0.0088116666302084923, -0.0024587332736700773, 0.0080747157335281372, 0.0010966570116579533, 0.0012807381572201848, -0.0085294945165514946, 0.0071528907865285873, -0.015254206955432892, 0.0055383052676916122, -0.0018620085902512074, -0.0030767025891691446, 0.00038969086017459631, 0.0025987050030380487, 0.0051611731760203838, 0.0036797025240957737, 0.0045971791259944439, -0.013975659385323524, -0.0031628597062081099, 0.0017680699238553643, 0.010614450089633465, -0.0031384616158902645, 0.0055304397828876972, 0.0041135423816740513, -0.0039473474025726318, -0.0010840501636266708, -0.00046948695671744645, -0.0043120160698890686, 0.011027595959603786, 0.0042417705990374088, -0.0041441856883466244, 0.00010424629726912826, -0.0021255470346659422, -0.011798292398452759, 0.0036252809222787619, 0.0019878668244928122, 0.0088409017771482468, -0.0024544908665120602, 0.011879393830895424, 0.0021089497022330761, 0.0095695285126566887, 0.012525237165391445, -0.0089154588058590889, 0.013704962097108364, -0.0017478438094258308, -0.0017934836214408278, -0.0095483483746647835, -0.0088602053001523018, -0.0023521529510617256, 0.0037488120142370462, -0.0089185023680329323, 0.0064989505335688591, -0.0095104547217488289, 0.000761931121814996, 0.00013526211841963232, 
  0.00055164913646876812, 0.0023643365129828453, 0.0045099565759301186, -0.0015047522028908134, 0.00067123770713806152, -0.0079238023608922958, 0.0069526201114058495, 0.0095098922029137611, -0.0063733607530593872, 0.00021512743842322379, 0.0081376172602176666, 0.00050541729433462024, 0.021929943934082985, 0.010801545344293118, 0.0036542476154863834, 0.0049687759019434452, 0.0055319215171039104, -0.0035317277070134878, -0.0016568958526477218, 0.0078375702723860741, -0.015099496580660343, -0.0047444957308471203, 0.0085811484605073929, -0.0051929350011050701, -0.0047740344889461994, 0.010787601582705975, 7.830251706764102e-05, 0.011547203175723553, -0.0014539246913045645, -0.0070635317824780941, -0.0069357044994831085, -0.0046750470064580441, -0.0083795525133609772, 0.0027592461556196213, -0.0094115175306797028, 0.0032207451295107603, -0.0075455070473253727, -0.0028732821810990572, 0.0001154825440607965, -0.0028799129649996758, -0.0018190293340012431, 0.0038312459364533424, 0.0066984095610678196, -0.0066271428950130939, 0.0018321715760976076, -0.0029130498878657818, -0.011330709792673588, 0.0017214928520843387, 0.0036421632394194603, 0.0030747645068913698, 0.004688863642513752, 0.0042814980261027813, -0.014588221907615662, 0.0023460129741579294, 0.0083834258839488029, 1.1893893315573223e-05, 0.0021690409630537033, -0.0035472651943564415, 0.00089681980898603797, 0.0057595837861299515, 0.0050042755901813507, -0.019448183476924896, 0.0058037657290697098, -0.064750812947750092, -0.077384009957313538, -0.068080268800258636, -0.069730490446090698, -0.068922862410545349, -0.063337638974189758, -0.071506589651107788, -0.073634900152683258, -0.06989818811416626, -0.078809536993503571, -0.074992522597312927, -0.075360208749771118, -0.065806470811367035, -0.069157630205154419, -0.074248246848583221, -0.074073813855648041, -0.065724603831768036, -0.076277285814285278, -0.074010439217090607, -0.072578392922878265, -0.066492900252342224, -0.069202862679958344, -0.075964249670505524, -0.07126288115978241, -0.072164759039878845, -0.064750030636787415, -0.068624608218669891, -0.065095320343971252, -0.07880072295665741, -0.075212098658084869, -0.064341716468334198, -0.059273641556501389, -0.064111761748790741, -0.064637050032615662, -0.075814731419086456, -0.070402361452579498, -0.071451418101787567, -0.076421588659286499, -0.075257480144500732, -0.07167825847864151, -0.06579647958278656, -0.071179233491420746, -0.073358528316020966, -0.080264560878276825, -0.069933071732521057, -0.067197844386100769, -0.070133447647094727, -0.0558820441365242, -0.068865858018398285, -0.066301189363002777, -0.076099090278148651, -0.06022416427731514, -0.066704034805297852, -0.073898628354072571, -0.070355303585529327, -0.084377750754356384, -0.072247445583343506, -0.069152995944023132, -0.072608411312103271, -0.071387827396392822, -0.15042848885059357, -0.1548188328742981, -0.14466223120689392, -0.16123661398887634, -0.14846397936344147, -0.15411941707134247, -0.15727867186069489, -0.1494753509759903, -0.1531374603509903, -0.16555598378181458, -0.16020622849464417, -0.15217605233192444, -0.15410950779914856, -0.14842653274536133, -0.13951531052589417, -0.16561765968799591, -0.14154791831970215, -0.1401941329240799, -0.14582103490829468, -0.1467246413230896, -0.1479635089635849, -0.15227863192558289, -0.14493176341056824, -0.14735476672649384, -0.084834061563014984, -0.069657780230045319, -0.067313894629478455, -0.071015439927577972, -0.07015739381313324, -0.069940805435180664, -0.066760800778865814, -0.082346662878990173, -0.074337713420391083, -0.074785798788070679, -0.086630761623382568, -0.076417580246925354, -0.074843384325504303, -0.063697271049022675, -0.083625525236129761, -0.083924829959869385, -0.08073011040687561, -0.06500466912984848, -0.074783138930797577, -0.078775011003017426, -0.064957492053508759, -0.068257525563240051, -0.072060972452163696, -0.05863126739859581, -0.078288465738296509, -0.083822198212146759, -0.066412098705768585, -0.068185359239578247, -0.067297130823135376, -0.064761780202388763, -0.075764261186122894, -0.06764645129442215, -0.07677055150270462, -0.066956020891666412, -0.086663194000720978, -0.080445669591426849, -0.06518593430519104, -0.077234625816345215, -0.065744869410991669, -0.075994983315467834, -0.076802544295787811, -0.075600698590278625, -0.070644527673721313, -0.078734956681728363, -0.078697383403778076, -0.081007681787014008, -0.077012397348880768, -0.076108947396278381, -0.060288198292255402, -0.072950944304466248, -0.079621061682701111, -0.069455929100513458, -0.063485138118267059, -0.06885228306055069, -0.068044789135456085, -0.081701919436454773, -0.076083064079284668, -0.06975342333316803, -0.07163093239068985, -0.081744514405727386, -0.067444682121276855, -0.081110052764415741, -0.077851526439189911, -0.075376972556114197, -0.067253760993480682, -0.072948172688484192, -0.069482818245887756, -0.059203732758760452, -0.060651008039712906, -0.066962532699108124, -0.074112467467784882, -0.0606679767370224, 0.008230358362197876, 0.00049027119530364871, -0.0011208780342712998, 0.0045611863024532795, 0.0047424742951989174, -0.0044509680010378361, -0.0078982990235090256, -0.0018076383275911212, 0.0021754247136414051, -0.001263834536075592, -4.0618851926410571e-05, 0.01098210271447897, -0.005370019469410181, -0.011275207623839378, 0.0056092296727001667, 0.0041020344942808151, 0.0023971516638994217, -0.0081680165603756905, 0.0018136363942176104, -0.0028403499163687229, 0.0051213582046329975, 0.001568819279782474, -0.0076338094659149647, -0.0039334269240498543, -0.003097994951531291, 0.0077929534018039703, 0.0057855439372360706, -0.0023958890233188868, 0.0094702178612351418, 0.0090623479336500168, -0.0049511557444930077, -0.0032243444584310055, -0.013319458812475204, -0.013869967311620712, -0.011971469968557358, -0.00015811139019206166, -0.012689652852714062, -0.0050510414876043797, -0.00062055635498836637, -0.010741126723587513, -0.0043160035274922848, -0.00080838397843763232, 0.0028857414145022631, 7.8799639595672488e-05, 0.00098725210409611464, 0.0020291756372898817, 0.0041597266681492329, 0.0063675842247903347, -0.0061593297868967056, 0.0082632899284362793, 0.0062019191682338715, -0.0038632003124803305, -0.0001871520362328738, -0.0018280111253261566, -0.0010727598564699292, 0.0030876153614372015, 9.0265952167101204e-05, -0.0027670580893754959, 0.0034856812562793493, -0.0028983382508158684, 0.004237207118421793, 0.00039008993189781904, -0.005616853479295969, -0.0049646785482764244, 0.0072995005175471306, -0.00022761436412110925, 0.01513979397714138, 0.0061159371398389339, 0.005856076255440712, 0.00080762262223288417, -0.00087567709852010012, -0.0097135929390788078, -0.016822122037410736, -0.0013259364059194922, -0.0049564214423298836, 0.012305476702749729, 0.0040029040537774563, -0.002810873556882143, 0.0013612920884042978, 0.0091193290427327156, -0.015053435228765011, 0.0028958744369447231, 0.0042275944724678993, 0.016367411240935326, 0.0039787045679986477, 0.0052574984729290009, 0.012722709216177464, 0.0062029152177274227, 0.010012351907789707, 0.014472151175141335, 0.0097791953012347221, 0.013775870203971863, -0.0048844744451344013, -0.0021026001777499914, 0.007688762154430151, -0.0053956075571477413, -0.0058968802914023399, -0.015001952648162842, -0.00066329666879028082, 0.00075398199260234833, -0.00015165236254688352, -0.0012329586315900087, 0.0016874822322279215, -8.8501810751040466e-06, -0.0051435697823762894, -0.0017319396138191223, 0.0034899101592600346, 0.0081346742808818817, 0.0044921152293682098, -0.00045767799019813538, 0.0017770532285794616, -0.0095214769244194031, -0.0025985799729824066, 0.0048697399906814098, -0.0046695144847035408, -0.0094532538205385208, 0.013806795701384544, -0.0026278714649379253, 0.0066455323249101639, -0.0089212870225310326, 0.00051877886289730668, -0.0055492348037660122, 0.0024535679258406162, 0.0045970827341079712, -0.0080968467518687248, -0.002277028514072299, 0.0072519052773714066, -0.0088116666302084923, 0.0024587332736700773, -0.0080747157335281372, -0.0010966570116579533, -0.0012807381572201848, 0.0085294945165514946, -0.0071528907865285873, 0.015254206955432892, -0.0055383052676916122, 0.0018620085902512074, 0.0030767025891691446, -0.00038969086017459631, -0.0025987050030380487, -0.0051611731760203838, -0.0036797025240957737, -0.0045971791259944439, 0.013975659385323524, 0.0031628597062081099, -0.0017680699238553643, -0.010614450089633465, 0.0031384616158902645, -0.0055304397828876972, -0.0041135423816740513, 0.0039473474025726318, 0.0010840501636266708, 0.00046948695671744645, 0.0043120160698890686, -0.011027595959603786, -0.0042417705990374088, 0.0041441856883466244, -0.00010424629726912826, 0.0021255470346659422, 0.011798292398452759, -0.0036252809222787619, -0.0019878668244928122, -0.0088409017771482468, 0.0024544908665120602, -0.011879393830895424, -0.0021089497022330761, -0.0095695285126566887, -0.012525237165391445, 0.0089154588058590889, -0.013704962097108364, 0.0017478438094258308, 0.0017934836214408278, 0.0095483483746647835, 0.0088602053001523018, 0.0023521529510617256, -0.0037488120142370462, 0.0089185023680329323, -0.0064989505335688591, 0.0095104547217488289, -0.000761931121814996, -0.00013526211841963232, 
};
const TfArray<2, int> tensor_dimension2 = { 2, { 2,400 } };
const TfArray<2, int> tensor_dimension3 = { 2, { 1,2 } };
const TfArray<2, int> tensor_dimension4 = { 2, { 1,2 } };
const TfArray<2, int> tensor_dimension5 = { 2, { 1,2 } };
const TfLiteFullyConnectedParams opdata0 = { kTfLiteActNone, kTfLiteFullyConnectedWeightsFormatDefault, false, false };
const TfArray<3, int> inputs0 = { 3, { 0,2,-1 } };
const TfArray<1, int> outputs0 = { 1, { 3 } };
const TfLiteAddParams opdata1 = { kTfLiteActNone };
const TfArray<2, int> inputs1 = { 2, { 3,1 } };
const TfArray<1, int> outputs1 = { 1, { 4 } };
const TfLiteSoftmaxParams opdata2 = { 1 };
const TfArray<1, int> inputs2 = { 1, { 4 } };
const TfArray<1, int> outputs2 = { 1, { 5 } };
};

TensorInfo_t tensorData[] = {
{ kTfLiteArenaRw, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension0, 1600, },
{ kTfLiteMmapRo, (int32_t*)g0::tensor_data1, (TfLiteIntArray*)&g0::tensor_dimension1, 8, },
{ kTfLiteMmapRo, (int32_t*)g0::tensor_data2, (TfLiteIntArray*)&g0::tensor_dimension2, 3200, },
{ kTfLiteArenaRw, (int32_t*)(tensor_arena + 1600), (TfLiteIntArray*)&g0::tensor_dimension3, 8, },
{ kTfLiteArenaRw, (int32_t*)(tensor_arena + 16), (TfLiteIntArray*)&g0::tensor_dimension4, 8, },
{ kTfLiteArenaRw, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension5, 8, },
};

#ifndef TF_LITE_STATIC_MEMORY
TfLiteNode tflNodes[3] = {
{ (TfLiteIntArray*)&g0::inputs0, (TfLiteIntArray*)&g0::outputs0, (TfLiteIntArray*)&g0::inputs0, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata0)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs1, (TfLiteIntArray*)&g0::outputs1, (TfLiteIntArray*)&g0::inputs1, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata1)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs2, (TfLiteIntArray*)&g0::outputs2, (TfLiteIntArray*)&g0::inputs2, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata2)), nullptr, 0, },
};
#else
TfLiteNode tflNodes[3] = {
{ (TfLiteIntArray*)&g0::inputs0, (TfLiteIntArray*)&g0::outputs0, (TfLiteIntArray*)&g0::inputs0, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata0)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs1, (TfLiteIntArray*)&g0::outputs1, (TfLiteIntArray*)&g0::inputs1, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata1)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs2, (TfLiteIntArray*)&g0::outputs2, (TfLiteIntArray*)&g0::inputs2, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata2)), nullptr, 0, },
};
#endif

used_operators_e used_ops[] =
{OP_FULLY_CONNECTED, OP_ADD, OP_SOFTMAX, };


// Indices into tflTensors and tflNodes for subgraphs
const size_t tflTensors_subgraph_index[] = {0, 6, };
const size_t tflNodes_subgraph_index[] = {0, 3, };

// Input/output tensors
static const int in_tensor_indices[] = {
  0, 
};

static const int out_tensor_indices[] = {
  5, 
};


size_t current_subgraph_index = 0;

static void init_tflite_tensor(size_t i, TfLiteTensor *tensor) {
  tensor->type = kTfLiteFloat32;
  tensor->is_variable = false;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  tensor->allocation_type = tensorData[i].allocation_type;
#else
  tensor->allocation_type = (tensor_arena <= tensorData[i].data && tensorData[i].data < tensor_arena + kTensorArenaSize) ? kTfLiteArenaRw : kTfLiteMmapRo;
#endif
  tensor->bytes = tensorData[i].bytes;
  tensor->dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  if(tensor->allocation_type == kTfLiteArenaRw){
    uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

    tensor->data.data =  start;
  }
  else {
      tensor->data.data = tensorData[i].data;
  }
#else
  tensor->data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
  tensor->quantization.type = kTfLiteNoQuantization;

}

static void init_tflite_eval_tensor(int i, TfLiteEvalTensor *tensor) {

  tensor->type = kTfLiteFloat32;

  tensor->dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  auto allocation_type = tensorData[i].allocation_type;
  if(allocation_type == kTfLiteArenaRw) {
    uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

    tensor->data.data =  start;
  }
  else {
    tensor->data.data = tensorData[i].data;
  }
#else
  tensor->data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
}

static void* overflow_buffers[EI_MAX_OVERFLOW_BUFFER_COUNT];
static size_t overflow_buffers_ix = 0;
static void * AllocatePersistentBufferImpl(struct TfLiteContext* ctx,
                                       size_t bytes) {
  void *ptr;
  uint32_t align_bytes = (bytes % 16) ? 16 - (bytes % 16) : 0;

  if (current_location - (bytes + align_bytes) < tensor_boundary) {
    if (overflow_buffers_ix > EI_MAX_OVERFLOW_BUFFER_COUNT - 1) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d, does not fit in tensor arena and reached EI_MAX_OVERFLOW_BUFFER_COUNT\n",
        (int)bytes);
      return NULL;
    }

    // OK, this will look super weird, but.... we have CMSIS-NN buffers which
    // we cannot calculate beforehand easily.
    ptr = ei_calloc(bytes, 1);
    if (ptr == NULL) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d\n", (int)bytes);
      return NULL;
    }
    overflow_buffers[overflow_buffers_ix++] = ptr;
    return ptr;
  }

  current_location -= bytes;

  // align to the left aligned boundary of 16 bytes
  current_location -= 15; // for alignment
  current_location += 16 - ((uintptr_t)(current_location) & 15);

  ptr = current_location;
  memset(ptr, 0, bytes);

  return ptr;
}

typedef struct {
  size_t bytes;
  void *ptr;
} scratch_buffer_t;

static scratch_buffer_t scratch_buffers[EI_MAX_SCRATCH_BUFFER_COUNT];
static size_t scratch_buffers_ix = 0;

static TfLiteStatus RequestScratchBufferInArenaImpl(struct TfLiteContext* ctx, size_t bytes,
                                                int* buffer_idx) {
  if (scratch_buffers_ix > EI_MAX_SCRATCH_BUFFER_COUNT - 1) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d, reached EI_MAX_SCRATCH_BUFFER_COUNT\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffer_t b;
  b.bytes = bytes;

  b.ptr = AllocatePersistentBufferImpl(ctx, b.bytes);
  if (!b.ptr) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffers[scratch_buffers_ix] = b;
  *buffer_idx = scratch_buffers_ix;

  scratch_buffers_ix++;

  return kTfLiteOk;
}

static void* GetScratchBufferImpl(struct TfLiteContext* ctx, int buffer_idx) {
  if (buffer_idx > (int)scratch_buffers_ix) {
    return NULL;
  }
  return scratch_buffers[buffer_idx].ptr;
}

static const uint16_t TENSOR_IX_UNUSED = 0x7FFF;

static void ResetTensors() {
  for (size_t ix = 0; ix < MAX_TFL_TENSOR_COUNT; ix++) {
    tflTensors[ix].index = TENSOR_IX_UNUSED;
  }
  for (size_t ix = 0; ix < MAX_TFL_EVAL_COUNT; ix++) {
    tflEvalTensors[ix].index = TENSOR_IX_UNUSED;
  }
}

static TfLiteTensor* GetTensorImpl(const struct TfLiteContext* context,
                               int tensor_idx) {

  tensor_idx = tflTensors_subgraph_index[current_subgraph_index] + tensor_idx;

  for (size_t ix = 0; ix < MAX_TFL_TENSOR_COUNT; ix++) {
    // already used? OK!
    if (tflTensors[ix].index == tensor_idx) {
      return &tflTensors[ix].tensor;
    }
    // passed all the ones we've used, so end of the list?
    if (tflTensors[ix].index == TENSOR_IX_UNUSED) {
      // init the tensor
      init_tflite_tensor(tensor_idx, &tflTensors[ix].tensor);
      tflTensors[ix].index = tensor_idx;
      return &tflTensors[ix].tensor;
    }
  }

  ei_printf("ERR: GetTensor called beyond MAX_TFL_TENSOR_COUNT (%d)\n", MAX_TFL_TENSOR_COUNT);
  return nullptr;
}

static TfLiteEvalTensor* GetEvalTensorImpl(const struct TfLiteContext* context,
                                       int tensor_idx) {

  tensor_idx = tflTensors_subgraph_index[current_subgraph_index] + tensor_idx;

  for (size_t ix = 0; ix < MAX_TFL_EVAL_COUNT; ix++) {
    // already used? OK!
    if (tflEvalTensors[ix].index == tensor_idx) {
      return &tflEvalTensors[ix].tensor;
    }
    // passed all the ones we've used, so end of the list?
    if (tflEvalTensors[ix].index == TENSOR_IX_UNUSED) {
      // init the tensor
      init_tflite_eval_tensor(tensor_idx, &tflEvalTensors[ix].tensor);
      tflEvalTensors[ix].index = tensor_idx;
      return &tflEvalTensors[ix].tensor;
    }
  }

  ei_printf("ERR: GetTensor called beyond MAX_TFL_EVAL_COUNT (%d)\n", (int)MAX_TFL_EVAL_COUNT);
  return nullptr;
}

class EonMicroContext : public MicroContext {
 public:
 
  EonMicroContext(): MicroContext(nullptr, nullptr, nullptr) { }

  void* AllocatePersistentBuffer(size_t bytes) {
    return AllocatePersistentBufferImpl(nullptr, bytes);
  }

  TfLiteStatus RequestScratchBufferInArena(size_t bytes,
                                           int* buffer_index) {
  return RequestScratchBufferInArenaImpl(nullptr, bytes, buffer_index);
  }

  void* GetScratchBuffer(int buffer_index) {
    return GetScratchBufferImpl(nullptr, buffer_index);
  }
 
  TfLiteTensor* AllocateTempTfLiteTensor(int tensor_index) {
    return GetTensorImpl(nullptr, tensor_index);
  }

  void DeallocateTempTfLiteTensor(TfLiteTensor* tensor) {
    return;
  }

  bool IsAllTempTfLiteTensorDeallocated() {
    return true;
  }

  TfLiteEvalTensor* GetEvalTensor(int tensor_index) {
    return GetEvalTensorImpl(nullptr, tensor_index);
  }

};


} // namespace

TfLiteStatus tflite_learn_5_init( void*(*alloc_fnc)(size_t,size_t) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  tensor_arena = (uint8_t*) alloc_fnc(16, kTensorArenaSize);
  if (!tensor_arena) {
    ei_printf("ERR: failed to allocate tensor arena\n");
    return kTfLiteError;
  }
#else
  memset(tensor_arena, 0, kTensorArenaSize);
#endif
  tensor_boundary = tensor_arena;
  current_location = tensor_arena + kTensorArenaSize;

  EonMicroContext micro_context_;
  
  // Set microcontext as the context ptr
  ctx.impl_ = static_cast<void*>(&micro_context_);
  // Setup tflitecontext functions
  ctx.AllocatePersistentBuffer = &AllocatePersistentBufferImpl;
  ctx.RequestScratchBufferInArena = &RequestScratchBufferInArenaImpl;
  ctx.GetScratchBuffer = &GetScratchBufferImpl;
  ctx.GetTensor = &GetTensorImpl;
  ctx.GetEvalTensor = &GetEvalTensorImpl;
  ctx.ReportError = &MicroContextReportOpError;

  ctx.tensors_size = 6;
  for (size_t i = 0; i < 6; ++i) {
    TfLiteTensor tensor;
    init_tflite_tensor(i, &tensor);
    if (tensor.allocation_type == kTfLiteArenaRw) {
      auto data_end_ptr = (uint8_t*)tensor.data.data + tensorData[i].bytes;
      if (data_end_ptr > tensor_boundary) {
        tensor_boundary = data_end_ptr;
      }
    }
  }

  if (tensor_boundary > current_location /* end of arena size */) {
    ei_printf("ERR: tensor arena is too small, does not fit model - even without scratch buffers\n");
    return kTfLiteError;
  }

  registrations[OP_FULLY_CONNECTED] = Register_FULLY_CONNECTED();
  registrations[OP_ADD] = Register_ADD();
  registrations[OP_SOFTMAX] = Register_SOFTMAX();

  for (size_t g = 0; g < 1; ++g) {
    current_subgraph_index = g;
    for(size_t i = tflNodes_subgraph_index[g]; i < tflNodes_subgraph_index[g+1]; ++i) {
      if (registrations[used_ops[i]].init) {
        tflNodes[i].user_data = registrations[used_ops[i]].init(&ctx, (const char*)tflNodes[i].builtin_data, 0);
      }
    }
  }
  current_subgraph_index = 0;

  for(size_t g = 0; g < 1; ++g) {
    current_subgraph_index = g;
    for(size_t i = tflNodes_subgraph_index[g]; i < tflNodes_subgraph_index[g+1]; ++i) {
      if (registrations[used_ops[i]].prepare) {
        ResetTensors();
        TfLiteStatus status = registrations[used_ops[i]].prepare(&ctx, &tflNodes[i]);
        if (status != kTfLiteOk) {
          return status;
        }
      }
    }
  }
  current_subgraph_index = 0;

  return kTfLiteOk;
}

TfLiteStatus tflite_learn_5_input(int index, TfLiteTensor *tensor) {
  init_tflite_tensor(in_tensor_indices[index], tensor);
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_5_output(int index, TfLiteTensor *tensor) {
  init_tflite_tensor(out_tensor_indices[index], tensor);
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_5_invoke() {
  for (size_t i = 0; i < 3; ++i) {
    ResetTensors();

    TfLiteStatus status = registrations[used_ops[i]].invoke(&ctx, &tflNodes[i]);

#if EI_CLASSIFIER_PRINT_STATE
    ei_printf("layer %lu\n", i);
    ei_printf("    inputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].inputs->size; ix++) {
      auto d = tensorData[tflNodes[i].inputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");

    ei_printf("    outputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].outputs->size; ix++) {
      auto d = tensorData[tflNodes[i].outputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");
#endif // EI_CLASSIFIER_PRINT_STATE

    if (status != kTfLiteOk) {
      return status;
    }
  }
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_5_reset( void (*free_fnc)(void* ptr) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  free_fnc(tensor_arena);
#endif

  // scratch buffers are allocated within the arena, so just reset the counter so memory can be reused
  scratch_buffers_ix = 0;

  // overflow buffers are on the heap, so free them first
  for (size_t ix = 0; ix < overflow_buffers_ix; ix++) {
    ei_free(overflow_buffers[ix]);
  }
  overflow_buffers_ix = 0;
  return kTfLiteOk;
}
