/* Generated by Edge Impulse
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
// Generated on: 23.10.2023 13:14:19

#include <stdio.h>
#include <stdlib.h>
#include "edge-impulse-sdk/tensorflow/lite/c/builtin_op_data.h"
#include "edge-impulse-sdk/tensorflow/lite/c/common.h"
#include "edge-impulse-sdk/tensorflow/lite/micro/micro_mutable_op_resolver.h"
#include "edge-impulse-sdk/porting/ei_classifier_porting.h"

#if EI_CLASSIFIER_PRINT_STATE
#if defined(__cplusplus) && EI_C_LINKAGE == 1
extern "C" {
    extern void ei_printf(const char *format, ...);
}
#else
extern void ei_printf(const char *format, ...);
#endif
#endif

#if defined __GNUC__
#define ALIGN(X) __attribute__((aligned(X)))
#elif defined _MSC_VER
#define ALIGN(X) __declspec(align(X))
#elif defined __TASKING__
#define ALIGN(X) __align(X)
#elif defined __ICCARM__
#define ALIGN(x) __attribute__((aligned(x)))
#endif

#ifndef EI_MAX_SCRATCH_BUFFER_COUNT
#ifndef CONFIG_IDF_TARGET_ESP32S3
#define EI_MAX_SCRATCH_BUFFER_COUNT 14
#else
#define EI_MAX_SCRATCH_BUFFER_COUNT 28
#endif // CONFIG_IDF_TARGET_ESP32S3
#endif // EI_MAX_SCRATCH_BUFFER_COUNT

#ifndef EI_MAX_OVERFLOW_BUFFER_COUNT
#define EI_MAX_OVERFLOW_BUFFER_COUNT 10
#endif // EI_MAX_OVERFLOW_BUFFER_COUNT

using namespace tflite;
using namespace tflite::ops;
using namespace tflite::ops::micro;

namespace {

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX) || defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
constexpr int kTensorArenaSize = 368160;
#else
constexpr int kTensorArenaSize = 367136;
#endif

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX)
#pragma Bss(".tensor_arena")
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#pragma Bss()
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16) __attribute__((section(".tensor_arena")));
#else
#define EI_CLASSIFIER_ALLOCATION_HEAP 1
uint8_t* tensor_arena = NULL;
#endif

static uint8_t* tensor_boundary;
static uint8_t* current_location;

template <int SZ, class T> struct TfArray {
  int sz; T elem[SZ];
};
enum used_operators_e {
  OP_CONV_2D, OP_DEPTHWISE_CONV_2D, OP_PAD, OP_ADD, OP_SOFTMAX,  OP_LAST
};
struct TensorInfo_t { // subset of TfLiteTensor used for initialization from constant memory
  TfLiteAllocationType allocation_type;
  TfLiteType type;
  void* data;
  TfLiteIntArray* dims;
  size_t bytes;
  TfLiteQuantization quantization;
};
struct NodeInfo_t { // subset of TfLiteNode used for initialization from constant memory
  struct TfLiteIntArray* inputs;
  struct TfLiteIntArray* outputs;
  void* builtin_data;
  used_operators_e used_op_index;
};

typedef struct {
  TfLiteTensor tensor;
  int16_t index;
} TfLiteTensorWithIndex;

typedef struct {
  TfLiteEvalTensor tensor;
  int16_t index;
} TfLiteEvalTensorWithIndex;

TfLiteContext ctx{};
static const int MAX_TFL_TENSOR_COUNT = 4;
static TfLiteTensorWithIndex tflTensors[MAX_TFL_TENSOR_COUNT];
static const int MAX_TFL_EVAL_COUNT = 4;
static TfLiteEvalTensorWithIndex tflEvalTensors[MAX_TFL_EVAL_COUNT];
TfLiteRegistration registrations[OP_LAST];
TfLiteNode tflNodes[27];

const TfArray<4, int> tensor_dimension0 = { 4, { 1,120,120,1 } };
const TfArray<1, float> quant0_scale = { 1, { 0.0039215688593685627, } };
const TfArray<1, int> quant0_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant0 = { (TfLiteFloatArray*)&quant0_scale, (TfLiteIntArray*)&quant0_zero, 0 };
const ALIGN(16) int32_t tensor_data1[4*2] = { 
  0, 0, 
  0, 1, 
  0, 1, 
  0, 0, 
};
const TfArray<2, int> tensor_dimension1 = { 2, { 4,2 } };
const ALIGN(16) int32_t tensor_data2[6] = { 20962, -28994, -32519, -19148, -29322, -26829, };
const TfArray<1, int> tensor_dimension2 = { 1, { 6 } };
const TfArray<6, float> quant2_scale = { 6, { 0.00027749509899877012, 0.00024170288816094398, 0.00021105878113303334, 0.00035489336005412042, 0.00023775621957611293, 0.00025592191377654672, } };
const TfArray<6, int> quant2_zero = { 6, { 0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant2 = { (TfLiteFloatArray*)&quant2_scale, (TfLiteIntArray*)&quant2_zero, 0 };
const ALIGN(16) int8_t tensor_data3[6*1*1*32] = { 
  /* [0][0][][] */ 26,81,-42,-27,-41,7,5,42,-40,89,-14,127,-54,-8,100,41,6,55,-10,-42,-44,5,-65,-27,-91,-34,-49,47,70,-30,-58,-46, 
  /* [1][0][][] */ 50,-40,9,-11,70,13,-18,39,77,30,-106,0,15,37,-34,-2,18,15,-10,-28,-22,52,-8,-79,90,42,127,34,-70,33,-38,95, 
  /* [2][0][][] */ -54,-57,92,-65,39,108,-53,83,-27,62,27,-127,76,1,21,50,53,14,-46,-2,84,118,-69,25,-110,79,-58,-58,-29,34,-44,-126, 
  /* [3][0][][] */ 53,-13,17,22,17,-15,-30,29,58,27,13,-58,63,26,7,-29,58,31,76,-33,15,-28,-127,18,-15,62,-40,-21,-49,1,50,32, 
  /* [4][0][][] */ -8,39,105,-3,-29,-15,127,-30,-7,-44,16,-16,45,26,-28,0,29,46,123,54,19,105,51,38,58,23,40,-14,24,-20,68,13, 
  /* [5][0][][] */ 51,51,-30,74,28,-1,-101,97,7,-127,66,-103,-20,-58,-113,18,-41,-54,4,55,-14,-27,13,11,104,-1,-1,27,15,66,-49,12, 
};
const TfArray<4, int> tensor_dimension3 = { 4, { 6,1,1,32 } };
const TfArray<6, float> quant3_scale = { 6, { 0.0043408521451056004, 0.0037809549830853939, 0.0033015895169228315, 0.005551591981202364, 0.0037192171439528465, 0.0040033827535808086, } };
const TfArray<6, int> quant3_zero = { 6, { 0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant3 = { (TfLiteFloatArray*)&quant3_scale, (TfLiteIntArray*)&quant3_zero, 0 };
const ALIGN(16) int32_t tensor_data4[32] = { 853, -1224, -628, -50, -273, -1435, -2107, 406, -1342, -2497, -655, 979, -698, -2096, -1652, -749, -186, -1481, -2203, -2210, -187, -450, -1375, -1648, -114, -27, -2327, -2234, -1285, -1714, -565, -648, };
const TfArray<1, int> tensor_dimension4 = { 1, { 32 } };
const TfArray<32, float> quant4_scale = { 32, { 8.4705461631529033e-05, 7.5911077146884054e-05, 0.00011611831723712385, 8.3818085840903223e-05, 6.9508700107689947e-05, 7.5238058343529701e-05, 6.7764449340756983e-05, 6.6144843003712595e-05, 7.6093907409813255e-05, 7.3341201641596854e-05, 8.3742845163214952e-05, 0.00011311445268802345, 8.1928708823397756e-05, 7.0827125455252826e-05, 7.5885123806074262e-05, 7.9929028288461268e-05, 7.2519178502261639e-05, 9.0215471573174e-05, 6.6936139774043113e-05, 6.6006163251586258e-05, 8.0134741438087076e-05, 9.4003109552431852e-05, 8.4055915067438036e-05, 8.5298452177084982e-05, 7.8974910138640553e-05, 7.177435327321291e-05, 7.3193667049054056e-05, 6.319813837762922e-05, 7.466005627065897e-05, 7.637574162799865e-05, 4.3718526285374537e-05, 8.1574005889706314e-05, } };
const TfArray<32, int> quant4_zero = { 32, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant4 = { (TfLiteFloatArray*)&quant4_scale, (TfLiteIntArray*)&quant4_zero, 0 };
const ALIGN(16) int8_t tensor_data5[32*1*1*96] = { 
  /* [0][0][][] */ -30,-42,23,-13,44,-34,16,-72,-11,-23,-97,9,45,-88,-41,52,-5,-5,-91,-17,-87,-71,-12,70,-63,22,62,-13,75,24,-30,-32,59,-28,-34,-12,-30,-96,-43,44,59,-62,-70,77,38,-69,-8,-77,18,-31,-59,-30,-29,22,12,67,0,55,68,-64,-17,80,6,48,-52,26,19,86,-3,50,22,-61,77,-127,37,72,-59,27,-102,15,1,-12,26,-3,2,-22,-26,53,-16,96,-5,-51,-10,0,-12,-21, 
  /* [1][0][][] */ -27,36,-81,-36,-49,24,-2,-41,35,-63,-91,4,31,-15,20,15,58,16,19,55,-51,2,-14,-11,-28,-1,-19,31,-31,-14,39,-32,15,86,-15,-20,-25,13,-56,-51,-71,-30,-53,-63,16,6,43,-77,19,-31,27,-7,-37,50,-75,-11,-24,30,-9,45,-56,74,-53,-95,-79,27,23,22,19,-39,21,-37,-75,37,-52,-19,52,-50,-65,21,-86,30,-73,-127,2,95,-78,-59,7,19,52,-23,5,47,-8,-11, 
  /* [2][0][][] */ -30,15,-22,31,-9,-89,23,64,-49,13,-29,44,28,-60,30,-16,-29,-15,-26,27,-38,-28,39,19,-11,12,49,13,-23,48,11,-22,-56,-68,-33,-41,-8,14,46,6,-83,-73,39,7,-60,29,-31,-20,12,-33,33,-43,-4,-56,15,-16,-61,48,-11,-40,12,17,-37,21,38,-8,33,2,-37,39,-29,-34,18,-51,23,10,-31,5,11,10,25,-83,28,-31,-8,-127,-16,-4,15,27,-34,17,-17,-17,-46,-36, 
  /* [3][0][][] */ 43,13,-17,3,-21,9,-31,-25,6,14,12,-46,59,5,37,19,78,74,-84,31,36,-43,-40,-29,-58,-54,-22,71,20,-33,4,22,-32,-6,4,-38,-28,-65,-35,56,-55,-120,-56,21,70,27,-36,-104,51,-60,-31,-48,31,-7,75,-22,-88,-36,-127,-19,-25,45,-13,47,-8,-1,-23,7,-29,-26,6,13,29,-107,40,-22,42,77,41,-22,-72,-114,-20,42,28,4,-80,-50,-110,42,-27,-19,21,-76,-84,14, 
  /* [4][0][][] */ 14,49,-15,24,-12,-18,42,-18,4,39,-14,14,13,-76,-20,-37,-16,-3,-48,-15,37,-87,43,16,-107,-4,45,-42,-31,26,-47,-26,13,58,1,-98,-30,-39,-76,43,-38,-70,-47,-55,17,59,-21,-34,-19,-105,-88,-53,-57,-26,-17,9,-38,-48,22,-2,13,-38,-27,-24,-45,28,-6,-16,4,-66,-90,-59,-32,-11,63,35,33,-27,-24,-52,-5,-122,-82,-31,-2,-17,65,-23,-122,-116,8,34,-12,17,-127,-13, 
  /* [5][0][][] */ 3,-77,34,36,-3,-127,-27,-13,36,-106,-30,-71,-25,7,-27,-24,-29,-7,-64,43,-3,-13,1,-22,-29,-67,-49,-71,-17,-28,-47,-115,-53,-55,-81,-25,-69,-65,-24,-43,-78,-37,17,17,-66,1,-27,-29,-98,-18,-12,53,-9,-56,-5,-50,33,-16,-15,-36,7,-76,-43,-86,-59,8,-65,-30,-20,-14,49,-79,-65,0,-56,-58,-1,-47,-11,35,51,-3,-29,50,-84,-17,-24,1,22,-81,23,26,-33,-23,22,-45, 
  /* [6][0][][] */ 65,-77,25,1,-100,-87,-49,-6,-57,2,-45,-98,109,92,127,-123,-23,-47,-28,16,-97,-21,21,-11,-85,3,-54,-85,-64,-120,-17,-97,6,-22,-77,-13,-54,-20,-117,2,7,-11,-34,-59,-4,19,-1,-76,-51,67,-65,-90,-11,23,12,-61,59,-53,-91,23,-109,-47,-5,-93,-79,-5,37,23,4,-52,-64,-51,89,-90,-105,-74,-99,-113,-84,-66,-27,47,-20,-65,8,22,-73,-108,6,17,116,-38,21,12,0,-64, 
  /* [7][0][][] */ 64,69,-8,-34,-45,85,6,9,49,-7,-58,7,50,-127,36,76,52,30,5,77,20,26,7,66,-9,64,56,69,-41,104,-39,45,7,19,54,37,-33,38,13,19,57,-92,77,75,56,1,-4,-75,38,-95,-62,-17,-3,27,46,17,58,-33,28,-31,42,20,64,-62,-45,-18,61,31,-60,3,36,69,70,9,60,53,-17,31,-55,39,68,-62,-2,-40,74,-36,-63,64,78,27,41,62,-57,-49,-8,-46, 
  /* [8][0][][] */ -16,-54,-72,-100,18,-18,-17,-27,-66,11,14,43,-24,-38,-81,-42,-70,20,-31,-32,-49,-43,-6,27,-104,52,-20,-7,-48,-1,-42,32,63,-30,7,-39,25,-21,1,6,51,-8,-127,-111,-62,-74,-59,-6,-23,-48,-81,-66,-54,25,10,-69,15,25,-76,28,6,3,16,60,-80,-43,-47,58,-67,-30,-29,-17,33,31,-12,8,-87,17,-18,-8,-36,29,-88,-74,17,-7,51,-64,2,-5,-47,36,-33,-46,-43,-8, 
  /* [9][0][][] */ -63,48,13,-35,-12,-117,-91,-123,-25,-27,-58,-25,-77,-106,-117,-63,-59,-61,-97,-105,-46,-7,-21,-127,100,-65,-59,-35,-70,-83,-115,-6,-23,-60,-48,-71,-101,-56,-70,-91,-36,-9,-21,-102,-10,-34,-125,-23,-14,-61,-98,9,-16,-93,-105,2,-13,-95,21,-58,-100,-3,9,-102,-106,-47,6,-32,-75,2,6,-113,-57,13,-114,-113,-103,-120,-70,8,-39,-49,9,19,-89,-23,1,36,-1,-30,-68,1,-1,-50,-10,-74, 
  /* [10][0][][] */ -26,56,24,-63,-18,53,51,-33,-4,3,-2,-79,53,-6,-17,2,2,57,-96,-36,-34,18,13,-22,-81,11,-52,-50,-29,43,-127,-19,38,59,62,11,-30,-68,-66,43,-45,-20,-67,-14,-27,-38,-35,-70,11,-35,-1,-37,9,-11,-62,-11,-69,8,-68,-7,16,44,52,-10,45,-30,-72,-6,0,-22,-59,-50,40,-27,-48,39,18,29,23,-2,17,-61,-23,37,-60,12,22,-25,-30,-84,-53,-21,-61,-24,-53,-101, 
  /* [11][0][][] */ 66,-10,1,55,57,14,-7,31,105,37,84,64,18,86,68,-81,-22,-47,127,65,25,84,53,-25,-3,-21,2,18,48,-17,31,-2,-13,-26,26,68,-28,68,-14,-44,-11,70,18,-18,-27,55,62,7,59,60,81,76,-34,-23,-9,17,27,-18,-35,46,-35,23,29,6,38,31,14,17,79,52,64,-24,13,95,-41,22,2,31,32,62,-25,17,-13,-32,26,11,26,-19,-44,7,17,-35,-14,64,3,41, 
  /* [12][0][][] */ -51,7,-38,-28,30,-53,-18,52,-83,32,-58,28,-27,-82,10,-7,-73,-41,-50,-69,-8,-52,-35,45,-113,-30,55,-57,51,23,-74,10,-41,-90,-17,-22,29,-73,28,27,46,-43,-43,-12,-60,-113,-90,21,-56,-127,-71,-20,42,-2,-23,8,-38,-30,51,-23,33,67,-4,38,36,-20,-23,35,-5,41,-33,64,56,0,2,13,-84,14,-122,-72,-29,12,45,-6,-18,-60,36,63,-41,-102,23,21,64,-23,-44,20, 
  /* [13][0][][] */ 17,-84,14,7,3,20,-3,-11,10,-127,-42,-74,6,10,-9,-77,-121,-92,-107,-33,-5,-67,24,-79,-21,-40,-46,-37,-106,-104,0,-27,-33,14,-63,-33,-100,-66,-34,-7,-56,-6,-82,-41,-75,-31,-45,-66,-18,7,-73,-113,-109,-30,8,-99,-89,-32,36,-94,-65,22,-96,-43,-82,-87,-106,3,-72,-59,29,-51,-105,66,-95,-75,-113,41,1,-85,-18,-123,8,51,-99,-64,9,23,38,30,-91,-17,6,-82,-1,-59, 
  /* [14][0][][] */ -76,-76,23,3,-16,5,-71,-116,-11,-65,19,13,-58,-82,-94,-88,-14,-22,-57,9,-16,-39,42,0,-24,-102,21,14,-69,-68,-99,1,54,-52,-20,-63,82,30,13,-45,1,-74,44,32,119,-7,-31,-40,62,-33,68,-18,75,-33,-41,-35,-52,-51,70,11,64,-82,-25,17,-51,-31,-21,-121,-114,-81,-30,74,-51,12,-17,-34,65,-71,54,30,25,-2,-74,17,-127,-17,-29,69,74,23,-3,-73,17,4,23,0, 
  /* [15][0][][] */ -56,-89,-17,32,-3,-97,-39,-109,4,-65,-59,-32,-1,-26,-115,-82,-23,-69,-112,-6,-7,-33,38,50,76,-20,-43,15,-41,-39,-32,-123,-35,-70,-90,-66,-59,41,-3,-102,-31,60,-17,-80,-60,-38,-57,-35,-63,-113,-68,56,-63,-117,-60,-45,-21,-41,-2,7,-64,-97,-77,6,-50,-19,-103,-64,-101,-2,25,-98,-38,-32,-18,-64,-20,-30,35,38,-48,0,-79,-14,-78,-85,-45,-4,36,22,-77,-55,-9,-3,-127,59, 
  /* [16][0][][] */ -89,-53,55,-56,22,27,-21,68,12,32,-61,67,-35,-127,-48,-12,32,9,32,34,70,-5,-12,29,0,29,-49,1,-47,13,-2,-39,-49,-8,40,21,21,6,23,-68,22,-64,59,20,-21,40,-4,-7,-70,-95,17,52,9,76,56,-7,-4,49,83,-45,64,48,-6,55,32,-44,-7,11,-17,59,-61,32,16,8,40,71,-68,57,-61,-17,22,-75,58,0,2,10,78,34,68,14,-32,52,62,-18,-44,-8, 
  /* [17][0][][] */ -9,-57,-40,-23,-68,-74,-53,-29,25,-68,10,16,24,-58,-69,21,-1,16,-2,33,-45,-68,2,-48,-26,4,-56,2,20,-36,-33,9,-45,-27,-5,-53,-11,3,-39,-25,-55,-76,-12,-10,-11,-1,-26,-104,22,28,-50,25,-10,32,36,-67,-127,23,-22,-72,1,-60,21,37,-85,-46,-12,-79,-79,-34,28,9,-10,-95,-50,19,45,-37,21,-45,-15,-82,-22,-69,-73,15,44,-8,-36,-37,-78,-81,-60,13,-26,-27, 
  /* [18][0][][] */ -112,13,18,0,46,-121,-21,-48,-54,93,-119,-82,-75,-29,-13,-88,-37,-66,0,37,14,-81,-37,-102,20,-12,-62,20,71,-29,50,-24,-25,-69,-27,-21,-72,-30,-73,-11,-78,-51,-83,-57,-124,-41,26,47,-36,-65,97,-32,-121,-57,49,4,-88,-29,-63,-126,3,19,-43,75,7,-127,31,5,-7,2,-97,18,-113,-41,-107,-117,-16,87,-52,-99,-87,-59,34,-88,14,-14,-6,-8,-120,-5,-91,16,107,-85,-20,-55, 
  /* [19][0][][] */ -30,-31,-1,-24,-12,-103,13,9,12,29,-31,-55,-110,-14,-85,-11,-2,-117,21,-12,-63,6,-85,-40,0,-97,-30,-93,-108,-126,-91,-20,127,-101,-28,-48,-44,-94,-86,-115,-21,-124,-103,-43,-104,-30,113,-110,7,-23,-75,-20,-72,74,-46,-50,-33,14,-51,-67,-14,-85,15,-10,-95,-51,-67,-50,-55,-15,2,-82,-89,-126,-86,-101,-64,-121,-40,19,-12,-116,-69,1,-105,59,-44,-52,9,-30,-51,-8,-67,26,-4,-79, 
  /* [20][0][][] */ -84,16,50,42,-46,-3,-6,67,-26,5,-51,17,-15,-29,15,-23,-65,-62,-27,-21,8,-58,-35,-38,72,-42,-49,46,24,28,-73,8,55,-53,-4,13,63,-25,26,-55,-43,-40,-11,-53,-85,-57,-98,77,-26,-127,-27,41,50,18,27,-47,41,43,85,-8,83,-56,-59,-8,4,-92,-12,-56,-69,-40,-60,72,-34,-56,26,25,19,40,62,61,62,-24,76,-9,14,-18,-8,51,40,60,-8,36,7,-1,-5,-3, 
  /* [21][0][][] */ 3,47,37,-45,42,-63,23,21,-37,-59,-53,0,-3,-29,-52,-20,-70,-11,-43,-2,20,-28,30,-30,51,-63,-2,52,-1,16,-31,-40,-33,-30,-49,-49,68,11,-60,2,-46,-10,57,5,-45,-37,-75,55,-51,-113,-4,59,26,-25,-42,5,-68,34,-7,30,54,-41,-17,-13,47,2,-14,-50,-66,12,10,17,17,-36,41,27,-41,-9,29,55,18,10,48,-48,9,-127,24,-52,-67,19,21,-40,-37,-30,-24,-11, 
  /* [22][0][][] */ 37,-30,-73,-80,31,-26,59,-12,-76,55,-75,-50,88,-50,-45,-74,10,74,-84,-58,8,1,-21,8,6,8,-38,21,-61,-28,-3,-42,40,58,9,-18,-46,-42,-77,-56,-18,-57,-35,51,66,-92,100,-53,-22,-34,-48,-53,-69,-49,-13,56,-28,-33,-52,-17,28,-4,-23,-82,-91,46,-86,3,4,15,-17,-51,-3,4,22,-81,10,-37,-6,16,19,-83,-80,-127,49,56,18,-54,-69,-24,-49,34,-8,28,-57,23, 
  /* [23][0][][] */ -2,-51,-26,-20,17,-124,-27,-97,12,-101,38,-5,-43,-122,-33,-37,16,-47,-112,10,27,-102,29,-46,-9,-53,6,4,4,10,12,-41,-58,-10,-30,-54,20,-66,-115,-17,-113,-45,-32,-68,-41,-44,-10,-52,41,-127,-87,-32,10,-96,-66,-1,-110,-45,26,25,-62,-79,-76,-42,-31,0,-116,-96,-31,-71,11,-76,-60,-69,-56,-72,39,-53,-5,37,-67,-76,-50,-67,-1,-30,24,-33,-66,-17,-8,-41,-4,-71,-66,-4, 
  /* [24][0][][] */ -30,13,-63,-26,-53,-39,-22,-85,35,66,23,-4,81,-5,-19,-32,-11,58,-51,-3,28,-32,-17,5,-21,-45,73,66,54,58,12,-13,-16,26,34,0,-22,-95,5,37,-111,-114,68,47,68,5,53,15,-17,-65,-62,3,36,9,66,1,-36,76,-57,18,85,32,34,48,-70,93,-22,-17,-38,51,-11,-56,6,-25,74,58,82,-13,-28,-20,-48,-101,-37,-106,32,-20,-25,-56,-75,-76,0,-7,-40,10,-127,-10, 
  /* [25][0][][] */ -107,-47,-41,-24,52,-63,-48,59,-20,-66,-45,34,47,-74,-70,18,-63,17,7,-75,17,17,-8,-29,27,-27,-46,39,57,-23,-17,39,64,-115,34,36,100,-65,23,10,-57,31,-37,21,17,6,-37,12,-127,-19,-40,12,51,-15,-2,-22,-58,45,-38,4,98,49,23,44,-4,29,2,-20,-60,-10,-49,-45,35,-99,60,35,20,46,6,14,40,4,-9,40,-37,-124,-61,-49,1,-19,43,24,-56,-9,-64,-59, 
  /* [26][0][][] */ 56,-100,-70,-53,-99,34,-14,-44,-127,-79,19,35,-43,-13,-83,-48,53,24,-92,-86,-48,62,18,-53,-15,21,-54,-63,-51,-59,3,35,-55,-7,-112,-28,-82,0,-64,43,-62,41,-8,-15,-25,12,-31,19,-85,-52,-62,-11,-33,-83,22,-50,19,-7,-6,39,-44,-13,26,-35,22,24,-83,62,-39,7,-14,21,72,-111,-97,-39,-62,-120,-101,-52,-62,-17,25,-63,53,-89,-54,-36,-95,25,-21,70,-8,103,-17,-11, 
  /* [27][0][][] */ -43,-46,-94,-115,-111,-99,-97,-57,6,38,-26,-85,-70,-8,4,-72,-7,-62,26,-83,-112,-41,-71,-42,-94,-4,-125,-55,-7,-33,-71,-58,8,-5,-112,-105,-65,-60,-127,8,-93,5,-33,-41,15,-35,18,33,47,33,17,-66,-112,-91,-48,-73,33,-69,-78,-104,-91,-93,-74,-12,-22,-84,-126,19,-19,-35,-110,-42,-10,-40,-58,-110,-20,-49,7,18,6,-51,58,-40,-102,-87,-52,-19,-81,-15,-74,-86,3,-21,58,25, 
  /* [28][0][][] */ 41,-30,53,-2,-127,-41,-118,-100,-46,-96,3,-22,-52,-45,1,3,75,47,-96,28,-43,37,-118,-33,-114,-17,-63,-57,-56,-73,-45,4,-63,2,32,33,-52,-101,-83,4,-5,17,-112,1,-71,-26,34,-4,21,-54,-35,-23,-112,-27,-37,25,19,-21,7,32,-13,-44,-87,-58,0,24,-15,47,-37,-6,-36,-87,10,-20,-41,-94,-63,-44,-95,13,-96,-81,-3,-60,18,-107,-23,-63,-62,-17,-50,-52,-22,46,-39,-81, 
  /* [29][0][][] */ 12,23,-5,-77,-104,19,-127,-58,34,-61,-66,-101,32,-104,-61,-57,-71,49,-59,-72,-66,-42,20,-19,-7,-60,-51,-23,-103,-34,-23,10,-4,-12,-81,-92,-39,-14,-73,47,-55,29,-59,40,0,57,-78,-95,5,-79,-34,-24,-2,-88,16,16,-123,3,-95,64,-65,47,-72,-93,-101,-42,-23,26,5,-93,0,-97,30,-25,0,-5,75,-71,-32,4,-43,-90,-65,-64,26,23,8,25,-79,-11,-8,37,-118,-43,-44,-26, 
  /* [30][0][][] */ 19,-63,-77,-4,-109,6,-86,-11,114,-33,2,-67,-115,9,56,11,-34,33,92,-126,43,-99,-110,-20,-109,5,-73,109,-18,-106,-91,-18,-120,-79,-127,-78,15,-40,-1,19,88,-74,-30,91,70,-43,99,62,-69,47,19,-102,92,-50,-39,71,-92,-69,-80,-54,-110,-32,-71,-37,-106,-91,-88,71,-64,68,34,-33,-96,92,40,-104,-68,-88,-72,-61,6,-14,-103,-24,-108,30,-108,107,-35,-112,63,29,-69,-13,8,-101, 
  /* [31][0][][] */ 21,-41,46,4,12,41,-40,-52,-77,-58,-63,-75,38,-77,-46,80,-51,-69,-25,-12,-15,18,-33,15,-22,-93,15,29,-54,-22,42,51,-26,-4,-69,-21,18,-71,-14,-48,-21,-55,-8,27,-5,-23,-41,-43,-26,-78,44,6,-59,-103,-36,7,-127,44,-37,43,-19,1,30,-31,23,68,-26,-42,57,-96,-121,-1,-53,-83,8,9,-44,-64,48,26,-40,-109,55,53,22,-12,-87,-7,-40,-59,-45,-21,-27,51,-79,-68, 
};
const TfArray<4, int> tensor_dimension5 = { 4, { 32,1,1,96 } };
const TfArray<32, float> quant5_scale = { 32, { 0.0035999820102006197, 0.0032262206077575684, 0.0049350284971296787, 0.0035622685682028532, 0.0029541198164224625, 0.0031976173631846905, 0.0028799891006201506, 0.0028111557476222515, 0.003233990864828229, 0.0031170009169727564, 0.003559070872142911, 0.0048073641955852509, 0.0034819699358195066, 0.0030101528391242027, 0.00322511768899858, 0.0033969837240874767, 0.0030820651445537806, 0.0038341574836522341, 0.0028447858057916164, 0.0028052618727087975, 0.0034057265147566795, 0.0039951321668922901, 0.0035723764449357986, 0.0036251840647310019, 0.0033564334735274315, 0.0030504099559038877, 0.0031107307877391577, 0.0026859208010137081, 0.0031730523332953453, 0.0032459688372910023, 0.0018580373143777251, 0.0034668950829654932, } };
const TfArray<32, int> quant5_zero = { 32, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant5 = { (TfLiteFloatArray*)&quant5_scale, (TfLiteIntArray*)&quant5_zero, 0 };
const ALIGN(16) int32_t tensor_data6[96] = { 490, -163, 3374, 7850, 2701, -3921, 3423, -1892, -3104, -408, 3278, -2725, 3221, 13666, 624, 1563, -2467, -1165, -698, 3876, 1804, -1735, 1399, -1152, -1629, 2990, 797, 941, 4764, 2069, 1359, 772, 1263, 4259, 2955, 3435, -1696, 4868, 3237, -8921, 101, 677, -21, 1048, -1915, -667, -1559, -522, -14490, 2346, 1173, -6969, 9581, -1498, 304, 375, 1430, 1165, -1356, -3232, 20, 881, -306, 4157, 3846, 2894, 1744, 4907, 6084, -2466, 3398, 5235, 3034, 112, 6576, 5834, -525, -3427, -1897, 380, 11452, 3005, -1651, -1923, 294, 1639, -339, -2752, 3747, -1857, 3131, 462, -800, -4164, -465, 567, };
const TfArray<1, int> tensor_dimension6 = { 1, { 96 } };
const TfArray<96, float> quant6_scale = { 96, { 0.00014866815763525665, 0.00031956227030605078, 0.00011535707017173991, 7.5130585173610598e-05, 0.00018415108206681907, 0.00012225010141264647, 0.00011658600851660594, 0.00013444229261949658, 0.00015011949290055782, 0.00024767545983195305, 0.00016141364176291972, 0.00016275762754958123, 0.00014447209832724184, 5.6510732974857092e-05, 0.00041489402065053582, 0.00018311411258764565, 0.00014435194316320121, 0.0001604925055289641, 0.00022130829165689647, 0.00010381748870713636, 0.00017533227219246328, 0.00012044570758007467, 9.487842908129096e-05, 0.00025144289247691631, 0.00016863594646565616, 0.00017152828513644636, 0.00018427579198032618, 0.00020634080283343792, 0.00013165698328521103, 0.00016673734353389591, 0.00014550225751008838, 0.00016283203149214387, 0.00021762460528407246, 0.00012367415183689445, 0.00018305762205272913, 0.00013915686577092856, 0.00014865343109704554, 8.4830578998662531e-05, 9.8233271273784339e-05, 7.2423485107719898e-05, 0.00029165454907342792, 0.00020405420218594372, 0.00017932856280822307, 0.00018597187590785325, 0.00012822085409425199, 0.00012109018280170858, 0.00013922851940151304, 0.00018040502618532628, 6.0122743889223784e-05, 0.00018326047575101256, 0.00017251893586944789, 0.00011408150021452457, 6.5532323787920177e-05, 0.00018265437392983586, 0.00016749602218624204, 0.0001592691260157153, 0.0002336270990781486, 0.00011002842074958608, 0.00027453762595541775, 0.00013440100883599371, 0.00016563595272600651, 0.00016193589544855058, 0.00014740886399522424, 0.00013769206998404115, 0.00015954204718582332, 0.00012625333329197019, 0.0001352774997940287, 0.00011510141484905034, 0.00011513285426190123, 0.00013368504005484283, 7.7281991252675653e-05, 0.00010769475920824334, 0.00012803553545381874, 0.00015801905828993767, 0.00010177660442423075, 0.00012176647578598931, 0.00010188927262788638, 0.00016742014850024134, 0.00011062229896197096, 0.00016063261136878282, 6.8567467678803951e-05, 0.00013907425454817712, 0.00014967043534852564, 0.00017269041563849896, 0.0002879041712731123, 0.00014352092694025487, 0.00015490537043660879, 0.00013499167107511312, 0.00014362006913870573, 0.00016074688755907118, 0.00017534084327053279, 0.00011846490815514699, 0.00015599212201777846, 0.00013666458835359663, 0.00021215132437646389, 0.00014214703696779907, } };
const TfArray<96, int> quant6_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant6 = { (TfLiteFloatArray*)&quant6_scale, (TfLiteIntArray*)&quant6_zero, 0 };
const ALIGN(16) int8_t tensor_data7[96*1*1*16] = { 
  /* [0][0][][] */ 14,95,-125,62,72,-26,81,89,-33,-6,-19,-85,89,127,-61,0, 
  /* [1][0][][] */ -22,-11,-50,-4,-36,24,20,-127,11,-38,-25,-24,-9,-33,-34,-7, 
  /* [2][0][][] */ 9,-4,48,96,25,41,-127,80,8,28,28,-78,-24,-72,-8,25, 
  /* [3][0][][] */ 111,-71,127,44,-16,-36,-76,105,16,117,15,0,-28,1,49,-39, 
  /* [4][0][][] */ 2,11,17,50,-90,25,-59,-108,8,21,-12,-35,41,29,127,56, 
  /* [5][0][][] */ 116,38,9,-33,-100,9,5,27,12,-21,-21,71,127,74,-52,10, 
  /* [6][0][][] */ 50,22,-41,13,-27,38,50,-23,18,10,-11,-33,101,54,127,-47, 
  /* [7][0][][] */ -70,12,-2,-44,-16,-44,-72,-25,-69,51,-50,-45,-127,-41,11,77, 
  /* [8][0][][] */ 57,42,57,31,52,30,86,6,78,-30,51,8,-127,-51,-79,9, 
  /* [9][0][][] */ -58,29,12,-59,-18,-37,17,-5,-47,25,-18,53,42,127,-4,45, 
  /* [10][0][][] */ 89,76,-56,12,-20,22,88,9,-14,10,-4,-127,-60,-28,21,74, 
  /* [11][0][][] */ -3,-31,9,-31,-11,-53,-7,52,-88,-17,-51,22,-31,-29,10,127, 
  /* [12][0][][] */ -127,-68,-26,-48,22,-41,85,23,-63,-31,-21,47,-35,39,-105,123, 
  /* [13][0][][] */ 42,16,106,71,115,-23,19,127,-32,110,-110,-84,16,28,46,6, 
  /* [14][0][][] */ -53,66,6,0,13,0,57,-2,-19,31,127,-1,-79,58,0,34, 
  /* [15][0][][] */ 24,14,-96,-52,115,4,-60,-37,25,9,-31,-113,18,-127,-32,15, 
  /* [16][0][][] */ 127,30,37,53,55,1,85,-29,18,56,94,-7,48,0,0,8, 
  /* [17][0][][] */ 9,19,-37,-79,-6,-7,127,-91,1,-46,-66,48,43,61,-8,12, 
  /* [18][0][][] */ 16,100,-58,-59,89,-113,-20,-16,-50,127,-40,-22,-64,44,10,-17, 
  /* [19][0][][] */ 6,-26,127,10,29,-14,-16,-3,88,106,11,8,35,-59,117,-72, 
  /* [20][0][][] */ -7,88,33,29,-6,9,4,-66,51,-16,127,-10,-106,-33,-70,-9, 
  /* [21][0][][] */ -68,100,79,66,81,65,67,70,-111,127,-81,-33,-89,13,-21,-74, 
  /* [22][0][][] */ 67,-51,60,69,20,-96,56,37,53,-34,-104,-127,99,-83,20,-93, 
  /* [23][0][][] */ -14,-37,50,39,55,23,4,-21,1,-8,44,-20,50,91,94,127, 
  /* [24][0][][] */ -8,-3,104,124,99,5,-61,-127,91,72,-47,45,-21,57,-8,-31, 
  /* [25][0][][] */ 13,63,41,-35,-49,5,27,-36,-24,69,-93,-55,23,127,56,-2, 
  /* [26][0][][] */ -50,68,-31,-21,29,-74,-18,-18,10,-18,17,88,35,17,-94,127, 
  /* [27][0][][] */ -30,-96,-57,2,-55,70,-27,-60,18,-45,36,-8,43,-39,-127,-31, 
  /* [28][0][][] */ -48,-12,48,45,21,-5,-48,-127,-122,5,99,43,80,-5,-59,30, 
  /* [29][0][][] */ -127,67,-68,-26,-35,8,-91,-59,-63,-50,29,38,-6,-52,-103,65, 
  /* [30][0][][] */ 70,95,7,86,-27,-36,-64,-4,13,22,-32,-127,68,-6,24,25, 
  /* [31][0][][] */ 127,37,-37,-16,-79,15,46,22,-44,21,48,3,22,70,9,-21, 
  /* [32][0][][] */ -30,-7,127,-29,-28,77,95,13,-37,-29,0,36,39,82,60,49, 
  /* [33][0][][] */ 1,31,-84,-30,-8,28,127,-5,26,-20,22,-29,69,61,-36,17, 
  /* [34][0][][] */ -91,45,70,-16,21,-39,127,-19,-75,-7,26,-23,51,8,-61,-22, 
  /* [35][0][][] */ 12,43,10,-13,-43,111,-1,-43,-42,29,-4,127,-99,17,13,35, 
  /* [36][0][][] */ -34,-61,127,-66,-30,9,-69,-18,30,36,-79,55,-16,-108,-45,55, 
  /* [37][0][][] */ 74,-14,32,66,73,-85,-78,0,-23,98,-104,-12,-127,-66,82,-49, 
  /* [38][0][][] */ 5,-4,53,-75,78,-87,-13,38,-57,55,-39,-20,-94,-127,-98,46, 
  /* [39][0][][] */ -45,54,-110,-28,-80,-22,114,11,-127,-63,58,117,86,43,5,67, 
  /* [40][0][][] */ 127,-7,82,-120,-88,19,3,-4,-53,-26,-55,-81,15,-1,15,48, 
  /* [41][0][][] */ 127,-15,-27,5,6,23,5,-72,77,-6,14,-75,124,0,74,-28, 
  /* [42][0][][] */ -30,-117,-103,118,-47,-127,-82,49,19,-16,14,84,-88,44,-113,-4, 
  /* [43][0][][] */ -76,-57,-46,-74,-32,40,17,63,31,-127,-20,48,-27,-43,-35,70, 
  /* [44][0][][] */ -66,12,24,-84,-7,-1,24,43,55,-114,48,127,99,73,-50,38, 
  /* [45][0][][] */ 68,114,-39,121,127,-50,-94,4,121,-14,46,-122,20,15,-8,45, 
  /* [46][0][][] */ -5,-4,44,-51,66,4,41,51,15,105,-73,-127,3,-13,-55,31, 
  /* [47][0][][] */ 62,-19,-35,-28,28,13,-71,-45,-13,127,-36,27,31,-77,-100,19, 
  /* [48][0][][] */ 29,69,-23,-73,26,2,127,-102,43,35,-4,19,28,57,21,-8, 
  /* [49][0][][] */ 3,127,-84,18,80,24,73,64,-10,9,68,-85,-54,81,68,-49, 
  /* [50][0][][] */ 40,71,-57,16,-127,54,-58,-9,93,118,90,14,22,-35,62,37, 
  /* [51][0][][] */ 127,8,-24,21,11,102,-74,-54,92,8,-55,12,6,-40,23,-9, 
  /* [52][0][][] */ -69,-121,1,78,-91,-125,-92,-37,-50,-117,4,-34,-24,-127,-55,126, 
  /* [53][0][][] */ 36,99,80,-97,0,65,54,-7,-2,-10,-26,-40,120,-127,12,39, 
  /* [54][0][][] */ 55,127,35,59,6,-18,-73,101,52,40,-49,64,81,26,64,14, 
  /* [55][0][][] */ -4,6,90,65,48,-12,57,87,-24,29,-42,-38,127,29,31,-44, 
  /* [56][0][][] */ 127,35,12,-36,-33,104,-36,-91,-50,-16,-106,3,-21,116,7,52, 
  /* [57][0][][] */ -15,-50,-73,-8,-127,-95,14,7,-122,17,32,64,90,66,11,34, 
  /* [58][0][][] */ 49,-10,43,-6,-13,-20,0,-3,28,-15,-127,-45,31,-28,-38,24, 
  /* [59][0][][] */ 101,9,-114,123,-41,47,10,45,8,-30,3,-127,-116,-98,33,34, 
  /* [60][0][][] */ -16,11,-5,16,-65,-46,-62,-25,-59,-83,39,127,-39,-118,-62,19, 
  /* [61][0][][] */ -24,15,94,-120,-28,41,6,39,-21,-85,50,56,105,-51,19,127, 
  /* [62][0][][] */ 80,38,-24,-123,-44,25,1,-19,-21,20,-23,74,127,-19,-111,-70, 
  /* [63][0][][] */ -27,-59,55,-47,-14,-100,-68,-11,-112,-33,-37,7,127,-3,38,-4, 
  /* [64][0][][] */ -19,-37,-15,47,-127,-75,-57,-74,2,109,46,20,-42,-17,-46,64, 
  /* [65][0][][] */ -25,1,-46,18,-74,66,-38,-26,56,-104,127,-25,73,43,-116,46, 
  /* [66][0][][] */ -58,115,-9,-71,52,-2,-89,-34,-8,127,1,-44,-35,-108,69,36, 
  /* [67][0][][] */ 28,-6,-104,-127,86,116,-22,-55,-43,34,16,-49,47,59,60,44, 
  /* [68][0][][] */ 82,60,29,-17,23,54,46,104,-22,127,65,-75,-18,-35,-83,-44, 
  /* [69][0][][] */ 7,-93,73,-117,-10,-127,-54,119,-55,36,55,104,37,88,-39,78, 
  /* [70][0][][] */ 125,54,127,121,58,81,90,40,122,51,-102,-40,-42,-15,16,-54, 
  /* [71][0][][] */ -5,36,103,-94,-106,-109,8,-8,-30,-7,29,-127,-124,16,0,65, 
  /* [72][0][][] */ -80,-99,13,-105,39,-20,-18,9,-82,-20,-91,13,26,60,-70,127, 
  /* [73][0][][] */ 45,30,33,-11,94,-115,-30,12,-47,15,-114,25,-89,-43,127,-62, 
  /* [74][0][][] */ -104,-38,-127,-37,25,-55,-74,5,-102,-34,-63,17,-48,-51,-71,77, 
  /* [75][0][][] */ 86,-33,21,-49,-12,-1,-127,-46,-23,-125,93,34,20,-42,-31,19, 
  /* [76][0][][] */ 8,14,-100,57,-11,88,126,-46,79,-127,23,53,59,-47,-77,11, 
  /* [77][0][][] */ -56,-60,127,-44,-3,-30,-72,-101,-20,-4,33,70,18,13,-18,33, 
  /* [78][0][][] */ 29,73,45,17,17,-54,1,-40,62,18,-28,-127,-66,-70,-48,-87, 
  /* [79][0][][] */ -54,-64,60,115,127,77,-44,44,28,34,-36,26,-28,-66,1,-32, 
  /* [80][0][][] */ -10,-102,91,127,-49,-19,-114,22,4,6,11,-31,-107,-48,-3,42, 
  /* [81][0][][] */ 99,59,-70,39,25,6,42,30,16,-41,127,43,28,44,-11,-15, 
  /* [82][0][][] */ -85,-9,11,-16,-22,-127,-127,-110,13,70,-13,-33,-95,26,-116,7, 
  /* [83][0][][] */ 66,-40,127,-12,1,10,-112,15,-1,-92,15,-47,-46,-55,24,-24, 
  /* [84][0][][] */ -21,-19,-127,1,105,47,53,33,-107,-2,-72,-2,35,-8,-107,7, 
  /* [85][0][][] */ 8,79,27,-14,61,2,23,-107,116,-24,13,-10,127,-95,29,-15, 
  /* [86][0][][] */ 127,16,103,76,22,-12,52,11,-3,-20,-102,-78,36,27,-23,-25, 
  /* [87][0][][] */ 7,3,61,-37,54,-15,-94,25,25,-15,23,-38,-78,-127,28,1, 
  /* [88][0][][] */ -41,-4,18,-12,33,-3,-22,-50,21,0,-62,-127,-76,-68,-31,3, 
  /* [89][0][][] */ -45,24,56,13,-8,57,-127,9,85,78,-90,-16,2,-25,0,-17, 
  /* [90][0][][] */ -12,-18,-16,-41,127,25,-87,-6,46,45,37,-2,33,0,-62,-28, 
  /* [91][0][][] */ -9,-15,96,76,-77,58,-96,82,-60,9,-53,-102,15,93,83,127, 
  /* [92][0][][] */ -29,123,21,14,-23,98,-107,80,-30,10,103,-44,-32,127,109,-14, 
  /* [93][0][][] */ 30,99,-10,-9,60,127,-70,37,98,87,30,22,-76,-8,17,37, 
  /* [94][0][][] */ 59,93,73,-37,-127,1,41,-9,47,-14,97,-10,-13,14,35,-39, 
  /* [95][0][][] */ -19,76,89,-40,66,21,-50,36,19,33,-127,2,33,-33,119,-32, 
};
const TfArray<4, int> tensor_dimension7 = { 4, { 96,1,1,16 } };
const TfArray<96, float> quant7_scale = { 96, { 0.0013532177545130253, 0.0029087420552968979, 0.0010500112548470497, 0.00068385893246158957, 0.0016761929728090763, 0.0011127535253763199, 0.0010611973702907562, 0.0012237300397828221, 0.0013664282159879804, 0.0022544090170413256, 0.0014692306285724044, 0.0014814638998359442, 0.0013150240993127227, 0.00051437597721815109, 0.00377647764980793, 0.0016667541349306703, 0.0013139303773641586, 0.0014608461642637849, 0.0020144078880548477, 0.00094497483223676682, 0.0015959216980263591, 0.0010963294189423323, 0.00086360913701355457, 0.0022887012455612421, 0.001534970011562109, 0.001561296870931983, 0.0016773280221968889, 0.0018781698308885098, 0.0011983774602413177, 0.0015176883898675442, 0.001324400887824595, 0.0014821412041783333, 0.001980877947062254, 0.0011257155565544963, 0.0016662399284541607, 0.0012666434049606323, 0.0013530837604776025, 0.00077215087367221713, 0.00089414580725133419, 0.00065921811619773507, 0.0026547184679657221, 0.0018573565175756812, 0.0016322970623150468, 0.0016927663236856461, 0.0011671008542180061, 0.0011021955870091915, 0.0012672955635935068, 0.0016420952742919326, 0.0005472534685395658, 0.0016680863918736577, 0.0015703139360994101, 0.0010384006891399622, 0.00059649295872077346, 0.0016625694697722793, 0.0015245940303429961, 0.0014497106894850731, 0.0021265370305627584, 0.0010015084408223629, 0.0024989156518131495, 0.0012233543675392866, 0.0015076632844284177, 0.0014739843318238854, 0.0013417552690953016, 0.0012533104745671153, 0.0014521948760375381, 0.0011491919867694378, 0.0012313324259594083, 0.0010476842289790511, 0.0010479703778401017, 0.0012168374378234148, 0.00070344156119972467, 0.00098026683554053307, 0.0011654141126200557, 0.0014383322559297085, 0.00092639814829453826, 0.0011083513963967562, 0.00092742370907217264, 0.0015239034546539187, 0.0010069140698760748, 0.001462121494114399, 0.0006241196533665061, 0.0012658914783969522, 0.0013623407576233149, 0.0015718748327344656, 0.0026205815374851227, 0.0013063662918284535, 0.0014099905965849757, 0.0012287306599318981, 0.0013072687434032559, 0.0014631616650149226, 0.0015959996962919831, 0.0010782995959743857, 0.0014198825228959322, 0.0012439580168575048, 0.0019310587085783482, 0.0012938607251271605, } };
const TfArray<96, int> quant7_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant7 = { (TfLiteFloatArray*)&quant7_scale, (TfLiteIntArray*)&quant7_zero, 0 };
const ALIGN(16) int32_t tensor_data8[16] = { 1911, 9091, 5966, -227, 9284, -4845, 4760, 4491, 5169, 3139, -15466, 4060, -12512, 15079, 2747, 17516, };
const TfArray<1, int> tensor_dimension8 = { 1, { 16 } };
const TfArray<16, float> quant8_scale = { 16, { 5.0807597290258855e-05, 5.7614190154708922e-05, 5.3260104323271662e-05, 4.6037719585001469e-05, 3.8792954001110047e-05, 6.5924097725655884e-05, 4.4926375267095864e-05, 4.4355710997479036e-05, 6.8432527768891305e-05, 5.6500695791328326e-05, 3.1068273528944701e-05, 6.9722904299851507e-05, 4.5736185711575672e-05, 4.6878576540620998e-05, 6.2594117480330169e-05, 6.5986496338155121e-05, } };
const TfArray<16, int> quant8_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant8 = { (TfLiteFloatArray*)&quant8_scale, (TfLiteIntArray*)&quant8_zero, 0 };
const ALIGN(16) int8_t tensor_data9[16*1*1*96] = { 
  /* [0][0][][] */ -41,25,26,-26,-78,-14,-104,26,-17,44,13,18,65,21,37,-47,16,-73,82,-9,9,-92,69,42,23,-20,-26,23,-51,-45,-65,47,-6,-40,78,36,48,34,28,4,13,25,-52,10,-30,16,18,75,-5,-9,-19,-41,-37,16,-25,-31,-32,40,-21,99,99,51,-45,-15,-1,-5,-56,44,-127,-41,-17,8,17,29,-22,-25,-61,0,-66,24,-27,36,10,-60,47,44,16,35,9,-3,5,-51,43,-37,-79,12, 
  /* [1][0][][] */ 54,3,3,-25,-16,-52,24,26,2,3,38,-44,-9,-21,-56,-85,19,-3,10,15,-49,-47,-19,45,-22,-48,41,-7,72,-95,63,-57,50,-21,35,54,33,68,1,-5,51,45,29,-3,22,44,-127,-81,-24,-66,-24,-30,67,-7,11,-7,-1,-5,-50,24,57,64,-21,-58,9,-31,-13,-42,-40,-21,-28,-4,-33,8,29,-31,26,48,12,-74,3,-66,-94,0,9,-26,-7,5,-66,-13,-20,26,48,4,-32,66, 
  /* [2][0][][] */ 28,-58,-18,6,24,-60,27,18,16,29,5,-10,-55,-60,-12,-52,-58,-44,-79,-13,12,-66,-26,-20,33,-67,-21,-64,-82,-1,-27,55,-18,127,-41,-32,-38,-26,-2,-10,-86,30,21,-2,-13,-4,29,-18,43,-6,-17,-72,57,3,-56,26,62,-12,20,15,23,22,-53,-19,6,32,-5,-2,27,-30,-12,-39,16,-21,18,47,16,-70,60,38,42,-19,-43,17,-43,49,11,53,16,-4,-2,66,-91,22,-12,4, 
  /* [3][0][][] */ 32,-24,-37,3,-30,25,-56,-77,-3,100,31,50,92,-62,-11,19,8,-93,33,-29,15,122,49,-66,51,-9,-38,18,50,15,61,2,-27,-25,42,12,69,43,65,15,-69,-15,-19,-8,-6,48,-17,20,-4,-101,40,-26,15,-86,-80,-44,42,127,-47,24,48,32,-97,44,66,75,-58,35,-107,43,-19,-47,22,-61,44,0,3,29,-81,-32,-3,-1,-41,-24,15,-62,38,34,10,49,49,-18,101,42,-62,71, 
  /* [4][0][][] */ -33,40,-63,27,24,-14,-101,14,-93,62,118,-72,-23,17,1,-79,35,-18,-56,28,-8,-76,99,30,-53,-10,-127,1,12,-59,51,-4,-1,-45,7,15,14,15,46,43,-60,-72,53,-2,-19,33,-87,38,-53,89,4,16,50,-17,-33,29,-10,-54,-26,-32,73,16,41,-29,-29,-9,-37,-7,-53,-16,-64,52,15,-47,-34,-32,25,-78,-17,0,-51,78,-75,12,-2,-16,26,-83,64,12,63,15,-95,-74,26,-12, 
  /* [5][0][][] */ -54,50,40,25,62,8,74,38,11,-20,-16,10,20,-17,4,-27,-50,-13,63,54,-66,-50,-70,61,-41,-41,46,43,106,-7,-41,63,71,127,18,36,4,21,48,-11,36,72,55,1,32,35,26,-15,-19,-8,7,38,40,10,56,-38,36,2,-43,-27,14,66,-30,-7,77,-42,-33,-59,-86,-11,-36,23,19,27,41,-50,38,-16,-45,-16,125,-5,-14,-25,-69,39,-16,85,-45,3,-16,-36,36,44,5,96, 
  /* [6][0][][] */ 34,37,-88,-36,-27,-112,105,96,-37,63,-26,20,-81,-63,65,19,7,-65,15,-12,-41,-77,-39,-52,-84,-1,81,54,127,28,97,-15,2,-22,-20,-24,21,19,8,19,61,23,-64,-34,-31,-4,-66,-30,16,-121,-17,79,42,6,-8,-80,57,55,-48,70,-54,59,-88,-47,53,17,-25,52,-7,-48,-57,13,7,73,120,-14,0,-11,-24,-78,-12,-60,-98,84,39,0,62,29,-14,45,18,-11,-15,8,-39,101, 
  /* [7][0][][] */ 5,46,-46,-63,-34,-3,23,14,-58,0,-33,-45,-28,20,18,-43,-24,-23,-77,14,-7,54,-1,-11,12,-1,-17,-27,18,1,47,-33,72,20,-48,10,25,-13,-6,26,-12,-36,-18,-44,54,-17,46,-60,-20,-37,-45,-42,-22,-2,-15,-12,0,31,-99,42,-39,127,45,-20,-46,-3,-22,-4,-38,-39,-56,32,57,28,-51,49,-60,14,21,-45,-39,-5,-7,-53,27,-12,21,51,44,29,-44,34,6,-41,-12,-4, 
  /* [8][0][][] */ -19,44,-23,45,-9,6,-57,38,-59,-33,23,23,-21,53,7,54,2,-36,20,24,22,-18,-1,-5,-43,39,28,49,29,24,-8,14,1,-57,24,-44,-19,14,55,13,35,-5,35,37,-39,-2,-23,-16,-18,0,57,65,7,22,-40,77,-41,70,-3,-4,-15,12,31,31,8,-64,-18,-33,-83,42,2,33,2,-36,-45,-25,-31,27,-88,-30,-2,-7,-56,8,34,-27,32,46,11,72,-36,-41,-9,-127,-8,-5, 
  /* [9][0][][] */ 8,-32,-93,49,-96,-43,7,50,-12,25,-19,33,-8,-13,40,53,37,-40,53,-11,23,3,-13,-92,10,-22,11,-23,-12,-15,-3,-14,13,-48,42,-81,8,-36,-15,5,-39,16,41,-32,20,19,-25,-26,28,78,28,-31,-67,-58,-45,-35,28,30,32,-4,-13,88,-68,-32,40,20,-31,-24,-127,37,35,14,-17,67,-25,24,-18,28,-50,-23,31,-42,29,-30,39,-41,2,-12,-6,4,40,45,68,5,-72,9, 
  /* [10][0][][] */ 65,45,-49,-50,-61,7,40,32,-12,31,-2,-8,-22,-21,-18,-1,-110,-28,48,86,105,25,66,51,-33,79,114,-19,-54,-39,-32,21,127,-1,-6,30,118,-67,69,99,51,-34,58,13,-25,-57,-11,88,51,79,-28,-53,-70,-41,-11,62,48,-36,52,51,5,40,-51,-21,-14,-16,-27,14,-6,13,-55,75,126,20,7,-112,-14,-48,18,-36,-39,46,71,1,-12,-12,28,35,-77,-15,31,47,26,81,-50,14, 
  /* [11][0][][] */ -8,8,54,-83,-19,0,-42,-3,24,-6,-27,-18,-26,-1,34,47,-65,18,21,36,6,27,-64,-17,-15,-7,-41,12,20,-22,55,-7,-13,26,-15,-3,-28,25,-65,-24,-22,41,-40,20,-4,-29,13,1,17,-59,-27,0,-8,8,13,-45,8,-23,11,-51,-4,-57,-22,-22,19,-8,20,53,127,11,22,-3,-6,24,-14,-41,13,30,19,28,32,36,16,10,12,1,10,-29,-61,-56,-53,9,-29,51,63,14, 
  /* [12][0][][] */ 44,-23,5,-76,48,92,24,74,72,64,-8,57,10,38,50,27,-86,72,19,43,127,-50,30,-28,4,-3,-33,-30,37,70,18,11,5,47,7,-40,38,-11,-46,-68,62,-40,44,-10,-27,26,36,-34,-59,-13,18,74,13,26,10,10,39,70,-3,98,-3,-104,-12,-66,-35,70,6,-39,28,-79,24,34,65,33,16,-3,-19,43,-72,-18,6,62,36,63,-1,107,-15,-38,93,-7,-105,21,54,16,19,-40, 
  /* [13][0][][] */ 29,-9,-41,-120,-25,-37,-13,13,11,-54,-38,-63,40,-121,-2,-88,4,-60,-51,-60,-82,-52,-18,92,-43,-9,109,47,86,-66,79,7,7,29,-55,112,6,-92,-15,-52,127,1,-16,-13,24,-92,71,-77,39,-54,-38,31,26,49,-30,20,120,-38,-87,73,89,74,-58,-68,-1,19,-12,54,-97,-115,-82,0,-37,28,-45,-84,-106,48,22,60,15,1,-52,-85,11,59,9,-26,3,-44,-33,11,-38,-12,-11,4, 
  /* [14][0][][] */ 42,-36,-84,-19,65,80,-113,4,78,-8,44,13,-2,-21,-9,-70,-43,-21,22,89,17,-63,-40,-16,-6,24,-41,48,1,32,-30,40,72,34,27,34,31,34,39,-26,37,-8,-2,-61,-15,-25,66,-6,58,3,28,-55,6,37,-84,30,54,91,-54,58,6,-42,-44,-88,-11,-7,-65,31,-127,37,-35,23,24,-60,20,-9,12,-5,-60,-27,12,-5,-5,-40,12,45,9,6,15,-8,76,-7,30,-34,-65,-37, 
  /* [15][0][][] */ -92,-20,23,-81,2,-49,1,-71,-24,0,2,28,-36,-20,5,94,-100,-15,-29,-80,25,-8,22,-83,42,6,23,-80,-104,-110,-16,3,-68,83,2,-100,-32,-40,25,-66,-45,-60,7,-25,-7,-2,88,110,-56,29,11,-16,-29,9,7,-30,-73,-66,66,2,-31,-23,-51,-7,-74,-1,-21,27,127,-99,32,-33,10,-54,-93,-78,-56,-7,71,4,-25,93,49,-18,6,-5,-113,-42,-33,-27,-67,1,-38,-19,-17,4, 
};
const TfArray<4, int> tensor_dimension9 = { 4, { 16,1,1,96 } };
const TfArray<16, float> quant9_scale = { 16, { 0.0021593228448182344, 0.0024486030451953411, 0.0022635543718934059, 0.0019566030241549015, 0.0016487004468217492, 0.0028017740696668625, 0.0019093708833679557, 0.001885117613710463, 0.0029083823319524527, 0.0024012795183807611, 0.0013204016722738743, 0.0029632234945893288, 0.0019437877926975489, 0.001992339501157403, 0.0026602500583976507, 0.0028044260106980801, } };
const TfArray<16, int> quant9_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant9 = { (TfLiteFloatArray*)&quant9_scale, (TfLiteIntArray*)&quant9_zero, 0 };
const ALIGN(16) int32_t tensor_data10[96] = { -6258, 3318, -3627, -7114, -104, 3469, 3997, -2297, -598, -10914, 3509, -3546, 2543, -8619, 6457, -30, 8725, -3242, -4070, 3012, 2985, -2940, 13054, -6009, 1080, -2842, 5960, -2228, -3555, -17480, 4137, 2777, -148, 4774, -4166, -1332, 3234, -315, -3845, 2775, -139, 1797, 977, -2559, 7158, 8399, 629, 12900, 2919, 9492, 2653, -5375, -1325, -6001, 647, 15645, 627, -4084, 8464, 4492, 9751, 14093, 917, -12969, 9026, 2372, -6243, 11037, -2614, -1340, 5404, -859, 3590, -3906, -2035, 3360, -2567, -5682, -785, -5289, -5323, 12814, 6305, 16502, -567, -2265, -1600, -88, -9324, -3166, 14222, 1470, -8547, 1264, -4908, -4941, };
const TfArray<1, int> tensor_dimension10 = { 1, { 96 } };
const TfArray<96, float> quant10_scale = { 96, { 0.0001725789625197649, 0.00011523468128871173, 8.8154934928752482e-05, 7.2446840931661427e-05, 0.00018522496975492686, 0.00033164554042741656, 0.00026119744870811701, 0.0001289722858928144, 0.00032574628130532801, 0.00011740026093320921, 0.00012899373541586101, 0.00017206772463396192, 0.00015556432481389493, 7.4138923082500696e-05, 0.00011652530520223081, 0.00024263300292659551, 0.0001516081829322502, 0.00020331983978394419, 0.00010759066935861483, 7.5648749771062285e-05, 0.00024029078485909849, 0.00033255005837418139, 0.00015105334750842303, 0.00011694982822518796, 0.00046574627049267292, 0.00017571102944202721, 0.00029505335260182619, 0.00014230709348339587, 0.00022515800083056092, 3.3455296943429857e-05, 0.00032817863393574953, 8.8737455371301621e-05, 0.00028690422186627984, 0.00022029524552635849, 0.0002175462432205677, 0.00021836624364368618, 0.00024538228171877563, 0.0010358924046158791, 0.00012961192987859249, 0.00014894008927512914, 0.00018228731642011553, 0.00022729580814484507, 0.00017395761096850038, 0.00019680327386595309, 9.3797236331738532e-05, 5.5142652854556218e-05, 0.00026538645033724606, 0.00011079525575041771, 0.00020782351202797145, 0.00016228720778599381, 6.6035456256940961e-05, 7.4547358963172883e-05, 0.00012585762306116521, 0.00013711830251850188, 0.0002493954380042851, 0.00011681370961014181, 9.9812765256501734e-05, 0.0001354249834548682, 0.00016340929141733795, 0.00013084296369925141, 9.6412222774233669e-05, 0.00010538581409491599, 0.00015710524166934192, 8.451396570308134e-05, 8.6267144070006907e-05, 0.00017421417578589171, 0.00016273731307592243, 0.00012307506403885782, 0.00027213405701331794, 0.00023234520631376654, 0.00021683704107999802, 0.00015130966494325548, 0.00013626863074023277, 0.00026177542167715728, 0.00020266084175091237, 0.00017788397963158786, 9.0520450612530112e-05, 0.00011845162225654349, 0.00022155963233672082, 0.00017838209168985486, 0.00019063288345932961, 9.3314170953817666e-05, 0.00029017354245297611, 9.6516894700471312e-05, 0.0001625932491151616, 0.00019717069517355412, 0.00019034612341783941, 0.00026105562574230134, 0.00026882888050749898, 0.00026576034724712372, 9.2489019152708352e-05, 0.00013208088057581335, 0.00018140836618840694, 0.00032523288973607123, 9.8237520433031023e-05, 8.5088417108636349e-05, } };
const TfArray<96, int> quant10_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant10 = { (TfLiteFloatArray*)&quant10_scale, (TfLiteIntArray*)&quant10_zero, 0 };
const ALIGN(16) int8_t tensor_data11[1*3*3*96] = { 
  /* [0][0][][] */ 48,83,79,111,-79,3,4,29,66,-31,-127,-35,-47,109,-4,-72,-34,-2,34,40,-16,94,-25,86,38,-61,-94,34,-34,-8,-22,-63,52,-64,-40,109,26,123,37,-68,40,-67,48,22,-36,-35,-4,-18,-63,-76,-67,-86,50,84,17,-30,-84,-40,-11,-100,-38,-8,-31,37,-85,38,100,-66,3,127,11,39,25,-15,44,32,-47,47,-70,47,41,21,-10,-81,49,-36,56,-96,-32,39,-115,-8,78,-27,127,-117, -3,-48,25,127,-62,94,-90,-32,96,33,-82,-10,-87,-4,-48,64,-127,120,-31,3,112,38,36,127,68,-28,1,40,44,84,-54,-127,127,127,14,97,127,115,63,-29,127,11,120,37,-40,-91,127,-96,-49,-127,-127,-79,102,127,-88,-83,-35,104,-127,-85,-6,-107,-24,11,-67,117,68,-91,5,93,127,41,-127,38,-23,-127,-34,-40,62,127,-7,-85,127,-126,-69,-25,52,-20,48,81,-116,-39,127,-36,-47,108, 29,-28,72,126,-27,-9,-26,51,48,14,6,-54,-42,121,10,-127,11,-13,-25,-16,8,110,-35,18,16,-81,-32,127,12,76,-42,-81,-12,-119,-27,127,10,34,24,12,5,16,22,-33,2,51,-40,56,-16,10,-115,69,28,64,-51,-89,-1,-20,-29,46,-127,29,-39,-24,-8,52,56,-47,-41,43,40,-17,-1,-44,-2,-19,28,43,-26,50,27,28,10,-65,-36,-39,-41,77,-13,-43,-127,8,64,18,87,25, 
  /* [0][1][][] */ 127,-57,123,78,31,-47,120,23,-55,-44,-76,127,-26,-8,-21,-47,2,-4,126,76,-127,-7,-127,42,23,-12,-127,30,-71,39,93,-11,49,-4,12,30,-125,14,16,15,48,-127,-21,93,-127,-40,23,-127,-127,-25,1,107,14,-1,103,-4,-127,16,-41,-3,-81,-127,-24,127,-127,-72,127,-127,-14,32,-65,-127,-82,28,127,-3,72,127,-82,-10,127,-28,-49,49,42,-26,38,-26,43,-40,-19,-15,65,-127,91,-39, -91,-44,-72,79,-73,-127,-127,-127,45,35,20,84,-126,4,-78,-37,-78,-111,99,127,23,-127,-101,93,-127,103,27,46,17,-54,-127,14,-89,41,127,16,14,35,127,57,-62,-17,-14,127,18,-23,-59,-90,-14,-43,-34,94,127,26,8,-88,14,50,87,-28,-32,-87,-127,91,-70,-127,70,122,-1,-25,-59,-79,-42,127,-97,-18,127,113,118,-21,-39,-30,-98,-15,-14,-41,127,127,127,127,-32,-127,-10,-73,-6,111, 103,-53,127,-70,-12,-74,-14,84,-31,117,32,112,-13,92,-127,-3,-72,-6,-53,-9,-78,38,-124,-7,-15,-48,52,38,127,98,13,-104,7,-109,-4,69,-88,-46,10,16,25,78,-14,122,20,-46,12,-24,84,-70,-80,22,82,3,-127,-27,32,53,-105,47,-63,-85,-31,55,80,-48,111,-57,-55,17,-15,-11,-120,-80,0,-35,33,28,-104,20,-33,-127,-59,35,-53,-17,-63,-51,37,-11,-4,-10,42,127,34,-80, 
  /* [0][2][][] */ 56,-127,44,53,77,9,2,97,-11,43,-68,20,28,85,-21,67,6,120,106,113,-37,19,-63,100,-48,127,-18,27,-50,92,3,-35,17,-56,-26,-36,-12,-36,10,-42,15,17,-15,-52,-46,-127,-78,-57,-23,22,30,38,51,-53,1,-10,-64,39,8,127,5,3,115,48,-83,-29,27,-52,76,50,-52,21,74,85,14,48,-4,-10,127,-4,-31,-30,-58,-83,38,115,-5,-78,-18,-24,13,70,-24,-11,19,-127, -58,-35,51,-106,127,19,-4,90,-127,81,-64,21,127,87,-19,-38,-15,127,82,30,-7,33,90,99,23,79,-19,78,-15,69,-5,-44,-96,-9,43,-17,17,15,51,-127,3,4,-127,77,-48,-26,-37,-5,12,-32,-49,88,19,-41,27,-127,-58,127,27,46,-26,-68,94,97,-97,18,67,-29,127,-32,-64,75,45,-20,-45,1,23,-69,-3,10,27,-70,-80,-127,38,127,-39,-59,90,-20,17,5,-33,60,62,-24, 30,20,30,-98,19,15,-53,69,-20,127,102,43,-6,127,-23,98,4,44,-127,-34,-18,-15,-69,55,27,29,16,-32,70,127,-17,-68,33,-47,-19,-24,-11,-127,30,-53,-35,-31,6,-9,1,-90,-22,-71,25,-104,-2,127,62,-5,17,-70,-46,58,20,114,-24,-7,71,58,-4,-40,14,2,16,48,5,110,97,51,5,55,-29,-26,69,13,7,-117,5,-92,127,40,-61,-3,-9,13,-12,39,-34,5,-46,-114, 
};
const TfArray<4, int> tensor_dimension11 = { 4, { 1,3,3,96 } };
const TfArray<96, float> quant11_scale = { 96, { 0.0073346057906746864, 0.0048974738456308842, 0.0037465845234692097, 0.0030789906159043312, 0.0078720608726143837, 0.014094935730099678, 0.011100891046226025, 0.0054813218303024769, 0.013844216242432594, 0.0049895108677446842, 0.0054822335951030254, 0.0073128780350089073, 0.0066114836372435093, 0.003150904318317771, 0.0049523254856467247, 0.01031190250068903, 0.0064433477818965912, 0.0086410930380225182, 0.0045726033858954906, 0.0032150717452168465, 0.010212358087301254, 0.014133377000689507, 0.0064197671599686146, 0.0049703675322234631, 0.019794216379523277, 0.0074677187949419022, 0.012539766728878021, 0.0060480516403913498, 0.0095692146569490433, 0.0014218500582501292, 0.013947592116892338, 0.0037713418714702129, 0.012193429283797741, 0.0093625476583838463, 0.0092457151040434837, 0.0092805651947855949, 0.010428746230900288, 0.044025424867868423, 0.0055085066705942154, 0.006329953670501709, 0.0077472105622291565, 0.0096600716933608055, 0.0073931985534727573, 0.008364139124751091, 0.0039863823913037777, 0.0023435626644641161, 0.011278924532234669, 0.004708798136562109, 0.0088324993848800659, 0.0068972064182162285, 0.0028065068181604147, 0.0031682625412940979, 0.0053489487618207932, 0.0058275274932384491, 0.010599305853247643, 0.004964582622051239, 0.0042420425452291965, 0.0057555618695914745, 0.0069448947906494141, 0.0055608255788683891, 0.0040975194424390793, 0.0044788969680666924, 0.0066769728437066078, 0.0035918434150516987, 0.0036663536448031664, 0.0074041024781763554, 0.0069163357838988304, 0.005230689886957407, 0.011565697379410267, 0.0098746707662940025, 0.0092155737802386284, 0.0064306608401238918, 0.0057914163917303085, 0.011125454679131508, 0.0086130853742361069, 0.0075600692071020603, 0.003847119165584445, 0.0050341938622295856, 0.0094162840396165848, 0.0075812386348843575, 0.0081018973141908646, 0.0039658523164689541, 0.012332375161349773, 0.0041019679047167301, 0.006910212803632021, 0.0083797546103596687, 0.0080897100269794464, 0.011094863526523113, 0.011425226926803589, 0.011294814758002758, 0.0039307833649218082, 0.0056134373880922794, 0.007709855679422617, 0.013822398148477077, 0.0041750944219529629, 0.0036162575706839561, } };
const TfArray<96, int> quant11_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant11 = { (TfLiteFloatArray*)&quant11_scale, (TfLiteIntArray*)&quant11_zero, 3 };
const ALIGN(16) int32_t tensor_data12[96] = { 2279, 4624, 561, -481, 2950, 12248, 2966, -420, -2326, 4008, 1502, -3299, 4350, 1910, 121, -653, 4365, 4874, -1394, 341, 4020, 4983, 10066, -2050, -1583, -1118, 7668, -2185, -126, 176, 8612, -651, 5746, 1086, 7341, -2505, 3289, -14543, -123, 998, 1986, 1327, 2646, -3274, 727, 942, 2757, 3394, 2560, 2031, 3515, 538, -2477, 2844, 547, 2136, 3530, 1380, 4467, 514, -839, 2355, 1658, 5323, 4199, 4335, -2408, 3764, 1920, -3319, 8073, 1121, 2300, 2235, 1208, 757, 369, 842, 2552, 2500, 2382, 1303, 6977, 1371, 1567, 1253, 1033, -520, 4917, -55, 2402, -732, 9972, 1680, -118, 290, };
const TfArray<1, int> tensor_dimension12 = { 1, { 96 } };
const TfArray<96, float> quant12_scale = { 96, { 0.00021310565352905542, 0.00011075279326178133, 0.00025447431835345924, 0.00023398497432935983, 0.00023974856594577432, 7.1354232204612345e-05, 0.00021880639542359859, 0.00024024950107559562, 0.00011820232612080872, 0.00014872821338940412, 0.00020474191114772111, 0.0001735830883262679, 0.0001612178748473525, 0.0002525931631680578, 0.00026045896811410785, 0.00019555371545720845, 0.00015304028056561947, 0.00015315551718231291, 0.00014783597725909203, 0.00021812022896483541, 0.0001624316064408049, 0.00012501170567702502, 9.8960459581576288e-05, 0.00017175672110170126, 0.00027795851929113269, 0.00023230083752423525, 0.00012434441305231303, 0.00013072472938802093, 0.00027951196534559131, 0.00024275480245705694, 9.265895641874522e-05, 0.00018874953093472868, 0.00014909716264810413, 0.00019845763745252043, 0.0001118770960601978, 0.00018322789401281625, 0.00011761592759285122, 6.9023291871417314e-05, 0.00016755724209360778, 0.00028046124498359859, 0.00020495662465691566, 0.00019041304767597467, 0.00012040481669828296, 0.00012220257485751063, 0.00031075821607373655, 0.00018563550838734955, 0.00021410862973425537, 0.00016999809304252267, 0.00019887120288331062, 0.0002252410922665149, 0.00016875439905561507, 0.00012934366532135755, 0.00011795778846135363, 0.00019720393174793571, 0.00033136754063889384, 0.00021084946638438851, 0.00015907519264146686, 0.00022293563233688474, 0.00014960725093260407, 0.00023003986279945821, 0.00019198142399545759, 0.00016261158452834934, 0.00021828331227879971, 0.00015167814854066819, 0.00015571840049233288, 0.00013554020551964641, 0.00020092408522032201, 0.00014639995060861111, 0.00024308136198669672, 0.00010633180500008166, 0.00010999901132890955, 0.00015040791186038405, 0.00019686063751578331, 0.00014732050476595759, 0.00029854840249754488, 0.00020680086163338274, 0.00030206935480237007, 0.00021857158571947366, 0.0001630319602554664, 0.00018211788847111166, 0.00018101773457601666, 0.00025476422160863876, 0.00011557697143871337, 0.00023306965886149555, 0.00013943950762040913, 0.00023329419491346925, 0.00020056201901752502, 0.00033580581657588482, 0.00015167154197115451, 0.00019113444432150573, 0.00012779605458490551, 0.00024974800180643797, 9.4384355179499835e-05, 0.00015313677431549877, 0.00046297095832414925, 0.0001945152907865122, } };
const TfArray<96, int> quant12_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant12 = { (TfLiteFloatArray*)&quant12_scale, (TfLiteIntArray*)&quant12_zero, 0 };
const ALIGN(16) int8_t tensor_data13[96*1*1*16] = { 
  /* [0][0][][] */ 44,98,-2,-9,-49,-69,-32,-68,21,-30,-26,-30,-20,-70,32,-127, 
  /* [1][0][][] */ -39,72,-91,-56,-127,32,33,19,-58,-40,-1,-1,12,115,47,39, 
  /* [2][0][][] */ -68,-55,-63,-59,40,-113,26,-2,-127,11,70,66,30,20,-4,75, 
  /* [3][0][][] */ -53,-113,-13,21,-127,51,-78,-74,-18,64,95,31,-94,11,-122,-18, 
  /* [4][0][][] */ 63,35,4,-32,-49,-4,-99,24,-26,8,42,10,-47,-3,-85,-127, 
  /* [5][0][][] */ -115,104,-118,-52,113,-57,74,-43,53,-127,-58,-37,-60,-84,-81,-34, 
  /* [6][0][][] */ -58,-64,-1,0,-97,18,49,18,-17,-74,59,-2,-46,1,-127,-14, 
  /* [7][0][][] */ -44,82,88,58,-29,127,6,-50,29,69,-35,-13,59,81,40,42, 
  /* [8][0][][] */ -32,-31,46,28,119,22,127,58,18,26,-31,-91,92,58,-123,-1, 
  /* [9][0][][] */ -2,33,103,31,-59,-11,-3,-68,92,-61,5,-38,36,-127,16,-52, 
  /* [10][0][][] */ -6,-90,-18,-84,-97,32,58,29,20,-127,-26,43,-28,9,-60,50, 
  /* [11][0][][] */ 127,-1,-25,21,-99,21,81,-55,58,39,-60,-25,52,-59,-3,86, 
  /* [12][0][][] */ -25,26,52,-72,40,2,42,22,88,24,127,58,-74,8,2,-45, 
  /* [13][0][][] */ 61,-42,-3,48,2,-21,37,41,-74,-16,48,31,-22,127,74,-14, 
  /* [14][0][][] */ 51,-95,105,-9,10,108,-34,45,19,94,127,81,25,21,77,-42, 
  /* [15][0][][] */ 20,93,-26,9,70,120,-100,96,-55,-37,19,26,-6,127,-28,-32, 
  /* [16][0][][] */ -54,49,75,18,16,48,-23,-26,-1,16,36,53,125,46,19,127, 
  /* [17][0][][] */ 76,104,76,-77,77,-38,40,-78,-127,-22,38,77,-70,10,55,-9, 
  /* [18][0][][] */ -27,37,-34,-21,41,118,-67,-84,82,127,89,30,-5,88,-35,-10, 
  /* [19][0][][] */ 10,75,126,74,17,-19,-22,-19,0,127,7,42,44,61,-70,-1, 
  /* [20][0][][] */ 63,-12,0,79,-14,-19,24,79,21,21,-127,-101,89,-95,8,16, 
  /* [21][0][][] */ -38,-127,28,60,-14,-76,-118,43,-24,16,38,36,-3,-26,-31,21, 
  /* [22][0][][] */ -23,-53,-68,-22,127,48,-9,91,-11,9,41,87,-22,86,-39,40, 
  /* [23][0][][] */ -74,41,7,-48,-2,97,127,39,-29,95,-75,-53,43,90,-56,-103, 
  /* [24][0][][] */ 21,-38,29,8,127,-9,52,-41,36,-6,68,53,-23,30,22,10, 
  /* [25][0][][] */ 95,8,117,17,-69,-49,-4,48,76,11,-53,-31,127,-1,39,95, 
  /* [26][0][][] */ 34,-6,70,43,74,-55,-23,25,-54,26,82,127,21,-42,19,12, 
  /* [27][0][][] */ -7,66,-42,69,-54,127,-12,-112,-7,-28,45,-16,34,12,107,95, 
  /* [28][0][][] */ -87,26,-22,-127,-38,-31,-24,-54,-60,20,-52,-32,-63,-24,-97,14, 
  /* [29][0][][] */ 74,70,-34,56,15,2,-28,-43,20,37,14,92,-127,-2,-13,30, 
  /* [30][0][][] */ -28,14,-32,-49,127,-85,-57,35,-87,122,-76,-29,51,22,58,95, 
  /* [31][0][][] */ -4,-109,21,50,71,14,2,74,47,80,53,-22,-122,23,37,127, 
  /* [32][0][][] */ -43,30,2,-1,-82,7,50,37,71,-127,-9,-53,-3,-7,24,27, 
  /* [33][0][][] */ -88,-15,127,98,50,101,-81,12,-20,-62,-5,-27,-74,-29,35,93, 
  /* [34][0][][] */ 60,86,-88,-51,37,85,-40,83,100,38,80,-77,-127,-82,-51,94, 
  /* [35][0][][] */ 45,-17,9,17,23,47,-65,25,31,-127,-78,-29,-76,-53,38,-46, 
  /* [36][0][][] */ -127,-64,-108,-89,118,14,-1,96,-77,72,9,54,85,110,-78,94, 
  /* [37][0][][] */ 28,59,119,5,41,-49,-5,6,-75,81,-52,-56,-30,13,127,-63, 
  /* [38][0][][] */ -14,124,-30,-33,31,80,127,-74,79,-10,-36,22,-35,-36,-109,-6, 
  /* [39][0][][] */ 17,-39,-90,-127,8,-16,-13,-8,-28,-29,31,-5,19,12,-108,-23, 
  /* [40][0][][] */ -20,12,-127,-64,-75,-1,27,-79,-9,-51,-6,-92,-23,61,-17,23, 
  /* [41][0][][] */ -37,-29,40,2,2,-9,-127,-40,-31,-102,84,-57,-90,-10,2,6, 
  /* [42][0][][] */ -4,127,-37,-90,-11,51,88,-77,104,-51,-60,-8,78,-29,22,32, 
  /* [43][0][][] */ 2,105,29,-40,103,75,100,15,41,34,-13,-127,-72,-45,-36,-32, 
  /* [44][0][][] */ 16,13,36,-16,-36,26,7,8,-32,12,6,7,127,25,-21,26, 
  /* [45][0][][] */ 75,-70,-109,17,-46,-57,11,19,51,-72,35,54,-7,127,-22,-22, 
  /* [46][0][][] */ -46,-28,40,58,35,-56,-5,-30,41,-83,29,16,73,86,48,127, 
  /* [47][0][][] */ -79,-111,1,127,-11,-19,35,83,-20,-18,-77,-10,-48,-2,-89,97, 
  /* [48][0][][] */ -66,49,57,11,-18,86,-76,-127,30,71,15,-71,55,-111,-61,-52, 
  /* [49][0][][] */ -6,67,74,-72,-75,-45,127,67,4,-65,-56,-16,7,-3,-22,2, 
  /* [50][0][][] */ 16,-8,-72,-18,1,-127,-109,-11,-122,12,-7,51,17,-7,-106,8, 
  /* [51][0][][] */ -46,90,-119,126,5,115,-6,-53,-17,-127,38,-41,121,77,-24,80, 
  /* [52][0][][] */ -114,43,4,-23,102,127,127,100,60,-69,-99,-121,-105,-109,-125,-45, 
  /* [53][0][][] */ -92,-94,19,-93,0,-38,5,1,86,-22,-77,25,58,-14,99,127, 
  /* [54][0][][] */ 20,-14,36,15,-27,98,11,70,2,-59,11,-48,-54,-47,-127,-48, 
  /* [55][0][][] */ -32,18,-66,-38,32,13,66,123,-82,-87,-127,-45,98,-15,12,52, 
  /* [56][0][][] */ 75,-5,-41,-31,-52,48,-68,-32,-114,-41,-9,31,127,26,-17,-49, 
  /* [57][0][][] */ -80,-20,-20,-28,93,-34,97,36,10,30,6,4,6,68,-127,72, 
  /* [58][0][][] */ 47,39,-14,-40,-1,29,-30,-49,60,-100,-97,-21,-127,-55,3,8, 
  /* [59][0][][] */ -24,0,-52,62,-6,77,-96,-86,98,127,-47,27,6,3,-31,-39, 
  /* [60][0][][] */ -9,-89,83,110,-75,-105,85,63,69,127,-66,10,63,-26,24,46, 
  /* [61][0][][] */ 5,61,-48,-31,-43,-6,-50,-127,-16,-26,70,68,98,-14,55,60, 
  /* [62][0][][] */ 114,4,105,-68,31,33,26,91,-115,10,-15,85,127,32,95,-34, 
  /* [63][0][][] */ 19,-127,-17,-18,-46,-7,39,4,-26,-42,1,0,-66,87,91,27, 
  /* [64][0][][] */ -18,36,-45,-46,0,25,4,-63,-26,-127,9,-23,48,-15,-60,45, 
  /* [65][0][][] */ -38,32,86,98,127,27,78,83,42,56,-37,-81,-19,37,-85,46, 
  /* [66][0][][] */ -17,-59,-41,-100,-12,-127,49,-26,16,-46,7,17,-42,-42,-35,28, 
  /* [67][0][][] */ 43,-11,-16,3,-112,126,-93,-127,-86,5,-65,-115,-3,-24,27,-36, 
  /* [68][0][][] */ 48,21,12,-23,-18,-20,-39,34,-78,-127,-7,2,-21,1,-28,-35, 
  /* [69][0][][] */ 74,-45,91,41,-65,-62,-95,23,-48,127,-52,-30,12,30,-21,-14, 
  /* [70][0][][] */ 3,-12,-31,127,-71,6,-34,-35,91,120,32,5,45,-50,-23,68, 
  /* [71][0][][] */ 48,-65,127,102,-36,-30,2,8,107,85,-103,-63,49,-81,13,-8, 
  /* [72][0][][] */ -19,-42,-35,36,37,21,-127,114,35,-12,65,15,-71,-37,-72,74, 
  /* [73][0][][] */ 61,-27,79,-79,-18,-45,-42,-10,0,58,-127,12,-24,-124,55,-92, 
  /* [74][0][][] */ 58,-54,18,26,-127,-21,54,-68,-51,-68,-21,-18,60,-35,-23,-20, 
  /* [75][0][][] */ 73,127,-61,-1,28,60,21,-6,60,18,74,29,-15,-10,15,-9, 
  /* [76][0][][] */ -43,-33,5,-45,-59,13,36,-3,-97,27,125,66,-31,-78,57,127, 
  /* [77][0][][] */ 15,127,-85,24,-40,-75,17,39,85,-45,-57,42,-43,49,15,-20, 
  /* [78][0][][] */ 127,87,-17,-2,-95,57,-84,-7,-32,-30,-53,-7,-20,-77,67,50, 
  /* [79][0][][] */ -41,-80,119,106,55,-47,-52,-50,13,81,33,56,-11,70,30,127, 
  /* [80][0][][] */ 52,127,-19,-3,-39,81,42,-49,41,56,-13,11,-33,18,3,9, 
  /* [81][0][][] */ 12,-57,9,-109,23,14,17,127,31,42,-65,-14,-38,37,-25,-30, 
  /* [82][0][][] */ 43,31,83,54,127,-56,11,40,29,92,-33,5,-11,-23,31,-39, 
  /* [83][0][][] */ -57,-7,-32,-37,39,33,127,99,-26,-6,-40,-30,-120,93,-40,-14, 
  /* [84][0][][] */ -56,-22,16,87,-10,-55,-78,24,-98,127,-16,46,-36,80,111,-10, 
  /* [85][0][][] */ -29,56,35,55,-29,25,-25,30,21,40,32,-80,-127,-69,-8,-4, 
  /* [86][0][][] */ -40,-7,63,64,82,-48,40,50,-4,28,-41,-20,30,69,-127,-25, 
  /* [87][0][][] */ -33,30,127,-7,-104,-39,-4,50,-20,-66,33,87,-60,13,-25,53, 
  /* [88][0][][] */ -17,-23,-30,43,-20,28,-31,8,10,-52,-81,-127,25,-55,7,-26, 
  /* [89][0][][] */ 31,40,40,-99,-32,-42,-36,14,127,-13,-3,-116,51,-47,19,-107, 
  /* [90][0][][] */ -16,75,-15,35,-46,27,72,127,94,-33,27,122,85,-22,19,71, 
  /* [91][0][][] */ -44,53,-10,27,32,72,5,-77,-10,-25,27,16,-106,-127,-98,-79, 
  /* [92][0][][] */ -22,58,-37,33,-75,32,-55,19,-55,27,127,61,34,24,-15,-5, 
  /* [93][0][][] */ 32,22,101,56,-61,-121,56,52,97,-28,-98,-93,-1,-127,-56,70, 
  /* [94][0][][] */ -68,-127,-17,-98,24,-27,-20,37,29,-31,39,68,11,51,-23,35, 
  /* [95][0][][] */ -35,-37,-55,-71,100,83,20,-25,86,16,-18,67,41,127,-41,19, 
};
const TfArray<4, int> tensor_dimension13 = { 4, { 96,1,1,16 } };
const TfArray<96, float> quant13_scale = { 96, { 0.0024014550726860762, 0.0012480563018471003, 0.0028676323127001524, 0.0026367409154772758, 0.0027016899548470974, 0.0008040799293667078, 0.0024656958412379026, 0.0027073349338024855, 0.0013320039724931121, 0.0016759955324232578, 0.0023072052281349897, 0.0019560812506824732, 0.0018167395610362291, 0.0028464337810873985, 0.0029350724071264267, 0.0022036649752408266, 0.0017245875205844641, 0.0017258861334994435, 0.0016659410903230309, 0.0024579635355621576, 0.0018304169643670321, 0.0014087377348914742, 0.0011151703074574471, 0.0019355001859366894, 0.00313227204605937, 0.0026177626568824053, 0.001401218120008707, 0.0014731169212609529, 0.0031497776508331299, 0.0027355668134987354, 0.0010441596386954188, 0.0021269896533340216, 0.001680153189226985, 0.0022363888565450907, 0.0012607258977368474, 0.0020647670608013868, 0.0013253958895802498, 0.00077781290747225285, 0.0018881768919527531, 0.0031604750547558069, 0.0023096248041838408, 0.0021457355469465256, 0.0013568234862759709, 0.0013770820805802941, 0.003501886734738946, 0.0020918981172144413, 0.002412757370620966, 0.0019156824564561248, 0.0022410491947084665, 0.0025382074527442455, 0.0019016675651073456, 0.001457554055377841, 0.0013292483054101467, 0.0022222609259188175, 0.0037341301795095205, 0.0023760304320603609, 0.0017925940919667482, 0.0025122275110334158, 0.0016859013121575117, 0.0025922839995473623, 0.0021634092554450035, 0.0018324451521039009, 0.0024598012678325176, 0.0017092378111556172, 0.0017547669121995568, 0.0015273818280547857, 0.0022641827818006277, 0.001649758662097156, 0.0027392467018216848, 0.0011982368305325508, 0.001239562057889998, 0.0016949237324297428, 0.0022183924447745085, 0.0016601323150098324, 0.0033642961643636227, 0.0023304072674363852, 0.0034039735328406096, 0.0024630497209727764, 0.0018371822079643607, 0.00205225870013237, 0.0020398611668497324, 0.0028708989266306162, 0.0013024192303419113, 0.0026264262851327658, 0.0015713225584477186, 0.002628956688567996, 0.0022601026576012373, 0.0037841442972421646, 0.0017091634217649698, 0.0021538648288697004, 0.0014401142252609134, 0.0028143720701336861, 0.0010636028600856662, 0.0017256749561056495, 0.0052171489223837852, 0.0021919631399214268, } };
const TfArray<96, int> quant13_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant13 = { (TfLiteFloatArray*)&quant13_scale, (TfLiteIntArray*)&quant13_zero, 0 };
const ALIGN(16) int32_t tensor_data14[16] = { -32981, -14741, 10755, -21459, 16646, -23898, 14224, 471, -3743, -13044, 11424, 8257, -5933, -27684, -5317, 13786, };
const TfArray<1, int> tensor_dimension14 = { 1, { 16 } };
const TfArray<16, float> quant14_scale = { 16, { 6.0974409279879183e-05, 6.4023261074908078e-05, 4.1256567783420905e-05, 7.1661030233372003e-05, 5.0174850912299007e-05, 0.00012589863035827875, 3.1093393772607669e-05, 2.534433951950632e-05, 9.1418303782120347e-05, 0.00011054107744712383, 5.8985908253816888e-05, 6.2415318097919226e-05, 9.3140195531304926e-05, 4.6226614358602092e-05, 6.2089944549370557e-05, 6.4384090364910662e-05, } };
const TfArray<16, int> quant14_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant14 = { (TfLiteFloatArray*)&quant14_scale, (TfLiteIntArray*)&quant14_zero, 0 };
const ALIGN(16) int8_t tensor_data15[16*1*1*96] = { 
  /* [0][0][][] */ 33,15,20,27,-18,-82,-24,34,10,-79,-6,0,70,-53,38,12,-57,-57,68,-18,94,40,-54,9,-17,74,112,69,-26,41,46,-23,44,-12,14,-8,24,1,-39,10,122,15,20,27,4,-32,14,-44,11,-34,84,29,-13,49,106,32,1,-26,-26,29,34,47,-25,-26,38,9,88,-7,-1,-63,23,4,-1,15,-22,51,37,19,92,5,-5,14,0,34,-71,-20,-32,38,13,40,-103,10,48,-15,127,66, 
  /* [1][0][][] */ 1,28,-33,-21,-31,-51,51,-23,-6,-15,-71,-31,-10,-16,-16,-30,3,-11,1,-21,18,-49,71,-47,-2,4,-11,44,-49,10,-7,37,-33,42,46,9,5,34,-37,50,51,6,15,-23,54,-10,13,32,-11,-33,38,-46,1,38,47,67,29,2,-48,1,-2,-26,15,-28,38,41,112,-25,-13,-68,-7,-23,13,43,11,41,-67,-23,127,-14,65,-14,36,-51,13,-60,-27,30,-19,-25,6,19,52,-71,8,58, 
  /* [2][0][][] */ 46,-48,17,-11,14,50,-60,-21,-65,37,-47,-54,74,-27,22,55,10,-35,-127,-36,-33,-2,-38,50,21,-34,-14,15,-78,4,-17,65,-16,-46,-24,-29,-39,-7,22,-12,22,-10,18,7,8,23,12,-27,-93,5,-30,28,15,48,3,-87,-27,-12,29,81,-16,-18,-4,75,23,-8,-38,13,-7,5,-29,22,37,27,-17,26,-46,23,-62,-34,-8,5,27,-68,-45,-48,4,-64,-38,-8,16,65,1,-18,78,-58, 
  /* [3][0][][] */ 54,-43,16,-38,-21,-35,76,22,46,82,-52,-22,34,3,-26,50,45,51,4,14,-30,16,23,3,-9,66,24,0,-7,-9,-53,49,17,4,89,-26,-11,-74,-49,62,39,0,10,47,73,-73,27,-8,53,-40,54,-61,78,67,53,-16,-26,-3,-29,-43,-9,4,37,-3,7,-2,116,-12,-22,-32,-38,-3,41,-57,-1,-44,16,-11,127,13,-14,-54,-26,-57,-18,-29,43,43,-38,10,-46,15,53,-67,-3,32, 
  /* [4][0][][] */ -10,25,38,7,-37,8,-85,3,77,-77,-63,4,32,9,-4,63,20,-20,4,-53,12,-57,-81,-32,-1,-9,15,-14,-47,127,-45,-1,-36,-65,33,30,24,9,-49,16,69,7,85,-15,-62,10,121,-27,7,-53,-39,3,-88,80,1,13,-30,65,-63,28,-42,-109,8,55,89,63,-57,-63,14,51,4,-98,45,20,76,58,-108,-22,-62,60,-1,8,15,-113,48,-107,-27,-103,-13,-38,-70,-58,-6,27,64,-54, 
  /* [5][0][][] */ -17,-2,20,-6,-8,-13,-5,45,57,2,-9,-25,-31,-14,38,-33,-27,28,-26,-39,-26,37,-7,13,17,-31,40,-23,-40,59,20,69,6,-59,28,10,-11,-23,-17,-7,-11,17,-2,1,17,31,-37,-5,-4,7,50,7,45,-58,0,38,-37,-49,1,-24,51,11,18,52,-24,11,118,-27,-18,-9,-10,-9,22,39,55,6,-24,-18,127,50,4,-3,-42,14,60,40,-13,101,17,-27,-23,1,15,1,-12,48, 
  /* [6][0][][] */ 19,-59,40,28,-11,77,-14,-6,34,-127,-73,29,27,-23,26,92,14,22,1,-79,-89,-23,-110,-79,-46,10,-43,23,-100,91,-17,-69,-9,89,34,3,-1,-103,9,21,8,75,95,-14,-5,35,-57,18,37,-68,-31,-104,79,46,-96,-18,-57,-9,-41,-80,-45,-45,78,33,100,-63,-41,-37,-100,13,-17,-99,-15,-97,44,-124,2,-2,-23,45,-69,47,11,-75,96,-49,-9,15,-90,55,-106,82,20,13,92,-45, 
  /* [7][0][][] */ 7,-22,-50,94,-38,-28,25,23,-91,-46,38,39,31,-84,13,9,-37,-17,8,-50,-48,-14,-57,-1,64,38,-33,28,-48,58,21,-11,-45,-127,-36,105,12,-28,-26,23,-20,49,18,-87,-19,58,69,44,-44,28,-51,19,37,-9,29,-123,-65,-3,-103,-26,51,45,39,-27,53,-54,127,-29,-53,-1,20,-14,-4,-3,-78,-77,49,12,50,-33,-27,-31,-87,-56,16,2,-3,80,-82,-9,23,-19,36,34,56,-36, 
  /* [8][0][][] */ -11,-28,35,10,-17,10,23,41,27,0,13,3,3,38,-16,-13,59,39,19,13,-36,-59,9,-39,13,1,55,-18,-16,51,31,16,8,19,48,-4,-25,-24,10,-11,31,58,37,4,29,11,42,-14,12,-35,58,25,27,28,-46,22,-48,66,-37,-6,12,-87,-21,14,-51,4,16,-16,20,38,47,-47,-2,-127,46,-101,-14,-11,-14,23,-19,-6,-14,21,65,-46,-37,63,-9,71,-1,-17,-34,15,6,-19, 
  /* [9][0][][] */ 27,-42,-17,2,7,37,-18,102,-12,10,26,50,-11,49,9,-37,-14,31,5,-9,-1,30,11,5,-1,11,12,-2,41,-23,32,-4,-2,-5,35,47,-19,-17,1,9,12,-25,25,24,6,13,23,10,-36,-19,8,14,127,56,-11,-10,-4,-9,10,20,10,-20,96,22,25,37,65,-8,18,-16,-23,18,50,-122,-32,-115,-38,30,45,-1,-36,4,25,-49,14,11,0,-11,-6,94,54,19,49,-1,-12,14, 
  /* [10][0][][] */ 29,62,47,3,-26,3,-56,-40,88,22,-69,29,42,20,-26,-46,-61,-7,15,30,16,-28,-23,-16,28,-47,-86,11,-32,74,-7,-10,19,22,17,58,-3,21,-29,-1,55,-42,87,-66,-55,-33,34,54,-12,21,19,-17,-16,1,22,38,-12,17,-12,-13,-26,-14,3,56,20,10,-114,-18,-16,-35,26,6,-1,34,54,2,66,-34,-127,22,-14,46,11,2,-2,8,-66,-107,-43,46,21,18,73,-30,11,40, 
  /* [11][0][][] */ -12,-5,10,44,0,18,42,-6,74,-41,4,-16,15,18,13,-48,-33,37,5,-35,41,42,-25,9,-22,19,49,21,65,-37,-9,28,-6,86,-62,50,-3,3,33,-5,-31,26,7,-4,-33,-9,-10,11,-1,-4,-1,-5,3,15,-41,45,22,50,-33,-75,-10,43,29,-64,-2,2,-127,-35,6,-48,-113,58,55,52,1,11,22,50,-108,-54,-6,-10,3,20,0,17,18,54,-7,-12,-2,15,-1,51,84,10, 
  /* [12][0][][] */ 6,22,-60,8,20,-22,43,76,42,-45,25,-6,-4,2,41,-10,3,-48,8,-14,33,51,-11,71,-82,-13,-127,25,35,4,32,13,-21,-20,40,2,51,-21,20,13,-14,-21,18,10,23,8,17,-17,-57,-21,-43,70,54,27,-1,-37,-13,7,-55,-37,-5,30,59,-7,-27,11,27,26,68,38,4,5,33,9,5,-9,-69,0,59,-68,24,-49,5,-4,35,4,19,-59,-39,16,-40,1,-33,70,55,79, 
  /* [13][0][][] */ -20,23,-127,46,60,18,52,41,29,37,-18,41,-70,-26,120,-10,7,69,64,-27,-3,-34,-19,53,-2,54,-42,50,0,69,34,0,-56,114,-14,62,54,-26,-19,-73,-23,27,35,-9,74,52,-31,37,-16,-8,-11,-7,29,-37,26,6,-30,-71,-56,-40,28,-5,54,-65,-25,52,110,5,52,41,-99,-54,115,64,-18,33,-18,-53,120,-21,12,-31,25,-32,100,58,22,-9,-68,-37,38,55,36,41,76,99, 
  /* [14][0][][] */ 10,25,26,49,-71,-53,15,68,-71,-37,30,-14,-49,-9,36,-3,-53,48,-17,-47,-7,67,-92,45,-53,5,-43,-74,-19,-2,30,61,-22,36,42,-30,-15,-97,-32,-25,28,-50,39,-6,-19,12,-59,15,-22,-60,83,65,-4,76,31,37,-72,21,-29,82,75,81,36,31,24,-14,28,-49,40,54,38,35,-54,31,-7,26,-1,67,51,16,-52,75,-37,-127,45,-43,11,8,-110,-9,-28,2,1,-1,67,41, 
  /* [15][0][][] */ 41,-12,14,46,-12,-30,-5,-54,-4,-13,-33,-16,45,25,25,-30,-22,6,-90,51,-20,-22,-3,49,9,-10,94,5,16,-38,-51,26,15,3,2,-64,29,29,36,40,55,12,-40,6,-60,-70,36,1,-57,-1,10,-8,-46,-70,-48,33,-33,5,-20,23,-26,-8,-42,67,39,25,-91,47,2,5,25,33,-13,-83,-51,-85,-19,2,-127,18,35,-32,47,37,-51,21,-29,-50,28,78,-5,-72,-33,7,36,-50, 
};
const TfArray<4, int> tensor_dimension15 = { 4, { 16,1,1,96 } };
const TfArray<16, float> quant15_scale = { 16, { 0.0025914122816175222, 0.0027209885884076357, 0.0017534041544422507, 0.0030455938540399075, 0.0021324311383068562, 0.005350691732019186, 0.0013214692007750273, 0.0010771343950182199, 0.0038852777797728777, 0.0046979957260191441, 0.0025069010443985462, 0.0026526509318500757, 0.0039584580808877945, 0.0019646310247480869, 0.0026388226542621851, 0.0027363237459212542, } };
const TfArray<16, int> quant15_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant15 = { (TfLiteFloatArray*)&quant15_scale, (TfLiteIntArray*)&quant15_zero, 0 };
const ALIGN(16) int32_t tensor_data16[96] = { 16166, -225, -3434, 17015, 3676, 1142, -488, -1951, -2132, -8750, 6956, -8363, 11032, -6091, -1156, -7658, -2270, 115, -9613, 4601, 2785, 4149, -4034, 629, 364, 3177, -10222, -10216, 2323, -1465, -3762, -2846, 5441, -756, -1014, 4098, -7325, 6140, 4739, 8179, 7095, 1940, 4506, -2373, -2522, -2462, 19226, 6468, 66, 1806, -936, 582, -3806, -1392, -1347, 446, -6073, -4522, -4727, -1358, 4431, -3425, -41, 9635, 7340, -462, 8635, 4286, 5678, -11067, 11754, 1098, -359, 1395, -2216, 546, 8008, 11201, 4912, 25204, 9767, -3230, 6013, 11394, 202, -4391, 11855, -5407, 6389, 2094, -5604, -6795, 1854, 6440, 24920, 1764, };
const TfArray<1, int> tensor_dimension16 = { 1, { 96 } };
const TfArray<96, float> quant16_scale = { 96, { 3.425181785132736e-05, 0.00031089736148715019, 0.00011017328506568447, 4.9806276365416124e-05, 0.00021799307432956994, 0.0006070732488296926, 0.00013659869728144258, 0.00021640733757521957, 0.00031893679988570511, 9.6478914201725274e-05, 0.00019461041665636003, 0.0001783903717296198, 6.612674769712612e-05, 7.0250687713269144e-05, 0.00025198329240083694, 0.00016837853763718158, 0.00021541659953072667, 0.00037530608824454248, 0.0001216385790030472, 0.00028339575510472059, 0.00018453996744938195, 0.00016948439588304609, 0.00010819606541190296, 0.00024402409326285124, 0.00084270635852590203, 0.0002264276408823207, 0.00019982137018814683, 8.1211954238824546e-05, 0.00040078422171063721, 0.00013982118980493397, 0.00023267156211659312, 0.00030561874154955149, 0.00011332068970659748, 0.00027809856692329049, 0.00017490831669420004, 0.00012823315046261996, 0.00019605284614954144, 0.00019143836107105017, 0.00012646763934753835, 8.6219151853583753e-05, 0.00039080754504539073, 0.00026368987164460123, 0.00017592882795725018, 0.0001143342669820413, 0.00021516990091186017, 0.00019393068214412779, 8.0491299740970135e-05, 0.00016712609794922173, 0.00017951866902876645, 0.00017647203640080988, 0.00024006022431422025, 0.00020735753059852868, 0.00014580186689272523, 0.00052310299361124635, 0.00031170315924100578, 0.00031453295378014445, 0.00011486436414998025, 0.0004281340807210654, 0.00015663955127820373, 0.00043742658453993499, 0.00016284134471789002, 0.00015099499432835728, 0.00018941849702969193, 0.0001387591619277373, 0.00029178796103224158, 0.00025982764782384038, 0.00019893914577551186, 0.00013000697072129697, 0.00018136305152438581, 0.00013883157225791365, 5.9673839132301509e-05, 0.00024900468997657299, 0.00072170631028711796, 0.00021215679589658976, 0.00017109955660998821, 0.00028197022038511932, 6.4853455114644021e-05, 0.00010130069131264463, 0.0002657740842550993, 0.00012418473488651216, 0.00010850169201148674, 0.00013642893463838845, 6.7815773945767432e-05, 0.00023888067516963929, 0.00010487448162166402, 0.0002204191405326128, 7.1401205786969513e-05, 0.0001666081661824137, 0.0002223872288595885, 0.0001717194973025471, 0.0001303651079069823, 0.00024131628742907196, 0.00022664786956738681, 0.00012771252659149468, 7.9949146311264485e-05, 0.00025332660879939795, } };
const TfArray<96, int> quant16_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant16 = { (TfLiteFloatArray*)&quant16_scale, (TfLiteIntArray*)&quant16_zero, 0 };
const ALIGN(16) int8_t tensor_data17[1*3*3*96] = { 
  /* [0][0][][] */ -63,-33,-30,-81,62,1,78,-64,21,75,-36,28,-108,27,-9,-46,-6,-27,-37,-59,-44,36,75,-27,-14,27,-1,62,-21,-64,40,-7,-30,0,23,-53,17,-49,-86,-24,-62,15,28,17,-15,69,-93,-54,-83,-18,-36,21,-51,-44,24,-3,28,29,63,-17,-27,-32,-26,6,-43,-15,-55,-28,-49,72,-78,-11,96,21,-2,-13,-35,-6,127,-30,-47,29,-46,-38,-60,5,71,40,-24,-12,82,-20,19,-19,-127,-1, -99,42,21,-127,-43,-3,102,-24,3,83,-64,24,-10,92,-120,32,8,80,48,-76,-73,127,127,127,31,10,20,39,127,79,127,11,-127,-9,-51,-55,8,-5,107,-127,-80,-25,-10,9,94,-21,-77,-36,26,-1,-26,127,-83,-23,-94,-3,-17,31,53,14,-61,-127,-106,1,-66,-36,-12,-52,-38,66,-39,127,-116,-11,33,-22,31,-127,-20,-8,-42,-1,27,-61,127,101,-104,53,-45,-45,64,-2,4,61,-99,-110, -86,-16,-32,-6,41,-2,66,-12,-8,127,-37,28,-59,31,-24,35,5,-45,56,-28,-127,33,56,-1,-5,-17,13,10,-31,-68,39,0,10,9,6,56,25,-43,-99,-25,-38,86,-64,26,8,-27,-83,-33,-20,-7,-32,64,17,-15,8,-17,80,-2,43,2,-41,-21,-71,-38,-76,-3,127,-50,-38,33,-1,-18,36,-39,-15,4,37,-14,-55,-29,-13,13,-65,3,6,-15,-65,-40,-24,-108,61,76,38,-3,-78,-10, 
  /* [0][1][][] */ -89,16,112,-97,-3,89,-49,4,20,92,-54,17,-127,127,2,83,-9,63,11,-3,59,-65,79,-21,45,36,110,-15,-24,62,-21,-16,-107,-8,60,-73,22,-6,-83,-14,-36,18,68,-24,-53,127,-103,-89,-27,65,49,-59,-69,13,86,-25,5,-42,91,-7,39,40,30,36,2,45,-33,-48,-35,22,-127,-13,127,127,30,-66,-95,-49,-62,7,-93,21,-53,-74,22,44,-88,-2,-22,127,33,-50,127,-24,-14,-34, -9,127,120,54,-127,-127,95,-103,127,90,-115,-12,-91,120,-25,83,127,-127,127,127,125,-93,19,-66,-127,-127,127,127,-106,127,2,127,-23,127,80,-127,127,52,45,2,127,26,-127,-27,127,-6,54,127,127,-127,127,-112,127,127,-127,127,-39,127,-127,127,-127,114,46,-8,127,127,-12,127,-127,-127,-73,-125,-62,44,127,44,83,-90,74,-125,13,127,33,127,59,84,-97,61,54,58,-97,-6,-87,-77,-114,-46, -127,-65,108,-123,-34,38,-127,39,-17,73,-34,127,-81,43,30,14,-14,22,35,21,-57,-35,-3,-40,28,16,47,34,-42,-46,-3,-3,38,-10,62,61,30,-33,-127,-25,-31,-2,-34,25,-66,-100,-127,-121,79,6,-8,-50,110,32,116,-14,127,31,90,-31,-42,-25,-63,-31,-78,-15,-47,-47,-43,105,-99,-28,114,-100,-3,127,29,-48,-66,-116,-71,-15,-39,-83,13,58,-127,127,0,-64,127,127,-71,-50,-52,-23, 
  /* [0][2][][] */ -43,-26,-24,-64,67,3,15,46,-2,86,16,-21,-1,-15,-6,74,12,40,-15,-45,-24,-51,45,-24,-14,25,51,21,5,-72,-24,10,-22,10,-26,-77,21,-73,-4,-46,-15,-7,3,62,42,86,-82,-44,-114,19,-43,-34,14,-21,44,-20,-18,-14,6,-7,-26,82,55,-52,18,-19,113,92,6,87,-27,-28,19,29,-38,-59,127,-16,-74,-96,-127,15,-127,-10,-22,12,-50,-103,-127,25,-60,19,-73,-19,69,-13, -52,-68,-42,-104,-49,-7,27,127,-38,85,127,35,-30,-84,127,127,5,-60,83,-22,-33,-101,-1,-2,3,30,49,25,-8,-45,-49,8,22,-12,-127,-25,-45,18,79,-92,-20,-127,-95,127,35,-29,-47,-10,-12,-52,-28,20,89,64,-43,-13,-13,-54,48,5,87,84,127,-127,-39,-58,-13,-75,97,90,-60,0,25,-10,-8,-46,121,-45,0,-48,-31,18,-107,-84,93,-127,-76,-22,-79,14,78,3,-46,-127,-37,127, 19,-13,-127,-17,-25,-15,-52,80,22,47,6,17,0,-55,-7,7,3,68,11,-59,-75,-60,71,-41,7,-2,-29,18,2,-23,-10,7,56,14,-46,3,14,-127,3,0,-44,-63,-22,44,-26,-44,-126,-46,-89,-31,-28,46,44,-19,16,-30,85,9,61,33,-23,76,32,-43,3,-32,-52,64,11,114,-117,-23,-11,-33,-16,35,93,1,118,-127,-34,-18,-78,-77,-39,19,55,84,19,19,-38,48,-23,-23,-39,-15, 
};
const TfArray<4, int> tensor_dimension17 = { 4, { 1,3,3,96 } };
const TfArray<96, float> quant17_scale = { 96, { 0.0014557022368535399, 0.013213137164711952, 0.0046823644079267979, 0.0021167667582631111, 0.009264705702662468, 0.025800613686442375, 0.0058054444380104542, 0.0091973114758729935, 0.013554814271628857, 0.0041003539226949215, 0.0082709426060318947, 0.0075815906748175621, 0.0028103867080062628, 0.0029856541659682989, 0.010709289461374283, 0.007156087551265955, 0.0091552054509520531, 0.015950508415699005, 0.0051696393638849258, 0.012044318951666355, 0.0078429486602544785, 0.0072030867449939251, 0.0045983325690031052, 0.010371023789048195, 0.035815019160509109, 0.0096231745555996895, 0.0084924083203077316, 0.0034515080042183399, 0.017033329233527184, 0.0059424005448818207, 0.0098885409533977509, 0.012988796457648277, 0.0048161293379962444, 0.011819188483059406, 0.0074336030520498753, 0.0054499087855219841, 0.0083322459831833839, 0.0081361299380660057, 0.0053748744539916515, 0.0036643138155341148, 0.016609320417046547, 0.011206818744540215, 0.0074769747443497181, 0.0048592062667012215, 0.009144720621407032, 0.0082420539110898972, 0.003420880064368248, 0.0071028587408363819, 0.0076295430772006512, 0.0075000612996518612, 0.010202559642493725, 0.0088126948103308678, 0.0061965794302523136, 0.022231876850128174, 0.013247383758425713, 0.013367650099098682, 0.0048817354254424572, 0.018195698037743568, 0.006657180842012167, 0.018590629100799561, 0.0069207567721605301, 0.0064172870479524136, 0.0080502862110733986, 0.0058972644619643688, 0.012400987558066845, 0.011042675003409386, 0.0084549132734537125, 0.0055252960883080959, 0.0077079297043383121, 0.0059003415517508984, 0.0025361380539834499, 0.010582699440419674, 0.030672518536448479, 0.0090166637673974037, 0.0072717312723398209, 0.011983734555542469, 0.0027562717441469431, 0.0043052793480455875, 0.011295397765934467, 0.0052778511308133602, 0.0046113217249512672, 0.0057982294820249081, 0.0028821704909205437, 0.010152428410947323, 0.0044571654871106148, 0.0093678133562207222, 0.0030345511622726917, 0.0070808469317853451, 0.0094514572992920876, 0.0072980783879756927, 0.0055405166931450367, 0.010255942121148109, 0.009632534347474575, 0.0054277824237942696, 0.0033978386782109737, 0.010766380466520786, } };
const TfArray<96, int> quant17_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant17 = { (TfLiteFloatArray*)&quant17_scale, (TfLiteIntArray*)&quant17_zero, 3 };
const ALIGN(16) int32_t tensor_data18[96] = { 468, 9284, -97, 3002, 4613, 11042, 777, 1984, 6651, -2093, 21982, 3237, 1607, 1372, 10677, 917, 1816, 3855, -149, 7688, 713, 6421, -1502, 693, -2282, 1432, 1367, 2986, 3421, 1025, 7888, 2659, 754, 6227, 1315, 7162, 6420, 3232, 2376, 2328, 51707, 2831, 1592, 2624, 3635, 14389, 3933, 13486, 1691, -137, 1159, 10780, 2118, -3289, 4686, 374, 404, 66565, 2066, 1312, 3069, 5125, 5836, 346, 27897, 6563, 3001, 3279, 10366, 2788, 454, 2321, -6855, 2881, 1757, 3872, 36, 9801, 8580, 11361, 4913, 587, 4494, 12822, -402, 5913, 2909, 2779, 16, 4178, 722, 19213, 2115, 6827, 3024, 3830, };
const TfArray<1, int> tensor_dimension18 = { 1, { 96 } };
const TfArray<96, float> quant18_scale = { 96, { 0.00025946350069716573, 0.00010498473420739174, 0.00030588326626457274, 0.00014135499077383429, 0.00015848276962060481, 7.4418705480638891e-05, 0.00013364960614126176, 0.00017764873337000608, 0.0001268860069103539, 0.00017031664901878685, 4.553331746137701e-05, 0.00021401896083261818, 0.00017107854364439845, 0.00021893595112487674, 7.1565962571185082e-05, 0.00014285869838204235, 0.00019396349671296775, 0.0001596330403117463, 0.00045821646926924586, 0.0001124286136473529, 0.00021238834597170353, 0.00011923375859623775, 0.00016791537927929312, 0.00026636352413333952, 0.00025096937315538526, 0.00012735580094158649, 0.00018388591706752777, 0.00020411537843756378, 0.00021921406732872128, 0.00025289025506936014, 0.00010833863780135289, 0.00022500180057249963, 0.00030620396137237549, 0.00010855712025659159, 0.00022955967870075256, 0.00011461749818408862, 0.0001161772379418835, 0.00015312813047785312, 0.00014360135537572205, 0.00019462376076262444, 2.2452313714893535e-05, 0.0001195835939142853, 0.00022602951503358781, 0.0001499253703514114, 0.00015333481132984161, 6.9696296122856438e-05, 0.0001697553088888526, 7.2820941568352282e-05, 0.0001966926793102175, 0.00025180960074067116, 0.00025739319971762598, 8.3465638454072177e-05, 0.00022690501646138728, 0.00017823107191361487, 0.0001363839692203328, 0.00027263385709375143, 0.00031799590215086937, 1.8799291865434498e-05, 0.00011938939860556275, 0.00023404670355375856, 0.00014226399071048945, 0.00014084418944548815, 0.00010665172158041969, 0.00023859836801420897, 3.6005003494210541e-05, 0.00013861217303201556, 0.00016640355170238763, 0.0001662146532908082, 9.5994735602289438e-05, 0.00014914758503437042, 0.00031863973708823323, 0.00013792105892207474, 0.00012082229659426957, 0.00019187887664884329, 0.00014208475477062166, 0.00013401191972661763, 0.00028898517484776676, 8.8358901848550886e-05, 0.00010389052476966754, 9.235605102730915e-05, 0.00011314151925034821, 0.00015941138553898782, 0.00011514197831274942, 6.5647975134197623e-05, 0.0001344260381301865, 0.00010983568063238636, 0.0001870727282948792, 0.00011193840327905491, 0.00021527359785977751, 0.00014952484343666583, 0.00019184309348929673, 4.956284465151839e-05, 0.00020087376469746232, 0.00010121310333488509, 0.00017094917711801827, 0.00018736721540335566, } };
const TfArray<96, int> quant18_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant18 = { (TfLiteFloatArray*)&quant18_scale, (TfLiteIntArray*)&quant18_zero, 0 };
const ALIGN(16) int8_t tensor_data19[96*1*1*16] = { 
  /* [0][0][][] */ 60,13,33,33,-87,-14,127,-9,93,83,14,32,37,-26,1,14, 
  /* [1][0][][] */ 7,73,-30,82,127,104,-34,-34,35,0,-77,-37,-98,27,-81,12, 
  /* [2][0][][] */ -13,48,55,41,29,97,-5,34,56,-42,49,-18,16,-127,-4,-15, 
  /* [3][0][][] */ 127,-17,-22,18,39,79,-66,24,-11,106,-46,0,-34,25,-7,43, 
  /* [4][0][][] */ -16,-1,12,25,-21,-21,-83,28,-11,79,5,28,30,58,-61,127, 
  /* [5][0][][] */ -79,6,112,95,127,-10,68,-3,-50,39,-86,-23,-4,46,-87,-63, 
  /* [6][0][][] */ -115,38,-56,-2,-40,-12,127,22,67,-78,-86,36,-61,-7,-76,-43, 
  /* [7][0][][] */ -36,127,56,-29,69,83,82,-39,-59,58,-4,97,90,110,20,-35, 
  /* [8][0][][] */ 0,-38,-29,22,-26,77,-30,-50,15,7,36,24,127,15,-94,-42, 
  /* [9][0][][] */ -10,-127,-18,79,-12,-38,-13,71,3,6,-8,46,-64,7,39,13, 
  /* [10][0][][] */ 33,0,-127,44,-97,119,83,-94,64,-21,55,8,41,97,-35,66, 
  /* [11][0][][] */ -24,-73,5,-14,-5,35,28,-26,21,-8,-28,-74,9,34,-127,1, 
  /* [12][0][][] */ -28,-127,-69,88,-36,-73,-14,120,11,51,-27,103,-78,12,-5,36, 
  /* [13][0][][] */ -66,-56,-55,17,-11,-11,16,18,-63,127,-11,-19,57,51,34,5, 
  /* [14][0][][] */ -74,29,8,-112,-17,26,-56,-127,68,-3,42,50,96,-70,-109,-81, 
  /* [15][0][][] */ -33,-84,127,-84,-72,5,37,22,37,-66,-123,-77,87,-70,-53,-52, 
  /* [16][0][][] */ -7,-52,-11,3,3,45,-18,-17,67,-127,2,-62,19,-56,-94,-102, 
  /* [17][0][][] */ -23,11,-27,-33,31,-7,5,52,127,-126,-3,-32,23,-93,-39,-91, 
  /* [18][0][][] */ 59,-8,-15,-57,53,-28,14,-24,-3,127,45,43,-1,50,1,-85, 
  /* [19][0][][] */ -94,5,-26,-104,-16,56,-15,-29,24,26,-41,-127,-1,-66,-10,-23, 
  /* [20][0][][] */ 86,127,71,-111,104,-70,-92,32,-56,-61,44,-92,-107,24,-54,-53, 
  /* [21][0][][] */ -26,-116,1,56,127,77,29,79,-27,22,-35,15,58,-2,-17,-1, 
  /* [22][0][][] */ 29,-51,16,10,24,2,-3,67,-17,80,-14,43,-10,32,127,-4, 
  /* [23][0][][] */ -73,17,-16,26,12,-17,20,-36,-15,-33,75,18,-29,50,46,127, 
  /* [24][0][][] */ 49,0,5,21,25,-52,10,-30,4,127,-56,74,-18,-20,49,-22, 
  /* [25][0][][] */ 74,-42,94,116,-15,17,-39,-43,-124,127,32,-80,-23,-18,-4,22, 
  /* [26][0][][] */ -17,21,15,22,-36,123,-28,62,-70,-13,-42,59,-34,4,99,-127, 
  /* [27][0][][] */ 32,18,-26,-98,-26,-18,-36,-1,-57,-13,-71,-32,-22,45,-29,127, 
  /* [28][0][][] */ -11,29,44,42,22,16,-127,15,0,3,31,-10,2,-1,-39,7, 
  /* [29][0][][] */ -1,-88,-17,30,-73,44,127,-27,90,25,-71,21,42,-44,-54,32, 
  /* [30][0][][] */ 81,-65,-85,32,-75,-8,34,22,-18,-9,-28,-40,-78,17,57,127, 
  /* [31][0][][] */ -127,-19,54,64,0,-21,-67,-26,-30,-15,-29,-42,-31,-2,9,31, 
  /* [32][0][][] */ -127,-76,-58,8,-47,-17,-18,-38,118,53,-61,-66,-43,45,12,-22, 
  /* [33][0][][] */ 16,44,-114,1,-127,-71,93,-57,-91,8,6,-31,-4,77,47,52, 
  /* [34][0][][] */ 36,3,27,7,-87,-38,11,-42,22,-127,-18,52,-30,-3,43,53, 
  /* [35][0][][] */ -24,-24,-26,31,-51,5,67,24,15,70,44,50,18,82,7,127, 
  /* [36][0][][] */ 11,-8,-15,23,127,17,-17,42,-13,35,-77,-55,34,-17,20,-28, 
  /* [37][0][][] */ -70,54,10,-87,23,-67,-25,-21,17,-47,-102,-12,-9,-82,2,-127, 
  /* [38][0][][] */ -11,127,84,-39,-99,10,-81,-108,14,-72,24,-14,-86,-115,29,-102, 
  /* [39][0][][] */ 31,-63,2,59,31,-19,42,-20,8,-5,-5,-2,22,127,82,85, 
  /* [40][0][][] */ 16,-20,38,127,14,-66,9,74,-69,-3,-34,-34,-11,-20,87,47, 
  /* [41][0][][] */ -33,-66,53,37,-18,62,-2,65,-56,41,-127,39,-5,45,83,-112, 
  /* [42][0][][] */ 18,-9,-4,13,50,85,17,25,34,-127,-109,-25,-68,-15,75,94, 
  /* [43][0][][] */ 17,-87,-2,22,25,47,24,127,-37,-82,-82,-61,32,-37,6,-4, 
  /* [44][0][][] */ -39,-66,-42,-73,22,25,26,24,-38,-50,-75,34,-7,127,9,28, 
  /* [45][0][][] */ 26,-31,-127,46,-88,96,-45,-104,-12,-54,-37,5,20,74,72,12, 
  /* [46][0][][] */ 41,-35,-71,-1,27,-81,27,101,-23,-75,97,68,-127,-13,83,-48, 
  /* [47][0][][] */ -55,-23,-60,42,15,-21,22,67,38,65,39,99,-32,127,5,101, 
  /* [48][0][][] */ 37,-21,-97,-127,31,-63,32,51,40,-80,-20,5,-51,-9,-40,-109, 
  /* [49][0][][] */ 45,14,-3,37,21,-98,79,-46,-36,127,-24,70,33,15,44,126, 
  /* [50][0][][] */ -2,24,0,-1,-127,-12,2,-34,33,11,50,42,-40,-65,29,5, 
  /* [51][0][][] */ -16,-35,-6,-127,16,87,66,3,5,-69,9,-18,100,101,-13,125, 
  /* [52][0][][] */ 17,-54,5,-56,68,-127,-47,-44,-34,22,53,13,48,35,-28,35, 
  /* [53][0][][] */ 3,-17,31,-30,-88,-81,-6,-127,35,76,2,103,-4,-52,20,-106, 
  /* [54][0][][] */ 57,127,17,-30,-94,-15,-43,-115,55,11,71,51,-61,-53,42,-19, 
  /* [55][0][][] */ 6,33,-23,44,-37,52,41,-59,19,127,88,61,-14,-30,-18,0, 
  /* [56][0][][] */ 15,-62,-127,52,-58,73,47,26,100,-17,13,-17,-72,-13,-3,5, 
  /* [57][0][][] */ -25,46,120,-64,11,-29,-4,-50,18,2,68,127,-2,-98,43,-66, 
  /* [58][0][][] */ 60,-89,2,4,24,38,-74,127,-30,71,-10,81,-16,41,89,-20, 
  /* [59][0][][] */ -40,42,-34,-7,-1,-4,8,39,10,-20,-50,-33,-127,-43,81,4, 
  /* [60][0][][] */ -27,34,32,-56,-94,-41,57,-127,-16,63,42,44,-6,-60,-55,-47, 
  /* [61][0][][] */ 31,70,-16,-21,-127,-92,-26,-48,-34,-13,22,37,-66,-35,73,50, 
  /* [62][0][][] */ -68,27,-69,5,-33,93,-97,42,-91,2,-31,86,-59,64,127,-66, 
  /* [63][0][][] */ 31,-45,-102,-127,-24,-70,97,50,9,-117,-48,4,3,52,43,-16, 
  /* [64][0][][] */ 40,24,27,55,127,-42,14,65,-119,80,-43,0,-74,37,125,95, 
  /* [65][0][][] */ 31,54,-53,-5,8,51,-18,-108,-54,-20,67,-27,-127,9,-30,13, 
  /* [66][0][][] */ 1,46,-53,84,-36,127,-24,40,-85,-12,-60,49,3,53,50,-80, 
  /* [67][0][][] */ 5,17,-53,-1,45,-37,53,-111,-45,35,31,112,-127,-34,-74,-78, 
  /* [68][0][][] */ -3,-127,21,50,5,28,47,110,-4,40,33,29,-38,41,-7,-6, 
  /* [69][0][][] */ 49,54,115,-31,91,127,-53,69,64,104,-4,-4,113,-74,-68,-105, 
  /* [70][0][][] */ 11,49,10,13,43,48,-78,-37,-127,-101,18,70,42,85,-76,24, 
  /* [71][0][][] */ -37,-74,39,49,127,-59,35,47,-90,38,-50,-35,3,79,-19,67, 
  /* [72][0][][] */ -50,54,21,-6,-58,41,-24,-74,8,24,3,0,71,65,-127,-5, 
  /* [73][0][][] */ -10,-29,6,-50,59,-90,-3,-8,49,43,58,5,-9,-8,-80,127, 
  /* [74][0][][] */ -11,20,-31,53,-94,3,102,9,68,40,53,84,127,4,-63,18, 
  /* [75][0][][] */ 1,124,-103,91,-32,127,-55,42,-7,37,-81,33,-69,61,67,-90, 
  /* [76][0][][] */ -55,6,-76,-4,-127,-23,14,44,14,-35,-10,-25,-3,-31,-49,31, 
  /* [77][0][][] */ 52,32,-69,78,86,127,23,74,-3,55,50,-6,5,42,81,75, 
  /* [78][0][][] */ 4,-93,19,-55,87,-120,42,-4,-4,51,85,-18,-3,-15,-38,127, 
  /* [79][0][][] */ -60,19,-25,-20,-8,-66,-19,7,-127,-17,12,46,92,65,-52,11, 
  /* [80][0][][] */ -79,-58,54,7,108,-50,22,-23,-127,50,-109,-18,-67,-40,86,88, 
  /* [81][0][][] */ 96,76,-14,26,19,-25,35,69,-62,127,-69,-65,-68,18,96,61, 
  /* [82][0][][] */ -14,127,-61,-80,-25,-127,114,25,-22,-8,30,123,-26,61,127,23, 
  /* [83][0][][] */ -40,3,50,-32,34,52,28,-103,81,-22,46,-46,-13,-65,-87,-127, 
  /* [84][0][][] */ -69,-44,-45,-34,6,72,116,-7,41,40,74,95,127,123,-52,84, 
  /* [85][0][][] */ 66,-20,36,2,127,26,-42,44,0,122,-28,-11,11,77,32,18, 
  /* [86][0][][] */ -24,86,1,4,39,43,28,-36,97,48,127,2,-24,21,-20,-46, 
  /* [87][0][][] */ 25,-47,1,-78,38,-107,69,-74,76,-31,127,-51,56,-87,-108,106, 
  /* [88][0][][] */ -70,78,31,-37,39,-18,45,-29,13,-87,14,-111,2,11,27,-127, 
  /* [89][0][][] */ 3,63,-5,37,-64,127,-20,-6,-126,6,-28,57,-20,59,73,-109, 
  /* [90][0][][] */ 79,-127,-9,64,99,-28,10,60,-23,-60,-92,0,8,5,-9,-4, 
  /* [91][0][][] */ -21,-11,46,-60,11,-122,-127,74,-67,12,-28,-125,-122,-66,2,21, 
  /* [92][0][][] */ 38,57,64,12,-127,-107,37,6,9,29,49,20,-97,-57,-10,23, 
  /* [93][0][][] */ -39,-113,-97,61,-17,-97,-43,127,14,42,35,70,-15,114,8,44, 
  /* [94][0][][] */ 127,-15,114,-63,62,-2,60,46,39,104,-13,27,4,-12,105,-23, 
  /* [95][0][][] */ -20,-19,27,-34,127,34,44,13,-21,20,-91,4,80,41,-19,-8, 
};
const TfArray<4, int> tensor_dimension19 = { 4, { 96,1,1,16 } };
const TfArray<96, float> quant19_scale = { 96, { 0.0039585279300808907, 0.0016017088200896978, 0.0046667349524796009, 0.0021565947681665421, 0.0024179064203053713, 0.0011353755835443735, 0.0020390369463711977, 0.0027103135362267494, 0.001935847569257021, 0.0025984509848058224, 0.00069468305446207523, 0.0032651990186423063, 0.0026100748218595982, 0.0033402156550437212, 0.0010918524349108338, 0.0021795362699776888, 0.0029592211358249187, 0.0024354555644094944, 0.0069908197037875652, 0.0017152770888060331, 0.0032403215300291777, 0.0018191003473475575, 0.0025618157815188169, 0.0040637985803186893, 0.0038289362564682961, 0.0019430150277912617, 0.0028054716531187296, 0.0031141042709350586, 0.0033444587606936693, 0.003858242416754365, 0.0016528780106455088, 0.0034327597822993994, 0.0046716276556253433, 0.0016562112141400576, 0.0035022974479943514, 0.0017486719880253077, 0.0017724682111293077, 0.0023362128995358944, 0.0021908667404204607, 0.0029692945536226034, 0.00034254571073688567, 0.001824437640607357, 0.0034484392963349819, 0.0022873496636748314, 0.0023393661249428988, 0.0010633276542648673, 0.0025898867752403021, 0.001110999146476388, 0.0030008591711521149, 0.0038417552132159472, 0.0039269421249628067, 0.0012734008487313986, 0.0034617963247001171, 0.0027191981207579374, 0.0020807541441172361, 0.0041594626381993294, 0.0048515326343476772, 0.00028681303956545889, 0.0018214748706668615, 0.0035707540810108185, 0.0021704630926251411, 0.0021488016936928034, 0.0016271413769572973, 0.0036401969846338034, 0.00054931349586695433, 0.002114748815074563, 0.0025387504138052464, 0.0025358684360980988, 0.0014645521296188235, 0.0022754832170903683, 0.0048613552935421467, 0.0021042048465460539, 0.0018433360382914543, 0.0029274169355630875, 0.0021677284967154264, 0.0020445645786821842, 0.0044089276343584061, 0.0013480553170666099, 0.0015850149793550372, 0.0014090382028371096, 0.00172615353949368, 0.0024320739321410656, 0.0017566736787557602, 0.0010015640873461962, 0.0020508826710283756, 0.0016757177654653788, 0.0028540915809571743, 0.0017077981028705835, 0.0032843404915183783, 0.0022812390234321356, 0.0029268709477037191, 0.00075615989044308662, 0.0030646482482552528, 0.0015441665891557932, 0.0026081011164933443, 0.002858584513887763, } };
const TfArray<96, int> quant19_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant19 = { (TfLiteFloatArray*)&quant19_scale, (TfLiteIntArray*)&quant19_zero, 0 };
const ALIGN(16) int32_t tensor_data20[16] = { -10829, 3490, -16977, -3084, 14227, -20337, -28554, -1864, -23460, 4025, -15255, -11564, 2671, 5849, -4922, 6117, };
const TfArray<1, int> tensor_dimension20 = { 1, { 16 } };
const TfArray<16, float> quant20_scale = { 16, { 0.00010390798706794158, 0.00014221732271835208, 0.00015740054368507117, 9.1662834165617824e-05, 9.5807059551589191e-05, 0.00012586043158080429, 0.00010503912199055776, 0.00010054077574750409, 6.4746789576020092e-05, 9.5795418019406497e-05, 0.00014657065912615508, 8.771273132879287e-05, 0.00014880359231028706, 0.00012204782979097217, 0.00013990748266223818, 0.00014513239148072898, } };
const TfArray<16, int> quant20_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant20 = { (TfLiteFloatArray*)&quant20_scale, (TfLiteIntArray*)&quant20_zero, 0 };
const ALIGN(16) int8_t tensor_data21[16*1*1*48] = { 
  /* [0][0][][] */ 41,69,12,-61,90,44,-53,66,-18,127,11,47,-54,47,-29,30,32,76,80,-24,-78,106,1,56,29,57,52,88,5,-47,-19,71,-28,5,-64,71,54,-107,-18,18,-19,-20,80,42,-6,-81,-36,9, 
  /* [1][0][][] */ -49,9,-68,-62,24,88,-55,20,6,-47,-19,5,48,-9,-20,-25,-18,-20,22,32,-50,59,-80,-35,-45,-30,56,72,-4,-38,41,-47,30,-50,-22,46,15,-54,127,-37,-5,35,-35,-2,24,38,46,40, 
  /* [2][0][][] */ -26,39,21,-34,-6,-64,-19,-14,110,56,-45,-19,93,-23,127,69,-80,-24,-7,21,78,-62,-24,-59,7,-37,44,-23,22,23,-29,-2,23,-19,53,51,-45,2,-2,-39,17,2,14,-17,43,-72,100,-35, 
  /* [3][0][][] */ 45,7,-40,-35,21,127,22,-32,68,-30,16,-45,-54,-5,23,62,-44,-73,30,-110,5,3,16,-22,-24,79,101,35,4,-65,7,36,59,-11,108,41,-55,-56,-2,51,52,46,27,-9,1,3,1,-11, 
  /* [4][0][][] */ 107,-26,17,-30,100,37,39,19,70,-33,-99,37,41,-27,52,-4,-127,-102,-35,-107,-17,24,-52,-23,-52,72,-86,72,-66,-60,28,59,28,-68,6,-19,18,-13,-44,30,-21,-30,-27,46,-19,83,-49,-57, 
  /* [5][0][][] */ -11,-26,-70,-2,-36,98,45,-15,84,84,41,93,50,-11,74,4,-42,127,8,35,25,-27,-69,-11,41,16,-77,-54,-31,44,29,2,-61,-13,65,-17,-71,-10,-81,0,117,-24,45,47,-46,22,-64,31, 
  /* [6][0][][] */ 69,-1,34,60,13,-36,74,-28,7,1,127,64,34,25,-24,57,57,10,-55,42,44,-64,-34,21,-34,38,77,8,59,25,14,3,68,-51,-92,14,71,20,-4,4,7,54,37,-13,33,76,16,0, 
  /* [7][0][][] */ -73,-33,-2,7,-39,-51,37,35,65,127,-74,-72,-112,21,13,-3,-94,55,2,94,-34,28,20,31,-8,-70,-35,-96,11,27,-29,21,-41,-31,15,-25,2,-63,100,19,-10,50,26,-15,33,49,-34,-23, 
  /* [8][0][][] */ -7,-52,89,-28,64,-75,74,-69,-7,-108,59,51,4,-4,44,29,42,49,-10,82,-3,37,-30,20,88,32,-19,7,-127,22,-16,-111,12,-74,-8,97,15,59,114,44,33,-1,34,126,26,-49,-23,93, 
  /* [9][0][][] */ 26,-27,21,-75,36,63,-19,21,26,-25,-50,-25,23,-34,127,-11,-7,-102,45,21,-42,17,68,-35,-32,-88,-28,69,80,49,-81,9,-63,52,-15,100,-22,-35,-57,-30,-19,38,10,120,39,71,-28,1, 
  /* [10][0][][] */ -11,48,6,-19,55,13,-85,-31,35,12,70,-24,2,-11,46,-55,-48,127,-19,26,17,-14,17,11,-61,21,16,120,47,8,-20,12,58,33,-21,33,-10,-15,-35,-7,-97,-4,13,-5,34,45,57,25, 
  /* [11][0][][] */ -35,81,-40,65,13,88,-22,4,-27,-14,-100,-87,82,29,-39,-74,24,57,-42,-69,4,-10,127,16,23,-10,-19,63,22,2,23,70,19,8,-33,-11,16,120,123,-3,25,-9,71,-23,-45,-5,93,1, 
  /* [12][0][][] */ -36,1,30,28,-53,-73,8,5,-18,-58,-86,13,86,-85,37,26,37,96,91,-127,-6,-2,-47,-87,-8,-41,32,-5,5,50,22,70,37,48,23,-38,-34,-1,27,-34,-24,4,30,-7,52,5,-18,-24, 
  /* [13][0][][] */ -10,-104,-35,-70,3,25,68,39,-117,-16,97,-82,16,19,62,13,75,20,-33,-114,62,-62,100,-8,-44,-46,-51,2,-36,-127,-79,46,26,0,-40,-6,8,-72,56,-60,4,92,70,-1,45,-12,43,-69, 
  /* [14][0][][] */ 60,25,-57,-9,-68,61,-71,-66,-25,87,44,25,1,-49,15,-36,47,-118,42,12,84,-47,42,-4,-35,127,-91,-10,-38,-29,-92,8,98,34,83,-38,-59,12,-22,25,2,-21,73,-12,-70,-52,-24,47, 
  /* [15][0][][] */ -55,0,36,1,93,-2,-6,49,15,43,-9,30,55,-37,-43,-20,-8,22,-6,-43,23,-33,-45,-66,31,-77,-38,59,-6,-15,27,4,-64,-5,127,-2,-107,6,24,12,-59,-3,41,-5,-42,-32,-22,-3, 
};
const TfArray<4, int> tensor_dimension21 = { 4, { 16,1,1,48 } };
const TfArray<16, float> quant21_scale = { 16, { 0.0044160895049571991, 0.0060442360118031502, 0.0066895228810608387, 0.0038956704083830118, 0.0040718000382184982, 0.0053490679711103439, 0.0044641625136137009, 0.004272982943803072, 0.0027517385315150023, 0.0040713050402700901, 0.0062292530201375484, 0.0037277911324054003, 0.0063241524621844292, 0.0051870327442884445, 0.0059460676275193691, 0.0061681265942752361, } };
const TfArray<16, int> quant21_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant21 = { (TfLiteFloatArray*)&quant21_scale, (TfLiteIntArray*)&quant21_zero, 0 };
const ALIGN(16) int32_t tensor_data22[48] = { 9866, 1446, 16608, 1518, 15366, -2067, 46951, 1200, 14008, 43079, 9938, 26194, 1988, 7398, 29710, 21418, 66, 4375, 9987, 59870, 655, 13405, 2990, 12663, 4705, 43789, 3317, -3193, 3969, 8815, 13714, -82, 2094, 7626, 2027, 16281, 7355, 22914, 5417, 9192, 12140, 3043, 4090, 13483, 12690, 4976, 28401, 17373, };
const TfArray<1, int> tensor_dimension22 = { 1, { 48 } };
const TfArray<48, float> quant22_scale = { 48, { 9.3076174380257726e-05, 0.00012429466005414724, 0.00010597987420624122, 0.00011190972873009741, 0.00014673941768705845, 0.00014017104695085436, 4.5996923290658742e-05, 8.5691164713352919e-05, 0.00010025774099631235, 4.5009466703049839e-05, 5.6046341342153028e-05, 7.7512064308393747e-05, 7.5602569268085063e-05, 0.00011380531213944778, 6.6236498241778463e-05, 0.00014974400983192027, 0.00011176378757227212, 6.6484746639616787e-05, 0.00019825062190648168, 3.2268759241560474e-05, 0.00012965814676135778, 9.1045119916088879e-05, 0.00011778090265579522, 7.2558206738904119e-05, 9.4456983788404614e-05, 4.6667901187902316e-05, 6.6252825490664691e-05, 5.753312143497169e-05, 0.00033391118631698191, 0.00013833268894813955, 7.6760647061746567e-05, 0.0002287128590978682, 0.00012154805153841153, 0.00014310350525192916, 0.0001289955253014341, 7.0808353484608233e-05, 7.8056553320493549e-05, 6.435109389713034e-05, 7.58224559831433e-05, 0.00012360836262814701, 0.00010881362686632201, 0.00018411644850857556, 0.00014725934306625277, 0.0001003952493192628, 0.00012778767268173397, 6.0158192354720086e-05, 5.6537319323979318e-05, 9.8867320048157126e-05, } };
const TfArray<48, int> quant22_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant22 = { (TfLiteFloatArray*)&quant22_scale, (TfLiteIntArray*)&quant22_zero, 0 };
const ALIGN(16) int8_t tensor_data23[1*3*3*48] = { 
  /* [0][0][][] */ -118,-5,-86,80,-127,64,-56,127,-117,-120,-5,-48,52,49,46,-127,54,69,4,-99,88,-58,127,-59,8,-66,82,106,-127,-42,-12,124,42,-118,50,-78,-71,-75,127,14,18,-90,57,-86,44,32,-10,-109, -47,17,-45,127,-23,55,-127,25,-107,-78,100,-83,81,-82,-95,-58,52,75,56,-127,127,-127,91,-69,-109,-121,114,69,-35,-37,-102,127,44,-118,83,-33,-53,-97,84,-91,-38,23,27,-127,-55,47,-10,-45, -96,-37,-113,0,-37,127,-56,-25,-43,-106,36,-22,-10,11,47,-8,6,22,47,-37,5,-57,114,27,-127,-47,49,15,31,-5,-28,32,-27,-127,11,-51,-59,-4,71,0,-127,-45,46,-26,-102,42,4,-35, 
  /* [0][1][][] */ -85,92,31,93,-101,68,-75,58,-8,-53,19,-127,18,-15,-114,-55,60,127,-127,-106,55,-68,76,-51,12,-42,52,127,-81,-85,-66,43,75,10,57,-105,-74,-127,77,-81,7,-62,42,-59,127,78,-51,-89, -127,21,-73,71,11,69,-125,108,-127,-65,127,-114,74,-119,-46,-111,127,104,-79,-84,52,-73,18,-86,3,-127,127,70,12,-127,-127,-4,127,0,127,-99,-127,-115,79,-127,-11,127,127,-99,-92,127,-32,-64, -44,28,-127,32,-11,71,-35,53,-61,-88,88,-68,112,27,-127,49,71,13,-28,52,36,-78,45,-107,-60,6,113,6,55,-6,-66,50,15,-21,15,-85,-124,49,97,15,3,-68,18,-84,-126,18,7,-127, 
  /* [0][2][][] */ -69,88,1,42,-96,58,-89,71,-124,-127,-2,-71,32,-60,-31,-108,83,31,-96,-66,-8,-30,-38,-127,-84,-43,21,60,-53,12,-44,29,-13,27,-1,-11,10,-71,-2,-16,-103,-1,46,-12,74,62,-127,23, 62,127,0,48,-71,119,-81,40,-126,-96,83,-66,103,-127,-98,-20,48,60,-69,-70,32,-37,-47,-103,-44,-34,85,93,70,25,-46,-40,52,30,34,-127,-48,-75,19,-79,-55,57,16,-61,-67,57,-103,13, 1,45,-86,34,-68,96,-79,38,-110,-36,-2,-62,127,-112,11,-56,-23,27,-4,-2,-13,69,-8,-103,40,12,18,33,1,-18,10,-45,8,35,-2,-86,-34,5,6,3,-11,-41,29,-56,-119,37,3,-4, 
};
const TfArray<4, int> tensor_dimension23 = { 4, { 1,3,3,48 } };
const TfArray<48, float> quant23_scale = { 48, { 0.0039557372219860554, 0.0052825231105089188, 0.0045041446574032307, 0.004756163340061903, 0.0062364251352846622, 0.0059572695754468441, 0.0019548691343516111, 0.0036418742965906858, 0.0042609539814293385, 0.0019129022257402539, 0.0023819694761186838, 0.0032942625693976879, 0.003213109215721488, 0.0048367255367338657, 0.0028150512371212244, 0.0063641201704740524, 0.0047499607317149639, 0.0028256017249077559, 0.0084256511181592941, 0.001371422316879034, 0.0055104708299040794, 0.0038694175891578197, 0.0050056884065270424, 0.0030837238300591707, 0.0040144217200577259, 0.0019833857659250498, 0.0028157450724393129, 0.0024451576173305511, 0.014191225171089172, 0.0058791390620172024, 0.0032623275183141232, 0.00972029659897089, 0.0051657920703291893, 0.0060818986967206001, 0.0054823094978928566, 0.0030093549285084009, 0.0033174033742398024, 0.0027349214069545269, 0.0032224543392658234, 0.0052533554844558239, 0.0046245791018009186, 0.0078249489888548851, 0.0062585221603512764, 0.0042667980305850506, 0.005430975928902626, 0.0025567230768501759, 0.0024028359912335873, 0.004201861098408699, } };
const TfArray<48, int> quant23_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant23 = { (TfLiteFloatArray*)&quant23_scale, (TfLiteIntArray*)&quant23_zero, 3 };
const ALIGN(16) int32_t tensor_data24[48] = { 1132, -645, 1862, -1958, 5848, -1125, 3881, -3124, 1246, -281, 1002, 4054, 6, -60, 1126, 11639, -1459, 2489, 5794, -166, -1107, 1646, -1466, 2262, 181, 796, 332, -1256, 11070, -306, 2514, -981, -1353, 7299, -1084, 2278, 466, 1137, -252, 3819, 939, 12464, -3956, 1187, 10667, -335, 1985, 5390, };
const TfArray<1, int> tensor_dimension24 = { 1, { 48 } };
const TfArray<48, float> quant24_scale = { 48, { 0.00029047240968793631, 0.00030677428003400564, 0.00022401029127649963, 0.00024142657639458776, 0.00013735503307543695, 0.00021420497796498239, 0.00020771223353222013, 0.0001337807480012998, 0.00029021367663517594, 0.00042701317579485476, 0.00022323262237478048, 0.00016886940284166485, 0.00036394424387253821, 0.00068682292476296425, 0.00026876636547967792, 9.1133908426854759e-05, 0.00025461518089286983, 0.00022489887487608939, 0.00014796957839280367, 0.00070362427504733205, 0.00036392008769325912, 0.00035108756856061518, 0.00016894175496418029, 0.00034277632948942482, 0.00040394626557826996, 0.00030282215448096395, 0.00040728822932578623, 0.00027355315978638828, 8.4524799603968859e-05, 0.00023387446708511561, 0.00015235206228680909, 0.00023104135470930487, 0.00022448341769631952, 0.0001123808033298701, 0.00025266039301641285, 0.000292597571387887, 0.00047864470980130136, 0.00022054050350561738, 0.00024396803928539157, 0.00019945105304941535, 0.00038230235804803669, 7.4702445999719203e-05, 0.00014626489428337663, 0.00037818867713212967, 9.7658688900992274e-05, 0.00039632053812965751, 0.00025780452415347099, 0.00015981205797288567, } };
const TfArray<48, int> quant24_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant24 = { (TfLiteFloatArray*)&quant24_scale, (TfLiteIntArray*)&quant24_zero, 0 };
const ALIGN(16) int8_t tensor_data25[48*1*1*8] = { 
  /* [0][0][][] */ 28,22,127,-44,64,69,-74,-63, 
  /* [1][0][][] */ 41,-126,-127,37,91,58,60,61, 
  /* [2][0][][] */ -127,-5,-60,-4,22,32,-82,-45, 
  /* [3][0][][] */ 18,65,127,-47,18,-93,4,-23, 
  /* [4][0][][] */ -108,49,-123,-78,127,-39,-20,-124, 
  /* [5][0][][] */ -115,2,-29,-13,3,27,-53,-127, 
  /* [6][0][][] */ -23,-104,-119,63,127,25,-15,61, 
  /* [7][0][][] */ -88,-127,-45,-71,-114,-44,57,90, 
  /* [8][0][][] */ 67,4,12,-25,44,-119,-127,-21, 
  /* [9][0][][] */ -15,79,-28,127,-35,-42,116,-24, 
  /* [10][0][][] */ 0,74,27,51,127,-5,-27,21, 
  /* [11][0][][] */ -95,-17,-28,-1,-92,55,127,15, 
  /* [12][0][][] */ 52,80,-127,41,10,-50,-74,6, 
  /* [13][0][][] */ 52,-14,-76,-13,-3,-127,-32,-6, 
  /* [14][0][][] */ 19,-86,103,17,98,-127,-34,-31, 
  /* [15][0][][] */ -113,-39,52,104,48,88,-127,62, 
  /* [16][0][][] */ 127,-1,-14,16,99,-83,-75,-15, 
  /* [17][0][][] */ 58,127,63,85,53,52,12,-69, 
  /* [18][0][][] */ 71,-17,66,21,127,-27,56,-23, 
  /* [19][0][][] */ -1,127,25,35,-68,-5,24,-2, 
  /* [20][0][][] */ -38,44,58,-127,14,15,4,109, 
  /* [21][0][][] */ -43,76,70,-127,43,2,23,52, 
  /* [22][0][][] */ -91,-46,-75,-15,-127,69,86,-21, 
  /* [23][0][][] */ 43,21,-127,-3,-9,-44,-47,-3, 
  /* [24][0][][] */ -15,43,1,-4,-19,107,-127,114, 
  /* [25][0][][] */ -65,-37,-127,15,-28,-62,77,77, 
  /* [26][0][][] */ 58,-19,-61,-49,77,4,127,-19, 
  /* [27][0][][] */ 114,-88,8,127,-24,38,-1,107, 
  /* [28][0][][] */ 22,85,63,-43,127,-64,14,-67, 
  /* [29][0][][] */ 11,-79,-13,-20,-69,-12,127,-83, 
  /* [30][0][][] */ 31,-127,-86,-125,-124,2,33,-53, 
  /* [31][0][][] */ -7,8,15,-19,-127,5,-10,-4, 
  /* [32][0][][] */ 68,13,-102,127,73,-102,104,-117, 
  /* [33][0][][] */ 96,53,94,11,127,-72,-32,-5, 
  /* [34][0][][] */ -127,-59,76,-50,-38,58,85,-36, 
  /* [35][0][][] */ -2,51,127,4,-62,-63,-28,38, 
  /* [36][0][][] */ -122,15,83,-12,-34,127,86,33, 
  /* [37][0][][] */ -10,-84,-28,-127,-80,-33,24,17, 
  /* [38][0][][] */ 73,0,127,-29,81,78,-98,22, 
  /* [39][0][][] */ -65,121,-110,-57,-47,26,-2,127, 
  /* [40][0][][] */ 68,-29,15,37,-3,-9,9,127, 
  /* [41][0][][] */ -25,124,99,56,90,99,-127,15, 
  /* [42][0][][] */ 25,-126,-48,-20,-127,14,18,-98, 
  /* [43][0][][] */ -37,-52,18,-89,108,-127,13,8, 
  /* [44][0][][] */ -58,97,115,33,-29,23,-127,-20, 
  /* [45][0][][] */ -18,64,21,62,-90,23,-127,35, 
  /* [46][0][][] */ -17,-51,31,21,-127,-97,-38,-22, 
  /* [47][0][][] */ -30,14,28,-78,-127,1,31,19, 
};
const TfArray<4, int> tensor_dimension25 = { 4, { 48,1,1,8 } };
const TfArray<48, float> quant25_scale = { 48, { 0.002991977147758007, 0.0031598927453160286, 0.0023073919583112001, 0.0024867863394320011, 0.0014148094924166799, 0.0022063935175538063, 0.0021395157091319561, 0.0013779930304735899, 0.0029893121682107449, 0.0043983994983136654, 0.0022993816528469324, 0.0017394196474924684, 0.0037487652152776718, 0.0070745395496487617, 0.002768396632745862, 0.000938714190851897, 0.0026226339396089315, 0.0023165447637438774, 0.0015241433866322041, 0.0072475997731089592, 0.0037485165521502495, 0.0036163367331027985, 0.0017401649383828044, 0.0035307276993989944, 0.0041608014144003391, 0.0031191844027489424, 0.0041952249594032764, 0.002817702479660511, 0.0008706378866918385, 0.0024089966900646687, 0.0015692847082391381, 0.0023798146285116673, 0.0023122653365135193, 0.0011575653916224837, 0.0026024989783763885, 0.0030138671863824129, 0.0049302242696285248, 0.0022716517560184002, 0.0025129644200205803, 0.0020544223953038454, 0.0039378609508275986, 0.00076946383342146873, 0.0015065845800563693, 0.0038954885676503181, 0.0010059219785034657, 0.0040822536684572697, 0.0026554854121059179, 0.0016461255727335811, } };
const TfArray<48, int> quant25_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant25 = { (TfLiteFloatArray*)&quant25_scale, (TfLiteIntArray*)&quant25_zero, 0 };
const ALIGN(16) int32_t tensor_data26[8] = { -1115, -4626, 20027, -8854, -3164, -16262, -1691, -14846, };
const TfArray<1, int> tensor_dimension26 = { 1, { 8 } };
const TfArray<8, float> quant26_scale = { 8, { 6.2912789871916175e-05, 7.1334485255647451e-05, 0.00011819409701274708, 0.00013385388592723757, 4.9704140110407025e-05, 8.2602782640606165e-05, 8.3177830674685538e-05, 9.3274546088650823e-05, } };
const TfArray<8, int> quant26_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant26 = { (TfLiteFloatArray*)&quant26_scale, (TfLiteIntArray*)&quant26_zero, 0 };
const ALIGN(16) int8_t tensor_data27[8*1*1*48] = { 
  /* [0][0][][] */ -16,-29,-9,-67,6,-13,110,91,-77,-79,-15,68,-63,-2,-51,20,-55,20,-14,127,22,-9,34,54,51,66,41,26,-51,-50,-40,-55,-39,86,18,-74,0,-24,50,-26,26,24,3,-82,32,-20,-10,-93, 
  /* [1][0][][] */ -4,59,12,-42,-69,18,-1,-29,-22,35,6,44,86,41,-59,-5,-3,-97,105,-38,80,8,-75,13,9,-19,-56,45,71,23,86,19,-4,-1,26,37,23,124,-6,-14,42,23,-24,21,127,20,-21,62, 
  /* [2][0][][] */ -19,-23,124,5,92,-63,-9,-9,-39,-28,-6,60,-6,-13,-30,-127,-44,-96,-44,15,-109,28,-22,-45,-80,-5,-1,-58,-30,3,-35,-8,22,-8,19,4,42,-25,-37,-33,29,-24,22,-26,-45,-28,-59,-53, 
  /* [3][0][][] */ 41,33,58,25,-16,-23,46,81,-32,-44,53,6,-33,48,-45,59,77,33,9,18,-85,-54,116,-3,2,27,-39,-51,-43,70,127,-64,2,-84,21,25,-21,-54,-24,78,-112,-26,64,-4,-53,-49,61,42, 
  /* [4][0][][] */ 52,-11,120,-34,20,-13,23,23,-35,-3,-24,39,70,-82,30,-90,100,49,-22,-43,-2,17,11,13,-10,12,127,-47,52,57,-94,-15,-9,-9,59,14,45,-48,56,37,-54,-15,-123,67,7,-101,19,46, 
  /* [5][0][][] */ 21,-34,51,23,39,26,10,-23,-51,9,-14,1,48,-9,-7,-38,88,65,16,-16,92,-84,127,-56,4,57,0,27,-6,43,-34,-50,-32,-23,-59,55,27,36,39,28,-103,7,43,26,54,-7,74,14, 
  /* [6][0][][] */ -78,37,-118,110,11,4,27,36,-33,-3,41,-64,-65,4,10,39,-117,33,-31,49,60,32,-9,-54,32,-51,15,77,-33,-65,-16,13,41,39,-17,-40,-16,-13,54,17,70,57,-59,-7,-56,127,-37,-4, 
  /* [7][0][][] */ 33,43,-57,2,11,51,101,70,-5,36,-89,-1,-39,33,-60,-37,-7,6,78,94,65,6,127,44,91,74,-48,71,-56,6,3,-34,-1,-67,-29,-8,11,66,-44,13,-22,42,-8,-43,33,3,34,-6, 
};
const TfArray<4, int> tensor_dimension27 = { 4, { 8,1,1,48 } };
const TfArray<8, float> quant27_scale = { 8, { 0.0026737935841083527, 0.0030317155178636312, 0.0050232489593327045, 0.0056887897662818432, 0.0021124258637428284, 0.0035106181167066097, 0.0035350578837096691, 0.003964168019592762, } };
const TfArray<8, int> quant27_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant27 = { (TfLiteFloatArray*)&quant27_scale, (TfLiteIntArray*)&quant27_zero, 0 };
const ALIGN(16) int32_t tensor_data28[48] = { -963, 16488, -2097, -3112, 13990, -162, 2765, 6493, -4164, 1136, -8919, -1162, 2561, 1963, 9429, 3943, 9558, 2144, 3564, -4224, -677, 1315, 15481, 233, -6670, 3340, 14309, -3683, -1664, -6395, -16537, 11214, 12899, -2245, 529, -1132, 143, 1587, 12937, -2392, 2499, -10950, 7290, 7220, -2211, 12265, -2673, -2246, };
const TfArray<1, int> tensor_dimension28 = { 1, { 48 } };
const TfArray<48, float> quant28_scale = { 48, { 0.00038235736428759992, 9.0406807430554181e-05, 0.00058972690021619201, 0.00013089005369693041, 0.00013110098370816559, 0.00062590109882876277, 0.00022772788361180574, 0.0003083054325543344, 0.00013683010183740407, 0.00024825867149047554, 0.00015912430535536259, 0.00073855812661349773, 0.00038172138738445938, 0.00016590298037044704, 0.00013194134226068854, 0.00049713067710399628, 0.00015820945554878563, 6.0543286963365972e-05, 0.00021453526278492063, 0.00020587639301083982, 0.00039188412483781576, 0.00024432016653008759, 0.00012421891733538359, 0.0005059789982624352, 0.00026635942049324512, 0.00026205982430838048, 0.00042961389408446848, 0.00019474150030873716, 0.00028362468583509326, 0.00029282926698215306, 9.1133784735575318e-05, 8.585933392168954e-05, 8.2133774412795901e-05, 0.00018130637181457132, 0.00017677558935247362, 0.00023733274429105222, 0.000665763218421489, 0.00035248752101324499, 0.0001086484917323105, 0.00017438996292185038, 0.00016325697652064264, 5.4654698033118621e-05, 0.00022032423294149339, 0.00021154081332497299, 0.0002818942884914577, 7.9316945630125701e-05, 6.4862513681873679e-05, 0.00023536832304671407, } };
const TfArray<48, int> quant28_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant28 = { (TfLiteFloatArray*)&quant28_scale, (TfLiteIntArray*)&quant28_zero, 0 };
const ALIGN(16) int8_t tensor_data29[1*3*3*48] = { 
  /* [0][0][][] */ 12,-69,16,27,-87,-124,-55,1,-41,-11,-4,37,34,-33,-83,19,54,48,-1,-16,-28,8,-115,25,38,-24,-44,-17,-53,86,0,-48,-3,20,-32,5,-25,-51,-1,31,-36,111,-47,-9,-4,25,74,-24, -127,-39,-16,127,-102,55,-89,67,47,2,15,23,59,9,-71,-28,-43,101,70,-40,8,127,-18,127,79,-54,-88,67,44,-127,17,-39,12,28,-39,-77,23,7,-39,3,-118,23,-127,-127,18,58,-10,127, -9,-20,9,53,-79,24,52,35,41,-48,31,27,0,-21,-68,8,-127,31,-34,-83,-8,-7,113,-2,-35,-14,-36,2,19,53,45,58,-49,21,17,113,-21,-11,6,66,50,24,5,-45,-12,49,-48,8, 
  /* [0][1][][] */ -32,-59,-20,22,-5,-127,116,-84,-37,-23,61,63,91,0,-70,-27,-46,-13,-35,127,10,-65,53,-7,-4,120,-125,-69,127,-76,89,-86,-76,10,-29,53,-16,-70,-65,22,117,127,-28,-114,-44,-53,20,110, 100,-127,127,36,125,69,-73,-61,17,127,127,-127,-127,127,127,127,85,127,127,85,127,87,-31,-30,66,-127,-127,127,35,126,127,-67,-127,127,106,127,-127,127,-127,-74,57,101,-97,-11,127,-127,18,99, 19,-11,-33,31,-127,127,-127,48,127,-107,-19,100,-50,-23,-22,-61,7,2,-120,-18,-2,-99,-75,-18,127,-47,-59,94,-47,-16,36,-42,-69,-2,127,-79,16,-25,-25,-100,127,40,49,2,-43,82,127,-84, 
  /* [0][2][][] */ 15,4,11,-4,-25,-113,1,-32,-30,-40,49,37,-9,-82,-60,-4,-73,8,-57,30,-30,-30,111,-31,-101,0,38,-48,5,-4,-22,-41,-52,-15,-31,101,0,6,-8,24,-19,21,-18,44,8,28,5,43, 25,-50,-23,-19,-13,-28,120,-127,58,-48,-44,42,-118,-89,-75,-65,-24,66,-59,93,-12,24,-48,-33,-89,60,91,-52,-76,44,-43,-127,-53,-24,-35,3,54,-23,-27,127,-83,10,-29,52,40,22,37,-111, 16,-35,12,4,-72,-38,-23,-67,-17,-50,-29,38,24,-80,-40,-5,58,16,-45,-27,-29,-39,-127,-20,22,-44,12,-3,-5,30,14,-52,-26,-18,7,-87,4,-11,4,-7,21,6,15,-18,7,38,104,-46, 
};
const TfArray<4, int> tensor_dimension29 = { 4, { 1,3,3,48 } };
const TfArray<48, float> quant29_scale = { 48, { 0.016250187531113625, 0.0038422890938818455, 0.025063391774892807, 0.0055628269910812378, 0.0055717914365231991, 0.026600796729326248, 0.0096784345805644989, 0.013102980330586433, 0.0058152792043983936, 0.010550993494689465, 0.0067627825774252415, 0.031388718634843826, 0.016223158687353134, 0.0070508765056729317, 0.0056075067259371281, 0.021128052845597267, 0.0067239017225801945, 0.002573089674115181, 0.0091177485883235931, 0.0087497467175126076, 0.016655074432492256, 0.010383606888353825, 0.0052793039940297604, 0.021504107862710953, 0.011320275254547596, 0.011137542314827442, 0.018258590251207352, 0.0082765137776732445, 0.012054049409925938, 0.012445244006812572, 0.003873185720294714, 0.0036490217316895723, 0.0034906852524727583, 0.0077055208384990692, 0.0075129624456167221, 0.010086641646921635, 0.028294935822486877, 0.014980719424784184, 0.0046175606548786163, 0.0074115730822086334, 0.0069384216330945492, 0.0023228246718645096, 0.0093637797981500626, 0.0089904842898249626, 0.011980507522821426, 0.0033709702547639608, 0.0027566568460315466, 0.01000315323472023, } };
const TfArray<48, int> quant29_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant29 = { (TfLiteFloatArray*)&quant29_scale, (TfLiteIntArray*)&quant29_zero, 3 };
const ALIGN(16) int32_t tensor_data30[48] = { 5495, 6400, 8584, 265, 3080, -2924, 4413, 8923, 3943, -1056, 7233, -1811, 5282, -626, 1910, 7533, -488, 1908, -680, 3201, 3474, 2586, 380, 48130, 8106, 4673, 23904, 1612, 6958, 9659, 1124, 519, 4518, 878, 127, -41, -2647, -76, 4176, 4415, 1471, 1179, 3961, 8476, 2919, 3171, 2351, 5353, };
const TfArray<1, int> tensor_dimension30 = { 1, { 48 } };
const TfArray<48, float> quant30_scale = { 48, { 0.00013167884026188403, 0.00014058162923902273, 0.00010390118404757231, 0.00025962450308725238, 0.00021521498274523765, 0.00017976896197069436, 0.00015008568880148232, 9.3453854788094759e-05, 0.00016113340097945184, 0.00028578529600054026, 0.00012913256068713963, 0.000279759377008304, 0.00014656539133284241, 0.00039115329855121672, 0.00023642989981453866, 0.00011757305037463084, 0.00038568209856748581, 0.00029563985299319029, 0.00027584304916672409, 0.00023169176711235195, 0.00017956036026589572, 0.00025714043295010924, 0.00025725064915604889, 2.5054401703528129e-05, 0.00012066537601640448, 0.00012845237506553531, 4.938724305247888e-05, 0.00024210283299908042, 0.00011808013368863612, 9.1906091256532818e-05, 0.00038372896960936487, 0.00053199648391455412, 0.00012199173215776682, 0.00028279927209950984, 0.00029654902755282819, 0.00041918858187273145, 0.00022891032858751714, 0.00030501899891532958, 0.00018412014469504356, 0.00015859246195759624, 0.00033136291312985122, 0.00031429872615262866, 0.00021667986584361643, 0.00011956763046327978, 0.00021644745720550418, 0.00021285167895257473, 0.00028964938246645033, 0.00014122744323685765, } };
const TfArray<48, int> quant30_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant30 = { (TfLiteFloatArray*)&quant30_scale, (TfLiteIntArray*)&quant30_zero, 0 };
const ALIGN(16) int8_t tensor_data31[48*1*1*8] = { 
  /* [0][0][][] */ 48,127,-125,-65,33,110,-14,85, 
  /* [1][0][][] */ 17,-64,102,-127,-20,117,-68,-25, 
  /* [2][0][][] */ -17,123,89,22,127,25,65,23, 
  /* [3][0][][] */ 127,27,-83,103,13,-118,-91,-63, 
  /* [4][0][][] */ -48,22,-13,-90,-14,127,19,49, 
  /* [5][0][][] */ -3,25,-115,-127,3,118,51,-9, 
  /* [6][0][][] */ 27,127,8,38,124,39,-27,-45, 
  /* [7][0][][] */ 108,-39,51,86,49,34,127,14, 
  /* [8][0][][] */ 50,107,29,56,100,119,125,-127, 
  /* [9][0][][] */ 17,75,-31,-50,25,127,-24,38, 
  /* [10][0][][] */ -83,-61,42,-100,-7,-63,-88,127, 
  /* [11][0][][] */ 5,-118,-127,-53,13,-28,19,14, 
  /* [12][0][][] */ 4,-65,-45,-65,-34,28,-88,127, 
  /* [13][0][][] */ -22,7,-47,81,-127,-22,-14,10, 
  /* [14][0][][] */ -61,8,-127,-48,74,41,-10,22, 
  /* [15][0][][] */ 35,-121,-127,13,-97,-30,-29,-78, 
  /* [16][0][][] */ 104,-18,-6,42,-63,30,8,127, 
  /* [17][0][][] */ -35,53,127,-37,-51,24,-1,-9, 
  /* [18][0][][] */ -49,-127,73,91,9,-46,32,-116, 
  /* [19][0][][] */ 127,6,-55,77,-62,25,38,108, 
  /* [20][0][][] */ -33,-127,114,93,-9,-81,14,-54, 
  /* [21][0][][] */ 22,-62,-41,-34,127,-1,102,7, 
  /* [22][0][][] */ -127,52,-67,109,43,33,-88,-122, 
  /* [23][0][][] */ -28,-79,62,-7,-51,115,127,-5, 
  /* [24][0][][] */ -1,-23,-22,-65,-36,45,127,-39, 
  /* [25][0][][] */ -127,-56,-107,-94,-102,29,-110,-24, 
  /* [26][0][][] */ -70,36,-27,54,-127,12,-24,-15, 
  /* [27][0][][] */ 12,-127,56,92,0,-101,-5,-92, 
  /* [28][0][][] */ 5,75,45,34,127,-70,14,-46, 
  /* [29][0][][] */ 116,45,-49,-11,122,-69,-127,43, 
  /* [30][0][][] */ 64,-20,6,-127,40,-40,28,-15, 
  /* [31][0][][] */ 52,-30,-8,26,-6,41,-7,127, 
  /* [32][0][][] */ -127,-55,38,-89,-41,64,27,114, 
  /* [33][0][][] */ -42,54,30,-43,-32,127,-114,68, 
  /* [34][0][][] */ 10,127,-40,-30,-19,-24,-123,61, 
  /* [35][0][][] */ -12,-127,5,13,24,-49,-2,-110, 
  /* [36][0][][] */ -28,-49,-50,-26,-127,-80,-39,14, 
  /* [37][0][][] */ -55,-127,52,91,-43,-95,-2,-46, 
  /* [38][0][][] */ -55,-8,32,-57,-127,-68,-14,42, 
  /* [39][0][][] */ 127,-27,72,75,36,-61,-45,-46, 
  /* [40][0][][] */ 36,70,-31,8,-127,-46,-89,27, 
  /* [41][0][][] */ 50,86,-101,-127,3,-17,-5,30, 
  /* [42][0][][] */ -9,-17,5,33,127,10,30,-3, 
  /* [43][0][][] */ 127,24,54,28,-54,-12,62,76, 
  /* [44][0][][] */ -8,-3,-9,84,16,-117,-127,46, 
  /* [45][0][][] */ 32,2,32,23,48,-127,28,-24, 
  /* [46][0][][] */ 63,-59,-11,121,27,101,61,127, 
  /* [47][0][][] */ -60,-115,17,13,-40,-27,127,-22, 
};
const TfArray<4, int> tensor_dimension31 = { 4, { 48,1,1,8 } };
const TfArray<48, float> quant31_scale = { 48, { 0.0017412941670045257, 0.001859022886492312, 0.0013739680871367455, 0.0034332217182964087, 0.0028459592722356319, 0.0023772281128913164, 0.0019847026560455561, 0.0012358147650957108, 0.0021307952702045441, 0.0037791666109114885, 0.0017076226649805903, 0.0036994810216128826, 0.0019381508463993669, 0.0051725315861403942, 0.0031265008728951216, 0.0015547621296718717, 0.0051001817919313908, 0.0039094812236726284, 0.0036476922687143087, 0.0030638447497040033, 0.002374469768255949, 0.0034003728069365025, 0.003401830093935132, 0.00033131430973298848, 0.0015956544084474444, 0.0016986281843855977, 0.0006530868704430759, 0.0032015186734497547, 0.0015614676522091031, 0.0012153474381193519, 0.005074353888630867, 0.0070350132882595062, 0.0016131938900798559, 0.0037396799307316542, 0.0039215041324496269, 0.0055432645604014397, 0.0030270635616034269, 0.0040335091762244701, 0.0024347673170268536, 0.0020971945486962795, 0.0043818759731948376, 0.0041562225669622421, 0.0028653305489569902, 0.0015811379998922348, 0.0028622571844607592, 0.0028147073462605476, 0.0038302645552903414, 0.0018675629980862141, } };
const TfArray<48, int> quant31_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant31 = { (TfLiteFloatArray*)&quant31_scale, (TfLiteIntArray*)&quant31_zero, 0 };
const ALIGN(16) int32_t tensor_data32[8] = { 3408, 18511, -4177, 764, -458, 4077, -10815, -15978, };
const TfArray<1, int> tensor_dimension32 = { 1, { 8 } };
const TfArray<8, float> quant32_scale = { 8, { 0.00017391609435435385, 0.00012289373262319714, 0.00012371908815111965, 0.00010909634147537872, 0.00020342592324595898, 0.00012921052984893322, 0.00018706900300458074, 0.00010579970694379881, } };
const TfArray<8, int> quant32_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant32 = { (TfLiteFloatArray*)&quant32_scale, (TfLiteIntArray*)&quant32_zero, 0 };
const ALIGN(16) int8_t tensor_data33[8*1*1*48] = { 
  /* [0][0][][] */ -39,-2,37,16,-31,-9,34,12,-50,13,-49,-60,-19,-41,-1,-24,49,-48,19,33,-1,34,-25,7,-1,-41,53,-15,11,-8,16,5,78,39,45,-127,17,13,-30,-31,6,-5,41,59,42,12,33,11, 
  /* [1][0][][] */ -38,45,70,-12,-37,48,-54,0,24,36,20,-127,-3,118,-26,76,-1,31,-37,-95,44,-94,-4,39,-88,-45,-8,-118,-41,-4,32,-41,35,85,-41,-26,126,-39,9,9,-17,76,-87,-31,111,-10,-25,-33, 
  /* [2][0][][] */ -24,0,-55,20,2,42,3,12,-8,39,-8,27,73,-79,31,-49,42,-86,25,31,-23,32,4,53,-26,54,-18,-40,0,15,27,-42,-49,-64,28,-31,62,28,-11,-57,-9,32,69,1,127,5,34,12, 
  /* [3][0][][] */ 1,5,-57,59,9,-43,-37,-75,14,-13,-29,-11,21,32,50,77,-2,-3,-6,11,16,-78,10,-28,-77,-3,127,-33,-16,9,-30,7,17,-70,7,-6,5,-22,-1,64,-27,-14,16,34,38,23,-23,49, 
  /* [4][0][][] */ -43,-50,-16,11,9,-20,-17,5,34,-24,61,-79,-7,37,20,5,-14,-32,30,-12,5,-55,12,-3,12,-7,33,62,48,38,-21,30,-24,11,4,-14,-73,93,48,-53,26,-17,-24,-34,-79,6,127,-2, 
  /* [5][0][][] */ 52,-53,-9,6,39,-35,77,-124,29,-33,-25,122,-127,78,-11,-68,-28,-79,22,-7,-44,93,-46,-70,-45,56,-50,1,-39,63,-52,-54,18,72,34,-11,-54,-22,-13,-60,39,-67,-63,4,-68,84,64,45, 
  /* [6][0][][] */ 40,-10,28,-15,-34,-15,-31,32,-48,18,-56,127,-43,-55,7,32,19,45,22,48,39,-90,-9,1,49,50,-58,16,0,-61,7,34,1,38,-21,4,17,9,3,-22,2,-38,47,72,5,-63,75,-2, 
  /* [7][0][][] */ -1,49,5,77,16,20,23,22,-22,13,55,-1,76,117,45,25,18,50,-33,42,10,-13,-51,-41,26,-4,-42,64,19,-59,-30,10,40,27,37,-110,-69,25,-6,63,-32,45,59,127,-73,-29,-113,85, 
};
const TfArray<4, int> tensor_dimension33 = { 4, { 8,1,1,48 } };
const TfArray<8, float> quant33_scale = { 8, { 0.007391433697193861, 0.0052229836583137512, 0.0052580609917640686, 0.0046365945599973202, 0.0086456015706062317, 0.0054914476349949837, 0.0079504325985908508, 0.0044964873231947422, } };
const TfArray<8, int> quant33_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant33 = { (TfLiteFloatArray*)&quant33_scale, (TfLiteIntArray*)&quant33_zero, 0 };
const ALIGN(16) int32_t tensor_data34[48] = { 6666, 6166, 4073, -3947, 2520, -3134, -5153, 40215, 729, 9740, 5596, 41411, 2429, 366, 692, 5456, -5061, 14151, 1030, 6335, 7192, -2265, -1949, 297, 13405, 622, 8588, 12052, 1125, -4556, -967, 9544, 4140, 3270, -7426, 8772, -10221, 15080, 1244, 19581, 5405, -3838, 10493, 1802, -3283, 9431, 1634, -2472, };
const TfArray<1, int> tensor_dimension34 = { 1, { 48 } };
const TfArray<48, float> quant34_scale = { 48, { 0.00015976111171767116, 9.5108698587864637e-05, 0.000150187814142555, 0.00016813965339679271, 0.00050965062109753489, 0.00018982817709911615, 7.9873119830153883e-05, 4.4971402530791238e-05, 0.00014188057684805244, 6.7342065449338406e-05, 8.8467677414882928e-05, 7.6039177656639367e-05, 9.0208450274076313e-05, 7.5905423727817833e-05, 0.00023666092602070421, 0.00021764608391094953, 0.00011044343409594148, 0.00018716325575951487, 0.00016907750978134573, 0.00018933617684524506, 9.5917166618164629e-05, 0.00024538213619962335, 0.00014631777594331652, 0.00026055835769511759, 0.00010587482393020764, 0.0002275362639920786, 5.1172417443012819e-05, 8.111515489872545e-05, 0.00027413072530180216, 0.00058905949117615819, 0.00019078310288023204, 7.1739887061994523e-05, 0.00010614952770993114, 0.00010496873437659815, 0.00011728952813427895, 5.237893492449075e-05, 6.7950808443129063e-05, 4.3947009544353932e-05, 0.00012999556201975793, 8.8681939814705402e-05, 0.00013325386680662632, 0.00022971828002482653, 6.6187072661705315e-05, 0.00018046164768747985, 6.9418201746884733e-05, 0.00015857465041335672, 7.8268618381116539e-05, 0.00020095544459763914, } };
const TfArray<48, int> quant34_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant34 = { (TfLiteFloatArray*)&quant34_scale, (TfLiteIntArray*)&quant34_zero, 0 };
const ALIGN(16) int8_t tensor_data35[1*3*3*48] = { 
  /* [0][0][][] */ -63,-124,-13,-39,125,13,28,-90,-62,-127,-11,-39,127,1,38,-80,49,-5,-7,-36,-127,23,22,-1,-111,18,41,-27,74,-39,-41,-36,-72,-83,102,49,-26,35,109,-127,-127,11,29,16,102,-127,50,91, -38,-96,-59,127,-119,127,127,-10,-90,64,38,-127,118,120,73,-25,-40,-80,50,-45,-41,31,-15,127,-127,77,127,-38,103,-23,-41,-101,-23,-84,117,82,127,115,93,-86,-117,-37,82,37,91,42,77,43, 3,-125,-61,41,-60,3,49,-16,89,-12,11,-67,-15,127,-42,9,-79,-18,56,21,3,-12,-12,-48,-116,-5,7,-72,48,90,113,8,-12,-29,11,75,57,5,1,11,-6,91,115,15,14,-14,24,-91, 
  /* [0][1][][] */ -127,-26,-19,-82,-105,-50,120,-127,-127,-124,97,-92,90,38,-127,-90,104,-115,-52,-40,-105,127,-25,-18,-27,74,38,-90,-125,-60,15,-36,-66,-127,-127,53,0,127,11,-84,-2,43,5,100,127,58,127,-53, -36,-53,-127,-43,-43,88,75,-51,45,62,127,-63,84,93,19,-127,127,-127,-127,-127,-84,100,-127,33,-59,127,97,-127,-127,127,-92,-127,-127,-107,88,112,78,64,-54,-88,19,-83,127,87,110,-30,84,127, 0,-127,-95,107,79,-45,16,-68,69,-37,21,-33,0,112,100,21,-38,-33,-32,-12,-38,-20,-96,-83,-100,9,8,-79,-72,25,127,-45,-32,-14,113,127,74,49,-15,15,-6,127,123,16,94,-72,-9,20, 
  /* [0][2][][] */ -38,-60,4,51,-32,-2,-8,-46,7,-62,47,-97,-25,-36,-38,18,-62,-15,54,-49,-30,69,-22,-51,29,5,123,4,29,61,-20,-16,-13,-99,-21,107,20,56,-102,-4,-29,38,-71,62,42,6,57,-53, 0,-71,-42,-20,127,5,109,-92,76,-1,-22,-71,-23,70,-107,-75,60,-10,22,-91,-29,113,-9,7,-43,4,94,-41,41,2,-100,-57,-39,-37,-89,40,23,68,-127,-82,30,-63,127,127,34,-112,78,69, 5,-4,-36,8,13,-27,-9,-45,-86,-13,-30,13,18,56,27,28,-22,5,-16,-62,-17,-1,-5,-42,-122,-64,38,-30,8,-90,8,-58,-45,-8,10,53,58,8,-66,-11,18,7,9,43,9,-54,26,65, 
};
const TfArray<4, int> tensor_dimension35 = { 4, { 1,3,3,48 } };
const TfArray<48, float> quant35_scale = { 48, { 0.0067898468114435673, 0.0040421197190880775, 0.0063829822465777397, 0.0071459352038800716, 0.021660150960087776, 0.008067697286605835, 0.0033946074545383453, 0.0019112846348434687, 0.0060299243777990341, 0.0028620376251637936, 0.0037598763592541218, 0.0032316648866981268, 0.0038338589947670698, 0.0032259805593639612, 0.010058089159429073, 0.0092499582096934319, 0.0046938457526266575, 0.007954438216984272, 0.0071857939474284649, 0.0080467872321605682, 0.0040764794684946537, 0.01042874064296484, 0.0062185050919651985, 0.011073729954659939, 0.0044996798969805241, 0.0096702910959720612, 0.0021748277358710766, 0.0034473941195756197, 0.011650555767118931, 0.025035027414560318, 0.0081082815304398537, 0.0030489452183246613, 0.0045113549567759037, 0.0044611711055040359, 0.0049848048947751522, 0.0022261047270148993, 0.0028879093006253242, 0.0018677478656172752, 0.0055248113349080086, 0.0037689823657274246, 0.0056632892228662968, 0.0097630266100168228, 0.0028129504062235355, 0.0076696197502315044, 0.0029502734541893005, 0.0067394226789474487, 0.0033264162484556437, 0.0085406061261892319, } };
const TfArray<48, int> quant35_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant35 = { (TfLiteFloatArray*)&quant35_scale, (TfLiteIntArray*)&quant35_zero, 3 };
const ALIGN(16) int32_t tensor_data36[48] = { 1524, -319, -162, 1060, 17922, 2043, -3, 7380, 2449, 1107, 101, 4400, 1810, 704, -285, 383, 4235, 6703, 4841, -1181, 714, 31, -485, 4424, -672, -872, 1308, 40, 11676, 7711, 6105, 239, 605, -30, 4782, -13, 591, -494, 988, 1131, 3376, 1811, -171, -1109, 1330, 2806, 1782, -754, };
const TfArray<1, int> tensor_dimension36 = { 1, { 48 } };
const TfArray<48, float> quant36_scale = { 48, { 0.00041173293720930815, 0.0003895868721883744, 0.00042592265526764095, 0.00027367690927349031, 5.7799839851213619e-05, 0.00030815185164101422, 0.00029661983717232943, 0.00011954179353779182, 0.00026021935627795756, 0.00053342402679845691, 0.00030416049412451684, 0.00020617920381482691, 0.00019669724861159921, 0.00037639553193002939, 0.00034526843228377402, 0.00029200268909335136, 0.00022424221970140934, 0.00011433981126174331, 0.00015572152915410697, 0.00026838624035008252, 0.00044154378701932728, 0.00022818593424744904, 0.00038165904697962105, 0.0001939368958119303, 0.00025749512133188546, 0.00055107008665800095, 0.00023321773915085942, 0.00044639743282459676, 8.6046187789179385e-05, 0.00011294485011603683, 0.00014611586811952293, 0.00033126657945103943, 0.00033980247098952532, 0.00036034223739989102, 0.0001708315103314817, 0.000439484603703022, 0.00023182375298347324, 0.00060454534832388163, 0.00032567448215559125, 0.0005372395389713347, 0.00019252095080446452, 0.00031781807774677873, 0.00030408179736696184, 0.00031450932146981359, 0.00032342475606128573, 0.00022140149667393416, 0.000239429427892901, 0.00021376670338213444, } };
const TfArray<48, int> quant36_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant36 = { (TfLiteFloatArray*)&quant36_scale, (TfLiteIntArray*)&quant36_zero, 0 };
const ALIGN(16) int8_t tensor_data37[48*1*1*8] = { 
  /* [0][0][][] */ -13,25,15,-25,-70,-37,-127,6, 
  /* [1][0][][] */ 70,-32,-11,-48,127,-103,34,-10, 
  /* [2][0][][] */ -70,121,-75,-127,52,20,-51,17, 
  /* [3][0][][] */ 38,22,85,49,88,124,127,-68, 
  /* [4][0][][] */ -95,-127,10,34,-13,-117,26,-68, 
  /* [5][0][][] */ 127,-21,113,91,-105,-20,-64,-2, 
  /* [6][0][][] */ 47,76,127,-30,81,-23,-9,15, 
  /* [7][0][][] */ 25,-11,-127,-32,-68,116,122,-66, 
  /* [8][0][][] */ -37,72,-41,40,19,127,-1,118, 
  /* [9][0][][] */ 20,104,18,71,27,-65,76,127, 
  /* [10][0][][] */ 14,-127,1,-22,-89,-84,-68,-100, 
  /* [11][0][][] */ -90,-104,127,76,-38,-86,47,50, 
  /* [12][0][][] */ -38,27,-127,93,13,-44,-123,77, 
  /* [13][0][][] */ 127,-93,116,45,14,2,52,-82, 
  /* [14][0][][] */ -9,127,-7,-91,-25,-119,-25,-51, 
  /* [15][0][][] */ 57,115,20,-62,57,-26,66,-127, 
  /* [16][0][][] */ -30,-86,-5,127,0,45,-22,53, 
  /* [17][0][][] */ -35,-127,-82,52,-62,87,-87,26, 
  /* [18][0][][] */ -126,-84,-101,20,-48,35,3,127, 
  /* [19][0][][] */ 40,-127,88,-121,-17,-103,20,-74, 
  /* [20][0][][] */ 18,51,-29,59,16,127,56,11, 
  /* [21][0][][] */ 6,119,48,-42,40,-80,76,-127, 
  /* [22][0][][] */ 1,-4,127,46,-27,88,44,-9, 
  /* [23][0][][] */ -59,-72,43,-33,67,62,-22,-127, 
  /* [24][0][][] */ -92,-119,62,-90,77,105,-34,-127, 
  /* [25][0][][] */ 127,20,-52,-42,47,41,-61,-15, 
  /* [26][0][][] */ -113,-36,-127,-29,-64,-33,2,18, 
  /* [27][0][][] */ 61,23,-15,-53,-127,-15,111,97, 
  /* [28][0][][] */ -123,-127,-99,23,-29,-111,33,40, 
  /* [29][0][][] */ 127,-2,64,-76,11,1,-50,-95, 
  /* [30][0][][] */ -84,-84,39,-87,45,93,-10,-127, 
  /* [31][0][][] */ 63,65,-18,127,15,-125,-19,2, 
  /* [32][0][][] */ -34,127,-8,43,25,85,-43,39, 
  /* [33][0][][] */ -14,127,-76,40,31,-22,-34,19, 
  /* [34][0][][] */ -118,-127,-23,127,-71,14,24,91, 
  /* [35][0][][] */ -27,127,-17,-28,61,84,50,52, 
  /* [36][0][][] */ 22,-4,-18,-4,-127,-12,40,89, 
  /* [37][0][][] */ -43,87,38,29,-127,73,-31,-79, 
  /* [38][0][][] */ 78,1,43,64,90,117,127,5, 
  /* [39][0][][] */ -19,-83,85,-23,15,53,-127,82, 
  /* [40][0][][] */ -121,-35,-127,115,2,-26,30,54, 
  /* [41][0][][] */ 116,66,37,127,-40,-41,29,-7, 
  /* [42][0][][] */ -46,8,-104,-118,95,-127,-11,42, 
  /* [43][0][][] */ 11,3,95,-12,54,127,76,0, 
  /* [44][0][][] */ -35,-7,-69,127,68,1,-85,-20, 
  /* [45][0][][] */ 3,127,49,-63,36,-63,-43,-2, 
  /* [46][0][][] */ -10,-127,9,44,-9,59,-93,127, 
  /* [47][0][][] */ 47,90,127,27,112,61,48,-16, 
};
const TfArray<4, int> tensor_dimension37 = { 4, { 48,1,1,8 } };
const TfArray<48, float> quant37_scale = { 48, { 0.0050733969546854496, 0.0048005119897425175, 0.0052482434548437595, 0.0033722626976668835, 0.00071221293183043599, 0.0037970647681504488, 0.0036549668293446302, 0.0014730008551850915, 0.0032064379192888737, 0.0065728812478482723, 0.0037478830199688673, 0.00254055205732584, 0.0024237148463726044, 0.0046379673294723034, 0.0042544174939393997, 0.0035980739630758762, 0.0027631255798041821, 0.0014089017640799284, 0.0019188096048310399, 0.0033070708159357309, 0.0054407278075814247, 0.0028117201291024685, 0.0047028246335685253, 0.0023897015489637852, 0.003172869561240077, 0.0067903175950050354, 0.0028737224638462067, 0.0055005350150167942, 0.0010602660477161407, 0.0013917129253968596, 0.0018004481680691242, 0.0040818857960402966, 0.0041870656423270702, 0.0044401576742529869, 0.0021049957722425461, 0.0054153543896973133, 0.0028565456159412861, 0.007449242752045393, 0.0040129795670509338, 0.0066198967397212982, 0.0023722541518509388, 0.0039161727763712406, 0.0037469132803380489, 0.0038754018023610115, 0.0039852582849562168, 0.0027281220536679029, 0.0029502632096409798, 0.0026340456679463387, } };
const TfArray<48, int> quant37_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant37 = { (TfLiteFloatArray*)&quant37_scale, (TfLiteIntArray*)&quant37_zero, 0 };
const ALIGN(16) int32_t tensor_data38[8] = { -5203, -2176, 11852, -9831, 19473, 4763, -7711, 11063, };
const TfArray<1, int> tensor_dimension38 = { 1, { 8 } };
const TfArray<8, float> quant38_scale = { 8, { 0.00016558979405090213, 0.00018418193212710321, 0.00017481489339843392, 0.00025650081806816161, 0.00022220230312086642, 0.00017773476429283619, 0.00010031621786765754, 0.00018766317225527018, } };
const TfArray<8, int> quant38_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant38 = { (TfLiteFloatArray*)&quant38_scale, (TfLiteIntArray*)&quant38_zero, 0 };
const ALIGN(16) int8_t tensor_data39[8*1*1*16] = { 
  /* [0][0][][] */ 18,-29,-24,-68,-56,-34,11,-40,25,-9,-60,-14,84,127,-14,-86, 
  /* [1][0][][] */ 127,-48,-59,8,-53,58,-85,-58,-55,96,-25,-29,-27,18,-34,-12, 
  /* [2][0][][] */ -13,-97,22,23,51,-41,-95,-23,37,-80,-3,-127,42,-12,-86,-15, 
  /* [3][0][][] */ 26,2,18,14,-10,70,-46,-19,127,63,42,-1,30,-32,-7,2, 
  /* [4][0][][] */ -57,-12,-21,-119,-21,11,22,-113,20,-44,-73,-11,-127,53,-27,-5, 
  /* [5][0][][] */ 89,27,58,-34,29,-41,-127,-116,4,-96,58,37,-35,38,64,-30, 
  /* [6][0][][] */ 93,69,-115,-95,57,-65,-50,-70,-43,41,-127,115,85,-94,30,111, 
  /* [7][0][][] */ -127,1,103,1,-61,9,-12,-46,-32,62,102,-24,39,-29,39,22, 
};
const TfArray<4, int> tensor_dimension39 = { 4, { 8,1,1,16 } };
const TfArray<8, float> quant39_scale = { 8, { 0.0070375660434365273, 0.0078277317807078362, 0.0074296328239142895, 0.010901284404098988, 0.0094435978680849075, 0.0075537273660302162, 0.0042634392157196999, 0.0079756844788789749, } };
const TfArray<8, int> quant39_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant39 = { (TfLiteFloatArray*)&quant39_scale, (TfLiteIntArray*)&quant39_zero, 0 };
const ALIGN(16) int32_t tensor_data40[16] = { 23487, -3086, -756, 1772, 1181, 3053, 6307, 2549, 234, -193, -634, 1337, 12222, -671, -1096, -2479, };
const TfArray<1, int> tensor_dimension40 = { 1, { 16 } };
const TfArray<16, float> quant40_scale = { 16, { 0.00010146793647436425, 0.00018918696150649339, 0.00021935357654001564, 0.00016964452515821904, 0.00081554293865337968, 0.00061223958618938923, 0.00028043458587490022, 0.00073360622627660632, 0.00039703564834780991, 0.00098803092259913683, 0.00046764980652369559, 0.00013071422290522605, 5.4607327911071479e-05, 0.000294483732432127, 0.00022424501366913319, 0.00028685256256721914, } };
const TfArray<16, int> quant40_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant40 = { (TfLiteFloatArray*)&quant40_scale, (TfLiteIntArray*)&quant40_zero, 0 };
const ALIGN(16) int8_t tensor_data41[1*3*3*16] = { 
  /* [0][0][][] */ 6,-5,16,28,-32,5,5,13,-7,-8,-1,7,-36,-5,-13,2, 14,-8,-27,17,6,-8,4,-32,-8,11,-14,66,-41,22,5,6, -9,-12,-35,20,-4,-20,-2,9,3,4,-12,-21,45,-3,-1,8, 
  /* [0][1][][] */ 7,8,-16,13,127,-32,-127,-26,127,127,-12,14,127,-22,18,-16, -127,127,127,2,-102,-102,-8,-109,9,-102,127,127,85,127,127,127, 21,4,-23,3,-12,127,26,-14,-11,-11,-14,-2,57,-4,-8,2, 
  /* [0][2][][] */ -11,30,-3,-13,-23,9,48,1,-13,-6,-10,26,-13,1,12,-6, 25,-6,-12,-127,8,-24,-17,127,-6,3,-5,7,-40,-58,-9,-27, 23,-2,-12,7,10,-11,-24,-6,-10,4,-10,16,44,-6,4,-2, 
};
const TfArray<4, int> tensor_dimension41 = { 4, { 1,3,3,16 } };
const TfArray<16, float> quant41_scale = { 16, { 0.0043123872019350529, 0.0080404458567500114, 0.0093225268647074699, 0.0072098919190466404, 0.034660574048757553, 0.02602018229663372, 0.011918469332158566, 0.031178263947367668, 0.016874015331268311, 0.041991312056779861, 0.019875116646289825, 0.0055553545244038105, 0.0023208113852888346, 0.012515558861196041, 0.0095304129645228386, 0.012191234156489372, } };
const TfArray<16, int> quant41_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant41 = { (TfLiteFloatArray*)&quant41_scale, (TfLiteIntArray*)&quant41_zero, 3 };
const ALIGN(16) int32_t tensor_data42[16] = { -3, 8633, -327, -4293, 25125, 85671, 1214, 957, 7325, -7023, 3231, 11133, 14132, -41881, 7005, 66909, };
const TfArray<1, int> tensor_dimension42 = { 1, { 16 } };
const TfArray<16, float> quant42_scale = { 16, { 0.00024206790840253234, 0.00045188257354311645, 0.00038767341175116599, 0.00024897712864913046, 6.2178223743103445e-05, 2.0614297682186589e-05, 0.00016125963884405792, 5.4550815548282117e-05, 0.0001686614123173058, 0.0001064281677827239, 0.00047313448158092797, 0.00023138253891374916, 0.00025169216678477824, 2.2422782421926968e-05, 0.00040379076381213963, 4.0275172068504617e-05, } };
const TfArray<16, int> quant42_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant42 = { (TfLiteFloatArray*)&quant42_scale, (TfLiteIntArray*)&quant42_zero, 0 };
const ALIGN(16) int8_t tensor_data43[16*3*3*1] = { 
  /* [0][0][][] */ -87, -108, -30, 
  /* [0][1][][] */ 65, -35, 16, 
  /* [0][2][][] */ 33, 127, 20, 
  /* [1][0][][] */ 93, -97, -17, 
  /* [1][1][][] */ -127, 92, 15, 
  /* [1][2][][] */ 6, -8, -19, 
  /* [2][0][][] */ -23, -1, -47, 
  /* [2][1][][] */ 37, 96, 127, 
  /* [2][2][][] */ -10, -93, -78, 
  /* [3][0][][] */ 122, 127, 62, 
  /* [3][1][][] */ 6, -17, -10, 
  /* [3][2][][] */ -95, -120, -38, 
  /* [4][0][][] */ 26, -32, 45, 
  /* [4][1][][] */ 31, -127, 35, 
  /* [4][2][][] */ 45, -60, 20, 
  /* [5][0][][] */ -75, 37, -14, 
  /* [5][1][][] */ -127, 31, -14, 
  /* [5][2][][] */ -69, 22, -26, 
  /* [6][0][][] */ -11, 82, 127, 
  /* [6][1][][] */ -44, 59, -9, 
  /* [6][2][][] */ -27, -43, -79, 
  /* [7][0][][] */ 35, 15, -25, 
  /* [7][1][][] */ 127, 32, -12, 
  /* [7][2][][] */ 9, -13, -25, 
  /* [8][0][][] */ -24, -34, 51, 
  /* [8][1][][] */ -58, -92, 127, 
  /* [8][2][][] */ -29, -65, 96, 
  /* [9][0][][] */ -15, 46, -12, 
  /* [9][1][][] */ 2, 127, -34, 
  /* [9][2][][] */ -19, 47, -28, 
  /* [10][0][][] */ 24, 86, 10, 
  /* [10][1][][] */ -38, -127, -31, 
  /* [10][2][][] */ 10, 38, 16, 
  /* [11][0][][] */ -2, -29, 0, 
  /* [11][1][][] */ 59, -110, 27, 
  /* [11][2][][] */ -99, 127, -57, 
  /* [12][0][][] */ -46, 39, -16, 
  /* [12][1][][] */ -127, 101, -1, 
  /* [12][2][][] */ -80, 68, -1, 
  /* [13][0][][] */ 86, 46, 32, 
  /* [13][1][][] */ 127, 116, 24, 
  /* [13][2][][] */ 66, 91, 34, 
  /* [14][0][][] */ -35, -33, 39, 
  /* [14][1][][] */ 35, 87, -127, 
  /* [14][2][][] */ -22, -73, 70, 
  /* [15][0][][] */ -97, -56, -32, 
  /* [15][1][][] */ -121, -127, -36, 
  /* [15][2][][] */ -18, -63, -21, 
};
const TfArray<4, int> tensor_dimension43 = { 4, { 16,3,3,1 } };
const TfArray<16, float> quant43_scale = { 16, { 0.061727311462163925, 0.11523004621267319, 0.098856717348098755, 0.063489161431789398, 0.015855446457862854, 0.0052566453814506531, 0.041121207177639008, 0.013910457491874695, 0.043008659034967422, 0.027139181271195412, 0.12064928561449051, 0.059002544730901718, 0.064181499183177948, 0.0057178093120455742, 0.10296663641929626, 0.010270168073475361, } };
const TfArray<16, int> quant43_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant43 = { (TfLiteFloatArray*)&quant43_scale, (TfLiteIntArray*)&quant43_zero, 0 };
const TfArray<4, int> tensor_dimension44 = { 4, { 1,60,60,16 } };
const TfArray<1, float> quant44_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant44_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant44 = { (TfLiteFloatArray*)&quant44_scale, (TfLiteIntArray*)&quant44_zero, 0 };
const TfArray<4, int> tensor_dimension45 = { 4, { 1,60,60,16 } };
const TfArray<1, float> quant45_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant45_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant45 = { (TfLiteFloatArray*)&quant45_scale, (TfLiteIntArray*)&quant45_zero, 0 };
const TfArray<4, int> tensor_dimension46 = { 4, { 1,60,60,8 } };
const TfArray<1, float> quant46_scale = { 1, { 0.081155277788639069, } };
const TfArray<1, int> quant46_zero = { 1, { 14 } };
const TfLiteAffineQuantization quant46 = { (TfLiteFloatArray*)&quant46_scale, (TfLiteIntArray*)&quant46_zero, 0 };
const TfArray<4, int> tensor_dimension47 = { 4, { 1,60,60,48 } };
const TfArray<1, float> quant47_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant47_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant47 = { (TfLiteFloatArray*)&quant47_scale, (TfLiteIntArray*)&quant47_zero, 0 };
const TfArray<4, int> tensor_dimension48 = { 4, { 1,61,61,48 } };
const TfArray<1, float> quant48_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant48_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant48 = { (TfLiteFloatArray*)&quant48_scale, (TfLiteIntArray*)&quant48_zero, 0 };
const TfArray<4, int> tensor_dimension49 = { 4, { 1,30,30,48 } };
const TfArray<1, float> quant49_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant49_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant49 = { (TfLiteFloatArray*)&quant49_scale, (TfLiteIntArray*)&quant49_zero, 0 };
const TfArray<4, int> tensor_dimension50 = { 4, { 1,30,30,8 } };
const TfArray<1, float> quant50_scale = { 1, { 0.075621247291564941, } };
const TfArray<1, int> quant50_zero = { 1, { -12 } };
const TfLiteAffineQuantization quant50 = { (TfLiteFloatArray*)&quant50_scale, (TfLiteIntArray*)&quant50_zero, 0 };
const TfArray<4, int> tensor_dimension51 = { 4, { 1,30,30,48 } };
const TfArray<1, float> quant51_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant51_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant51 = { (TfLiteFloatArray*)&quant51_scale, (TfLiteIntArray*)&quant51_zero, 0 };
const TfArray<4, int> tensor_dimension52 = { 4, { 1,30,30,48 } };
const TfArray<1, float> quant52_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant52_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant52 = { (TfLiteFloatArray*)&quant52_scale, (TfLiteIntArray*)&quant52_zero, 0 };
const TfArray<4, int> tensor_dimension53 = { 4, { 1,30,30,8 } };
const TfArray<1, float> quant53_scale = { 1, { 0.060087721794843674, } };
const TfArray<1, int> quant53_zero = { 1, { 16 } };
const TfLiteAffineQuantization quant53 = { (TfLiteFloatArray*)&quant53_scale, (TfLiteIntArray*)&quant53_zero, 0 };
const TfArray<4, int> tensor_dimension54 = { 4, { 1,30,30,8 } };
const TfArray<1, float> quant54_scale = { 1, { 0.097083762288093567, } };
const TfArray<1, int> quant54_zero = { 1, { -8 } };
const TfLiteAffineQuantization quant54 = { (TfLiteFloatArray*)&quant54_scale, (TfLiteIntArray*)&quant54_zero, 0 };
const TfArray<4, int> tensor_dimension55 = { 4, { 1,30,30,48 } };
const TfArray<1, float> quant55_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant55_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant55 = { (TfLiteFloatArray*)&quant55_scale, (TfLiteIntArray*)&quant55_zero, 0 };
const TfArray<4, int> tensor_dimension56 = { 4, { 1,31,31,48 } };
const TfArray<1, float> quant56_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant56_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant56 = { (TfLiteFloatArray*)&quant56_scale, (TfLiteIntArray*)&quant56_zero, 0 };
const TfArray<4, int> tensor_dimension57 = { 4, { 1,15,15,48 } };
const TfArray<1, float> quant57_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant57_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant57 = { (TfLiteFloatArray*)&quant57_scale, (TfLiteIntArray*)&quant57_zero, 0 };
const TfArray<4, int> tensor_dimension58 = { 4, { 1,15,15,16 } };
const TfArray<1, float> quant58_scale = { 1, { 0.065545454621315002, } };
const TfArray<1, int> quant58_zero = { 1, { -10 } };
const TfLiteAffineQuantization quant58 = { (TfLiteFloatArray*)&quant58_scale, (TfLiteIntArray*)&quant58_zero, 0 };
const TfArray<4, int> tensor_dimension59 = { 4, { 1,15,15,96 } };
const TfArray<1, float> quant59_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant59_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant59 = { (TfLiteFloatArray*)&quant59_scale, (TfLiteIntArray*)&quant59_zero, 0 };
const TfArray<4, int> tensor_dimension60 = { 4, { 1,15,15,96 } };
const TfArray<1, float> quant60_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant60_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant60 = { (TfLiteFloatArray*)&quant60_scale, (TfLiteIntArray*)&quant60_zero, 0 };
const TfArray<4, int> tensor_dimension61 = { 4, { 1,15,15,16 } };
const TfArray<1, float> quant61_scale = { 1, { 0.066360309720039368, } };
const TfArray<1, int> quant61_zero = { 1, { -22 } };
const TfLiteAffineQuantization quant61 = { (TfLiteFloatArray*)&quant61_scale, (TfLiteIntArray*)&quant61_zero, 0 };
const TfArray<4, int> tensor_dimension62 = { 4, { 1,15,15,16 } };
const TfArray<1, float> quant62_scale = { 1, { 0.088740222156047821, } };
const TfArray<1, int> quant62_zero = { 1, { -14 } };
const TfLiteAffineQuantization quant62 = { (TfLiteFloatArray*)&quant62_scale, (TfLiteIntArray*)&quant62_zero, 0 };
const TfArray<4, int> tensor_dimension63 = { 4, { 1,15,15,96 } };
const TfArray<1, float> quant63_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant63_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant63 = { (TfLiteFloatArray*)&quant63_scale, (TfLiteIntArray*)&quant63_zero, 0 };
const TfArray<4, int> tensor_dimension64 = { 4, { 1,15,15,96 } };
const TfArray<1, float> quant64_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant64_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant64 = { (TfLiteFloatArray*)&quant64_scale, (TfLiteIntArray*)&quant64_zero, 0 };
const TfArray<4, int> tensor_dimension65 = { 4, { 1,15,15,16 } };
const TfArray<1, float> quant65_scale = { 1, { 0.061477996408939362, } };
const TfArray<1, int> quant65_zero = { 1, { 39 } };
const TfLiteAffineQuantization quant65 = { (TfLiteFloatArray*)&quant65_scale, (TfLiteIntArray*)&quant65_zero, 0 };
const TfArray<4, int> tensor_dimension66 = { 4, { 1,15,15,16 } };
const TfArray<1, float> quant66_scale = { 1, { 0.10986270010471344, } };
const TfArray<1, int> quant66_zero = { 1, { 3 } };
const TfLiteAffineQuantization quant66 = { (TfLiteFloatArray*)&quant66_scale, (TfLiteIntArray*)&quant66_zero, 0 };
const TfArray<4, int> tensor_dimension67 = { 4, { 1,15,15,96 } };
const TfArray<1, float> quant67_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant67_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant67 = { (TfLiteFloatArray*)&quant67_scale, (TfLiteIntArray*)&quant67_zero, 0 };
const TfArray<4, int> tensor_dimension68 = { 4, { 1,15,15,32 } };
const TfArray<1, float> quant68_scale = { 1, { 0.063926413655281067, } };
const TfArray<1, int> quant68_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant68 = { (TfLiteFloatArray*)&quant68_scale, (TfLiteIntArray*)&quant68_zero, 0 };
const TfArray<4, int> tensor_dimension69 = { 4, { 1,15,15,6 } };
const TfArray<1, float> quant69_scale = { 1, { 0.10652835667133331, } };
const TfArray<1, int> quant69_zero = { 1, { -5 } };
const TfLiteAffineQuantization quant69 = { (TfLiteFloatArray*)&quant69_scale, (TfLiteIntArray*)&quant69_zero, 0 };
const TfArray<4, int> tensor_dimension70 = { 4, { 1,15,15,6 } };
const TfArray<1, float> quant70_scale = { 1, { 0.00390625, } };
const TfArray<1, int> quant70_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant70 = { (TfLiteFloatArray*)&quant70_scale, (TfLiteIntArray*)&quant70_zero, 0 };
const TfLiteConvParams opdata0 = { kTfLitePaddingSame, 2,2, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs0 = { 3, { 0,43,42 } };
const TfArray<1, int> outputs0 = { 1, { 44 } };
const TfLiteDepthwiseConvParams opdata1 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs1 = { 3, { 44,41,40 } };
const TfArray<1, int> outputs1 = { 1, { 45 } };
const TfLiteConvParams opdata2 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs2 = { 3, { 45,39,38 } };
const TfArray<1, int> outputs2 = { 1, { 46 } };
const TfLiteConvParams opdata3 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs3 = { 3, { 46,37,36 } };
const TfArray<1, int> outputs3 = { 1, { 47 } };
const TfArray<2, int> inputs4 = { 2, { 47,1 } };
const TfArray<1, int> outputs4 = { 1, { 48 } };
const TfLiteDepthwiseConvParams opdata5 = { kTfLitePaddingValid, 2,2, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs5 = { 3, { 48,35,34 } };
const TfArray<1, int> outputs5 = { 1, { 49 } };
const TfLiteConvParams opdata6 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs6 = { 3, { 49,33,32 } };
const TfArray<1, int> outputs6 = { 1, { 50 } };
const TfLiteConvParams opdata7 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs7 = { 3, { 50,31,30 } };
const TfArray<1, int> outputs7 = { 1, { 51 } };
const TfLiteDepthwiseConvParams opdata8 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs8 = { 3, { 51,29,28 } };
const TfArray<1, int> outputs8 = { 1, { 52 } };
const TfLiteConvParams opdata9 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs9 = { 3, { 52,27,26 } };
const TfArray<1, int> outputs9 = { 1, { 53 } };
const TfLiteAddParams opdata10 = { kTfLiteActNone };
const TfArray<2, int> inputs10 = { 2, { 50,53 } };
const TfArray<1, int> outputs10 = { 1, { 54 } };
const TfLiteConvParams opdata11 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs11 = { 3, { 54,25,24 } };
const TfArray<1, int> outputs11 = { 1, { 55 } };
const TfArray<2, int> inputs12 = { 2, { 55,1 } };
const TfArray<1, int> outputs12 = { 1, { 56 } };
const TfLiteDepthwiseConvParams opdata13 = { kTfLitePaddingValid, 2,2, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs13 = { 3, { 56,23,22 } };
const TfArray<1, int> outputs13 = { 1, { 57 } };
const TfLiteConvParams opdata14 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs14 = { 3, { 57,21,20 } };
const TfArray<1, int> outputs14 = { 1, { 58 } };
const TfLiteConvParams opdata15 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs15 = { 3, { 58,19,18 } };
const TfArray<1, int> outputs15 = { 1, { 59 } };
const TfLiteDepthwiseConvParams opdata16 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs16 = { 3, { 59,17,16 } };
const TfArray<1, int> outputs16 = { 1, { 60 } };
const TfLiteConvParams opdata17 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs17 = { 3, { 60,15,14 } };
const TfArray<1, int> outputs17 = { 1, { 61 } };
const TfLiteAddParams opdata18 = { kTfLiteActNone };
const TfArray<2, int> inputs18 = { 2, { 58,61 } };
const TfArray<1, int> outputs18 = { 1, { 62 } };
const TfLiteConvParams opdata19 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs19 = { 3, { 62,13,12 } };
const TfArray<1, int> outputs19 = { 1, { 63 } };
const TfLiteDepthwiseConvParams opdata20 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs20 = { 3, { 63,11,10 } };
const TfArray<1, int> outputs20 = { 1, { 64 } };
const TfLiteConvParams opdata21 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs21 = { 3, { 64,9,8 } };
const TfArray<1, int> outputs21 = { 1, { 65 } };
const TfLiteAddParams opdata22 = { kTfLiteActNone };
const TfArray<2, int> inputs22 = { 2, { 62,65 } };
const TfArray<1, int> outputs22 = { 1, { 66 } };
const TfLiteConvParams opdata23 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs23 = { 3, { 66,7,6 } };
const TfArray<1, int> outputs23 = { 1, { 67 } };
const TfLiteConvParams opdata24 = { kTfLitePaddingValid, 1,1, kTfLiteActRelu, 1,1 };
const TfArray<3, int> inputs24 = { 3, { 67,5,4 } };
const TfArray<1, int> outputs24 = { 1, { 68 } };
const TfLiteConvParams opdata25 = { kTfLitePaddingValid, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs25 = { 3, { 68,3,2 } };
const TfArray<1, int> outputs25 = { 1, { 69 } };
const TfLiteSoftmaxParams opdata26 = { 1 };
const TfArray<1, int> inputs26 = { 1, { 69 } };
const TfArray<1, int> outputs26 = { 1, { 70 } };
const TensorInfo_t tensorData[] = {
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension0, 14400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant0))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data1, (TfLiteIntArray*)&tensor_dimension1, 32, {kTfLiteNoQuantization, nullptr}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data2, (TfLiteIntArray*)&tensor_dimension2, 24, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant2))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data3, (TfLiteIntArray*)&tensor_dimension3, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant3))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data4, (TfLiteIntArray*)&tensor_dimension4, 128, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant4))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data5, (TfLiteIntArray*)&tensor_dimension5, 3072, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant5))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data6, (TfLiteIntArray*)&tensor_dimension6, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant6))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data7, (TfLiteIntArray*)&tensor_dimension7, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant7))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data8, (TfLiteIntArray*)&tensor_dimension8, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant8))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data9, (TfLiteIntArray*)&tensor_dimension9, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant9))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data10, (TfLiteIntArray*)&tensor_dimension10, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant10))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data11, (TfLiteIntArray*)&tensor_dimension11, 864, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant11))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data12, (TfLiteIntArray*)&tensor_dimension12, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant12))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data13, (TfLiteIntArray*)&tensor_dimension13, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant13))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data14, (TfLiteIntArray*)&tensor_dimension14, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant14))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data15, (TfLiteIntArray*)&tensor_dimension15, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant15))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data16, (TfLiteIntArray*)&tensor_dimension16, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant16))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data17, (TfLiteIntArray*)&tensor_dimension17, 864, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant17))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data18, (TfLiteIntArray*)&tensor_dimension18, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant18))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data19, (TfLiteIntArray*)&tensor_dimension19, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant19))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data20, (TfLiteIntArray*)&tensor_dimension20, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant20))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data21, (TfLiteIntArray*)&tensor_dimension21, 768, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant21))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data22, (TfLiteIntArray*)&tensor_dimension22, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant22))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data23, (TfLiteIntArray*)&tensor_dimension23, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant23))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data24, (TfLiteIntArray*)&tensor_dimension24, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant24))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data25, (TfLiteIntArray*)&tensor_dimension25, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant25))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data26, (TfLiteIntArray*)&tensor_dimension26, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant26))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data27, (TfLiteIntArray*)&tensor_dimension27, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant27))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data28, (TfLiteIntArray*)&tensor_dimension28, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant28))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data29, (TfLiteIntArray*)&tensor_dimension29, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant29))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data30, (TfLiteIntArray*)&tensor_dimension30, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant30))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data31, (TfLiteIntArray*)&tensor_dimension31, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant31))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data32, (TfLiteIntArray*)&tensor_dimension32, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant32))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data33, (TfLiteIntArray*)&tensor_dimension33, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant33))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data34, (TfLiteIntArray*)&tensor_dimension34, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant34))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data35, (TfLiteIntArray*)&tensor_dimension35, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant35))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data36, (TfLiteIntArray*)&tensor_dimension36, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant36))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data37, (TfLiteIntArray*)&tensor_dimension37, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant37))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data38, (TfLiteIntArray*)&tensor_dimension38, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant38))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data39, (TfLiteIntArray*)&tensor_dimension39, 128, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant39))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data40, (TfLiteIntArray*)&tensor_dimension40, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant40))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data41, (TfLiteIntArray*)&tensor_dimension41, 144, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant41))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data42, (TfLiteIntArray*)&tensor_dimension42, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant42))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data43, (TfLiteIntArray*)&tensor_dimension43, 144, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant43))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 57600, (TfLiteIntArray*)&tensor_dimension44, 57600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant44))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension45, 57600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant45))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 57600, (TfLiteIntArray*)&tensor_dimension46, 28800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant46))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 178608, (TfLiteIntArray*)&tensor_dimension47, 172800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant47))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension48, 178608, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant48))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 178608, (TfLiteIntArray*)&tensor_dimension49, 43200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant49))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 86400, (TfLiteIntArray*)&tensor_dimension50, 7200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant50))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 43200, (TfLiteIntArray*)&tensor_dimension51, 43200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant51))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension52, 43200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant52))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 43200, (TfLiteIntArray*)&tensor_dimension53, 7200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant53))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension54, 7200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant54))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 46128, (TfLiteIntArray*)&tensor_dimension55, 43200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant55))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension56, 46128, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant56))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 46128, (TfLiteIntArray*)&tensor_dimension57, 10800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant57))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 56928, (TfLiteIntArray*)&tensor_dimension58, 3600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant58))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 21600, (TfLiteIntArray*)&tensor_dimension59, 21600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant59))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension60, 21600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant60))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 21600, (TfLiteIntArray*)&tensor_dimension61, 3600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant61))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 43200, (TfLiteIntArray*)&tensor_dimension62, 3600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant62))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 21600, (TfLiteIntArray*)&tensor_dimension63, 21600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant63))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension64, 21600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant64))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 25200, (TfLiteIntArray*)&tensor_dimension65, 3600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant65))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 21600, (TfLiteIntArray*)&tensor_dimension66, 3600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant66))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension67, 21600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant67))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 21600, (TfLiteIntArray*)&tensor_dimension68, 7200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant68))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 1360, (TfLiteIntArray*)&tensor_dimension69, 1350, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant69))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension70, 1350, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant70))}, },
};const NodeInfo_t nodeData[] = {
  { (TfLiteIntArray*)&inputs0, (TfLiteIntArray*)&outputs0, const_cast<void*>(static_cast<const void*>(&opdata0)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs1, (TfLiteIntArray*)&outputs1, const_cast<void*>(static_cast<const void*>(&opdata1)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs2, (TfLiteIntArray*)&outputs2, const_cast<void*>(static_cast<const void*>(&opdata2)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs3, (TfLiteIntArray*)&outputs3, const_cast<void*>(static_cast<const void*>(&opdata3)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs4, (TfLiteIntArray*)&outputs4, nullptr, OP_PAD, },
  { (TfLiteIntArray*)&inputs5, (TfLiteIntArray*)&outputs5, const_cast<void*>(static_cast<const void*>(&opdata5)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs6, (TfLiteIntArray*)&outputs6, const_cast<void*>(static_cast<const void*>(&opdata6)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs7, (TfLiteIntArray*)&outputs7, const_cast<void*>(static_cast<const void*>(&opdata7)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs8, (TfLiteIntArray*)&outputs8, const_cast<void*>(static_cast<const void*>(&opdata8)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs9, (TfLiteIntArray*)&outputs9, const_cast<void*>(static_cast<const void*>(&opdata9)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs10, (TfLiteIntArray*)&outputs10, const_cast<void*>(static_cast<const void*>(&opdata10)), OP_ADD, },
  { (TfLiteIntArray*)&inputs11, (TfLiteIntArray*)&outputs11, const_cast<void*>(static_cast<const void*>(&opdata11)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs12, (TfLiteIntArray*)&outputs12, nullptr, OP_PAD, },
  { (TfLiteIntArray*)&inputs13, (TfLiteIntArray*)&outputs13, const_cast<void*>(static_cast<const void*>(&opdata13)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs14, (TfLiteIntArray*)&outputs14, const_cast<void*>(static_cast<const void*>(&opdata14)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs15, (TfLiteIntArray*)&outputs15, const_cast<void*>(static_cast<const void*>(&opdata15)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs16, (TfLiteIntArray*)&outputs16, const_cast<void*>(static_cast<const void*>(&opdata16)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs17, (TfLiteIntArray*)&outputs17, const_cast<void*>(static_cast<const void*>(&opdata17)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs18, (TfLiteIntArray*)&outputs18, const_cast<void*>(static_cast<const void*>(&opdata18)), OP_ADD, },
  { (TfLiteIntArray*)&inputs19, (TfLiteIntArray*)&outputs19, const_cast<void*>(static_cast<const void*>(&opdata19)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs20, (TfLiteIntArray*)&outputs20, const_cast<void*>(static_cast<const void*>(&opdata20)), OP_DEPTHWISE_CONV_2D, },
  { (TfLiteIntArray*)&inputs21, (TfLiteIntArray*)&outputs21, const_cast<void*>(static_cast<const void*>(&opdata21)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs22, (TfLiteIntArray*)&outputs22, const_cast<void*>(static_cast<const void*>(&opdata22)), OP_ADD, },
  { (TfLiteIntArray*)&inputs23, (TfLiteIntArray*)&outputs23, const_cast<void*>(static_cast<const void*>(&opdata23)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs24, (TfLiteIntArray*)&outputs24, const_cast<void*>(static_cast<const void*>(&opdata24)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs25, (TfLiteIntArray*)&outputs25, const_cast<void*>(static_cast<const void*>(&opdata25)), OP_CONV_2D, },
  { (TfLiteIntArray*)&inputs26, (TfLiteIntArray*)&outputs26, const_cast<void*>(static_cast<const void*>(&opdata26)), OP_SOFTMAX, },
};

static void init_tflite_tensor(size_t i, TfLiteTensor *tensor) {
  tensor->type = tensorData[i].type;
  tensor->is_variable = 0;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  tensor->allocation_type = tensorData[i].allocation_type;
#else
  tensor->allocation_type = (tensor_arena <= tensorData[i].data && tensorData[i].data < tensor_arena + kTensorArenaSize) ? kTfLiteArenaRw : kTfLiteMmapRo;
#endif
  tensor->bytes = tensorData[i].bytes;
  tensor->dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  if(tensor->allocation_type == kTfLiteArenaRw){
    uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

    tensor->data.data =  start;
  }
  else {
      tensor->data.data = tensorData[i].data;
  }
#else
  tensor->data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
  tensor->quantization = tensorData[i].quantization;
  if (tensor->quantization.type == kTfLiteAffineQuantization) {
    TfLiteAffineQuantization const* quant = ((TfLiteAffineQuantization const*)(tensorData[i].quantization.params));
    tensor->params.scale = quant->scale->data[0];
    tensor->params.zero_point = quant->zero_point->data[0];
  }

}

static void init_tflite_eval_tensor(int i, TfLiteEvalTensor *tensor) {

  tensor->type = tensorData[i].type;

  tensor->dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  auto allocation_type = tensorData[i].allocation_type;
  if(allocation_type == kTfLiteArenaRw) {
    uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

    tensor->data.data =  start;
  }
  else {
    tensor->data.data = tensorData[i].data;
  }
#else
  tensor->data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
}

static void* overflow_buffers[EI_MAX_OVERFLOW_BUFFER_COUNT];
static size_t overflow_buffers_ix = 0;
static void * AllocatePersistentBufferImpl(struct TfLiteContext* ctx,
                                       size_t bytes) {
  void *ptr;
  uint32_t align_bytes = (bytes % 16) ? 16 - (bytes % 16) : 0;

  if (current_location - (bytes + align_bytes) < tensor_boundary) {
    if (overflow_buffers_ix > EI_MAX_OVERFLOW_BUFFER_COUNT - 1) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d, does not fit in tensor arena and reached EI_MAX_OVERFLOW_BUFFER_COUNT\n",
        (int)bytes);
      return NULL;
    }

    // OK, this will look super weird, but.... we have CMSIS-NN buffers which
    // we cannot calculate beforehand easily.
    ptr = ei_calloc(bytes, 1);
    if (ptr == NULL) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d\n", (int)bytes);
      return NULL;
    }
    overflow_buffers[overflow_buffers_ix++] = ptr;
    return ptr;
  }

  current_location -= bytes;

  // align to the left aligned boundary of 16 bytes
  current_location -= 15; // for alignment
  current_location += 16 - ((uintptr_t)(current_location) & 15);

  ptr = current_location;
  memset(ptr, 0, bytes);

  return ptr;
}
typedef struct {
  size_t bytes;
  void *ptr;
} scratch_buffer_t;
static scratch_buffer_t scratch_buffers[EI_MAX_SCRATCH_BUFFER_COUNT];
static size_t scratch_buffers_ix = 0;

static TfLiteStatus RequestScratchBufferInArenaImpl(struct TfLiteContext* ctx, size_t bytes,
                                                int* buffer_idx) {
  if (scratch_buffers_ix > EI_MAX_SCRATCH_BUFFER_COUNT - 1) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d, reached EI_MAX_SCRATCH_BUFFER_COUNT\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffer_t b;
  b.bytes = bytes;

  b.ptr = AllocatePersistentBufferImpl(ctx, b.bytes);
  if (!b.ptr) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffers[scratch_buffers_ix] = b;
  *buffer_idx = scratch_buffers_ix;

  scratch_buffers_ix++;

  return kTfLiteOk;
}

static void* GetScratchBufferImpl(struct TfLiteContext* ctx, int buffer_idx) {
  if (buffer_idx > (int)scratch_buffers_ix) {
    return NULL;
  }
  return scratch_buffers[buffer_idx].ptr;
}

static const uint16_t TENSOR_IX_UNUSED = 0x7FFF;

static void ResetTensors() {
  for (size_t ix = 0; ix < MAX_TFL_TENSOR_COUNT; ix++) {
    tflTensors[ix].index = TENSOR_IX_UNUSED;
  }
  for (size_t ix = 0; ix < MAX_TFL_EVAL_COUNT; ix++) {
    tflEvalTensors[ix].index = TENSOR_IX_UNUSED;
  }
}

static TfLiteTensor* GetTensorImpl(const struct TfLiteContext* context,
                               int tensor_idx) {

  for (size_t ix = 0; ix < MAX_TFL_TENSOR_COUNT; ix++) {
    // already used? OK!
    if (tflTensors[ix].index == tensor_idx) {
      return &tflTensors[ix].tensor;
    }
    // passed all the ones we've used, so end of the list?
    if (tflTensors[ix].index == TENSOR_IX_UNUSED) {
      // init the tensor
      init_tflite_tensor(tensor_idx, &tflTensors[ix].tensor);
      tflTensors[ix].index = tensor_idx;
      return &tflTensors[ix].tensor;
    }
  }

  ei_printf("ERR: GetTensor called beyond MAX_TFL_TENSOR_COUNT (%d)\n", MAX_TFL_TENSOR_COUNT);
  return nullptr;
}

static TfLiteEvalTensor* GetEvalTensorImpl(const struct TfLiteContext* context,
                                       int tensor_idx) {

  for (size_t ix = 0; ix < MAX_TFL_EVAL_COUNT; ix++) {
    // already used? OK!
    if (tflEvalTensors[ix].index == tensor_idx) {
      return &tflEvalTensors[ix].tensor;
    }
    // passed all the ones we've used, so end of the list?
    if (tflEvalTensors[ix].index == TENSOR_IX_UNUSED) {
      // init the tensor
      init_tflite_eval_tensor(tensor_idx, &tflEvalTensors[ix].tensor);
      tflEvalTensors[ix].index = tensor_idx;
      return &tflEvalTensors[ix].tensor;
    }
  }

  ei_printf("ERR: GetTensor called beyond MAX_TFL_EVAL_COUNT (%d)\n", (int)MAX_TFL_EVAL_COUNT);
  return nullptr;
}

class EonMicroContext : public MicroContext {
 public:
  EonMicroContext(): MicroContext(nullptr, nullptr, nullptr) { }

  void* AllocatePersistentBuffer(size_t bytes) {
    return AllocatePersistentBufferImpl(nullptr, bytes);
  };
  TfLiteStatus RequestScratchBufferInArena(size_t bytes,
                                           int* buffer_index) {
  return RequestScratchBufferInArenaImpl(nullptr, bytes, buffer_index);
  }
  void* GetScratchBuffer(int buffer_index) {
    return GetScratchBufferImpl(nullptr, buffer_index);
  }

  TfLiteTensor* AllocateTempTfLiteTensor(int tensor_index) {
    return GetTensorImpl(nullptr, tensor_index);
  }
  void DeallocateTempTfLiteTensor(TfLiteTensor* tensor) {
    return;
  }
  bool IsAllTempTfLiteTensorDeallocated() {
    return true;
  }

  TfLiteEvalTensor* GetEvalTensor(int tensor_index) {
    return GetEvalTensorImpl(nullptr, tensor_index);
  }
};

} // namespace

TfLiteStatus tflite_learn_5_init( void*(*alloc_fnc)(size_t,size_t) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  tensor_arena = (uint8_t*) alloc_fnc(16, kTensorArenaSize);
  if (!tensor_arena) {
    ei_printf("ERR: failed to allocate tensor arena\n");
    return kTfLiteError;
  }
#else
  memset(tensor_arena, 0, kTensorArenaSize);
#endif
  tensor_boundary = tensor_arena;
  current_location = tensor_arena + kTensorArenaSize;

  EonMicroContext micro_context_;
  ctx.impl_ = static_cast<void*>(&micro_context_);
  ctx.AllocatePersistentBuffer = &AllocatePersistentBufferImpl;
  ctx.RequestScratchBufferInArena = &RequestScratchBufferInArenaImpl;
  ctx.GetScratchBuffer = &GetScratchBufferImpl;
  ctx.GetTensor = &GetTensorImpl;
  ctx.GetEvalTensor = &GetEvalTensorImpl;
  ctx.tensors_size = 71;
  for (size_t i = 0; i < 71; ++i) {
    TfLiteTensor tensor;
    init_tflite_tensor(i, &tensor);
    if (tensor.allocation_type == kTfLiteArenaRw) {
      auto data_end_ptr = (uint8_t*)tensor.data.data + tensorData[i].bytes;
      if (data_end_ptr > tensor_boundary) {
        tensor_boundary = data_end_ptr;
      }
    }
  }
  if (tensor_boundary > current_location /* end of arena size */) {
    ei_printf("ERR: tensor arena is too small, does not fit model - even without scratch buffers\n");
    return kTfLiteError;
  }
  registrations[OP_CONV_2D] = Register_CONV_2D();
  registrations[OP_DEPTHWISE_CONV_2D] = Register_DEPTHWISE_CONV_2D();
  registrations[OP_PAD] = Register_PAD();
  registrations[OP_ADD] = Register_ADD();
  registrations[OP_SOFTMAX] = Register_SOFTMAX();

  for (size_t i = 0; i < 27; ++i) {
    tflNodes[i].inputs = nodeData[i].inputs;
    tflNodes[i].outputs = nodeData[i].outputs;
    tflNodes[i].builtin_data = nodeData[i].builtin_data;
tflNodes[i].custom_initial_data = nullptr;
      tflNodes[i].custom_initial_data_size = 0;
if (registrations[nodeData[i].used_op_index].init) {
      tflNodes[i].user_data = registrations[nodeData[i].used_op_index].init(&ctx, (const char*)tflNodes[i].builtin_data, 0);
    }
  }
  for (size_t i = 0; i < 27; ++i) {
    if (registrations[nodeData[i].used_op_index].prepare) {
      ResetTensors();

      TfLiteStatus status = registrations[nodeData[i].used_op_index].prepare(&ctx, &tflNodes[i]);
      if (status != kTfLiteOk) {
        return status;
      }
    }
  }
  return kTfLiteOk;
}

static const int inTensorIndices[] = {
  0, 
};
TfLiteStatus tflite_learn_5_input(int index, TfLiteTensor *tensor) {
  init_tflite_tensor(inTensorIndices[index], tensor);
  return kTfLiteOk;
}

static const int outTensorIndices[] = {
  70, 
};
TfLiteStatus tflite_learn_5_output(int index, TfLiteTensor *tensor) {
  init_tflite_tensor(outTensorIndices[index], tensor);
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_5_invoke() {
  for (size_t i = 0; i < 27; ++i) {
    ResetTensors();

    TfLiteStatus status = registrations[nodeData[i].used_op_index].invoke(&ctx, &tflNodes[i]);

#if EI_CLASSIFIER_PRINT_STATE
    ei_printf("layer %lu\n", i);
    ei_printf("    inputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].inputs->size; ix++) {
      auto d = tensorData[tflNodes[i].inputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");

    ei_printf("    outputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].outputs->size; ix++) {
      auto d = tensorData[tflNodes[i].outputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");
#endif // EI_CLASSIFIER_PRINT_STATE

    if (status != kTfLiteOk) {
      return status;
    }
  }
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_5_reset( void (*free_fnc)(void* ptr) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  free_fnc(tensor_arena);
#endif

  // scratch buffers are allocated within the arena, so just reset the counter so memory can be reused
  scratch_buffers_ix = 0;

  // overflow buffers are on the heap, so free them first
  for (size_t ix = 0; ix < overflow_buffers_ix; ix++) {
    ei_free(overflow_buffers[ix]);
  }
  overflow_buffers_ix = 0;
  return kTfLiteOk;
}
