/* Generated by Edge Impulse
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
// Generated on: 12.01.2024 19:35:34

#include <stdio.h>
#include <stdlib.h>
#include "edge-impulse-sdk/tensorflow/lite/c/builtin_op_data.h"
#include "edge-impulse-sdk/tensorflow/lite/c/common.h"
#include "edge-impulse-sdk/tensorflow/lite/micro/micro_mutable_op_resolver.h"
#include "edge-impulse-sdk/porting/ei_classifier_porting.h"

#if EI_CLASSIFIER_PRINT_STATE
#if defined(__cplusplus) && EI_C_LINKAGE == 1
extern "C" {
    extern void ei_printf(const char *format, ...);
}
#else
extern void ei_printf(const char *format, ...);
#endif
#endif

#if defined __GNUC__
#define ALIGN(X) __attribute__((aligned(X)))
#elif defined _MSC_VER
#define ALIGN(X) __declspec(align(X))
#elif defined __TASKING__
#define ALIGN(X) __align(X)
#elif defined __ICCARM__
#define ALIGN(x) __attribute__((aligned(x)))
#endif

#ifndef EI_MAX_SCRATCH_BUFFER_COUNT
#ifndef CONFIG_IDF_TARGET_ESP32S3
#define EI_MAX_SCRATCH_BUFFER_COUNT 4
#else
#define EI_MAX_SCRATCH_BUFFER_COUNT 8
#endif // CONFIG_IDF_TARGET_ESP32S3
#endif // EI_MAX_SCRATCH_BUFFER_COUNT

#ifndef EI_MAX_OVERFLOW_BUFFER_COUNT
#define EI_MAX_OVERFLOW_BUFFER_COUNT 10
#endif // EI_MAX_OVERFLOW_BUFFER_COUNT

using namespace tflite;
using namespace tflite::ops;
using namespace tflite::ops::micro;

namespace {

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX) || defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
constexpr int kTensorArenaSize = 18128;
#else
constexpr int kTensorArenaSize = 17104;
#endif

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX)
#pragma Bss(".tensor_arena")
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#pragma Bss()
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16) __attribute__((section(".tensor_arena")));
#else
#define EI_CLASSIFIER_ALLOCATION_HEAP 1
uint8_t* tensor_arena = NULL;
#endif

static uint8_t* tensor_boundary;
static uint8_t* current_location;

template <int SZ, class T> struct TfArray {
  int sz; T elem[SZ];
};
enum used_operators_e {
  OP_RESHAPE, OP_CONV_2D, OP_MAX_POOL_2D, OP_FULLY_CONNECTED, OP_SOFTMAX,  OP_LAST
};
struct TensorInfo_t { // subset of TfLiteTensor used for initialization from constant memory
  TfLiteAllocationType allocation_type;
  TfLiteType type;
  void* data;
  TfLiteIntArray* dims;
  size_t bytes;
  TfLiteQuantization quantization;
};

typedef struct {
  TfLiteTensor tensor;
  int16_t index;
} TfLiteTensorWithIndex;

typedef struct {
  TfLiteEvalTensor tensor;
  int16_t index;
} TfLiteEvalTensorWithIndex;

TfLiteContext ctx{};
static const int MAX_TFL_TENSOR_COUNT = 4;
static TfLiteTensorWithIndex tflTensors[MAX_TFL_TENSOR_COUNT];
static const int MAX_TFL_EVAL_COUNT = 4;
static TfLiteEvalTensorWithIndex tflEvalTensors[MAX_TFL_EVAL_COUNT];
TfLiteRegistration registrations[OP_LAST];

const TfArray<2, int> tensor_dimension0 = { 2, { 1,7960 } };
const TfArray<1, float> quant0_scale = { 1, { 0.0021599265746772289, } };
const TfArray<1, int> quant0_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant0 = { (TfLiteFloatArray*)&quant0_scale, (TfLiteIntArray*)&quant0_zero, 0 };
const ALIGN(16) int32_t tensor_data1[4] = { 1, 1, 199, 40, };
const TfArray<1, int> tensor_dimension1 = { 1, { 4 } };
const ALIGN(16) int32_t tensor_data2[4] = { 1, 199, 1, 8, };
const TfArray<1, int> tensor_dimension2 = { 1, { 4 } };
const ALIGN(16) int32_t tensor_data3[4] = { 1, 1, 100, 8, };
const TfArray<1, int> tensor_dimension3 = { 1, { 4 } };
const ALIGN(16) int32_t tensor_data4[4] = { 1, 100, 1, 16, };
const TfArray<1, int> tensor_dimension4 = { 1, { 4 } };
const ALIGN(8) int32_t tensor_data5[2] = { -1, 800, };
const TfArray<1, int> tensor_dimension5 = { 1, { 2 } };
const ALIGN(8) int32_t tensor_data6[2] = { 6859, -6859, };
const TfArray<1, int> tensor_dimension6 = { 1, { 2 } };
const TfArray<1, float> quant6_scale = { 1, { 1.3429950740828644e-05, } };
const TfArray<1, int> quant6_zero = { 1, { 0 } };
const TfLiteAffineQuantization quant6 = { (TfLiteFloatArray*)&quant6_scale, (TfLiteIntArray*)&quant6_zero, 0 };
const ALIGN(16) int8_t tensor_data7[2*800] = { 
  87, -39, 2, 1, 99, -89, 24, 14, -44, 65, -96, -91, 17, 117, 63, 67, 67, 40, 36, -21, 56, -39, 48, 92, 0, 50, -14, -65, 54, 90, 32, 94, 31, 91, 43, -6, 2, -101, 51, 89, 35, 112, -112, -42, 29, 85, 67, 48, 58, -11, 22, -57, 103, -100, 87, 71, -44, 22, -38, -52, 26, 73, 52, 82, 40, 27, 46, 11, 3, -17, 47, 95, 15, 63, -63, -104, 70, 40, 62, 61, 60, 17, -69, -79, 53, -55, 58, 106, 16, 35, -60, -64, 83, 56, 25, 41, 61, 38, -19, -76, -8, -63, 32, 70, -36, 16, -88, -53, -2, 26, 92, -7, -26, 22, -80, -15, 45, -38, 24, 29, -65, -26, -55, -29, 66, 61, 113, -7, 49, 7, -94, -33, 20, -63, 51, 31, -86, 5, -49, -61, 100, 113, 59, 28, -38, -71, -65, -35, 44, -19, 24, 55, -81, -30, -57, -90, 31, 118, 50, 32, -16, -14, -56, -73, -12, -82, 54, 101, -41, -66, -81, -77, 54, 113, 95, 13, 8, -75, 0, -22, 44, -26, 78, 83, -37, -56, -95, -106, 9, 99, 41, 8, 35, -10, -18, -74, 60, -59, 83, 103, -56, -16, -32, -111, 64, 51, 37, 73, -28, -10, -54, -13, 4, -60, 59, 80, -71, -17, -51, -95, 73, 93, 116, 66, 8, 17, -5, -31, 42, -85, 33, 68, 19, 32, -20, -106, 30, 114, 60, 111, 46, 0, 17, -80, 49, -57, 31, 48, -32, 24, -59, -90, 40, 103, 91, 42, 34, 53, 18, -42, 1, -29, 19, 66, -40, 49, -94, -29, 90, 97, 109, 34, 61, -11, 20, -69, 25, -94, 71, 78, -40, -9, -107, -36, 57, 101, 104, 114, 68, 79, -38, -36, 60, -87, 75, 99, -44, 33, -34, -27, 39, 97, 29, 72, 5, 1, 15, -66, 63, -39, 28, 56, -59, -21, -107, -88, 99, 59, 109, 13, 1, -58, -21, -84, 72, -43, 86, 85, -67, 1, -68, -23, 70, 97, 67, 90, -53, -46, -35, -55, 48, -22, 81, 27, -60, -8, -90, -90, 71, 109, 80, 28, 20, 5, -63, -92, 12, -109, 34, 42, -56, -28, -46, -117, -26, 109, 110, 56, 35, -74, -47, -34, 59, -7, -8, 38, -26, 20, -20, -78, 12, 64, 55, -14, -31, -67, -74, -10, 67, -82, -16, 104, -93, -17, -97, -41, -43, 60, 83, 52, -62, 34, -20, -68, 10, -60, 35, 92, -77, -24, -15, -56, 42, 71, 57, 42, -54, -9, -68, -111, -13, -95, 89, 46, -16, -29, -43, -87, 21, 39, 56, -7, -37, -48, -79, -16, 0, -89, 12, 42, -60, 11, -82, -73, 28, 67, 38, 17, 21, -74, -26, -81, -16, -38, 5, 110, -86, 7, -37, -39, -1, 34, 24, 9, -3, 9, -26, -111, 51, -27, 59, 58, -61, 28, -52, -99, 17, 66, 105, 91, 54, -38, 16, -34, 11, -24, 83, 40, -51, -43, -81, -67, 17, 87, 119, 50, -16, -35, 23, -13, -4, -70, 72, 75, -62, 43, -101, -106, 66, 20, 39, 94, 12, 32, -54, -16, 65, -104, 38, 58, -4, 9, -35, -42, 3, 102, 98, 30, -21, -5, -45, -92, 38, -61, 79, 80, -6, -33, -23, -66, 32, 55, 76, 26, 30, -66, -68, -38, 45, -70, 13, 115, -75, 1, -92, -43, 72, 110, 117, 27, -6, -42, -62, -82, 37, -61, 53, 49, -55, -39, -113, -78, 59, 60, 55, 63, -32, -62, -24, -52, 33, -72, -5, 54, -78, -17, -80, -112, 5, 53, 62, 27, 15, -64, -60, -25, 11, -89, 67, 43, -30, -79, -92, -111, 11, 35, 76, 52, -36, -58, -70, -56, -33, -73, 71, 16, -69, 29, -50, -95, 105, 86, 107, 19, 44, -10, -88, -68, 67, -52, 24, 60, -72, 34, -83, -42, -29, 42, 105, 104, 21, -49, -83, -88, 23, -17, 12, 49, -50, 5, -46, -117, 74, 61, 116, 84, 0, -45, -60, 20, 61, -79, 26, 39, -54, -11, -66, -59, 3, 63, 58, 64, -6, -95, -30, -66, 103, -62, 85, 70, -54, 19, -94, -91, 11, 95, 65, 49, -26, -58, -70, -45, 23, -80, 86, 44, -6, 1, -53, -63, 90, 119, 77, 96, 61, -20, -30, -70, 7, -73, 84, 115, -16, -6, -54, -101, 95, 113, 108, 101, 32, -8, -84, -74, 95, -104, -8, 106, -61, -41, -35, -75, -23, 28, 86, 96, -1, -27, -84, -62, 29, -94, 49, 89, -82, -15, -76, -108, -42, 51, 120, 38, -6, 21, -93, -86, 39, -84, 13, 107, -19, -4, -45, -75, 7, 106, 89, 35, -45, -58, -13, -44, 75, -69, 60, 96, -1, -24, -109, -29, 18, 61, 98, 64, 17, -93, -38, -95, 36, -59, 59, -49, -37, -11, -113, -82, -44, 99, 117, 42, 
  -33, 7, 17, 31, -89, 59, -85, -34, 13, -18, 21, 33, -59, -40, -60, -56, -38, -53, -8, -51, 2, 48, -41, -54, 8, -92, 48, 45, -38, -33, -50, -12, -15, -40, -12, -50, -28, 16, -8, -16, -54, -38, 66, 38, -54, -37, -109, -63, -18, -19, -4, -14, -85, 93, -23, -113, 20, -99, 105, 88, -43, -105, -111, -99, -28, -14, -44, -4, -21, 31, -92, -102, 3, -56, 22, 52, -110, -48, -56, -76, -85, -33, 47, 84, -57, 21, -23, -108, -32, -27, 82, 82, -93, -86, -93, -32, -16, 8, 81, 71, 62, 73, -28, -42, 8, 28, 37, 86, -44, -47, -99, -27, 17, 21, 63, 61, 15, 28, -23, -115, 31, -47, 59, 55, -21, -112, -45, -45, -72, 14, 57, 62, -13, 103, -6, -63, 36, 6, 43, 99, -46, -106, -104, -6, -1, 27, 42, 85, -23, 86, -83, -18, 94, -23, 92, 71, -23, -105, -93, -77, -23, 4, 41, 94, -23, 45, -17, -29, 19, 74, 26, 105, -50, -126, -55, -32, 50, 66, 60, 48, -21, 30, -89, -99, 12, -23, 75, 66, -22, -81, -110, -91, -37, 4, 51, 17, -13, 40, -68, -121, 37, -5, 56, 56, -57, -122, -69, -73, -8, 30, 87, 78, -53, 89, -97, -92, 29, 39, 32, 110, -20, -42, -104, -66, 1, 27, 24, -36, -65, 20, 19, -91, 4, -38, 23, 22, -35, -96, -98, -91, 1, -6, 26, 28, 14, 78, -12, -55, 35, 21, 58, 56, -74, -72, -118, -96, -27, -21, 34, 26, -67, 94, -62, -51, 38, -35, 31, 72, -33, -66, -90, -99, -43, 24, 6, 93, -16, 97, -79, -62, 34, -10, 39, 70, -32, -93, -101, -50, -43, 6, 0, 0, -13, 61, -5, -47, 45, -37, 114, 105, -69, -36, -37, -36, -13, 21, 12, 24, -53, 81, -15, -96, 87, -56, 58, 21, -8, -90, -71, -71, 16, -32, 48, 36, -40, 65, -63, -95, 43, 14, 56, 53, -26, -96, -52, -68, -24, 42, 62, 59, 11, 33, -58, -74, 51, 58, 52, 33, 13, -39, -114, -32, 28, 67, 100, 96, -48, 98, -56, -60, 47, 60, 107, 103, -24, -76, -70, -79, -35, 75, 92, 28, -99, 39, 13, -29, 91, 50, 101, 113, -56, -107, -61, -11, 66, 26, 68, -3, -8, 75, -62, -108, 86, 22, 64, 94, 14, -51, -32, -55, 46, 15, 14, 51, -92, 79, -19, -118, 42, -15, 63, 57, -33, -108, -42, -109, 43, 14, 19, 28, 6, 21, -58, -77, 1, 17, 60, 94, -53, -95, -50, -6, 11, 35, 95, 69, -62, 38, -86, -107, -3, -34, 92, 104, -16, -111, -114, -14, -22, -2, 27, 94, 7, 44, -33, -54, 55, -5, 51, 28, -13, -71, -37, -23, -5, -17, 71, 106, -56, 108, -69, -90, -6, -21, 29, 96, -51, -114, -91, -30, -5, -10, 61, 28, -2, 40, -35, -20, 27, 38, 113, 83, -2, -111, -39, -82, -49, -14, -21, 40, -53, 73, -87, -23, 27, 14, 57, 109, -32, -61, -110, -68, -32, 6, 54, 88, -40, 47, -79, -72, 40, 6, 25, 57, -33, -59, -118, 10, -18, 0, 81, 101, -34, 56, -2, -81, 76, 18, 97, 42, -73, -101, -99, -71, 5, 31, 94, 21, 0, 72, 5, -127, 26, 43, 114, 96, -21, -111, -99, 8, 3, -15, 87, 88, -1, 94, -47, -121, 87, 80, 36, 82, 1, -44, -76, -22, -5, 12, 64, 36, -34, 69, -39, -94, 7, -1, 37, 40, -25, -72, -43, -52, -38, 29, 88, 47, -63, 117, -12, -64, 12, 34, 84, 100, -70, -37, -26, -83, -6, 55, 63, 52, 64, 71, 2, -81, 10, -48, 85, 83, -43, -71, -43, 20, -39, 8, 88, 32, -65, 69, -84, -20, 79, 20, 101, 44, -3, -37, -115, -33, 10, 8, 61, 50, -60, 69, 1, -125, 27, 21, 115, 87, -55, -96, -55, -71, -18, 11, 60, 42, -25, 80, -41, -99, 4, -9, 85, 63, -21, -126, -105, -93, -37, 60, 63, 47, -41, 90, -77, -88, 36, -48, 46, 50, -81, -45, -73, -22, -9, -11, 63, 56, -8, 62, -26, -52, 60, 10, 21, 84, -54, -118, -51, -59, -34, -16, 56, 43, 10, 58, -36, -117, 19, -24, 63, 92, -61, -67, -43, -27, -12, 88, 68, 69, -74, 99, -59, -104, 36, 12, 55, 78, -30, -95, -96, -90, 37, 17, 66, 114, -27, 65, -27, -51, 29, 12, 29, 46, 25, -99, -34, -97, 21, 28, 77, 82, -68, 32, 0, -55, 1, 42, 67, 95, -39, -40, -102, -35, 0, 73, 101, 33, -26, 32, -73, -51, 63, -17, 89, 37, -65, -124, -52, -43, 39, 45, 72, 61, -10, 32, -17, 39, 51, 74, 37, 68, -14, -43, -64, -102, 
};
const TfArray<2, int> tensor_dimension7 = { 2, { 2,800 } };
const TfArray<1, float> quant7_scale = { 1, { 0.0018221656791865826, } };
const TfArray<1, int> quant7_zero = { 1, { 0 } };
const TfLiteAffineQuantization quant7 = { (TfLiteFloatArray*)&quant7_scale, (TfLiteIntArray*)&quant7_zero, 0 };
const ALIGN(16) int32_t tensor_data8[16] = { 1371, 487, -138, 738, 380, 3105, -54, 3467, -3557, 3434, 3835, 5126, 3224, 7117, 4718, 5264, };
const TfArray<1, int> tensor_dimension8 = { 1, { 16 } };
const TfArray<16, float> quant8_scale = { 16, { 1.8128852389054373e-05, 2.0770832634298131e-05, 2.2815891497884877e-05, 1.9494444131851196e-05, 1.7040754755726084e-05, 1.9885404981323518e-05, 1.7939746612682939e-05, 2.3504955606767908e-05, 1.6586111087235622e-05, 1.3065849998383783e-05, 1.9884470020770095e-05, 2.0886107449769042e-05, 1.703589987300802e-05, 1.8364080460742116e-05, 2.1619880499201827e-05, 1.8981059838552028e-05, } };
const TfArray<16, int> quant8_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant8 = { (TfLiteFloatArray*)&quant8_scale, (TfLiteIntArray*)&quant8_zero, 0 };
const ALIGN(16) int8_t tensor_data9[16*1*3*8] = { 
  /* [0][0][][] */ 81,70,102,58,-1,34,-13,35, 31,3,19,-46,-41,55,69,-127, 71,76,41,7,-78,3,40,2, 
  /* [1][0][][] */ -65,102,18,98,-18,-85,8,79, -81,-4,-55,34,53,90,86,127, 61,3,41,-55,-47,-69,-13,33, 
  /* [2][0][][] */ -67,10,-48,52,-17,-69,-3,82, 37,-6,48,95,15,-113,-19,127, -102,23,31,-11,-59,-27,84,40, 
  /* [3][0][][] */ 4,-49,27,8,65,-61,-109,90, -29,-76,-7,127,-11,-91,-56,76, -92,24,-54,0,31,-60,39,95, 
  /* [4][0][][] */ -53,-62,-81,-32,-127,-121,-5,58, -110,-59,-50,-55,-25,59,-1,-53, 70,55,62,-59,-104,94,-55,1, 
  /* [5][0][][] */ -76,46,39,99,-44,-127,-23,123, -94,31,-50,-12,55,51,-60,-3, -58,121,70,73,31,-11,-42,88, 
  /* [6][0][][] */ 127,5,27,44,-121,5,9,-16, 87,-98,51,-120,-13,20,51,27, -5,-86,-51,50,-8,50,-63,-105, 
  /* [7][0][][] */ 36,54,-17,-119,-50,127,60,5, 93,63,48,47,75,106,29,20, 60,-19,-56,-48,100,70,64,-8, 
  /* [8][0][][] */ 15,-119,127,113,-3,-67,82,70, -94,-85,-110,96,59,-59,-107,121, -78,-36,68,99,8,7,-23,-2, 
  /* [9][0][][] */ 109,-127,85,78,-41,114,57,36, 11,-91,-12,-99,18,108,-92,56, 42,-92,-88,83,-3,108,-112,97, 
  /* [10][0][][] */ -75,-62,-43,62,53,-51,82,12, -100,-84,-23,15,-21,-86,-46,62, -66,-16,-42,95,-44,40,-11,127, 
  /* [11][0][][] */ -90,57,-40,127,32,-5,-29,-19, -57,-40,29,53,78,-103,17,78, -35,-1,-76,106,-89,-95,-48,13, 
  /* [12][0][][] */ -36,34,-67,75,-18,49,58,-54, 120,8,-80,-90,-77,113,-67,-74, 127,88,98,-12,84,-55,-46,32, 
  /* [13][0][][] */ 74,-3,-29,-64,-90,127,-99,-40, 127,20,-66,-26,-79,-35,-100,-67, 11,0,81,-34,108,-30,-107,64, 
  /* [14][0][][] */ 100,-12,49,-48,3,100,-16,-58, 41,59,67,0,16,45,19,-64, 127,-110,-5,68,40,-30,-26,-78, 
  /* [15][0][][] */ 127,34,-30,-75,25,6,-81,32, 58,-17,57,-52,44,-14,-5,41, -3,-104,67,-85,-74,36,8,15, 
};
const TfArray<4, int> tensor_dimension9 = { 4, { 16,1,3,8 } };
const TfArray<16, float> quant9_scale = { 16, { 0.0025422726757824421, 0.0029127667658030987, 0.0031995524186640978, 0.0027337742503732443, 0.0023896847851574421, 0.0027886000461876392, 0.0025157537311315536, 0.0032961824908852577, 0.0023259285371750593, 0.0018322699470445514, 0.0027884689625352621, 0.0029289321973919868, 0.0023890039883553982, 0.0025752594228833914, 0.0030318317003548145, 0.0026617806870490313, } };
const TfArray<16, int> quant9_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant9 = { (TfLiteFloatArray*)&quant9_scale, (TfLiteIntArray*)&quant9_zero, 0 };
const ALIGN(16) int32_t tensor_data10[8] = { 22972, -11350, -14386, 6180, -10470, 20034, -12843, -2995, };
const TfArray<1, int> tensor_dimension10 = { 1, { 8 } };
const TfArray<8, float> quant10_scale = { 8, { 5.0042840484820772e-06, 4.2972469600499608e-06, 4.0283262023876887e-06, 5.6636490626260638e-06, 4.7896455726004206e-06, 5.3146873142395634e-06, 4.3029431253671646e-06, 4.9486311581858899e-06, } };
const TfArray<8, int> quant10_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant10 = { (TfLiteFloatArray*)&quant10_scale, (TfLiteIntArray*)&quant10_zero, 0 };
const ALIGN(16) int8_t tensor_data11[8*1*3*40] = { 
  /* [0][0][][] */ 0,48,1,18,-83,5,85,-3,-16,3,32,-75,71,-45,-75,-8,-51,-68,-59,-120,-7,-52,-5,3,1,-45,-34,-105,36,-106,-127,7,-25,-92,6,-54,-16,-17,82,110, 22,36,-69,57,-48,-75,105,53,-4,-37,52,47,-108,49,19,33,41,-6,-51,17,-115,8,-11,-48,-78,-84,23,-34,93,-58,-101,29,-106,-122,-63,-13,26,51,-21,68, 52,-13,68,-63,78,-66,-70,-20,-46,59,-76,-76,26,-80,-37,-39,-80,-77,14,-98,1,-79,-38,-24,-37,-107,-119,-6,3,-59,-116,-119,-63,-108,-81,-65,-56,88,90,97, 
  /* [1][0][][] */ -99,-85,-19,76,-102,83,-86,91,-4,-6,-30,-59,74,-80,99,32,-93,-40,101,95,44,-56,35,22,24,-65,-87,-36,-37,27,14,-102,-10,75,53,33,-94,-102,-30,-101, 79,-11,-71,29,-17,102,72,94,9,-38,-17,-21,54,-84,-81,83,20,-75,-51,-33,51,102,-55,-26,-102,-18,5,-51,-14,87,-24,-3,20,123,-19,-42,-74,-40,-39,-127, 87,-74,4,-62,-98,69,71,9,-95,25,-80,69,97,-59,-7,26,-15,71,89,-31,-42,23,-97,39,50,98,-55,102,-3,-59,58,-43,59,-63,-13,57,41,-13,-90,34, 
  /* [2][0][][] */ 70,104,-92,-31,-92,-93,49,58,-59,21,19,-86,52,-106,-65,66,63,-71,77,37,103,-7,-3,9,36,-82,-82,-100,-8,-108,-79,29,-93,63,75,-92,22,-111,9,-72, 35,-2,7,-55,14,1,38,-59,84,-86,107,-92,-54,21,105,60,-100,-59,70,78,13,90,-47,-10,-65,103,-52,-4,-90,-89,-56,77,-97,2,-30,-55,-104,20,-127,-83, 55,-86,-69,-13,67,-21,108,107,63,-72,-93,-31,30,45,25,62,-85,-84,108,-100,55,41,-79,23,88,-101,5,-65,5,70,39,-36,3,-120,38,-74,8,79,-88,-70, 
  /* [3][0][][] */ -64,-11,-3,-76,95,-41,92,-8,93,-41,11,-27,23,60,55,32,122,56,63,61,89,106,106,117,78,113,108,-26,102,76,80,93,96,72,75,69,6,26,-51,81, -59,-32,-2,-41,34,45,47,-45,56,24,-32,5,-9,-26,88,-14,102,95,30,83,98,76,46,127,53,-14,89,-14,49,19,108,122,70,31,-2,3,30,-25,95,-4, 64,3,65,-68,63,78,29,31,-59,41,109,-18,-33,60,-35,62,67,41,8,118,-11,85,0,73,14,41,107,58,104,-8,117,4,43,35,-6,35,55,-42,-41,3, 
  /* [4][0][][] */ 74,-42,-13,87,-59,15,1,75,-16,-7,-57,55,44,56,-22,76,-55,-84,-88,-101,-26,-96,-93,15,-55,-66,-58,-9,28,-54,-99,7,-79,-73,10,-97,-55,54,-65,7, 53,12,66,-42,-46,-13,65,-56,9,-39,-2,43,-24,62,-53,-18,-57,-11,2,-75,-59,13,21,48,-63,27,-36,-70,-35,42,-127,37,-113,-105,36,10,-62,3,-111,-27, 81,-88,-75,-1,-55,-29,43,29,-39,-57,-35,74,65,77,-78,19,-77,-82,-24,-32,-27,-46,-44,-85,-53,-118,-110,-49,-62,39,14,-123,62,13,-101,39,64,54,-36,-109, 
  /* [5][0][][] */ -24,19,-6,37,59,27,-14,28,24,84,-28,94,35,72,-3,29,-50,-12,-30,45,-54,-34,52,-110,-42,-104,-1,44,-20,97,-110,35,-24,-54,46,16,-4,-8,104,12, -74,-83,40,48,21,-22,-47,-30,-18,-27,-50,-63,-8,52,-35,12,-11,-4,48,57,36,-59,13,26,-97,-13,-84,75,59,38,-75,-56,-103,-2,-70,-20,33,110,14,-24, 63,-61,79,-3,34,40,8,-8,46,102,69,59,15,85,-22,55,33,-75,-19,-93,33,51,-76,2,-57,-91,31,62,55,-22,-23,26,-66,-127,-79,-69,0,-22,72,119, 
  /* [6][0][][] */ 49,92,-13,24,-26,-36,-55,-72,-98,-99,-63,7,-53,-41,9,-33,-70,59,-9,-35,-61,22,-34,8,-61,-29,72,-9,5,-65,-32,-117,21,-101,-90,13,-118,49,-85,-71, -41,-90,59,-1,-60,99,57,43,22,39,-48,85,-94,47,84,-63,-77,-105,54,54,-66,-121,-54,-47,-119,80,-44,28,-53,-50,61,58,-95,53,-85,53,87,42,-96,-59, 1,-47,-73,-22,-92,-79,-16,-33,89,80,-92,-81,-6,-79,-69,-82,56,-102,3,-60,-36,-127,24,-41,-9,-30,-126,-38,-53,34,-71,-37,-35,55,-31,83,-54,-96,-111,8, 
  /* [7][0][][] */ 65,0,46,30,93,50,-65,57,-17,-21,104,-33,99,-29,20,72,23,120,3,26,11,74,-35,19,98,18,35,106,101,103,8,-8,96,121,36,-25,71,-2,53,-26, -30,15,-43,-31,-74,-84,1,25,-27,-5,71,-66,54,-3,-81,-45,-47,6,42,-29,20,63,85,76,41,15,1,86,63,-3,-44,23,99,75,107,52,53,55,-5,24, 18,-32,-39,-36,-41,-2,-14,-2,-22,42,3,35,-43,66,41,84,57,93,85,28,22,87,95,102,-24,127,65,104,11,86,71,103,-27,13,-34,53,-46,-33,57,37, 
};
const TfArray<4, int> tensor_dimension11 = { 4, { 8,1,3,40 } };
const TfArray<8, float> quant11_scale = { 8, { 0.0023168770130723715, 0.0019895338919013739, 0.0018650293350219727, 0.0026221489533782005, 0.0022175039630383253, 0.0024605870712548494, 0.0019921709317713976, 0.002291110809892416, } };
const TfArray<8, int> quant11_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant11 = { (TfLiteFloatArray*)&quant11_scale, (TfLiteIntArray*)&quant11_zero, 0 };
const TfArray<4, int> tensor_dimension12 = { 4, { 1,1,199,40 } };
const TfArray<1, float> quant12_scale = { 1, { 0.0021599265746772289, } };
const TfArray<1, int> quant12_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant12 = { (TfLiteFloatArray*)&quant12_scale, (TfLiteIntArray*)&quant12_zero, 0 };
const TfArray<4, int> tensor_dimension13 = { 4, { 1,1,199,8 } };
const TfArray<1, float> quant13_scale = { 1, { 0.0071309632621705532, } };
const TfArray<1, int> quant13_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant13 = { (TfLiteFloatArray*)&quant13_scale, (TfLiteIntArray*)&quant13_zero, 0 };
const TfArray<4, int> tensor_dimension14 = { 4, { 1,199,1,8 } };
const TfArray<1, float> quant14_scale = { 1, { 0.0071309632621705532, } };
const TfArray<1, int> quant14_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant14 = { (TfLiteFloatArray*)&quant14_scale, (TfLiteIntArray*)&quant14_zero, 0 };
const TfArray<4, int> tensor_dimension15 = { 4, { 1,100,1,8 } };
const TfArray<1, float> quant15_scale = { 1, { 0.0071309632621705532, } };
const TfArray<1, int> quant15_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant15 = { (TfLiteFloatArray*)&quant15_scale, (TfLiteIntArray*)&quant15_zero, 0 };
const TfArray<4, int> tensor_dimension16 = { 4, { 1,1,100,8 } };
const TfArray<1, float> quant16_scale = { 1, { 0.0071309632621705532, } };
const TfArray<1, int> quant16_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant16 = { (TfLiteFloatArray*)&quant16_scale, (TfLiteIntArray*)&quant16_zero, 0 };
const TfArray<4, int> tensor_dimension17 = { 4, { 1,1,100,16 } };
const TfArray<1, float> quant17_scale = { 1, { 0.007370323408395052, } };
const TfArray<1, int> quant17_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant17 = { (TfLiteFloatArray*)&quant17_scale, (TfLiteIntArray*)&quant17_zero, 0 };
const TfArray<4, int> tensor_dimension18 = { 4, { 1,100,1,16 } };
const TfArray<1, float> quant18_scale = { 1, { 0.007370323408395052, } };
const TfArray<1, int> quant18_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant18 = { (TfLiteFloatArray*)&quant18_scale, (TfLiteIntArray*)&quant18_zero, 0 };
const TfArray<4, int> tensor_dimension19 = { 4, { 1,50,1,16 } };
const TfArray<1, float> quant19_scale = { 1, { 0.007370323408395052, } };
const TfArray<1, int> quant19_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant19 = { (TfLiteFloatArray*)&quant19_scale, (TfLiteIntArray*)&quant19_zero, 0 };
const TfArray<2, int> tensor_dimension20 = { 2, { 1,800 } };
const TfArray<1, float> quant20_scale = { 1, { 0.007370323408395052, } };
const TfArray<1, int> quant20_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant20 = { (TfLiteFloatArray*)&quant20_scale, (TfLiteIntArray*)&quant20_zero, 0 };
const TfArray<2, int> tensor_dimension21 = { 2, { 1,2 } };
const TfArray<1, float> quant21_scale = { 1, { 0.28202304244041443, } };
const TfArray<1, int> quant21_zero = { 1, { 3 } };
const TfLiteAffineQuantization quant21 = { (TfLiteFloatArray*)&quant21_scale, (TfLiteIntArray*)&quant21_zero, 0 };
const TfArray<2, int> tensor_dimension22 = { 2, { 1,2 } };
const TfArray<1, float> quant22_scale = { 1, { 0.00390625, } };
const TfArray<1, int> quant22_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant22 = { (TfLiteFloatArray*)&quant22_scale, (TfLiteIntArray*)&quant22_zero, 0 };
const TfLiteReshapeParams opdata0 = { { 0, 0, 0, 0, 0, 0, 0, 0, }, 0 };
const TfArray<2, int> inputs0 = { 2, { 0,1 } };
const TfArray<1, int> outputs0 = { 1, { 12 } };
const TfLiteConvParams opdata1 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu, 1,1 };
const TfArray<3, int> inputs1 = { 3, { 12,11,10 } };
const TfArray<1, int> outputs1 = { 1, { 13 } };
const TfLiteReshapeParams opdata2 = { { 0, 0, 0, 0, 0, 0, 0, 0, }, 0 };
const TfArray<2, int> inputs2 = { 2, { 13,2 } };
const TfArray<1, int> outputs2 = { 1, { 14 } };
const TfLitePoolParams opdata3 = { kTfLitePaddingSame, 1,2, 1,2, kTfLiteActNone, { { 0,0, 0, 0 } } };
const TfArray<1, int> inputs3 = { 1, { 14 } };
const TfArray<1, int> outputs3 = { 1, { 15 } };
const TfLiteReshapeParams opdata4 = { { 0, 0, 0, 0, 0, 0, 0, 0, }, 0 };
const TfArray<2, int> inputs4 = { 2, { 15,3 } };
const TfArray<1, int> outputs4 = { 1, { 16 } };
const TfLiteConvParams opdata5 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu, 1,1 };
const TfArray<3, int> inputs5 = { 3, { 16,9,8 } };
const TfArray<1, int> outputs5 = { 1, { 17 } };
const TfLiteReshapeParams opdata6 = { { 0, 0, 0, 0, 0, 0, 0, 0, }, 0 };
const TfArray<2, int> inputs6 = { 2, { 17,4 } };
const TfArray<1, int> outputs6 = { 1, { 18 } };
const TfLitePoolParams opdata7 = { kTfLitePaddingSame, 1,2, 1,2, kTfLiteActNone, { { 0,0, 0, 0 } } };
const TfArray<1, int> inputs7 = { 1, { 18 } };
const TfArray<1, int> outputs7 = { 1, { 19 } };
const TfLiteReshapeParams opdata8 = { { 0, 0, 0, 0, 0, 0, 0, 0, }, 0 };
const TfArray<2, int> inputs8 = { 2, { 19,5 } };
const TfArray<1, int> outputs8 = { 1, { 20 } };
const TfLiteFullyConnectedParams opdata9 = { kTfLiteActNone, kTfLiteFullyConnectedWeightsFormatDefault, false, false };
const TfArray<3, int> inputs9 = { 3, { 20,7,6 } };
const TfArray<1, int> outputs9 = { 1, { 21 } };
const TfLiteSoftmaxParams opdata10 = { 1 };
const TfArray<1, int> inputs10 = { 1, { 21 } };
const TfArray<1, int> outputs10 = { 1, { 22 } };
const TensorInfo_t tensorData[] = {
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 7968, (TfLiteIntArray*)&tensor_dimension0, 7960, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant0))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data1, (TfLiteIntArray*)&tensor_dimension1, 16, {kTfLiteNoQuantization, nullptr}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data2, (TfLiteIntArray*)&tensor_dimension2, 16, {kTfLiteNoQuantization, nullptr}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data3, (TfLiteIntArray*)&tensor_dimension3, 16, {kTfLiteNoQuantization, nullptr}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data4, (TfLiteIntArray*)&tensor_dimension4, 16, {kTfLiteNoQuantization, nullptr}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data5, (TfLiteIntArray*)&tensor_dimension5, 8, {kTfLiteNoQuantization, nullptr}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data6, (TfLiteIntArray*)&tensor_dimension6, 8, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant6))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data7, (TfLiteIntArray*)&tensor_dimension7, 1600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant7))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data8, (TfLiteIntArray*)&tensor_dimension8, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant8))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data9, (TfLiteIntArray*)&tensor_dimension9, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant9))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data10, (TfLiteIntArray*)&tensor_dimension10, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant10))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data11, (TfLiteIntArray*)&tensor_dimension11, 960, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant11))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension12, 7960, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant12))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 7968, (TfLiteIntArray*)&tensor_dimension13, 1592, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant13))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension14, 1592, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant14))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 1600, (TfLiteIntArray*)&tensor_dimension15, 800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant15))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension16, 800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant16))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 1600, (TfLiteIntArray*)&tensor_dimension17, 1600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant17))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension18, 1600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant18))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 1600, (TfLiteIntArray*)&tensor_dimension19, 800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant19))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension20, 800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant20))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 800, (TfLiteIntArray*)&tensor_dimension21, 2, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant21))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension22, 2, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant22))}, },
};
#ifndef TF_LITE_STATIC_MEMORY
TfLiteNode tflNodes[11] = {
  { (TfLiteIntArray*)&inputs0, (TfLiteIntArray*)&outputs0, (TfLiteIntArray*)&inputs0, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata0)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs1, (TfLiteIntArray*)&outputs1, (TfLiteIntArray*)&inputs1, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata1)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs2, (TfLiteIntArray*)&outputs2, (TfLiteIntArray*)&inputs2, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata2)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs3, (TfLiteIntArray*)&outputs3, (TfLiteIntArray*)&inputs3, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata3)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs4, (TfLiteIntArray*)&outputs4, (TfLiteIntArray*)&inputs4, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata4)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs5, (TfLiteIntArray*)&outputs5, (TfLiteIntArray*)&inputs5, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata5)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs6, (TfLiteIntArray*)&outputs6, (TfLiteIntArray*)&inputs6, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata6)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs7, (TfLiteIntArray*)&outputs7, (TfLiteIntArray*)&inputs7, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata7)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs8, (TfLiteIntArray*)&outputs8, (TfLiteIntArray*)&inputs8, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata8)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs9, (TfLiteIntArray*)&outputs9, (TfLiteIntArray*)&inputs9, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata9)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs10, (TfLiteIntArray*)&outputs10, (TfLiteIntArray*)&inputs10, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata10)), nullptr, 0, },
};
#else
TfLiteNode tflNodes[11] = {
  { (TfLiteIntArray*)&inputs0, (TfLiteIntArray*)&outputs0, (TfLiteIntArray*)&inputs0, nullptr, const_cast<void*>(static_cast<const void*>(&opdata0)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs1, (TfLiteIntArray*)&outputs1, (TfLiteIntArray*)&inputs1, nullptr, const_cast<void*>(static_cast<const void*>(&opdata1)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs2, (TfLiteIntArray*)&outputs2, (TfLiteIntArray*)&inputs2, nullptr, const_cast<void*>(static_cast<const void*>(&opdata2)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs3, (TfLiteIntArray*)&outputs3, (TfLiteIntArray*)&inputs3, nullptr, const_cast<void*>(static_cast<const void*>(&opdata3)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs4, (TfLiteIntArray*)&outputs4, (TfLiteIntArray*)&inputs4, nullptr, const_cast<void*>(static_cast<const void*>(&opdata4)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs5, (TfLiteIntArray*)&outputs5, (TfLiteIntArray*)&inputs5, nullptr, const_cast<void*>(static_cast<const void*>(&opdata5)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs6, (TfLiteIntArray*)&outputs6, (TfLiteIntArray*)&inputs6, nullptr, const_cast<void*>(static_cast<const void*>(&opdata6)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs7, (TfLiteIntArray*)&outputs7, (TfLiteIntArray*)&inputs7, nullptr, const_cast<void*>(static_cast<const void*>(&opdata7)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs8, (TfLiteIntArray*)&outputs8, (TfLiteIntArray*)&inputs8, nullptr, const_cast<void*>(static_cast<const void*>(&opdata8)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs9, (TfLiteIntArray*)&outputs9, (TfLiteIntArray*)&inputs9, nullptr, const_cast<void*>(static_cast<const void*>(&opdata9)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs10, (TfLiteIntArray*)&outputs10, (TfLiteIntArray*)&inputs10, nullptr, const_cast<void*>(static_cast<const void*>(&opdata10)), nullptr, 0, },
};
#endif

used_operators_e used_ops[] =
{OP_RESHAPE, OP_CONV_2D, OP_RESHAPE, OP_MAX_POOL_2D, OP_RESHAPE, OP_CONV_2D, OP_RESHAPE, OP_MAX_POOL_2D, OP_RESHAPE, OP_FULLY_CONNECTED, OP_SOFTMAX, };



static void init_tflite_tensor(size_t i, TfLiteTensor *tensor) {
  tensor->type = tensorData[i].type;
  tensor->is_variable = 0;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  tensor->allocation_type = tensorData[i].allocation_type;
#else
  tensor->allocation_type = (tensor_arena <= tensorData[i].data && tensorData[i].data < tensor_arena + kTensorArenaSize) ? kTfLiteArenaRw : kTfLiteMmapRo;
#endif
  tensor->bytes = tensorData[i].bytes;
  tensor->dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  if(tensor->allocation_type == kTfLiteArenaRw){
    uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

    tensor->data.data =  start;
  }
  else {
      tensor->data.data = tensorData[i].data;
  }
#else
  tensor->data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
  tensor->quantization = tensorData[i].quantization;
  if (tensor->quantization.type == kTfLiteAffineQuantization) {
    TfLiteAffineQuantization const* quant = ((TfLiteAffineQuantization const*)(tensorData[i].quantization.params));
    tensor->params.scale = quant->scale->data[0];
    tensor->params.zero_point = quant->zero_point->data[0];
  }

}

static void init_tflite_eval_tensor(int i, TfLiteEvalTensor *tensor) {

  tensor->type = tensorData[i].type;

  tensor->dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  auto allocation_type = tensorData[i].allocation_type;
  if(allocation_type == kTfLiteArenaRw) {
    uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

    tensor->data.data =  start;
  }
  else {
    tensor->data.data = tensorData[i].data;
  }
#else
  tensor->data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
}

static void* overflow_buffers[EI_MAX_OVERFLOW_BUFFER_COUNT];
static size_t overflow_buffers_ix = 0;
static void * AllocatePersistentBufferImpl(struct TfLiteContext* ctx,
                                       size_t bytes) {
  void *ptr;
  uint32_t align_bytes = (bytes % 16) ? 16 - (bytes % 16) : 0;

  if (current_location - (bytes + align_bytes) < tensor_boundary) {
    if (overflow_buffers_ix > EI_MAX_OVERFLOW_BUFFER_COUNT - 1) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d, does not fit in tensor arena and reached EI_MAX_OVERFLOW_BUFFER_COUNT\n",
        (int)bytes);
      return NULL;
    }

    // OK, this will look super weird, but.... we have CMSIS-NN buffers which
    // we cannot calculate beforehand easily.
    ptr = ei_calloc(bytes, 1);
    if (ptr == NULL) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d\n", (int)bytes);
      return NULL;
    }
    overflow_buffers[overflow_buffers_ix++] = ptr;
    return ptr;
  }

  current_location -= bytes;

  // align to the left aligned boundary of 16 bytes
  current_location -= 15; // for alignment
  current_location += 16 - ((uintptr_t)(current_location) & 15);

  ptr = current_location;
  memset(ptr, 0, bytes);

  return ptr;
}
typedef struct {
  size_t bytes;
  void *ptr;
} scratch_buffer_t;
static scratch_buffer_t scratch_buffers[EI_MAX_SCRATCH_BUFFER_COUNT];
static size_t scratch_buffers_ix = 0;

static TfLiteStatus RequestScratchBufferInArenaImpl(struct TfLiteContext* ctx, size_t bytes,
                                                int* buffer_idx) {
  if (scratch_buffers_ix > EI_MAX_SCRATCH_BUFFER_COUNT - 1) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d, reached EI_MAX_SCRATCH_BUFFER_COUNT\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffer_t b;
  b.bytes = bytes;

  b.ptr = AllocatePersistentBufferImpl(ctx, b.bytes);
  if (!b.ptr) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffers[scratch_buffers_ix] = b;
  *buffer_idx = scratch_buffers_ix;

  scratch_buffers_ix++;

  return kTfLiteOk;
}

static void* GetScratchBufferImpl(struct TfLiteContext* ctx, int buffer_idx) {
  if (buffer_idx > (int)scratch_buffers_ix) {
    return NULL;
  }
  return scratch_buffers[buffer_idx].ptr;
}

static const uint16_t TENSOR_IX_UNUSED = 0x7FFF;

static void ResetTensors() {
  for (size_t ix = 0; ix < MAX_TFL_TENSOR_COUNT; ix++) {
    tflTensors[ix].index = TENSOR_IX_UNUSED;
  }
  for (size_t ix = 0; ix < MAX_TFL_EVAL_COUNT; ix++) {
    tflEvalTensors[ix].index = TENSOR_IX_UNUSED;
  }
}

static TfLiteTensor* GetTensorImpl(const struct TfLiteContext* context,
                               int tensor_idx) {

  for (size_t ix = 0; ix < MAX_TFL_TENSOR_COUNT; ix++) {
    // already used? OK!
    if (tflTensors[ix].index == tensor_idx) {
      return &tflTensors[ix].tensor;
    }
    // passed all the ones we've used, so end of the list?
    if (tflTensors[ix].index == TENSOR_IX_UNUSED) {
      // init the tensor
      init_tflite_tensor(tensor_idx, &tflTensors[ix].tensor);
      tflTensors[ix].index = tensor_idx;
      return &tflTensors[ix].tensor;
    }
  }

  ei_printf("ERR: GetTensor called beyond MAX_TFL_TENSOR_COUNT (%d)\n", MAX_TFL_TENSOR_COUNT);
  return nullptr;
}

static TfLiteEvalTensor* GetEvalTensorImpl(const struct TfLiteContext* context,
                                       int tensor_idx) {

  for (size_t ix = 0; ix < MAX_TFL_EVAL_COUNT; ix++) {
    // already used? OK!
    if (tflEvalTensors[ix].index == tensor_idx) {
      return &tflEvalTensors[ix].tensor;
    }
    // passed all the ones we've used, so end of the list?
    if (tflEvalTensors[ix].index == TENSOR_IX_UNUSED) {
      // init the tensor
      init_tflite_eval_tensor(tensor_idx, &tflEvalTensors[ix].tensor);
      tflEvalTensors[ix].index = tensor_idx;
      return &tflEvalTensors[ix].tensor;
    }
  }

  ei_printf("ERR: GetTensor called beyond MAX_TFL_EVAL_COUNT (%d)\n", (int)MAX_TFL_EVAL_COUNT);
  return nullptr;
}

class EonMicroContext : public MicroContext {
 public:
  EonMicroContext(): MicroContext(nullptr, nullptr, nullptr) { }

  void* AllocatePersistentBuffer(size_t bytes) {
    return AllocatePersistentBufferImpl(nullptr, bytes);
  };
  TfLiteStatus RequestScratchBufferInArena(size_t bytes,
                                           int* buffer_index) {
  return RequestScratchBufferInArenaImpl(nullptr, bytes, buffer_index);
  }
  void* GetScratchBuffer(int buffer_index) {
    return GetScratchBufferImpl(nullptr, buffer_index);
  }

  TfLiteTensor* AllocateTempTfLiteTensor(int tensor_index) {
    return GetTensorImpl(nullptr, tensor_index);
  }
  void DeallocateTempTfLiteTensor(TfLiteTensor* tensor) {
    return;
  }
  bool IsAllTempTfLiteTensorDeallocated() {
    return true;
  }

  TfLiteEvalTensor* GetEvalTensor(int tensor_index) {
    return GetEvalTensorImpl(nullptr, tensor_index);
  }
};

} // namespace

TfLiteStatus tflite_learn_5_init( void*(*alloc_fnc)(size_t,size_t) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  tensor_arena = (uint8_t*) alloc_fnc(16, kTensorArenaSize);
  if (!tensor_arena) {
    ei_printf("ERR: failed to allocate tensor arena\n");
    return kTfLiteError;
  }
#else
  memset(tensor_arena, 0, kTensorArenaSize);
#endif
  tensor_boundary = tensor_arena;
  current_location = tensor_arena + kTensorArenaSize;

  EonMicroContext micro_context_;
  ctx.impl_ = static_cast<void*>(&micro_context_);
  ctx.AllocatePersistentBuffer = &AllocatePersistentBufferImpl;
  ctx.RequestScratchBufferInArena = &RequestScratchBufferInArenaImpl;
  ctx.GetScratchBuffer = &GetScratchBufferImpl;
  ctx.GetTensor = &GetTensorImpl;
  ctx.GetEvalTensor = &GetEvalTensorImpl;
  ctx.ReportError = &MicroContextReportOpError;
  ctx.tensors_size = 23;
  for (size_t i = 0; i < 23; ++i) {
    TfLiteTensor tensor;
    init_tflite_tensor(i, &tensor);
    if (tensor.allocation_type == kTfLiteArenaRw) {
      auto data_end_ptr = (uint8_t*)tensor.data.data + tensorData[i].bytes;
      if (data_end_ptr > tensor_boundary) {
        tensor_boundary = data_end_ptr;
      }
    }
  }
  if (tensor_boundary > current_location /* end of arena size */) {
    ei_printf("ERR: tensor arena is too small, does not fit model - even without scratch buffers\n");
    return kTfLiteError;
  }
  registrations[OP_RESHAPE] = Register_RESHAPE();
  registrations[OP_CONV_2D] = Register_CONV_2D();
  registrations[OP_MAX_POOL_2D] = Register_MAX_POOL_2D();
  registrations[OP_FULLY_CONNECTED] = Register_FULLY_CONNECTED();
  registrations[OP_SOFTMAX] = Register_SOFTMAX();

  for (size_t i = 0; i < 11; ++i) {
if (registrations[used_ops[i]].init) {
       tflNodes[i].user_data = registrations[used_ops[i]].init(&ctx, (const char*)tflNodes[i].builtin_data, 0);
    }
  }
  for (size_t i = 0; i < 11; ++i) {
    if (registrations[used_ops[i]].prepare) {
      ResetTensors();

      TfLiteStatus status = registrations[used_ops[i]].prepare(&ctx, &tflNodes[i]);
      if (status != kTfLiteOk) {
        return status;
      }
    }
  }
  return kTfLiteOk;
}

static const int inTensorIndices[] = {
  0, 
};
TfLiteStatus tflite_learn_5_input(int index, TfLiteTensor *tensor) {
  init_tflite_tensor(inTensorIndices[index], tensor);
  return kTfLiteOk;
}

static const int outTensorIndices[] = {
  22, 
};
TfLiteStatus tflite_learn_5_output(int index, TfLiteTensor *tensor) {
  init_tflite_tensor(outTensorIndices[index], tensor);
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_5_invoke() {
  for (size_t i = 0; i < 11; ++i) {
    ResetTensors();

    TfLiteStatus status = registrations[used_ops[i]].invoke(&ctx, &tflNodes[i]);

#if EI_CLASSIFIER_PRINT_STATE
    ei_printf("layer %lu\n", i);
    ei_printf("    inputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].inputs->size; ix++) {
      auto d = tensorData[tflNodes[i].inputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");

    ei_printf("    outputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].outputs->size; ix++) {
      auto d = tensorData[tflNodes[i].outputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");
#endif // EI_CLASSIFIER_PRINT_STATE

    if (status != kTfLiteOk) {
      return status;
    }
  }
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_5_reset( void (*free_fnc)(void* ptr) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  free_fnc(tensor_arena);
#endif

  // scratch buffers are allocated within the arena, so just reset the counter so memory can be reused
  scratch_buffers_ix = 0;

  // overflow buffers are on the heap, so free them first
  for (size_t ix = 0; ix < overflow_buffers_ix; ix++) {
    ei_free(overflow_buffers[ix]);
  }
  overflow_buffers_ix = 0;
  return kTfLiteOk;
}
