/* Generated by Edge Impulse
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
// Generated on: 17.01.2024 12:00:09

#include <stdio.h>
#include <stdlib.h>
#include "edge-impulse-sdk/tensorflow/lite/c/builtin_op_data.h"
#include "edge-impulse-sdk/tensorflow/lite/c/common.h"
#include "edge-impulse-sdk/tensorflow/lite/micro/micro_mutable_op_resolver.h"
#include "edge-impulse-sdk/porting/ei_classifier_porting.h"

#if EI_CLASSIFIER_PRINT_STATE
#if defined(__cplusplus) && EI_C_LINKAGE == 1
extern "C" {
    extern void ei_printf(const char *format, ...);
}
#else
extern void ei_printf(const char *format, ...);
#endif
#endif

#if defined __GNUC__
#define ALIGN(X) __attribute__((aligned(X)))
#elif defined _MSC_VER
#define ALIGN(X) __declspec(align(X))
#elif defined __TASKING__
#define ALIGN(X) __align(X)
#elif defined __ICCARM__
#define ALIGN(x) __attribute__((aligned(x)))
#endif

#ifndef EI_MAX_SCRATCH_BUFFER_COUNT
#ifndef CONFIG_IDF_TARGET_ESP32S3
#define EI_MAX_SCRATCH_BUFFER_COUNT 14
#else
#define EI_MAX_SCRATCH_BUFFER_COUNT 28
#endif // CONFIG_IDF_TARGET_ESP32S3
#endif // EI_MAX_SCRATCH_BUFFER_COUNT

#ifndef EI_MAX_OVERFLOW_BUFFER_COUNT
#define EI_MAX_OVERFLOW_BUFFER_COUNT 10
#endif // EI_MAX_OVERFLOW_BUFFER_COUNT

using namespace tflite;
using namespace tflite::ops;
using namespace tflite::ops::micro;

namespace {

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX) || defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
constexpr int kTensorArenaSize = 1410768;
#else
constexpr int kTensorArenaSize = 1409744;
#endif

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX)
#pragma Bss(".tensor_arena")
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#pragma Bss()
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16) __attribute__((section(".tensor_arena")));
#else
#define EI_CLASSIFIER_ALLOCATION_HEAP 1
uint8_t* tensor_arena = NULL;
#endif

static uint8_t* tensor_boundary;
static uint8_t* current_location;

template <int SZ, class T> struct TfArray {
  int sz; T elem[SZ];
};
enum used_operators_e {
  OP_CONV_2D, OP_DEPTHWISE_CONV_2D, OP_PAD, OP_ADD, OP_SOFTMAX,  OP_LAST
};
struct TensorInfo_t { // subset of TfLiteTensor used for initialization from constant memory
  TfLiteAllocationType allocation_type;
  TfLiteType type;
  void* data;
  TfLiteIntArray* dims;
  size_t bytes;
  TfLiteQuantization quantization;
};

typedef struct {
  TfLiteTensor tensor;
  int16_t index;
} TfLiteTensorWithIndex;

typedef struct {
  TfLiteEvalTensor tensor;
  int16_t index;
} TfLiteEvalTensorWithIndex;

TfLiteContext ctx{};
static const int MAX_TFL_TENSOR_COUNT = 4;
static TfLiteTensorWithIndex tflTensors[MAX_TFL_TENSOR_COUNT];
static const int MAX_TFL_EVAL_COUNT = 4;
static TfLiteEvalTensorWithIndex tflEvalTensors[MAX_TFL_EVAL_COUNT];
TfLiteRegistration registrations[OP_LAST];

const TfArray<4, int> tensor_dimension0 = { 4, { 1,240,240,3 } };
const TfArray<1, float> quant0_scale = { 1, { 0.0039215688593685627, } };
const TfArray<1, int> quant0_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant0 = { (TfLiteFloatArray*)&quant0_scale, (TfLiteIntArray*)&quant0_zero, 0 };
const ALIGN(16) int32_t tensor_data1[4*2] = { 
  0, 0, 
  0, 1, 
  0, 1, 
  0, 0, 
};
const TfArray<2, int> tensor_dimension1 = { 2, { 4,2 } };
const ALIGN(16) int32_t tensor_data2[4] = { 17666, -37725, -25280, -35291, };
const TfArray<1, int> tensor_dimension2 = { 1, { 4 } };
const TfArray<4, float> quant2_scale = { 4, { 0.00041117490036413074, 0.00020728094386868179, 0.0003130215045530349, 0.00022033190180081874, } };
const TfArray<4, int> quant2_zero = { 4, { 0,0,0,0 } };
const TfLiteAffineQuantization quant2 = { (TfLiteFloatArray*)&quant2_scale, (TfLiteIntArray*)&quant2_zero, 0 };
const ALIGN(16) int8_t tensor_data3[4*1*1*32] = { 
  /* [0][0][][] */ 57,-18,-44,-33,78,-51,-22,-29,127,-8,68,37,-34,-47,-42,-21,0,-43,-49,17,19,12,-14,37,-4,26,0,6,37,-26,27,14, 
  /* [1][0][][] */ 41,74,-98,-66,-32,45,122,26,-44,-109,-113,70,105,-44,111,-101,127,-82,37,-28,42,-45,-85,13,17,-76,64,-56,-49,-112,-26,-2, 
  /* [2][0][][] */ -27,60,30,46,-20,7,65,20,-50,-55,56,-20,-70,63,-127,69,31,71,43,-53,-30,23,-109,-1,44,-42,59,-62,-28,11,52,30, 
  /* [3][0][][] */ 62,-62,78,18,-17,100,22,9,-52,-78,39,94,63,-2,-90,6,127,-67,102,23,-77,12,-50,3,76,-31,-116,86,-57,103,28,34, 
};
const TfArray<4, int> tensor_dimension3 = { 4, { 4,1,1,32 } };
const TfArray<4, float> quant3_scale = { 4, { 0.0057015363126993179, 0.0028742509894073009, 0.0043404973112046719, 0.003055221401154995, } };
const TfArray<4, int> quant3_zero = { 4, { 0,0,0,0 } };
const TfLiteAffineQuantization quant3 = { (TfLiteFloatArray*)&quant3_scale, (TfLiteIntArray*)&quant3_zero, 0 };
const ALIGN(16) int32_t tensor_data4[32] = { -1020, -653, 229, -252, -909, -264, -1242, -862, 185, -1578, 587, -1661, -99, -391, -842, -1503, -581, -1570, -708, -1643, -165, -1409, 218, -1382, -922, 689, -437, -212, -1193, -834, -740, -1595, };
const TfArray<1, int> tensor_dimension4 = { 1, { 32 } };
const TfArray<32, float> quant4_scale = { 32, { 6.0598275013035163e-05, 6.2553626776207238e-05, 6.1100763559807092e-05, 7.6957374403718859e-05, 8.6870961240492761e-05, 5.3284344176063314e-05, 5.7516263041179627e-05, 5.9247522585792467e-05, 7.0797621447127312e-05, 5.6684577430132776e-05, 5.1274873840156943e-05, 5.3901396313449368e-05, 6.1449609347619116e-05, 6.810716149630025e-05, 5.2972434787079692e-05, 5.4394979088101536e-05, 6.953968113521114e-05, 5.9158915973966941e-05, 5.1430663006613031e-05, 6.3366918766405433e-05, 7.4720977863762528e-05, 5.6635031796758994e-05, 0.00011526322487043217, 5.4962118156254292e-05, 5.2645580581156537e-05, 6.6948807216249406e-05, 6.7945424234494567e-05, 6.1783466662745923e-05, 5.6987737480085343e-05, 9.8754971986636519e-05, 4.7949812142178416e-05, 5.6734672398306429e-05, } };
const TfArray<32, int> quant4_zero = { 32, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant4 = { (TfLiteFloatArray*)&quant4_scale, (TfLiteIntArray*)&quant4_zero, 0 };
const ALIGN(16) int8_t tensor_data5[32*1*1*96] = { 
  /* [0][0][][] */ -71,-62,53,-46,19,-27,-89,-110,-6,-96,-113,-14,5,-12,-51,-6,-63,-62,-87,-77,-73,-98,-21,53,-127,-25,28,-52,51,-38,-43,-101,55,-86,-105,5,-101,-98,-100,-22,13,-84,-110,48,-5,-115,32,-40,-2,-71,-62,35,-95,-85,-93,53,-7,3,48,-104,-74,38,-77,2,9,-31,25,23,-1,26,34,-98,48,-109,8,37,-115,-14,-69,-27,5,-5,45,-51,-71,-53,-88,29,-4,40,-24,-104,-13,7,-21,-30, 
  /* [1][0][][] */ -86,-9,-60,-8,4,-12,7,-33,41,-127,-87,37,-8,-29,3,46,52,-38,-19,16,-48,-15,10,8,28,-16,-40,51,-22,1,42,-51,4,50,-9,-14,21,13,-31,-63,-54,13,-7,-90,-40,21,-40,-60,-52,-86,60,40,-30,32,-64,-87,-17,37,79,49,-18,65,-50,-98,-86,22,39,1,46,42,-15,30,-80,50,-56,20,71,-47,-51,20,-85,92,-79,-89,0,58,-65,-49,22,27,29,-27,70,17,-42,39, 
  /* [2][0][][] */ 33,51,-21,45,-16,-37,52,106,-80,100,-46,67,69,-10,72,-106,-40,-32,58,28,-65,-11,86,20,-56,60,46,21,-48,28,58,38,-51,1,-78,-43,-66,68,106,-41,-90,-98,16,17,-42,84,-20,-60,78,23,123,-89,-7,62,32,54,-72,27,-86,-24,-16,52,-45,34,55,26,33,67,-127,54,-8,-94,12,-29,56,34,-88,-10,-3,27,17,-85,26,-40,-7,-69,-32,-63,70,88,25,38,-46,-75,14,-81, 
  /* [3][0][][] */ 9,-40,34,5,-62,-6,-63,61,43,-42,33,-36,59,77,37,-14,16,44,-25,-36,75,-50,-29,-67,-23,-103,-58,72,-22,-71,51,-61,-47,-2,10,-58,-93,-40,60,28,-68,-60,-19,-1,44,42,-52,-47,31,-102,24,-38,80,25,77,-79,-58,-94,-29,-76,-9,2,-25,8,14,-42,-42,-16,-48,3,32,26,32,-89,45,-13,13,50,54,-46,-79,-33,60,44,-6,-25,-47,-127,-40,40,-11,-98,51,-127,-20,72, 
  /* [4][0][][] */ 62,42,-31,9,-47,69,0,9,5,96,-16,8,25,-47,-28,-50,-36,-23,-9,74,11,-62,17,-12,-15,-24,17,-44,-45,-1,-50,-10,29,43,-9,20,-39,-26,-46,12,-46,-49,-81,-70,11,6,-2,7,0,-42,-60,-50,-63,1,-29,37,31,-64,-10,-8,-46,-74,-38,-50,15,1,-17,-29,17,-101,-66,-67,-57,18,65,1,12,-29,-19,-47,-5,-50,-73,-18,-7,33,18,-9,-95,-65,-20,81,-20,127,-41,-48, 
  /* [5][0][][] */ 85,-53,70,38,83,-120,6,51,70,-80,-13,-36,-55,92,37,15,33,36,-84,82,46,25,4,-20,-124,-35,-42,-82,22,25,1,-68,-30,9,-92,29,-113,-13,65,-12,-67,-77,41,89,-16,23,16,-59,-76,36,121,68,2,6,21,22,51,-11,-47,-46,81,-64,71,-113,-57,77,-36,30,-9,17,-37,-42,-53,104,16,-60,-7,-49,-4,82,75,54,63,74,-81,53,-18,42,68,-80,115,127,60,14,83,-31, 
  /* [6][0][][] */ -35,-92,64,63,-6,-80,-21,15,-34,-121,-15,-63,47,36,63,-95,-3,-18,-48,67,-54,-108,57,29,-55,-85,-23,-65,-53,-66,-4,-87,-79,-102,-28,-127,-40,5,-81,30,35,30,29,-42,-98,80,-93,-57,-90,-23,-12,-47,18,-48,58,-62,-26,-40,4,69,-22,-42,87,-102,-87,35,56,-68,38,33,-99,9,25,-46,-87,-47,-49,-107,-67,-47,-10,22,8,-50,-81,-91,-67,-83,55,50,54,-7,5,-121,15,48, 
  /* [7][0][][] */ 58,6,-41,-21,-14,43,-25,-28,75,-89,-84,15,37,-58,14,41,11,-11,-28,74,56,8,-24,57,-69,34,16,33,-83,109,-44,36,-18,-6,49,10,-103,34,8,-44,43,-62,75,34,15,6,36,-103,3,-71,-77,-44,-17,36,0,-28,80,-100,49,-57,34,-36,81,-127,-89,-49,34,-11,-92,49,57,73,59,-8,24,32,-31,18,-87,-8,45,6,-26,-69,43,-1,-109,67,61,-10,35,60,-5,-56,-22,12, 
  /* [8][0][][] */ -4,2,-53,-74,-13,72,-38,-44,2,46,25,55,63,-56,-64,-17,-13,68,26,-18,-9,-5,46,60,-48,78,36,62,-12,40,-35,71,90,-27,30,26,110,-7,-23,46,62,63,-100,-86,-5,-60,-14,90,28,-10,-99,-25,-12,-51,-27,-80,37,87,-122,83,-4,48,-17,127,101,-27,0,56,-49,-21,28,-19,39,-25,-15,3,-23,77,60,14,47,-10,-100,-27,41,41,57,-18,9,-28,-44,63,-110,-47,-37,-53, 
  /* [9][0][][] */ -35,-31,50,-1,85,-60,-74,-126,-5,1,-44,4,8,-97,-114,-57,-31,-37,-43,-16,-33,39,-119,-116,49,-43,-46,-16,27,-36,-104,56,10,-36,-16,-51,-95,-24,5,-70,-1,-88,5,-108,25,-21,-116,4,2,20,-99,-4,93,-94,-88,42,104,-82,17,-40,-104,45,87,-94,-49,-33,43,-1,4,41,46,-105,-32,27,-47,-109,-27,-127,-67,43,-11,-17,41,-15,-70,-109,-9,-49,39,-12,-53,118,47,36,10,-64, 
  /* [10][0][][] */ -9,108,105,-52,8,107,92,96,33,65,25,-73,93,77,-11,-17,-29,63,-42,-19,0,28,67,-43,28,16,-100,-63,-37,65,-69,-58,46,127,105,116,-26,4,19,25,-29,59,-80,0,-50,-49,3,-46,3,-11,63,-12,103,45,-16,13,-89,-56,7,-73,-1,70,102,34,88,-61,-79,-11,-13,0,-19,-110,96,58,-22,118,-43,70,61,42,54,-8,107,87,-82,67,54,-60,38,34,10,95,-76,-57,22,-74, 
  /* [11][0][][] */ 49,-29,-51,43,56,-3,3,-11,49,36,-101,50,-6,-106,-17,-91,-85,-121,15,7,-15,20,-20,-127,-116,-115,-56,17,23,-7,-19,-54,-109,-97,2,-1,-90,21,-50,-87,-60,43,-99,-35,-72,-87,-112,-111,22,44,89,1,-114,-112,-26,-18,-39,-83,-62,-110,-103,30,29,-31,5,30,-85,-16,57,6,-106,-96,-7,51,-118,1,-92,-13,-75,31,-124,-59,-87,-74,-3,-103,-28,-59,-115,-45,-30,-96,-105,-28,-62,-70, 
  /* [12][0][][] */ 13,47,-33,7,92,-3,-21,11,-56,33,-7,42,-81,28,42,-45,-75,-27,-35,-40,45,-9,2,81,-58,-24,63,-83,46,41,-42,99,-49,-49,-38,7,-15,-31,-4,21,90,22,-68,-21,-15,-52,-38,70,-29,-109,28,113,-33,-18,-66,91,-13,-59,29,58,88,56,38,-13,47,37,-30,77,41,82,-39,82,39,114,4,-5,-8,12,-82,-60,-33,103,56,-1,-26,31,30,107,-42,-81,62,57,127,0,13,70, 
  /* [13][0][][] */ 60,-79,70,73,47,47,48,77,40,-119,-2,-49,70,30,31,-62,-106,-62,-28,0,36,-25,79,-37,-67,-64,-5,31,-77,-66,47,-16,-18,70,6,-30,-87,-62,34,41,-106,18,-35,-18,-47,17,-37,-28,-7,36,-66,-110,-18,31,88,-105,-33,-16,17,-97,-28,55,-43,-8,-59,-76,-69,50,-35,18,127,-60,-33,-15,-58,-16,-77,33,46,-45,-9,-67,78,5,-81,-104,13,5,-9,-18,-68,71,39,-116,75,33, 
  /* [14][0][][] */ -47,-116,44,74,46,-7,-3,-120,-81,-81,58,79,-73,-67,-94,-90,-52,-72,-8,9,-8,4,-22,46,-103,-86,-32,8,-98,-57,-127,50,72,-68,11,-63,71,79,57,-98,-17,-74,8,45,29,-86,-26,-73,95,22,79,82,52,-82,-31,-3,1,-19,71,70,28,-101,30,-3,-71,-20,50,-101,-37,-109,-51,105,12,21,32,-78,69,-114,47,-32,44,5,-74,-59,-98,-78,-115,110,100,14,60,-44,94,97,-9,90, 
  /* [15][0][][] */ 9,-53,-61,17,42,-32,16,-121,9,-31,-89,7,106,-33,-102,-124,46,-25,-80,51,16,-20,23,57,28,22,-1,36,79,34,17,-106,-43,-35,-35,-37,-85,63,50,-90,-13,56,-62,-50,-10,-93,-58,-91,-47,-7,-32,11,-66,-124,28,-22,43,7,-64,52,-67,-70,67,40,0,49,-91,-45,-59,-12,25,-89,-20,-44,58,-121,-25,9,49,20,-92,12,-105,-84,-127,-53,-107,4,47,31,-67,12,12,125,-119,121, 
  /* [16][0][][] */ -41,-5,63,-36,58,43,-41,24,28,5,-74,60,-33,-15,-35,-46,42,36,31,41,90,33,-39,32,-35,23,-53,31,-82,28,7,21,-76,45,25,18,-48,32,8,-59,6,-42,57,49,38,73,41,-24,-39,-100,82,94,-39,65,38,45,6,20,69,-4,127,44,49,-1,-9,7,-35,60,8,88,-65,13,11,80,50,49,1,40,-76,-4,-2,-21,70,-2,-7,47,44,18,60,9,-5,109,96,-28,-28,69, 
  /* [17][0][][] */ -13,-115,-14,22,-66,-116,-85,-106,-6,-99,26,2,39,9,-120,-1,-12,1,31,99,-103,-46,-26,-74,-18,14,-94,-17,42,-55,-60,21,-63,-54,-23,-30,-70,37,-85,-63,-105,-65,-47,-42,-30,-26,27,-116,26,44,-45,-16,-59,20,38,-89,-127,27,-97,-118,-11,-104,37,24,-80,-89,-6,-74,-112,-38,42,-14,-25,-121,-81,12,48,-71,-6,-80,-29,-47,-91,-103,-118,17,22,-59,-21,18,-113,-69,-44,46,-28,47, 
  /* [18][0][][] */ -124,64,81,-86,42,-59,-100,-37,-33,32,-106,-20,-74,16,32,-58,2,-40,3,-62,62,-53,3,-78,-5,-110,-26,86,9,66,-22,25,26,-62,-90,-122,-34,-17,-91,27,-61,-15,-83,-23,-122,-12,-21,-27,0,-37,9,12,-127,-47,-20,43,2,-6,-50,-113,47,76,-48,1,-102,-124,-40,35,5,-107,-67,74,-92,-81,-98,-95,-13,33,-16,-69,-73,-12,-49,-98,64,-39,39,-3,-115,-90,-73,50,46,-92,-5,-61, 
  /* [19][0][][] */ -12,-21,50,15,10,-59,30,117,47,-83,-16,-39,-17,-12,-73,25,24,-108,127,31,-53,37,-68,-22,45,-78,-21,-47,-75,-119,-67,-10,43,-77,18,-7,-30,-88,20,-67,-13,-120,-80,-27,-101,-20,8,-83,-54,30,-32,-10,31,-15,-17,-43,17,57,15,-48,-4,13,64,21,-9,-39,-44,10,-35,8,33,-77,-61,-104,-45,-66,-49,-110,-23,47,6,-93,-20,32,-95,-31,-16,-42,31,-14,23,31,-63,74,49,-63, 
  /* [20][0][][] */ 89,53,37,66,-61,44,-1,49,-6,63,-54,0,18,49,31,-44,-35,-26,-21,56,13,-30,-49,-36,34,-20,-53,2,-11,35,-19,122,42,41,-9,54,8,8,-16,-70,-35,-35,-40,-45,-4,-31,-2,41,22,-83,-14,67,1,127,18,23,64,48,110,48,69,-40,21,-14,0,-26,-41,4,-1,-48,-53,49,-60,20,51,4,69,39,49,78,52,0,52,-16,24,88,-15,65,14,43,13,41,28,114,-4,8, 
  /* [21][0][][] */ 55,25,35,-99,23,-67,16,40,-37,-60,-98,14,38,-7,-70,-108,-105,-67,53,-20,52,-61,27,-93,-5,-101,-75,36,0,-10,-31,-69,-35,1,-81,-111,50,31,-63,-58,-48,-43,0,-38,-119,-93,-96,39,-64,-58,-6,25,39,30,-82,15,-37,24,-89,53,5,-84,-9,-32,35,-19,-56,-76,-95,-21,30,6,-5,-40,52,28,-127,-50,9,65,-28,43,28,-97,-22,-112,16,-114,-104,30,53,-112,-73,-61,21,-31, 
  /* [22][0][][] */ 19,-6,-8,-41,67,-20,32,78,-38,127,-27,-44,74,-50,-40,-38,28,34,8,-10,22,-16,30,-1,57,8,-54,42,-24,-33,13,-40,70,50,31,37,28,-1,26,-35,1,2,-4,45,33,-42,77,-4,-9,-31,-16,-11,9,-7,24,18,-5,-10,-15,-14,0,21,-40,26,9,-4,-41,-29,48,25,22,-17,-8,12,45,-21,14,1,20,57,32,-60,-31,1,30,33,41,-17,-32,19,-30,8,-18,10,-14,27, 
  /* [23][0][][] */ 52,-104,-31,12,37,-101,-30,-98,12,-91,32,25,2,-119,-20,-62,39,-60,-56,111,39,-97,48,-60,-46,-48,30,-15,24,36,23,-69,-57,0,-17,38,42,-38,-88,-27,-116,-36,-28,-121,-91,-108,54,-10,30,-114,-49,-71,55,-81,-80,34,-60,-36,39,6,-127,-107,-76,-42,62,-3,-124,-114,59,-49,62,-91,-41,-43,-67,-107,4,-51,40,54,-69,-78,-12,-116,42,-26,56,-47,-98,2,54,12,46,10,-9,29, 
  /* [24][0][][] */ -108,-64,-84,-81,-109,-127,-77,-60,30,52,44,9,54,30,-55,-123,-91,14,-19,-82,56,-87,-66,-50,2,-52,42,45,42,7,-20,-89,-39,-15,4,-7,-65,-98,8,-42,-88,-104,64,-21,-11,-54,-5,15,-112,-79,-34,-28,7,11,78,-86,26,33,-18,-25,53,-52,-13,60,-120,53,-59,-103,-124,27,-49,-45,-52,1,84,65,24,-82,-106,-91,-91,-97,-69,-119,-23,30,-37,-110,0,-110,-36,-102,-38,-17,-118,22, 
  /* [25][0][][] */ -70,-32,-31,-19,48,-40,-58,37,20,-28,-19,-5,48,0,-64,0,-15,39,54,-81,36,73,25,-37,5,-44,-67,60,75,-81,47,48,98,-66,30,63,93,-47,-53,-6,-58,72,-63,15,42,32,34,29,-54,93,-110,-19,84,0,-49,-35,-10,81,-84,63,43,48,10,121,127,37,7,-23,-78,-4,61,-83,44,-101,41,39,29,83,16,15,19,18,-48,54,-38,-39,-34,-81,-27,-20,79,11,-106,-24,-12,-64, 
  /* [26][0][][] */ 9,-122,-8,28,-34,-41,-8,-1,-62,-127,60,31,-44,-41,-1,-12,50,15,-67,-42,9,42,66,4,51,-2,3,18,-27,35,-62,0,-61,-34,-36,-124,-69,39,-28,65,-85,76,57,-4,-63,59,-51,52,-54,-5,-22,41,32,-7,6,-114,39,27,104,4,7,-64,52,-31,83,-29,-38,17,-50,83,99,72,65,-83,-85,16,57,-75,-68,-7,-57,67,38,-50,34,-30,-51,-11,-61,70,-11,-1,-33,24,-7,105, 
  /* [27][0][][] */ 6,9,-47,-79,-83,-58,-52,-10,32,51,19,-88,-30,33,57,-26,40,1,42,-100,-75,2,-21,-31,-97,49,-91,-13,46,12,-26,-37,88,55,-61,-45,-89,-34,-70,74,-69,0,5,5,80,13,57,74,113,62,81,-63,-86,-65,-14,1,36,-12,-88,-71,-58,-34,-18,49,18,-50,-85,99,34,-22,-127,-21,39,-47,8,-63,23,-50,60,107,71,-39,90,-46,-65,-69,-10,15,-35,6,47,-58,4,18,81,4, 
  /* [28][0][][] */ 127,-21,26,6,-46,21,-95,-91,-50,-89,15,118,-1,-103,-26,60,48,58,10,72,-62,-9,-111,-86,-83,23,-78,-65,-63,-72,-27,7,-85,-17,34,37,-1,-109,-69,0,51,3,-111,4,-103,-51,-19,12,15,17,-94,-49,-79,-10,-3,10,101,-1,22,35,-34,-66,-102,50,29,31,-41,40,-32,-26,-28,-49,15,12,-32,-107,-109,-74,-87,25,-64,-119,45,-57,29,-88,34,-58,-110,-80,-63,-15,-46,81,-95,-104, 
  /* [29][0][][] */ -12,12,5,-45,-127,12,-60,2,32,-53,-52,-37,48,-60,-38,-44,-65,25,29,-80,-42,-33,6,-19,-49,-24,-45,-15,-31,-22,17,-40,24,-11,-46,-38,-25,29,20,29,4,20,-43,11,-11,26,-47,-16,8,6,28,-60,41,-65,49,21,-32,1,-40,20,-68,28,-53,-54,-51,-57,5,32,26,-60,-16,-65,37,4,30,-8,25,-47,-22,12,-18,-53,12,-61,6,7,-2,11,-22,49,34,6,-83,0,19,8, 
  /* [30][0][][] */ 3,-89,-82,21,-91,10,-82,-32,96,-31,-26,-38,-90,1,19,8,-24,13,83,-110,30,-112,-125,-10,-113,2,-77,100,-13,-97,-97,-13,-76,-87,-107,-73,-6,-44,-13,6,52,-94,-37,59,60,-59,64,28,-77,67,15,-100,84,-61,-39,63,-75,-50,-75,-55,-97,-23,-85,-26,-104,-102,-103,73,-61,78,42,-41,-81,68,9,-92,-53,-83,-84,-65,7,22,-95,-24,-118,-5,-102,85,-38,-127,62,44,-35,-9,3,-71, 
  /* [31][0][][] */ 26,-106,-8,42,5,13,-80,-110,-57,-50,-95,-94,76,-127,-72,49,-82,-103,22,9,15,-8,-59,45,-2,-121,-7,-4,-86,-72,1,48,-20,-19,-101,-41,38,-58,-82,-119,11,-87,-57,-11,-32,-76,-65,-16,19,-1,69,-56,-116,-78,-95,-13,-120,18,0,51,-64,-38,32,-88,23,50,-69,-91,26,-120,-123,-26,-107,-65,-32,-30,-78,-71,3,34,-92,-65,22,21,8,38,-107,-21,-19,-73,-93,-70,-25,46,-29,-28, 
};
const TfArray<4, int> tensor_dimension5 = { 4, { 32,1,1,96 } };
const TfArray<32, float> quant5_scale = { 32, { 0.0025754265952855349, 0.0026585289742797613, 0.0025967822875827551, 0.0032706884667277336, 0.0036920157726854086, 0.0022645846474915743, 0.0024444411974400282, 0.0025180196389555931, 0.003008898813277483, 0.0024090944789350033, 0.0021791821345686913, 0.0022908092942088842, 0.0026116082444787025, 0.0028945542871952057, 0.0022513284347951412, 0.0023117866367101669, 0.0029554362408816814, 0.0025142538361251354, 0.0021858031395822763, 0.0026930940803140402, 0.00317564164288342, 0.0024069887585937977, 0.0048986868932843208, 0.0023358899634331465, 0.0022374370601028204, 0.0028453241102397442, 0.0028876804281026125, 0.0026257974095642567, 0.0024219788610935211, 0.0041970862075686455, 0.002037866972386837, 0.0024112234823405743, } };
const TfArray<32, int> quant5_zero = { 32, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant5 = { (TfLiteFloatArray*)&quant5_scale, (TfLiteIntArray*)&quant5_zero, 0 };
const ALIGN(16) int32_t tensor_data6[96] = { -3736, 4322, 12110, 2604, -4679, -4005, 27523, 2327, 1864, -1859, 11539, -1309, -11064, 3294, 14874, 4532, 18132, 4818, -6526, -7940, 3873, 27770, 23129, 21348, 1386, 1043, 4942, 3424, 2849, -5371, 6447, -4108, -393, 4425, 15, 1541, 8552, 7191, -2406, 7500, 11380, 8327, 4121, 13489, 5597, 4462, 1782, 13394, 6625, -5851, -9632, 222, -645, -1217, 1322, 102, -105, -1319, -3864, 8759, -937, 1733, -1679, -2221, -4707, 10004, 22667, 1464, -3142, 429, 2132, 1912, 2778, -1723, 465, 13940, -694, 24920, 25878, -1801, 9503, 1623, -1099, 1220, 13633, 12035, 6019, 1343, 3716, 7607, -511, -8828, 641, -3241, -2682, -2400, };
const TfArray<1, int> tensor_dimension6 = { 1, { 96 } };
const TfArray<96, float> quant6_scale = { 96, { 0.00020260854216758162, 0.00036840824759565294, 0.00018197552708443254, 0.00024626145022921264, 0.00024761343956924975, 0.00040321849519386888, 0.00011849576549138874, 0.00028991367435082793, 0.00024428140022791922, 0.00031791321816854179, 0.00016777151904534549, 0.00017855616169981658, 0.00024102098541334271, 0.00085200904868543148, 0.00020266497449483722, 0.00026314915157854557, 0.00010025505616795272, 0.00028401199961081147, 0.00030066241743043065, 0.0002227176446467638, 0.00013490008132066578, 9.5070019597187638e-05, 0.00012574686843436211, 7.6390831964090466e-05, 0.00022472444106824696, 0.00042955731623806059, 0.0005989277851767838, 0.00028048257809132338, 0.00016703865549061447, 0.00038515249616466463, 0.00021738774375990033, 0.00021282403031364083, 0.00018950349476654083, 0.0002338804624741897, 0.000302710453979671, 0.0002032826014328748, 0.00022869452368468046, 0.00013579310325440019, 0.00029467931017279625, 0.00022512795112561435, 0.00011350387649144977, 0.00029702353640459478, 0.00033715786412358284, 0.00016625580610707402, 0.00032992614433169365, 0.00020176214457023889, 0.00026421528309583664, 0.00016164116095751524, 0.00021537038264796138, 0.0002269814140163362, 0.00016624273848719895, 0.00020540463447105139, 0.00033960613654926419, 0.00027813517954200506, 0.0004461501375772059, 0.00029513787012547255, 0.00033215087023563683, 0.00032791352714411914, 0.00040526952943764627, 0.00020648616191465408, 0.00080568419070914388, 0.00035168597241863608, 0.00022703490685671568, 0.00029477395582944155, 0.00042428320739418268, 0.00018508303037378937, 9.3398892204277217e-05, 0.00021142387413419783, 0.00038546585710719228, 0.00033564912155270576, 0.00016973006131593138, 0.00026607018662616611, 0.00042630324605852365, 0.00025230186292901635, 0.00028224807465448976, 0.00014781104982830584, 0.00025181291857734323, 7.719598215771839e-05, 7.1203947300091386e-05, 0.00021024483430664986, 0.00015226798132061958, 0.00014789345732424408, 0.00021439293050207198, 0.00023783957294654101, 0.0001304749894188717, 0.00019529068958945572, 0.00039237632881850004, 0.00019120890647172928, 0.00016828879597596824, 0.00023026761482469738, 0.0003060516610275954, 0.000242160793277435, 0.00027742085512727499, 0.00033031453494913876, 0.00029327100492082536, 0.00022520952916238457, } };
const TfArray<96, int> quant6_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant6 = { (TfLiteFloatArray*)&quant6_scale, (TfLiteIntArray*)&quant6_zero, 0 };
const ALIGN(16) int8_t tensor_data7[96*1*1*16] = { 
  /* [0][0][][] */ -59,44,-26,-95,-92,5,-50,-127,-5,-2,0,103,13,-94,3,54, 
  /* [1][0][][] */ -28,21,-15,12,-53,-6,48,-127,55,3,-32,1,14,-23,15,-99, 
  /* [2][0][][] */ 91,26,-61,48,21,-46,-127,-79,109,-50,80,30,-40,45,-72,10, 
  /* [3][0][][] */ 41,5,-27,-120,5,-22,-51,61,59,28,125,18,-92,17,3,127, 
  /* [4][0][][] */ -16,127,14,109,-13,-7,15,-4,18,-6,28,-28,-96,-60,0,2, 
  /* [5][0][][] */ -74,37,124,-16,-21,83,-1,41,-98,119,-55,-26,56,-72,-127,-31, 
  /* [6][0][][] */ 46,-71,72,-81,26,102,-91,96,-73,-68,33,-20,91,96,-2,127, 
  /* [7][0][][] */ 52,39,-55,23,4,-7,-48,-74,127,43,7,24,40,-56,24,16, 
  /* [8][0][][] */ 28,-89,27,-46,74,-43,-2,-53,66,69,53,0,44,127,126,-3, 
  /* [9][0][][] */ -37,-20,18,90,45,-18,47,-127,-58,44,39,-12,-26,-113,-13,-65, 
  /* [10][0][][] */ -20,28,-24,-127,-21,82,-10,50,-11,33,-13,-38,5,17,22,52, 
  /* [11][0][][] */ 10,52,32,-53,90,-49,108,24,-127,78,-2,-13,-25,109,-110,-1, 
  /* [12][0][][] */ -2,11,-4,-33,14,-33,24,25,-12,117,-19,-69,-39,127,-48,84, 
  /* [13][0][][] */ -13,-36,-38,-20,19,-127,-45,48,-15,-36,55,45,26,-7,31,44, 
  /* [14][0][][] */ 49,-26,28,-5,37,-56,-127,-95,5,-39,72,27,-57,-54,-66,-42, 
  /* [15][0][][] */ -77,32,4,-6,-40,32,127,21,-29,49,2,-12,-27,51,35,10, 
  /* [16][0][][] */ 12,76,71,122,29,-8,127,83,-68,32,-4,-10,-65,18,-21,-53, 
  /* [17][0][][] */ -18,-127,-7,64,-49,-22,-101,14,-96,-11,-2,-12,30,45,62,-31, 
  /* [18][0][][] */ -7,92,38,108,-20,45,19,54,37,13,-55,-45,3,127,31,10, 
  /* [19][0][][] */ 60,51,90,8,15,-48,-17,-127,-44,-57,-42,-90,-22,-96,-68,-60, 
  /* [20][0][][] */ 127,84,-36,25,-4,-127,0,14,2,49,13,-36,-33,-25,-42,23, 
  /* [21][0][][] */ -6,-81,64,41,-32,-67,127,96,15,-28,35,44,-36,126,-14,107, 
  /* [22][0][][] */ 44,17,-92,127,-42,63,-43,84,13,68,64,48,5,3,-4,21, 
  /* [23][0][][] */ 79,21,118,-94,37,-86,42,31,-48,-48,31,-29,-111,1,-127,51, 
  /* [24][0][][] */ -126,51,53,-34,3,127,-4,-25,-14,41,69,10,-70,-18,42,-113, 
  /* [25][0][][] */ 27,12,29,-13,5,33,-1,-37,-34,-127,-37,-16,11,29,-21,42, 
  /* [26][0][][] */ -32,13,15,-31,-37,-29,-1,-23,-127,-62,8,-28,-31,117,-26,30, 
  /* [27][0][][] */ -15,54,0,86,19,1,4,5,42,37,-13,-24,-14,127,-2,45, 
  /* [28][0][][] */ -10,121,92,90,76,73,89,93,-74,-43,-66,-15,7,127,78,-2, 
  /* [29][0][][] */ -19,-35,32,16,-14,19,-4,54,-57,45,-75,-127,33,14,-14,-9, 
  /* [30][0][][] */ 2,44,-47,73,-24,-34,17,-127,-12,36,4,15,40,9,40,37, 
  /* [31][0][][] */ -52,-49,22,-127,-34,46,-33,-27,71,98,-74,-50,2,-54,-14,79, 
  /* [32][0][][] */ -127,-21,59,-4,18,38,2,44,-55,-7,-101,-31,52,11,64,82, 
  /* [33][0][][] */ -11,-41,-26,-15,-81,6,-109,-76,53,46,-14,-46,79,-127,83,10, 
  /* [34][0][][] */ 51,-31,35,33,52,39,-29,46,-53,-16,29,2,24,16,23,127, 
  /* [35][0][][] */ -72,57,5,-13,-39,-30,68,-127,17,96,-97,-27,-16,-83,-8,-79, 
  /* [36][0][][] */ -36,49,21,69,-20,69,127,31,-15,43,-58,-34,13,16,4,-21, 
  /* [37][0][][] */ 80,-17,41,-127,14,-28,-123,0,-119,11,34,-11,-48,-119,43,-20, 
  /* [38][0][][] */ 51,36,-25,27,101,24,48,-6,81,36,0,5,65,27,127,-3, 
  /* [39][0][][] */ -4,-3,-26,-106,14,53,-127,100,74,-31,-11,32,33,106,23,63, 
  /* [40][0][][] */ -13,-4,65,-127,48,-59,66,-32,-112,6,8,-28,-54,-67,38,-3, 
  /* [41][0][][] */ -1,-20,-63,7,0,47,-4,88,-53,68,-22,-18,-127,81,37,73, 
  /* [42][0][][] */ 127,15,-23,36,-54,-76,-24,-29,17,-5,97,22,-95,68,68,-77, 
  /* [43][0][][] */ 53,36,-58,58,106,-96,67,-61,115,39,-38,43,69,-127,-52,-44, 
  /* [44][0][][] */ -52,-44,54,-61,80,17,-28,-127,-36,-16,-46,8,47,-30,75,-53, 
  /* [45][0][][] */ 82,3,-127,12,25,-69,-64,1,49,8,64,-14,-22,-4,-8,-5, 
  /* [46][0][][] */ 11,-28,-27,-88,3,4,15,-52,-46,-13,8,17,0,-127,65,-9, 
  /* [47][0][][] */ -26,47,72,-36,112,11,28,22,-82,45,-24,36,-17,0,127,-26, 
  /* [48][0][][] */ -86,-47,10,-15,37,27,-14,-57,-17,-6,-108,-19,102,26,127,36, 
  /* [49][0][][] */ 6,-35,71,112,118,45,61,75,-89,-62,-22,-18,9,127,54,0, 
  /* [50][0][][] */ 84,-15,-127,6,78,-123,-71,-82,22,-84,-70,13,77,-14,62,-51, 
  /* [51][0][][] */ 14,68,45,-16,55,-37,37,21,-122,70,50,-127,-33,-106,-42,81, 
  /* [52][0][][] */ 10,74,-85,95,5,-2,-3,54,104,127,29,-23,-6,90,30,27, 
  /* [53][0][][] */ 33,-33,-33,13,-100,-54,-24,-48,75,-27,49,-62,-6,-127,55,-2, 
  /* [54][0][][] */ 48,-52,-47,4,49,36,-127,-12,-13,27,6,-19,34,2,15,15, 
  /* [55][0][][] */ 37,-6,23,18,60,-110,-3,-127,-1,-103,-54,-5,10,-32,6,-27, 
  /* [56][0][][] */ -47,14,52,-54,-12,-29,-50,109,8,127,19,-3,-1,-1,-30,34, 
  /* [57][0][][] */ -12,-14,12,-9,-96,-31,127,87,-16,59,-12,14,5,28,56,-43, 
  /* [58][0][][] */ 11,28,-127,2,48,41,-52,-29,-97,-22,62,-8,-69,48,-13,-23, 
  /* [59][0][][] */ -68,82,89,10,-22,-58,97,127,-13,14,32,-22,-31,15,38,-15, 
  /* [60][0][][] */ 13,-3,-8,10,5,-127,3,1,3,-61,3,-16,15,-16,-14,-22, 
  /* [61][0][][] */ 40,-48,26,127,99,-8,-12,23,-75,-9,15,67,7,38,24,-49, 
  /* [62][0][][] */ 45,127,1,6,29,-46,-51,53,12,-43,-19,-39,-40,-47,-73,-68, 
  /* [63][0][][] */ -14,96,-7,127,-115,5,-86,-25,-36,-9,-29,-68,37,85,-38,46, 
  /* [64][0][][] */ -26,-20,47,71,-6,33,41,127,-18,31,-62,-19,21,-12,16,-20, 
  /* [65][0][][] */ -34,-43,31,-65,17,-86,127,-68,-6,-20,23,-73,-91,-44,-35,-41, 
  /* [66][0][][] */ -42,2,127,-42,24,-45,125,96,-58,-25,33,-17,-92,123,-34,66, 
  /* [67][0][][] */ -5,-5,0,-107,29,-6,-72,33,92,-127,-67,47,52,73,122,10, 
  /* [68][0][][] */ -28,65,127,28,28,-39,32,3,-28,-20,8,-80,-21,-36,56,-11, 
  /* [69][0][][] */ 99,96,31,28,-121,-87,4,-61,40,30,127,-17,-102,41,-38,-35, 
  /* [70][0][][] */ 91,47,-87,71,-40,92,-16,115,33,127,-23,27,50,43,-34,21, 
  /* [71][0][][] */ 17,12,-6,-14,13,-68,-8,42,-45,3,-25,-8,-127,15,19,33, 
  /* [72][0][][] */ 15,-48,-127,33,24,4,15,118,-38,-25,29,57,52,33,8,31, 
  /* [73][0][][] */ -15,41,60,24,31,-99,-40,-127,36,-119,52,-21,-17,-72,24,-19, 
  /* [74][0][][] */ 14,-12,33,127,37,-22,-40,53,-25,-27,-39,25,67,-40,79,-91, 
  /* [75][0][][] */ 44,7,-80,27,-30,-39,-8,-63,127,43,44,-4,-7,76,-72,4, 
  /* [76][0][][] */ -23,21,14,-9,35,3,24,88,-1,-2,-10,-127,-15,-4,0,23, 
  /* [77][0][][] */ 6,-1,29,118,-101,23,127,12,41,66,-66,12,67,-42,-16,-34, 
  /* [78][0][][] */ -46,-22,41,-68,83,66,-30,66,41,18,-76,-11,127,111,123,39, 
  /* [79][0][][] */ -27,-67,0,-59,-52,-10,16,-127,43,36,-44,29,27,-22,73,-80, 
  /* [80][0][][] */ -23,-48,127,21,68,12,-25,-30,21,-3,-97,-11,94,87,59,-84, 
  /* [81][0][][] */ -98,74,-65,-21,22,-127,30,65,-50,-36,102,-13,-39,16,-1,15, 
  /* [82][0][][] */ 127,-26,-39,31,22,-69,-86,-2,39,5,-35,29,91,-10,-3,3, 
  /* [83][0][][] */ -61,29,-127,-23,-13,-13,125,-111,80,37,-37,-72,8,29,59,113, 
  /* [84][0][][] */ -90,28,72,-19,-7,18,127,-39,-36,83,-14,-39,-20,82,78,56, 
  /* [85][0][][] */ -87,127,36,-98,-101,-39,-8,-77,-49,-30,-43,15,-29,-34,-59,-25, 
  /* [86][0][][] */ 0,-7,11,5,-13,-40,127,-16,11,-18,-37,29,54,20,54,-55, 
  /* [87][0][][] */ 2,-6,18,-127,19,-45,31,29,-17,27,-12,-99,-19,-12,-13,34, 
  /* [88][0][][] */ 88,3,8,3,21,-127,-27,-11,-20,-17,-20,-37,-24,-35,-7,-30, 
  /* [89][0][][] */ 33,-46,-109,-37,39,25,-78,46,-24,67,104,-48,127,-2,44,-8, 
  /* [90][0][][] */ 30,-20,22,-30,82,-34,-79,61,47,-65,-28,-22,-29,59,2,-127, 
  /* [91][0][][] */ -16,18,-35,39,26,1,33,-127,35,55,-7,-89,-35,-2,-29,-10, 
  /* [92][0][][] */ 8,36,36,8,13,-127,5,3,-1,-13,17,-24,-24,-26,-11,-1, 
  /* [93][0][][] */ 49,-19,76,-27,-127,101,-9,-51,10,-31,-93,-3,12,-53,32,62, 
  /* [94][0][][] */ 24,12,-28,0,44,4,-28,42,3,-37,32,-44,127,-4,35,-33, 
  /* [95][0][][] */ 91,101,-2,6,-68,3,-51,50,-85,33,127,-51,-67,35,96,-30, 
};
const TfArray<4, int> tensor_dimension7 = { 4, { 96,1,1,16 } };
const TfArray<96, float> quant7_scale = { 96, { 0.00046822524745948613, 0.00085138581926003098, 0.00042054263758473098, 0.00056910642888396978, 0.00057223084149882197, 0.00093183177523314953, 0.00027384189888834953, 0.00066998606780543923, 0.00056453055003657937, 0.00073469255585223436, 0.00038771741674281657, 0.00041264054016210139, 0.00055699580116197467, 0.0019689798355102539, 0.00046835566172376275, 0.00060813367599621415, 0.00023168789630290121, 0.00065634737256914377, 0.00069482624530792236, 0.00051469705067574978, 0.00031175202457234263, 0.00021970535453874618, 0.00029059909866191447, 0.00017653804388828576, 0.00051933474605903029, 0.00099270034115761518, 0.00138411286752671, 0.00064819090766832232, 0.00038602377753704786, 0.00089008151553571224, 0.00050237972754985094, 0.00049183308146893978, 0.00043793965596705675, 0.00054049416212365031, 0.00069955922663211823, 0.00046978297177702188, 0.00052850955398753285, 0.00031381577719002962, 0.00068099936470389366, 0.00052026723278686404, 0.00026230572257190943, 0.00068641680991277099, 0.00077916664304211736, 0.00038421462522819638, 0.00076245429227128625, 0.00046626920811831951, 0.0006105974898673594, 0.00037355025415308774, 0.00049771764315664768, 0.00052455055993050337, 0.00038418441545218229, 0.00047468696720898151, 0.00078482460230588913, 0.0006427661282941699, 0.0010310461511835456, 0.00068205909337848425, 0.00076759554212912917, 0.00075780315091833472, 0.00093657168326899409, 0.00047718634596094489, 0.0018619238398969173, 0.00081274088006466627, 0.00052467419300228357, 0.00068121810909360647, 0.00098051200620830059, 0.00042772403685376048, 0.00021584340720437467, 0.00048859731759876013, 0.00089080567704513669, 0.00077568000415340066, 0.00039224355714395642, 0.00061488413484767079, 0.00098518026061356068, 0.00058306573191657662, 0.00065227097366005182, 0.00034158906782977283, 0.00058193580480292439, 0.00017839872452896088, 0.00016455122386105359, 0.00048587258788757026, 0.0003518889716360718, 0.0003417795232962817, 0.00049545877845957875, 0.0005496435915119946, 0.00030152569524943829, 0.0004513137973845005, 0.00090677564730867743, 0.00044188086758367717, 0.00038891282747499645, 0.00053214491344988346, 0.00070728070568293333, 0.00055962987244129181, 0.00064111535903066397, 0.00076335185440257192, 0.00067774479975923896, 0.00052045576740056276, } };
const TfArray<96, int> quant7_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant7 = { (TfLiteFloatArray*)&quant7_scale, (TfLiteIntArray*)&quant7_zero, 0 };
const ALIGN(16) int32_t tensor_data8[16] = { -1641, 50089, -17064, 7216, -6788, 5380, 18925, -40568, -4631, 19841, 36200, -5849, -9000, 24045, 3481, -4796, };
const TfArray<1, int> tensor_dimension8 = { 1, { 16 } };
const TfArray<16, float> quant8_scale = { 16, { 0.0003600020136218518, 0.00027408369351178408, 0.00019165032426826656, 0.00014531740453094244, 0.00030300967046059668, 0.00018381512199994177, 0.00022008763335179538, 0.00024643313372507691, 0.00028493572608567774, 0.00021367523004300892, 0.00031971855787560344, 0.00028055699658580124, 0.00022906679078005254, 0.00018475802789907902, 0.00040238705696538091, 0.00026378681650385261, } };
const TfArray<16, int> quant8_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant8 = { (TfLiteFloatArray*)&quant8_scale, (TfLiteIntArray*)&quant8_zero, 0 };
const ALIGN(16) int8_t tensor_data9[16*1*1*96] = { 
  /* [0][0][][] */ -55,5,28,-22,-6,-77,-64,-40,55,-18,-14,-49,-2,-7,-40,14,40,14,15,-7,13,-31,-62,15,-6,-31,19,127,-5,-29,12,-32,-56,34,22,-22,-16,-21,-87,-33,48,-39,-2,4,7,106,-7,51,-4,-52,-13,-29,29,-5,10,96,6,1,-16,-34,-1,18,-8,4,-36,-37,-3,31,18,22,32,5,25,-30,3,4,-18,10,-33,-25,9,6,19,41,-8,5,20,-74,-31,-38,-12,27,13,-18,-58,-33, 
  /* [1][0][][] */ -24,-127,-95,-1,53,-35,43,-3,1,-72,-85,-29,-7,50,-58,52,-62,32,-19,-55,0,22,16,-90,70,17,49,-99,-14,-33,27,22,25,50,15,-46,-22,-5,54,15,-71,41,-31,-38,1,62,16,35,-15,3,1,-61,-51,-11,63,3,-18,-7,-12,-37,38,-1,-24,-103,-85,88,-27,-13,10,43,11,-29,5,-72,-46,-15,103,-71,35,-10,-51,-5,24,-36,-75,15,-54,-30,3,-54,17,26,1,17,-5,109, 
  /* [2][0][][] */ 36,33,-42,-16,62,74,33,64,-30,-47,-2,12,-43,4,26,4,-23,23,-52,27,-10,-18,127,-6,64,39,14,-25,10,5,71,8,56,14,-42,40,-24,11,28,8,-35,42,31,17,7,-107,-3,-20,22,60,1,20,20,-16,-18,20,7,3,-5,-4,-3,23,26,-49,-6,-48,-4,4,-17,1,-25,-11,-81,-11,-13,42,64,51,48,25,-27,-39,-16,-26,-27,17,-25,16,25,20,44,-43,34,2,14,33, 
  /* [3][0][][] */ -44,-36,36,-30,22,-94,30,10,-23,-63,14,14,35,48,95,82,-21,-41,26,25,81,16,-39,40,-59,-36,-3,30,40,-2,-103,65,-112,-20,92,-24,2,-4,-47,36,-42,-24,34,-53,20,-9,-105,-4,-34,-90,-33,32,22,-19,35,27,-115,49,118,82,6,36,13,-45,73,119,-30,-19,19,13,22,-43,96,-94,18,-5,68,-29,66,-59,35,29,-11,-127,12,47,-4,54,46,-36,-75,45,-64,17,53,-59, 
  /* [4][0][][] */ 6,-4,49,-24,127,34,-20,-24,-5,-48,2,-54,-34,13,-39,39,64,-77,33,88,2,-16,-49,27,-48,-40,61,-11,1,6,25,-48,-1,14,-23,-6,8,-36,-55,-27,60,-59,-8,-22,19,58,-31,11,79,-64,-28,-34,39,-10,17,2,2,-32,-22,16,29,12,8,71,32,37,-6,-7,-38,14,49,95,33,-16,-3,35,54,9,-7,-76,6,-19,-18,36,-52,22,39,76,-85,51,-39,9,5,37,-27,-45, 
  /* [5][0][][] */ 33,3,-28,-25,29,55,29,29,-77,-15,27,42,19,-21,-2,-36,-7,-32,4,8,24,65,21,37,15,24,-38,-47,-18,28,-36,25,-24,-7,-21,-47,46,48,68,14,-56,30,31,-23,-28,-112,26,-59,21,-24,-16,41,19,-52,-11,-29,-34,-17,-32,24,47,11,45,1,-18,35,-15,33,-10,35,-9,6,-3,14,0,35,-127,-19,59,16,-16,-47,-26,45,-3,-10,-12,107,7,52,44,-61,-19,-24,-15,9, 
  /* [6][0][][] */ 49,-65,-14,-35,3,62,39,41,-53,10,-15,8,-20,-15,-9,13,-25,-27,-36,-13,-33,42,65,-11,17,51,-11,-42,31,12,34,21,75,-24,17,-9,20,49,69,-46,-84,116,48,-6,-12,-127,-3,-31,14,103,-44,70,-19,-73,-27,-44,20,-50,5,-23,-4,34,44,-83,12,-21,-13,-3,-27,-4,56,-26,-51,-9,-6,17,-38,-6,48,29,-12,3,19,-22,-8,-18,-3,15,43,22,39,-37,19,-5,7,7, 
  /* [7][0][][] */ 43,127,9,31,62,58,12,20,5,-50,10,-8,-18,7,52,-58,50,-59,-48,-36,31,72,56,8,25,-22,52,48,-5,-1,2,11,21,-2,-32,39,25,1,26,48,-69,-9,-2,-9,-3,44,35,-30,-10,-76,17,31,8,10,-5,90,-25,81,10,9,6,18,-37,3,-33,34,-12,-86,-49,-12,33,-28,-38,-38,-1,8,-106,35,41,2,-46,-62,11,-1,-64,66,27,8,-90,42,-45,-50,-63,9,44,37, 
  /* [8][0][][] */ -2,-11,28,-5,-47,-50,43,-17,6,25,23,-15,8,35,20,11,-44,-7,30,39,-21,-1,-127,55,8,-11,29,12,16,-7,-15,26,7,-23,10,5,-29,-22,-40,12,39,-15,-18,24,-14,41,4,22,-82,-21,3,-5,-50,9,-35,42,-12,-9,-60,7,17,-34,-5,18,19,35,-18,-16,-1,-18,-33,-17,76,1,28,-19,16,10,-4,-21,-36,-6,-33,-15,31,2,55,1,7,-48,-19,27,5,-29,13,-35, 
  /* [9][0][][] */ 1,-81,-15,-19,9,105,8,26,-34,-19,74,97,15,-41,58,-70,7,-46,-48,-11,-39,19,72,-36,-11,21,47,24,-23,30,19,-12,2,17,-83,-3,63,41,18,58,-36,-15,-6,35,-55,-104,-6,-69,41,64,3,10,7,-36,-48,-31,-26,41,-50,21,-27,-11,-5,-17,-55,-9,8,-30,-34,23,-1,-91,10,19,14,43,-97,-10,83,53,-53,-43,-8,25,27,-69,14,27,21,-19,48,11,-127,-45,32,-6, 
  /* [10][0][][] */ -67,-44,-11,-8,-39,-94,22,-38,125,-32,13,-19,-5,42,16,-8,19,48,-23,-43,15,22,-43,-13,-38,-64,23,-127,-17,-28,58,-49,5,60,24,0,10,-16,-14,-26,45,-95,24,-42,10,116,-23,45,-9,10,-46,-47,-16,12,1,-25,29,51,20,-35,47,61,-73,12,-34,97,7,-6,46,15,43,-39,-26,-20,-26,84,-15,42,-61,-3,-10,35,32,27,-19,8,21,116,-57,-20,-56,19,2,-25,3,9, 
  /* [11][0][][] */ -77,25,23,-22,30,-61,-14,54,-70,-23,57,49,64,-48,11,-25,55,-20,-10,22,45,-4,-54,68,-8,-23,35,33,-3,79,-121,51,-42,5,7,-21,11,-12,50,29,43,0,7,8,85,-23,28,-15,98,-15,-16,98,48,-16,31,-22,-50,-7,-16,23,38,-17,-22,53,-25,11,-4,15,34,-17,-6,61,13,27,15,30,-109,80,-123,13,22,-6,-87,-27,127,29,66,74,11,98,-110,-76,-39,56,0,-36, 
  /* [12][0][][] */ -9,-8,-22,-26,31,43,1,-53,-65,65,48,22,40,-47,-17,40,-19,-37,78,28,-30,9,-60,70,-37,-5,-55,93,28,39,-88,-3,-71,-4,-34,1,-26,-22,-56,0,16,10,-14,-44,-27,-50,30,15,17,-17,-3,-8,-14,14,-8,-48,4,-29,-3,7,-64,-64,60,78,33,-27,17,26,-46,-127,-27,55,84,-17,29,68,-46,-30,-46,-24,-29,-33,-35,-10,58,-52,3,-9,32,19,-29,48,-60,31,-7,-40, 
  /* [13][0][][] */ -32,42,-66,9,-55,-22,-1,-2,-87,-12,19,8,61,-38,-34,-52,-33,-45,-35,-33,-3,73,43,-62,56,-11,4,44,26,-23,-69,-50,-81,10,-6,2,-12,9,41,49,-17,37,4,-8,17,7,29,43,21,-28,-1,59,12,-41,24,41,-102,3,-8,3,36,22,-28,26,-10,-21,-67,-71,-23,29,-4,-89,36,-2,-39,-20,-127,-2,2,-42,3,-64,9,-13,-7,-55,89,-9,-70,7,-21,-3,-12,-28,-28,16, 
  /* [14][0][][] */ -35,43,-30,0,7,23,-15,-1,-127,56,61,29,-22,-78,-81,11,-63,-34,46,9,14,-18,16,-95,-25,-10,-71,-4,17,18,-51,40,-3,-24,-42,9,-52,-24,20,22,-3,47,-29,-44,-52,-28,8,-14,85,-3,-6,24,40,34,-21,-21,-4,0,-32,29,-26,-18,39,17,-44,13,-17,-40,-37,-17,15,31,0,17,16,13,-45,-95,-88,-97,-2,-13,19,17,2,-95,-45,40,-30,50,-6,56,-21,10,-10,-11, 
  /* [15][0][][] */ 13,-19,-39,-31,7,17,-25,-10,10,-26,-17,-39,17,-6,54,-64,-65,0,-48,4,34,55,-45,-28,2,5,18,38,-11,-10,15,-94,-18,9,61,14,46,32,-58,11,-2,-60,11,22,-25,2,85,16,43,-8,-2,-83,2,48,-32,44,-11,25,-15,30,17,43,30,-19,-10,31,-31,-53,-39,11,32,-27,-34,-7,4,-33,-127,20,68,48,17,-27,29,37,-7,0,10,-13,-41,74,24,9,-50,-12,13,-1, 
};
const TfArray<4, int> tensor_dimension9 = { 4, { 16,1,1,96 } };
const TfArray<16, float> quant9_scale = { 16, { 0.0153000857681036, 0.011648557148873806, 0.0081451386213302612, 0.0061759892851114273, 0.012877910397946835, 0.0078121423721313477, 0.0093537243083119392, 0.010473407804965973, 0.012109767645597458, 0.0090811969712376595, 0.013588038273155689, 0.011923672631382942, 0.0097353383898735046, 0.0078522162511944771, 0.017101449891924858, 0.011210938915610313, } };
const TfArray<16, int> quant9_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant9 = { (TfLiteFloatArray*)&quant9_scale, (TfLiteIntArray*)&quant9_zero, 0 };
const ALIGN(16) int32_t tensor_data10[96] = { 21927, 51002, -172, -3081, 16262, -3754, 6433, -6142, 7207, 12880, 1013, -3457, -2193, 1063, 6675, -11521, -4451, 3241, -327, 20136, -17459, 14140, -3199, 12217, 23296, -2515, -1039, 20603, 4811, -20205, 61, 14672, 28954, -10319, 1859, 3243, -508, 1752, 4393, -9836, -3083, -968, -9689, -1246, 32400, -1524, 14628, -5626, -10552, -2652, 926, -3235, -3382, 36587, -8755, 10678, 28775, -7691, 48237, -449, -10900, -717, 1537, -2194, -2127, 10979, -2667, -10329, -5764, 3528, -1666, -7164, -2184, -2222, -3448, -7151, -3474, -1590, 25776, -7978, -6575, -11085, 1764, -2067, 36621, -13758, -4791, -25570, -3275, 14194, -2538, 38373, -2049, -367, -1672, -2349, };
const TfArray<1, int> tensor_dimension10 = { 1, { 96 } };
const TfArray<96, float> quant10_scale = { 96, { 0.00010274068336002529, 0.00012332145706750453, 0.00013147263962309808, 0.00025863651535473764, 0.00019475232693366706, 0.00017709931125864387, 3.4128213883377612e-05, 9.6144001872744411e-05, 0.00033864882425405085, 0.0001824370410759002, 0.00023847825650591403, 0.00015194610750768334, 0.00029935405473224819, 0.00020644730830099434, 0.00049681466771289706, 0.00010244773147860542, 0.00020524993306025863, 0.0002294397127116099, 0.00016964638780336827, 4.4595868530450389e-05, 3.7918594898656011e-05, 4.6412758820224553e-05, 0.00021787954028695822, 5.9133468312211335e-05, 5.6801945902407169e-05, 7.6747870480176061e-05, 0.00018081808229908347, 0.00017951818881556392, 4.1658255213405937e-05, 0.00062462722416967154, 0.00050802540499716997, 0.00021368212765082717, 0.00014093269419390708, 0.00013924892118666321, 0.00025552001898176968, 0.00038421028875745833, 0.00043045909842476249, 0.00017977126117330045, 0.00029153926880098879, 6.1894497775938362e-05, 0.00030017184326425195, 0.00024527867208234966, 0.00050780473975464702, 6.1527425714302808e-05, 0.00035879047936759889, 0.00015569129027426243, 8.9937122538685799e-05, 0.00026032840833067894, 0.00082665786612778902, 0.00013013316493015736, 0.00033145368797704577, 0.00019424709898885339, 0.0001729282084852457, 7.6490883657243103e-05, 9.9420845799613744e-05, 0.00015359286044258624, 9.3544222181662917e-05, 0.00042579267756082118, 2.4569408196839504e-05, 0.00018585393263492733, 0.00027128958026878536, 0.00043859260040335357, 0.00012846893514506519, 0.00015913872630335391, 0.00013893634604755789, 0.0001414986327290535, 0.00029489133157767355, 0.00020291980763431638, 0.00020847730047535151, 9.4395232736133039e-05, 0.00018371942860540003, 0.00011154278763569891, 0.00033218806493096054, 0.00014281932089943439, 0.00022619281662628055, 0.00027175887953490019, 0.00021314623882062733, 8.0977828474715352e-05, 8.9191249571740627e-05, 0.00015761553368065506, 0.00022354163229465485, 0.0002238125161966309, 0.00020060276438016444, 0.00022016486036591232, 8.7619620899204165e-05, 0.00010675011435523629, 9.7226300567854196e-05, 0.0006850986392237246, 0.00038638312253169715, 0.0001941845694091171, 0.00035185078741051257, 2.9230617656139657e-05, 0.00015320797683671117, 0.00011339534830767661, 0.00031012826366350055, 0.00038481262163259089, } };
const TfArray<96, int> quant10_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant10 = { (TfLiteFloatArray*)&quant10_scale, (TfLiteIntArray*)&quant10_zero, 0 };
const ALIGN(16) int8_t tensor_data11[1*3*3*96] = { 
  /* [0][0][][] */ -48,-69,-14,127,23,99,70,-51,-3,-21,-8,3,-13,-1,32,15,-16,-37,29,22,26,-127,127,26,-78,-8,45,-38,-119,-127,39,31,8,23,68,-25,-22,-16,20,-7,-19,36,-97,74,24,-81,39,53,-22,58,-28,23,12,-12,17,55,-81,-36,-67,-24,-14,8,8,45,71,-20,83,25,-7,14,29,127,34,31,37,-11,-7,21,127,-7,-13,25,-35,18,127,27,-90,-17,3,-37,-13,-73,13,-26,-22,37, 127,-127,74,105,-44,127,45,-104,75,10,-14,127,127,-101,-16,14,9,127,123,-112,127,-58,81,85,-127,-118,-75,-43,-56,38,-54,-14,-106,72,-127,-98,-37,-21,-59,62,4,127,127,84,-52,-111,-101,-46,-17,-127,34,92,59,-37,47,86,-47,51,-88,-113,-42,-46,-64,73,73,-55,36,30,-70,22,-12,91,127,127,19,9,7,60,-30,77,70,127,127,-23,-7,68,-126,127,-120,-87,4,-119,-77,-127,-40,110, -75,-15,24,-79,12,-7,67,3,87,-33,-30,34,-9,-13,-7,1,-7,-26,10,-2,-43,-102,36,6,-101,116,5,-63,108,42,-20,21,-12,21,19,-45,8,25,13,9,26,9,-105,62,12,-39,37,16,-17,12,-15,13,-12,-2,-4,28,-68,14,-46,43,5,42,32,3,-7,-33,-25,27,12,2,5,51,21,-17,-5,9,-12,-15,-91,-6,-26,-15,-11,5,-87,1,-57,-25,-54,9,-17,-45,26,-30,-17,0, 
  /* [0][1][][] */ -60,-78,78,-39,-41,80,25,127,-50,-25,-6,-93,23,-109,69,48,-5,-59,-19,88,56,-57,43,55,-124,8,127,-29,-36,64,122,-102,-127,108,-90,-70,-34,24,-32,101,-64,-26,-2,34,-47,127,-36,76,13,98,12,1,14,-60,39,31,127,127,-91,-67,127,-32,-34,127,67,-40,-12,9,127,44,127,89,-37,97,-13,20,24,14,-39,1,-48,112,-89,116,8,30,-54,31,73,-127,-26,-32,127,-56,-27,7, 67,113,62,-107,127,64,74,41,-127,127,127,-13,-51,-115,-127,127,127,-80,-127,-46,119,127,-124,127,-104,-101,-54,127,-127,107,-127,-127,-87,127,110,127,127,-127,-114,127,-60,-95,122,-127,-127,-31,-127,-127,127,-111,74,52,127,127,127,-127,97,-113,-127,127,22,-82,-127,-96,-127,127,-127,127,-115,-127,-104,-83,-126,-71,127,127,-127,127,-82,127,127,26,-53,-127,49,127,81,48,127,19,127,14,-69,26,127,-127, -53,-5,-63,35,-54,-90,33,-11,16,-38,-38,79,4,97,10,11,2,53,-4,127,-13,-60,-40,6,-108,112,-79,-25,-65,-8,8,-48,-75,32,7,-23,-17,45,-68,33,127,-4,-29,31,-43,-61,13,45,4,127,-18,15,-26,-75,7,16,89,11,-10,17,-28,127,86,-46,-40,17,36,-9,-77,110,-22,-76,2,-49,-27,-10,34,12,78,-62,-73,-38,54,24,-40,-22,55,23,7,46,-44,13,-45,86,-31,-4, 
  /* [0][2][][] */ -53,-5,-12,-15,15,-54,81,31,48,-25,-44,4,12,27,-27,24,-6,67,6,-3,-78,-95,-6,-14,-58,-51,31,-76,72,37,30,22,42,4,-26,-51,-10,26,3,12,-33,-11,-63,94,4,52,-1,45,-17,-30,3,-19,10,-11,17,6,-59,41,-30,24,14,-2,-17,-8,-3,-47,-47,4,-27,21,23,24,11,-17,25,4,30,3,-92,-25,-8,-16,14,16,-121,12,33,-46,-58,-40,-31,-65,16,63,-22,6, 119,29,-127,-29,-68,-30,22,30,-77,-30,-30,-94,-62,127,-13,52,7,-71,-9,-122,127,-24,-38,-2,-117,127,-66,12,-42,-18,4,3,-57,2,29,-9,-24,-38,127,60,11,-11,75,-36,-37,94,-77,-44,-32,0,-127,-127,-42,-30,-8,53,-48,2,12,43,-8,-23,7,-48,-52,38,61,-25,117,102,-26,-70,11,-46,3,3,107,1,67,5,15,-103,-60,1,-12,9,127,39,-60,27,-21,-127,40,64,-13,33, -42,10,-21,20,12,-61,-127,17,-39,-6,-30,1,18,-17,13,-2,2,-23,1,20,-68,-89,15,7,-18,-93,22,2,-33,-28,-9,26,53,-38,-10,-30,-40,-2,53,-50,21,-7,-37,-30,0,94,15,15,-9,9,-4,-5,11,6,-4,-12,-51,-11,23,-32,-9,9,71,-8,31,2,-9,28,0,13,-5,16,-11,13,1,13,51,0,79,-20,4,-21,-5,-11,71,-16,39,-40,65,33,-19,-50,-20,2,-17,-10, 
};
const TfArray<4, int> tensor_dimension11 = { 4, { 1,3,3,96 } };
const TfArray<96, float> quant11_scale = { 96, { 0.0043664788827300072, 0.0052411616779863834, 0.0055875871330499649, 0.010992051102221012, 0.0082769738510251045, 0.0075267208740115166, 0.0014504491118714213, 0.0040861200541257858, 0.014392574317753315, 0.0077535738237202168, 0.010135325603187084, 0.0064577092416584492, 0.01272254716604948, 0.0087740104645490646, 0.021114623174071312, 0.0043540284968912601, 0.0087231220677495003, 0.0097511876374483109, 0.00720997154712677, 0.0018953243270516396, 0.0016115402104333043, 0.0019725421443581581, 0.0092598805204033852, 0.0025131723377853632, 0.0024140826426446438, 0.0032617843244224787, 0.0076847681775689125, 0.0076295225881040096, 0.0017704758793115616, 0.026546657085418701, 0.021591078490018845, 0.0090814903378486633, 0.005989639088511467, 0.0059180790558457375, 0.010859601199626923, 0.016328936442732811, 0.018294511362910271, 0.0076402784325182438, 0.012390418909490108, 0.002630515955388546, 0.012757303193211555, 0.01042434386909008, 0.021581700071692467, 0.0026149156037718058, 0.015248594805598259, 0.0066168797202408314, 0.0038223275914788246, 0.011063957586884499, 0.035132959485054016, 0.0055306595750153065, 0.014086781069636345, 0.0082555012777447701, 0.0073494487442076206, 0.0032508624717593193, 0.0042253858409821987, 0.0065276967361569405, 0.0039756293408572674, 0.018096188083291054, 0.0010441998019814491, 0.0078987916931509972, 0.01152980700135231, 0.01864018477499485, 0.0054599298164248466, 0.0067633958533406258, 0.0059047946706414223, 0.0060136918909847736, 0.012532881461083889, 0.0086240917444229126, 0.0088602853938937187, 0.0040117972530424595, 0.0078080752864480019, 0.0047405683435499668, 0.014117992483079433, 0.0060698213055729866, 0.00961319450289011, 0.011549752205610275, 0.0090587148442864418, 0.0034415575210005045, 0.0037906281650066376, 0.0066986600868403912, 0.009500519372522831, 0.0095120314508676529, 0.0085256174206733704, 0.0093570062890648842, 0.0037238337099552155, 0.0045368797145783901, 0.004132117610424757, 0.029116692021489143, 0.016421282663941383, 0.0082528442144393921, 0.014953657984733582, 0.0012423011939972639, 0.0065113389864563942, 0.0048193023540079594, 0.013180450536310673, 0.016354536637663841, } };
const TfArray<96, int> quant11_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant11 = { (TfLiteFloatArray*)&quant11_scale, (TfLiteIntArray*)&quant11_zero, 3 };
const ALIGN(16) int32_t tensor_data12[96] = { 2577, 7160, 13950, 30844, 25875, -4334, -3834, 9165, 15529, -3575, 7621, 5595, 18427, 8216, 22564, 3049, 1062, 5731, 9604, 5760, 677, 1082, 19033, -1148, 5450, 47, 15536, 11578, 6702, 90730, 35744, 14407, 13372, -1545, 15634, 6427, 6131, 5544, 24096, -1609, 21587, 13323, 25449, -4531, 29619, 7365, 8316, 25002, 101334, 10859, -203, 20272, -5236, -534, -2360, 6762, -1264, 35063, 8476, 11509, 11181, 55160, 7012, 9421, 9196, 21884, 5117, -5408, 7582, -3477, 5453, 15067, 13341, 7641, -5983, -8064, 5154, -258, 2451, -1059, 42763, 7639, 6403, 6409, 2467, 316, 19938, 111444, 15177, 19705, 5211, -898, 7977, 7842, 8688, 16034, };
const TfArray<1, int> tensor_dimension12 = { 1, { 96 } };
const TfArray<96, float> quant12_scale = { 96, { 0.00013583964027930051, 0.00019838595471810549, 0.0001371971593471244, 8.1544385466258973e-05, 0.00012021933798678219, 0.0002499813272152096, 0.00022342256852425635, 0.00016504962695762515, 0.00013952914741821587, 0.00037319638067856431, 0.00037442846223711967, 0.00015058241842780262, 8.2666338130366057e-05, 0.00025801494484767318, 0.00010040291817858815, 0.00016991900338325649, 0.00017280415340792388, 0.00019864868954755366, 0.00021207988902460784, 0.00021523675241041929, 0.00039641439798288047, 0.00026679618167690933, 0.0001016040041577071, 0.00052851071814075112, 0.00045764629612676799, 0.00020905050041619688, 0.00015364614955615252, 0.00011861372331622988, 0.00023394259915221483, 4.007274765172042e-05, 7.4668758315965533e-05, 0.00015341193648055196, 0.00014096556697040796, 0.00025091585121117532, 0.00012140789476688951, 0.0001224238658323884, 0.00010638192907208577, 0.00023733839043416083, 0.00010555046173976734, 0.00039769307477399707, 9.4403934781439602e-05, 0.00013257857062853873, 9.7355230536777526e-05, 0.00023486241116188467, 0.00011314844596199691, 0.00015410144987981766, 0.00020699495507869869, 0.00011460656969575211, 4.1338262235512957e-05, 0.00019256661471445113, 0.00016913691069930792, 8.7818247266113758e-05, 0.00022087713296059519, 0.0001743519096635282, 0.00039024520083330572, 0.00016090064309537411, 0.00015005661407485604, 6.0164151364006102e-05, 0.000220935617107898, 0.00013577105710282922, 0.00014276598813012242, 3.0039944249438122e-05, 0.00020330707775428891, 0.00011220949818380177, 0.00028291234048083425, 9.6317133284173906e-05, 0.00024325390404555947, 0.00022515762248076499, 0.00020101637346670032, 0.00023222403251565993, 0.00019293386139906943, 0.00010993000614689663, 0.00014469813322648406, 0.00012881180737167597, 0.0002851066819857806, 0.00017353284056298435, 0.00027131507522426546, 0.00028459023451432586, 0.00026127375895157456, 0.00031636023777537048, 5.2858311391901225e-05, 0.00020488489826675504, 0.00017279767780564725, 0.00023371356655843556, 0.00036249725962989032, 0.00022359458671417087, 0.00012178333417978138, 3.4550103009678423e-05, 9.3919654318597168e-05, 0.0001251494832104072, 0.00024776897043921053, 0.0002453816996421665, 0.00017114436195697635, 0.00022153327881824225, 0.00015579546743538231, 0.00010198012751061469, } };
const TfArray<96, int> quant12_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant12 = { (TfLiteFloatArray*)&quant12_scale, (TfLiteIntArray*)&quant12_zero, 0 };
const ALIGN(16) int8_t tensor_data13[96*1*1*16] = { 
  /* [0][0][][] */ 54,102,-83,98,89,85,79,-32,125,121,-57,52,-55,-55,38,-127, 
  /* [1][0][][] */ 44,36,-33,-7,-4,-69,127,-55,0,0,-98,-26,7,-93,-68,61, 
  /* [2][0][][] */ -127,12,65,-47,-65,16,15,-57,-14,41,35,100,-19,52,35,-48, 
  /* [3][0][][] */ 39,-40,-58,46,-40,39,39,127,-19,-96,-33,-15,53,-21,14,41, 
  /* [4][0][][] */ 93,-33,33,98,42,32,-34,127,63,1,-11,-74,18,31,-94,-19, 
  /* [5][0][][] */ 127,-61,9,-20,47,-87,-22,-20,16,39,38,-7,-27,-46,-47,18, 
  /* [6][0][][] */ -11,16,49,-77,27,-1,-95,-127,-21,28,38,35,94,-123,-52,-37, 
  /* [7][0][][] */ 19,40,127,22,-12,-91,6,-97,-111,-64,-33,-46,-31,21,0,7, 
  /* [8][0][][] */ -4,-13,7,94,-19,76,34,9,27,1,-9,-13,-2,2,-127,-86, 
  /* [9][0][][] */ 14,-60,1,35,-12,-20,67,33,40,59,11,-12,-82,24,-127,-18, 
  /* [10][0][][] */ 17,-2,-17,-45,-24,-17,-17,1,-38,66,127,6,-47,-35,-30,-14, 
  /* [11][0][][] */ 107,3,29,-51,76,-91,-104,-50,-29,-38,-29,20,-64,-42,25,-127, 
  /* [12][0][][] */ 100,79,-36,62,-71,-103,-9,-27,-9,-7,41,-59,64,127,29,42, 
  /* [13][0][][] */ -44,-75,-46,62,41,-32,-21,65,40,-26,62,-4,-25,-11,127,48, 
  /* [14][0][][] */ -7,-31,26,21,25,-9,33,127,-3,-12,39,-43,-46,-15,-66,92, 
  /* [15][0][][] */ 111,-63,-31,47,47,-45,66,-39,19,-127,-11,6,2,-19,3,-79, 
  /* [16][0][][] */ -18,-21,-52,-26,11,48,35,-50,127,56,39,-13,24,107,120,92, 
  /* [17][0][][] */ -52,-24,72,52,-46,-17,59,18,-40,-1,-37,-70,-39,57,-127,-32, 
  /* [18][0][][] */ 27,16,-12,59,-86,32,1,127,-96,-105,-41,23,40,-115,102,0, 
  /* [19][0][][] */ -17,1,77,-75,-30,0,-127,-1,-28,-83,12,92,-37,11,-30,56, 
  /* [20][0][][] */ 34,9,-18,17,-19,32,-85,13,-3,-42,127,-57,37,-14,23,98, 
  /* [21][0][][] */ -90,-105,-35,-127,83,-6,-116,58,9,-6,36,9,-97,-47,13,5, 
  /* [22][0][][] */ 45,-65,-20,-91,68,-127,93,-40,-102,80,-38,-110,-65,-10,43,10, 
  /* [23][0][][] */ 31,-8,-1,-40,3,-7,-38,-22,-13,12,49,-7,127,26,39,-32, 
  /* [24][0][][] */ -53,-3,-23,-104,24,-21,-10,0,-113,-25,58,-127,-33,29,74,51, 
  /* [25][0][][] */ -20,-53,-23,-49,-57,30,-101,-127,-39,-55,16,-40,-2,-95,-45,-22, 
  /* [26][0][][] */ 8,-127,43,-107,29,64,118,46,113,115,-118,67,32,-8,13,65, 
  /* [27][0][][] */ 45,-23,70,-91,-14,-58,51,-31,-73,29,-127,3,-17,-36,-62,13, 
  /* [28][0][][] */ -90,-40,-68,-127,46,-29,14,-53,-18,9,-8,-25,72,-16,50,40, 
  /* [29][0][][] */ -61,-59,11,24,-28,-43,-7,-58,-38,7,-101,127,16,-100,68,-6, 
  /* [30][0][][] */ 8,24,20,7,22,-31,-42,20,10,-82,127,-46,-71,104,-62,103, 
  /* [31][0][][] */ -49,-53,56,-84,-27,18,105,-54,-4,127,49,39,-26,69,79,118, 
  /* [32][0][][] */ -27,30,5,91,-127,16,-41,-41,-15,-43,-17,37,30,19,-10,28, 
  /* [33][0][][] */ -19,23,15,36,-61,12,74,-70,-53,86,21,-30,-37,-31,22,127, 
  /* [34][0][][] */ -89,26,127,-42,-4,19,-57,68,-87,24,-35,79,-77,28,-28,-88, 
  /* [35][0][][] */ 81,83,7,58,107,-127,-3,-60,47,16,-31,26,35,52,-36,27, 
  /* [36][0][][] */ 73,-37,-99,-56,127,-86,-90,72,-30,-108,-26,-47,23,29,44,-35, 
  /* [37][0][][] */ -35,12,127,-33,-30,42,102,-81,-73,26,-38,-13,50,22,52,-5, 
  /* [38][0][][] */ -73,1,-97,-8,-37,127,58,-116,22,41,16,-68,-17,-104,-84,51, 
  /* [39][0][][] */ -35,70,4,-49,127,21,-99,29,28,94,-24,-79,-24,-66,-58,-74, 
  /* [40][0][][] */ 23,55,4,127,1,42,110,18,34,36,-74,-19,64,-14,-42,-69, 
  /* [41][0][][] */ 55,-57,-50,-67,27,-80,76,127,-67,34,-25,70,-5,13,74,-57, 
  /* [42][0][][] */ 54,-15,-62,46,-31,-34,43,5,48,27,127,-14,1,68,-39,7, 
  /* [43][0][][] */ -127,15,-15,-26,-2,51,-75,-122,6,88,-42,18,-59,4,57,-47, 
  /* [44][0][][] */ 25,-6,3,9,34,1,9,-34,127,33,-1,57,10,6,-40,-7, 
  /* [45][0][][] */ 86,-125,-62,-70,40,-93,-61,-64,17,-3,97,7,-11,-2,80,127, 
  /* [46][0][][] */ 3,38,19,98,-52,-42,-39,-24,-127,-58,-23,37,-28,27,17,-54, 
  /* [47][0][][] */ 56,-116,-70,127,17,56,-71,-58,90,26,29,16,40,79,116,-1, 
  /* [48][0][][] */ -70,-42,62,-127,3,14,-10,11,-71,-14,-12,8,-28,29,108,46, 
  /* [49][0][][] */ -124,-44,112,15,22,-38,84,92,20,1,-98,66,-76,26,-127,-98, 
  /* [50][0][][] */ 60,75,-68,-32,101,26,-32,127,74,-45,67,29,-31,-62,33,-114, 
  /* [51][0][][] */ 66,-10,59,-36,110,-113,-46,-109,-52,-127,85,82,-113,-41,41,-79, 
  /* [52][0][][] */ -59,51,45,-47,-15,33,0,112,-54,127,-53,-20,40,109,84,-14, 
  /* [53][0][][] */ -117,41,47,-127,-18,0,-45,-83,-55,-41,-18,41,69,-59,-8,78, 
  /* [54][0][][] */ -7,6,1,40,18,7,29,-5,13,40,-27,-44,-19,127,-9,-27, 
  /* [55][0][][] */ -35,127,26,59,42,10,-86,15,30,3,105,10,-12,42,37,-18, 
  /* [56][0][][] */ 3,22,-75,-12,-18,127,-24,-13,88,35,78,103,-4,-23,126,55, 
  /* [57][0][][] */ -22,32,20,48,-36,31,28,127,-18,34,26,1,-9,63,-16,-16, 
  /* [58][0][][] */ -21,45,2,-123,-74,88,-83,7,57,40,-29,58,30,-79,20,127, 
  /* [59][0][][] */ 10,74,10,-127,5,20,-39,-92,57,73,-8,12,4,-89,-22,4, 
  /* [60][0][][] */ -36,103,126,-107,-127,112,13,-105,-37,48,-59,-51,45,36,63,33, 
  /* [61][0][][] */ -24,85,9,-17,18,-41,102,127,6,126,-18,-64,13,112,-49,9, 
  /* [62][0][][] */ -58,2,54,6,2,27,11,6,-84,-13,-127,-3,-31,-11,96,-29, 
  /* [63][0][][] */ -9,-71,35,-86,-16,-44,-127,-91,-97,3,23,0,66,47,127,27, 
  /* [64][0][][] */ 60,13,-38,95,45,-18,15,-127,17,-53,55,-36,20,10,-15,28, 
  /* [65][0][][] */ -108,-14,4,-114,-38,43,-97,-127,-95,9,66,31,31,32,69,-47, 
  /* [66][0][][] */ 34,-90,43,-6,-73,-21,-34,127,-76,-22,46,-107,28,0,-51,42, 
  /* [67][0][][] */ 88,-60,-81,26,61,-92,-79,-127,35,-114,-56,9,-44,43,-16,-48, 
  /* [68][0][][] */ -58,-12,-10,23,-108,69,53,-95,-22,87,69,-15,-43,-38,127,85, 
  /* [69][0][][] */ -32,-15,1,13,15,-127,36,76,51,49,-5,-53,29,42,-30,58, 
  /* [70][0][][] */ 1,-55,-35,-18,-73,32,65,127,-95,-34,-15,44,-78,82,-15,8, 
  /* [71][0][][] */ -41,-29,12,-90,34,15,-4,58,-51,-97,24,40,60,-29,127,-49, 
  /* [72][0][][] */ 82,28,-65,28,-17,4,-127,1,-29,-37,-16,43,27,0,39,0, 
  /* [73][0][][] */ -127,-78,11,-125,-122,58,1,11,-87,0,11,-75,63,23,-36,6, 
  /* [74][0][][] */ -11,51,105,28,9,11,-127,95,-9,-55,-94,-78,-25,28,-76,-6, 
  /* [75][0][][] */ -4,119,11,16,-29,100,25,115,51,71,-57,-60,-28,127,-19,-5, 
  /* [76][0][][] */ 71,8,-51,-13,22,-127,-32,-89,8,-28,-9,-20,0,31,-5,-28, 
  /* [77][0][][] */ -105,35,24,-47,-77,-29,-30,-127,101,10,-105,-5,27,106,68,-89, 
  /* [78][0][][] */ -48,-127,21,0,55,-10,22,33,-58,14,-123,-7,30,47,99,31, 
  /* [79][0][][] */ 6,14,-21,-85,127,5,32,21,41,20,9,-21,-50,-37,-6,36, 
  /* [80][0][][] */ -40,23,77,-64,45,-50,93,97,16,35,6,-43,-57,127,-25,51, 
  /* [81][0][][] */ 22,-18,74,-2,-9,43,17,-13,-18,-15,-16,-28,-9,-15,-127,14, 
  /* [82][0][][] */ 7,-62,48,68,1,-93,-71,-71,74,-127,29,-116,68,-24,-53,-27, 
  /* [83][0][][] */ 15,41,-26,-63,-67,27,17,23,-127,-13,18,-2,-57,-90,25,40, 
  /* [84][0][][] */ 26,36,13,83,-71,-46,-38,-7,-25,-47,127,-22,-13,20,78,-84, 
  /* [85][0][][] */ 19,53,-5,-8,21,-97,70,124,-127,-28,-35,-68,-53,73,112,-47, 
  /* [86][0][][] */ 72,-120,-50,-71,66,15,49,127,-91,19,29,-111,-22,-61,-15,99, 
  /* [87][0][][] */ 127,-74,61,-64,16,-122,-53,-62,6,-13,-121,26,-3,-28,13,29, 
  /* [88][0][][] */ 111,41,-59,-30,72,-41,-76,83,-26,-117,9,-10,-127,-4,8,-76, 
  /* [89][0][][] */ 21,114,-31,17,-16,32,-4,-20,9,61,109,45,-127,-7,-49,-95, 
  /* [90][0][][] */ 39,-44,18,18,14,10,-14,48,-6,-127,-24,-5,2,2,-13,-2, 
  /* [91][0][][] */ -92,28,-3,-127,-68,28,35,-114,-100,86,23,58,49,-39,68,49, 
  /* [92][0][][] */ -27,-1,-101,-127,54,-31,-95,4,49,-24,110,-58,-81,30,18,-14, 
  /* [93][0][][] */ 80,21,26,-70,-26,74,-74,12,37,-95,-36,-44,-8,56,-127,-17, 
  /* [94][0][][] */ 4,127,-50,97,21,-116,-4,-67,27,-48,108,-52,46,-53,61,3, 
  /* [95][0][][] */ -110,18,16,-127,21,-10,-14,84,-13,-62,-42,-55,-50,-5,-20,0, 
};
const TfArray<4, int> tensor_dimension13 = { 4, { 96,1,1,16 } };
const TfArray<96, float> quant13_scale = { 96, { 0.00041525732376612723, 0.00060645933263003826, 0.00041940720984712243, 0.00024927849881350994, 0.00036750655272044241, 0.00076418468961492181, 0.00068299542181193829, 0.00050455128075554967, 0.00042653598939068615, 0.0011408490827307105, 0.0011446154676377773, 0.00046032547834329307, 0.00025270826881751418, 0.00078874314203858376, 0.0003069284139201045, 0.0005194367840886116, 0.00052825658349320292, 0.00060726248193532228, 0.00064832123462110758, 0.00065797165734693408, 0.0012118257582187653, 0.000815587118268013, 0.00031060009496286511, 0.0016156397759914398, 0.0013990096049383283, 0.00063906051218509674, 0.00046969123650342226, 0.00036259824992157519, 0.00071515480522066355, 0.00012250106374267489, 0.00022825993073638529, 0.00046897525317035615, 0.00043092708801850677, 0.00076704152161255479, 0.00037113993312232196, 0.00037424571928568184, 0.00032520605600439012, 0.00072553561767563224, 0.00032266427297145128, 0.0012157346354797482, 0.00028858971199952066, 0.00040528830140829086, 0.00029761172481812537, 0.00071796664269641042, 0.00034589107963256538, 0.00047108306898735464, 0.00063277676235884428, 0.00035034850588999689, 0.00012636970495805144, 0.00058866979088634253, 0.00051704596262425184, 0.0002684574865270406, 0.00067521410528570414, 0.00053298805141821504, 0.0011929667089134455, 0.00049186794785782695, 0.00045871810289099813, 0.00018391982303000987, 0.00067539291922003031, 0.00041504765977151692, 0.00043643091339617968, 9.1831119789276272e-05, 0.000621503044385463, 0.00034302074345760047, 0.00086485367501154542, 0.00029443830135278404, 0.0007436191663146019, 0.00068829942028969526, 0.00061450042994692922, 0.00070990121457725763, 0.00058979244204238057, 0.00033605241333134472, 0.00044233741937205195, 0.00039377342909574509, 0.00087156175868585706, 0.00053048419067636132, 0.00082940125139430165, 0.00086998293409124017, 0.00079870526678860188, 0.00096710282377898693, 0.00016158611106220633, 0.00062632636399939656, 0.00052823679288849235, 0.00071445468347519636, 0.0011081421980634332, 0.00068352126982063055, 0.00037228764267638326, 0.00010561852104729041, 0.00028710928745567799, 0.00038257782580330968, 0.00075742159970104694, 0.00075012375600636005, 0.00052318267989903688, 0.00067721994128078222, 0.00047626162995584309, 0.00031174989999271929, } };
const TfArray<96, int> quant13_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant13 = { (TfLiteFloatArray*)&quant13_scale, (TfLiteIntArray*)&quant13_zero, 0 };
const ALIGN(16) int32_t tensor_data14[16] = { -11797, 11011, -11139, 6354, 4504, 13561, -7199, -22094, 26385, 14092, 33758, 33224, -33387, 16045, 28282, -13925, };
const TfArray<1, int> tensor_dimension14 = { 1, { 16 } };
const TfArray<16, float> quant14_scale = { 16, { 0.0003179843770340085, 0.00023939654056448489, 0.0001705183822195977, 0.00015423928562086076, 0.00017959432443603873, 0.00021479498536791652, 0.00021289045980665833, 0.00020977636449970305, 0.00011787238327087834, 0.00017885955458041281, 0.00022951340361032635, 0.00040440712473355234, 0.00021370920876506716, 0.00017134950030595064, 0.00030054221861064434, 0.00018284597899764776, } };
const TfArray<16, int> quant14_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant14 = { (TfLiteFloatArray*)&quant14_scale, (TfLiteIntArray*)&quant14_zero, 0 };
const ALIGN(16) int8_t tensor_data15[16*1*1*96] = { 
  /* [0][0][][] */ -17,8,-56,2,48,74,-13,-31,2,7,8,19,60,-16,11,35,28,-23,-34,-10,32,-60,-28,-9,-42,3,-8,-37,25,-18,52,21,127,-15,52,35,16,-23,-56,9,-41,51,-16,-28,32,3,-54,47,18,-15,-3,-26,0,14,36,-17,2,64,45,-11,-60,7,15,51,-6,22,35,-59,-14,31,-5,2,1,-41,10,5,-14,-72,19,-1,27,-13,-40,-56,10,-42,13,-60,-47,30,22,7,40,53,-29,62, 
  /* [1][0][][] */ -11,-22,52,75,-43,-45,8,-47,-20,-32,21,10,-46,-41,-28,-22,-45,1,-34,-12,-7,-74,-39,-45,62,-48,-59,50,9,44,8,40,19,46,-90,-15,-45,-10,36,15,24,-127,64,36,-27,17,23,64,-26,6,19,2,47,-46,-35,-43,-14,26,-51,-42,36,33,28,-40,-26,-45,7,57,5,51,-58,18,-86,-54,-23,75,-7,-3,-7,5,34,-56,-48,15,-84,48,-24,2,53,-21,-22,18,-74,-14,35,-22, 
  /* [2][0][][] */ 42,62,42,-34,-33,-15,-26,32,78,-28,23,80,-20,39,28,-1,1,27,44,-30,23,-49,54,-17,18,-7,-19,-8,47,66,46,-47,-46,10,-78,13,-4,84,53,-20,-3,-84,6,24,-48,-84,33,36,29,3,1,-17,25,-19,-70,-31,-11,1,-29,-26,45,-8,49,13,30,-51,-26,-16,6,-10,-42,-15,-11,65,-41,2,18,62,38,-2,-7,76,2,19,-28,60,-1,14,127,-44,-37,-81,-54,17,-29,53, 
  /* [3][0][][] */ -51,4,25,28,-43,-24,-60,9,-6,55,32,7,-26,7,32,17,-32,-29,-14,8,-37,-58,-24,-1,13,40,-16,17,61,-22,70,-29,33,-46,-12,98,-22,31,-2,82,-14,-62,-59,-16,-8,11,21,60,-57,24,-26,52,-81,31,-90,27,30,33,0,64,-32,56,-37,41,-25,-127,-19,12,-51,11,9,31,16,-44,9,-35,23,-78,43,-42,-28,-7,-10,43,-54,-18,-33,-18,49,-39,-26,52,-61,4,3,-25, 
  /* [4][0][][] */ 20,-127,-43,-69,51,30,-10,70,-14,-35,-27,31,68,22,23,5,105,2,-11,-11,-42,61,-3,0,-39,-8,38,54,51,-40,31,-10,-4,-58,81,-42,80,-4,-34,6,54,57,-70,-20,49,16,0,-10,4,55,8,-25,10,-30,58,31,-8,-52,90,17,25,-8,54,36,44,-97,43,-30,-44,34,-12,10,53,-27,1,30,46,119,79,-4,12,24,99,-13,23,-51,15,-68,0,16,46,-19,66,18,28,-49, 
  /* [5][0][][] */ 3,9,31,-1,-64,-45,-20,39,90,-67,27,-22,-81,55,35,27,-100,8,33,-27,18,-6,38,19,62,30,-9,32,12,-32,-22,44,-97,27,-61,2,-41,-42,46,21,19,-18,29,22,26,-3,65,-19,7,-18,37,8,-1,16,12,21,23,-41,-62,11,-72,22,-86,-99,37,-14,-40,15,33,-29,-2,-54,23,68,-38,-18,22,-28,-8,112,-95,-84,3,-2,37,33,-31,32,49,23,-16,-127,-87,-68,-37,-101, 
  /* [6][0][][] */ -17,47,43,-77,2,-24,-41,33,59,16,11,-26,1,-25,-8,22,-24,-36,8,42,45,12,-11,15,60,5,-7,-74,3,19,-11,0,-34,69,-21,15,-16,43,74,11,-4,-49,-47,-7,-1,-39,46,-127,26,53,14,-25,-1,-40,-56,-19,50,-27,-43,9,27,70,-2,-12,17,21,22,21,-12,-49,47,-11,31,57,51,-23,-13,40,9,-39,-22,-19,5,13,-27,35,-2,-6,8,-22,-29,1,22,6,13,74, 
  /* [7][0][][] */ 17,1,37,-25,-23,-49,-8,-27,12,-34,13,-30,-79,-32,26,35,-33,-27,3,-48,-23,-25,-41,24,-17,8,0,0,-15,-9,-12,-15,-15,46,-7,-31,-21,0,-37,66,37,-32,-17,7,0,72,-21,119,-12,74,11,-13,20,-8,10,-29,45,-19,-4,18,4,48,19,-33,-16,57,26,-6,-41,-50,16,19,44,40,-48,-4,54,36,27,-46,1,-42,-5,23,-41,127,-41,-7,-52,16,10,-27,-46,-14,10,-24, 
  /* [8][0][][] */ -106,13,-93,16,32,48,1,66,37,35,1,12,47,3,43,41,-77,34,-97,7,19,5,0,63,-88,16,59,60,52,-92,27,14,13,-17,41,31,35,59,-15,42,21,78,76,-95,-42,-11,61,-9,11,6,46,51,-56,118,-43,6,-47,-26,12,-52,-24,-107,-52,35,19,-23,44,-64,55,-33,56,47,10,-23,11,-40,25,-127,11,-36,-68,11,93,13,-11,7,4,-13,-11,63,-6,18,-31,-63,-56,-73, 
  /* [9][0][][] */ 56,41,30,-65,-27,-26,-54,-42,65,-45,73,8,-33,-13,8,32,-67,29,42,4,12,-4,2,-23,49,-6,-9,-51,-29,-40,-77,-22,-11,90,-36,18,23,-19,44,17,24,-7,16,-59,-9,-40,45,-98,-30,-19,21,23,-11,-18,-2,-9,-41,-8,-70,-18,-1,79,8,-7,87,127,7,19,17,-17,15,-53,-5,21,-6,-3,52,-3,3,65,-47,-38,41,-91,5,59,-65,5,-31,53,-68,-48,-10,-10,-31,-65, 
  /* [10][0][][] */ -13,-20,-15,25,11,-125,39,-34,-25,63,14,31,-22,16,33,-12,-3,4,-26,49,-62,-13,-56,-51,-127,-2,-20,87,2,20,-8,42,48,-35,32,-21,67,-57,-57,3,-18,78,73,6,-50,33,-34,53,-90,-39,-3,30,-11,-19,30,-23,-31,49,-47,45,-1,9,-23,41,-27,46,26,40,-5,65,32,65,-67,-85,4,-47,-3,-11,-56,47,61,-32,-69,-85,94,-19,37,19,-92,47,72,6,6,45,34,-73, 
  /* [11][0][][] */ 12,12,-41,17,-29,28,69,6,15,-3,-24,24,9,19,37,20,-51,13,-105,-31,28,7,26,15,-56,-37,-2,6,-8,1,11,12,-14,-33,16,34,21,13,17,18,55,22,82,-62,11,-48,-8,-2,-127,-5,-11,-18,23,58,-11,38,12,-18,-18,-9,-20,-29,-45,0,-26,48,-13,2,44,-22,55,-9,-53,-50,-23,2,3,-33,-55,10,-9,-30,95,33,11,-53,-4,6,47,23,-51,-26,18,-16,-4,-14, 
  /* [12][0][][] */ -6,-31,-40,56,-2,49,-16,42,55,-50,-7,31,7,21,-27,-92,35,14,39,58,35,7,25,24,48,73,13,-17,-83,-59,67,-69,-13,-56,51,-4,30,23,86,4,-26,25,-3,-6,-25,43,19,-38,59,-8,-26,-24,1,54,13,92,48,-57,29,-9,-33,-18,-36,-30,39,-11,-14,14,29,9,-6,-65,81,74,-105,9,48,-50,6,-62,-79,-18,127,47,-35,-108,-9,-22,50,61,-42,59,98,-83,-31,-23, 
  /* [13][0][][] */ 55,-68,-33,65,22,-59,4,-26,-52,-41,43,-20,-53,-10,-8,-35,-9,-110,-13,6,-69,-24,18,-22,-13,28,-54,26,2,-80,-20,7,-3,4,13,16,0,-27,10,25,-36,41,19,77,25,112,-6,-127,51,61,26,-4,-13,-64,-2,-49,3,-18,-24,12,-14,4,-15,-47,12,-24,6,-40,51,-35,-11,-46,25,75,-36,-18,-4,-19,7,-36,2,-79,-36,52,66,60,7,53,-48,22,19,-37,-63,-10,-40,-35, 
  /* [14][0][][] */ -69,-89,-58,42,15,-7,58,92,-31,4,-84,-16,42,39,-74,-23,101,-9,30,6,-40,58,36,-27,-78,-30,90,9,-64,-87,14,-5,-11,-63,79,-34,64,85,-42,0,69,66,-21,-18,3,114,60,7,-98,35,12,-29,-87,-10,86,0,-19,-14,30,30,-2,65,-1,27,44,-1,-8,59,29,33,2,-69,-89,-34,-10,67,-33,89,-12,7,51,-9,6,25,127,-42,61,35,43,23,-7,-36,37,14,17,-5, 
  /* [15][0][][] */ 73,-70,29,-31,105,-18,56,-28,-30,58,9,25,-117,9,-14,33,-8,21,105,-23,-4,-2,-45,57,-26,-33,34,-12,-24,18,-81,-71,-61,-61,93,-24,26,-57,-65,-46,-37,41,-19,-17,-19,63,-57,-18,38,38,-44,-61,42,-125,127,-69,-1,-28,-21,17,-107,-22,7,-1,90,48,-34,-5,-14,54,4,-53,37,73,20,-43,9,-13,93,29,-4,-35,37,6,31,57,2,21,-89,58,82,-15,-3,18,46,-18, 
};
const TfArray<4, int> tensor_dimension15 = { 4, { 16,1,1,96 } };
const TfArray<16, float> quant15_scale = { 16, { 0.013514336198568344, 0.010174352675676346, 0.0072470312006771564, 0.0065551693551242352, 0.0076327589340507984, 0.0091287866234779358, 0.0090478444471955299, 0.0089154951274394989, 0.0050095762126147747, 0.0076015307568013668, 0.0097543196752667427, 0.017187302932143211, 0.0090826414525508881, 0.0072823534719645977, 0.012773044407367706, 0.0077709541656076908, } };
const TfArray<16, int> quant15_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant15 = { (TfLiteFloatArray*)&quant15_scale, (TfLiteIntArray*)&quant15_zero, 0 };
const ALIGN(16) int32_t tensor_data16[96] = { 10898, -10205, 4622, 56089, 492, -4790, -15815, 7622, -2054, -214, -1042, -3202, -4561, -1269, 8572, -4690, 1015, 19610, 28468, 1479, 11479, 250, 2370, 1751, 15819, 2368, -6337, -4346, -6584, -9715, 6050, -11900, 1051, 1214, -3219, 17247, 1539, -4946, 13939, 2510, 742, -1748, -11676, -10677, -11565, 83250, 4918, 16165, 26768, -15009, -2537, 10382, 3503, -670, -1919, -396, -20033, 527, 1283, -10426, -1964, -5349, -13102, -6156, 2921, 13003, 29632, 29565, -17211, -1144, -5118, -612, 37755, 11296, -351, 1059, 22120, 35031, -2177, -12880, -431, -10588, -2202, -5069, 402, -4582, 259, 1210, -4429, -4376, 2505, -2658, -269, -653, 1637, 48586, };
const TfArray<1, int> tensor_dimension16 = { 1, { 96 } };
const TfArray<96, float> quant16_scale = { 96, { 0.00019095097377430648, 0.00011542461288627237, 0.00035676301922649145, 3.7926223740214482e-05, 0.00020725565264001489, 0.00023153472284320742, 0.00030357495415955782, 8.0756493844091892e-05, 0.00017728509556036443, 0.00035200471756979823, 0.00012980452447663993, 0.00025747698964551091, 0.00017535840743221343, 0.00055824877927079797, 0.00014067224401514977, 0.00018357243970967829, 0.0001308161299675703, 0.00037508195964619517, 6.3356244936585426e-05, 0.00025611475575715303, 1.878333387139719e-05, 0.00022528805129695684, 0.00011917477968381718, 0.00028307369211688638, 0.00022646936122328043, 0.00020280640455894172, 0.00011802604421973228, 0.00023160883574746549, 9.0538647782523185e-05, 8.4213112131692469e-05, 0.00012883628369309008, 0.00012189766130177304, 0.00017661950550973415, 0.0001523819228168577, 0.0002678394375834614, 0.00014019286027178168, 0.00048554776003584266, 0.00014535922673530877, 6.2459817854687572e-05, 0.00014680840831715614, 0.00020464933186303824, 0.00033754462492652237, 0.00031489372486248612, 0.00012900120054837316, 0.00011771780555136502, 4.9177277105627581e-05, 0.00025348973576910794, 0.00023102149134501815, 9.2249058070592582e-05, 0.0001349947415292263, 0.00011320252087898552, 8.6602070950902998e-05, 0.00025978087796829641, 0.00031007133657112718, 0.0003495070559438318, 0.00066783285001292825, 0.0001665771851548925, 0.0002662095648702234, 0.00012886461627203971, 6.1805360019207001e-05, 0.00045400802628137171, 0.00013823001063428819, 0.00027613760903477669, 0.00014603704039473087, 0.0001645169104449451, 0.00022677685774397105, 5.6558892538305372e-05, 6.3606530602555722e-05, 0.00031273296917788684, 0.00027072973898611963, 0.00024148226657416672, 7.8259661677293479e-05, 0.00015234481543302536, 0.000161103525897488, 0.0001983062393264845, 0.00019664931460283697, 0.00055105792125687003, 8.2605336501728743e-05, 0.00032006690162234008, 0.00014598453708458692, 0.00018287521379534155, 0.00019103585509583354, 0.0001296695409109816, 0.00011261895997449756, 0.00014311875565908849, 0.00012224038073327392, 0.00014809762069489807, 0.00014468903827946633, 0.00023484793200623244, 0.00010163772094529122, 0.00023759648320265114, 0.00015601626364514232, 0.00017349871632177383, 0.00061878294218331575, 0.00062757957493886352, 8.7848064140416682e-05, } };
const TfArray<96, int> quant16_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant16 = { (TfLiteFloatArray*)&quant16_scale, (TfLiteIntArray*)&quant16_zero, 0 };
const ALIGN(16) int8_t tensor_data17[1*3*3*96] = { 
  /* [0][0][][] */ -18,-9,-25,127,-29,30,-56,-57,10,-3,98,-4,2,-9,-8,41,7,14,-59,0,73,-12,31,-39,4,18,55,40,20,17,24,55,0,26,9,-14,-1,42,-40,-27,13,17,36,2,-83,-76,22,-7,-3,-16,-7,-8,57,8,-12,9,3,-43,30,-30,28,-6,127,38,-16,-6,-6,-61,70,40,-2,-11,79,-22,57,-5,19,-127,29,53,-3,6,127,-14,46,39,-36,-28,46,-20,-14,88,7,16,2,12, -50,-17,-8,20,41,-7,-7,-127,35,15,-127,-4,-7,-15,2,86,14,-29,-10,-20,85,-105,127,21,-59,-38,-89,-20,21,29,-52,17,105,4,-10,-1,-21,127,-36,-127,5,-10,-32,8,45,-127,127,-49,-73,45,46,13,37,-65,33,51,29,51,-92,94,127,45,0,-19,43,-35,-83,-8,47,-26,-10,47,-51,-38,101,-12,-28,-66,-27,75,-62,60,-18,14,-10,46,53,-58,-26,46,-19,73,-127,-28,21,-127, -3,-10,-25,-62,2,17,44,17,-4,0,18,53,12,-13,-24,7,-24,18,-38,8,17,16,25,-41,-1,-39,18,8,-16,6,42,-78,48,14,6,-26,15,4,-4,-24,6,2,-16,6,19,-47,22,-5,8,-14,0,-4,8,8,-6,4,-19,46,15,-5,16,-4,1,-20,-31,-16,0,-46,-93,-9,38,-21,-125,-22,-20,7,18,-23,7,2,-22,37,-38,-13,-50,19,26,25,-21,-15,21,-9,42,-6,-1,-49, 
  /* [0][1][][] */ -36,67,-17,39,-88,-13,1,-41,18,105,-49,-19,-23,-25,-7,56,127,-26,-74,-18,62,-127,-29,12,-35,-46,-116,-11,39,50,-50,30,-117,-76,-42,4,62,-5,-14,35,-30,105,9,-6,42,-47,-19,-32,127,47,-2,22,51,13,-45,-11,42,18,-125,127,-35,-73,24,127,-62,-31,-92,127,-22,127,-23,69,-51,-53,44,5,-45,-61,127,47,127,28,3,6,127,30,-90,40,-23,-31,-111,46,88,112,29,-56, 127,127,127,118,-39,-127,127,30,127,-127,22,-127,-88,127,127,127,-19,-127,-62,-127,127,17,-79,123,127,127,-50,-127,127,127,-127,127,-9,-127,-90,127,-127,-40,111,92,-127,-127,127,127,127,-105,-116,127,-13,127,-127,-127,-127,127,127,-127,127,-127,-31,46,-107,-22,-66,-64,127,127,-59,111,127,-97,-127,127,-51,127,-127,-127,-127,119,-63,127,-43,127,88,127,-37,-127,-19,-118,-127,-117,-28,-127,-20,-127,-127,124, -23,107,-39,9,127,64,-19,46,13,21,-3,-13,-27,-29,-16,13,-112,-23,-127,45,36,67,-21,-126,-35,-45,127,69,20,49,72,9,127,-55,127,1,54,3,-98,11,36,27,-22,-1,-22,-61,-9,-44,78,24,-15,39,-4,1,-95,-6,23,16,127,-108,1,127,-9,-47,-118,-27,-85,97,17,-22,99,28,-25,-48,7,56,-28,-7,-42,-7,-59,25,55,28,-77,36,127,-56,44,-10,127,-14,-116,29,25,19, 
  /* [0][2][][] */ -1,-48,-20,-70,-3,20,51,23,3,15,-24,51,33,-32,-1,19,30,8,43,16,-12,33,-21,-32,-1,-36,19,7,0,0,49,-71,-42,53,-13,-29,27,-38,-29,12,1,17,-35,32,10,-83,-20,-1,-6,0,12,-4,12,5,-37,15,3,63,-54,27,0,-3,14,19,-8,-15,15,-52,-49,13,-23,3,-127,-38,0,17,10,-13,57,22,27,42,-40,27,12,20,-17,-1,24,37,17,3,11,50,-4,-43, -36,-15,-32,20,-40,78,-15,64,15,-11,71,-16,127,-7,-21,-12,-6,-44,-101,17,-14,79,-54,-127,-54,-54,100,68,9,59,54,-1,-115,67,-7,-28,-32,-24,-127,-7,43,-8,-14,46,-36,-44,-26,-51,-50,24,59,32,-7,-92,31,59,19,33,76,-52,21,-48,3,15,19,-23,-127,-56,-11,-19,-57,16,32,-44,-28,-4,-62,13,-46,-6,38,29,20,8,6,67,-91,127,32,127,-40,-11,121,-27,49,82, -10,-32,-28,35,13,55,-41,6,6,-15,12,8,12,-49,-8,3,-47,-5,6,15,-24,12,-26,-5,-6,9,5,54,-5,-4,34,32,7,41,20,-18,-5,-20,-74,6,14,-12,18,10,-75,-55,-21,8,0,-19,-3,-8,-5,13,-12,4,-5,-58,15,-37,-28,54,-5,-33,-8,-1,38,-45,42,2,40,-19,28,-49,-13,25,9,10,-4,38,-33,21,109,-2,-18,59,45,-9,127,18,-5,-19,14,-20,-6,-64, 
};
const TfArray<4, int> tensor_dimension17 = { 4, { 1,3,3,96 } };
const TfArray<96, float> quant17_scale = { 96, { 0.0081154163926839828, 0.0049055460840463638, 0.01516242790967226, 0.0016118645435199142, 0.0088083650916814804, 0.0098402258008718491, 0.01290193572640419, 0.0034321509301662445, 0.0075346166267991066, 0.014960199594497681, 0.0055166920647025108, 0.010942772030830383, 0.0074527319520711899, 0.023725572973489761, 0.005978570319712162, 0.0078018284402787685, 0.0055596851743757725, 0.015940982848405838, 0.0026926402933895588, 0.010884876362979412, 0.00079829170135781169, 0.0095747420564293861, 0.0050649279728531837, 0.012030631303787231, 0.0096249477937817574, 0.0086192721500992775, 0.0050161066465079784, 0.0098433755338191986, 0.0038478923961520195, 0.0035790570545941591, 0.0054755420424044132, 0.0051806503906846046, 0.0075063286349177361, 0.0064762318506836891, 0.011383175849914551, 0.0059581967070698738, 0.020635779947042465, 0.0061777671799063683, 0.0026545422151684761, 0.0062393574044108391, 0.0086975963786244392, 0.014345645904541016, 0.013382983393967152, 0.0054825511761009693, 0.0050030066631734371, 0.0020900343079119921, 0.010773314163088799, 0.0098184132948517799, 0.0039205849170684814, 0.0057372762821614742, 0.0048111071810126305, 0.0036805879790335894, 0.011040686629712582, 0.013178031891584396, 0.014854049310088158, 0.028382895514369011, 0.0070795300416648388, 0.011313905939459801, 0.005476746242493391, 0.0026267278008162975, 0.019295340403914452, 0.0058747753500938416, 0.011735848151147366, 0.0062065739184617996, 0.0069919684901833534, 0.0096380161121487617, 0.0024037528783082962, 0.0027032776270061731, 0.013291151262819767, 0.011506013572216034, 0.010262995958328247, 0.0033260355703532696, 0.0064746546559035778, 0.0068468996323645115, 0.0084280148148536682, 0.0083575956523418427, 0.023419961333274841, 0.0035107266157865524, 0.013602842576801777, 0.0062043424695730209, 0.0077721965499222279, 0.0081190234050154686, 0.0055109555833041668, 0.004786305595189333, 0.0060825468972325325, 0.0051952162757515907, 0.0062941485084593296, 0.0061492840759456158, 0.0099810371175408363, 0.0043196030892431736, 0.010097850114107132, 0.0066306907683610916, 0.0073736952617764473, 0.026298273354768753, 0.026672132313251495, 0.0037335427477955818, } };
const TfArray<96, int> quant17_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant17 = { (TfLiteFloatArray*)&quant17_scale, (TfLiteIntArray*)&quant17_zero, 3 };
const ALIGN(16) int32_t tensor_data18[96] = { 12637, 1917, 17274, -1149, 17298, 5929, 16769, 12579, -1785, 11896, 6723, 5107, 13265, 29809, -93, -6062, 10975, 23185, 3863, -908, -759, 31308, 5247, 4798, 18076, 9569, 9288, 11185, -938, -527, 11063, 13482, 18983, 5604, 4369, -1256, 26560, 18951, 1132, 8107, 1363, 18182, 18649, 4709, 10404, 16528, 23878, 13416, 4591, 5847, 343, -1775, 64262, 6732, 9435, 20300, 157, 11980, 4490, 8957, 26090, 8091, 5217, 11852, 5615, 4093, 10368, -802, 29768, 12196, 8767, -1906, -2492, 3441, 3083, 6158, 42412, 25218, 13497, -5440, 4442, -7251, -1466, 894, 8735, 7146, 14098, 14170, 12856, 3385, 18111, 5164, 16791, 42402, -9922, 24224, };
const TfArray<1, int> tensor_dimension18 = { 1, { 96 } };
const TfArray<96, float> quant18_scale = { 96, { 0.00021299847867339849, 0.00016682918067090213, 9.0228735643904656e-05, 0.00047031897702254355, 0.00011236050340812653, 0.00017579831182956696, 0.00018392535275779665, 0.00028971626306883991, 0.00031010882230475545, 0.0001396680308971554, 0.00020098916138522327, 0.00017503625713288784, 0.00018722360255196691, 0.00015736790373921394, 0.00029561592964455485, 0.00015112619439605623, 0.000201473492779769, 0.00010906434181379154, 0.0001246066385647282, 0.00035346060758456588, 0.0002678770397324115, 8.5873478383291513e-05, 0.00029760165489278734, 0.00018558002193458378, 9.7508258477319032e-05, 0.0002327078691450879, 0.00015949131920933723, 9.8550342954695225e-05, 0.00021819498215336353, 0.00025592904421500862, 0.00013344864419195801, 0.00013478939945343882, 0.00010020501213148236, 0.00017646643391344696, 0.00029298671870492399, 0.00027180660981684923, 8.4194340161047876e-05, 0.00013777405547443777, 0.00028780719731003046, 0.00013848615344613791, 0.00036749913124367595, 9.8794138466473669e-05, 0.00011306331725791097, 0.00016281232819892466, 0.00010164760169573128, 0.00020211734226904809, 0.00012019727728329599, 0.00011001592065440491, 0.00034607190173119307, 0.00016086427785921842, 0.0002429833693895489, 0.00048574083484709263, 4.5425927964970469e-05, 0.00023580028209835291, 0.00024214405857492238, 9.5242350653279573e-05, 0.00032280705636367202, 0.00012981353211216629, 0.00015610379341524094, 0.00020598490664269775, 6.860717257950455e-05, 0.00015553596313111484, 0.00018705443653743714, 0.00020827547996304929, 0.00019412841356825083, 0.00027804015553556383, 0.00017278797167818993, 0.00040110613917931914, 9.0825451479759067e-05, 0.00010093500895891339, 0.00023234135005623102, 0.00024423041031695902, 0.00018631033890414983, 0.00035648178891278803, 0.00014082192501518875, 0.00020739158208016306, 5.9253499784972519e-05, 0.0001759527949616313, 0.0001302860036958009, 0.0002204851625720039, 0.00019584475376177579, 0.00027922115987166762, 0.00016192397742997855, 0.00030059341224841774, 0.00014031156024429947, 0.00021912579541094601, 0.00013087710249237716, 9.9178192613180727e-05, 0.00012691461597569287, 0.00045250836410559714, 9.1428955784067512e-05, 0.00029826111858710647, 0.00011363359953975305, 6.8971043219789863e-05, 0.00026577746029943228, 0.00014330771227832884, } };
const TfArray<96, int> quant18_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant18 = { (TfLiteFloatArray*)&quant18_scale, (TfLiteIntArray*)&quant18_zero, 0 };
const ALIGN(16) int8_t tensor_data19[96*1*1*16] = { 
  /* [0][0][][] */ 8,-34,21,70,-12,-38,-57,-48,127,-26,-39,-87,16,-24,15,-56, 
  /* [1][0][][] */ -70,99,36,-60,127,22,-95,28,-70,-21,32,41,-98,42,-26,-85, 
  /* [2][0][][] */ 49,25,-46,62,-56,127,-101,2,58,-34,73,73,47,-98,36,-30, 
  /* [3][0][][] */ 32,127,-4,78,-75,3,-25,-18,56,42,124,-33,21,38,-71,-29, 
  /* [4][0][][] */ 23,-86,47,43,-79,33,31,57,4,41,-104,-22,18,-127,63,39, 
  /* [5][0][][] */ 127,5,-11,11,22,-90,-35,11,7,19,-47,-9,-3,-15,-42,5, 
  /* [6][0][][] */ 16,-125,-84,90,-25,62,-68,51,-79,-44,-20,-52,5,11,127,89, 
  /* [7][0][][] */ -28,-19,19,79,55,-127,-38,38,5,-75,33,-2,-42,31,-16,-49, 
  /* [8][0][][] */ 26,-39,-31,-8,49,29,-27,-31,-11,-26,4,28,-127,-35,6,-1, 
  /* [9][0][][] */ 69,-127,-32,57,27,-52,-13,-49,97,-87,-28,31,22,-23,50,23, 
  /* [10][0][][] */ -47,-15,43,-15,-42,127,54,76,-21,39,-63,-58,47,0,-18,-32, 
  /* [11][0][][] */ 78,-61,-127,55,-32,-27,-32,54,80,-4,-88,-64,16,90,-72,18, 
  /* [12][0][][] */ 38,20,44,120,-59,-123,-92,-18,47,-17,-127,2,-81,-41,91,-88, 
  /* [13][0][][] */ -7,27,39,-63,24,70,28,-127,-26,12,57,13,35,-64,20,-6, 
  /* [14][0][][] */ -47,-6,-42,-65,43,-127,5,-56,-35,-18,-32,-19,-33,48,33,-2, 
  /* [15][0][][] */ -41,13,104,23,-3,-21,-66,-78,-48,-101,-48,-54,-127,11,20,36, 
  /* [16][0][][] */ -108,75,-32,-18,42,45,12,40,-10,11,127,-35,-41,50,-14,-57, 
  /* [17][0][][] */ -7,11,6,-21,15,-7,38,127,-24,115,17,40,-8,82,61,-42, 
  /* [18][0][][] */ 66,74,-87,85,-4,23,1,-58,127,91,-18,-42,78,-18,76,-118, 
  /* [19][0][][] */ 4,14,31,-20,8,-14,-10,-15,-37,-5,-24,12,-127,-12,-8,12, 
  /* [20][0][][] */ 127,-84,-20,-31,-54,-25,36,-99,-86,-47,-118,-40,94,-32,54,12, 
  /* [21][0][][] */ 70,17,24,82,12,-22,17,45,4,0,7,24,11,127,8,-13, 
  /* [22][0][][] */ -26,-1,-6,-3,-26,-13,-44,127,40,-7,-6,-33,30,15,78,25, 
  /* [23][0][][] */ -7,9,-127,12,-6,-107,-11,-30,15,-11,19,-57,-85,-8,4,73, 
  /* [24][0][][] */ 127,-89,-104,-8,99,-77,-99,94,105,17,126,76,-15,65,121,45, 
  /* [25][0][][] */ 24,-125,-100,77,-28,0,5,3,21,-46,-106,42,127,69,-30,57, 
  /* [26][0][][] */ 70,-36,7,89,26,111,-119,-19,-36,-127,50,35,36,-110,11,35, 
  /* [27][0][][] */ -127,18,-106,39,52,6,34,10,47,-5,126,53,31,-41,-4,-27, 
  /* [28][0][][] */ -20,-44,76,70,-117,17,127,82,117,83,-91,-44,-126,-44,56,72, 
  /* [29][0][][] */ -23,81,-16,-40,62,-11,51,-27,-127,-13,1,-24,-38,83,-69,26, 
  /* [30][0][][] */ 59,65,-127,-18,49,-75,-11,-50,5,12,22,-35,-112,-76,9,-66, 
  /* [31][0][][] */ 30,-1,-116,40,10,11,78,-19,23,82,-69,-72,13,-23,-127,18, 
  /* [32][0][][] */ -127,24,-54,41,-10,105,22,9,18,62,115,-44,-80,23,-100,-40, 
  /* [33][0][][] */ -74,-12,107,-98,-77,84,127,52,-60,72,-49,21,-42,54,-40,47, 
  /* [34][0][][] */ 4,-27,-45,-127,34,45,-41,12,-12,-43,-6,-42,-47,-13,13,41, 
  /* [35][0][][] */ -45,14,57,9,79,3,21,-28,-127,21,1,72,-93,95,-37,-59, 
  /* [36][0][][] */ -62,2,-24,15,39,-11,43,127,58,41,110,-38,-18,66,-15,-57, 
  /* [37][0][][] */ -127,-29,72,-107,-71,-18,61,-11,-15,9,18,-20,-6,-78,62,45, 
  /* [38][0][][] */ -50,-20,-2,-87,56,-29,-127,29,-56,-1,107,1,55,-18,-13,38, 
  /* [39][0][][] */ -11,-34,-60,-52,27,-9,65,127,-58,-1,38,-23,-11,13,15,2, 
  /* [40][0][][] */ 31,55,6,31,10,8,-53,-14,0,-55,26,-4,127,46,-35,-47, 
  /* [41][0][][] */ 31,-123,-75,-77,-23,39,-55,-47,4,-20,-8,-91,67,-55,76,127, 
  /* [42][0][][] */ 125,-33,18,127,-34,-21,-63,9,-20,-31,-6,-22,-5,72,6,-68, 
  /* [43][0][][] */ -21,81,45,127,14,93,74,-41,-44,125,-18,79,-33,22,-27,14, 
  /* [44][0][][] */ -72,35,-86,91,63,33,58,99,127,117,49,-59,-43,17,-85,-60, 
  /* [45][0][][] */ 17,62,16,-47,17,-115,49,-58,-46,-35,-36,-32,2,-70,59,-127, 
  /* [46][0][][] */ -4,-37,11,-65,-1,-31,-18,121,-7,-85,-109,-71,11,127,98,41, 
  /* [47][0][][] */ -4,-64,53,-127,-64,87,-18,64,-55,-89,-30,-3,21,-109,60,46, 
  /* [48][0][][] */ 21,64,29,-68,-39,-54,-3,-34,64,6,12,-40,28,127,-43,45, 
  /* [49][0][][] */ 71,-41,50,127,62,71,32,97,-96,6,-37,69,4,61,49,22, 
  /* [50][0][][] */ -87,-62,127,-70,-25,-2,-74,-85,-60,-65,70,40,45,43,15,-32, 
  /* [51][0][][] */ -15,85,43,-45,-2,71,-127,-58,16,11,-13,108,0,-24,83,-22, 
  /* [52][0][][] */ 26,59,103,41,94,-77,17,36,-90,19,69,79,29,107,-127,-92, 
  /* [53][0][][] */ -17,-32,3,-127,1,-55,1,13,-26,-4,43,1,21,24,39,-38, 
  /* [54][0][][] */ -21,23,7,-10,32,3,-46,-42,33,8,66,-40,-35,127,14,-71, 
  /* [55][0][][] */ 29,-13,-73,34,-12,43,-54,-65,27,-14,-58,25,-49,-127,-62,33, 
  /* [56][0][][] */ 39,29,33,49,18,-32,42,127,21,0,3,-73,29,31,-36,21, 
  /* [57][0][][] */ 94,8,122,127,-12,-66,-8,-10,16,39,-63,27,30,-8,78,-86, 
  /* [58][0][][] */ 112,18,76,127,-63,-24,16,-32,-24,-49,-53,45,-15,-77,-6,-62, 
  /* [59][0][][] */ 60,-127,103,-85,38,-39,-47,73,-93,-62,-94,-52,-4,71,-1,-31, 
  /* [60][0][][] */ -63,0,27,-26,74,-5,-15,38,-48,-32,53,25,-127,-14,23,-46, 
  /* [61][0][][] */ -61,127,22,25,-61,75,-90,-124,95,-27,32,-15,-4,9,-124,5, 
  /* [62][0][][] */ -73,-41,-9,-38,127,-19,-34,117,-30,-73,50,54,-106,37,-96,-35, 
  /* [63][0][][] */ 5,8,127,25,-27,-55,11,-63,-1,-34,-19,40,-21,-54,26,-10, 
  /* [64][0][][] */ 27,25,-106,-21,-32,22,6,-68,-23,7,60,-20,-12,-127,-18,13, 
  /* [65][0][][] */ -27,19,-8,-3,40,22,-20,-127,17,-29,-26,-30,-3,-31,46,-58, 
  /* [66][0][][] */ -127,12,15,22,-103,105,-15,-25,-50,-6,-89,10,101,83,30,107, 
  /* [67][0][][] */ 21,40,69,127,-44,-19,-49,-8,-25,-2,14,33,2,-4,-71,14, 
  /* [68][0][][] */ 49,9,-18,127,0,8,-5,-34,-80,-35,-23,-15,-68,-35,-22,-83, 
  /* [69][0][][] */ 83,60,-9,112,20,-100,44,-127,42,34,-16,51,19,-64,-5,-21, 
  /* [70][0][][] */ 127,-82,-12,6,46,23,6,32,22,-70,-1,62,29,36,67,78, 
  /* [71][0][][] */ 42,13,-23,66,62,-127,-37,47,87,-71,-6,-19,53,-27,10,26, 
  /* [72][0][][] */ -127,-68,-4,35,43,52,-13,20,-63,-21,-44,37,13,18,2,87, 
  /* [73][0][][] */ 13,-50,-17,127,-8,-30,-49,-76,51,-18,-86,59,87,11,59,-14, 
  /* [74][0][][] */ 127,-34,-30,4,58,-69,47,-33,14,-30,-104,-21,-77,-9,-12,-26, 
  /* [75][0][][] */ 21,-53,-85,127,-37,-29,-111,-63,17,-23,-3,-60,61,-67,41,-37, 
  /* [76][0][][] */ -23,24,29,-25,7,-2,-23,-79,-33,-127,-28,53,-39,-13,-27,-3, 
  /* [77][0][][] */ 127,-45,-48,98,-60,-37,-77,-82,89,3,26,-74,65,5,-10,-1, 
  /* [78][0][][] */ -52,41,25,-28,-10,3,-45,-19,7,18,37,-14,20,127,13,-10, 
  /* [79][0][][] */ 1,67,31,39,-15,66,-98,-127,-9,-88,91,-36,105,-78,-20,-44, 
  /* [80][0][][] */ 18,-20,-33,63,-11,-102,13,-9,-67,-31,-108,34,18,-127,60,-22, 
  /* [81][0][][] */ 127,-40,-97,36,101,17,-60,-19,67,-113,-41,-115,52,5,-14,-12, 
  /* [82][0][][] */ 127,61,18,56,-74,-28,-38,-43,-34,-18,13,-18,9,31,40,-27, 
  /* [83][0][][] */ 127,69,35,37,-55,19,-29,22,15,32,51,-40,-42,-5,-32,-52, 
  /* [84][0][][] */ -7,-127,-42,-56,-26,27,30,-106,-42,8,-46,17,14,-113,102,110, 
  /* [85][0][][] */ -49,74,26,-51,-1,-11,99,70,-44,53,-4,24,-38,127,-34,-30, 
  /* [86][0][][] */ 53,-25,63,20,-73,6,3,-38,15,-4,-127,32,63,31,21,41, 
  /* [87][0][][] */ -109,87,-102,-7,22,114,84,65,81,71,96,-11,68,-127,6,42, 
  /* [88][0][][] */ 39,-21,-69,-9,43,68,88,-127,106,5,-48,-24,-93,-62,-46,-26, 
  /* [89][0][][] */ 62,-52,-5,-31,28,-9,-8,127,10,-19,21,35,22,14,16,30, 
  /* [90][0][][] */ 47,20,-3,116,12,-43,127,-42,49,63,-83,-11,49,8,19,-59, 
  /* [91][0][][] */ 29,-41,32,39,-85,-127,15,-55,26,24,-90,22,26,-23,-32,61, 
  /* [92][0][][] */ 95,88,71,55,-25,-127,-58,-19,-61,-73,-111,49,-1,-55,5,-9, 
  /* [93][0][][] */ 127,-55,-14,37,-29,-95,35,6,11,30,-88,-11,-25,-5,27,7, 
  /* [94][0][][] */ -31,57,66,-59,127,-76,-23,76,-19,-24,6,88,-49,81,-86,-81, 
  /* [95][0][][] */ -75,127,77,122,-34,99,57,19,56,40,81,8,34,7,-3,-42, 
};
const TfArray<4, int> tensor_dimension19 = { 4, { 96,1,1,16 } };
const TfArray<96, float> quant19_scale = { 96, { 0.0008243852062150836, 0.00064569246023893356, 0.00034921956830658019, 0.001820313511416316, 0.00043487793300300837, 0.00068040640326216817, 0.00071186112472787499, 0.0011213122634217143, 0.0012002391740679741, 0.0005405684350989759, 0.00077790458453819156, 0.00067745696287602186, 0.00072462664684280753, 0.00060907367151230574, 0.001144146197475493, 0.0005849159206263721, 0.00077977910405024886, 0.00042212053085677326, 0.00048227512161247432, 0.0013680270640179515, 0.0010367861250415444, 0.00033236306626349688, 0.0011518317041918635, 0.00071826536441221833, 0.00037739408435299993, 0.00090066803386434913, 0.00061729212757200003, 0.000381427351385355, 0.00084449764108285308, 0.0009905428159981966, 0.00051649706438183784, 0.00052168627735227346, 0.00038783153286203742, 0.00068299227859824896, 0.0011339701013639569, 0.0010519950883463025, 0.00032586415181867778, 0.00053323805332183838, 0.0011139233829453588, 0.00053599412785843015, 0.0014223615871742368, 0.00038237092667259276, 0.00043759809341281652, 0.00063014571787789464, 0.00039341492811217904, 0.00078227109042927623, 0.00046520921750925481, 0.00042580350418575108, 0.0013394299894571304, 0.00062260602135211229, 0.00094043812714517117, 0.0018800019752234221, 0.00017581562860868871, 0.00091263686772435904, 0.00093718967400491238, 0.00036862416891381145, 0.0012493862304836512, 0.00050242780707776546, 0.00060418108478188515, 0.00079724000534042716, 0.00026553586940281093, 0.00060198339633643627, 0.00072397186886519194, 0.00080610538134351373, 0.00075135088991373777, 0.0010761212324723601, 0.00066875520860776305, 0.0015524334739893675, 0.00035152907366864383, 0.00039065690361894667, 0.00089924945496022701, 0.00094526470638811588, 0.00072109192842617631, 0.0013797202846035361, 0.0005450344760902226, 0.00080268440069630742, 0.00022933360014576465, 0.00068100431235507131, 0.00050425645895302296, 0.0008533615036867559, 0.00075799378100782633, 0.0010806921636685729, 0.00062670744955539703, 0.0011634109541773796, 0.00054305914090946317, 0.0008481002296321094, 0.00050654419464990497, 0.00038385737570933998, 0.00049120787298306823, 0.0017513796919956803, 0.00035386485978960991, 0.0011543841101229191, 0.00043980529881082475, 0.00026694420375861228, 0.0010286599863320589, 0.00055465538753196597, } };
const TfArray<96, int> quant19_zero = { 96, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant19 = { (TfLiteFloatArray*)&quant19_scale, (TfLiteIntArray*)&quant19_zero, 0 };
const ALIGN(16) int32_t tensor_data20[16] = { -41830, -2371, 2308, -26201, 2110, -3759, -10390, -42964, -21078, 38174, 23040, 9697, -24004, -26042, 28775, -27797, };
const TfArray<1, int> tensor_dimension20 = { 1, { 16 } };
const TfArray<16, float> quant20_scale = { 16, { 0.0003794281801674515, 0.00064616947202011943, 0.00064028764609247446, 0.00076072855154052377, 0.00073215120937675238, 0.00069040106609463692, 0.00070244603557512164, 0.00042420104728080332, 0.00056390027748420835, 0.00040491056279279292, 0.00062446005176752806, 0.00031765937455929816, 0.00058988301316276193, 0.00092953670537099242, 0.00045509956544265151, 0.00034132739529013634, } };
const TfArray<16, int> quant20_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant20 = { (TfLiteFloatArray*)&quant20_scale, (TfLiteIntArray*)&quant20_zero, 0 };
const ALIGN(16) int8_t tensor_data21[16*1*1*48] = { 
  /* [0][0][][] */ 3,50,-23,-38,0,-21,35,121,-89,19,50,-28,-35,-7,0,31,5,-55,-37,0,44,-18,-1,127,-21,77,10,-21,35,18,51,-14,-13,40,44,-58,22,75,44,-29,-75,-30,23,17,34,17,-87,-39, 
  /* [1][0][][] */ -41,11,-6,14,-67,15,-10,46,-32,-35,1,-48,-46,6,-5,-6,-4,64,-19,8,-14,5,-28,-38,-20,-38,-7,40,-50,-53,-46,24,0,-5,43,-10,6,-43,11,23,-34,-23,127,5,37,-13,5,-18, 
  /* [2][0][][] */ -19,-15,-11,-8,-10,-68,4,-30,-7,0,12,0,19,34,-2,5,5,-22,-1,-11,23,10,11,-127,-15,98,-8,5,-4,-42,-19,-1,-19,55,2,22,24,3,28,3,-50,-1,3,-6,5,-32,-6,23, 
  /* [3][0][][] */ -6,39,6,-7,-8,-6,-20,9,-24,10,34,47,-127,26,-13,-15,25,-15,-1,-31,-12,-23,-20,16,5,1,8,8,-24,19,5,36,7,5,37,23,33,14,53,-2,5,4,34,-50,24,1,6,23, 
  /* [4][0][][] */ 26,-36,5,-7,48,24,18,-13,-55,2,-32,-13,13,-12,7,26,7,-4,-65,16,-2,28,-7,71,25,-35,10,48,-6,-68,39,-10,19,-26,23,-127,11,20,-4,17,5,23,-8,-7,-28,-24,-1,3, 
  /* [5][0][][] */ 40,-28,-32,94,1,-6,-11,-6,35,-14,41,43,14,53,1,3,-46,16,57,0,43,-18,-8,-10,3,-56,-22,-31,21,-9,-4,38,45,-127,8,52,-13,-8,-30,0,-91,72,27,9,-7,-14,-103,-16, 
  /* [6][0][][] */ 29,-4,19,26,-11,-22,-28,-1,6,-1,-2,10,-22,17,21,-8,1,-18,127,9,3,17,2,-19,12,34,20,-12,-16,-11,-21,-7,-11,-3,27,-53,-7,-32,62,9,4,-10,-3,-4,4,-24,-17,-5, 
  /* [7][0][][] */ -89,-67,-65,0,7,98,43,42,-29,87,-4,127,101,-20,-12,34,-17,-17,-33,-11,6,4,-79,56,-15,-33,-34,-1,-18,-20,18,-6,46,-28,-38,-8,29,-119,87,1,27,72,-94,-63,-2,-31,-24,-17, 
  /* [8][0][][] */ -18,-6,17,29,-3,0,-8,56,28,-77,-8,52,29,-11,4,14,-19,53,-10,-13,-29,9,0,17,7,-19,-4,-4,-14,127,-1,41,11,3,4,-63,-61,57,7,23,32,4,104,2,-7,37,11,27, 
  /* [9][0][][] */ -55,2,36,55,61,-5,-14,-13,114,-84,51,111,-77,38,26,-10,-37,25,-19,-45,53,-4,-10,-43,57,-3,46,-97,-17,8,15,-8,4,27,84,-98,-39,-108,-127,45,-79,34,60,23,-38,43,28,-47, 
  /* [10][0][][] */ -19,-9,-43,-93,20,75,13,-19,17,18,10,-11,45,-65,-34,25,47,-18,28,-33,16,-13,2,22,-56,-127,0,-16,21,34,30,-29,-1,-74,20,-6,19,-60,-1,-55,-20,-28,14,37,-8,21,33,-39, 
  /* [11][0][][] */ -2,-1,-18,10,42,-81,-48,-27,-37,42,2,-30,30,61,-14,-44,-10,60,-8,1,-33,-127,23,-16,-30,-14,14,-43,53,-76,-8,-37,35,-26,-46,-44,110,12,-17,-82,-15,37,64,-57,-26,-66,17,44, 
  /* [12][0][][] */ 117,15,-43,8,15,49,20,127,4,3,-53,16,-10,-5,-7,-7,-27,10,-14,-10,16,40,49,13,1,-6,1,-8,26,52,18,-2,-20,-73,-13,69,5,-12,-29,-52,-6,-73,5,-123,-69,-45,114,-30, 
  /* [13][0][][] */ -9,15,-17,-7,7,6,-18,12,-8,26,6,19,-7,3,9,-6,1,-5,-11,-18,-6,-6,-1,-15,-4,-2,24,127,-1,0,7,-9,18,-8,-33,12,24,-21,10,-24,-27,10,-12,1,-6,3,3,-14, 
  /* [14][0][][] */ 6,-19,-3,-88,90,45,61,-39,-58,-14,-23,103,-52,14,28,-30,30,64,-83,70,-20,46,67,-25,11,56,-19,-96,24,-40,30,-32,-32,24,-127,-34,-30,27,100,13,-45,18,-1,-16,-43,33,3,-24, 
  /* [15][0][][] */ -23,-66,-26,-5,107,23,52,-33,6,30,-28,-14,95,20,-37,74,40,106,62,-31,-85,23,30,-18,-79,44,37,30,90,37,99,-44,36,32,39,127,-55,-69,-81,-37,74,71,78,-26,-44,8,-32,36, 
};
const TfArray<4, int> tensor_dimension21 = { 4, { 16,1,1,48 } };
const TfArray<16, float> quant21_scale = { 16, { 0.016125697642564774, 0.027462203055620193, 0.027212224900722504, 0.032330963760614395, 0.03111642599105835, 0.029342044144868851, 0.029853954911231995, 0.018028544262051582, 0.023965761065483093, 0.017208699136972427, 0.026539551094174385, 0.013500522822141647, 0.025070028379559517, 0.039505310356616974, 0.019341731444001198, 0.014506413601338863, } };
const TfArray<16, int> quant21_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant21 = { (TfLiteFloatArray*)&quant21_scale, (TfLiteIntArray*)&quant21_zero, 0 };
const ALIGN(16) int32_t tensor_data22[48] = { 6610, 53112, -2870, 58792, 4451, 128293, -3719, 53821, 1971, 27239, 23976, 2623, 5961, 34027, -6623, -6054, -1400, 3957, 925, -1480, 4094, -800, -5590, -21921, -5510, 44905, 125461, 95439, 1412, 9060, -1634, 4004, 26589, 3264, 49035, 67, 72809, 4587, 46423, 4790, 2612, 120877, -3015, 4146, 52773, 2077, 6045, 53197, };
const TfArray<1, int> tensor_dimension22 = { 1, { 48 } };
const TfArray<48, float> quant22_scale = { 48, { 6.2152619648259133e-05, 3.0253455406636931e-05, 0.00016205485735554248, 4.0763585275271907e-05, 0.00013407118967734277, 7.2624308813828975e-05, 9.2289359599817544e-05, 0.00011172940139658749, 8.6098509200382978e-05, 5.2828978368779644e-05, 4.0372808143729344e-05, 7.5842966907657683e-05, 3.9495269447797909e-05, 2.5760256903595291e-05, 0.00018829802866093814, 0.0001271460932912305, 0.00022886242368258536, 6.07719921390526e-05, 0.00011393569729989395, 0.00014216150157153606, 6.0542093706317246e-05, 0.00012627535033971071, 0.00011107050522696227, 0.00014474308409262449, 0.00010115579061675817, 9.2782473075203598e-05, 1.7315331206191331e-05, 7.5227071647532284e-05, 0.00012386339949443936, 7.6949756476096809e-05, 0.00011844022810691968, 0.00019873776182066649, 2.8149052013759501e-05, 0.00011020540841855109, 2.5162777092191391e-05, 5.4697124141966924e-05, 8.0802929005585611e-05, 6.5414758864790201e-05, 0.00012453860836103559, 0.00010041763744084165, 9.5202041848096997e-05, 4.7165725845843554e-05, 6.6525652073323727e-05, 7.3490118666086346e-05, 2.8408874641172588e-05, 0.00012916789273731411, 7.7883276389911771e-05, 2.2018510207999498e-05, } };
const TfArray<48, int> quant22_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant22 = { (TfLiteFloatArray*)&quant22_scale, (TfLiteIntArray*)&quant22_zero, 0 };
const ALIGN(16) int8_t tensor_data23[1*3*3*48] = { 
  /* [0][0][][] */ 65,-106,104,82,58,-32,118,-75,64,-82,-99,56,53,-42,-68,-83,103,80,51,83,71,-91,-84,42,-27,-40,-69,-60,-62,61,-72,-119,-17,46,68,66,-61,55,-51,-25,41,-86,60,55,-94,2,80,-35, 81,-105,127,81,-78,-68,-68,-82,80,-95,-65,78,93,-97,-88,98,-33,88,79,127,92,-119,52,62,-50,-76,-64,-73,52,74,-35,-127,-99,84,88,88,-83,81,-79,-20,63,-103,95,93,-81,-127,106,-97, 45,-52,67,38,13,-50,-60,-41,46,-28,-4,31,41,-75,-53,11,-64,35,38,72,24,-60,35,31,-35,-55,-46,-29,41,26,93,-92,-85,44,40,35,-25,45,-35,-23,50,-40,45,40,-13,-22,31,-83, 
  /* [0][1][][] */ 87,-127,-31,93,57,-81,127,-91,93,-109,-66,79,84,-114,-13,-127,127,101,79,-37,77,106,-127,72,73,-69,-95,-97,-127,88,-77,-11,-74,73,108,102,-91,80,-87,81,84,-100,82,93,-93,102,102,-99, 127,-127,-72,127,-127,-127,-105,-127,127,-127,-127,127,127,-127,-20,95,-56,127,127,-55,127,127,71,127,127,-127,-127,-127,46,127,-23,18,-127,127,127,127,-127,127,-127,127,127,-127,127,127,-127,-10,127,-127, 73,-98,-37,73,32,-66,-56,-68,49,-41,-78,54,48,-61,-14,20,-70,58,61,-30,65,74,64,64,65,-75,-75,-46,41,44,127,15,-71,63,44,50,-45,63,-47,53,57,-59,58,56,-65,-65,68,-54, 
  /* [0][2][][] */ 42,-47,-35,68,26,-51,66,-46,63,-87,9,39,59,-77,86,-78,79,50,42,-45,22,-16,-79,39,-18,-51,-50,-43,-70,29,-49,82,-61,41,56,49,-29,54,-46,-87,45,-44,34,42,-25,9,46,-75, 78,-81,-41,91,-61,-68,-80,-75,55,-85,-49,69,79,-53,127,32,-53,59,64,-53,49,-28,46,61,-47,-74,-86,-59,34,49,-24,105,-50,67,60,70,-52,64,-63,-96,62,-68,58,61,-80,39,70,-58, 47,-43,-17,52,28,-27,-21,-45,17,-24,-50,28,30,-5,66,24,-42,31,30,-39,27,-5,50,42,-31,-34,-59,-24,31,33,60,63,-16,47,7,22,-21,34,-37,-57,27,-42,25,32,-56,7,34,2, 
};
const TfArray<4, int> tensor_dimension23 = { 4, { 1,3,3,48 } };
const TfArray<48, float> quant23_scale = { 48, { 0.0026414862368255854, 0.0012857718393206596, 0.0068873311392962933, 0.0017324523068964481, 0.0056980256922543049, 0.0030865329317748547, 0.0039222976192831993, 0.0047484994865953922, 0.0036591864190995693, 0.002245231531560421, 0.0017158443806692958, 0.0032233260571956635, 0.0016785489860922098, 0.0010948108974844217, 0.0080026658251881599, 0.0054037091322243214, 0.0097266528755426407, 0.0025828096549957991, 0.0048422669060528278, 0.0060418634675443172, 0.0025730389170348644, 0.0053667020983994007, 0.004720496479421854, 0.0061515807174146175, 0.0042991209775209427, 0.0039432551711797714, 0.00073590152896940708, 0.0031971505377441645, 0.0052641946822404861, 0.0032703645993024111, 0.0050337095744907856, 0.0084463544189929962, 0.0011963347205892205, 0.0046837297268211842, 0.0010694180382415652, 0.0023246277123689651, 0.0034341244027018547, 0.0027801271062344313, 0.0052928910590708256, 0.0042677493765950203, 0.0040460866875946522, 0.0020045433193445206, 0.0028273400384932756, 0.0031233299523591995, 0.0012073771795257926, 0.005489635281264782, 0.0033100391738116741, 0.00093578663654625416, } };
const TfArray<48, int> quant23_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant23 = { (TfLiteFloatArray*)&quant23_scale, (TfLiteIntArray*)&quant23_zero, 3 };
const ALIGN(16) int32_t tensor_data24[48] = { 294, 1120, 2920, 145, 13009, 17666, 3664, -196, -1151, -898, 1094, 1212, 2324, 768, 94126, 5499, 4506, -1658, -95, 6730, -1689, 10769, 9480, 15230, 3857, -135, 7025, 4928, 5274, -165, 13859, 13224, 582, -528, 5777, 4350, -3555, 26, -920, 4675, -58, -183, -424, -34, 1418, 3113, 415, 823, };
const TfArray<1, int> tensor_dimension24 = { 1, { 48 } };
const TfArray<48, float> quant24_scale = { 48, { 0.00034258075174875557, 0.0006604599766433239, 0.00019580568186938763, 0.00029092768090777099, 0.00015527007053606212, 0.00022429427190218121, 0.00030029303161427379, 0.00023569480981677771, 0.00029258514405228198, 0.00068300799466669559, 0.00083350145723670721, 0.0003259197692386806, 0.00046577019384130836, 0.00075275381095707417, 4.2183190089417621e-05, 0.00022042100317776203, 0.00014735547301825136, 0.00030384783167392015, 0.00023626517213415354, 0.00015716472989879549, 0.00035969418240711093, 0.00023216039699036628, 0.00035547677543945611, 0.0001057504050550051, 0.00041862114449031651, 0.00031966689857654274, 0.00098707107827067375, 0.00037389350472949445, 0.00031960365595296025, 0.00050086103146895766, 0.00020263373153284192, 0.0001095155457733199, 0.00053873186698183417, 0.00020754715660586953, 0.00063635531114414334, 0.00040717326919548213, 0.00036650069523602724, 0.00045517162652686238, 0.00017295377620030195, 0.00039407849544659257, 0.00025023685884661973, 0.00026448411517776549, 0.00034165734541602433, 0.00032280851155519485, 0.0013648353051394224, 0.00042349446448497474, 0.00038727684295736253, 0.0012768527958542109, } };
const TfArray<48, int> quant24_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant24 = { (TfLiteFloatArray*)&quant24_scale, (TfLiteIntArray*)&quant24_zero, 0 };
const ALIGN(16) int8_t tensor_data25[48*1*1*8] = { 
  /* [0][0][][] */ -127,4,-12,83,-30,18,31,-44, 
  /* [1][0][][] */ 127,78,90,-3,-11,-34,123,77, 
  /* [2][0][][] */ -23,-84,-32,14,-127,-9,1,83, 
  /* [3][0][][] */ 127,-5,-4,-78,-85,-11,43,-11, 
  /* [4][0][][] */ -123,-23,-97,-31,76,-81,88,127, 
  /* [5][0][][] */ -86,-39,1,-7,-127,-25,-14,89, 
  /* [6][0][][] */ -36,-127,-51,-31,20,-39,-27,17, 
  /* [7][0][][] */ -68,39,28,98,127,-38,-28,19, 
  /* [8][0][][] */ 106,0,11,-127,18,-19,31,-59, 
  /* [9][0][][] */ 43,-127,-3,-10,3,106,-30,19, 
  /* [10][0][][] */ -66,80,-27,-4,-75,45,127,37, 
  /* [11][0][][] */ 127,-29,9,15,-31,-12,-19,-99, 
  /* [12][0][][] */ -15,31,-2,14,19,-37,127,66, 
  /* [13][0][][] */ 11,-28,42,-45,88,102,127,-18, 
  /* [14][0][][] */ 52,27,49,39,-127,6,-90,-37, 
  /* [15][0][][] */ 81,-127,43,-48,-107,-22,64,116, 
  /* [16][0][][] */ -22,0,51,36,-127,-15,7,-15, 
  /* [17][0][][] */ -27,63,-127,-34,-5,-108,76,-67, 
  /* [18][0][][] */ 127,-4,-6,-37,-92,26,4,76, 
  /* [19][0][][] */ 127,-89,-86,0,25,40,102,26, 
  /* [20][0][][] */ 45,-36,-36,127,0,26,-35,-61, 
  /* [21][0][][] */ 25,12,2,17,-68,127,-70,-86, 
  /* [22][0][][] */ -127,2,16,14,-47,2,-48,1, 
  /* [23][0][][] */ -60,-61,48,26,-125,127,111,-76, 
  /* [24][0][][] */ 127,1,5,-30,-13,-30,-3,21, 
  /* [25][0][][] */ 7,-20,-10,-26,127,85,38,-34, 
  /* [26][0][][] */ -98,-68,-1,2,44,-127,100,-68, 
  /* [27][0][][] */ -16,-127,15,-8,-6,-56,35,0, 
  /* [28][0][][] */ -81,33,-27,36,-36,-16,127,36, 
  /* [29][0][][] */ -9,8,24,-23,6,59,-68,-127, 
  /* [30][0][][] */ 94,-1,127,4,-66,-57,-63,-44, 
  /* [31][0][][] */ 1,-63,-32,-12,1,-82,127,121, 
  /* [32][0][][] */ -127,7,5,41,-77,-89,-108,56, 
  /* [33][0][][] */ -47,-6,27,2,-127,-53,-65,22, 
  /* [34][0][][] */ 22,-127,40,-24,-6,115,-86,58, 
  /* [35][0][][] */ -17,-25,-127,11,4,-59,27,-31, 
  /* [36][0][][] */ 59,93,94,-2,-64,26,-62,-127, 
  /* [37][0][][] */ -127,11,35,-27,2,-11,-14,-85, 
  /* [38][0][][] */ -127,-34,-107,-17,67,4,43,109, 
  /* [39][0][][] */ 77,-36,40,-31,68,-12,127,2, 
  /* [40][0][][] */ -42,-10,-2,-2,-98,120,127,-24, 
  /* [41][0][][] */ -84,20,20,-83,-103,-67,-127,45, 
  /* [42][0][][] */ -53,-86,-127,-44,2,89,-83,-67, 
  /* [43][0][][] */ -50,57,52,-127,59,36,45,17, 
  /* [44][0][][] */ 127,-11,69,-110,64,-38,-19,52, 
  /* [45][0][][] */ -29,-32,-31,9,19,-24,127,-62, 
  /* [46][0][][] */ 89,2,-36,-32,127,-66,-31,13, 
  /* [47][0][][] */ 127,1,14,82,-6,51,-16,-24, 
};
const TfArray<4, int> tensor_dimension25 = { 4, { 48,1,1,8 } };
const TfArray<48, float> quant25_scale = { 48, { 0.00066855031764134765, 0.0012888953788205981, 0.00038211708306334913, 0.00056774873519316316, 0.00030301135848276317, 0.00043771287892013788, 0.00058602535864338279, 0.00045996115659363568, 0.00057098333491012454, 0.0013328980421647429, 0.0016265878221020103, 0.00063603621674701571, 0.0009089559898711741, 0.0014690078096464276, 8.2320984802208841e-05, 0.00043015414848923683, 0.00028756592655554414, 0.00059296260587871075, 0.00046107423258945346, 0.00030670879641547799, 0.00070194737054407597, 0.00045306372339837253, 0.00069371709832921624, 0.00020637315174099058, 0.00081694405525922775, 0.00062383367912843823, 0.0019262807909399271, 0.00072965753497555852, 0.00062371027888730168, 0.00097743619699031115, 0.00039544209721498191, 0.00021372086484916508, 0.0010513415327295661, 0.00040503070340491831, 0.0012418548576533794, 0.00079460337292402983, 0.00071523035876452923, 0.00088827271247282624, 0.00033752131275832653, 0.0007690487545914948, 0.00048834015615284443, 0.00051614386029541492, 0.00066674826666712761, 0.00062996457563713193, 0.0026634919922798872, 0.00082645437214523554, 0.00075577525421977043, 0.0024917931295931339, } };
const TfArray<48, int> quant25_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant25 = { (TfLiteFloatArray*)&quant25_scale, (TfLiteIntArray*)&quant25_zero, 0 };
const ALIGN(16) int32_t tensor_data26[8] = { -41997, 20367, -36100, -227, 24289, -17572, 40400, 53642, };
const TfArray<1, int> tensor_dimension26 = { 1, { 8 } };
const TfArray<8, float> quant26_scale = { 8, { 0.00053448264952749014, 0.00045919770491309464, 0.0013869233662262559, 0.00096350262174382806, 0.00057266815565526485, 0.00032648991327732801, 0.00045830817543901503, 0.00078024517279118299, } };
const TfArray<8, int> quant26_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant26 = { (TfLiteFloatArray*)&quant26_scale, (TfLiteIntArray*)&quant26_zero, 0 };
const ALIGN(16) int8_t tensor_data27[8*1*1*48] = { 
  /* [0][0][][] */ -31,7,-12,2,49,-29,12,25,-73,85,-18,98,74,27,65,-5,-9,8,-41,-6,-7,-14,-10,-11,68,-66,10,57,-19,0,39,-45,23,-59,127,4,0,11,-10,-16,34,-19,68,8,-23,29,-44,-11, 
  /* [1][0][][] */ 7,29,127,-36,10,5,0,-94,-6,23,-9,-16,-21,30,6,-95,-2,-48,23,1,-39,32,-19,-40,-4,-19,12,-14,-12,-19,-8,37,-32,41,28,61,-38,-32,47,-49,23,18,-6,13,-70,26,27,-43, 
  /* [2][0][][] */ 18,-47,10,-25,32,31,1,-1,-4,27,-14,12,-3,56,18,8,-18,127,8,-32,-16,15,-38,-9,83,-2,-7,-19,-22,-20,-14,-2,-15,2,11,19,-12,23,-4,24,39,-28,-13,-8,-21,37,-18,-11, 
  /* [3][0][][] */ 9,-127,-39,-35,-12,-22,-22,-1,-4,-26,43,-18,-2,17,28,-7,4,-33,10,17,7,18,-34,33,15,67,12,-5,-53,-49,116,0,12,25,-29,11,-1,-12,-21,27,12,13,-45,50,-4,2,4,13, 
  /* [4][0][][] */ -72,28,16,-9,-12,-44,9,10,52,-60,22,-17,-18,-30,-37,-32,-38,5,-22,19,19,-13,29,15,-17,36,-3,127,46,13,17,-37,-8,-127,-50,20,-1,-15,0,-15,-25,24,11,33,-56,-16,-35,10, 
  /* [5][0][][] */ -14,-29,39,22,-16,32,-10,56,2,29,-22,16,19,-18,-1,17,-7,-112,-3,-76,-38,-85,-11,57,18,64,-108,-49,-76,-11,43,53,-40,-127,-36,-53,69,38,-68,39,69,-23,4,26,113,-5,-64,10, 
  /* [6][0][][] */ -13,-43,11,46,35,-35,-32,-55,9,-19,100,-58,5,43,-31,-85,-28,41,-40,7,-30,92,37,-80,-17,22,-61,-73,14,34,-24,-5,-51,-54,-39,83,-58,-31,-4,-96,17,25,10,108,127,-3,85,-29, 
  /* [7][0][][] */ 23,51,-75,13,-47,-1,15,57,24,-20,23,-35,31,-62,10,-36,-37,-127,67,-11,94,38,-2,-66,-11,-63,16,-22,-15,50,-4,-26,-19,52,17,-19,-16,-61,-7,-69,12,-5,44,43,-39,-1,-17,-6, 
};
const TfArray<4, int> tensor_dimension27 = { 4, { 8,1,1,48 } };
const TfArray<8, float> quant27_scale = { 8, { 0.022715512663125992, 0.019515901803970337, 0.058944240212440491, 0.040948860347270966, 0.024338396266102791, 0.013875821605324745, 0.019478097558021545, 0.033160418272018433, } };
const TfArray<8, int> quant27_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant27 = { (TfLiteFloatArray*)&quant27_scale, (TfLiteIntArray*)&quant27_zero, 0 };
const ALIGN(16) int32_t tensor_data28[48] = { -50579, -735, 10760, 3694, 5524, -12016, 3772, 34592, 2285, 29557, -1501, 17912, -8699, -1119, 35828, 26588, -477, 22660, 32331, 8831, 1519, 255, 1647, 20819, -6805, 17606, 48375, 21474, 2153, 4949, 606, -130, 1078, 8373, -6481, 13390, -13274, 20647, -22101, 129751, 44040, 21775, 8918, -2827, 14316, 3290, 3381, 444, };
const TfArray<1, int> tensor_dimension28 = { 1, { 48 } };
const TfArray<48, float> quant28_scale = { 48, { 0.00042250994010828435, 0.00038108869921416044, 0.00018199227633886039, 0.00023787129612173885, 0.00012343493290245533, 0.00013815796410199255, 0.00032195393578149378, 9.8204996902495623e-05, 0.00010856216249521822, 0.00016260889242403209, 7.8687538916710764e-05, 0.00024771463358774781, 0.00020463101100176573, 0.00027181938639841974, 7.1137903432827443e-05, 6.3013751059770584e-05, 0.00014332434511743486, 0.00021847935568075627, 7.2811395511962473e-05, 0.00021540948364418, 0.00025272287894040346, 0.00031586273689754307, 0.00017893801850732416, 9.6509400464128703e-05, 0.00018292669847141951, 0.00022833814728073776, 0.00045529077760875225, 0.00016765484178904444, 0.0002267777017550543, 0.00017235397535841912, 7.1858819865155965e-05, 0.00020988640608265996, 0.00066453783074393868, 0.00028838188154622912, 0.00020122683781664819, 0.00017007923452183604, 0.00029134302167221904, 0.00013955617032479495, 0.0003903144970536232, 1.9863015040755272e-05, 7.7124364906921983e-05, 5.074439468444325e-05, 0.00019145231635775417, 0.00019358916324563324, 0.00017195871623698622, 0.00011248232476646081, 0.00015001322026364505, 6.691691669402644e-05, } };
const TfArray<48, int> quant28_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant28 = { (TfLiteFloatArray*)&quant28_scale, (TfLiteIntArray*)&quant28_zero, 0 };
const ALIGN(16) int8_t tensor_data29[1*3*3*48] = { 
  /* [0][0][][] */ 7,-6,20,107,3,85,-1,31,16,6,10,5,0,-12,-50,11,-6,8,-16,-119,-7,-30,127,-7,-10,7,-7,6,-4,2,17,101,19,27,42,-30,6,26,-12,6,19,-63,-11,-9,16,8,-8,-8, 118,11,14,-127,25,95,11,14,125,127,4,41,-51,-26,2,11,127,-58,-60,-54,-110,24,-111,15,13,78,-32,-81,25,22,15,-124,5,-61,127,12,-35,-52,-11,122,-77,-101,-35,7,-37,-4,-127,24, -30,-1,7,12,-3,73,5,19,30,9,-18,30,-13,-8,11,6,-105,27,-7,75,-38,-13,-18,-3,-6,-55,-6,31,-13,5,9,-21,12,-20,23,-15,4,38,36,-7,49,36,-20,9,-40,4,-3,-8, 
  /* [0][1][][] */ 127,6,2,-100,16,-29,34,-14,7,6,-13,46,0,-3,9,-32,-4,-51,-56,-88,9,-79,-126,-16,3,102,-14,-127,-11,29,14,-108,22,-56,-6,127,-2,52,-52,41,-60,-127,40,-82,-43,-17,-18,-4, 21,-122,-127,110,-127,-127,-127,-127,-127,-100,127,-127,127,127,35,-127,-86,127,127,-100,127,127,115,127,127,-127,-127,28,-127,-127,94,127,-127,127,-34,-37,127,-127,127,127,127,-80,127,127,127,-118,96,108, 49,7,49,-16,3,-57,40,20,-24,14,-107,-10,2,-44,127,7,61,-70,-86,90,12,-47,7,-29,1,4,-38,68,25,39,0,3,33,-40,9,69,-3,58,67,-7,-79,8,-92,-29,28,-14,-15,2, 
  /* [0][2][][] */ -45,-10,27,-20,10,34,-38,26,2,-28,11,26,9,-7,-49,21,4,22,-12,103,1,-33,-18,-15,-8,21,0,49,-9,1,45,-29,-12,-44,-35,-38,-3,30,3,-26,11,-3,47,-32,-37,13,-16,23, 64,127,74,21,15,-16,120,39,15,-6,44,23,-5,1,-97,27,-58,-57,-49,127,-42,50,10,14,26,-67,-39,32,86,0,127,22,88,-24,6,-34,-26,-21,-12,109,-25,-13,-45,47,20,-32,3,-127, -41,1,6,0,5,-4,-58,9,-23,-14,-42,-42,22,-8,-12,12,33,23,-26,-123,23,-7,2,-9,-11,-5,-10,-49,-7,5,11,11,-25,93,-42,-21,-4,34,29,-59,6,14,-41,12,-43,127,-6,-10, 
};
const TfArray<4, int> tensor_dimension29 = { 4, { 1,3,3,48 } };
const TfArray<48, float> quant29_scale = { 48, { 0.017956672236323357, 0.016196269541978836, 0.007734671700745821, 0.010109529830515385, 0.0052459845319390297, 0.0058717136271297932, 0.013683042488992214, 0.0041737123392522335, 0.0046138917095959187, 0.0069108777679502964, 0.0033442203421145678, 0.010527871549129486, 0.0086968177929520607, 0.011552323587238789, 0.0030233608558773994, 0.0026780844200402498, 0.0060912845656275749, 0.00928537268191576, 0.003094484331086278, 0.009154902771115303, 0.010740721598267555, 0.013424165546894073, 0.0076048653572797775, 0.0041016493923962116, 0.0077743842266499996, 0.0097043709829449654, 0.019349858164787292, 0.0071253306232392788, 0.0096380524337291718, 0.0073250439018011093, 0.0030539997387677431, 0.0089201722294092178, 0.028242858126759529, 0.012256229296326637, 0.0085521405562758446, 0.007228367030620575, 0.012382077984511852, 0.0059311371296644211, 0.016588365659117699, 0.00084417813923209906, 0.0032777853775769472, 0.0021566366776823997, 0.0081367231905460358, 0.0082275392487645149, 0.0073082451708614826, 0.0047804987989366055, 0.0063755619339644909, 0.002843968803063035, } };
const TfArray<48, int> quant29_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant29 = { (TfLiteFloatArray*)&quant29_scale, (TfLiteIntArray*)&quant29_zero, 3 };
const ALIGN(16) int32_t tensor_data30[48] = { 48814, 11963, 6161, 9386, 2551, 14988, -1535, -24, 1259, 4305, 4136, 1596, 2489, -995, 1842, -1936, 4360, 10546, -255, 369857, 6474, 6101, 11861, -399, 6175, 12652, 28018, 10196, -667, -3592, 195, 2377, -2989, 9524, 4619, 9165, 8314, 6194, 188236, 3000, -1356, 2871, 1459, 4130, 6615, 2750, -1355, 2888, };
const TfArray<1, int> tensor_dimension30 = { 1, { 48 } };
const TfArray<48, float> quant30_scale = { 48, { 8.8383181719109416e-05, 0.00018112831457983702, 0.00023787330428604037, 0.00034974608570337296, 0.0008780520292930305, 0.00032495398772880435, 0.0012739247176796198, 0.00092401908477768302, 0.00041447821422480047, 0.00031975266756489873, 0.00054752588039264083, 0.00023059689556248486, 0.00039637633017264307, 0.00036293352604843676, 0.00027617445448413491, 0.0018351923208683729, 0.00033623771741986275, 0.00041246539331041276, 0.001600411836989224, 7.8204457167885266e-06, 0.00019114057067781687, 0.00020827069238293916, 0.00031965854577720165, 0.00085086922626942396, 0.00020159149426035583, 0.00010595581989036873, 0.00014968727191444486, 0.00035501286038197577, 0.00039648261736147106, 0.00068926130188629031, 0.00048457342199981213, 0.00032412493601441383, 0.00069183763116598129, 0.00022623538097832352, 0.00023892060562502593, 0.00022276621893979609, 0.00043996926979161799, 0.00023463775869458914, 1.378648175887065e-05, 0.0015296904603019357, 0.00052708527073264122, 0.00095220102230086923, 0.00039068504702299833, 0.0003511449322104454, 0.0001846842496888712, 0.00039337322232313454, 0.00073436694219708443, 0.00090064009418711066, } };
const TfArray<48, int> quant30_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant30 = { (TfLiteFloatArray*)&quant30_scale, (TfLiteIntArray*)&quant30_zero, 0 };
const ALIGN(16) int8_t tensor_data31[48*1*1*8] = { 
  /* [0][0][][] */ 35,29,-10,-15,127,14,-10,-19, 
  /* [1][0][][] */ -23,-99,-32,127,15,-17,65,53, 
  /* [2][0][][] */ -14,-127,-18,31,-1,-1,109,-11, 
  /* [3][0][][] */ 127,5,24,3,3,-24,16,22, 
  /* [4][0][][] */ -8,-35,112,-5,-9,-100,-42,-127, 
  /* [5][0][][] */ 17,-20,67,52,127,13,-80,75, 
  /* [6][0][][] */ 5,19,10,127,17,37,64,-62, 
  /* [7][0][][] */ 1,127,-38,-4,-16,5,11,-28, 
  /* [8][0][][] */ 127,75,-5,52,-31,-31,56,-35, 
  /* [9][0][][] */ -127,33,-91,-27,113,7,-81,20, 
  /* [10][0][][] */ -70,-30,-32,127,22,33,-72,-37, 
  /* [11][0][][] */ -126,127,-45,-121,-5,-61,-40,-40, 
  /* [12][0][][] */ 127,66,-61,49,-47,-44,-50,-71, 
  /* [13][0][][] */ 105,99,-98,41,65,127,-90,60, 
  /* [14][0][][] */ -127,-116,-70,92,39,11,44,-34, 
  /* [15][0][][] */ -1,127,-10,-10,9,-36,16,-5, 
  /* [16][0][][] */ 18,-79,6,-14,31,-127,30,66, 
  /* [17][0][][] */ 34,127,-1,33,-3,50,-97,-45, 
  /* [18][0][][] */ 22,20,-127,-14,-11,54,0,30, 
  /* [19][0][][] */ -127,36,-65,-70,-24,-2,26,48, 
  /* [20][0][][] */ -119,-17,-44,20,127,-16,-48,-8, 
  /* [21][0][][] */ -39,-27,-18,40,-127,14,20,-27, 
  /* [22][0][][] */ -108,-33,-23,-38,87,-2,24,127, 
  /* [23][0][][] */ -37,-14,-28,-8,-11,127,-100,-85, 
  /* [24][0][][] */ 33,30,-127,-9,51,77,4,107, 
  /* [25][0][][] */ 118,-85,-50,127,-88,-80,57,-9, 
  /* [26][0][][] */ -3,-27,5,-6,-9,90,127,5, 
  /* [27][0][][] */ 71,-12,-51,11,127,18,-11,10, 
  /* [28][0][][] */ -2,42,-94,-26,41,118,49,127, 
  /* [29][0][][] */ 114,60,-92,38,-33,127,-114,-103, 
  /* [30][0][][] */ 15,9,-22,-127,-6,-3,2,-30, 
  /* [31][0][][] */ -64,37,48,-20,-127,-36,-18,26, 
  /* [32][0][][] */ -59,79,-40,-127,-11,-6,-116,-36, 
  /* [33][0][][] */ -78,-20,15,12,-127,-27,25,12, 
  /* [34][0][][] */ -127,-16,-50,23,119,26,0,42, 
  /* [35][0][][] */ 28,30,-38,-6,21,-41,127,-63, 
  /* [36][0][][] */ -49,14,37,-40,-39,96,-127,-3, 
  /* [37][0][][] */ -12,-64,-49,1,-12,-110,127,-7, 
  /* [38][0][][] */ -13,-127,51,37,8,-66,-101,99, 
  /* [39][0][][] */ -12,-127,-4,54,-13,6,-64,-122, 
  /* [40][0][][] */ 104,99,-19,51,-127,-22,2,-50, 
  /* [41][0][][] */ 55,-127,60,14,39,104,-23,86, 
  /* [42][0][][] */ -16,-29,45,-127,-58,28,-16,14, 
  /* [43][0][][] */ -12,67,-3,-127,64,4,-8,-1, 
  /* [44][0][][] */ 31,91,60,3,29,87,127,-17, 
  /* [45][0][][] */ -127,-35,9,34,-26,-16,-28,-46, 
  /* [46][0][][] */ -28,15,127,80,29,-26,-26,34, 
  /* [47][0][][] */ -5,-22,-12,127,-3,8,6,-7, 
};
const TfArray<4, int> tensor_dimension31 = { 4, { 48,1,1,8 } };
const TfArray<48, float> quant31_scale = { 48, { 0.00024317909264937043, 0.00049835973186418414, 0.00065448891837149858, 0.00096229766495525837, 0.0024158882442861795, 0.00089408428175374866, 0.0035050993319600821, 0.0025423627812415361, 0.0011404028628021479, 0.00087977328803390265, 0.0015064725885167718, 0.00063446845160797238, 0.0010905970120802522, 0.00099858187604695559, 0.00075987138552591205, 0.0050493814051151276, 0.00092513056006282568, 0.0011348647531121969, 0.0044034020975232124, 2.151731496269349e-05, 0.00052590761333703995, 0.00057303975336253643, 0.00087951432215049863, 0.0023410969879478216, 0.00055466248886659741, 0.00029152876231819391, 0.00041185226291418076, 0.00097678881138563156, 0.0010908894473686814, 0.0018964459886774421, 0.0013332640519365668, 0.00089180323993787169, 0.0019035345176234841, 0.00062246812740340829, 0.00065737048862501979, 0.00061292300233617425, 0.0012105393689125776, 0.00064558658050373197, 3.7932375562377274e-05, 0.0042088180780410767, 0.0014502319972962141, 0.0026199030689895153, 0.0010749378707259893, 0.00096614647191017866, 0.00050814356654882431, 0.0010823342017829418, 0.0020205504260957241, 0.0024780374951660633, } };
const TfArray<48, int> quant31_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant31 = { (TfLiteFloatArray*)&quant31_scale, (TfLiteIntArray*)&quant31_zero, 0 };
const ALIGN(16) int32_t tensor_data32[8] = { -9241, -25571, 9087, 24532, 346, 7159, 41526, 3849, };
const TfArray<1, int> tensor_dimension32 = { 1, { 8 } };
const TfArray<8, float> quant32_scale = { 8, { 0.00063819455681368709, 0.00064773816848173738, 0.00072205881588160992, 0.00084170233458280563, 0.00070132699329406023, 0.0010559490183368325, 0.00072039908263832331, 0.00068766833283007145, } };
const TfArray<8, int> quant32_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant32 = { (TfLiteFloatArray*)&quant32_scale, (TfLiteIntArray*)&quant32_zero, 0 };
const ALIGN(16) int8_t tensor_data33[8*1*1*48] = { 
  /* [0][0][][] */ 23,-5,7,-127,36,45,-2,7,15,-5,-16,-6,99,0,-4,-17,0,15,7,0,104,23,-20,15,46,46,-22,43,-2,19,5,-121,5,17,-16,-9,-28,-11,-1,31,19,-40,-37,-8,-3,-12,-14,-15, 
  /* [1][0][][] */ -33,-36,-3,-23,11,27,-37,78,26,2,-20,-19,28,0,21,26,0,35,20,-45,7,21,127,27,-22,17,56,6,19,-15,8,4,10,-6,-15,-27,4,-40,20,19,-26,-10,-104,-20,-34,17,-28,-105, 
  /* [2][0][][] */ -24,42,13,42,6,-29,48,-5,-7,71,34,-10,-2,0,12,18,0,-27,-127,28,14,-13,32,-22,-15,-25,80,18,39,0,-3,21,11,-29,-37,7,57,16,-23,0,5,8,-1,14,32,-48,24,55, 
  /* [3][0][][] */ -8,1,12,8,12,25,7,-38,61,26,20,-4,38,0,-35,-3,0,-19,-5,16,9,-25,-13,-36,-5,-7,-17,10,-23,-29,16,-3,-14,67,-20,41,9,4,-16,-127,18,9,31,-77,16,-14,-8,38, 
  /* [4][0][][] */ -2,-16,80,26,-4,-27,4,6,8,-7,-21,-22,-91,0,-7,5,0,2,30,4,48,-7,1,41,-9,26,9,55,-3,-3,3,74,-1,31,1,5,19,-5,-22,-10,-25,-127,-10,-8,-15,16,10,-3, 
  /* [5][0][][] */ -9,54,14,-12,-9,31,27,27,-30,11,-6,57,18,0,-127,2,0,23,-48,17,-3,18,-21,33,-24,-13,16,1,-20,37,25,-20,44,22,-44,-22,-9,18,-61,24,29,-21,-32,36,-8,59,20,12, 
  /* [6][0][][] */ -43,-66,31,-1,52,-29,-14,20,16,-15,-15,103,-3,0,-127,41,0,-10,57,-17,-16,7,23,-46,22,17,1,37,49,-9,2,-8,103,-44,43,6,5,-17,-51,-26,-6,-47,22,-24,-30,-101,-31,-47, 
  /* [7][0][][] */ -78,-27,15,-1,127,6,82,31,-18,54,13,-29,-24,0,73,76,0,-5,-18,87,-9,-19,-29,31,17,26,48,26,33,61,32,-18,-21,-37,6,-15,14,31,32,54,72,-17,-16,14,80,-30,59,67, 
};
const TfArray<4, int> tensor_dimension33 = { 4, { 8,1,1,48 } };
const TfArray<8, float> quant33_scale = { 8, { 0.027123268693685532, 0.027528872713446617, 0.030687497928738594, 0.035772349685430527, 0.02980639785528183, 0.044877834618091583, 0.030616959556937218, 0.029225904494524002, } };
const TfArray<8, int> quant33_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant33 = { (TfLiteFloatArray*)&quant33_scale, (TfLiteIntArray*)&quant33_zero, 0 };
const ALIGN(16) int32_t tensor_data34[48] = { 43154, 52427, 63913, 47455, 8439, 11461, 1026, 39261, 41154, 57124, 26408, -1353, -41654, -127, 15264, -369, -204, 41320, 220, -1981, -16250, -2713, 48324, 70397, 31148, 81497, 74744, 28483, 66, 12442, -16988, -53787, 19825, 147376, 36712, 1136, 61157, 1067, 127084, -24004, 13390, -25562, -2333, 117771, -1676, 134474, 2243, -24903, };
const TfArray<1, int> tensor_dimension34 = { 1, { 48 } };
const TfArray<48, float> quant34_scale = { 48, { 0.00012611663260031492, 7.9719422501511872e-05, 0.00013527889677789062, 9.6915719041135162e-05, 8.7048458226490766e-05, 0.00012154909200035036, 0.00014854440814815462, 4.6507266233675182e-05, 5.9777736169053242e-05, 1.7254535123356618e-05, 3.3829339372459799e-05, 2.0402221707627177e-05, 0.00014147504407446831, 0.005541567225009203, 0.00014913413906469941, 0.0001643226423766464, 0.0027484172023832798, 1.0467001629876904e-05, 0.00011497351806610823, 0.00019979328499175608, 7.840266334824264e-05, 7.5108109740540385e-05, 0.000129726278828457, 1.751348827383481e-05, 2.7654145014821552e-05, 3.3067637559724972e-05, 2.1521944290725514e-05, 5.1218601583968848e-05, 0.00016942311776801944, 4.8832720494829118e-05, 2.3863100068410859e-05, 0.00018053247185889632, 0.00012702008825726807, 8.6717909653089009e-06, 5.5791264458093792e-05, 0.00028249956085346639, 1.2555421562865376e-05, 0.0003998088650405407, 3.5135482903569937e-05, 8.3907383668702096e-05, 5.3590454626828432e-05, 0.00014311319682747126, 0.00010569930600468069, 9.0269841166445985e-06, 0.00015501052257604897, 4.4783166231354699e-05, 0.00021010931232012808, 0.00012743222760036588, } };
const TfArray<48, int> quant34_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant34 = { (TfLiteFloatArray*)&quant34_scale, (TfLiteIntArray*)&quant34_zero, 0 };
const ALIGN(16) int8_t tensor_data35[1*3*3*48] = { 
  /* [0][0][][] */ -38,-20,-8,-13,-1,-41,-78,-66,-22,-40,2,69,33,-71,114,-38,-113,-88,46,-3,-8,-70,-102,-69,-42,-127,-73,-33,55,19,96,28,-127,-96,-3,38,21,42,-127,80,-75,-14,107,-105,4,-39,-91,106, 79,9,-27,-21,54,-127,-127,-74,62,-69,-124,113,34,-82,-2,66,-52,-108,54,14,2,-104,-127,-58,-9,-118,-127,-45,-66,24,-50,68,25,-127,73,67,18,67,-93,127,-127,6,124,-127,-3,-33,-127,87, -24,26,3,-7,-73,-112,-54,-9,96,-8,-127,44,7,-71,-103,-15,-127,-26,37,16,-21,-85,-43,-25,-19,-36,-64,-20,-21,19,-22,-2,98,-95,85,27,19,36,-9,21,-81,7,5,-85,-24,-9,-57,9, 
  /* [0][1][][] */ -78,-127,-44,-50,-17,61,97,-97,-23,-97,-25,114,93,-64,26,-89,-121,-89,108,-76,38,-87,-103,-127,36,-119,-79,-43,113,-60,127,80,-45,-112,-14,82,-41,-79,-117,102,41,57,117,-100,-88,-115,83,119, 127,-80,-127,-127,124,50,95,-127,110,-127,-121,127,127,-14,-8,127,-60,-127,127,-127,127,-127,-117,-112,127,-81,-127,-127,-127,-127,-62,127,25,-119,127,127,-70,-127,-102,90,61,127,127,-122,-110,-127,127,127, -44,17,-67,-99,-127,-22,35,-37,127,-32,-87,39,56,-70,-25,-46,-37,-36,66,-75,70,-89,-38,-20,43,-10,-46,-63,6,-88,-27,11,24,-117,124,20,-28,-62,-1,-16,38,59,2,-80,-57,-39,64,44, 
  /* [0][2][][] */ -53,-107,-34,-35,-10,32,0,-37,-36,-58,-6,61,71,-127,-127,-61,-43,-23,82,74,54,-42,-10,-77,40,-51,-8,-52,65,30,79,68,101,-43,-38,-2,-97,28,-18,44,8,38,24,-50,91,-80,3,29, 88,-69,-88,-75,74,19,9,-47,58,-72,-26,59,72,-26,19,88,-24,-23,77,117,92,-50,-12,-65,104,-52,-6,-77,-55,44,-41,119,-18,-54,67,13,-127,42,-13,3,12,31,16,-88,127,-99,-13,36, -23,22,-45,-53,-87,-22,28,-12,56,-17,-11,37,26,-43,116,-33,-93,-7,42,62,95,-24,1,-5,49,-8,6,-52,-22,30,-14,40,-91,-47,64,7,-28,16,29,-38,8,38,-3,-16,66,-35,-5,17, 
};
const TfArray<4, int> tensor_dimension35 = { 4, { 1,3,3,48 } };
const TfArray<48, float> quant35_scale = { 48, { 0.0053599565289914608, 0.003388075390830636, 0.0057493527419865131, 0.0041189179755747318, 0.0036995592527091503, 0.0051658363081514835, 0.0063131372444331646, 0.001976558705791831, 0.0025405536871403456, 0.00073331774910911918, 0.0014377469196915627, 0.00086709443712607026, 0.0060126893222332001, 0.23551659286022186, 0.0063382009975612164, 0.0069837123155593872, 0.1168077290058136, 0.00044484756654128432, 0.0048863743431866169, 0.0084912143647670746, 0.0033321131486445665, 0.0031920946203172207, 0.0055133667774498463, 0.0007443232461810112, 0.0011753011494874954, 0.0014053746126592159, 0.00091468263417482376, 0.0021767904981970787, 0.0072004823014140129, 0.0020753906574100256, 0.0010141817620024085, 0.0076726297847926617, 0.0053983535617589951, 0.00036855111829936504, 0.002371128648519516, 0.012006230652332306, 0.00053360540186986327, 0.016991876065731049, 0.0014932580525055528, 0.0035660637076944113, 0.0022775942925363779, 0.0060823108069598675, 0.0044922204688191414, 0.00038364680949598551, 0.0065879472531378269, 0.0019032844575121999, 0.0089296456426382065, 0.0054158694110810757, } };
const TfArray<48, int> quant35_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant35 = { (TfLiteFloatArray*)&quant35_scale, (TfLiteIntArray*)&quant35_zero, 3 };
const ALIGN(16) int32_t tensor_data36[48] = { 6573, 330, 11950, 11169, 8522, 4685, 11319, -228, -53, -214, 2105, 322, 11501, -90351008, 8276, 39809, -72936016, -83, -1394, 20273, 4587, -37, 370, 174, 4313, -583, 105, 1397, 5422, 2035, 1904, 15180, 3231, 359, 63, -2928, 584, 6224, -259, 17640, 2153, 14529, 194, -116, 14042, 466, 22140, 9859, };
const TfArray<1, int> tensor_dimension36 = { 1, { 48 } };
const TfArray<48, float> quant36_scale = { 48, { 0.00033336272463202477, 0.00049137376481667161, 0.00027174034039489925, 0.00017045279673766345, 0.00023927705478854477, 0.00034515833249315619, 0.00033590046223253012, 0.00075165735324844718, 0.00046681668027304113, 0.0036940732970833778, 0.0006763467681594193, 0.0026863114908337593, 0.00017783907242119312, 1.7950397834809451e-09, 0.00033666868694126606, 8.5855746874585748e-05, 1.7950397834809451e-09, 0.007650772575289011, 0.00042681486229412258, 0.00018777177319861948, 0.00025971737341023982, 0.0055057969875633717, 0.00022028955572750419, 0.0030649472028017044, 0.00088517519179731607, 0.0010172768961638212, 0.0014733477728441358, 0.0010113493772223592, 0.00019116350449621677, 0.0014365016249939799, 0.0016157140489667654, 0.00016015503206290305, 0.00022803863976150751, 0.0091178510338068008, 0.00052429590141400695, 0.00042085460154339671, 0.0029813416767865419, 0.00020579344709403813, 0.0023170032072812319, 0.00018514943076297641, 0.0013422862393781543, 0.0001520909572718665, 0.00030052117654122412, 0.0084111243486404419, 0.00035791620030067861, 0.00076073390664532781, 0.00012481710291467607, 0.00010783423203974962, } };
const TfArray<48, int> quant36_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant36 = { (TfLiteFloatArray*)&quant36_scale, (TfLiteIntArray*)&quant36_zero, 0 };
const ALIGN(16) int8_t tensor_data37[48*1*1*8] = { 
  /* [0][0][][] */ 8,-127,37,-39,42,-15,-31,31, 
  /* [1][0][][] */ 69,33,4,-127,-17,-12,-34,79, 
  /* [2][0][][] */ 5,26,-53,127,26,113,35,68, 
  /* [3][0][][] */ 99,120,-108,127,-67,-27,-10,46, 
  /* [4][0][][] */ 19,-127,59,-5,-5,32,-43,-58, 
  /* [5][0][][] */ 13,49,-5,62,42,-43,18,127, 
  /* [6][0][][] */ 43,18,-127,-97,127,0,0,-96, 
  /* [7][0][][] */ 122,3,31,0,25,11,127,-80, 
  /* [8][0][][] */ -13,-55,17,81,-11,4,-17,-127, 
  /* [9][0][][] */ 76,-127,-12,-11,2,19,-116,80, 
  /* [10][0][][] */ -56,-60,-127,-7,-55,-13,-76,27, 
  /* [11][0][][] */ -22,-25,-10,-67,-127,-20,24,-17, 
  /* [12][0][][] */ 6,20,-79,49,-55,-6,49,127, 
  /* [13][0][][] */ 0,0,0,0,0,0,0,0, 
  /* [14][0][][] */ -29,-48,-64,53,58,127,29,55, 
  /* [15][0][][] */ 110,-20,2,-65,103,38,-48,127, 
  /* [16][0][][] */ 0,0,0,0,0,0,0,0, 
  /* [17][0][][] */ 3,6,127,-9,-44,18,26,28, 
  /* [18][0][][] */ 68,-127,18,35,2,20,-28,-51, 
  /* [19][0][][] */ -101,-18,12,87,-62,-31,-102,127, 
  /* [20][0][][] */ 69,2,-19,98,16,-127,-1,31, 
  /* [21][0][][] */ 21,14,127,-4,-12,5,51,19, 
  /* [22][0][][] */ -110,-40,-106,21,15,24,-127,-28, 
  /* [23][0][][] */ -42,69,13,-5,1,18,127,-25, 
  /* [24][0][][] */ 4,-6,-23,103,-14,-87,127,107, 
  /* [25][0][][] */ 30,26,50,7,75,127,33,-24, 
  /* [26][0][][] */ -127,-80,-112,-4,-1,50,-79,-26, 
  /* [27][0][][] */ -16,-30,-75,70,-49,127,41,25, 
  /* [28][0][][] */ 20,-1,-51,12,-27,127,54,81, 
  /* [29][0][][] */ 86,-50,127,-26,-70,78,98,65, 
  /* [30][0][][] */ -38,127,13,-28,31,-2,114,-4, 
  /* [31][0][][] */ -36,-127,-6,17,19,-23,85,106, 
  /* [32][0][][] */ -14,33,-45,49,16,16,9,127, 
  /* [33][0][][] */ 23,46,-3,-127,12,-19,20,71, 
  /* [34][0][][] */ -30,56,-18,-127,1,-8,20,71, 
  /* [35][0][][] */ 62,43,3,-127,11,29,76,-14, 
  /* [36][0][][] */ -127,12,-52,70,-37,45,-43,64, 
  /* [37][0][][] */ 2,2,10,27,-20,127,100,53, 
  /* [38][0][][] */ 1,-12,-8,80,127,11,-42,43, 
  /* [39][0][][] */ 14,-1,22,-127,49,-21,-73,107, 
  /* [40][0][][] */ 49,2,127,0,-10,1,64,-20, 
  /* [41][0][][] */ 6,-33,5,87,17,127,108,74, 
  /* [42][0][][] */ -127,-52,120,43,-45,43,-24,7, 
  /* [43][0][][] */ -12,-8,1,77,-33,-27,17,-127, 
  /* [44][0][][] */ 101,22,0,-84,79,-45,34,-127, 
  /* [45][0][][] */ -36,127,23,-1,1,-13,53,-55, 
  /* [46][0][][] */ -127,-54,8,-8,-38,31,-67,-15, 
  /* [47][0][][] */ 45,83,127,11,66,-6,119,-84, 
};
const TfArray<4, int> tensor_dimension37 = { 4, { 48,1,1,8 } };
const TfArray<48, float> quant37_scale = { 48, { 0.0007311546360142529, 0.0010777156567201018, 0.00059600011445581913, 0.00037384909228421748, 0.00052479933947324753, 0.00075702561298385262, 0.00073672062717378139, 0.0016485879896208644, 0.0010238552931696177, 0.00810210220515728, 0.0014834115281701088, 0.0058918078429996967, 0.00039004921563901007, 3.937008052901092e-09, 0.00073840550612658262, 0.0001883048826130107, 3.937008052901092e-09, 0.016780214384198189, 0.00093612045748159289, 0.00041183430585078895, 0.00056963047245517373, 0.012075702659785748, 0.00048315461026504636, 0.0067222584038972855, 0.0019414287526160479, 0.0022311634384095669, 0.0032314502168446779, 0.0022181628737598658, 0.000419273303123191, 0.0031506367959082127, 0.0035436979960650206, 0.0003512633265927434, 0.00050015043234452605, 0.019997915253043175, 0.0011499227257445455, 0.00092304800637066364, 0.006538888905197382, 0.00045136071275919676, 0.0050818151794373989, 0.00040608280687592924, 0.0029439970385283232, 0.0003335766086820513, 0.00065912422724068165, 0.018447872251272202, 0.00078500708332285285, 0.0016684952424839139, 0.00027375767240300775, 0.00023650964430999011, } };
const TfArray<48, int> quant37_zero = { 48, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant37 = { (TfLiteFloatArray*)&quant37_scale, (TfLiteIntArray*)&quant37_zero, 0 };
const ALIGN(16) int32_t tensor_data38[8] = { 651, -41655, -2373, -7696, -22040, -2727, -29052, -15075, };
const TfArray<1, int> tensor_dimension38 = { 1, { 8 } };
const TfArray<8, float> quant38_scale = { 8, { 0.0014072773046791553, 0.0013445117510855198, 0.0016341489972546697, 0.0011376456823199987, 0.0013187512522563338, 0.0020919735543429852, 0.0014546529855579138, 0.0011172650847584009, } };
const TfArray<8, int> quant38_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant38 = { (TfLiteFloatArray*)&quant38_scale, (TfLiteIntArray*)&quant38_zero, 0 };
const ALIGN(16) int8_t tensor_data39[8*1*1*16] = { 
  /* [0][0][][] */ 0,13,-12,9,117,-3,-4,-10,11,-127,-77,9,0,100,-10,0, 
  /* [1][0][][] */ 0,-1,-23,120,82,-24,30,-15,-12,-32,127,-51,0,43,-10,0, 
  /* [2][0][][] */ 0,11,16,-19,-92,-7,0,7,-9,-9,-15,-10,0,127,-10,0, 
  /* [3][0][][] */ 0,-47,-27,-127,97,14,74,4,14,67,5,58,0,1,12,0, 
  /* [4][0][][] */ 0,60,-37,23,-76,-3,127,-11,-13,-76,-6,3,0,3,43,0, 
  /* [5][0][][] */ 0,-36,-16,-8,-13,-16,-15,19,5,16,-1,-25,0,-7,127,0, 
  /* [6][0][][] */ 0,-11,-15,11,68,-24,-9,-9,-11,-45,100,57,0,127,57,0, 
  /* [7][0][][] */ 0,5,-39,127,2,-12,23,-20,-14,62,-79,106,0,-32,62,0, 
};
const TfArray<4, int> tensor_dimension39 = { 4, { 8,1,1,16 } };
const TfArray<8, float> quant39_scale = { 8, { 0.059809286147356033, 0.057141747325658798, 0.069451332092285156, 0.04834994301199913, 0.056046925485134125, 0.088908873498439789, 0.061822749674320221, 0.047483764588832855, } };
const TfArray<8, int> quant39_zero = { 8, { 0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant39 = { (TfLiteFloatArray*)&quant39_scale, (TfLiteIntArray*)&quant39_zero, 0 };
const ALIGN(16) int32_t tensor_data40[16] = { -161, 17120, 22491, 10236, 3954, 99133, 9879, 110744, -29716, 6126, 28045, 18340, -445, 31040, 5789, -107, };
const TfArray<1, int> tensor_dimension40 = { 1, { 16 } };
const TfArray<16, float> quant40_scale = { 16, { 0.0018688903655856848, 0.00015592330601066351, 0.00018449734488967806, 0.0003603002114687115, 0.00035436174948699772, 3.3384516427759081e-05, 0.0004765629128087312, 3.5068576835328713e-05, 1.3205092727730516e-05, 0.00024898743140511215, 0.00021860045671928674, 0.0011851477902382612, 0.00072724185883998871, 0.00020255922572687268, 0.00028597633354365826, 0.003907486330717802, } };
const TfArray<16, int> quant40_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant40 = { (TfLiteFloatArray*)&quant40_scale, (TfLiteIntArray*)&quant40_zero, 0 };
const ALIGN(16) int8_t tensor_data41[1*3*3*16] = { 
  /* [0][0][][] */ -108,19,-82,-126,38,-65,80,-76,-90,-2,-8,28,-127,4,54,-73, 51,25,-127,127,127,-127,127,-127,-85,127,-127,49,-105,5,127,-25, 24,-24,96,-2,-72,73,-94,76,-95,-26,4,-15,61,1,-99,-29, 
  /* [0][1][][] */ -127,127,-17,13,-44,19,-28,14,-28,1,2,-107,-49,8,-28,-14, -78,-40,-55,-14,-7,-22,8,-28,-108,-88,21,-12,-104,-127,2,23, 14,1,70,2,3,39,-25,32,-127,7,-1,2,-21,10,-3,43, 
  /* [0][2][][] */ -115,-70,81,2,-7,43,-39,51,-76,1,-1,3,40,1,-26,23, 23,-3,38,-2,-27,45,-34,20,-125,-12,0,82,-58,-1,-27,-111, 21,-6,23,0,4,20,9,22,-115,6,0,-127,107,1,18,-127, 
};
const TfArray<4, int> tensor_dimension41 = { 4, { 1,3,3,16 } };
const TfArray<16, float> quant41_scale = { 16, { 0.079427838325500488, 0.0066267400979995728, 0.0078411372378468513, 0.015312759205698967, 0.015060373581945896, 0.0014188418863341212, 0.020253922790288925, 0.0014904144918546081, 0.00056121643865481019, 0.010581965558230877, 0.0092905191704630852, 0.0503687784075737, 0.030907778069376945, 0.0086087668314576149, 0.012153994292020798, 0.16606816649436951, } };
const TfArray<16, int> quant41_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant41 = { (TfLiteFloatArray*)&quant41_scale, (TfLiteIntArray*)&quant41_zero, 3 };
const ALIGN(16) int32_t tensor_data42[16] = { -1073741824, 37899, -262747, 59012, 244422, 36741, 161302, 16419, -83925, 32437, 105989, 3143056, -1073741824, 27786, 84186, -1073741824, };
const TfArray<1, int> tensor_dimension42 = { 1, { 16 } };
const TfArray<16, float> quant42_scale = { 16, { 1.3102037232926023e-09, 0.0001036858739098534, 6.6675740526989102e-05, 1.790369424270466e-05, 1.0382150321674999e-05, 0.00010902249778155237, 2.0166913600405678e-05, 0.00012555009743664414, 1.043383963406086e-05, 8.5343403043225408e-05, 3.5478420613799244e-05, 1.8323696622246644e-06, 1.1533876076441629e-09, 0.00011874114716192707, 3.6200010072207078e-05, 1.243374708748135e-10, } };
const TfArray<16, int> quant42_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant42 = { (TfLiteFloatArray*)&quant42_scale, (TfLiteIntArray*)&quant42_zero, 0 };
const ALIGN(16) int8_t tensor_data43[16*3*3*3] = { 
  /* [0][0][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [0][1][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [0][2][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [1][0][][] */ 30,-11,16, -16,-22,5, -127,-105,-63, 
  /* [1][1][][] */ -14,-17,-8, -34,-10,-11, -27,-36,-4, 
  /* [1][2][][] */ -20,2,-12, -22,-7,-12, 3,-26,-1, 
  /* [2][0][][] */ 82,52,46, 81,125,27, 24,-15,7, 
  /* [2][1][][] */ 71,63,44, 86,127,1, 16,19,6, 
  /* [2][2][][] */ 85,-4,59, 76,-11,9, 42,-11,36, 
  /* [3][0][][] */ 29,36,72, 30,65,46, -5,-1,14, 
  /* [3][1][][] */ 43,54,89, 80,127,72, -24,-21,26, 
  /* [3][2][][] */ 40,45,104, 39,33,53, -12,4,23, 
  /* [4][0][][] */ -8,22,-7, -7,36,-3, 50,21,41, 
  /* [4][1][][] */ 14,35,37, 36,88,57, 126,94,53, 
  /* [4][2][][] */ 27,52,35, 50,112,39, 77,127,96, 
  /* [5][0][][] */ -4,-15,-119, -21,-23,-110, -34,-11,-60, 
  /* [5][1][][] */ -14,-55,-127, -24,-48,-91, -35,-21,-46, 
  /* [5][2][][] */ -28,-19,-30, -23,-9,-1, -32,-14,-2, 
  /* [6][0][][] */ 36,-58,42, 65,-75,48, 36,-7,19, 
  /* [6][1][][] */ 34,-104,54, 68,-127,69, 17,-29,16, 
  /* [6][2][][] */ 17,-44,5, 20,-47,25, -9,3,-5, 
  /* [7][0][][] */ -5,-25,-27, -114,-83,-39, -23,-7,-33, 
  /* [7][1][][] */ 21,-35,-38, -97,-127,-65, 6,-38,-33, 
  /* [7][2][][] */ -19,15,-56, -10,-7,-60, -32,4,-39, 
  /* [8][0][][] */ -116,116,127, -110,115,127, -100,114,126, 
  /* [8][1][][] */ -119,108,122, -114,107,122, -104,104,120, 
  /* [8][2][][] */ -116,120,126, -107,120,127, -98,117,125, 
  /* [9][0][][] */ 10,21,-3, 7,13,-11, 21,24,-16, 
  /* [9][1][][] */ 94,127,-22, 56,116,-6, -21,17,-7, 
  /* [9][2][][] */ -43,-6,-13, -35,-26,-43, -35,-2,-56, 
  /* [10][0][][] */ -38,-81,-23, 20,94,15, -21,-12,-7, 
  /* [10][1][][] */ -72,-99,-18, 64,127,10, -29,-24,-5, 
  /* [10][2][][] */ -45,-16,-2, 23,25,-15, -20,1,3, 
  /* [11][0][][] */ -108,-75,-44, -88,-84,-36, -51,-112,-64, 
  /* [11][1][][] */ -127,-95,-66, -117,-104,-73, -72,-90,-72, 
  /* [11][2][][] */ -9,-30,-55, 73,80,41, -26,9,-26, 
  /* [12][0][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [12][1][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [12][2][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [13][0][][] */ -50,-76,-18, -61,-89,-26, -13,-5,-8, 
  /* [13][1][][] */ 51,116,12, 46,127,19, 2,26,7, 
  /* [13][2][][] */ -11,-4,1, -4,-5,-4, -4,15,-6, 
  /* [14][0][][] */ 48,2,-41, 81,-14,-53, 27,0,-38, 
  /* [14][1][][] */ 90,-11,-78, 127,-32,-95, 46,-20,-64, 
  /* [14][2][][] */ 51,-15,-61, 70,-21,-71, 14,-10,-49, 
  /* [15][0][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [15][1][][] */ 0,0,0, 0,0,0, 0,0,0, 
  /* [15][2][][] */ 0,0,0, 0,0,0, 0,0,0, 
};
const TfArray<4, int> tensor_dimension43 = { 4, { 16,3,3,3 } };
const TfArray<16, float> quant43_scale = { 16, { 3.3410194077987398e-07, 0.02643989585340023, 0.01700231246650219, 0.0045654419809579849, 0.0026474480982869864, 0.027800735086202621, 0.0051425625570118427, 0.032015271484851837, 0.0026606288738548756, 0.021762566640973091, 0.0090469969436526299, 0.00046725422726012766, 2.9411381774480105e-07, 0.030278990045189857, 0.0092310020700097084, 3.1706054670621597e-08, } };
const TfArray<16, int> quant43_zero = { 16, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } };
const TfLiteAffineQuantization quant43 = { (TfLiteFloatArray*)&quant43_scale, (TfLiteIntArray*)&quant43_zero, 0 };
const TfArray<4, int> tensor_dimension44 = { 4, { 1,120,120,16 } };
const TfArray<1, float> quant44_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant44_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant44 = { (TfLiteFloatArray*)&quant44_scale, (TfLiteIntArray*)&quant44_zero, 0 };
const TfArray<4, int> tensor_dimension45 = { 4, { 1,120,120,16 } };
const TfArray<1, float> quant45_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant45_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant45 = { (TfLiteFloatArray*)&quant45_scale, (TfLiteIntArray*)&quant45_zero, 0 };
const TfArray<4, int> tensor_dimension46 = { 4, { 1,120,120,8 } };
const TfArray<1, float> quant46_scale = { 1, { 0.45594009757041931, } };
const TfArray<1, int> quant46_zero = { 1, { -13 } };
const TfLiteAffineQuantization quant46 = { (TfLiteFloatArray*)&quant46_scale, (TfLiteIntArray*)&quant46_zero, 0 };
const TfArray<4, int> tensor_dimension47 = { 4, { 1,120,120,48 } };
const TfArray<1, float> quant47_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant47_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant47 = { (TfLiteFloatArray*)&quant47_scale, (TfLiteIntArray*)&quant47_zero, 0 };
const TfArray<4, int> tensor_dimension48 = { 4, { 1,121,121,48 } };
const TfArray<1, float> quant48_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant48_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant48 = { (TfLiteFloatArray*)&quant48_scale, (TfLiteIntArray*)&quant48_zero, 0 };
const TfArray<4, int> tensor_dimension49 = { 4, { 1,60,60,48 } };
const TfArray<1, float> quant49_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant49_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant49 = { (TfLiteFloatArray*)&quant49_scale, (TfLiteIntArray*)&quant49_zero, 0 };
const TfArray<4, int> tensor_dimension50 = { 4, { 1,60,60,8 } };
const TfArray<1, float> quant50_scale = { 1, { 0.36344894766807556, } };
const TfArray<1, int> quant50_zero = { 1, { 13 } };
const TfLiteAffineQuantization quant50 = { (TfLiteFloatArray*)&quant50_scale, (TfLiteIntArray*)&quant50_zero, 0 };
const TfArray<4, int> tensor_dimension51 = { 4, { 1,60,60,48 } };
const TfArray<1, float> quant51_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant51_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant51 = { (TfLiteFloatArray*)&quant51_scale, (TfLiteIntArray*)&quant51_zero, 0 };
const TfArray<4, int> tensor_dimension52 = { 4, { 1,60,60,48 } };
const TfArray<1, float> quant52_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant52_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant52 = { (TfLiteFloatArray*)&quant52_scale, (TfLiteIntArray*)&quant52_zero, 0 };
const TfArray<4, int> tensor_dimension53 = { 4, { 1,60,60,8 } };
const TfArray<1, float> quant53_scale = { 1, { 0.40848413109779358, } };
const TfArray<1, int> quant53_zero = { 1, { 6 } };
const TfLiteAffineQuantization quant53 = { (TfLiteFloatArray*)&quant53_scale, (TfLiteIntArray*)&quant53_zero, 0 };
const TfArray<4, int> tensor_dimension54 = { 4, { 1,60,60,8 } };
const TfArray<1, float> quant54_scale = { 1, { 0.51242327690124512, } };
const TfArray<1, int> quant54_zero = { 1, { 1 } };
const TfLiteAffineQuantization quant54 = { (TfLiteFloatArray*)&quant54_scale, (TfLiteIntArray*)&quant54_zero, 0 };
const TfArray<4, int> tensor_dimension55 = { 4, { 1,60,60,48 } };
const TfArray<1, float> quant55_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant55_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant55 = { (TfLiteFloatArray*)&quant55_scale, (TfLiteIntArray*)&quant55_zero, 0 };
const TfArray<4, int> tensor_dimension56 = { 4, { 1,61,61,48 } };
const TfArray<1, float> quant56_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant56_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant56 = { (TfLiteFloatArray*)&quant56_scale, (TfLiteIntArray*)&quant56_zero, 0 };
const TfArray<4, int> tensor_dimension57 = { 4, { 1,30,30,48 } };
const TfArray<1, float> quant57_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant57_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant57 = { (TfLiteFloatArray*)&quant57_scale, (TfLiteIntArray*)&quant57_zero, 0 };
const TfArray<4, int> tensor_dimension58 = { 4, { 1,30,30,16 } };
const TfArray<1, float> quant58_scale = { 1, { 0.25837251543998718, } };
const TfArray<1, int> quant58_zero = { 1, { 17 } };
const TfLiteAffineQuantization quant58 = { (TfLiteFloatArray*)&quant58_scale, (TfLiteIntArray*)&quant58_zero, 0 };
const TfArray<4, int> tensor_dimension59 = { 4, { 1,30,30,96 } };
const TfArray<1, float> quant59_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant59_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant59 = { (TfLiteFloatArray*)&quant59_scale, (TfLiteIntArray*)&quant59_zero, 0 };
const TfArray<4, int> tensor_dimension60 = { 4, { 1,30,30,96 } };
const TfArray<1, float> quant60_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant60_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant60 = { (TfLiteFloatArray*)&quant60_scale, (TfLiteIntArray*)&quant60_zero, 0 };
const TfArray<4, int> tensor_dimension61 = { 4, { 1,30,30,16 } };
const TfArray<1, float> quant61_scale = { 1, { 0.21446788311004639, } };
const TfArray<1, int> quant61_zero = { 1, { -23 } };
const TfLiteAffineQuantization quant61 = { (TfLiteFloatArray*)&quant61_scale, (TfLiteIntArray*)&quant61_zero, 0 };
const TfArray<4, int> tensor_dimension62 = { 4, { 1,30,30,16 } };
const TfArray<1, float> quant62_scale = { 1, { 0.32712161540985107, } };
const TfArray<1, int> quant62_zero = { 1, { 10 } };
const TfLiteAffineQuantization quant62 = { (TfLiteFloatArray*)&quant62_scale, (TfLiteIntArray*)&quant62_zero, 0 };
const TfArray<4, int> tensor_dimension63 = { 4, { 1,30,30,96 } };
const TfArray<1, float> quant63_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant63_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant63 = { (TfLiteFloatArray*)&quant63_scale, (TfLiteIntArray*)&quant63_zero, 0 };
const TfArray<4, int> tensor_dimension64 = { 4, { 1,30,30,96 } };
const TfArray<1, float> quant64_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant64_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant64 = { (TfLiteFloatArray*)&quant64_scale, (TfLiteIntArray*)&quant64_zero, 0 };
const TfArray<4, int> tensor_dimension65 = { 4, { 1,30,30,16 } };
const TfArray<1, float> quant65_scale = { 1, { 0.24775053560733795, } };
const TfArray<1, int> quant65_zero = { 1, { 8 } };
const TfLiteAffineQuantization quant65 = { (TfLiteFloatArray*)&quant65_scale, (TfLiteIntArray*)&quant65_zero, 0 };
const TfArray<4, int> tensor_dimension66 = { 4, { 1,30,30,16 } };
const TfArray<1, float> quant66_scale = { 1, { 0.43271598219871521, } };
const TfArray<1, int> quant66_zero = { 1, { -12 } };
const TfLiteAffineQuantization quant66 = { (TfLiteFloatArray*)&quant66_scale, (TfLiteIntArray*)&quant66_zero, 0 };
const TfArray<4, int> tensor_dimension67 = { 4, { 1,30,30,96 } };
const TfArray<1, float> quant67_scale = { 1, { 0.023529412224888802, } };
const TfArray<1, int> quant67_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant67 = { (TfLiteFloatArray*)&quant67_scale, (TfLiteIntArray*)&quant67_zero, 0 };
const TfArray<4, int> tensor_dimension68 = { 4, { 1,30,30,32 } };
const TfArray<1, float> quant68_scale = { 1, { 0.072116509079933167, } };
const TfArray<1, int> quant68_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant68 = { (TfLiteFloatArray*)&quant68_scale, (TfLiteIntArray*)&quant68_zero, 0 };
const TfArray<4, int> tensor_dimension69 = { 4, { 1,30,30,4 } };
const TfArray<1, float> quant69_scale = { 1, { 0.12796272337436676, } };
const TfArray<1, int> quant69_zero = { 1, { 0 } };
const TfLiteAffineQuantization quant69 = { (TfLiteFloatArray*)&quant69_scale, (TfLiteIntArray*)&quant69_zero, 0 };
const TfArray<4, int> tensor_dimension70 = { 4, { 1,30,30,4 } };
const TfArray<1, float> quant70_scale = { 1, { 0.00390625, } };
const TfArray<1, int> quant70_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant70 = { (TfLiteFloatArray*)&quant70_scale, (TfLiteIntArray*)&quant70_zero, 0 };
const TfLiteConvParams opdata0 = { kTfLitePaddingSame, 2,2, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs0 = { 3, { 0,43,42 } };
const TfArray<1, int> outputs0 = { 1, { 44 } };
const TfLiteDepthwiseConvParams opdata1 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs1 = { 3, { 44,41,40 } };
const TfArray<1, int> outputs1 = { 1, { 45 } };
const TfLiteConvParams opdata2 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs2 = { 3, { 45,39,38 } };
const TfArray<1, int> outputs2 = { 1, { 46 } };
const TfLiteConvParams opdata3 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs3 = { 3, { 46,37,36 } };
const TfArray<1, int> outputs3 = { 1, { 47 } };
const TfArray<2, int> inputs4 = { 2, { 47,1 } };
const TfArray<1, int> outputs4 = { 1, { 48 } };
const TfLiteDepthwiseConvParams opdata5 = { kTfLitePaddingValid, 2,2, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs5 = { 3, { 48,35,34 } };
const TfArray<1, int> outputs5 = { 1, { 49 } };
const TfLiteConvParams opdata6 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs6 = { 3, { 49,33,32 } };
const TfArray<1, int> outputs6 = { 1, { 50 } };
const TfLiteConvParams opdata7 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs7 = { 3, { 50,31,30 } };
const TfArray<1, int> outputs7 = { 1, { 51 } };
const TfLiteDepthwiseConvParams opdata8 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs8 = { 3, { 51,29,28 } };
const TfArray<1, int> outputs8 = { 1, { 52 } };
const TfLiteConvParams opdata9 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs9 = { 3, { 52,27,26 } };
const TfArray<1, int> outputs9 = { 1, { 53 } };
const TfLiteAddParams opdata10 = { kTfLiteActNone };
const TfArray<2, int> inputs10 = { 2, { 50,53 } };
const TfArray<1, int> outputs10 = { 1, { 54 } };
const TfLiteConvParams opdata11 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs11 = { 3, { 54,25,24 } };
const TfArray<1, int> outputs11 = { 1, { 55 } };
const TfArray<2, int> inputs12 = { 2, { 55,1 } };
const TfArray<1, int> outputs12 = { 1, { 56 } };
const TfLiteDepthwiseConvParams opdata13 = { kTfLitePaddingValid, 2,2, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs13 = { 3, { 56,23,22 } };
const TfArray<1, int> outputs13 = { 1, { 57 } };
const TfLiteConvParams opdata14 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs14 = { 3, { 57,21,20 } };
const TfArray<1, int> outputs14 = { 1, { 58 } };
const TfLiteConvParams opdata15 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs15 = { 3, { 58,19,18 } };
const TfArray<1, int> outputs15 = { 1, { 59 } };
const TfLiteDepthwiseConvParams opdata16 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs16 = { 3, { 59,17,16 } };
const TfArray<1, int> outputs16 = { 1, { 60 } };
const TfLiteConvParams opdata17 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs17 = { 3, { 60,15,14 } };
const TfArray<1, int> outputs17 = { 1, { 61 } };
const TfLiteAddParams opdata18 = { kTfLiteActNone };
const TfArray<2, int> inputs18 = { 2, { 58,61 } };
const TfArray<1, int> outputs18 = { 1, { 62 } };
const TfLiteConvParams opdata19 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs19 = { 3, { 62,13,12 } };
const TfArray<1, int> outputs19 = { 1, { 63 } };
const TfLiteDepthwiseConvParams opdata20 = { kTfLitePaddingSame, 1,1, 1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs20 = { 3, { 63,11,10 } };
const TfArray<1, int> outputs20 = { 1, { 64 } };
const TfLiteConvParams opdata21 = { kTfLitePaddingSame, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs21 = { 3, { 64,9,8 } };
const TfArray<1, int> outputs21 = { 1, { 65 } };
const TfLiteAddParams opdata22 = { kTfLiteActNone };
const TfArray<2, int> inputs22 = { 2, { 62,65 } };
const TfArray<1, int> outputs22 = { 1, { 66 } };
const TfLiteConvParams opdata23 = { kTfLitePaddingSame, 1,1, kTfLiteActRelu6, 1,1 };
const TfArray<3, int> inputs23 = { 3, { 66,7,6 } };
const TfArray<1, int> outputs23 = { 1, { 67 } };
const TfLiteConvParams opdata24 = { kTfLitePaddingValid, 1,1, kTfLiteActRelu, 1,1 };
const TfArray<3, int> inputs24 = { 3, { 67,5,4 } };
const TfArray<1, int> outputs24 = { 1, { 68 } };
const TfLiteConvParams opdata25 = { kTfLitePaddingValid, 1,1, kTfLiteActNone, 1,1 };
const TfArray<3, int> inputs25 = { 3, { 68,3,2 } };
const TfArray<1, int> outputs25 = { 1, { 69 } };
const TfLiteSoftmaxParams opdata26 = { 1 };
const TfArray<1, int> inputs26 = { 1, { 69 } };
const TfArray<1, int> outputs26 = { 1, { 70 } };
const TensorInfo_t tensorData[] = {
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension0, 172800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant0))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data1, (TfLiteIntArray*)&tensor_dimension1, 32, {kTfLiteNoQuantization, nullptr}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data2, (TfLiteIntArray*)&tensor_dimension2, 16, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant2))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data3, (TfLiteIntArray*)&tensor_dimension3, 128, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant3))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data4, (TfLiteIntArray*)&tensor_dimension4, 128, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant4))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data5, (TfLiteIntArray*)&tensor_dimension5, 3072, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant5))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data6, (TfLiteIntArray*)&tensor_dimension6, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant6))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data7, (TfLiteIntArray*)&tensor_dimension7, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant7))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data8, (TfLiteIntArray*)&tensor_dimension8, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant8))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data9, (TfLiteIntArray*)&tensor_dimension9, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant9))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data10, (TfLiteIntArray*)&tensor_dimension10, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant10))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data11, (TfLiteIntArray*)&tensor_dimension11, 864, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant11))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data12, (TfLiteIntArray*)&tensor_dimension12, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant12))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data13, (TfLiteIntArray*)&tensor_dimension13, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant13))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data14, (TfLiteIntArray*)&tensor_dimension14, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant14))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data15, (TfLiteIntArray*)&tensor_dimension15, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant15))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data16, (TfLiteIntArray*)&tensor_dimension16, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant16))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data17, (TfLiteIntArray*)&tensor_dimension17, 864, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant17))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data18, (TfLiteIntArray*)&tensor_dimension18, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant18))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data19, (TfLiteIntArray*)&tensor_dimension19, 1536, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant19))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data20, (TfLiteIntArray*)&tensor_dimension20, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant20))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data21, (TfLiteIntArray*)&tensor_dimension21, 768, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant21))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data22, (TfLiteIntArray*)&tensor_dimension22, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant22))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data23, (TfLiteIntArray*)&tensor_dimension23, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant23))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data24, (TfLiteIntArray*)&tensor_dimension24, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant24))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data25, (TfLiteIntArray*)&tensor_dimension25, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant25))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data26, (TfLiteIntArray*)&tensor_dimension26, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant26))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data27, (TfLiteIntArray*)&tensor_dimension27, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant27))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data28, (TfLiteIntArray*)&tensor_dimension28, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant28))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data29, (TfLiteIntArray*)&tensor_dimension29, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant29))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data30, (TfLiteIntArray*)&tensor_dimension30, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant30))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data31, (TfLiteIntArray*)&tensor_dimension31, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant31))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data32, (TfLiteIntArray*)&tensor_dimension32, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant32))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data33, (TfLiteIntArray*)&tensor_dimension33, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant33))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data34, (TfLiteIntArray*)&tensor_dimension34, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant34))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data35, (TfLiteIntArray*)&tensor_dimension35, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant35))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data36, (TfLiteIntArray*)&tensor_dimension36, 192, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant36))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data37, (TfLiteIntArray*)&tensor_dimension37, 384, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant37))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data38, (TfLiteIntArray*)&tensor_dimension38, 32, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant38))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data39, (TfLiteIntArray*)&tensor_dimension39, 128, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant39))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data40, (TfLiteIntArray*)&tensor_dimension40, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant40))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data41, (TfLiteIntArray*)&tensor_dimension41, 144, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant41))}, },
  { kTfLiteMmapRo, kTfLiteInt32, (void*)tensor_data42, (TfLiteIntArray*)&tensor_dimension42, 64, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant42))}, },
  { kTfLiteMmapRo, kTfLiteInt8, (void*)tensor_data43, (TfLiteIntArray*)&tensor_dimension43, 432, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant43))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 230400, (TfLiteIntArray*)&tensor_dimension44, 230400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant44))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension45, 230400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant45))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 230400, (TfLiteIntArray*)&tensor_dimension46, 115200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant46))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 702768, (TfLiteIntArray*)&tensor_dimension47, 691200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant47))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension48, 702768, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant48))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 702768, (TfLiteIntArray*)&tensor_dimension49, 172800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant49))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 345600, (TfLiteIntArray*)&tensor_dimension50, 28800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant50))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 172800, (TfLiteIntArray*)&tensor_dimension51, 172800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant51))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension52, 172800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant52))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 172800, (TfLiteIntArray*)&tensor_dimension53, 28800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant53))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension54, 28800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant54))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 178608, (TfLiteIntArray*)&tensor_dimension55, 172800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant55))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension56, 178608, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant56))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 178608, (TfLiteIntArray*)&tensor_dimension57, 43200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant57))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 221808, (TfLiteIntArray*)&tensor_dimension58, 14400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant58))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 86400, (TfLiteIntArray*)&tensor_dimension59, 86400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant59))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension60, 86400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant60))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 86400, (TfLiteIntArray*)&tensor_dimension61, 14400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant61))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 172800, (TfLiteIntArray*)&tensor_dimension62, 14400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant62))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 86400, (TfLiteIntArray*)&tensor_dimension63, 86400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant63))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension64, 86400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant64))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 100800, (TfLiteIntArray*)&tensor_dimension65, 14400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant65))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 86400, (TfLiteIntArray*)&tensor_dimension66, 14400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant66))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension67, 86400, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant67))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 86400, (TfLiteIntArray*)&tensor_dimension68, 28800, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant68))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 3600, (TfLiteIntArray*)&tensor_dimension69, 3600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant69))}, },
  { kTfLiteArenaRw, kTfLiteInt8, tensor_arena + 0, (TfLiteIntArray*)&tensor_dimension70, 3600, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&quant70))}, },
};
#ifndef TF_LITE_STATIC_MEMORY
TfLiteNode tflNodes[27] = {
  { (TfLiteIntArray*)&inputs0, (TfLiteIntArray*)&outputs0, (TfLiteIntArray*)&inputs0, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata0)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs1, (TfLiteIntArray*)&outputs1, (TfLiteIntArray*)&inputs1, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata1)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs2, (TfLiteIntArray*)&outputs2, (TfLiteIntArray*)&inputs2, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata2)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs3, (TfLiteIntArray*)&outputs3, (TfLiteIntArray*)&inputs3, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata3)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs4, (TfLiteIntArray*)&outputs4, (TfLiteIntArray*)&inputs4, nullptr, nullptr, nullptr, nullptr, 0, },
  { (TfLiteIntArray*)&inputs5, (TfLiteIntArray*)&outputs5, (TfLiteIntArray*)&inputs5, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata5)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs6, (TfLiteIntArray*)&outputs6, (TfLiteIntArray*)&inputs6, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata6)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs7, (TfLiteIntArray*)&outputs7, (TfLiteIntArray*)&inputs7, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata7)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs8, (TfLiteIntArray*)&outputs8, (TfLiteIntArray*)&inputs8, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata8)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs9, (TfLiteIntArray*)&outputs9, (TfLiteIntArray*)&inputs9, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata9)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs10, (TfLiteIntArray*)&outputs10, (TfLiteIntArray*)&inputs10, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata10)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs11, (TfLiteIntArray*)&outputs11, (TfLiteIntArray*)&inputs11, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata11)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs12, (TfLiteIntArray*)&outputs12, (TfLiteIntArray*)&inputs12, nullptr, nullptr, nullptr, nullptr, 0, },
  { (TfLiteIntArray*)&inputs13, (TfLiteIntArray*)&outputs13, (TfLiteIntArray*)&inputs13, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata13)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs14, (TfLiteIntArray*)&outputs14, (TfLiteIntArray*)&inputs14, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata14)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs15, (TfLiteIntArray*)&outputs15, (TfLiteIntArray*)&inputs15, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata15)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs16, (TfLiteIntArray*)&outputs16, (TfLiteIntArray*)&inputs16, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata16)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs17, (TfLiteIntArray*)&outputs17, (TfLiteIntArray*)&inputs17, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata17)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs18, (TfLiteIntArray*)&outputs18, (TfLiteIntArray*)&inputs18, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata18)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs19, (TfLiteIntArray*)&outputs19, (TfLiteIntArray*)&inputs19, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata19)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs20, (TfLiteIntArray*)&outputs20, (TfLiteIntArray*)&inputs20, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata20)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs21, (TfLiteIntArray*)&outputs21, (TfLiteIntArray*)&inputs21, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata21)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs22, (TfLiteIntArray*)&outputs22, (TfLiteIntArray*)&inputs22, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata22)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs23, (TfLiteIntArray*)&outputs23, (TfLiteIntArray*)&inputs23, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata23)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs24, (TfLiteIntArray*)&outputs24, (TfLiteIntArray*)&inputs24, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata24)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs25, (TfLiteIntArray*)&outputs25, (TfLiteIntArray*)&inputs25, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata25)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs26, (TfLiteIntArray*)&outputs26, (TfLiteIntArray*)&inputs26, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&opdata26)), nullptr, 0, },
};
#else
TfLiteNode tflNodes[27] = {
  { (TfLiteIntArray*)&inputs0, (TfLiteIntArray*)&outputs0, (TfLiteIntArray*)&inputs0, nullptr, const_cast<void*>(static_cast<const void*>(&opdata0)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs1, (TfLiteIntArray*)&outputs1, (TfLiteIntArray*)&inputs1, nullptr, const_cast<void*>(static_cast<const void*>(&opdata1)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs2, (TfLiteIntArray*)&outputs2, (TfLiteIntArray*)&inputs2, nullptr, const_cast<void*>(static_cast<const void*>(&opdata2)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs3, (TfLiteIntArray*)&outputs3, (TfLiteIntArray*)&inputs3, nullptr, const_cast<void*>(static_cast<const void*>(&opdata3)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs4, (TfLiteIntArray*)&outputs4, (TfLiteIntArray*)&inputs4, nullptr, nullptr, nullptr, 0, },
  { (TfLiteIntArray*)&inputs5, (TfLiteIntArray*)&outputs5, (TfLiteIntArray*)&inputs5, nullptr, const_cast<void*>(static_cast<const void*>(&opdata5)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs6, (TfLiteIntArray*)&outputs6, (TfLiteIntArray*)&inputs6, nullptr, const_cast<void*>(static_cast<const void*>(&opdata6)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs7, (TfLiteIntArray*)&outputs7, (TfLiteIntArray*)&inputs7, nullptr, const_cast<void*>(static_cast<const void*>(&opdata7)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs8, (TfLiteIntArray*)&outputs8, (TfLiteIntArray*)&inputs8, nullptr, const_cast<void*>(static_cast<const void*>(&opdata8)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs9, (TfLiteIntArray*)&outputs9, (TfLiteIntArray*)&inputs9, nullptr, const_cast<void*>(static_cast<const void*>(&opdata9)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs10, (TfLiteIntArray*)&outputs10, (TfLiteIntArray*)&inputs10, nullptr, const_cast<void*>(static_cast<const void*>(&opdata10)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs11, (TfLiteIntArray*)&outputs11, (TfLiteIntArray*)&inputs11, nullptr, const_cast<void*>(static_cast<const void*>(&opdata11)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs12, (TfLiteIntArray*)&outputs12, (TfLiteIntArray*)&inputs12, nullptr, nullptr, nullptr, 0, },
  { (TfLiteIntArray*)&inputs13, (TfLiteIntArray*)&outputs13, (TfLiteIntArray*)&inputs13, nullptr, const_cast<void*>(static_cast<const void*>(&opdata13)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs14, (TfLiteIntArray*)&outputs14, (TfLiteIntArray*)&inputs14, nullptr, const_cast<void*>(static_cast<const void*>(&opdata14)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs15, (TfLiteIntArray*)&outputs15, (TfLiteIntArray*)&inputs15, nullptr, const_cast<void*>(static_cast<const void*>(&opdata15)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs16, (TfLiteIntArray*)&outputs16, (TfLiteIntArray*)&inputs16, nullptr, const_cast<void*>(static_cast<const void*>(&opdata16)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs17, (TfLiteIntArray*)&outputs17, (TfLiteIntArray*)&inputs17, nullptr, const_cast<void*>(static_cast<const void*>(&opdata17)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs18, (TfLiteIntArray*)&outputs18, (TfLiteIntArray*)&inputs18, nullptr, const_cast<void*>(static_cast<const void*>(&opdata18)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs19, (TfLiteIntArray*)&outputs19, (TfLiteIntArray*)&inputs19, nullptr, const_cast<void*>(static_cast<const void*>(&opdata19)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs20, (TfLiteIntArray*)&outputs20, (TfLiteIntArray*)&inputs20, nullptr, const_cast<void*>(static_cast<const void*>(&opdata20)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs21, (TfLiteIntArray*)&outputs21, (TfLiteIntArray*)&inputs21, nullptr, const_cast<void*>(static_cast<const void*>(&opdata21)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs22, (TfLiteIntArray*)&outputs22, (TfLiteIntArray*)&inputs22, nullptr, const_cast<void*>(static_cast<const void*>(&opdata22)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs23, (TfLiteIntArray*)&outputs23, (TfLiteIntArray*)&inputs23, nullptr, const_cast<void*>(static_cast<const void*>(&opdata23)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs24, (TfLiteIntArray*)&outputs24, (TfLiteIntArray*)&inputs24, nullptr, const_cast<void*>(static_cast<const void*>(&opdata24)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs25, (TfLiteIntArray*)&outputs25, (TfLiteIntArray*)&inputs25, nullptr, const_cast<void*>(static_cast<const void*>(&opdata25)), nullptr, 0, },
  { (TfLiteIntArray*)&inputs26, (TfLiteIntArray*)&outputs26, (TfLiteIntArray*)&inputs26, nullptr, const_cast<void*>(static_cast<const void*>(&opdata26)), nullptr, 0, },
};
#endif

used_operators_e used_ops[] =
{OP_CONV_2D, OP_DEPTHWISE_CONV_2D, OP_CONV_2D, OP_CONV_2D, OP_PAD, OP_DEPTHWISE_CONV_2D, OP_CONV_2D, OP_CONV_2D, OP_DEPTHWISE_CONV_2D, OP_CONV_2D, OP_ADD, OP_CONV_2D, OP_PAD, OP_DEPTHWISE_CONV_2D, OP_CONV_2D, OP_CONV_2D, OP_DEPTHWISE_CONV_2D, OP_CONV_2D, OP_ADD, OP_CONV_2D, OP_DEPTHWISE_CONV_2D, OP_CONV_2D, OP_ADD, OP_CONV_2D, OP_CONV_2D, OP_CONV_2D, OP_SOFTMAX, };



static void init_tflite_tensor(size_t i, TfLiteTensor *tensor) {
  tensor->type = tensorData[i].type;
  tensor->is_variable = 0;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  tensor->allocation_type = tensorData[i].allocation_type;
#else
  tensor->allocation_type = (tensor_arena <= tensorData[i].data && tensorData[i].data < tensor_arena + kTensorArenaSize) ? kTfLiteArenaRw : kTfLiteMmapRo;
#endif
  tensor->bytes = tensorData[i].bytes;
  tensor->dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  if(tensor->allocation_type == kTfLiteArenaRw){
    uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

    tensor->data.data =  start;
  }
  else {
      tensor->data.data = tensorData[i].data;
  }
#else
  tensor->data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
  tensor->quantization = tensorData[i].quantization;
  if (tensor->quantization.type == kTfLiteAffineQuantization) {
    TfLiteAffineQuantization const* quant = ((TfLiteAffineQuantization const*)(tensorData[i].quantization.params));
    tensor->params.scale = quant->scale->data[0];
    tensor->params.zero_point = quant->zero_point->data[0];
  }

}

static void init_tflite_eval_tensor(int i, TfLiteEvalTensor *tensor) {

  tensor->type = tensorData[i].type;

  tensor->dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  auto allocation_type = tensorData[i].allocation_type;
  if(allocation_type == kTfLiteArenaRw) {
    uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

    tensor->data.data =  start;
  }
  else {
    tensor->data.data = tensorData[i].data;
  }
#else
  tensor->data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
}

static void* overflow_buffers[EI_MAX_OVERFLOW_BUFFER_COUNT];
static size_t overflow_buffers_ix = 0;
static void * AllocatePersistentBufferImpl(struct TfLiteContext* ctx,
                                       size_t bytes) {
  void *ptr;
  uint32_t align_bytes = (bytes % 16) ? 16 - (bytes % 16) : 0;

  if (current_location - (bytes + align_bytes) < tensor_boundary) {
    if (overflow_buffers_ix > EI_MAX_OVERFLOW_BUFFER_COUNT - 1) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d, does not fit in tensor arena and reached EI_MAX_OVERFLOW_BUFFER_COUNT\n",
        (int)bytes);
      return NULL;
    }

    // OK, this will look super weird, but.... we have CMSIS-NN buffers which
    // we cannot calculate beforehand easily.
    ptr = ei_calloc(bytes, 1);
    if (ptr == NULL) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d\n", (int)bytes);
      return NULL;
    }
    overflow_buffers[overflow_buffers_ix++] = ptr;
    return ptr;
  }

  current_location -= bytes;

  // align to the left aligned boundary of 16 bytes
  current_location -= 15; // for alignment
  current_location += 16 - ((uintptr_t)(current_location) & 15);

  ptr = current_location;
  memset(ptr, 0, bytes);

  return ptr;
}
typedef struct {
  size_t bytes;
  void *ptr;
} scratch_buffer_t;
static scratch_buffer_t scratch_buffers[EI_MAX_SCRATCH_BUFFER_COUNT];
static size_t scratch_buffers_ix = 0;

static TfLiteStatus RequestScratchBufferInArenaImpl(struct TfLiteContext* ctx, size_t bytes,
                                                int* buffer_idx) {
  if (scratch_buffers_ix > EI_MAX_SCRATCH_BUFFER_COUNT - 1) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d, reached EI_MAX_SCRATCH_BUFFER_COUNT\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffer_t b;
  b.bytes = bytes;

  b.ptr = AllocatePersistentBufferImpl(ctx, b.bytes);
  if (!b.ptr) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffers[scratch_buffers_ix] = b;
  *buffer_idx = scratch_buffers_ix;

  scratch_buffers_ix++;

  return kTfLiteOk;
}

static void* GetScratchBufferImpl(struct TfLiteContext* ctx, int buffer_idx) {
  if (buffer_idx > (int)scratch_buffers_ix) {
    return NULL;
  }
  return scratch_buffers[buffer_idx].ptr;
}

static const uint16_t TENSOR_IX_UNUSED = 0x7FFF;

static void ResetTensors() {
  for (size_t ix = 0; ix < MAX_TFL_TENSOR_COUNT; ix++) {
    tflTensors[ix].index = TENSOR_IX_UNUSED;
  }
  for (size_t ix = 0; ix < MAX_TFL_EVAL_COUNT; ix++) {
    tflEvalTensors[ix].index = TENSOR_IX_UNUSED;
  }
}

static TfLiteTensor* GetTensorImpl(const struct TfLiteContext* context,
                               int tensor_idx) {

  for (size_t ix = 0; ix < MAX_TFL_TENSOR_COUNT; ix++) {
    // already used? OK!
    if (tflTensors[ix].index == tensor_idx) {
      return &tflTensors[ix].tensor;
    }
    // passed all the ones we've used, so end of the list?
    if (tflTensors[ix].index == TENSOR_IX_UNUSED) {
      // init the tensor
      init_tflite_tensor(tensor_idx, &tflTensors[ix].tensor);
      tflTensors[ix].index = tensor_idx;
      return &tflTensors[ix].tensor;
    }
  }

  ei_printf("ERR: GetTensor called beyond MAX_TFL_TENSOR_COUNT (%d)\n", MAX_TFL_TENSOR_COUNT);
  return nullptr;
}

static TfLiteEvalTensor* GetEvalTensorImpl(const struct TfLiteContext* context,
                                       int tensor_idx) {

  for (size_t ix = 0; ix < MAX_TFL_EVAL_COUNT; ix++) {
    // already used? OK!
    if (tflEvalTensors[ix].index == tensor_idx) {
      return &tflEvalTensors[ix].tensor;
    }
    // passed all the ones we've used, so end of the list?
    if (tflEvalTensors[ix].index == TENSOR_IX_UNUSED) {
      // init the tensor
      init_tflite_eval_tensor(tensor_idx, &tflEvalTensors[ix].tensor);
      tflEvalTensors[ix].index = tensor_idx;
      return &tflEvalTensors[ix].tensor;
    }
  }

  ei_printf("ERR: GetTensor called beyond MAX_TFL_EVAL_COUNT (%d)\n", (int)MAX_TFL_EVAL_COUNT);
  return nullptr;
}

class EonMicroContext : public MicroContext {
 public:
  EonMicroContext(): MicroContext(nullptr, nullptr, nullptr) { }

  void* AllocatePersistentBuffer(size_t bytes) {
    return AllocatePersistentBufferImpl(nullptr, bytes);
  };
  TfLiteStatus RequestScratchBufferInArena(size_t bytes,
                                           int* buffer_index) {
  return RequestScratchBufferInArenaImpl(nullptr, bytes, buffer_index);
  }
  void* GetScratchBuffer(int buffer_index) {
    return GetScratchBufferImpl(nullptr, buffer_index);
  }

  TfLiteTensor* AllocateTempTfLiteTensor(int tensor_index) {
    return GetTensorImpl(nullptr, tensor_index);
  }
  void DeallocateTempTfLiteTensor(TfLiteTensor* tensor) {
    return;
  }
  bool IsAllTempTfLiteTensorDeallocated() {
    return true;
  }

  TfLiteEvalTensor* GetEvalTensor(int tensor_index) {
    return GetEvalTensorImpl(nullptr, tensor_index);
  }
};

} // namespace

TfLiteStatus tflite_learn_5_init( void*(*alloc_fnc)(size_t,size_t) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  tensor_arena = (uint8_t*) alloc_fnc(16, kTensorArenaSize);
  if (!tensor_arena) {
    ei_printf("ERR: failed to allocate tensor arena\n");
    return kTfLiteError;
  }
#else
  memset(tensor_arena, 0, kTensorArenaSize);
#endif
  tensor_boundary = tensor_arena;
  current_location = tensor_arena + kTensorArenaSize;

  EonMicroContext micro_context_;
  ctx.impl_ = static_cast<void*>(&micro_context_);
  ctx.AllocatePersistentBuffer = &AllocatePersistentBufferImpl;
  ctx.RequestScratchBufferInArena = &RequestScratchBufferInArenaImpl;
  ctx.GetScratchBuffer = &GetScratchBufferImpl;
  ctx.GetTensor = &GetTensorImpl;
  ctx.GetEvalTensor = &GetEvalTensorImpl;
  ctx.ReportError = &MicroContextReportOpError;
  ctx.tensors_size = 71;
  for (size_t i = 0; i < 71; ++i) {
    TfLiteTensor tensor;
    init_tflite_tensor(i, &tensor);
    if (tensor.allocation_type == kTfLiteArenaRw) {
      auto data_end_ptr = (uint8_t*)tensor.data.data + tensorData[i].bytes;
      if (data_end_ptr > tensor_boundary) {
        tensor_boundary = data_end_ptr;
      }
    }
  }
  if (tensor_boundary > current_location /* end of arena size */) {
    ei_printf("ERR: tensor arena is too small, does not fit model - even without scratch buffers\n");
    return kTfLiteError;
  }
  registrations[OP_CONV_2D] = Register_CONV_2D();
  registrations[OP_DEPTHWISE_CONV_2D] = Register_DEPTHWISE_CONV_2D();
  registrations[OP_PAD] = Register_PAD();
  registrations[OP_ADD] = Register_ADD();
  registrations[OP_SOFTMAX] = Register_SOFTMAX();

  for (size_t i = 0; i < 27; ++i) {
if (registrations[used_ops[i]].init) {
       tflNodes[i].user_data = registrations[used_ops[i]].init(&ctx, (const char*)tflNodes[i].builtin_data, 0);
    }
  }
  for (size_t i = 0; i < 27; ++i) {
    if (registrations[used_ops[i]].prepare) {
      ResetTensors();

      TfLiteStatus status = registrations[used_ops[i]].prepare(&ctx, &tflNodes[i]);
      if (status != kTfLiteOk) {
        return status;
      }
    }
  }
  return kTfLiteOk;
}

static const int inTensorIndices[] = {
  0, 
};
TfLiteStatus tflite_learn_5_input(int index, TfLiteTensor *tensor) {
  init_tflite_tensor(inTensorIndices[index], tensor);
  return kTfLiteOk;
}

static const int outTensorIndices[] = {
  70, 
};
TfLiteStatus tflite_learn_5_output(int index, TfLiteTensor *tensor) {
  init_tflite_tensor(outTensorIndices[index], tensor);
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_5_invoke() {
  for (size_t i = 0; i < 27; ++i) {
    ResetTensors();

    TfLiteStatus status = registrations[used_ops[i]].invoke(&ctx, &tflNodes[i]);

#if EI_CLASSIFIER_PRINT_STATE
    ei_printf("layer %lu\n", i);
    ei_printf("    inputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].inputs->size; ix++) {
      auto d = tensorData[tflNodes[i].inputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");

    ei_printf("    outputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].outputs->size; ix++) {
      auto d = tensorData[tflNodes[i].outputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");
#endif // EI_CLASSIFIER_PRINT_STATE

    if (status != kTfLiteOk) {
      return status;
    }
  }
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_5_reset( void (*free_fnc)(void* ptr) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  free_fnc(tensor_arena);
#endif

  // scratch buffers are allocated within the arena, so just reset the counter so memory can be reused
  scratch_buffers_ix = 0;

  // overflow buffers are on the heap, so free them first
  for (size_t ix = 0; ix < overflow_buffers_ix; ix++) {
    ei_free(overflow_buffers[ix]);
  }
  overflow_buffers_ix = 0;
  return kTfLiteOk;
}
